!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   AbstractUserProfileSet, IdentitySet, IdentityBag, UnorderedCollection,
!   Collection, Object.
!
!=========================================================================

removeallmethods AbstractUserProfileSet
removeallclassmethods AbstractUserProfileSet

category: 'For Documentation Installation only'
classmethod: AbstractUserProfileSet
installDocumentation

self comment:
'An AbstractUserProfileSet is an IdentitySet whose elements must be instances of
 class UserProfile.  You may not create subclasses or instances of 
 AbstractUserProfileSet.  Only one instance of AbstractUserProfileSet is
 permitted in a GemStone repository that was upgraded from GemStone v4.1.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: UserProfile'.
%

category: 'Accessing'
method: AbstractUserProfileSet
userWithId: aString 

"Searches the receiver for a UserProfile whose userId is equal to aString, and
 returns that UserProfile.  Generates an error if no userId is equal to
 aString."

^ self userWithId: aString 
         ifAbsent:[ self _error: #objErrNotInColl args: { aString }]
%

! Gs64 v3.0 removed  userWithId:ifAbsent:

category: 'Adding'
method: AbstractUserProfileSet
add: aUserProfile

"(Subclass responsibility.)  Adds aUserProfile to the receiver."

AbstractUserProfileSet subclassResponsibility: #add:
%

category: 'Adding'
method: AbstractUserProfileSet
_add: aUserProfile

AbstractUserProfileSet subclassResponsibility: #_add:
%

category: 'Adding'
method: AbstractUserProfileSet
addAll: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

AbstractUserProfileSet subclassResponsibility: #addAll:
%

! Gs64 v3.0 removed   remove:ifAbsent: 
! Gs64 v3.0 removed   remove:

category: 'Removing'
method: AbstractUserProfileSet
removeIfPresent: anObject

"Reimplemented to maintain KeyValueDictionary on AllUsers."

^ self remove: anObject ifAbsent: [ nil ]
%

category: 'Removing'
method: AbstractUserProfileSet
removeAllPresent: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aCollection == self ifTrue:[ ^ self removeAll: aCollection ].

aCollection accompaniedBy: self do:[ :me :element | me removeIfPresent: element ].
^ aCollection
%

category: 'Removing'
method: AbstractUserProfileSet
removeAll: aCollection

"Reimplemented to maintain KeyValueDictionary on AllUsers."

| aColl tmpArr|
aColl := aCollection.
aColl == self ifTrue:[
  aColl == AllUsers ifTrue:[ 
    self _halt: 'Attempt to remove all elements of AllUsers'  .
    self _uncontinuableError
    ].
  tmpArr := Array withAll: aColl .
  aColl := tmpArr .
  ]. 
aColl accompaniedBy: self do:[ :me :element | me remove: element ].
^ aCollection
%

category: 'Removing'
method: AbstractUserProfileSet
_removeAll: aCollection errIfAbsent: aBool

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aBool ifTrue:[ self removeAll: aCollection]
     ifFalse:[ self removeAllPresent: aCollection ]
%

! new: deleted

! methods removed

