!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: canonstringbucket.gs 47587 2020-01-07 18:05:31Z lalmarod $
!
! Superclass Hierarchy:
!   CanonStringBucket, AbstractCollisionBucket, 
!   Array, SequenceableCollection,
!   Collection, Object.
!
!=========================================================================

expectvalue %String
run
AbstractCollisionBucket _newKernelSubclass: #CanonStringBucket
  instVarNames: #( keyValueDictionary)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
      options: #( disallowGciStore )
  reservedOop: 931 
%

removeallmethods CanonStringBucket
removeallclassmethods CanonStringBucket

category: 'For Documentation Installation only'
classmethod: CanonStringBucket
installDocumentation

self comment:
'A CanonStringBucket is an Array that is used in a 
 CanonSymbolsDictionary .  It contains keys which have the same String
 hash value , and is sorted by value comparision of the keys.
 The comparision is done using binary comparison of the bytes of the keys.
 The hash value must be computed by using CanonStringDict >> hashFunction:
'

%


!---------------------------------------
category: 'Accessing'
! at: 		inherited from AbstractCollisionBucket
! at:ifAbsent:  inherited
! at:otherwise: inherited

! fix 31083
method: CanonStringBucket
keyAt: index

"Returns the key at the specified index."

^ self _at: index 
%

! keyAt:otherwise:  	inherited

method: CanonStringBucket
keyValueDictionary

"Returns the value of the instance variable."

^keyValueDictionary
%

! numElements  		inherited
! size 			inherited

method: CanonStringBucket
tableSize

"Returns the number of keys in the capacity of the receiver."

^self _basicSize
%

method: CanonStringBucket
valueAt: index

"not supported, instances hold only keys"

self shouldNotImplement: #valueAt: 
%

! _reportKeyNotFound:with:	inherited

!---------------------------------------
category: 'Adding'
method: CanonStringBucket
add: anAssociation

"Disallowed, CanonStringBucket does not contain associations"

self shouldNotImplement: #add:
%

!---------------------------------------
! category: 'Deprecated'
!  doKeys:  		inherited
!  doValues:   		inherited
! category: 'Error Handling'
!   _errorKeyNotFound:	inherited
! category: 'Formatting'
!   printOn:		inherited
! category: 'Initializing'
!  initialize		inherited

!---------------------------------------
category: 'Private'
!  compareKey:with:	inherited

method: CanonStringBucket
_removeAll

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a dictionary."

keyValueDictionary := nil.
numElements := 0.
"gs64 v3.0 don't send  size: 0"
%

! ---------------------------------------
! category: 'Removing'

method: CanonStringBucket
removeKey: aKey ifAbsent: aBlock

"Removes the specified key and returns aKey . If aKey is not found,
 returns the result of evaluating the zero-argument block aBlock."

 | keyIndex |
 keyIndex := self searchForKey: aKey.
 keyIndex == nil
 ifFalse: [
    numElements := numElements - 1.
    self _deleteNoShrinkFrom: keyIndex to: keyIndex .
    ^ aKey 
    ]
 ifTrue: [ ^ self _reportKeyNotFound: aKey with: aBlock ]
%


!---------------------------------------
category: 'Searching'
!   firstPair		inherited
!  includesKey:		inherited

method: CanonStringBucket
searchForKey: aKey

"Returns the index of aKey, or if not found, nil."

<primitive: 471>
aKey _validateClass: String  .
self _primitiveFailed: #searchForKey: args: { aKey }.
self _uncontinuableError
%

!---------------------------------------
category: 'Updating'
!  at:put: 		inherited
!  at:put:keyValDict: deleted

method: CanonStringBucket
at: aKey put: aValue keyValDict_coll: aKeyValDict

"key-value pairs are not supported"

^ self shouldNotImplement: #at:put:keyValDict_coll:
%

method: CanonStringBucket
addKey: aKey

"All additions should be done via methods in the parent dictionary."

^ self shouldNotImplement: #addKey:
%

method: CanonStringBucket
at: anIndex putKey: aKey

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putKey: .
%

method: CanonStringBucket
at: anIndex putValue: aValue

"Disallowed, must use addKey:  or removeKey:"

self shouldNotImplement: #at:putValue: .
%

method: CanonStringBucket
keyValueDictionary: aDict

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict
%

! additions to fix 31544 , keysDo: valuesDo: keysAndValuesDo:
category: 'Enumerating'
method: CanonStringBucket
keysDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the key as the argument.  Returns the receiver."

1 to: numElements do:[:idx | aBlock value: ( self _at: idx )  ] .
%

category: 'Enumerating'
method: CanonStringBucket
valuesDo: aBlock

"For each key/value pair in the receiver, evaluates the one-argument block
 aBlock with the value as the argument.  Returns the receiver."

 self keysDo: aBlock
%

category: 'Enumerating'
method: CanonStringBucket
keysAndValuesDo: aBlock

"For each key/value pair in the receiver, evaluates the two-argument block
 aBlock with the arguments key, value.  Returns the receiver."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: aSym value: aSym 
].
%
! added for 36675, renamed for 39898
category: 'Enumerating'
method: CanonStringBucket
accompaniedBy: anObj keysAndValuesDo: aBlock

"Evaluates aBlock with each of the receiver's key/value pairs as the
 2nd and 3rd arguments.  
 aBlock must be a 3 argument block, with arguments anObj, key value ."

1 to: numElements do:[:idx | | aSym |
   aSym := self _at: idx  .
   aBlock value: anObj value: aSym value: aSym
].
%

category: 'Private'
method: CanonStringBucket
objectSecurityPolicy: anObjectSecurityPolicy
"Assigns the receiver and all its components to the given security policy.
 Returns the receiver."

self validateSystemUser .
^ super objectSecurityPolicy: anObjectSecurityPolicy
%

category: 'Private'
method: CanonStringBucket
_audit
| bsz extra nSize |
extra := (bsz := self basicSize) - (nSize := self class instSize) - numElements .
extra < 0 ifTrue:[ Error signal:'bad size'].
0 to: extra - 1 do:[:n |
  (self basicAt:(bsz - n - nSize)) ifNotNil:[ Error signal:'bad element'].
].
%

!---------------------------------------
! class methods
category: 'Instance Creation'
!  new		inherited
!  new:		inherited

