!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ClassSet, IdentitySet, IdentityBag, UnorderedCollection, Collection,
!   Object.
!
!=========================================================================

! Create the class ClassSet, if it does not already exist

expectvalue %String
run
  IdentitySet _newKernelSubclass: 'ClassSet'
    instVarNames: #()
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
    options: #()
    reservedOop: 733 
%

removeallmethods ClassSet
removeallclassmethods ClassSet

category: 'For Documentation Installation only'
classmethod: ClassSet
installDocumentation

self comment:
'A ClassSet is an IdentitySet that holds only Class objects.

Constraints:
	_varyingSize: Object
	_numEntries: Object
	_indexedPaths: Object
	_levels: Object
	[elements]: Class' .
%

! ------------------- Instance methods for ClassSet
category: 'Sorting'
method: ClassSet
sortAscending

"Returns an Array with the same (Class) elements as the receiver,
 in ascending order by class name."

^ self _sortPaths: #(#name) directions: #(true).
%

