!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   ComplexBlock, ExecutableBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods ComplexBlock
removeallclassmethods ComplexBlock

category: 'For Documentation Installation only'
classmethod: ComplexBlock
installDocumentation

self comment:

'ComplexBlock is obsolete in Gemstone64 v3.0 and above. 
 A ComplexBlock references a variable context to access variables in enclosing
 scopes.' 
%

category: 'Accessing'
method: ComplexBlock
staticLink

"Returns the value of the instance variable staticLink."

^ staticLink
%

category: 'Accessing'
method: ComplexBlock
selfValue

"Returns the value of the instance variable selfValue."

^ selfValue
%

category: 'Accessing'
method: ComplexBlock
_sourceString

"Returns a String that will create a block similar to the receiver when
 the string is compiled.  References to variables in other contexts or
 to the pseudovariable 'self' will not recompile properly if the source
 string is used to create a new block similar to the receiver."

| result tempsArr lnk atemps |
result := String new.
result addAll: '"This is source for a ComplexBlock.  If there are
references to ''self'', or if non-block temporaries are used that
are not initialized in the block, it may not recreate a useful
block"
 | '.
"fold the arguments and temporaries of surrounding scopes together - the scopes
 won't be there if the source is used to create a new block, so duplicates
 must be eliminated"
tempsArr := { } .
atemps := method argsAndTemps .
atemps ~~ nil ifTrue: [
  tempsArr addAll: atemps
  ].
lnk := staticLink.
[ lnk ~~ nil ] whileTrue: [
  lnk := lnk at: 1.
  (lnk isKindOf: ComplexVCBlock) ifTrue: [
    atemps := lnk argsAndTemps .
    atemps ~~ nil ifTrue: [
      atemps do: [:a | (tempsArr includesValue: a) ifFalse: [ tempsArr add: a ] ].
      ].
    lnk := lnk staticLink.
    ]
  ifFalse: [
    lnk := nil
    ].
  ].
tempsArr do: [:e |
  result addAll: e; add: $ .
  ].
result addAll: '|
^' .

result addAll:( method _sourceString copyFrom: firstSourceOffset to: lastSourceOffset) .
^result
%

! _sourceStringForConversion deleted
! _fixConversionResult:selectBlock: deleted

category: 'Block Evaluation'
method: ComplexBlock
value

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: anObject

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: firstObject value: secondObject

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: firstObject value: secondObject value: thirdObject

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: first value: second value: third value: fourth

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
value: first value: second value: third value: fourth value: fifth

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: ComplexBlock
valueWithArguments: argList

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

! deleted convertTo5With: symbolList oldNamesDict: oldNamesDict

category: 'Disassembly'
classmethod: ComplexBlock
_cost

^ 2

%

