!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   CriticalSection, Object
!
!=========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: #CriticalSection
  instVarNames: #(#owner #semaphore)
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: 917
%

! Remove existing behavior from CriticalSection
removeallmethods CriticalSection
removeallclassmethods CriticalSection

! ------------------- Class methods for CriticalSection
category: 'Documentation'
classmethod: CriticalSection
comment
^'CriticalSection is a class from the Blue Book API that
provides one way of using semaphores.

Constraints:
	owner: GsProcess
	semaphore: Semaphore'
%

category: 'Instance Creation'
classmethod: CriticalSection
new
  "Answer a new CriticalSection"
  ^self basicNew _initialize
%

category: 'Private'
method: CriticalSection
_scheduler

"Returns   ProcessorScheduler scheduler "
<primitive: 457>

self _primitiveFailed: #_scheduler
%


! ------------------- Instance methods for CriticalSection
category: 'Blue Book Protocol'
method: CriticalSection
critical: aBlock
  "Wait until no other processes are sending critical to the receiver
   and then execute aBlock and return its value."

  | value activeProcess |
  activeProcess := self _scheduler activeProcess"a primitive".
  (owner == activeProcess) ifFalse: [
    semaphore wait.
    owner := activeProcess.
    value := aBlock ensure: [
      owner := nil.
      semaphore signal.
    ].
  ] ifTrue: [
    value := aBlock value.
  ].
  ^value
%

category: 'Private'
method: CriticalSection
_initialize

  owner := nil.
  semaphore := Semaphore forMutualExclusion.
%
