!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   KeySoftValueDictionary, KeyValueDictionary, AbstractDictionary, Collection, Object.
!
!=========================================================================

expectvalue %String
run
| res oldCls clsName |
clsName := #IdentityKeySoftValueDictionary .
oldCls := Globals at:clsName otherwise: nil .
oldCls == nil ifTrue:[
  res := KeySoftValueDictionary _newKernelSubclass: clsName"IdentityKeySoftValueDictionary"
    instVarNames: #( )
    classVars: #()
    classInstVars: #()
    poolDictionaries: { }
    inDictionary: Globals
    options: #( instancesNonPersistent  disallowGciStore )
    reservedOop: 943 .
] ifFalse: [
  res := clsName asString , 'already exists'.
  oldCls instancesNonPersistent ifFalse:[ nil error:'should be NP' ].
].
^ res
%

removeallmethods IdentityKeySoftValueDictionary
removeallclassmethods 
set class IdentityKeySoftValueDictionary

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'IdentityKeySoftValueDictionary is a subclass of KeySoftValueDictionary
 which uses identity comparision on keys.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger' .
%

category: 'Hashing'
method:
hashFunction: aKey

"The hash function should perform some operation on the value of the key aKey
 which returns a value in the range 1..tableSize."

^(aKey identityHash \\ tableSize) + 1
%

set compile_env: 0
category: 'Hashing'
method: IdentityKeySoftValueDictionary
rehash
	"Re-establish any hash invariants of the receiver.
	 Identity hashes cannot change."
%

category: 'Private'
method:
collisionBucketClass

"Returns the class of object to create when keys collide."

^ IdentitySoftCollisionBucket
%

category: 'Private'
method:
compareKey: key1 with: key2

"Returns true if key1 is identical to key2; returns false otherwise."

^ key1 == key2
%
category: 'Private'
method:
_initializeWithoutClear: newSize

"Private. Initializes the instance variables of the receiver to be an empty
 KeyValueDictionary of the specified size. Does not clear the contents
 of the receiver - assumes they are all nil."

tableSize := newSize.
numElements := 0.
numCollisions := 0.
collisionLimit := newSize * 500 . "differs from KeySoftValueDictionary"
^self
%

category: 'Hashing'
method:
rebuildTable: newSize

| oldTs newTs |
oldTs := tableSize .
super rebuildTable: newSize .
(newTs := tableSize) > oldTs ifTrue:[
  self collisionLimit: newTs * 500 . "differs from KeySoftValueDictionary"
].
%
category: 'Updating
method:
collisionLimit: aLimit
| limit tlim |
(limit := aLimit ) _isSmallInteger ifFalse:[  "gemstone64 explicit constraint check"
  ^ limit _error: #rtErrBadArgKind args: { SmallInteger }
].
(limit ~~ 536870911 and:[ limit > (tlim := tableSize * 500)]) ifTrue:[
  limit := tlim "prevent infinite recursion on bucket overflows, fix  "
] .
^ super collisionLimit: limit
%

category: 'Comparing'
method:
hash

"Returns a numeric hash key for the receiver."

| hashValue |

hashValue := 97633 bitXor: (self size).
"For large dictionaries, the hash value is just a function of its size"
(self size > 64) ifTrue: [ ^ hashValue abs ].
self keysDo: [ :aKey |
   "Skip if the key is a dictionary."
   (aKey isKindOf: AbstractDictionary)
     ifFalse: [
       hashValue := hashValue bitXor: aKey identityHash
       ]
     ].
^ hashValue abs
%

! fix 32863, keysAndValuesDo: is inherited 
