expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UndefinedSymbolNotification otherwise: nil.
oldCls == nil ifTrue: [
	Notification subclass: 'UndefinedSymbolNotification'
	instVarNames: #()
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'UndefinedSymbolNotification'.
	newCls category: 'Monticello-Notifications'.
        newCls classComment: 'Notification signalled when compiler encounters Undefined Symbols.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods UndefinedSymbolNotification
removeallclassmethods UndefinedSymbolNotification

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UUID otherwise: nil.
oldCls == nil ifTrue: [
	ByteArray byteSubclass: 'UUID'
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'UUID'.
	newCls category: 'Network-UUID'.newCls classComment: 'A class to generate UUID
by John M McIntosh johnmci@smalltalkconsulting.com

See http://www.webdav.org/specs/draft-leach-uuids-guids-01.txt

If a plugin does not exist then we generate a UUID version 4 type GUUID' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods UUID
removeallclassmethods UUID

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCChangeSelectionRequest otherwise: nil.
oldCls == nil ifTrue: [
	Notification subclass: 'MCChangeSelectionRequest'
	instVarNames: #( patch label )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCChangeSelectionRequest'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCChangeSelectionRequest
removeallclassmethods MCChangeSelectionRequest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMergeResolutionRequest otherwise: nil.
oldCls == nil ifTrue: [
	Notification subclass: 'MCMergeResolutionRequest'
	instVarNames: #( merger )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMergeResolutionRequest'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMergeResolutionRequest
removeallclassmethods MCMergeResolutionRequest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionNameAndMessageRequest otherwise: nil.
oldCls == nil ifTrue: [
	Notification subclass: 'MCVersionNameAndMessageRequest'
	instVarNames: #( suggestion suggestedLogComment )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionNameAndMessageRequest'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionNameAndMessageRequest
removeallclassmethods MCVersionNameAndMessageRequest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCNoChangesException otherwise: nil.
oldCls == nil ifTrue: [
	Exception subclass: 'MCNoChangesException'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCNoChangesException'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCNoChangesException
removeallclassmethods MCNoChangesException

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSnapshotResource otherwise: nil.
oldCls == nil ifTrue: [
	TestResource subclass: 'MCSnapshotResource'
	instVarNames: #( snapshot )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSnapshotResource'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSnapshotResource
removeallclassmethods MCSnapshotResource

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDependencySorterTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'MCDependencySorterTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDependencySorterTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDependencySorterTest
removeallclassmethods MCDependencySorterTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCGemStoneTests otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'MCGemStoneTests'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCGemStoneTests'.
	newCls category: 'GemStone-Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCGemStoneTests
removeallclassmethods MCGemStoneTests

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSortingTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'MCSortingTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSortingTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSortingTest
removeallclassmethods MCSortingTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCTestCase otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'MCTestCase'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCTestCase'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCTestCase
removeallclassmethods MCTestCase

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCAncestryTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCAncestryTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCAncestryTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCAncestryTest
removeallclassmethods MCAncestryTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCClassDefinitionTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCClassDefinitionTest'
	instVarNames: #( previousChangeSet )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCClassDefinitionTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCClassDefinitionTest
removeallclassmethods MCClassDefinitionTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMergingTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCMergingTest'
	instVarNames: #( conflictBlock conflicts )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMergingTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMergingTest
removeallclassmethods MCMergingTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMethodDefinitionTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCMethodDefinitionTest'
	instVarNames: #( navigation isModified )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMethodDefinitionTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMethodDefinitionTest
removeallclassmethods MCMethodDefinitionTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCOrganizationTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCOrganizationTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCOrganizationTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCOrganizationTest
removeallclassmethods MCOrganizationTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPackageTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCPackageTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPackageTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPackageTest
removeallclassmethods MCPackageTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPatchTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCPatchTest'
	instVarNames: #( patch )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPatchTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPatchTest
removeallclassmethods MCPatchTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRepositoryTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCRepositoryTest'
	instVarNames: #( repository ancestors )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRepositoryTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRepositoryTest
removeallclassmethods MCRepositoryTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDictionaryRepositoryTest otherwise: nil.
oldCls == nil ifTrue: [
	MCRepositoryTest subclass: 'MCDictionaryRepositoryTest'
	instVarNames: #( dict )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDictionaryRepositoryTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDictionaryRepositoryTest
removeallclassmethods MCDictionaryRepositoryTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFilesystemRepositoryTest otherwise: nil.
oldCls == nil ifTrue: [
	MCRepositoryTest subclass: 'MCFilesystemRepositoryTest'
	instVarNames: #( directory )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFilesystemRepositoryTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFilesystemRepositoryTest
removeallclassmethods MCFilesystemRepositoryTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCScannerTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCScannerTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCScannerTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCScannerTest
removeallclassmethods MCScannerTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSerializationTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCSerializationTest'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSerializationTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSerializationTest
removeallclassmethods MCSerializationTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSnapshotTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCSnapshotTest'
	instVarNames: #( snapshot )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSnapshotTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSnapshotTest
removeallclassmethods MCSnapshotTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCStWriterTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCStWriterTest'
	instVarNames: #( stream writer )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCStWriterTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCStWriterTest
removeallclassmethods MCStWriterTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCVersionTest'
	instVarNames: #( version visited )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionTest
removeallclassmethods MCVersionTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCWorkingCopyTest otherwise: nil.
oldCls == nil ifTrue: [
	MCTestCase subclass: 'MCWorkingCopyTest'
	instVarNames: #( workingCopy repositoryGroup versions versions2 savedName )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCWorkingCopyTest'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCWorkingCopyTest
removeallclassmethods MCWorkingCopyTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #TimeStampTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'TimeStampTest'
	instVarNames: #( timestamp aTimeStamp )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'TimeStampTest'.
	newCls category: 'KernelTests-Monticello-Chronology'.newCls classComment: 'This is the unit test for the class TimeStamp.' stamp: 'brp 7/26/2003 22:44'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods TimeStampTest
removeallclassmethods TimeStampTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UUIDPrimitivesTest otherwise: nil.
oldCls == nil ifTrue: [
	TestCase subclass: 'UUIDPrimitivesTest'
	instVarNames: #(  )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'UUIDPrimitivesTest'.
	newCls category: 'NetworkTests-UUID'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods UUIDPrimitivesTest
removeallclassmethods UUIDPrimitivesTest

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCAncestry otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCAncestry'
	instVarNames: #( ancestors stepChildren )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCAncestry'.
	newCls category: 'Monticello-Versioning'.newCls classComment: 'Abstract superclass of records of ancestry.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCAncestry
removeallclassmethods MCAncestry

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionInfo otherwise: nil.
oldCls == nil ifTrue: [
	MCAncestry subclass: 'MCVersionInfo'
	instVarNames: #( id name message date time author )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionInfo'.
	newCls category: 'Monticello-Versioning'.newCls classComment: 'Adds to the record of ancestry, other identifying details.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionInfo
removeallclassmethods MCVersionInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCWorkingAncestry otherwise: nil.
oldCls == nil ifTrue: [
	MCAncestry subclass: 'MCWorkingAncestry'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCWorkingAncestry'.
	newCls category: 'Monticello-Versioning'.newCls classComment: 'The interim record of ancestry for a working copy, gets merged version added to the ancestry, and is used to create the VersionInfo when the working copy becomes a version. ' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCWorkingAncestry
removeallclassmethods MCWorkingAncestry

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCConflict otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCConflict'
	instVarNames: #( operation chooseRemote )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCConflict'.
	newCls category: 'Monticello-Merging'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCConflict
removeallclassmethods MCConflict

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDefinition otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCDefinition'
	instVarNames: #(  )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDefinition'.
	newCls category: 'Monticello-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDefinition
removeallclassmethods MCDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCClassDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCDefinition subclass: 'MCClassDefinition'
	instVarNames: #( name superclassName variables category type comment commentStamp traitComposition classTraitComposition )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCClassDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCClassDefinition
removeallclassmethods MCClassDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMethodDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCDefinition subclass: 'MCMethodDefinition'
	instVarNames: #( classIsMeta source category selector className timeStamp )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMethodDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMethodDefinition
removeallclassmethods MCMethodDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCDefinition subclass: 'MCMockDefinition'
	instVarNames: #( token )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockDefinition'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockDefinition
removeallclassmethods MCMockDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCOrganizationDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCDefinition subclass: 'MCOrganizationDefinition'
	instVarNames: #( categories )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCOrganizationDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCOrganizationDefinition
removeallclassmethods MCOrganizationDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCScriptDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCDefinition subclass: 'MCScriptDefinition'
	instVarNames: #( script packageName )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCScriptDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCScriptDefinition
removeallclassmethods MCScriptDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPostscriptDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCScriptDefinition subclass: 'MCPostscriptDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPostscriptDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPostscriptDefinition
removeallclassmethods MCPostscriptDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPreambleDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCScriptDefinition subclass: 'MCPreambleDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPreambleDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPreambleDefinition
removeallclassmethods MCPreambleDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRemovalPostscriptDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCScriptDefinition subclass: 'MCRemovalPostscriptDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRemovalPostscriptDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRemovalPostscriptDefinition
removeallclassmethods MCRemovalPostscriptDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRemovalPreambleDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCScriptDefinition subclass: 'MCRemovalPreambleDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRemovalPreambleDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRemovalPreambleDefinition
removeallclassmethods MCRemovalPreambleDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDefinitionIndex otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCDefinitionIndex'
	instVarNames: #( definitions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDefinitionIndex'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDefinitionIndex
removeallclassmethods MCDefinitionIndex

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDependencySorter otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCDependencySorter'
	instVarNames: #( required provided orderedItems )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDependencySorter'.
	newCls category: 'Monticello-Loading'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDependencySorter
removeallclassmethods MCDependencySorter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFrontier otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCFrontier'
	instVarNames: #( frontier bag )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFrontier'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFrontier
removeallclassmethods MCFrontier

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMergeRecord otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMergeRecord'
	instVarNames: #( version packageSnapshot ancestorInfo ancestor ancestorSnapshot imagePatch mergePatch )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMergeRecord'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMergeRecord
removeallclassmethods MCMergeRecord

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMerger otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMerger'
	instVarNames: #( conflicts )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMerger'.
	newCls category: 'Monticello-Merging'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMerger
removeallclassmethods MCMerger

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCThreeWayMerger otherwise: nil.
oldCls == nil ifTrue: [
	MCMerger subclass: 'MCThreeWayMerger'
	instVarNames: #( index operations provisions redundantAdds )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCThreeWayMerger'.
	newCls category: 'Monticello-Merging'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCThreeWayMerger
removeallclassmethods MCThreeWayMerger

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMock otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMock'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMock'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMock
removeallclassmethods MCMock

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassA otherwise: nil.
oldCls == nil ifTrue: [
	MCMock subclass: 'MCMockClassA'
	instVarNames: #( ivar )
	classVars: #( CVar )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockClassA'.
	newCls category: 'Monticello-Mocks'.newCls classComment: 'This is a mock class. The Monticello tests manipulated it to simulate a developer modifying code in the image.' stamp: 'cwp 8/10/2003 16:43'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassA
removeallclassmethods MCMockClassA

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockASubclass otherwise: nil.
oldCls == nil ifTrue: [
	MCMockClassA subclass: 'MCMockASubclass'
	instVarNames: #( x )
	classVars: #( Y )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockASubclass'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockASubclass
removeallclassmethods MCMockASubclass

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockDependentItem otherwise: nil.
oldCls == nil ifTrue: [
	MCMock subclass: 'MCMockDependentItem'
	instVarNames: #( name provides requires )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockDependentItem'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockDependentItem
removeallclassmethods MCMockDependentItem

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassD otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMockClassD'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockClassD'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassD
removeallclassmethods MCMockClassD

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassE otherwise: nil.
oldCls == nil ifTrue: [
	Object indexableSubclass: 'MCMockClassE'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockClassE'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassE
removeallclassmethods MCMockClassE

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassF otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMockClassF'
	instVarNames: #(  )
	classVars: #( Foo )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockClassF'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassF
removeallclassmethods MCMockClassF

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassH otherwise: nil.
oldCls == nil ifTrue: [
	Object byteSubclass: 'MCMockClassH'
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
        newCls := Gs_Package_Globals at: #'MCMockClassH'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassH
removeallclassmethods MCMockClassH

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockDependency otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCMockDependency'
	instVarNames: #( name children hasResolution )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockDependency'.
	newCls category: 'Tests-Monticello'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockDependency
removeallclassmethods MCMockDependency

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPackage otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPackage'
	instVarNames: #( name )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPackage'.
	newCls category: 'Monticello-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPackage
removeallclassmethods MCPackage

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPackageCache otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPackageCache'
	instVarNames: #( sorter fileNames )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPackageCache'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPackageCache
removeallclassmethods MCPackageCache

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPackageLoader otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPackageLoader'
	instVarNames: #( requirements unloadableDefinitions obsoletions additions removals errorDefinitions provisions methodAdditions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPackageLoader'.
	newCls category: 'Monticello-Loading'.newCls classComment: 'A MCPackageLoader is responsible for loading packages.  It gets used by VersionLoader, so it is eventually responsible for loading everything.

Instance Variables
	additions:		<Definitions>  Definitions that need to be added
	errorDefinitions:		<Object>
	obsoletions:		<Object>
	provisions:		<Object>
	removals:		<Object>
	requirements:		<Object>
	unloadableDefinitions:		<Object>
	methodAdditions  <MethodAdditions> MethodDefinitions corresponding to the Definitions in "additions" that have been added so far.

additions
	- xxxxx

errorDefinitions
	- xxxxx

obsoletions
	- xxxxx

provisions
	- xxxxx

removals
	- xxxxx

requirements
	- xxxxx

unloadableDefinitions
	- xxxxx
' stamp: 'rej 2/26/2007 07:35'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPackageLoader
removeallclassmethods MCPackageLoader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMultiPackageLoader otherwise: nil.
oldCls == nil ifTrue: [
	MCPackageLoader subclass: 'MCMultiPackageLoader'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMultiPackageLoader'.
	newCls category: 'Monticello-Loading'.newCls classComment: 'A PackageLoader doing some additional cross-package checks' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMultiPackageLoader
removeallclassmethods MCMultiPackageLoader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPackageManager otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPackageManager'
	instVarNames: #( package modified )
	classVars: #(  )
	classInstVars: #( )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPackageManager'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPackageManager
removeallclassmethods MCPackageManager

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCWorkingCopy otherwise: nil.
oldCls == nil ifTrue: [
	MCPackageManager subclass: 'MCWorkingCopy'
	instVarNames: #( versionInfo ancestry counter repositoryGroup requiredPackages )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCWorkingCopy'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCWorkingCopy
removeallclassmethods MCWorkingCopy

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPatch otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPatch'
	instVarNames: #( operations )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPatch'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPatch
removeallclassmethods MCPatch

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPatchOperation otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPatchOperation'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPatchOperation'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPatchOperation
removeallclassmethods MCPatchOperation

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCAddition otherwise: nil.
oldCls == nil ifTrue: [
	MCPatchOperation subclass: 'MCAddition'
	instVarNames: #( definition )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCAddition'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCAddition
removeallclassmethods MCAddition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCModification otherwise: nil.
oldCls == nil ifTrue: [
	MCPatchOperation subclass: 'MCModification'
	instVarNames: #( obsoletion modification )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCModification'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCModification
removeallclassmethods MCModification

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRemoval otherwise: nil.
oldCls == nil ifTrue: [
	MCPatchOperation subclass: 'MCRemoval'
	instVarNames: #( definition )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRemoval'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRemoval
removeallclassmethods MCRemoval

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPatcher otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPatcher'
	instVarNames: #( definitions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPatcher'.
	newCls category: 'Monticello-Patching'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPatcher
removeallclassmethods MCPatcher

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPlatform otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCPlatform'
	instVarNames: #(  )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPlatform'.
	newCls category: 'Monticello-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPlatform
removeallclassmethods MCPlatform

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCGemStonePlatform otherwise: nil.
oldCls == nil ifTrue: [
	MCPlatform subclass: 'MCGemStonePlatform'
	instVarNames: #( savedFullName packageManagerRegistry)
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCGemStonePlatform'.
	newCls category: 'Monticello-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCGemStonePlatform
removeallclassmethods MCGemStonePlatform

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCReader otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCReader'
	instVarNames: #( stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCReader'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCReader
removeallclassmethods MCReader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSnapshotReader otherwise: nil.
oldCls == nil ifTrue: [
	MCReader subclass: 'MCSnapshotReader'
	instVarNames: #( definitions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSnapshotReader'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSnapshotReader
removeallclassmethods MCSnapshotReader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionReader otherwise: nil.
oldCls == nil ifTrue: [
	MCReader subclass: 'MCVersionReader'
	instVarNames: #( package info definitions dependencies stepChildren )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionReader'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionReader
removeallclassmethods MCVersionReader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMczReader otherwise: nil.
oldCls == nil ifTrue: [
	MCVersionReader subclass: 'MCMczReader'
	instVarNames: #( zip infoCache )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMczReader'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMczReader
removeallclassmethods MCMczReader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMcdReader otherwise: nil.
oldCls == nil ifTrue: [
	MCMczReader subclass: 'MCMcdReader'
	instVarNames: #( baseInfo patch )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMcdReader'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMcdReader
removeallclassmethods MCMcdReader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRepository otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCRepository'
	instVarNames: #( creationTemplate storeDiffs )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRepository'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRepository
removeallclassmethods MCRepository

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDictionaryRepository otherwise: nil.
oldCls == nil ifTrue: [
	MCRepository subclass: 'MCDictionaryRepository'
	instVarNames: #( description dict )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDictionaryRepository'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDictionaryRepository
removeallclassmethods MCDictionaryRepository

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFileBasedRepository otherwise: nil.
oldCls == nil ifTrue: [
	MCRepository subclass: 'MCFileBasedRepository'
	instVarNames: #( cache allFileNames )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFileBasedRepository'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFileBasedRepository
removeallclassmethods MCFileBasedRepository

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFilesystemRepository otherwise: nil.
oldCls == nil ifTrue: [
	MCFileBasedRepository subclass: 'MCFilesystemRepository'
	instVarNames: #( directory )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFilesystemRepository'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFilesystemRepository
removeallclassmethods MCFilesystemRepository

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFilesystemCacheRepository otherwise: nil.
oldCls == nil ifTrue: [
	MCFilesystemRepository subclass: 'MCFilesystemCacheRepository'
	instVarNames: #( packageCaches seenFiles )
	classVars: #(  )
	classInstVars: #( )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFilesystemCacheRepository'.
	newCls category: 'Monticello-Repositories'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFilesystemCacheRepository
removeallclassmethods MCFilesystemCacheRepository

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCRepositoryGroup otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCRepositoryGroup'
	instVarNames: #( repositories useCache )
	classVars: #(  )
	classInstVars: #( )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCRepositoryGroup'.
	newCls category: 'Monticello-Versioning'.newCls classComment: 'A singleton class, holds the list of repositories. Can look for a requested VersionInfo among its repositories.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCRepositoryGroup
removeallclassmethods MCRepositoryGroup

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCScanner otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCScanner'
	instVarNames: #( stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCScanner'.
	newCls category: 'Monticello-Chunk Format'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCScanner
removeallclassmethods MCScanner

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCSnapshot otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCSnapshot'
	instVarNames: #( definitions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCSnapshot'.
	newCls category: 'Monticello-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCSnapshot
removeallclassmethods MCSnapshot

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVariableDefinition otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVariableDefinition'
	instVarNames: #( name )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVariableDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVariableDefinition
removeallclassmethods MCVariableDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCClassInstanceVariableDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCVariableDefinition subclass: 'MCClassInstanceVariableDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCClassInstanceVariableDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCClassInstanceVariableDefinition
removeallclassmethods MCClassInstanceVariableDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCClassVariableDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCVariableDefinition subclass: 'MCClassVariableDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCClassVariableDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCClassVariableDefinition
removeallclassmethods MCClassVariableDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCInstanceVariableDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCVariableDefinition subclass: 'MCInstanceVariableDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCInstanceVariableDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCInstanceVariableDefinition
removeallclassmethods MCInstanceVariableDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCPoolImportDefinition otherwise: nil.
oldCls == nil ifTrue: [
	MCVariableDefinition subclass: 'MCPoolImportDefinition'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCPoolImportDefinition'.
	newCls category: 'Monticello-Modeling'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCPoolImportDefinition
removeallclassmethods MCPoolImportDefinition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersion otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVersion'
	instVarNames: #( package info snapshot dependencies )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersion'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersion
removeallclassmethods MCVersion

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDiffyVersion otherwise: nil.
oldCls == nil ifTrue: [
	MCVersion subclass: 'MCDiffyVersion'
	instVarNames: #( base patch )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDiffyVersion'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDiffyVersion
removeallclassmethods MCDiffyVersion

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionDependency otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVersionDependency'
	instVarNames: #( package versionInfo )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionDependency'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionDependency
removeallclassmethods MCVersionDependency

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionLoader otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVersionLoader'
	instVarNames: #( versions )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionLoader'.
	newCls category: 'Monticello-Loading'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionLoader
removeallclassmethods MCVersionLoader

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionMerger otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVersionMerger'
	instVarNames: #( records merger )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionMerger'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionMerger
removeallclassmethods MCVersionMerger

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionSorter otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCVersionSorter'
	instVarNames: #( layers depthIndex depths stepparents roots )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionSorter'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionSorter
removeallclassmethods MCVersionSorter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCFilteredVersionSorter otherwise: nil.
oldCls == nil ifTrue: [
	MCVersionSorter subclass: 'MCFilteredVersionSorter'
	instVarNames: #( target )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCFilteredVersionSorter'.
	newCls category: 'Monticello-Versioning'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCFilteredVersionSorter
removeallclassmethods MCFilteredVersionSorter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCWriter otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MCWriter'
	instVarNames: #( stream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCWriter'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCWriter
removeallclassmethods MCWriter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMczWriter otherwise: nil.
oldCls == nil ifTrue: [
	MCWriter subclass: 'MCMczWriter'
	instVarNames: #( zip infoWriter )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMczWriter'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMczWriter
removeallclassmethods MCMczWriter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMcdWriter otherwise: nil.
oldCls == nil ifTrue: [
	MCMczWriter subclass: 'MCMcdWriter'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMcdWriter'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMcdWriter
removeallclassmethods MCMcdWriter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCStWriter otherwise: nil.
oldCls == nil ifTrue: [
	MCWriter subclass: 'MCStWriter'
	instVarNames: #( initStream )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCStWriter'.
	newCls category: 'Monticello-Chunk Format'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCStWriter
removeallclassmethods MCStWriter

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCVersionInfoWriter otherwise: nil.
oldCls == nil ifTrue: [
	MCWriter subclass: 'MCVersionInfoWriter'
	instVarNames: #( written )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCVersionInfoWriter'.
	newCls category: 'Monticello-Storing'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCVersionInfoWriter
removeallclassmethods MCVersionInfoWriter

expectvalue /String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MethodAddition otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MethodAddition'
	instVarNames: #( text category changeStamp requestor logSource myClass methodAndNode selector compiledMethod priorMethodOrNil )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MethodAddition'.
	newCls category: 'Monticello-Loading'.newCls classComment: 'I represent the addition of a method to a class.  I can produce the CompiledMethod, install it, and then notify the system that the method has been added.  This allows Monticello to implement atomic addition.  A loader can compile all classes and methods first and then install all methods only after they have been all compiled, and in a way that executes little code.' stamp: 'rej 2/25/2007 19:30'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MethodAddition
removeallclassmethods MethodAddition

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MethodReference otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'MethodReference'
	instVarNames: #( classSymbol classIsMeta methodSymbol stringVersion category package )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MethodReference'.
	newCls category: 'System-MethodReference'.
newCls classComment: 'A MethodReference is is a lightweight proxy for a CompiledMethod.  Has methods for pointed to the CompileMethod''s source statements, byte codes. Is heavily used my Tools.

Instance Variables
	classIsMeta:		     Boolean class vs. instance
	classSymbol:		Symbol for method''s class (without class keyword if meta)
	methodSymbol:		Symbol for method''s selector
	stringVersion:		''Class>>selector:'' format

' stamp: 'tlk 5/9/2006 18:43'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MethodReference
removeallclassmethods MethodReference

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #PackageInfo otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'PackageInfo'
	instVarNames: #( packageName methodCategoryPrefix )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'PackageInfo'.
	newCls category: 'PackageInfo-Base'.newCls classComment: 'Subclass this class to create new Packages.' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods PackageInfo
removeallclassmethods PackageInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCDirtyPackageInfo otherwise: nil.
oldCls == nil ifTrue: [
	PackageInfo subclass: 'MCDirtyPackageInfo'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCDirtyPackageInfo'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCDirtyPackageInfo
removeallclassmethods MCDirtyPackageInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCEmptyPackageInfo otherwise: nil.
oldCls == nil ifTrue: [
	PackageInfo subclass: 'MCEmptyPackageInfo'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCEmptyPackageInfo'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCEmptyPackageInfo
removeallclassmethods MCEmptyPackageInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockPackageInfo otherwise: nil.
oldCls == nil ifTrue: [
	PackageInfo subclass: 'MCMockPackageInfo'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockPackageInfo'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockPackageInfo
removeallclassmethods MCMockPackageInfo

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #PackageOrganizer otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'PackageOrganizer'
	instVarNames: #( packages )
	classVars: #(  )
	classInstVars: #( )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'PackageOrganizer'.
	newCls category: 'PackageInfo-Base'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods PackageOrganizer
removeallclassmethods PackageOrganizer

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockAPoolDictionary otherwise: nil.
oldCls == nil ifTrue: [
	SharedPool subclass: 'MCMockAPoolDictionary'
	instVarNames: #(  )
	classVars: #(  )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockAPoolDictionary'.
	newCls category: 'Monticello-Mocks'.newCls classComment: '' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockAPoolDictionary
removeallclassmethods MCMockAPoolDictionary

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #MCMockClassB otherwise: nil.
oldCls == nil ifTrue: [
	MCMock subclass: 'MCMockClassB'
	instVarNames: #( ivarb )
	classVars: #( CVar )
	classInstVars: #( ciVar )
	poolDictionaries: (MCMock poolDictionariesForNames: #( 'MCMockAPoolDictionary' ))
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'MCMockClassB'.
	newCls category: 'Monticello-Mocks'.newCls classComment: 'This comment has a bang! Bang! Bang!' stamp: ''.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods MCMockClassB
removeallclassmethods MCMockClassB

expectvalue %String
run
| oldCls newCls |
oldCls := Gs_Package_Globals at: #UUIDGenerator otherwise: nil.
oldCls == nil ifTrue: [
	Object subclass: 'UUIDGenerator'
	instVarNames: #( timeLow timeMid timeHiAndVersion clockSeqHiAndReserved clockSeqLow node randomCounter randomGenerator semaphoreForGenerator )
	classVars: #( )
	classInstVars: #(  )
	poolDictionaries: #()
	inDictionary: Gs_Package_Globals .
	newCls := Gs_Package_Globals at: #'UUIDGenerator'.
	newCls category: 'Network-UUID'.newCls classComment: 'This class generates a pseudo-random UUID
by John M McIntosh johnmci@smalltalkconsulting.com

See http://www.webdav.org/specs/draft-leach-uuids-guids-01.txt' stamp: '<historical>'.
	^ 'created new class: ' , newCls definition
] ifFalse: [
	^ 'existing class: ' , oldCls definition
].
%

removeallmethods UndefinedSymbolNotification
removeallclassmethods UndefinedSymbolNotification

category: 'ANSI - signaled exception'
method: UndefinedSymbolNotification
defaultAction
	"Answer true if you don't want a compile error to be generated on encountering undefined sysmbols."

	^true.
%


removeallmethods UUIDGenerator
removeallclassmethods UUIDGenerator


category: 'instance creation'
classmethod: UUID
fromString36: aString
	"Decode the UUID from a base 36 string using 0-9 and lowercase a-z.
	This is the shortest representation still being able to work as
	filenames etc since it does not depend on case nor characters
	that might cause problems."

	| object num |
	object := self nilUUID.
	num := Integer readFrom: aString asUppercase readStream base: 36.
	16 to: 1 by: -1 do: [:i |
		num size < i
			ifTrue: [object at: i put: 0]
			ifFalse: [object at: i put: (num digitAt: i)]].
	^object
%
run
UUID class setStamp: 'dvf 9/10/2004 23:11' forMethod: #fromString36:.
true
%

category: 'instance creation'
classmethod: UUID
fromString: aString
	| object |
	aString size ~= 36 ifTrue: [Error signal].
	object := self nilUUID. 
	object asUUID: aString.
	^object
%
run
UUID class setStamp: 'dvf 9/10/2004 23:10' forMethod: #fromString:.
true
%

category: 'instance creation'
classmethod: UUID
new
	^(self basicNew: 16) initialize
%
run
UUID class setStamp: 'DaleHenrichs 9/30/2010 16:11' forMethod: #new.
true
%

category: 'instance creation'
classmethod: UUID
nilUUID
	"Must call basicNew: here because I have a non-trivial initialize method."

	^self basicNew: 16
%
run
UUID class setStamp: 'nk 6/28/2004 16:10' forMethod: #nilUUID.
true
%

category: 'comparing'
method: UUID
< aMagnitude 
	"Answer whether the receiver is less than the argument."

	1 to: self size do: [:i |
		(self at: i) < (aMagnitude at: i) ifTrue: [^true]].
	^false.
%
run
UUID setStamp: 'JMM 11/22/2001 17:36' forMethod: #<.
true
%

category: 'comparing'
method: UUID
<= aMagnitude 
	"Answer whether the receiver is less than or equal to the argument."

	^(self > aMagnitude) not
%
run
UUID setStamp: 'JMM 11/22/2001 17:30' forMethod: #'<='.
true
%

category: 'comparing'
method: UUID
> aMagnitude 
	"Answer whether the receiver is greater than the argument."

	^aMagnitude < self
%
run
UUID setStamp: 'JMM 11/22/2001 17:30' forMethod: #>.
true
%

category: 'comparing'
method: UUID
>= aMagnitude 
	"Answer whether the receiver is greater than or equal to the argument."

	^(self < aMagnitude) not
%
run
UUID setStamp: 'JMM 11/22/2001 17:30' forMethod: #'>='.
true
%

category: 'converting'
method: UUID
asString
	| result data |
	data := String new: 36.
	result := WriteStream on: data.
	1 to: 4 do:[:i| self printHexAt: i to: result].
	result nextPut: $-.
	5 to: 6 do:[:i| self printHexAt: i to: result].
	result nextPut: $-.
	7 to: 8 do:[:i| self printHexAt: i to: result].
	result nextPut: $-.
	9 to: 10 do:[:i| self printHexAt: i to: result].
	result nextPut: $-.
	11 to: 16 do:[:i| self printHexAt: i to: result].
	^data.
	
%
run
UUID setStamp: 'DaleHenrichs 9/30/2010 16:33' forMethod: #asString.
true
%

category: 'converting'
method: UUID
asUUID: aString 
	| stream token byte |
	stream := (aString 
		copyReplaceAll: '-'
		with: '') asUppercase readStream.
	1 
		to: stream size / 2
		do: 
			[ :i | 
			token := stream next: 2.
			byte := MCPlatform current integerFromHexString: token.
			self 
				at: i
				put: byte ].
	^ self
%
run
UUID setStamp: 'DaleHenrichs 10/1/2010 10:23' forMethod: #asUUID:.
true
%

category: 'initalize-release'
method: UUID
initialize
	self primMakeUUID.
%
run
UUID setStamp: 'DaleHenrichs 9/29/2010 15:08' forMethod: #initialize.
true
%

category: 'testing'
method: UUID
isNilUUID
	1 to: self size do: [:i | (self at: i) ~= 0 ifTrue: [^false]].
	^true.
%
run
UUID setStamp: 'JMM 10/9/2001 14:17' forMethod: #isNilUUID.
true
%

category: 'system primitives'
method: UUID
primMakeUUID

	UUIDGenerator default generateBytes: self forVersion: 4.
%
run
UUID setStamp: 'DaleHenrichs 9/29/2010 15:08' forMethod: #primMakeUUID.
true
%

category: 'converting'
method: UUID
printHexAt: index to: aStream
	| map v |
	map := '0123456789abcdef'.
	v := self at: index.
	aStream nextPut: (map at: (v bitShift: -4) + 1). 
	aStream nextPut: (map at: (v bitAnd: 15) + 1).

%
run
UUID setStamp: 'ar 2/8/2004 12:16' forMethod: #printHexAt:to:.
true
%

category: 'printing'
method: UUID
printOn: aStream
	aStream nextPutAll: 'an UUID('.
	self asString printOn: aStream.
	aStream nextPutAll: ')'
%
run
UUID setStamp: 'JMM 10/9/2001 14:46' forMethod: #printOn:.
true
%

category: 'printing'
method: UUID
printString
	^self asString
%
run
UUID setStamp: 'ar 2/8/2004 12:16' forMethod: #printString.
true
%

category: '*Network-UUID'
method: String
asAlphaNumeric: totalSize extraChars: additionallyAllowed mergeUID: minimalSizeOfRandomPart 
	"Generates a String with unique identifier ( UID ) qualities, the difference to a
	 UUID is that its beginning is derived from the receiver, so that it has a meaning
	 for a human reader.

	 Answers a String of totalSize, which consists of 3 parts
	 1.part: the beginning of the receiver only consisting of
		a-z, A-Z, 0-9 and extraChars in Collection additionallyAllowed ( which can be nil )
	 2.part: a single _
	 3.part: a ( random ) UID of size >= minimalSizeOfRandomPart consisting of
		a-z, A-Z, 0-9

	 Starting letters are capitalized. 
	 TotalSize must be at least 1.
	 Exactly 1 occurrence of $_ is guaranteed ( unless additionallyAllowed includes $_ ).
	 The random part has even for small sizes good UID qualitites for many practical purposes.
	 If only lower- or uppercase letters are demanded, simply convert the answer with
	 say #asLowercase. The probability of a duplicate will rise only moderately ( see below ).

	 Example: 
		size of random part = 10
		in n generated UIDs the chance p of having non-unique UIDs is
			n = 10000 ->  p < 1e-10		if answer is reduced to lowerCase: p < 1.4 e-8
			n = 100000 -> p < 1e-8
		at the bottom is a snippet for your own calculations  
		Note: the calculated propabilites are theoretical,
			for the actually used random generator they may be much worse"
	| stream out sizeOfFirstPart index ascii ch skip array random |
	totalSize > minimalSizeOfRandomPart ifFalse: [ self errorOutOfBounds ].
	stream := self readStream.
	out :=  (String new: totalSize) writeStream.
	index := 0.
	skip := true.
	sizeOfFirstPart := totalSize - minimalSizeOfRandomPart - 1.
	[ stream atEnd or: [ index >= sizeOfFirstPart ] ] whileFalse: 
		[ (((ascii := (ch := stream next) codePoint) >= 65 and: [ ascii <= 90 ]) or: 
			[ (ascii >= 97 and: [ ascii <= 122 ]) or: 
				[ ch isDigit or: [ additionallyAllowed notNil and: [ additionallyAllowed includes: ch ] ] ] ]) 
			ifTrue: 
				[ skip 
					ifTrue: [ out nextPut: ch asUppercase ]
					ifFalse: [ out nextPut: ch ].
				index := index + 1.
				skip := false ]
			ifFalse: [ skip := true ] ].
	out nextPut: $_.
	array := Array new: 62.
	1 
		to: 26
		do: 
			[ :i | 
			array 
				at: i
				put: (i + 64) asCharacter.
			array 
				at: i + 26
				put: (i + 96) asCharacter ].
	53 
		to: 62
		do: 
			[ :i | 
			array 
				at: i
				put: (i - 5) asCharacter ].
	random := UUIDGenerator default randomGenerator.
	totalSize - index - 1 timesRepeat: [ out nextPut: (array atRandom: random) ].
	^ out contents

	"	calculation of probability p for failure of uniqueness in n UIDs
		Note: if answer will be converted to upper or lower case replace 62 with 36
	| n i p all |
	all := 62 raisedTo: sizeOfRandomPart.
	i := 1.
	p := 0.0 .
	n := 10000.
	[ i <= n ]
	whileTrue: [
		p := p + (( i - 1 ) / all ).
		i := i + 1 ].
	p   

	approximation formula: n squared / ( 62.0 raisedTo: sizeOfRandomPart ) / 2 
	"

	"'Crop SketchMorphs and Grab Screen Rect to JPG' 
			asAlphaNumeric: 31 extraChars: nil mergeUID: 10  
	 			'CropSketchMorphsAndG_iOw94jquN6'
	 'Monticello' 
			asAlphaNumeric: 31 extraChars: nil mergeUID: 10    
				'Monticello_kp6aV2l0IZK9uBULGOeG' 
	 'version-', ( '1.1.2' replaceAll: $. with: $- )
			asAlphaNumeric: 31 extraChars: #( $- ) mergeUID: 10    
				'Version-1-1-2_kuz2tMg2xX9iRLDVR'"
%
run
String setStamp: 'PeterHugossonMiller 9/3/2009 11:26' forMethod: #asAlphaNumeric:extraChars:mergeUID:.
true
%

category: 'as yet unclassified'
method: MCChangeSelectionRequest
label
	^ label
%
run
MCChangeSelectionRequest setStamp: 'avi 9/14/2004 15:02' forMethod: #label.
true
%

category: 'as yet unclassified'
method: MCChangeSelectionRequest
label: aString
	label := aString
%
run
MCChangeSelectionRequest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #label:.
true
%

category: 'as yet unclassified'
method: MCChangeSelectionRequest
patch
	^ patch
%
run
MCChangeSelectionRequest setStamp: 'avi 9/11/2004 15:12' forMethod: #patch.
true
%

category: 'as yet unclassified'
method: MCChangeSelectionRequest
patch: aPatch
	patch := aPatch
%
run
MCChangeSelectionRequest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #patch:.
true
%

category: 'as yet unclassified'
method: MCMergeResolutionRequest
merger
	^ merger
%
run
MCMergeResolutionRequest setStamp: 'ab 7/18/2003 18:19' forMethod: #merger.
true
%

category: 'as yet unclassified'
method: MCMergeResolutionRequest
merger: aMerger
	merger := aMerger
%
run
MCMergeResolutionRequest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #merger:.
true
%

category: 'as yet unclassified'
method: MCVersionNameAndMessageRequest
suggestedLogComment

	^ suggestedLogComment
%
run
MCVersionNameAndMessageRequest setStamp: 'AndrewBlack 9/4/2009 14:16' forMethod: #suggestedLogComment.
true
%

category: 'as yet unclassified'
method: MCVersionNameAndMessageRequest
suggestedLogComment: aLogMessage

	suggestedLogComment := aLogMessage
%
run
MCVersionNameAndMessageRequest setStamp: 'AndrewBlack 9/4/2009 14:16' forMethod: #suggestedLogComment:.
true
%

category: 'as yet unclassified'
method: MCVersionNameAndMessageRequest
suggestedName
	^ suggestion
%
run
MCVersionNameAndMessageRequest setStamp: 'ab 7/10/2003 01:07' forMethod: #suggestedName.
true
%

category: 'as yet unclassified'
method: MCVersionNameAndMessageRequest
suggestedName: aString
	suggestion := aString
%
run
MCVersionNameAndMessageRequest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #suggestedName:.
true
%

category: 'as yet unclassified'
method: MCNoChangesException
defaultAction
	self inform: 'No changes'
%
run
MCNoChangesException setStamp: 'jf 8/21/2003 19:49' forMethod: #defaultAction.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshotResource
mockPackage
	^ (MCPackage new name: self mockPackageName)
%
run
MCSnapshotResource class setStamp: 'cwp 8/1/2003 20:18' forMethod: #mockPackage.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshotResource
mockPackageName
	^ MCMockPackageInfo new packageName
%
run
MCSnapshotResource class setStamp: 'avi 2/22/2004 13:54' forMethod: #mockPackageName.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshotResource
takeSnapshot
	^ self mockPackage snapshot
%
run
MCSnapshotResource class setStamp: 'cwp 7/14/2003 15:19' forMethod: #takeSnapshot.
true
%

category: 'as yet unclassified'
method: MCSnapshotResource
definitions
	^ snapshot definitions
%
run
MCSnapshotResource setStamp: 'cwp 7/14/2003 14:50' forMethod: #definitions.
true
%

category: 'as yet unclassified'
method: MCSnapshotResource
setUp
	snapshot := self class takeSnapshot.
%
run
MCSnapshotResource setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'as yet unclassified'
method: MCSnapshotResource
snapshot
	^ snapshot
%
run
MCSnapshotResource setStamp: 'cwp 7/14/2003 14:51' forMethod: #snapshot.
true
%

category: 'testing'
classmethod: MCDependencySorterTest
isUnitTest
	^false
%
run
MCDependencySorterTest class setStamp: 'JorgeRessia 3/16/2010 20:26' forMethod: #isUnitTest.
true
%

category: 'asserting'
method: MCDependencySorterTest
assertItems: anArray orderAs: depOrder withRequired: missingDeps toLoad: unloadableItems
	self assertItems: anArray orderAs: depOrder withRequired: missingDeps  toLoad: unloadableItems  extraProvisions: #()
%
run
MCDependencySorterTest setStamp: 'avi 10/7/2004 22:32' forMethod: #assertItems:orderAs:withRequired:toLoad:.
true
%

category: 'asserting'
method: MCDependencySorterTest
assertItems: anArray orderAs: depOrder withRequired: missingDeps toLoad: unloadableItems extraProvisions: provisions
	| order sorter items missing unloadable |
	items := anArray collect: [:ea | self itemWithSpec: ea].
	sorter := MCDependencySorter items: items.
	sorter addExternalProvisions: provisions.
	order := (sorter orderedItems collect: [:ea | ea name]) asArray.
	self assert: order = depOrder.
	missing := sorter externalRequirements.
	self assert: missing asSet = missingDeps asSet.
	unloadable := (sorter itemsWithMissingRequirements collect: [:ea | ea name]) asArray.
	self assert: unloadable asSet = unloadableItems asSet
%
run
MCDependencySorterTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertItems:orderAs:withRequired:toLoad:extraProvisions:.
true
%

category: 'building'
method: MCDependencySorterTest
itemWithSpec: anArray
	^ MCMockDependentItem new
		name: (anArray at: 1);
		provides: (anArray at: 2);
		requires: (anArray at: 3)
%
run
MCDependencySorterTest setStamp: 'DaleHenrichs 10/8/2010 11:43' forMethod: #itemWithSpec:.
true
%

category: 'tests'
method: MCDependencySorterTest
testCascadingUnresolved
	self assertItems: #(
		(a (x) (z))
		(b () (x))
		(c () ()))
	orderAs: #(c)
	withRequired: #(z)
	toLoad: #(a b)	
%
run
MCDependencySorterTest setStamp: 'ab 5/25/2003 01:11' forMethod: #testCascadingUnresolved.
true
%

category: 'tests'
method: MCDependencySorterTest
testCycle
	self assertItems: #(
		(a (x) (y))
		(b (y) (x)))
	orderAs: #()
	withRequired: #()
	toLoad: #(a b)	
%
run
MCDependencySorterTest setStamp: 'ab 5/25/2003 01:11' forMethod: #testCycle.
true
%

category: 'tests'
method: MCDependencySorterTest
testExtraProvisions
	self assertItems:
		#((a (x) (z))
		(b () (x)))
	orderAs: #(a b)
	withRequired: #()
	toLoad: #()	
	extraProvisions: #(x z)
%
run
MCDependencySorterTest setStamp: 'avi 10/7/2004 22:35' forMethod: #testExtraProvisions.
true
%

category: 'tests'
method: MCDependencySorterTest
testMultiRequirementOrdering
	self assertItems: #(
		(a (x) (z))
		(b (y) ())
		(c (z) ())
		(d () (x y z)))
		orderAs: #(b c a d)
		withRequired: #()
		toLoad: #()
%
run
MCDependencySorterTest setStamp: 'ab 5/25/2003 01:11' forMethod: #testMultiRequirementOrdering.
true
%

category: 'tests'
method: MCDependencySorterTest
testSimpleOrdering
	self assertItems: #((a (x) ())
								 (c () (y))
								 (b (y) (x)))
		orderAs: #(a b c)
		withRequired: #()
		toLoad: #()
%
run
MCDependencySorterTest setStamp: 'ab 5/25/2003 01:11' forMethod: #testSimpleOrdering.
true
%

category: 'tests'
method: MCDependencySorterTest
testSimpleUnresolved
	self assertItems: #(
		(a () (z)))
	orderAs: #()
	withRequired: #(z)
	toLoad: #(a)
		
%
run
MCDependencySorterTest setStamp: 'ab 5/25/2003 01:12' forMethod: #testSimpleUnresolved.
true
%

category: 'tests'
method: MCDependencySorterTest
testUnusedAlternateProvider
	self assertItems: #(
		(a (x) (z))
		(b () (x))
		(c (x) ()))
	orderAs: #(c b)
	withRequired: #(z)
	toLoad: #(a)	
%
run
MCDependencySorterTest setStamp: 'avi 10/7/2004 22:12' forMethod: #testUnusedAlternateProvider.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testBeginsWith
	| collection |
	collection := {
		(#(1 2 3 4 5) copy). 
		#().
		('abcdef' copy). 
		''.
	}.
	1 to: collection size by: 2 do: [ :index | | nonEmpty empty | 
		nonEmpty := collection at: index.
		empty := collection at: index + 1.
		self assert: (nonEmpty beginsWith: (nonEmpty copyFrom: 1 to: nonEmpty size - 1)).
		self assert: (nonEmpty beginsWith: nonEmpty).
		self deny: (nonEmpty beginsWith: (nonEmpty copyWith: (nonEmpty at: 1))).
		
		self deny: (nonEmpty beginsWith:(empty)).
		self deny: (empty beginsWith:(nonEmpty )).
		]
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/7/2010 14:09' forMethod: #testBeginsWith.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyAfter
	| collection |
	collection := {
		{1.1. 4.4. 6.5. 2.4. 3.1.}. 
		#().
		('abcdef' copy). 
		''.
	}.
	1 to: collection size by: 2 do: [ :index | | nonEmpty empty result | 
		nonEmpty := collection at: index.
		empty := collection at: index + 1.
	
		result := nonEmpty	copyAfter: (nonEmpty at: 2).
		1 to: result size do: [:i| self assert: (nonEmpty at: i + 2) = (result at:i) ].
		self assert: result size = (nonEmpty size -2).
		
		result := empty copyAfter: (nonEmpty at: 1).
		self assert: result isEmpty.
		]
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 12:19' forMethod: #testCopyAfter.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyAfterLast
	| result index collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.} .
	index:= 2 .
	result := collection   copyAfterLast: (collection  at:index ).
	
	"verifying content: "
	(1) to: result size do: 
		[:i |
		self assert: (collection   at:(i + index ))=(result at: (i))].

	"verify size: "
	self assert: result size = (collection   size - index).
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:48' forMethod: #testCopyAfterLast.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyAfterLastEmpty
	| result |
	result := #() copyAfterLast: ({1.1. 4.4. 6.5. 2.4. 3.1.} at: 1).
	self assert: result isEmpty.
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:47' forMethod: #testCopyAfterLastEmpty.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyAfterLastLast
	| result index collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.} .
	index:= collection size .
	result := collection   copyAfterLast: (collection  at:index ).
	
	self assert: result isEmpty
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:55' forMethod: #testCopyAfterLastLast.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyAfterLastWithDuplicate
	| result element  collection |
	collection := {1.5. 5.5. 1.5 copy}.
	element := collection  at: 1.
	
	" collectionWithSameAtEndAndBegining first and last elements are equals.
	'copyAfter:' should copy after the last occurence of element :"
	result := collection   copyAfterLast: (element ).
	
	"verifying content: "
	self assert: result isEmpty.


%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:46' forMethod: #testCopyAfterLastWithDuplicate.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyUpTo
	| collection |
	collection := {
		{1.1. 4.4. 6.5. 2.4. 3.1.}. 
		#().
		('abcdef' copy). 
		''.
	}.
	1 to: collection size by: 2 do: [ :index | | nonEmpty empty result | 
		nonEmpty := collection at: index.
		empty := collection at: index + 1.
	
		result := nonEmpty	copyUpTo: (nonEmpty at: 2).
		1 to: result size do: [:i| self assert: (nonEmpty at: i) = (result at:i) ].
		self assert: result size = (2-1).
		
		result := empty copyUpTo: (nonEmpty at: 1).
		self assert: result isEmpty.
		]
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 12:02' forMethod: #testCopyUpTo.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyUpToLast
	| result index collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.} .
	index:= 2.
	result := collection   copyUpToLast: (collection  at:index).
	
	"verify content of 'result' :"
	1 to: result size do: [:i| self assert: (collection   at:i)=(result at:i)].
	
	"verify size of 'result' :"
	self assert: result size = (index-1).
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:53' forMethod: #testCopyUpToLast.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyUpToLastEmpty
	| result |
	result := #() copyUpToLast: ({1.1. 4.4. 6.5. 2.4. 3.1.} at: 1).
	self assert: result isEmpty.
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:53' forMethod: #testCopyUpToLastEmpty.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyUpToLastFirst
	| result index collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.} .
	index:= 1.
	result := collection   copyUpToLast: (collection  at:index).
	
	self assert: result isEmpty.
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:54' forMethod: #testCopyUpToLastFirst.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testCopyWithoutAll
	| collection |
	collection := {
		(#(1 2 3 4 5) copy). 
		{ 2. 4. }.
		#().
		('abcdef' copy). 
		'bcd'.
		''.
	}.
	1 to: collection size by: 3 do: [ :index | | nonEmpty toRemove empty result | 
		nonEmpty := collection at: index.
		toRemove := collection at: index + 1.
		empty := collection at: index + 2.
	
		result := nonEmpty copyWithoutAll: toRemove.
		toRemove do: [ :each | self deny: (result includes: each) ].
		nonEmpty do:  [ :each | (toRemove includes: each) ifFalse: [ self assert: (result includes: each) ] ].

		result := empty copyWithoutAll: toRemove.
		self assert: result size = empty size.
		toRemove do: [ :each | self deny: (result includes: each) ].
		]
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 12:11' forMethod: #testCopyWithoutAll.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testEndsWith
	| collection |
	collection := {
		(#(1 2 3 4 5) copy). 
		#().
		('abcdef' copy). 
		''.
	}.
	1 to: collection size by: 2 do: [ :index | | nonEmpty empty | 
		nonEmpty := collection at: index.
		empty := collection at: index + 1.
		self assert: (nonEmpty endsWith: (nonEmpty copyFrom: 2 to: nonEmpty size)).
		self assert: (nonEmpty endsWith: nonEmpty).
		self deny: (nonEmpty endsWith: (nonEmpty copyWith: (nonEmpty at: 1))).
		
		self deny: (nonEmpty endsWith:(empty)).
		self deny: (empty endsWith:(nonEmpty )).
		 ]
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/7/2010 14:09' forMethod: #testEndsWith.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testGemStoneLineEndings

	| inStream expectedStream testString expectedString testBytes expectedBytes |
	inStream := WriteStream on: String new.
	inStream nextPutAll: 'Line 1'; nextPut: Character cr.
	inStream nextPutAll: 'Line 2'; nextPut: Character lf.
	inStream nextPutAll: 'Line 3'; nextPut: Character cr; nextPut: Character lf.
	inStream nextPutAll: 'Line 4'; nextPut: Character lf; nextPut: Character cr.
	inStream nextPutAll: 'Line 5'; nextPut: Character cr.
	
	expectedStream := WriteStream on: String new.
	expectedStream nextPutAll: 'Line 1'; nextPut: Character lf.
	expectedStream nextPutAll: 'Line 2'; nextPut: Character lf.
	expectedStream nextPutAll: 'Line 3'; nextPut: Character lf.
	expectedStream nextPutAll: 'Line 4'; nextPut: Character lf; nextPut: Character lf.
	expectedStream nextPutAll: 'Line 5'; nextPut: Character lf.

	testString := inStream contents withGemStoneLineEndings.
	expectedString := expectedStream contents.
	testBytes := testString asByteArray.
	expectedBytes := expectedString asByteArray.
	self assert: testString = expectedString
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/6/2010 17:04' forMethod: #testGemStoneLineEndings.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOf
	"self debug: #testLastIndexOf"
	| element collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.}.
	element := collection at: 1.
	self assert: (collection lastIndexOf: element) = 1.
	self assert: (collection lastIndexOf: 9) = 0
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:43' forMethod: #testLastIndexOf.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOfDuplicate
	"self debug: #testLastIndexOf"
	| collection element |
	collection := {1.5. 5.5. 1.5 copy}.
	element := collection at: 1.

	" floatCollectionWithSameAtEndAndBegining first and last elements are equals 
	'lastIndexOf: should return the position of the last occurrence :'"
	self assert: (collection lastIndexOf: element) = collection size
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:43' forMethod: #testLastIndexOfDuplicate.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOfIfAbsent
	"self debug: #testIndexOfIfAbsent"
	| element collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.}.
	element := collection at: 1.
	self assert: (collection 
			lastIndexOf: element
			ifAbsent: [ 99 ]) = 1.
	self assert: (collection 
			lastIndexOf: 9
			ifAbsent: [ 99 ]) = 99
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:44' forMethod: #testLastIndexOfIfAbsent.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOfIfAbsentDuplicate
	"self debug: #testIndexOfIfAbsent"
	"self debug: #testLastIndexOf"
	| collection element |
	collection := {1.5. 5.5. 1.5 copy}.
	element := collection at: 1.

	" floatCollectionWithSameAtEndAndBegining first and last elements are equals 
	'lastIndexOf: should return the position of the last occurrence :'"
	self assert: (collection 
			lastIndexOf: element
			ifAbsent: [ 55 ]) = collection size
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:44' forMethod: #testLastIndexOfIfAbsentDuplicate.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOfStartingAt
	"self debug: #testLastIndexOf"
	| element collection |
	collection := {1.1. 4.4. 6.5. 2.4. 3.1.}.
	element := collection at: collection size.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size
			ifAbsent: [ 99 ]) = collection size.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size - 1
			ifAbsent: [ 99 ]) = 99.
	self assert: (collection 
			lastIndexOf: 9
			startingAt: collection size
			ifAbsent: [ 99 ]) = 99
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:42' forMethod: #testLastIndexOfStartingAt.
true
%

category: 'as yet unclassified'
method: MCGemStoneTests
testLastIndexOfStartingAtDuplicate
	"self debug: #testLastIndexOf"
	| collection element |
	collection := {1.5. 5.5. 1.5 copy}.
	element := collection at: collection size.

	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size
			ifAbsent: [ 55 ]) = collection size.
	self assert: (collection 
			lastIndexOf: element
			startingAt: collection size - 1
			ifAbsent: [ 55 ]) = 1
%
run
MCGemStoneTests setStamp: 'DaleHenrichs 10/8/2010 16:39' forMethod: #testLastIndexOfStartingAtDuplicate.
true
%

category: 'testing'
classmethod: MCSortingTest
isUnitTest
	^false
%
run
MCSortingTest class setStamp: 'JorgeRessia 3/16/2010 20:26' forMethod: #isUnitTest.
true
%

category: 'building'
method: MCSortingTest
classNamed: aSymbol
	^ MCClassDefinition
		name: aSymbol
		superclassName: #Object
		category: ''
		instVarNames: #()
		comment: ''
%
run
MCSortingTest setStamp: 'ab 4/8/2003 17:56' forMethod: #classNamed:.
true
%

category: 'building'
method: MCSortingTest
methodNamed: aSymbol class: className meta: aBoolean
	^ MCMethodDefinition
		className: className
		classIsMeta: aBoolean
		selector: aSymbol
		category: ''
		timeStamp: ''
		source: ''
%
run
MCSortingTest setStamp: 'ab 4/8/2003 18:03' forMethod: #methodNamed:class:meta:.
true
%

category: 'actions'
method: MCSortingTest
sortDefinitions: aCollection
	^ aCollection asSortedCollection asArray
%
run
MCSortingTest setStamp: 'ab 7/19/2003 18:01' forMethod: #sortDefinitions:.
true
%

category: 'building'
method: MCSortingTest
sortKeyFor: aDefinition
	^ String streamContents:
		[:s |
		aDefinition description
			do: [:ea | s nextPutAll: ea asString]
			separatedBy: [s nextPut: $.]]
%
run
MCSortingTest setStamp: 'ab 7/19/2003 17:56' forMethod: #sortKeyFor:.
true
%

category: 'tests'
method: MCSortingTest
testConsistentSorting
	| definitions shuffledAndSorted|
	definitions :=
		{self methodNamed: #a class: #A meta: false.
		self methodNamed: #a class: #A meta: true.
		self methodNamed: #a class: #B meta: false.
		self methodNamed: #b class: #A meta: false.
		self methodNamed: #b class: #B meta: false.
		self classNamed: #A.
		self classNamed: #B}.
	shuffledAndSorted :=
		(1 to: 100) collect: [:ea | self sortDefinitions: (MCPlatform current shuffle: definitions) ].
	self assert: shuffledAndSorted asSet size = 1.

%
run
MCSortingTest setStamp: 'DaleHenrichs 10/8/2010 11:35' forMethod: #testConsistentSorting.
true
%

category: 'tests'
method: MCSortingTest
testSortOrder
	| aA aAm aB bA bB A B cA bAm cAm |
	aA := self methodNamed: #a class: #A meta: false.
	bA := self methodNamed: #b class: #A meta: false.
	cA := self methodNamed: #c class: #A meta: false.
	aAm := self methodNamed: #a class: #A meta: true.
	bAm := self methodNamed: #b class: #A meta: true.
	cAm := self methodNamed: #c class: #A meta: true.
	aB := self methodNamed: #a class: #B meta: false.
	bB := self methodNamed: #b class: #B meta: false.
	A := self classNamed: #A.
	B := self classNamed: #B.
	self assert: (self sortDefinitions: {aA. aAm. cAm. aB. bAm. bA. bB. A. cA. B})
					= {A. aAm. bAm. cAm. aA. bA. cA. B. aB.  bB}
%
run
MCSortingTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testSortOrder.
true
%

category: 'asserting'
method: MCAncestryTest
assertCommonAncestorOf: leftName and: rightName in: options in: tree
	| left right ancestor |
	left := self versionForName: leftName in: tree.
	right := self versionForName: rightName in: tree.
	
	ancestor := left commonAncestorWith: right.
	
	self assert: (options includes: ancestor name)
%
run
MCAncestryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertCommonAncestorOf:and:in:in:.
true
%

category: 'asserting'
method: MCAncestryTest
assertCommonAncestorOf: leftName and: rightName is: ancestorName in: tree
	self assertCommonAncestorOf: leftName and: rightName in: (Array with: ancestorName) in: tree
%
run
MCAncestryTest setStamp: 'avi 9/17/2005 21:09' forMethod: #assertCommonAncestorOf:and:is:in:.
true
%

category: 'asserting'
method: MCAncestryTest
assertNamesOf: versionInfoCollection are: nameArray
	| names |
	names := versionInfoCollection collect: [:ea | ea name].
	
	self assert: names asArray = nameArray
%
run
MCAncestryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertNamesOf:are:.
true
%

category: 'asserting'
method: MCAncestryTest
assertPathTo: aSymbol is: anArray
	self
		assertNamesOf: (self tree allAncestorsOnPathTo: (self treeFrom: {aSymbol}))
		are: anArray
%
run
MCAncestryTest setStamp: 'jf 8/16/2003 23:42' forMethod: #assertPathTo:is:.
true
%

category: 'tests'
method: MCAncestryTest
testCommonAncestors
	self assertCommonAncestorOf: #a2 and: #e2 is: #a1 in: self tree.
	self assertCommonAncestorOf: #e2 and: #b3 is: #a1 in: self tree.
	self assertCommonAncestorOf: #b2 and: #e2 is: #'00' in: self tree.
	
	self assertCommonAncestorOf: #a4 and: #b5 in: #(b2 a1) in: self twoPersonTree.
	self assertCommonAncestorOf: #b5 and: #b3 is: #b2 in: self twoPersonTree.
	self assertCommonAncestorOf: #b2 and: #a4 is: #b2 in: self twoPersonTree.
	self assertCommonAncestorOf: #b2 and: #b2 is: #b2 in: self twoPersonTree.
	self assertCommonAncestorOf: #b2 and: #a1 is: #a1 in: self twoPersonTree.
	self assertCommonAncestorOf: #a1 and: #b2 is: #a1 in: self twoPersonTree.
%
run
MCAncestryTest setStamp: 'avi 9/17/2005 21:08' forMethod: #testCommonAncestors.
true
%

category: 'tests'
method: MCAncestryTest
testDescendants
	| c1 a1 b3 q1 q2 c2 |
	c1 := self tree.
	a1 := self treeFrom: #(a1 (('00'))).
	b3 := self treeFrom: #(b3
				((b2
					((b1
						((b0
							(('00')))))))
				(a1
					(('00'))))).
	q1 := MCWorkingAncestry new addAncestor: a1.
	q2 := MCWorkingAncestry new addAncestor: q1.
	self assert: (q2 commonAncestorWith: b3) = a1.
	self assert: (b3 commonAncestorWith: q2) = a1.
	self assert: (q2 commonAncestorWith: c1) = a1.
	self assert: (c1 commonAncestorWith: q2) = a1.
	q1 addStepChild: c1.
	self assert: (q2 commonAncestorWith: c1) = q1.
	self assert: (c1 commonAncestorWith: q2) = q1.
	c2 := MCWorkingAncestry new addAncestor: c1.
	self assert: (q2 commonAncestorWith: c2) = q1.
	self assert: (c2 commonAncestorWith: q2) = q1.

%
run
MCAncestryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testDescendants.
true
%

category: 'tests'
method: MCAncestryTest
testLinearPath
	self assertPathTo: #b1 is: #(b3 b2)
%
run
MCAncestryTest setStamp: 'jf 8/16/2003 20:45' forMethod: #testLinearPath.
true
%

category: 'tests'
method: MCAncestryTest
testPathToMissingAncestor
	self assert: (self tree allAncestorsOnPathTo: MCVersionInfo new) isEmpty
%
run
MCAncestryTest setStamp: 'jf 8/16/2003 20:42' forMethod: #testPathToMissingAncestor.
true
%

category: 'building'
method: MCAncestryTest
tree
	^ self treeFrom:
		#(c1
			((e2
				((e1
					((a1
						((#'00')))))))
			(a2
				((a1
					((#'00')))))
			(b3
				((b2
					((b1
						((b0
							((#'00')))))))
				(a1
					((#'00')))))
			(d1)))
%
run
MCAncestryTest setStamp: 'DaleHenrichs 10/1/2010 10:48' forMethod: #tree.
true
%

category: 'building'
method: MCAncestryTest
twoPersonTree
	^ self treeFrom:
		#(c1
			((a4
				((a1)
				(b3
					((b2
						((a1)))))))
			(b5
				((b2
					((a1)))))))
%
run
MCAncestryTest setStamp: 'jf 8/16/2003 22:55' forMethod: #twoPersonTree.
true
%

category: 'building'
method: MCAncestryTest
versionForName: name in: tree
	tree name = name
		ifTrue: [ ^ tree ].
	tree ancestors
		do: [ :ea | 
			| v |
			(v := self versionForName: name in: ea) ~~ nil
				ifTrue: [ ^ v ] ].
	^ nil
%
run
MCAncestryTest setStamp: 'DaleHenrichs 9/28/2010 11:50' forMethod: #versionForName:in:.
true
%

category: 'as yet unclassified'
classmethod: MCClassDefinitionTest
classAComment
	^ 'This is a mock class. The Monticello tests manipulated it to simulate a developer modifying code in the image.'
%
run
MCClassDefinitionTest class setStamp: 'cwp 8/10/2003 01:20' forMethod: #classAComment.
true
%

category: 'as yet unclassified'
classmethod: MCClassDefinitionTest
classACommentStamp
	^  'cwp 8/10/2003 16:43'
%
run
MCClassDefinitionTest class setStamp: 'cwp 8/10/2003 17:59' forMethod: #classACommentStamp.
true
%

category: 'as yet unclassified'
classmethod: MCClassDefinitionTest
restoreClassAComment
	| class |
	class := MCPlatform current globalNamed: #MCMockClassA ifAbsent: [ ^nil ].
	class classComment: self classAComment stamp: self classACommentStamp.
	^class
%
run
MCClassDefinitionTest class setStamp: 'DaleHenrichs 10/1/2010 15:09' forMethod: #restoreClassAComment.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
classAComment
	^ self class classAComment
%
run
MCClassDefinitionTest setStamp: 'cwp 8/10/2003 01:20' forMethod: #classAComment.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
setUp
	MCPlatform current removeClassNamedFromSystem: #MCMockClassC
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 10:56' forMethod: #setUp.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
tearDown

	MCPlatform current removeClassNamedFromSystem: #MCMockClassC
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 10:56' forMethod: #tearDown.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testCannotLoad
	| d |
	self deny: (MCPlatform current hasClassNamed: 'MCMockClassC').
	d :=  self mockClass: 'MCMockClassC' super: 'NotAnObject'.
	self should: [d load] raise: Error.
	self deny: (MCPlatform current hasClassNamed: 'MCMockClassC').
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 10:58' forMethod: #testCannotLoad.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testComparison
	| d1 d2 d3 d4 |
	d1 := self mockClass: 'A' super: 'X'.
	d2 := self mockClass: 'A' super: 'Y'.
	d3 := self mockClass: 'B' super: 'X'.
	d4 := self mockClass: 'B' super: 'X'.
	
	self assert: (d1 isRevisionOf: d2).
	self deny: (d1 isSameRevisionAs: d2).

	self assert: (d3 isRevisionOf: d4).
	self assert: (d3 isSameRevisionAs: d4).
	
	self deny: (d1 isRevisionOf: d3).
	self deny: (d4 isRevisionOf: d2).
%
run
MCClassDefinitionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testComparison.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testCreation
	| d |
	d :=  self mockClassA asClassDefinition.
	self assert: d className = #MCMockClassA.
	self assert: d superclassName = #MCMock.
	self assert: d type = #normal.
	self assert: d category = self mockCategoryName.
	self assert: d instVarNames asArray = #('ivar').
	self assert: d classVarNames asArray = #('CVar').
	self assert: d classInstVarNames asArray = #().
	self assert: (d comment isKindOf: String).
	self assert: d comment = self classAComment.
	self assert: d commentStamp = (MCPlatform current commentStampFor: self mockClassA)
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 13:29' forMethod: #testCreation.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testDefinitionString
	| d |
	d := self mockClassA asClassDefinition.
	self assert: d definitionString = (MCPlatform current st80ClassDefinitionFor: self mockClassA).
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 13:09' forMethod: #testDefinitionString.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testEquals
	| a b |
	a := self mockClass: 'ClassA' super: 'SuperA'.
	b := self mockClass: 'ClassA' super: 'SuperA'.
	self assert: a = b
%
run
MCClassDefinitionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testEquals.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testEqualsSensitivity
	| selector a b defA args defB |
	selector := #name:superclassName:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:commentStamp:.
	a := #(ClassA SuperA CategoryA #(iVarA) #(CVarA) #(PoolA) #(ciVarA)
			typeA 'A comment' 'A').
	b := #(ClassB SuperB CategoryB #(iVarB) #(CVarB) #(PoolB) #(ciVarB)
			typeB 'B comment' 'B').
	
	defA := MCClassDefinition perform: selector withArguments: a.
	1 to: 8 do: [:index |
				args := a copy.
				args at: index put: (b at: index).
				defB := MCClassDefinition perform: selector withArguments: args.
				self deny: defA = defB.]
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 9/28/2010 11:54' forMethod: #testEqualsSensitivity.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testKindOfSubclass
	| classes kindOfSubclass |
	classes := {self mockClassA. Collection. ByteArray.}.
	kindOfSubclass := #(' subclass: ' ' variableSubclass: ' ' variableByteSubclass: ').
	1 to: classes size do: [:i | | d |
		d :=  (classes at: i) asClassDefinition.
		self assert: d kindOfSubclass = (kindOfSubclass at: i).
	].
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 12:47' forMethod: #testKindOfSubclass.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testLoadAndUnload
	| d c |
	d := self mockClass: 'MCMockClassC' super: 'Object'.
	d load.
	self assert: (MCPlatform current hasClassNamed: 'MCMockClassC').
	c := MCPlatform current classNamed: 'MCMockClassC'.
	self assert: (c isKindOf: Class).
	self assert: c superclass = Object.
	self assert: c instVarNames isEmpty.
	self assert: c classVarNames isEmpty.
	self assert: c sharedPools isEmpty.
	self assert: c category = self mockCategoryName.
	self assert: (MCPlatform current classCommentFor: c) = (self commentForClass: 'MCMockClassC').
	self assert: (MCPlatform current commentStampFor: c) = (self commentStampForClass: 'MCMockClassC').
	d unload.
	self deny: (MCPlatform current hasClassNamed: 'MCMockClassC')
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 12:37' forMethod: #testLoadAndUnload.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testTypeOfClass
	| classes |
	classes := {self mockClassA. String. Collection. MCPlatform current weakArrayClass. ByteArray}.
	classes do: [:c | | d |
		d :=  c asClassDefinition.
		self assert: d type = c typeOfClass.
	].
%
run
MCClassDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 11:30' forMethod: #testTypeOfClass.
true
%

category: 'as yet unclassified'
method: MCClassDefinitionTest
testGemStoneKindOfSubclass
	| classes kindOfSubclass |
	classes := {String. }.
	kindOfSubclass := #(' variableByteSubclass: ').
	1 to: classes size do: [:i | | d |
		d :=  (classes at: i) asClassDefinition.
		self assert: d kindOfSubclass = (kindOfSubclass at: i).
	].
%

category: 'asserting'
method: MCMergingTest
assert: aCollection hasElements: anArray
	self assert: (aCollection collect: [:ea | ea token]) asSet = anArray asSet
%
run
MCMergingTest setStamp: 'ab 1/15/2003 16:46' forMethod: #assert:hasElements:.
true
%

category: 'asserting'
method: MCMergingTest
assertMerge: local with: remote base: ancestor gives: result conflicts: conflictResult
	| merger |
	conflicts := #().
	merger := MCThreeWayMerger
				base: (self snapshotWithElements: local)
				target: (self snapshotWithElements: remote)
				ancestor: (self snapshotWithElements: ancestor).
	merger conflicts do: [:ea | self handleConflict: ea].
	self assert: merger mergedSnapshot definitions hasElements: result.
	self assert: conflicts asSet = conflictResult asSet.
%
run
MCMergingTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertMerge:with:base:gives:conflicts:.
true
%

category: 'emulating'
method: MCMergingTest
handleConflict: aConflict
	| l r d |
	l := #removed.
	r := #removed.
	(d := aConflict localDefinition) ~~ nil
		ifTrue: [ l := d token ].
	(d := aConflict remoteDefinition) ~~ nil
		ifTrue: [ r := d token ].
	conflicts := conflicts copyWith: (Array with: r with: l).
	(l = #removed or: [ r = #removed ])
		ifTrue: [ aConflict chooseRemote ]
		ifFalse: [ 
			l > r
				ifTrue: [ aConflict chooseLocal ]
				ifFalse: [ aConflict chooseRemote ] ]
%
run
MCMergingTest setStamp: 'DaleHenrichs 9/28/2010 12:01' forMethod: #handleConflict:.
true
%

category: 'emulating'
method: MCMergingTest
snapshotWithElements: anArray
	^ MCSnapshot
		fromDefinitions: (anArray collect: [:t | self mockToken: t])
%
run
MCMergingTest setStamp: 'ab 7/6/2003 23:48' forMethod: #snapshotWithElements:.
true
%

category: 'tests'
method: MCMergingTest
testAdditiveConflictlessMerge
	self
		assertMerge: #(a1 b1)
				with: #(a1 c1)
				base: #(a1)
			
				gives: #(a1 b1 c1)
				conflicts: #()
%
run
MCMergingTest setStamp: 'ab 12/5/2002 00:28' forMethod: #testAdditiveConflictlessMerge.
true
%

category: 'tests'
method: MCMergingTest
testComplexConflictlessMerge
	self 
		assertMerge: #(a1 b1 d1)
				with: #(a2 c1)
				base: #(a1 c1 d1)
				
				gives: #(a2 b1)
				conflicts: #()
%
run
MCMergingTest setStamp: 'ab 12/5/2002 00:27' forMethod: #testComplexConflictlessMerge.
true
%

category: 'tests'
method: MCMergingTest
testIdenticalModification
	self
		assertMerge: #(a2 b1)
				with: #(a2 b1)
				base: #(a1 b1)
				
				gives: #(a2 b1)
				conflicts: #()
%
run
MCMergingTest setStamp: 'ab 12/5/2002 00:28' forMethod: #testIdenticalModification.
true
%

category: 'tests'
method: MCMergingTest
testLocalModifyRemoteRemove
	self assertMerge: #(a2 b1)
				with: #(b1)
				base: #(a1 b1)
				
				gives: #(b1)
				conflicts: #((removed a2)).
				
	self assertMerge: #(a1 b1)
				with: #(b1)
				base: #(a2 b1)
				
				gives: #(b1)
				conflicts: #((removed a1)).
%
run
MCMergingTest setStamp: 'ab 6/2/2003 01:44' forMethod: #testLocalModifyRemoteRemove.
true
%

category: 'tests'
method: MCMergingTest
testLocalRemoveRemoteModify
	self assertMerge: #(b1)
				with: #(a1 b1)
				base: #(a2 b1)
				
				gives: #(a1 b1)
				conflicts: #((a1 removed)).

	self assertMerge: #(b1)
				with: #(a2 b1)
				base: #(a1 b1)
				
				gives: #(a2 b1)
				conflicts: #((a2 removed)).
%
run
MCMergingTest setStamp: 'ab 6/2/2003 01:43' forMethod: #testLocalRemoveRemoteModify.
true
%

category: 'tests'
method: MCMergingTest
testMultiPackageMerge
	| merger |
	conflicts := #().
	merger := MCThreeWayMerger new.
	merger addBaseSnapshot: (self snapshotWithElements: #(a1 b1)).
	merger applyPatch: ((self snapshotWithElements: #()) patchRelativeToBase: (self snapshotWithElements: #(a1))).
	merger applyPatch: ((self snapshotWithElements: #(a2 b1)) patchRelativeToBase: (self snapshotWithElements: #(b1))).
	merger conflicts do: [:ea | self handleConflict: ea].
	self assert: merger mergedSnapshot definitions hasElements: #(a2 b1).
	self assert: conflicts isEmpty
%
run
MCMergingTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMultiPackageMerge.
true
%

category: 'tests'
method: MCMergingTest
testMultiPackageMerge2
	| merger |
	conflicts := #().
	merger := MCThreeWayMerger new.
	merger addBaseSnapshot: (self snapshotWithElements: #(a1 b1)).
	merger applyPatch: ((self snapshotWithElements: #()) patchRelativeToBase: (self snapshotWithElements: #(a1))).
	merger applyPatch: ((self snapshotWithElements: #(a1 b1)) patchRelativeToBase: (self snapshotWithElements: #(b1))).
	merger conflicts do: [:ea | self handleConflict: ea].
	self assert: merger mergedSnapshot definitions hasElements: #(a1 b1).
	self assert: conflicts isEmpty
%
run
MCMergingTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMultiPackageMerge2.
true
%

category: 'tests'
method: MCMergingTest
testMultiPackageMerge3
	| merger |
	conflicts := #().
	merger := MCThreeWayMerger new.
	merger addBaseSnapshot: (self snapshotWithElements: #(a1 b1)).
	merger applyPatch: ((self snapshotWithElements: #(a1 b1)) patchRelativeToBase: (self snapshotWithElements: #(b1))).
	merger applyPatch: ((self snapshotWithElements: #()) patchRelativeToBase: (self snapshotWithElements: #(a1))).
	merger conflicts do: [:ea | self handleConflict: ea].
	self assert: merger mergedSnapshot definitions hasElements: #(a1 b1).
	self assert: conflicts isEmpty
%
run
MCMergingTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMultiPackageMerge3.
true
%

category: 'tests'
method: MCMergingTest
testMultipleConflicts
	self assertMerge: #(a1 b3 c1)
				with: #(a1 b2 d1)
				base: #(a1 b1 c2)
				
				gives: #(a1 b3 d1)
				conflicts: #((removed c1) (b2 b3))

%
run
MCMergingTest setStamp: 'ab 6/2/2003 01:38' forMethod: #testMultipleConflicts.
true
%

category: 'tests'
method: MCMergingTest
testSimultaneousModification
	self assertMerge: #(a2)
				with: #(a3)
				base: #(a1)
				
				gives: #(a3)
				conflicts: #((a3 a2)).
%
run
MCMergingTest setStamp: 'ab 6/2/2003 01:38' forMethod: #testSimultaneousModification.
true
%

category: 'tests'
method: MCMergingTest
testSimultaneousRemove
	self assertMerge: #(a1)
				with: #(a1)
				base: #(a1 b1)
				
				gives: #(a1)
				conflicts: #()
%
run
MCMergingTest setStamp: 'ab 12/5/2002 01:27' forMethod: #testSimultaneousRemove.
true
%

category: 'tests'
method: MCMergingTest
testSubtractiveConflictlessMerge
	self assertMerge: #(a1 b1)
				with: #()
				base: #(a1)
				
				gives: #(b1)
				conflicts: #()
%
run
MCMergingTest setStamp: 'ab 12/5/2002 01:31' forMethod: #testSubtractiveConflictlessMerge.
true
%

category: 'mocks'
method: MCMethodDefinitionTest
override ^ 1
%
run
MCMethodDefinitionTest setStamp: 'DaleHenrichs 10/8/2010 16:29' forMethod: #override.
true
%

category: 'running'
method: MCMethodDefinitionTest
ownPackage
	^ MCWorkingCopy forPackage: (MCPackage named: 'Monticello')
%
run
MCMethodDefinitionTest setStamp: 'cwp 11/13/2003 14:15' forMethod: #ownPackage.
true
%

category: 'running'
method: MCMethodDefinitionTest
setUp
	navigation := MCPlatform current.
	isModified := self ownPackage modified
%
run
MCMethodDefinitionTest setStamp: 'DaleHenrichs 10/1/2010 11:03' forMethod: #setUp.
true
%

category: 'running'
method: MCMethodDefinitionTest
tearDown
	self restoreMocks.
	(MCWorkingCopy forPackage: (MCPackage named: 'FooBarBaz')) unregister.
	self class compile: 'override ^ 1' classified: 'mocks'.
	self ownPackage modified: isModified
%
run
MCMethodDefinitionTest setStamp: 'bf 5/20/2005 18:23' forMethod: #tearDown.
true
%

category: 'testing'
method: MCMethodDefinitionTest
testCannotLoad
	| definition |
	definition := self mockMethod: #kjahs87 class: 'NoSuchClass' source: 'kjahs87 ^self' meta: false.
	self should: [definition load] raise: Error.
	self assert: (navigation allImplementorsOf: #kjahs87) isEmpty
%
run
MCMethodDefinitionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testCannotLoad.
true
%

category: 'testing'
method: MCMethodDefinitionTest
testComparison
	|d1 d2 d3 d4 d5 |
	d1 := self mockMethod: #one class: 'A' source: '1' meta: false.
	d2 := self mockMethod: #one class: 'A' source: '2' meta: false.
	d3 := self mockMethod: #one class: 'A' source: '1' meta: true.
	d4 := self mockMethod: #two class: 'A' source: '1' meta: false.
	d5 := self mockMethod: #two class: 'A' source: '1' meta: false.
	
	self assert: (d1 isRevisionOf: d2).
	self deny: (d1 isSameRevisionAs: d2).
	
	self deny: (d1 isRevisionOf: d3).
	self deny: (d1 isRevisionOf: d4).
	
	self assert: (d4 isSameRevisionAs: d5).
%
run
MCMethodDefinitionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testComparison.
true
%

category: 'testing'
method: MCMethodDefinitionTest
testLoadAndUnload
	|definition|
	definition := self mockMethod: #one class: 'MCMockClassA' source: 'one ^2' meta: false.
	self assert: self mockInstanceA one = 1.
	definition load.
	self assert: self mockInstanceA one = 2.
	definition unload.
	self deny: (self mockInstanceA respondsTo: #one)
%
run
MCMethodDefinitionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testLoadAndUnload.
true
%

category: 'as yet unclassified'
method: MCOrganizationTest
testReordering
	|dec cats newCats |
	dec := MCOrganizationDefinition categories: #(A B C).
	cats := #(X Y B Z C A Q).
	newCats := dec reorderCategories: cats original: #(B C A).
	self assert: newCats asArray = #(X Y A B C Z Q).
%
run
MCOrganizationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testReordering.
true
%

category: 'as yet unclassified'
method: MCOrganizationTest
testReorderingWithNoCategoriesInVersion
	|dec cats newCats |
	dec := MCOrganizationDefinition categories: #().
	cats := #(X Y B Z C A Q).
	newCats := dec reorderCategories: cats original: #().
	self assert: newCats asArray = cats.
%
run
MCOrganizationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testReorderingWithNoCategoriesInVersion.
true
%

category: 'as yet unclassified'
method: MCOrganizationTest
testReorderingWithRemovals
	|dec cats newCats |
	dec := MCOrganizationDefinition categories: #(A B C).
	cats := #(X Y B Z C A Q).
	newCats := dec reorderCategories: cats original: #(Y B C A Q).
	self assert: newCats asArray = #(X A B C Z).
%
run
MCOrganizationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testReorderingWithRemovals.
true
%

category: 'running'
method: MCPackageTest
tearDown
	self mockSnapshot install.
	DataStream initialize "MCMockClassG ends up in the DataStream TypeMap -- we need to reset"
%
run
MCPackageTest setStamp: 'oscar.nierstrasz 10/18/2009 17:39' forMethod: #tearDown.
true
%

category: 'tests'
method: MCPackageTest
testUnload
	| mock |
	self mockPackage unload.
	self deny: (MCPlatform current hasClassNamed: #MCMockClassA).
	self deny: (MCSnapshotTest includesSelector: #mockClassExtension).
	mock := MCPlatform current globalNamed: #MCMock.
	self assert: ((MCPlatform current subclassesOfMonticelloClass: mock) detect: [ :c | c name = #MCMockClassA ] ifNone: [  ]) isNil
%
run
MCPackageTest setStamp: 'DaleHenrichs 10/1/2010 11:02' forMethod: #testUnload.
true
%

category: 'as yet unclassified'
method: MCPatchTest
setUp
	|rev1 rev2|
	rev1 :=  MCSnapshotResource takeSnapshot.
	self change: #one toReturn: 2.
	rev2 :=  MCSnapshotResource takeSnapshot.
	patch := rev2 patchRelativeToBase: rev1.
	self change: #one toReturn: 1.
%
run
MCPatchTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'as yet unclassified'
method: MCPatchTest
tearDown
	self restoreMocks
%
run
MCPatchTest setStamp: 'cwp 8/2/2003 17:24' forMethod: #tearDown.
true
%

category: 'as yet unclassified'
method: MCPatchTest
testPatchContents
	self assert: patch operations size = 1.
	self assert: patch operations first isModification.
	self assert: patch operations first definition selector = #one.

%
run
MCPatchTest setStamp: 'cwp 7/14/2003 15:31' forMethod: #testPatchContents.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepositoryTest
addVersion: aVersion
	dict at: aVersion info put: aVersion
%
run
MCDictionaryRepositoryTest setStamp: 'ab 8/16/2003 17:53' forMethod: #addVersion:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepositoryTest
deleteNode: aNode
	dict removeKey: aNode
%
run
MCDictionaryRepositoryTest setStamp: 'ab 7/19/2003 16:06' forMethod: #deleteNode:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepositoryTest
dictionary
	^ dict ifNil: [dict := Dictionary new]
%
run
MCDictionaryRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #dictionary.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepositoryTest
setUp
	repository :=  MCDictionaryRepository new dictionary: self dictionary
%
run
MCDictionaryRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepositoryTest
addVersion: aVersion

	(directory / aVersion fileName) writeStreamDo: [:file | aVersion fileOutOn: file ]
%
run
MCFilesystemRepositoryTest setStamp: 'DaleHenrichs 10/20/2010 12:07' forMethod: #addVersion:.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepositoryTest
directory
	directory ifNil:
		[directory := FSDiskFilesystem pwd / 'mctest'.
		directory ensureDirectory].
	^ directory
%
run
MCFilesystemRepositoryTest setStamp: 'DaleHenrichs 10/20/2010 12:10' forMethod: #directory.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepositoryTest
setUp
	repository := MCFilesystemRepository new directory: self directory
%
run
MCFilesystemRepositoryTest setStamp: 'DaleHenrichs 10/20/2010 12:27' forMethod: #setUp.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepositoryTest
tearDown
	self directory deleteAll
%
run
MCFilesystemRepositoryTest setStamp: 'DaleHenrichs 10/20/2010 12:10' forMethod: #tearDown.
true
%

category: 'tests'
method: MCFilesystemRepositoryTest
testBug42017Save

        | old message |
        old := MCPlatform current authorFullName.
        [ message := GsPackageLibrary
                        saveNewVersionOf: 'Monticello-Mocks'
                        author: 'testcase'
                        message: 'this is a test'
                        toPath: self directory asString ]
                        ensure: [MCPlatform current authorFullName: old ].
        self assert: (message includesString: 'testcase').
%

category: 'tests'
method: MCFilesystemRepositoryTest
testBug42017VersionInfo

        | info old |
        old := MCPlatform current authorFullName.
        [ MCPlatform current authorFullName: 'joe'.
                info := self mockVersionInfo: 'bug42017'.
                self assert: info author = 'joe' ]
                        ensure: [MCPlatform current authorFullName: old ]
%

category: 'as yet unclassified'
classmethod: MCRepositoryTest
isAbstract
	^ self = MCRepositoryTest
%
run
MCRepositoryTest class setStamp: 'ab 7/6/2003 12:45' forMethod: #isAbstract.
true
%

category: 'actions'
method: MCRepositoryTest
addVersion: aVersion
	self subclassResponsibility 
%
run
MCRepositoryTest setStamp: 'ab 8/16/2003 17:46' forMethod: #addVersion:.
true
%

category: 'actions'
method: MCRepositoryTest
addVersionWithSnapshot: aSnapshot name: aString
	| version |
	version := self versionWithSnapshot: aSnapshot name: aString.
	self addVersion: version.
	^ version info
%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addVersionWithSnapshot:name:.
true
%

category: 'asserting'
method: MCRepositoryTest
assertMissing: aVersionInfo
	self assert: (repository versionWithInfo: aVersionInfo) isNil
%
run
MCRepositoryTest setStamp: 'ab 7/19/2003 23:59' forMethod: #assertMissing:.
true
%

category: 'asserting'
method: MCRepositoryTest
assertVersionInfos: aCollection
	self assert: repository allVersionInfos asSet = aCollection asSet
%
run
MCRepositoryTest setStamp: 'ab 8/16/2003 18:07' forMethod: #assertVersionInfos:.
true
%

category: 'actions'
method: MCRepositoryTest
saveSnapshot1
	^ self saveSnapshot: self snapshot1 named: 'rev1'
%
run
MCRepositoryTest setStamp: 'ab 7/19/2003 16:20' forMethod: #saveSnapshot1.
true
%

category: 'actions'
method: MCRepositoryTest
saveSnapshot2
	^ self saveSnapshot: self snapshot2 named: 'rev2'
%
run
MCRepositoryTest setStamp: 'ab 7/19/2003 16:20' forMethod: #saveSnapshot2.
true
%

category: 'actions'
method: MCRepositoryTest
saveSnapshot: aSnapshot named: aString
	| version |
	version := self versionWithSnapshot: aSnapshot name: aString.
	repository storeVersion: version.
	^ version info
	
%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #saveSnapshot:named:.
true
%

category: 'building'
method: MCRepositoryTest
snapshot1
	^ (MCSnapshot fromDefinitions: (Array with: (MCOrganizationDefinition categories: #('y'))))
%
run
MCRepositoryTest setStamp: 'ab 7/10/2003 01:03' forMethod: #snapshot1.
true
%

category: 'building'
method: MCRepositoryTest
snapshot2
	^ (MCSnapshot fromDefinitions: (Array with: (MCOrganizationDefinition categories: #('x'))))
%
run
MCRepositoryTest setStamp: 'ab 7/10/2003 01:03' forMethod: #snapshot2.
true
%

category: 'accessing'
method: MCRepositoryTest
snapshotAt: aVersionInfo
	^ (repository versionWithInfo: aVersionInfo) snapshot
%
run
MCRepositoryTest setStamp: 'ab 7/7/2003 14:32' forMethod: #snapshotAt:.
true
%

category: 'tests'
method: MCRepositoryTest
testAddAndLoad
	| node |
	node := self addVersionWithSnapshot: self snapshot1 name: 'rev1'.
	self assert: (self snapshotAt: node) = self snapshot1.

%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testAddAndLoad.
true
%

category: 'tests'
method: MCRepositoryTest
testIncludesName
	self deny: (repository includesVersionNamed: 'MonticelloTest-xxx.1-rev1').
	self saveSnapshot1.
	self assert: (repository includesVersionNamed: 'MonticelloTest-xxx.1-rev1').
	self deny: (repository includesVersionNamed: 'MonticelloTest-xxx.1-rev2').
	self saveSnapshot2.
	self assert:  (repository includesVersionNamed: 'MonticelloTest-xxx.1-rev2').
%
run
MCRepositoryTest setStamp: 'avi 2/17/2004 03:24' forMethod: #testIncludesName.
true
%

category: 'tests'
method: MCRepositoryTest
testLoadMissingNode
	| node |
	node := MCVersionInfo new.
	self assertMissing: node
%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testLoadMissingNode.
true
%

category: 'tests'
method: MCRepositoryTest
testStoreAndLoad
	| node node2 |
	node := self saveSnapshot1.
	node2 := self saveSnapshot2.
	self assert: (self snapshotAt: node) = self snapshot1.
	self assert: (self snapshotAt: node2) = self snapshot2.
%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testStoreAndLoad.
true
%

category: 'building'
method: MCRepositoryTest
versionWithSnapshot: aSnapshot name: aString
	| info |
	info := self mockVersionInfo: aString. 
	^ MCVersion 
		package: (MCPackage new name: aString)
		info: info
		snapshot: aSnapshot
%
run
MCRepositoryTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #versionWithSnapshot:name:.
true
%

category: 'asserting'
method: MCScannerTest
assertScan: aString resultsIn: anArray

	self assert: (MCScanner scan: aString readStream) = anArray
%
run
MCScannerTest setStamp: 'DaleHenrichs 10/18/2010 15:26' forMethod: #assertScan:resultsIn:.
true
%

category: 'tests'
method: MCScannerTest
test1

	self assertScan: '#(#a ''23'' #(#x))' resultsIn: #(a '23' (x)) 
%
run
MCScannerTest setStamp: 'DaleHenrichs 10/6/2010 13:58' forMethod: #test1.
true
%

category: 'tests'
method: MCScannerTest
test2

	self assertScan: '''it''''s alive''' resultsIn: 'it''s alive'
%
run
MCScannerTest setStamp: 'DaleHenrichs 10/6/2010 13:54' forMethod: #test2.
true
%

category: 'tests'
method: MCScannerTest
test3

	self assert: (MCScanner scan: '(a #b c)' readStream) = #(a #b c)
%
run
MCScannerTest setStamp: 'DaleHenrichs 10/18/2010 15:27' forMethod: #test3.
true
%

category: 'tests'
method: MCScannerTest
test4

	self assertScan:  '#(#a ''23'' #(#x #() '')''''q'' #y12))' resultsIn: #(a '23' (x () ')''q' y12)).

%
run
MCScannerTest setStamp: 'DaleHenrichs 10/6/2010 13:56' forMethod: #test4.
true
%

category: 'tests'
method: MCScannerTest
test5

	self assertScan:  '#(#(#a) #b)' resultsIn: #((a) b) .

%
run
MCScannerTest setStamp: 'DaleHenrichs 10/6/2010 13:57' forMethod: #test5.
true
%

category: 'tests'
method: MCScannerTest
test6

	self should: [ MCScanner scan: '(a b' readStream ] raise: Error
%
run
MCScannerTest setStamp: 'DaleHenrichs 10/18/2010 15:27' forMethod: #test6.
true
%

category: 'asserting'
method: MCSerializationTest
assertDependenciesMatchWith: writerClass
	| stream readerClass expected actual x y |
	readerClass := writerClass readerClass.
	expected := self mockVersionWithDependencies.
	stream := RWBinaryOrTextStream on: String new.
	writerClass fileOut: expected on: stream.
	actual := readerClass on: stream reset
	 .
	self assert: (x := actual dependencies) = (y := expected dependencies).
%
run
MCSerializationTest setStamp: 'DaleHenrichs 10/20/2010 14:56' forMethod: #assertDependenciesMatchWith:.
true
%

category: 'asserting'
method: MCSerializationTest
assertExtensionProvidedBy: aClass
	self shouldnt: [aClass readerClass extension] raise: Exception.
%
run
MCSerializationTest setStamp: 'cwp 8/1/2003 14:57' forMethod: #assertExtensionProvidedBy:.
true
%

category: 'asserting'
method: MCSerializationTest
assertSnapshotsMatchWith: writerClass
	|  expected stream actual |
	expected := self mockSnapshot.
	stream := RWBinaryOrTextStream on: String new.
	(writerClass on: stream) writeSnapshot: expected.
	actual := writerClass readerClass snapshotFromStream: stream reset.
	self assertSnapshot: actual matches: expected.
%
run
MCSerializationTest setStamp: 'DaleHenrichs 10/20/2010 13:08' forMethod: #assertSnapshotsMatchWith:.
true
%

category: 'asserting'
method: MCSerializationTest
assertVersionInfosMatchWith: writerClass
	| stream readerClass expected actual |
	readerClass := writerClass readerClass.
	expected := self mockVersion.
	stream := RWBinaryOrTextStream on: String new.
	writerClass fileOut: expected on: stream.
	actual := readerClass versionInfoFromStream: stream reset.
	self assert: actual = expected info.
%
run
MCSerializationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertVersionInfosMatchWith:.
true
%

category: 'asserting'
method: MCSerializationTest
assertVersionsMatchWith: writerClass
	| stream readerClass expected actual |
	readerClass := writerClass readerClass.
	expected := self mockVersion.
	stream := RWBinaryOrTextStream on: String new.
	writerClass fileOut: expected on: stream.
	actual := readerClass versionFromStream: stream reset.
	self assertVersion: actual matches: expected.
%
run
MCSerializationTest setStamp: 'DaleHenrichs 10/20/2010 14:09' forMethod: #assertVersionsMatchWith:.
true
%

category: 'mocks'
method: MCSerializationTest
mockDiffyVersion
	| repos workingCopy base next |
	repos := MCDictionaryRepository new.
	workingCopy := MCWorkingCopy forPackage: self mockPackage.
	workingCopy repositoryGroup addRepository: repos.
	MCRepositoryGroup default removeRepository: repos.
	base := self mockVersion.
	repos storeVersion: base.
	self change: #a toReturn: 'a2'.
	next := self mockVersionWithAncestor: base.
	^ next asDiffAgainst: base	
%
run
MCSerializationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #mockDiffyVersion.
true
%

category: 'testing'
method: MCSerializationTest
testMcdSerialization
	| stream expected actual |
	expected := self mockDiffyVersion.
	stream := RWBinaryOrTextStream on: String new.
	MCMcdWriter fileOut: expected on: stream.
	actual := MCMcdReader versionFromStream: stream reset.
	self assertVersion: actual matches: expected.
%
run
MCSerializationTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMcdSerialization.
true
%

category: 'testing'
method: MCSerializationTest
testMczSerialization
	self assertVersionsMatchWith: MCMczWriter.
	self assertExtensionProvidedBy: MCMczWriter.
	self assertVersionInfosMatchWith: MCMczWriter.
	self assertDependenciesMatchWith: MCMczWriter.
%
run
MCSerializationTest setStamp: 'avi 1/19/2004 15:14' forMethod: #testMczSerialization.
true
%

category: 'testing'
method: MCSerializationTest
testStSerialization
true ifTrue: [ ^self ]. "not passing in 3.1 and not critical"
	self assertSnapshotsMatchWith: MCStWriter.
%
run
MCSerializationTest setStamp: 'cwp 8/3/2003 18:43' forMethod: #testStSerialization.
true
%

category: '*monticello-mocks'
method: MCSnapshotTest
mockClassExtension
%
run
MCSnapshotTest setStamp: 'ab 7/7/2003 23:21' forMethod: #mockClassExtension.
true
%

category: 'running'
method: MCSnapshotTest
setUp
	snapshot :=  self mockSnapshot.
%
run
MCSnapshotTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'tests'
method: MCSnapshotTest
testCreation
	|d|
	d :=  self mockSnapshot definitions.
	self assert: (d anySatisfy: [:ea | ea isClassDefinition and: [ea className = #MCMockClassA]]).
	self assert: (d anySatisfy: [:ea | ea isMethodDefinition and: [ea selector = #mockClassExtension]]).
	self assert: (d allSatisfy: [:ea | ea isClassDefinition not or: [ea category endsWith: 'Mocks']]).
	
%
run
MCSnapshotTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testCreation.
true
%

category: 'asserting'
method: MCStWriterTest
assertAllChunksAreWellFormed
	stream reset.
	MCPlatform current
		for: stream
		untilEnd: [ self assertChunkIsWellFormed: stream nextChunk ]
		displayingProgress: 'Checking syntax...'
%
run
MCStWriterTest setStamp: 'DaleHenrichs 10/7/2010 15:53' forMethod: #assertAllChunksAreWellFormed.
true
%

category: 'asserting'
method: MCStWriterTest
assertChunkIsWellFormed: chunk
	MCPlatform current
		parse: chunk readStream 
		class: UndefinedObject 
		noPattern: true
		context: nil
		notifying: nil
		ifFail: [self assert: false]
%
run
MCStWriterTest setStamp: 'DaleHenrichs 10/7/2010 15:33' forMethod: #assertChunkIsWellFormed:.
true
%

category: 'asserting'
method: MCStWriterTest
assertContentsOf: strm match: expectedIn 
	| actual expected |
	actual := strm contents withSqueakLineEndings.
	expected := expectedIn withSqueakLineEndings.
	"GemStone filout format inserts an extra cr at end of method ... strip it out if one's there"
	(actual size = (expected size + 1) and: [(actual at: actual size - 4) = Character cr])
		ifTrue: [ actual := (actual copyFrom: 1 to: actual size - 5), (actual copyFrom: actual size - 3 to: actual size)].
	self assert: actual size = expected size.
	actual with: expected do: [:a :e | self assert: a = e]
%
run
MCStWriterTest setStamp: 'DaleHenrichs 10/7/2010 16:54' forMethod: #assertContentsOf:match:.
true
%

category: 'asserting'
method: MCStWriterTest
assertMethodChunkIsWellFormed: chunk

	MCPlatform current
		parse: chunk readStream 
		class: UndefinedObject 
		noPattern: false
		context: nil
		notifying: nil
		ifFail: [self assert: false]

%
run
MCStWriterTest setStamp: 'DaleHenrichs 10/7/2010 16:56' forMethod: #assertMethodChunkIsWellFormed:.
true
%

category: 'data'
method: MCStWriterTest
expectedClassDefinitionA
 ^ '
MCMock subclass: #MCMockClassA
	instanceVariableNames: ''ivar''
	classVariableNames: ''CVar''
	poolDictionaries: ''''
	category: ''Monticello-Mocks''!

!MCMockClassA commentStamp: ''cwp 8/10/2003 16:43'' prior: 0!
This is a mock class. The Monticello tests manipulated it to simulate a developer modifying code in the image.!
'
%
run
MCStWriterTest setStamp: 'cwp 2/3/2004 21:39' forMethod: #expectedClassDefinitionA.
true
%

category: 'data'
method: MCStWriterTest
expectedClassDefinitionB
 ^ '
MCMock subclass: #MCMockClassB
	instanceVariableNames: ''ivarb''
	classVariableNames: ''CVar''
	poolDictionaries: ''MCMockAPoolDictionary''
	category: ''Monticello-Mocks''!

MCMockClassB class
	instanceVariableNames: ''ciVar''!

!MCMockClassB commentStamp: '''' prior: 0!
This comment has a bang!! Bang!! Bang!!!
'
%
run
MCStWriterTest setStamp: 'avi 2/17/2004 03:23' forMethod: #expectedClassDefinitionB.
true
%

category: 'data'
method: MCStWriterTest
expectedClassMethodDefinition
	^ '
!MCMockClassA class methodsFor: ''as yet unclassified'' stamp: ''ab 7/7/2003 23:21''!
one

	^ 1! !
'
%
run
MCStWriterTest setStamp: 'cwp 8/2/2003 14:43' forMethod: #expectedClassMethodDefinition.
true
%

category: 'testing'
method: MCStWriterTest
expectedInitializerA
	^ 'MCMockClassA initialize'
%
run
MCStWriterTest setStamp: 'ab 8/8/2003 17:01' forMethod: #expectedInitializerA.
true
%

category: 'data'
method: MCStWriterTest
expectedMethodDefinition
	^ '
!MCMockClassA methodsFor: ''numeric'' stamp: ''cwp 8/2/2003 17:26''!
one
	^ 1! !
'
%
run
MCStWriterTest setStamp: 'cwp 8/2/2003 17:27' forMethod: #expectedMethodDefinition.
true
%

category: 'data'
method: MCStWriterTest
expectedMethodDefinitionWithBangs
	^ '
!MCStWriterTest methodsFor: ''testing'' stamp: ''cwp 8/9/2003 14:55''!
methodWithBangs
	^ ''
	^ ReadStream on: 
''''MCRevisionInfo packageName: ''''MonticelloCompatibilityTest''''!!!!
MCOrganizationDeclaration categories: 
  #(
  ''''Monticello-Mocks'''')!!!!

MCClassDeclaration
  name: #MCMockClassD
  superclassName: #Object
  category: #''''Monticello-Mocks''''
  instVarNames: #()
  comment: ''''''''!!!!

MCMethodDeclaration className: #MCMockClassD selector: #one category: #''''as yet unclassified'''' timeStamp: ''''cwp 7/8/2003 21:21'''' source: 
''''one
	^ 1''''!!!!
''''
''
! !
'
%
run
MCStWriterTest setStamp: 'cwp 8/9/2003 14:58' forMethod: #expectedMethodDefinitionWithBangs.
true
%

category: 'data'
method: MCStWriterTest
expectedOrganizationDefinition
	^ 'SystemOrganization addCategory: ''Monticello-Mocks''!
'
%
run
MCStWriterTest setStamp: 'cwp 8/2/2003 12:14' forMethod: #expectedOrganizationDefinition.
true
%

category: 'testing'
method: MCStWriterTest
methodWithBangs
	^ '
	^ ReadStream on: 
''MCRevisionInfo packageName: ''MonticelloCompatibilityTest''!!
MCOrganizationDeclaration categories: 
  #(
  ''Monticello-Mocks'')!!

MCClassDeclaration
  name: #MCMockClassD
  superclassName: #Object
  category: #''Monticello-Mocks''
  instVarNames: #()
  comment: ''''!!

MCMethodDeclaration className: #MCMockClassD selector: #one category: #''as yet unclassified'' timeStamp: ''cwp 7/8/2003 21:21'' source: 
''one
	^ 1''!!
''
'

%
run
MCStWriterTest setStamp: 'cwp 8/9/2003 14:55' forMethod: #methodWithBangs.
true
%

category: 'testing'
method: MCStWriterTest
setUp
	stream := RWBinaryOrTextStream on: String new.
	writer := MCStWriter on: stream.

%
run
MCStWriterTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'testing'
method: MCStWriterTest
testClassDefinitionA
	writer visitClassDefinition: (self mockClassA asClassDefinition).
	self assertContentsOf: stream match: self expectedClassDefinitionA.
	stream reset.
	2 timesRepeat: [self assertChunkIsWellFormed: stream nextChunk]
%
run
MCStWriterTest setStamp: 'cwp 8/10/2003 02:11' forMethod: #testClassDefinitionA.
true
%

category: 'testing'
method: MCStWriterTest
testClassDefinitionB
	writer visitClassDefinition: (self mockClassB asClassDefinition).
	self assertContentsOf: stream match: self expectedClassDefinitionB.
	
%
run
MCStWriterTest setStamp: 'cwp 9/14/2003 19:39' forMethod: #testClassDefinitionB.
true
%

category: 'testing'
method: MCStWriterTest
testClassMethodDefinition
	writer visitMethodDefinition: (MethodReference class: self mockClassA class selector: #one) 									asMethodDefinition.
	self assertContentsOf: stream match: self expectedClassMethodDefinition.
	stream reset.
	self assert: stream nextChunk isAllSeparators.
	self assertChunkIsWellFormed: stream nextChunk.
	self assertMethodChunkIsWellFormed: stream nextChunk.
	self assert: stream nextChunk isAllSeparators 
%
run
MCStWriterTest setStamp: 'cwp 8/10/2003 02:11' forMethod: #testClassMethodDefinition.
true
%

category: 'testing'
method: MCStWriterTest
testInitializerDefinition
	|chunk lastChunk|
	writer writeSnapshot: self mockSnapshot.
	stream reset.
	[stream atEnd] whileFalse:
		[chunk := stream nextChunk.
		chunk isAllSeparators ifFalse: [lastChunk := chunk]].
	self assertContentsOf: lastChunk readStream match: self expectedInitializerA
%
run
MCStWriterTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testInitializerDefinition.
true
%

category: 'testing'
method: MCStWriterTest
testMethodDefinition
	writer visitMethodDefinition: (MethodReference class: self mockClassA selector: #one) 									asMethodDefinition.
	self assertContentsOf: stream match: self expectedMethodDefinition.
	stream reset.
	self assert: stream nextChunk isAllSeparators.
	self assertChunkIsWellFormed: stream nextChunk.
	self assertMethodChunkIsWellFormed: stream nextChunk.
	self assert: stream nextChunk isAllSeparators 
%
run
MCStWriterTest setStamp: 'cwp 8/10/2003 02:11' forMethod: #testMethodDefinition.
true
%

category: 'testing'
method: MCStWriterTest
testMethodDefinitionWithBangs
	writer visitMethodDefinition: (MethodReference 
									class: self class 
									selector: #methodWithBangs) asMethodDefinition.
	self assertContentsOf: stream match: self expectedMethodDefinitionWithBangs.
	stream reset.
	self assert: stream nextChunk isAllSeparators.
	self assertChunkIsWellFormed: stream nextChunk.
	self assertMethodChunkIsWellFormed: stream nextChunk.
	self assert: stream nextChunk isAllSeparators 
%
run
MCStWriterTest setStamp: 'cwp 8/9/2003 14:52' forMethod: #testMethodDefinitionWithBangs.
true
%

category: 'testing'
method: MCStWriterTest
testOrganizationDefinition
	| definition |
	definition := MCOrganizationDefinition categories: 
					(self mockPackage packageInfo systemCategories).
	writer visitOrganizationDefinition: definition.
	self assertContentsOf: stream match: self expectedOrganizationDefinition.
	self assertAllChunksAreWellFormed.
%
run
MCStWriterTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testOrganizationDefinition.
true
%

category: 'as yet unclassified'
classmethod: MCTestCase
isAbstract
	^ self = MCTestCase
%
run
MCTestCase class setStamp: 'cwp 7/14/2003 15:12' forMethod: #isAbstract.
true
%

category: 'testing'
classmethod: MCTestCase
isUnitTest
	^false
%
run
MCTestCase class setStamp: 'JorgeRessia 3/16/2010 20:23' forMethod: #isUnitTest.
true
%

category: 'as yet unclassified'
classmethod: MCTestCase
resources
	^ Array with: MCSnapshotResource
%
run
MCTestCase class setStamp: 'cwp 7/14/2003 15:05' forMethod: #resources.
true
%

category: 'asserting'
method: MCTestCase
assertPackage: actual matches: expected
	self assert: actual = expected

%
run
MCTestCase setStamp: 'cwp 8/8/2003 14:58' forMethod: #assertPackage:matches:.
true
%

category: 'asserting'
method: MCTestCase
assertSnapshot: actual matches: expected
	| diff |
	diff := actual patchRelativeToBase: expected.
	self assert: diff isEmpty

%
run
MCTestCase setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertSnapshot:matches:.
true
%

category: 'asserting'
method: MCTestCase
assertVersion: actual matches: expected
	self assertPackage: actual package matches: expected package.	
	self assertVersionInfo: actual info matches: expected info.
	self assertSnapshot: actual snapshot matches: expected snapshot.
%
run
MCTestCase setStamp: 'cwp 8/8/2003 14:58' forMethod: #assertVersion:matches:.
true
%

category: 'asserting'
method: MCTestCase
assertVersionInfo: actual matches: expected
	self assert: actual name asString = expected name asString.
	self assert: actual message = expected message.
	self assert: actual ancestors size = expected ancestors size.
	actual ancestors with: expected ancestors do: [:a :e | self assertVersionInfo: a matches: e]
	
%
run
MCTestCase setStamp: 'DaleHenrichs 10/20/2010 13:15' forMethod: #assertVersionInfo:matches:.
true
%

category: 'compiling'
method: MCTestCase
change: aSelector toReturn: anObject
	self 
		compileClass: self mockClassA 
		source: aSelector, ' ^ ', anObject printString 
		category: 'numeric'
%
run
MCTestCase setStamp: 'cwp 8/10/2003 02:12' forMethod: #change:toReturn:.
true
%

category: 'mocks'
method: MCTestCase
commentForClass: name
	^ 'This is a comment for ', name
%
run
MCTestCase setStamp: 'cwp 8/10/2003 16:51' forMethod: #commentForClass:.
true
%

category: 'mocks'
method: MCTestCase
commentStampForClass: name
	^ 'tester-', name,  ' 1/1/2000 00:00'
%
run
MCTestCase setStamp: 'cwp 8/10/2003 16:53' forMethod: #commentStampForClass:.
true
%

category: 'compiling'
method: MCTestCase
compileClass: aClass source: source category: category
	aClass compileSilently: source classified: category
%
run
MCTestCase setStamp: 'abc 2/16/2006 09:24' forMethod: #compileClass:source:category:.
true
%

category: 'mocks'
method: MCTestCase
mockCategoryName
	^ 'Monticello-Mocks'
%
run
MCTestCase setStamp: 'ab 7/19/2003 15:43' forMethod: #mockCategoryName.
true
%

category: 'mocks'
method: MCTestCase
mockClass: className super: superclassName
	^ MCClassDefinition
		name:  className
		superclassName:  superclassName
		category: self mockCategoryName
		instVarNames: #()
		classVarNames: #()
		poolDictionaryNames: #()
		classInstVarNames: #()
		type: #normal
		comment: (self commentForClass: className)
		commentStamp: (self commentStampForClass: className)
%
run
MCTestCase setStamp: 'cwp 8/10/2003 16:50' forMethod: #mockClass:super:.
true
%

category: 'mocks'
method: MCTestCase
mockClassA
	^ MCPlatform current globalNamed: #MCMockClassA
%
run
MCTestCase setStamp: 'DaleHenrichs 10/1/2010 11:06' forMethod: #mockClassA.
true
%

category: 'mocks'
method: MCTestCase
mockClassB
	^ MCPlatform current globalNamed: #MCMockClassB
%
run
MCTestCase setStamp: 'DaleHenrichs 10/1/2010 11:06' forMethod: #mockClassB.
true
%

category: 'mocks'
method: MCTestCase
mockDependencies
	^ Array with: (MCVersionDependency package: self mockEmptyPackage info: (self mockVersionInfo: 'x'))
%
run
MCTestCase setStamp: 'avi 1/19/2004 15:54' forMethod: #mockDependencies.
true
%

category: 'mocks'
method: MCTestCase
mockEmptyPackage
	^ MCPackage named: (MCEmptyPackageInfo new packageName)
%
run
MCTestCase setStamp: 'avi 2/22/2004 14:08' forMethod: #mockEmptyPackage.
true
%

category: 'mocks'
method: MCTestCase
mockExtensionMethodCategory
	^ MCMockPackageInfo new methodCategoryPrefix.
%
run
MCTestCase setStamp: 'avi 2/22/2004 13:56' forMethod: #mockExtensionMethodCategory.
true
%

category: 'mocks'
method: MCTestCase
mockInstanceA
	^ self mockClassA new
%
run
MCTestCase setStamp: 'cwp 8/10/2003 02:06' forMethod: #mockInstanceA.
true
%

category: 'mocks'
method: MCTestCase
mockMessageString
	^ 'A version generated for testing purposes.'
%
run
MCTestCase setStamp: 'cwp 7/30/2003 19:24' forMethod: #mockMessageString.
true
%

category: 'mocks'
method: MCTestCase
mockMethod: aSymbol class: className source: sourceString meta: aBoolean
	^ MCMethodDefinition
		className: className
		classIsMeta: aBoolean
		selector:  aSymbol
		category: 'as yet unclassified'
		timeStamp: ''
		source: sourceString
%
run
MCTestCase setStamp: 'ab 4/1/2003 02:02' forMethod: #mockMethod:class:source:meta:.
true
%

category: 'mocks'
method: MCTestCase
mockOverrideMethodCategory
	^ self mockExtensionMethodCategory, '-override'
%
run
MCTestCase setStamp: 'cwp 11/13/2003 13:24' forMethod: #mockOverrideMethodCategory.
true
%

category: 'mocks'
method: MCTestCase
mockPackage
	^ MCSnapshotResource mockPackage
%
run
MCTestCase setStamp: 'cwp 8/1/2003 20:27' forMethod: #mockPackage.
true
%

category: 'mocks'
method: MCTestCase
mockSnapshot
	^ MCSnapshotResource current snapshot
%
run
MCTestCase setStamp: 'cwp 7/14/2003 15:07' forMethod: #mockSnapshot.
true
%

category: 'mocks'
method: MCTestCase
mockToken: aSymbol
	^ MCMockDefinition token: aSymbol
%
run
MCTestCase setStamp: 'ab 1/15/2003 17:55' forMethod: #mockToken:.
true
%

category: 'mocks'
method: MCTestCase
mockVersion
	^ MCVersion 
		package: self mockPackage
		info: self mockVersionInfo
		snapshot: self mockSnapshot
%
run
MCTestCase setStamp: 'cwp 7/30/2003 19:23' forMethod: #mockVersion.
true
%

category: 'mocks'
method: MCTestCase
mockVersionInfo
	^ self treeFrom: #(d ((b ((a))) (c)))
%
run
MCTestCase setStamp: 'avi 2/12/2004 19:58' forMethod: #mockVersionInfo.
true
%

category: 'mocks'
method: MCTestCase
mockVersionInfo: tag 
	^ MCVersionInfo
		name: self mockVersionName, '-', tag asString
		id: UUID new
		message: self mockMessageString, '-', tag asString
		date: Date today
		time: Time now
		author: MCPlatform current authorFullName
		ancestors: #()

%
run
MCTestCase setStamp: 'DaleHenrichs 10/8/2010 12:26' forMethod: #mockVersionInfo:.
true
%

category: 'mocks'
method: MCTestCase
mockVersionInfoWithAncestor: aVersionInfo 
	^ MCVersionInfo
		name: aVersionInfo name, '-child'
		id: UUID new
		message: self mockMessageString
		date: Date today
		time: Time now
		author: MCPlatform current authorFullName
		ancestors: {aVersionInfo}

%
run
MCTestCase setStamp: 'DaleHenrichs 10/8/2010 12:26' forMethod: #mockVersionInfoWithAncestor:.
true
%

category: 'mocks'
method: MCTestCase
mockVersionName
	^ 'MonticelloTest-xxx.1'
%
run
MCTestCase setStamp: 'cwp 7/30/2003 19:25' forMethod: #mockVersionName.
true
%

category: 'mocks'
method: MCTestCase
mockVersionWithAncestor: aMCVersion 
	^ MCVersion
		package: self mockPackage
		info: (self mockVersionInfoWithAncestor: aMCVersion info)
		snapshot: self mockSnapshot
%
run
MCTestCase setStamp: 'cwp 11/6/2004 16:03' forMethod: #mockVersionWithAncestor:.
true
%

category: 'mocks'
method: MCTestCase
mockVersionWithDependencies
	^ MCVersion 
		package: self mockPackage
		info: self mockVersionInfo
		snapshot: self mockSnapshot
		dependencies: self mockDependencies
%
run
MCTestCase setStamp: 'avi 1/19/2004 15:15' forMethod: #mockVersionWithDependencies.
true
%

category: 'compiling'
method: MCTestCase
restoreMocks
	self mockSnapshot updatePackage: self mockPackage
%
run
MCTestCase setStamp: 'cwp 8/2/2003 15:05' forMethod: #restoreMocks.
true
%

category: 'mocks'
method: MCTestCase
treeFrom: anArray
	| name id |
	name := anArray first.
	id := '00000000-0000-0000-0000-0000000000', (name asString size = 1 ifTrue: [name asString, '0'] ifFalse: [name asString]).
	^ MCVersionInfo
		name: name
		id: (UUID fromString: id)
		message: ''
		date: nil
		time: nil
		author: ''
		ancestors: (anArray size > 1 ifTrue: [((anArray at: 2) collect: [:ea | self treeFrom: ea])] ifFalse: [#()])
%
run
MCTestCase setStamp: 'DaleHenrichs 9/29/2010 16:21' forMethod: #treeFrom:.
true
%

category: 'asserting'
method: MCVersionTest
assert: aSelector orders: sexpr as: array
	| expected |
	expected := OrderedCollection new.
	version := self versionFromTree: sexpr.
	version perform: aSelector with: [:ea | expected add: ea info name].
	self assert: expected asArray = array
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:32' forMethod: #assert:orders:as:.
true
%

category: 'asserting'
method: MCVersionTest
assert: aSelector orders: sexpr as: expected unresolved: unresolved
	| missing |
	missing := OrderedCollection new.
	version := self versionFromTree: sexpr.
	version 
		perform: aSelector 
		with: [:ea | visited add: ea info name]
		with: [:ea | missing add: ea name].
	self assert: visited asArray = expected.
	self assert: missing asArray = unresolved.
%
run
MCVersionTest setStamp: 'md 9/6/2005 18:41' forMethod: #assert:orders:as:unresolved:.
true
%

category: 'building'
method: MCVersionTest
dependencyFromTree: sexpr
	^ MCMockDependency fromTree: sexpr
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 12:29' forMethod: #dependencyFromTree:.
true
%

category: 'running'
method: MCVersionTest
setUp
	visited := OrderedCollection new.
%
run
MCVersionTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setUp.
true
%

category: 'tests'
method: MCVersionTest
testAllAvailablePostOrder
	self 
		assert: #allAvailableDependenciesDo: 
		orders: #(a ((b (d e)) c)) 
		as: #(d e b c)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:53' forMethod: #testAllAvailablePostOrder.
true
%

category: 'tests'
method: MCVersionTest
testAllMissing
	self 
		assert: #allDependenciesDo: 
		orders: #(a ((b (d e)) (c missing))) 
		as: #(d e b)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:50' forMethod: #testAllMissing.
true
%

category: 'tests'
method: MCVersionTest
testAllUnresolved
	self 
		assert: #allDependenciesDo:ifUnresolved: 
		orders: #(a ((b (d e)) (c missing)))
		as: #(d e b)
		unresolved: #(c)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:47' forMethod: #testAllUnresolved.
true
%

category: 'tests'
method: MCVersionTest
testDependencyOrder
	self 
		assert: #allDependenciesDo: 
		orders: #(a (b c)) 
		as: #(b c)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 13:55' forMethod: #testDependencyOrder.
true
%

category: 'tests'
method: MCVersionTest
testPostOrder
	self 
		assert: #allDependenciesDo: 
		orders: #(a ((b (d e)) c)) 
		as: #(d e b c)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:25' forMethod: #testPostOrder.
true
%

category: 'tests'
method: MCVersionTest
testWithAll
	self 
		assert: #withAllDependenciesDo: 
		orders: #(a ((b (d e)) c)) 
		as: #(d e b c a)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:22' forMethod: #testWithAll.
true
%

category: 'tests'
method: MCVersionTest
testWithAllMissing
	self 
		assert: #withAllDependenciesDo: 
		orders: #(a ((b (d e)) (c missing))) 
		as: #(d e b a)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:56' forMethod: #testWithAllMissing.
true
%

category: 'tests'
method: MCVersionTest
testWithAllUnresolved
	self 
		assert: #withAllDependenciesDo:ifUnresolved: 
		orders: #(a ((b (d e)) (c missing)))
		as: #(d e b a)
		unresolved: #(c)
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 14:29' forMethod: #testWithAllUnresolved.
true
%

category: 'building'
method: MCVersionTest
versionFromTree: sexpr
	^ (self dependencyFromTree: sexpr) resolve
%
run
MCVersionTest setStamp: 'cwp 11/7/2004 12:40' forMethod: #versionFromTree:.
true
%

category: 'asserting'
method: MCWorkingCopyTest
assertNameWhenSavingTo: aRepository is: aString
	| name |
	name := nil.
	[aRepository storeVersion: workingCopy newVersion]
		on: MCVersionNameAndMessageRequest
		do: [:n | name := n suggestedName. n resume: (Array with: name with: '')].
	self assert: name = aString
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #assertNameWhenSavingTo:is:.
true
%

category: 'asserting'
method: MCWorkingCopyTest
assertNumberWhenSavingTo: aRepository is: aNumber
	| name |
	name := nil.
	[aRepository storeVersion: workingCopy newVersion]
		on: MCVersionNameAndMessageRequest
		do: [:n | name := n suggestedName. n resume: (Array with: name with: '')].
	self assert: name = (self packageName, '-', MCPlatform current authorFullName, '.', aNumber asString)
%
run
MCWorkingCopyTest setStamp: 'DaleHenrichs 10/8/2010 12:29' forMethod: #assertNumberWhenSavingTo:is:.
true
%

category: 'actions'
method: MCWorkingCopyTest
basicMerge: aVersion
	aVersion merge
%
run
MCWorkingCopyTest setStamp: 'avi 2/13/2004 14:30' forMethod: #basicMerge:.
true
%

category: 'running'
method: MCWorkingCopyTest
clearPackageCache
	(MCPlatform current cacheRepository)
		removeVersionsMatching: 'MonticelloMocks*';
		removeVersionsMatching: 'MonticelloTest*';
		removeVersionsMatching: 'rev*';
		removeVersionsMatching: 'foo-*';
		removeVersionsMatching: 'foo2-*'
%
run
MCWorkingCopyTest setStamp: 'DaleHenrichs 10/20/2010 12:32' forMethod: #clearPackageCache.
true
%

category: 'accessing'
method: MCWorkingCopyTest
description
	^ self class name
%
run
MCWorkingCopyTest setStamp: 'ab 7/7/2003 18:02' forMethod: #description.
true
%

category: 'actions'
method: MCWorkingCopyTest
load: aVersion
	aVersion load
%
run
MCWorkingCopyTest setStamp: 'avi 1/24/2004 20:13' forMethod: #load:.
true
%

category: 'actions'
method: MCWorkingCopyTest
merge: aVersion
	[[self basicMerge: aVersion]
		on: MCMergeResolutionRequest do: [:n | n resume: true]]
			on: MCNoChangesException do: [:n | ]
%
run
MCWorkingCopyTest setStamp: 'jf 8/21/2003 20:22' forMethod: #merge:.
true
%

category: 'private'
method: MCWorkingCopyTest
packageName
	^ self mockPackage name
%
run
MCWorkingCopyTest setStamp: 'cwp 8/2/2003 15:03' forMethod: #packageName.
true
%

category: 'running'
method: MCWorkingCopyTest
setUp
	| repos1 repos2 |
	self clearPackageCache.
	repositoryGroup := MCRepositoryGroup new.
	repositoryGroup disableCache.
	workingCopy := MCWorkingCopy forPackage: self mockPackage.
	versions := Dictionary new.
	versions2 := Dictionary new.
	repos1 := MCDictionaryRepository new dictionary: versions.
	repos2 := MCDictionaryRepository new dictionary: versions2.
	repositoryGroup addRepository: repos1.
	repositoryGroup addRepository: repos2.
	MCRepositoryGroup default removeRepository: repos1; removeRepository: repos2.
	workingCopy repositoryGroup: repositoryGroup.
	savedName := MCPlatform current authorFullName.
	MCPlatform current authorFullName: 'abc'.
%
run
MCWorkingCopyTest setStamp: 'DaleHenrichs 10/8/2010 12:29' forMethod: #setUp.
true
%

category: 'actions'
method: MCWorkingCopyTest
snapshot
	| version |
	[version := workingCopy newVersion]
		on: MCVersionNameAndMessageRequest
		do: [:n | n resume: (Array with: n suggestedName with: '')].
	versions at: version info put: version.
	^ version
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #snapshot.
true
%

category: 'running'
method: MCWorkingCopyTest
tearDown
	workingCopy unregister.
	self restoreMocks.
	self clearPackageCache.
	MCPlatform current authorFullName: savedName.
%
run
MCWorkingCopyTest setStamp: 'DaleHenrichs 10/8/2010 12:29' forMethod: #tearDown.
true
%

category: 'tests'
method: MCWorkingCopyTest
testAncestorMerge
	| base revA revB revC |

	base := self snapshot.
	self change: #a toReturn: 'a1'.
	revA :=  self snapshot.
	self change: #b toReturn: 'b1'.
	revB :=  self snapshot.	
	self change: #c toReturn: 'c1'.
	revC :=  self snapshot.	

	self should: [self basicMerge: revA] raise: MCNoChangesException.
	
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testAncestorMerge.
true
%

category: 'tests'
method: MCWorkingCopyTest
testBackport
	| inst base final backported |
	inst := self mockInstanceA.
	base :=  self snapshot.
	self assert: inst one = 1.
	self change: #one toReturn: 2.
	self change: #two toReturn: 3.
	final := self snapshot.
	[workingCopy backportChangesTo: base info]
		on: MCChangeSelectionRequest
		do: [:e | e resume: e patch].
	self assert: inst one = 2.
	self assert: inst two = 3.
	self assert: workingCopy ancestry ancestors size = 1.
	self assert: workingCopy ancestry ancestors first = base info.
	self assert: workingCopy ancestry stepChildren size = 1.
	self assert: workingCopy ancestry stepChildren first = final info.
	backported := self snapshot.
	[workingCopy backportChangesTo: base info]
		on: MCChangeSelectionRequest
		do: [:e | e resume: e patch].
	self assert: workingCopy ancestry ancestors size = 1.
	self assert: workingCopy ancestry ancestors first = base info.
	self assert: workingCopy ancestry stepChildren size = 1.
	self assert: workingCopy ancestry stepChildren first = backported info.
	
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testBackport.
true
%

category: 'tests'
method: MCWorkingCopyTest
testDoubleRepeatedMerge
	| base motherA1 motherA2 motherB1 motherB2 inst |

	base := self snapshot.
	self change: #a toReturn: 'a1'.
	motherA1 :=  self snapshot.
	self change: #c toReturn: 'c1'.
	motherA2 :=  self snapshot.	
	
	self load: base.
	self change: #b toReturn: 'b1'.
	motherB1 :=  self snapshot.
	self change: #d toReturn: 'd1'.
	motherB2 :=  self snapshot.
	
	self load: base.
	self merge: motherA1.
	self merge: motherB1.
	self change: #a toReturn: 'a2'.
	self change: #b toReturn: 'b2'.
	self snapshot.

	self shouldnt: [self merge: motherA2] raise: Error.
	self shouldnt: [self merge: motherB2] raise: Error.
	
	inst := self mockInstanceA.
	self assert: inst a = 'a2'.
	self assert: inst b = 'b2'.
	self assert: inst c = 'c1'.
	self assert: inst d = 'd1'.
	
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testDoubleRepeatedMerge.
true
%

category: 'tests'
method: MCWorkingCopyTest
testMergeIntoImageWithNoChanges
	| base revB revA1 |

	self change: #a toReturn: 'a'.
	base := self snapshot.
	self change: #b toReturn: 'b'.
	revB := self snapshot.
	
	self load: base.
	self change: #a toReturn: 'a1'.
	revA1 := self snapshot.

	self change: #a toReturn: 'a'.
	self snapshot.
	self merge: revB.

	self assert: (workingCopy ancestors size = 2)
	
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMergeIntoImageWithNoChanges.
true
%

category: 'tests'
method: MCWorkingCopyTest
testMergeIntoUnmodifiedImage
	| base revA |

	base := self snapshot.
	self change: #a toReturn: 'a1'.
	revA := self snapshot.
	
	self load: base.

	self merge: revA.

	self assert: (workingCopy ancestors size = 1)
	
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testMergeIntoUnmodifiedImage.
true
%

category: 'tests'
method: MCWorkingCopyTest
testNaming
	| repos version |

	repos := MCDictionaryRepository new.
	self assertNameWhenSavingTo: repos is: self packageName, '-abc.1'.
	self assertNameWhenSavingTo: repos is: self packageName, '-abc.2'.
	repos := MCDictionaryRepository new.
	self assertNameWhenSavingTo: repos is: self packageName, '-abc.3'.
	version := self snapshot.
	version info instVarNamed: 'name' put: 'foo-jf.32'.
	version load.
	self assertNameWhenSavingTo: repos is: 'foo-abc.33'.
	self assertNameWhenSavingTo: repos is: 'foo-abc.34'.
	version info instVarNamed: 'name' put: 'foo-abc.35'.
	repos storeVersion: version.
	self assertNameWhenSavingTo: repos is: 'foo-abc.36'.
	self assertNameWhenSavingTo: repos is: 'foo-abc.37'.
	version info instVarNamed: 'name' put: 'foo-abc.10'.
	repos storeVersion: version.
	self assertNameWhenSavingTo: repos is: 'foo-abc.38'.
	version info instVarNamed: 'name' put: 'foo2-ab.40'.
	version load.
	self assertNameWhenSavingTo: repos is: 'foo2-abc.41'.
%
run
MCWorkingCopyTest setStamp: 'bf 5/20/2005 18:25' forMethod: #testNaming.
true
%

category: 'tests'
method: MCWorkingCopyTest
testOptimizedLoad
	| inst base diffy |
	inst := self mockInstanceA.
	base := self snapshot.
	self change: #one toReturn: 2.
	self assert: inst one = 2.
	diffy := self snapshot asDiffAgainst: base.
	self deny: diffy canOptimizeLoading.
	self load: base.
	self assert: inst one = 1.
	self assert: diffy canOptimizeLoading.
	self load: diffy.
	self assert: inst one = 2.

%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testOptimizedLoad.
true
%

category: 'tests'
method: MCWorkingCopyTest
testRedundantMerge
	| base |
	base :=  self snapshot.
	self merge: base.
	self shouldnt: [self merge: base] raise: Error.
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testRedundantMerge.
true
%

category: 'tests'
method: MCWorkingCopyTest
testRepeatedMerge
	| base mother1 mother2 inst |

	base :=  self snapshot.
	self change: #one toReturn: 2.
	mother1 :=  self snapshot.
	self change: #two toReturn: 3.
	mother2 :=  self snapshot.	
	
	self load: base.
	self change: #truth toReturn: false.
	self snapshot.

	inst := self mockInstanceA.
	self assert: inst one = 1.
	self assert: inst two = 2.	

	self merge: mother1.
	self assert: inst one = 2.
	self assert: inst two = 2.	
	
	self change: #one toReturn: 7.
	self assert: inst one = 7.
	self assert: inst two = 2.
	
	self shouldnt: [self merge: mother2] raise: Error.
	self assert: inst one = 7.
	self assert: inst two = 3.
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testRepeatedMerge.
true
%

category: 'tests'
method: MCWorkingCopyTest
testRepositoryFallback
	| version |
	version := self snapshot.
	self assert: (repositoryGroup versionWithInfo: version info) == version.
	versions removeKey: version info.
	versions2 at: version info put: version.
	self assert: ( repositoryGroup versionWithInfo: version info) == version.
	versions2 removeKey: version info.
	self should: [repositoryGroup versionWithInfo: version info] raise: Error.
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testRepositoryFallback.
true
%

category: 'tests'
method: MCWorkingCopyTest
testSelectiveBackport
	| inst base intermediate final |
	inst := self mockInstanceA.
	base :=  self snapshot.
	self assert: inst one = 1.
	self change: #one toReturn: 2.
	intermediate := self snapshot.
	self change: #two toReturn: 3.
	final := self snapshot.
	[workingCopy backportChangesTo: base info]
		on: MCChangeSelectionRequest
		do: [:e | | patch selected |
			patch := e patch.
			selected := patch operations select: [:ea | ea definition selector = #two].
			e resume: (MCPatch operations: selected)]. 
	self assert: inst one = 1.
	self assert: inst two = 3.
	self assert: workingCopy ancestry ancestors size = 1.
	self assert: workingCopy ancestry ancestors first = base info.
	self assert: workingCopy ancestry stepChildren size = 1.
	self assert: workingCopy ancestry stepChildren first = final info
%
run
MCWorkingCopyTest setStamp: 'nice 1/5/2010 15:59' forMethod: #testSelectiveBackport.
true
%

category: 'tests'
method: MCWorkingCopyTest
testSimpleMerge
	| mother base inst |
	inst := self mockInstanceA.
	base :=  self snapshot.
	self change: #one toReturn: 2.
	mother :=  self snapshot.
	self load: base.
	self change: #two toReturn: 3.
	self snapshot.
	self assert: inst one = 1.
	self assert: inst two = 3.
	
	self merge: mother.
	self assert: inst one = 2.
	self assert: inst two = 3.
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testSimpleMerge.
true
%

category: 'tests'
method: MCWorkingCopyTest
testSnapshotAndLoad
	| base inst |
	inst := self mockInstanceA.
	base :=  self snapshot.
	self change: #one toReturn: 2.
	self assert: inst one = 2.
	self load: base.
	self assert: inst one = 1.
%
run
MCWorkingCopyTest setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #testSnapshotAndLoad.
true
%

category: 'Coverage'
method: TimeStampTest
classToBeTested

	^ self timestampClass
%
run
TimeStampTest setStamp: 'brp 7/27/2003 13:50' forMethod: #classToBeTested.
true
%

category: 'Coverage'
method: TimeStampTest
selectorsToBeIgnored

	| deprecated private special |

	deprecated := #().
	private := #( #printOn: ).
	special := #().

	^ super selectorsToBeIgnored, deprecated, private, special.
%
run
TimeStampTest setStamp: 'brp 1/30/2005 09:13' forMethod: #selectorsToBeIgnored.
true
%

category: 'Running'
method: TimeStampTest
setUp

	timestamp := self timestampClass date: (Date readFrom: (ReadStream on: '1-10-2000')) time: (Time readFrom: (ReadStream on: '11:55:00 am')).

	aTimeStamp := TimeStamp fromString: '1-02-2004 12:34:56 am'
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:14' forMethod: #setUp.
true
%

category: 'Running'
method: TimeStampTest
tearDown

	timestamp := nil.
%
run
TimeStampTest setStamp: 'brp 7/26/2003 21:53' forMethod: #tearDown.
true
%

category: 'Tests'
method: TimeStampTest
testAccessing

	| d t |
	d := Date readFrom: (ReadStream on: '1-10-2000').
	t := Time readFrom: (ReadStream on: '11:55:00 am').

	self
		assert: timestamp date = d;
		assert: timestamp time = t.

%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:20' forMethod: #testAccessing.
true
%

category: 'Tests'
method: TimeStampTest
testArithmetic

	| ts |
	ts := timestamp minusDays: 123.  	"9 September 1999, 11:55 am"
	ts := ts minusSeconds: 1056.			"9 September 1999, 11:37:24 am"
	ts := ts plusDays: 123.				"10 January 2000, 11:37:24 am"
	ts := ts plusSeconds: 1056.			"10 January 2000, 11:55 am"
	self
		assert: ts  = timestamp.

	
%
run
TimeStampTest setStamp: 'brp 7/26/2003 22:05' forMethod: #testArithmetic.
true
%

category: 'Tests'
method: TimeStampTest
testArithmeticAcrossDateBoundary

	| ts |
	ts := timestamp minusSeconds: ((11*3600) + (55*60) + 1).
	self
		assert: ts = (TimeStamp fromString: '1-9-2000 11:59:59 pm').

	
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:48' forMethod: #testArithmeticAcrossDateBoundary.
true
%

category: 'Tests'
method: TimeStampTest
testComparing

	| ts1 ts2 ts3 c1 c2 le |
	ts1 := self timestampClass date: (Date readFrom: (ReadStream on: '01-10-2000')) time: (Time readFrom: (ReadStream on: '11:55:00 am')).
	ts2 := self timestampClass date: (Date readFrom: (ReadStream on: '07-26-2003')) time: (Time readFrom: (ReadStream on: '22:09:45 am')).
	ts3 := self timestampClass date: (Date readFrom: (ReadStream on: '05-28-1972')) time: (Time readFrom: (ReadStream on: '04:31:14 pm')).

	self
		assert: ts1 = timestamp;
		assert: ts1 hash = timestamp hash;
		assert: timestamp = timestamp copy;
		assert: ts1 < ts2;
		deny: ts1 < ts3.

	c1 := self timestampClass current.
	c2 := self timestampClass current.
	le := (c1 <= c2).
	self assert: le.


%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:21' forMethod: #testComparing.
true
%

category: 'Tests'
method: TimeStampTest
testConverting

	| d t |
	d := Date readFrom: (ReadStream on: '1-10-2000').
	t := Time readFrom: (ReadStream on: '11:55:00 am').

	self
		"assert: timestamp asSeconds = (d asSeconds + t asSeconds);"
		assert: timestamp asDate = d;
		assert: timestamp asTime = t;
		assert: timestamp asTimeStamp == timestamp;
		assert: timestamp dateAndTime = {d. t}.

%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:47' forMethod: #testConverting.
true
%

category: 'testing'
method: TimeStampTest
testDate
	self assert: aTimeStamp date = (Date readFrom: (ReadStream on: '01-02-2004'))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:22' forMethod: #testDate.
true
%

category: 'testing'
method: TimeStampTest
testDateAndTime
	self assert: aTimeStamp dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-02-2004')) with: (Time readFrom: (ReadStream on: '00:34:56')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:22' forMethod: #testDateAndTime.
true
%

category: 'Tests'
method: TimeStampTest
testFromString
	"This should signal an exception in 3.6beta as Time>>fromString: does not exist."

	self should: [ timestamp = (self timestampClass fromString: '1-10-2000 11:55:00 am') ] 


%
run
TimeStampTest setStamp: 'brp 8/23/2003 15:02' forMethod: #testFromString.
true
%

category: 'testing'
method: TimeStampTest
testGemStoneStoreOn
	| cs rw |
	cs := ReadStream on: '''02 January 2004 12:34:56 am'' asTimeStamp' .
	rw := ReadWriteStream on: String new.
	aTimeStamp storeOn: rw.
	self assert: rw contents = cs contents
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 15:49' forMethod: #testGemStoneStoreOn.
true
%

category: 'testing'
method: TimeStampTest
testGemstonePrintOn
	| cs rw |
	cs := ReadStream on: '02 January 2004 12:34:56 am'.
	rw := ReadWriteStream on: String new.
	aTimeStamp printOn: rw.
	self assert: rw contents = cs contents
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 15:48' forMethod: #testGemstonePrintOn.
true
%

category: 'testing'
method: TimeStampTest
testMinusDays
	self assert: (aTimeStamp minusDays: 5) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '12-28-2003')) with: (Time readFrom: (ReadStream on: '00:34:56')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:23' forMethod: #testMinusDays.
true
%

category: 'testing'
method: TimeStampTest
testMinusSeconds
	self assert: (aTimeStamp minusSeconds: 34 * 60 + 56) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-02-2004')) with: (Time readFrom: (ReadStream on: '00:00:00')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:23' forMethod: #testMinusSeconds.
true
%

category: 'testing'
method: TimeStampTest
testMinusSecondsOverMidnight
	self assert: (aTimeStamp minusSeconds: 34 * 60 + 57) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-01-2004')) with: (Time readFrom: (ReadStream on: '23:59:59')))
	"Bug The results are actual results are: #(1 January 2005 11:25:03 pm)"
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:23' forMethod: #testMinusSecondsOverMidnight.
true
%

category: 'testing'
method: TimeStampTest
testPlusDays
	self assert: (aTimeStamp plusDays: 366) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-02-2005')) with: (Time readFrom: (ReadStream on: '00:34:56')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:24' forMethod: #testPlusDays.
true
%

category: 'testing'
method: TimeStampTest
testPlusSeconds
	self assert: (aTimeStamp plusSeconds: 60 * 60 ) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-02-2004')) with: (Time readFrom: (ReadStream on: '01:34:56')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:24' forMethod: #testPlusSeconds.
true
%

category: 'testing'
method: TimeStampTest
testPlusSecondsOverMidnight
	self assert: (aTimeStamp plusSeconds: 24 * 60 * 60 + 1) dateAndTime
			= (Array with: (Date readFrom: (ReadStream on: '01-03-2004')) with: (Time readFrom: (ReadStream on: '00:34:57')))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:24' forMethod: #testPlusSecondsOverMidnight.
true
%

category: 'Tests'
method: TimeStampTest
testPrinting

	self	
		assert: timestamp printString = '10 January 2000 11:55 am'.

%
run
TimeStampTest setStamp: 'brp 8/23/2003 15:02' forMethod: #testPrinting.
true
%

category: 'testing'
method: TimeStampTest
testReadFromA1
	|ts|
	ts := TimeStamp current.
 	self assert: (ts = (TimeStamp fromString: ts printString)).
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:54' forMethod: #testReadFromA1.
true
%

category: 'Tests'
method: TimeStampTest
testSorting

	| c1 c2 |
	c1 := self timestampClass current.
	c2 := self timestampClass current.

	self
		assert: (self timestampClass current) <= (self timestampClass current);
		assert: (c1 <= c2).



%
run
TimeStampTest setStamp: 'brp 8/23/2003 17:47' forMethod: #testSorting.
true
%

category: 'testing'
method: TimeStampTest
testTime
	self assert: aTimeStamp time =  (Time readFrom: (ReadStream on: '00:34:56'))
%
run
TimeStampTest setStamp: 'DaleHenrichs 10/8/2010 14:26' forMethod: #testTime.
true
%

category: 'testing'
method: TimeStampTest
testTimeStamp
	self assert: aTimeStamp = aTimeStamp asTimeStamp

%
run
TimeStampTest setStamp: 'brp 1/21/2004 18:41' forMethod: #testTimeStamp.
true
%

category: 'Private'
method: TimeStampTest
timestampClass

	^ TimeStamp
%
run
TimeStampTest setStamp: 'brp 7/27/2003 13:50' forMethod: #timestampClass.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreation
	| uuid |
	uuid := UUID new.
	self should: [uuid size = 16].
	self shouldnt: [uuid isNilUUID].
	self should: [uuid asString size = 36].

%
run
UUIDPrimitivesTest setStamp: 'JMM 11/22/2001 17:14' forMethod: #testCreation.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationEquality
	| uuid1 uuid2 |
	uuid1 := UUID new.
	uuid2 := UUID new.
	self should: [uuid1 = uuid1].
	self should: [uuid2 = uuid2].
	self shouldnt: [uuid1 = uuid2].
	self shouldnt: [uuid1 hash = uuid2 hash].

%
run
UUIDPrimitivesTest setStamp: 'JMM 11/22/2001 17:27' forMethod: #testCreationEquality.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationFromComplexString
	| uuid string |
	string := '00000000-0000-0000-0000-0000000000c1'.
	uuid := UUID fromString: string.
	self should: [uuid size = 16].
	self should: [uuid asString size = 36].
	self should: [uuid asString  = string].
	self shouldnt: [uuid asString = (string asUppercase)].
	self should: [uuid asArray asSet size = 2].
	self should: [(uuid asArray asSet asArray at: 1) = 0].

%
run
UUIDPrimitivesTest setStamp: 'DaleHenrichs 9/30/2010 17:09' forMethod: #testCreationFromComplexString.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationFromString
	| uuid string |
	string := UUID nilUUID asString.
	uuid := UUID fromString: string.
	self should: [uuid size = 16].
	self should: [uuid = UUID nilUUID].
	self should: [uuid isNilUUID].
	self should: [uuid asString size = 36].
	self should: [uuid asArray asSet size = 1].
	self should: [(uuid asArray asSet asArray at: 1) = 0].

%
run
UUIDPrimitivesTest setStamp: 'JMM 11/22/2001 17:17' forMethod: #testCreationFromString.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationFromStringNotNil
	| uuid string |
	string := UUID new asString.
	uuid := UUID fromString: string.
	self should: [uuid size = 16].
	self should: [uuid asString size = 36].


%
run
UUIDPrimitivesTest setStamp: 'JMM 11/22/2001 17:18' forMethod: #testCreationFromStringNotNil.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationNil
	| uuid |
	uuid := UUID nilUUID.
	self should: [uuid size = 16].
	self should: [uuid isNilUUID].
	self should: [uuid asString size = 36].
	self should: [uuid asArray asSet size = 1].
	self should: [(uuid asArray asSet asArray at: 1) = 0].

%
run
UUIDPrimitivesTest setStamp: 'JMM 11/22/2001 17:16' forMethod: #testCreationNil.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testCreationNodeBased

	| str1 str2 sz1 sz2 |
	str1 := UUID new asString.
	sz1 := str1 size.
	str2 := UUID new asString.
	sz2 := str2 size.
	(str1 copyFrom: sz1 - 12 + 1 to: sz1) = (str2 copyFrom: sz2 - 12 + 1 to: sz2)
		ifFalse: [ ^ self ].
	1000
		timesRepeat: [ 
			| uuid |
			uuid := UUID new.
			self should: [ ((uuid at: 7) bitAnd: 16rF0) = 16r10 ].
			self should: [ ((uuid at: 9) bitAnd: 16rC0) = 16r80 ] ]
%
run
UUIDPrimitivesTest setStamp: 'DaleHenrichs 9/30/2010 16:39' forMethod: #testCreationNodeBased.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testDuplicationsKinda
	| check size uuid |
	size := 5000.
	check := Set new: size.
	size timesRepeat: 
		[ uuid := UUID new.
		self shouldnt: [check includes: uuid].
		check add: uuid].
		
%
run
UUIDPrimitivesTest setStamp: 'nice 1/5/2010 15:59' forMethod: #testDuplicationsKinda.
true
%

category: 'tests'
method: UUIDPrimitivesTest
testOrder
	| str1 sz1 str2 sz2 uuid1 uuid2 |
	100
		timesRepeat: [ 
			uuid1 := UUID new.
			str1 := uuid1 asString.
			sz1 := str1 size.
			uuid2 := UUID new.
			str2 := uuid2 asString.
			sz2 := str2 size.
			(str1 copyFrom: sz1 - 12 + 1 to: sz1) = (str2 copyFrom: sz2 - 12 + 1 to: sz2)
				ifTrue: [ 
					self should: [ uuid1 < uuid2 ].
					self should: [ uuid2 > uuid1 ].
					self shouldnt: [ uuid1 = uuid2 ] ] ]
%
run
UUIDPrimitivesTest setStamp: 'DaleHenrichs 9/30/2010 16:41' forMethod: #testOrder.
true
%

category: 'instance creation'
classmethod: MCAncestry
new

	^ self basicNew initialize

%
run
MCAncestry class setStamp: 'DaleHenrichs 9/29/2010 16:28' forMethod: #new.
true
%

category: 'ancestry'
method: MCAncestry
allAncestorsDo: aBlock
	self ancestors do:
		[:ea |
		aBlock value: ea.
		ea allAncestorsDo: aBlock]
%
run
MCAncestry setStamp: 'avi 2/12/2004 20:57' forMethod: #allAncestorsDo:.
true
%

category: 'ancestry'
method: MCAncestry
allAncestorsOnPathTo: aVersionInfo
	^ MCFilteredVersionSorter new
		target: aVersionInfo;
		addAllVersionInfos: self ancestors;
		sortedVersionInfos
%
run
MCAncestry setStamp: 'avi 2/12/2004 20:57' forMethod: #allAncestorsOnPathTo:.
true
%

category: 'ancestry'
method: MCAncestry
ancestorString
	^ String streamContents:
		[:s | self ancestors do: [:ea | s nextPutAll: ea name] separatedBy: [s nextPutAll: ', ']]
%
run
MCAncestry setStamp: 'avi 2/12/2004 20:57' forMethod: #ancestorString.
true
%

category: 'ancestry'
method: MCAncestry
ancestors
	^ ancestors ifNil: [#()]
%
run
MCAncestry setStamp: 'avi 2/12/2004 20:57' forMethod: #ancestors.
true
%

category: 'ancestry'
method: MCAncestry
ancestorsDoWhileTrue: aBlock
	self ancestors do:
		[:ea |
		(aBlock value: ea) ifTrue: 
			[ea ancestorsDoWhileTrue: aBlock]]
%
run
MCAncestry setStamp: 'bf 12/22/2004 21:55' forMethod: #ancestorsDoWhileTrue:.
true
%

category: 'ancestry'
method: MCAncestry
breadthFirstAncestors
	^ Array streamContents: [:s | self breadthFirstAncestorsDo: [:ea | s nextPut: ea]]
%
run
MCAncestry setStamp: 'avi 9/17/2005 16:03' forMethod: #breadthFirstAncestors.
true
%

category: 'ancestry'
method: MCAncestry
breadthFirstAncestorsDo: aBlock
	| seen todo next |
	seen := Set with: self.
	todo := OrderedCollection with: self.
	[todo isEmpty] whileFalse:
		[next := todo removeFirst.
		next ancestors do:
			[:ea |
			(seen includes: ea) ifFalse:
				[aBlock value: ea.
				seen add: ea.
				todo add: ea]]]
%
run
MCAncestry setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #breadthFirstAncestorsDo:.
true
%

category: 'ancestry'
method: MCAncestry
commonAncestorWith: aNode
	| commonAncestors |
	commonAncestors := self commonAncestorsWith: aNode.
	commonAncestors isEmpty ifTrue: [ ^nil ].
	^ commonAncestors at: 1
%
run
MCAncestry setStamp: 'DaleHenrichs 9/30/2010 15:11' forMethod: #commonAncestorWith:.
true
%

category: 'ancestry'
method: MCAncestry
commonAncestorsWith: aVersionInfo

	| sharedAncestors mergedOrder sorter ancs |
	sorter := MCVersionSorter new
						addVersionInfo: self;
						addVersionInfo: aVersionInfo.
	mergedOrder := sorter sortedVersionInfos.
	ancs := sorter allAncestorsOf: aVersionInfo.
	sharedAncestors := (sorter allAncestorsOf: self) select: [:each | ancs includes: each].
	^ mergedOrder select: [:ea | sharedAncestors includes: ea]
%
run
MCAncestry setStamp: 'DaleHenrichs 9/30/2010 15:09' forMethod: #commonAncestorsWith:.
true
%

category: 'ancestry'
method: MCAncestry
hasAncestor: aVersionInfo
	^ self
		hasAncestor: aVersionInfo
		alreadySeen: OrderedCollection new
%
run
MCAncestry setStamp: 'jrp 7/12/2004 08:16' forMethod: #hasAncestor:.
true
%

category: 'ancestry'
method: MCAncestry
hasAncestor: aVersionInfo alreadySeen: aList
	(aList includes: self) ifTrue: [^ false].
	aList add: self.

	^ self = aVersionInfo or: [self ancestors anySatisfy: [:ea | ea hasAncestor: aVersionInfo alreadySeen: aList]]

%
run
MCAncestry setStamp: 'jrp 7/12/2004 08:16' forMethod: #hasAncestor:alreadySeen:.
true
%

category: 'initializing'
method: MCAncestry
initialize
	ancestors := #().
	stepChildren := #()
%
run
MCAncestry setStamp: 'DaleHenrichs 9/29/2010 16:30' forMethod: #initialize.
true
%

category: 'ancestry'
method: MCAncestry
isRelatedTo: aVersionInfo
	^ aVersionInfo timeStamp < self timeStamp
		ifTrue: [self hasAncestor: aVersionInfo]
		ifFalse: [aVersionInfo hasAncestor: self]
%
run
MCAncestry setStamp: 'avi 2/12/2004 20:58' forMethod: #isRelatedTo:.
true
%

category: 'ancestry'
method: MCAncestry
stepChildren
	^ stepChildren ifNil: [#()]
%
run
MCAncestry setStamp: 'avi 9/11/2004 15:08' forMethod: #stepChildren.
true
%

category: 'ancestry'
method: MCAncestry
stepChildrenString
	^ String streamContents:
		[:s | self stepChildren do: [:ea | s nextPutAll: ea name] separatedBy: [s nextPutAll: ', ']]
%
run
MCAncestry setStamp: 'avi 9/14/2004 15:21' forMethod: #stepChildrenString.
true
%

category: 'ancestry'
method: MCAncestry
topologicalAncestors
	
	^ Array streamContents:
		[:s | | f frontier |
		frontier := MCFrontier frontierOn: self.
		[f := frontier frontier.
		s nextPutAll: f.
		frontier removeAll: f.
		f isEmpty] whileFalse] 
%
run
MCAncestry setStamp: 'nice 1/5/2010 15:59' forMethod: #topologicalAncestors.
true
%

category: 'ancestry'
method: MCAncestry
withBreadthFirstAncestors
	^ (Array with: self), self breadthFirstAncestors
%
run
MCAncestry setStamp: 'avi 9/17/2005 16:03' forMethod: #withBreadthFirstAncestors.
true
%

category: 'as yet unclassified'
classmethod: MCVersionInfo
name: vName id: id message: message date: date time: time author: author ancestors: ancestors
	^ self 
		name: vName
		id: id
		message: message
		date: date
		time: time
		author: author
		ancestors: ancestors
		stepChildren: #()
%
run
MCVersionInfo class setStamp: 'avi 9/11/2004 10:44' forMethod: #name:id:message:date:time:author:ancestors:.
true
%

category: 'as yet unclassified'
classmethod: MCVersionInfo
name: vName id: id message: message date: date time: time author: author ancestors: ancestors stepChildren: stepChildren
	^ self new
		initializeWithName: vName
		id: id
		message: message
		date: date
		time: time
		author: author
		ancestors: ancestors
		stepChildren: stepChildren
%
run
MCVersionInfo class setStamp: 'avi 9/11/2004 10:43' forMethod: #name:id:message:date:time:author:ancestors:stepChildren:.
true
%

category: 'comparing'
method: MCVersionInfo
= other
	^ other species = self species
		and: [other hasID: id]
%
run
MCVersionInfo setStamp: 'ab 7/5/2003 14:23' forMethod: #=.
true
%

category: 'converting'
method: MCVersionInfo
asDictionary
	^ Dictionary new
		at: #name put: name;
		at: #id put: id;
		at: #message put: message;
		at: #date put: date;
		at: #time put: time;
		at: #author put: author;
		at: #ancestors put: (self ancestors collect: [:a | a asDictionary]);
		yourself
%
run
MCVersionInfo setStamp: 'nk 1/23/2004 21:09' forMethod: #asDictionary.
true
%

category: 'pillaging'
method: MCVersionInfo
author
	^ author
%
run
MCVersionInfo setStamp: 'cwp 8/1/2003 00:26' forMethod: #author.
true
%

category: 'pillaging'
method: MCVersionInfo
date
	^ date
%
run
MCVersionInfo setStamp: 'cwp 8/1/2003 00:26' forMethod: #date.
true
%

category: 'private'
method: MCVersionInfo
hasID: aUUID
	^ id = aUUID
%
run
MCVersionInfo setStamp: 'ab 7/5/2003 14:10' forMethod: #hasID:.
true
%

category: 'comparing'
method: MCVersionInfo
hash
	^ id hash
%
run
MCVersionInfo setStamp: 'ab 7/5/2003 14:09' forMethod: #hash.
true
%

category: 'pillaging'
method: MCVersionInfo
id
	^ id 
%
run
MCVersionInfo setStamp: 'cwp 8/1/2003 00:24' forMethod: #id.
true
%

category: 'initialization'
method: MCVersionInfo
initializeWithName: vName id: aUUID message: aString date: aDate time: aTime author: initials ancestors: aCollection stepChildren: stepCollection
	name := vName.
	id := aUUID.
	message := aString.
	date := aDate.
	time := aTime.
	author := initials.
	ancestors :=  aCollection.
	stepChildren := stepCollection
%
run
MCVersionInfo setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithName:id:message:date:time:author:ancestors:stepChildren:.
true
%

category: 'accessing'
method: MCVersionInfo
message
	^ message ifNil: ['']
%
run
MCVersionInfo setStamp: 'ab 7/12/2003 00:04' forMethod: #message.
true
%

category: 'accessing'
method: MCVersionInfo
name
	^ name ifNil: ['<working copy>']
%
run
MCVersionInfo setStamp: 'ab 7/11/2003 23:33' forMethod: #name.
true
%

category: 'printing'
method: MCVersionInfo
printOn: aStream
	super printOn: aStream.
	aStream nextPut: $(; nextPutAll: self name; nextPut: $)
	
%
run
MCVersionInfo setStamp: 'ab 7/5/2003 18:00' forMethod: #printOn:.
true
%

category: 'accessing'
method: MCVersionInfo
summary
	^ String streamContents:
		[:s |
		s
			nextPutAll: self summaryHeader; cr; cr;
			nextPutAll: self message.
		]
%
run
MCVersionInfo setStamp: 'adrian_lienhard 1/7/2009 17:31' forMethod: #summary.
true
%

category: 'accessing'
method: MCVersionInfo
summaryHeader
	^ String streamContents:
		[:s |
		s
			nextPutAll: 'Name: '; nextPutAll: self name; cr.
		date ifNotNil:
			[s
				nextPutAll: 'Author: '; nextPutAll: author; cr;
				nextPutAll: 'Time: '; nextPutAll:  date asString, ', ', time asString; cr].
		id ifNotNil:
			[s nextPutAll: 'UUID: '; nextPutAll: id asString; cr].
		s
			nextPutAll: 'Ancestors: '; nextPutAll: self ancestorString.
		self stepChildren isEmpty ifFalse:
			[s cr; nextPutAll: 'Backported From: '; nextPutAll: self stepChildrenString].
		]
%
run
MCVersionInfo setStamp: 'avi 9/14/2004 15:22' forMethod: #summaryHeader.
true
%

category: 'pillaging'
method: MCVersionInfo
time
	^ time
%
run
MCVersionInfo setStamp: 'cwp 8/1/2003 00:26' forMethod: #time.
true
%

category: 'accessing'
method: MCVersionInfo
timeString
	^ date asString, ', ', time asString
%
run
MCVersionInfo setStamp: 'avi 9/17/2003 11:24' forMethod: #timeString.
true
%

category: 'as yet unclassified'
method: MCWorkingAncestry
addAncestor: aNode
	ancestors := (self ancestors reject: [:each | aNode hasAncestor: each])
		copyWith: aNode
%
run
MCWorkingAncestry setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addAncestor:.
true
%

category: 'as yet unclassified'
method: MCWorkingAncestry
addStepChild: aVersionInfo
	stepChildren := stepChildren copyWith: aVersionInfo
%
run
MCWorkingAncestry setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addStepChild:.
true
%

category: 'as yet unclassified'
method: MCWorkingAncestry
infoWithName: nameString message: messageString
	^ MCVersionInfo
		name: nameString
		id: UUID new
		message: messageString
		date: Date today
		time: Time now
		author: MCPlatform current authorFullName
		ancestors: ancestors asArray
		stepChildren: self stepChildren asArray
%
run
MCWorkingAncestry setStamp: 'DaleHenrichs 10/8/2010 12:26' forMethod: #infoWithName:message:.
true
%

category: 'as yet unclassified'
method: MCWorkingAncestry
name
	^ '<working copy>'
%
run
MCWorkingAncestry setStamp: 'avi 2/13/2004 01:14' forMethod: #name.
true
%

category: 'as yet unclassified'
method: MCWorkingAncestry
summary
	^ 'Ancestors: ', self ancestorString
%
run
MCWorkingAncestry setStamp: 'avi 2/13/2004 01:14' forMethod: #summary.
true
%

category: 'as yet unclassified'
classmethod: MCConflict
operation: anOperation
	^ self new operation: anOperation	
%
run
MCConflict class setStamp: 'ab 6/1/2003 13:07' forMethod: #operation:.
true
%

category: 'as yet unclassified'
method: MCConflict
applyTo: anObject
	self isResolved ifFalse: [self error: 'Cannot continue until this conflict has been resolved'].
	self remoteChosen ifTrue: [operation applyTo: anObject].
%
run
MCConflict setStamp: 'ab 6/1/2003 13:04' forMethod: #applyTo:.
true
%

category: 'as yet unclassified'
method: MCConflict
chooseLocal
	chooseRemote := false
%
run
MCConflict setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #chooseLocal.
true
%

category: 'as yet unclassified'
method: MCConflict
chooseNewer
	self isLocalNewer ifTrue: [ self chooseLocal ]
		ifFalse: [ self isRemoteNewer ifTrue: [ self chooseRemote ]]
%
run
MCConflict setStamp: 'nk 10/21/2003 23:16' forMethod: #chooseNewer.
true
%

category: 'as yet unclassified'
method: MCConflict
chooseOlder
	self isRemoteNewer ifTrue: [ self chooseLocal ]
		ifFalse: [ self isLocalNewer ifTrue: [ self chooseRemote ]]
%
run
MCConflict setStamp: 'nk 10/21/2003 23:22' forMethod: #chooseOlder.
true
%

category: 'as yet unclassified'
method: MCConflict
chooseRemote
	chooseRemote := true
%
run
MCConflict setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #chooseRemote.
true
%

category: 'as yet unclassified'
method: MCConflict
clearChoice
	chooseRemote := nil
%
run
MCConflict setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #clearChoice.
true
%

category: 'as yet unclassified'
method: MCConflict
definition
	^operation ~~ nil ifTrue: [ operation definition ]

%
run
MCConflict setStamp: 'DaleHenrichs 9/27/2010 15:50' forMethod: #definition.
true
%

category: 'as yet unclassified'
method: MCConflict
isConflict
	^true
%
run
MCConflict setStamp: 'dvf 8/10/2004 23:24' forMethod: #isConflict.
true
%

category: 'as yet unclassified'
method: MCConflict
isLocalNewer
	^ self localDefinition fullTimeStamp > self remoteDefinition fullTimeStamp
%
run
MCConflict setStamp: 'nk 10/21/2003 23:11' forMethod: #isLocalNewer.
true
%

category: 'as yet unclassified'
method: MCConflict
isRemoteNewer
	^ self localDefinition fullTimeStamp < self remoteDefinition fullTimeStamp
%
run
MCConflict setStamp: 'nk 10/21/2003 23:15' forMethod: #isRemoteNewer.
true
%

category: 'as yet unclassified'
method: MCConflict
isResolved
	^ chooseRemote notNil
%
run
MCConflict setStamp: 'ab 6/1/2003 13:02' forMethod: #isResolved.
true
%

category: 'as yet unclassified'
method: MCConflict
localChosen
	^ chooseRemote notNil and: [chooseRemote not]
%
run
MCConflict setStamp: 'ab 6/2/2003 01:45' forMethod: #localChosen.
true
%

category: 'as yet unclassified'
method: MCConflict
localDefinition
	^ operation baseDefinition
%
run
MCConflict setStamp: 'ab 6/1/2003 13:10' forMethod: #localDefinition.
true
%

category: 'as yet unclassified'
method: MCConflict
operation
	^ operation
%
run
MCConflict setStamp: 'avi 9/19/2005 02:19' forMethod: #operation.
true
%

category: 'as yet unclassified'
method: MCConflict
operation: anOperation
	operation := anOperation
%
run
MCConflict setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #operation:.
true
%

category: 'as yet unclassified'
method: MCConflict
remoteChosen
	^ chooseRemote notNil and: [chooseRemote]
%
run
MCConflict setStamp: 'ab 6/2/2003 01:45' forMethod: #remoteChosen.
true
%

category: 'as yet unclassified'
method: MCConflict
remoteDefinition
	^ operation targetDefinition
%
run
MCConflict setStamp: 'ab 6/1/2003 13:10' forMethod: #remoteDefinition.
true
%

category: 'as yet unclassified'
method: MCConflict
source
	^ self localChosen
		ifTrue: [operation fromSource]
		ifFalse: [operation source]
%
run
MCConflict setStamp: 'ab 7/18/2003 16:47' forMethod: #source.
true
%

category: 'as yet unclassified'
method: MCConflict
status
	^ self isResolved
		ifFalse: ['']
		ifTrue: [self remoteChosen
					ifFalse: ['L']
					ifTrue: ['R']]
%
run
MCConflict setStamp: 'ab 6/1/2003 13:48' forMethod: #status.
true
%

category: 'as yet unclassified'
method: MCConflict
summary
	
	^MCPlatform current formatSummaryFor: self
%
run
MCConflict setStamp: 'DaleHenrichs 10/8/2010 13:06' forMethod: #summary.
true
%

category: 'as yet unclassified'
classmethod: MCClassDefinition
kindOfSubclassFor: type
	type = #normal ifTrue: [^ ' subclass: '].
	type = #words ifTrue: [^ ' variableWordSubclass: '].
	type = #variable ifTrue: [^ ' variableSubclass: '].
	type = #bytes ifTrue: [^ ' variableByteSubclass: '].
	type = #weak ifTrue: [^ ' weakSubclass: ' ].
	type = #compiledMethod ifTrue: [^ ' variableByteSubclass: ' ].
	self error: 'Unrecognized class type'
%
run
MCClassDefinition class setStamp: 'DaleHenrichs 10/1/2010 13:12' forMethod: #kindOfSubclassFor:.
true
%

category: 'obsolete'
classmethod: MCClassDefinition
name: nameString
superclassName: superclassString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
comment: commentString
	^ self	name: nameString
			superclassName: superclassString
			category: categoryString 
			instVarNames: ivarArray
			classVarNames: cvarArray
			poolDictionaryNames: poolArray
			classInstVarNames: civarArray
			type: #normal
			comment: commentString

%
run
MCClassDefinition class setStamp: 'ab 4/1/2003 01:22' forMethod: #name:superclassName:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:comment:.
true
%

category: 'obsolete'
classmethod: MCClassDefinition
name: nameString
superclassName: superclassString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
type: typeSymbol
comment: commentString
	^ self 
		name: nameString
		superclassName: superclassString
		category: categoryString 
		instVarNames: ivarArray
		classVarNames: cvarArray
		poolDictionaryNames: poolArray
		classInstVarNames: civarArray
		type: typeSymbol
		comment: commentString
		commentStamp: nil
%
run
MCClassDefinition class setStamp: 'cwp 8/10/2003 16:33' forMethod: #name:superclassName:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:.
true
%

category: 'instance creation'
classmethod: MCClassDefinition
name: nameString
superclassName: superclassString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
type: typeSymbol
comment: commentString
commentStamp: stampString
	^ self instanceLike:
		(self new initializeWithName: nameString
					superclassName: superclassString
					traitComposition: '{}'
					classTraitComposition: '{}'
					category: categoryString 
					instVarNames: ivarArray
					classVarNames: cvarArray
					poolDictionaryNames: poolArray
					classInstVarNames: civarArray
					type: typeSymbol
					comment: commentString
					commentStamp: stampString)
%
run
MCClassDefinition class setStamp: 'al 10/9/2005 19:16' forMethod: #name:superclassName:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:commentStamp:.
true
%

category: 'obsolete'
classmethod: MCClassDefinition
name: nameString
superclassName: superclassString
category: categoryString 
instVarNames: ivarArray
comment: commentString
	^ self	name: nameString
			superclassName: superclassString
			category: categoryString 
			instVarNames: ivarArray
			classVarNames: #()
			poolDictionaryNames: #()
			classInstVarNames: #()
			comment: commentString

%
run
MCClassDefinition class setStamp: 'ab 4/1/2003 01:22' forMethod: #name:superclassName:category:instVarNames:comment:.
true
%

category: 'instance creation'
classmethod: MCClassDefinition
name: nameString
superclassName: superclassString
traitComposition: traitCompositionString
classTraitComposition: classTraitCompositionString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
type: typeSymbol
comment: commentString
commentStamp: stampString
	
	^ self instanceLike:
		(self new initializeWithName: nameString
					superclassName: superclassString
					traitComposition: traitCompositionString
					classTraitComposition: classTraitCompositionString
					category: categoryString 
					instVarNames: ivarArray
					classVarNames: cvarArray
					poolDictionaryNames: poolArray
					classInstVarNames: civarArray
					type: typeSymbol
					comment: commentString
					commentStamp: stampString)
%
run
MCClassDefinition class setStamp: 'al 10/10/2005 13:58' forMethod: #name:superclassName:traitComposition:classTraitComposition:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:commentStamp:.
true
%

category: 'visiting'
method: MCClassDefinition
= aDefinition
	^(super = aDefinition)
		and: [superclassName = aDefinition superclassName
		and: [self traitCompositionString = aDefinition traitCompositionString
		and: [self classTraitCompositionString = aDefinition classTraitCompositionString
		and: [category = aDefinition category
		and: [self type = aDefinition type
		and: [self sortedVariables = aDefinition sortedVariables
		and: [comment = aDefinition comment]]]]]]]
%
run
MCClassDefinition setStamp: 'nice 10/31/2009 13:11' forMethod: #=.
true
%

category: 'visiting'
method: MCClassDefinition
accept: aVisitor
	aVisitor visitClassDefinition: self.
	(self hasClassInstanceVariables or: [self hasClassTraitComposition])
		ifTrue: [aVisitor visitMetaclassDefinition: self].

%
run
MCClassDefinition setStamp: 'al 10/9/2005 19:33' forMethod: #accept:.
true
%

category: 'accessing'
method: MCClassDefinition
actualClass

	^MCPlatform current classNamed: self className

%
run
MCClassDefinition setStamp: 'DaleHenrichs 9/28/2010 15:37' forMethod: #actualClass.
true
%

category: 'initializing'
method: MCClassDefinition
addVariables: aCollection ofType: aClass
	variables addAll: (aCollection collect: [:var | aClass name: var asString]).
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:19' forMethod: #addVariables:ofType:.
true
%

category: 'accessing'
method: MCClassDefinition
category
	^ category
%
run
MCClassDefinition setStamp: 'cwp 11/24/2002 06:23' forMethod: #category.
true
%

category: 'accessing'
method: MCClassDefinition
classInstVarNames
	^ self selectVariables: #isClassInstanceVariable
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:32' forMethod: #classInstVarNames.
true
%

category: 'printing'
method: MCClassDefinition
classInstanceVariablesString
	^ self stringForVariablesOfType: #isClassInstanceVariable
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:35' forMethod: #classInstanceVariablesString.
true
%

category: 'accessing'
method: MCClassDefinition
className
	^ name
%
run
MCClassDefinition setStamp: 'ab 11/13/2002 01:52' forMethod: #className.
true
%

category: 'accessing'
method: MCClassDefinition
classTraitComposition
	^classTraitComposition
%
run
MCClassDefinition setStamp: 'al 10/9/2005 20:07' forMethod: #classTraitComposition.
true
%

category: 'accessing'
method: MCClassDefinition
classTraitCompositionString
	^self classTraitComposition ifNil: ['{}'].
%
run
MCClassDefinition setStamp: 'al 10/9/2005 21:55' forMethod: #classTraitCompositionString.
true
%

category: 'accessing'
method: MCClassDefinition
classVarNames
	^(self selectVariables: #isClassVariable) asArray sortBy:  [:a :b | a <= b]
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/15/2010 13:27' forMethod: #classVarNames.
true
%

category: 'printing'
method: MCClassDefinition
classVariablesString
	^ self stringForSortedVariablesOfType: #isClassVariable
%
run
MCClassDefinition setStamp: 'eem 4/30/2009 16:47' forMethod: #classVariablesString.
true
%

category: 'accessing'
method: MCClassDefinition
comment
	^ comment
%
run
MCClassDefinition setStamp: 'ab 1/15/2003 13:42' forMethod: #comment.
true
%

category: 'accessing'
method: MCClassDefinition
commentStamp
	^ commentStamp
%
run
MCClassDefinition setStamp: 'cwp 8/10/2003 16:40' forMethod: #commentStamp.
true
%

category: 'installing'
method: MCClassDefinition
createClass
	
	^MCPlatform current createClassFrom: self
%
run
MCClassDefinition setStamp: 'DaleHenrichs 9/28/2010 15:24' forMethod: #createClass.
true
%

category: 'initializing'
method: MCClassDefinition
defaultCommentStamp
	^ String new

	"The version below avoids stomping on stamps already in the image

	^ (Smalltalk at: name ifPresent: [:c | c organization commentStamp])
		ifNil: ['']
	"

%
run
MCClassDefinition setStamp: 'cwp 8/10/2003 17:39' forMethod: #defaultCommentStamp.
true
%

category: 'printing'
method: MCClassDefinition
definitionString
	^ String streamContents: [:stream | self printDefinitionOn: stream]
%
run
MCClassDefinition setStamp: 'cwp 8/2/2003 02:03' forMethod: #definitionString.
true
%

category: 'accessing'
method: MCClassDefinition
description
	^ Array with: name

%
run
MCClassDefinition setStamp: 'ab 12/5/2002 21:24' forMethod: #description.
true
%

category: 'testing'
method: MCClassDefinition
hasClassInstanceVariables
	^ (self selectVariables: #isClassInstanceVariable) isEmpty not
%
run
MCClassDefinition setStamp: 'cwp 8/2/2003 02:54' forMethod: #hasClassInstanceVariables.
true
%

category: 'testing'
method: MCClassDefinition
hasClassTraitComposition
	^self classTraitCompositionString ~= '{}'
%
run
MCClassDefinition setStamp: 'al 10/9/2005 21:59' forMethod: #hasClassTraitComposition.
true
%

category: 'testing'
method: MCClassDefinition
hasComment
	^ comment ~~ nil and: [ comment isEmpty not ]
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 12:10' forMethod: #hasComment.
true
%

category: 'testing'
method: MCClassDefinition
hasTraitComposition
	^self traitCompositionString ~= '{}'
%
run
MCClassDefinition setStamp: 'al 3/29/2006 00:27' forMethod: #hasTraitComposition.
true
%

category: 'comparing'
method: MCClassDefinition
hash
	| hash ty |
	hash := String stringHash: name initialHash: 0.
	hash := String stringHash: superclassName initialHash: hash.
	hash := String stringHash: self traitCompositionString initialHash: hash.
	hash := String stringHash: self classTraitCompositionString initialHash: hash.
	hash := String stringHash: (category ifNil: ['']) initialHash: hash.
        (ty := self type) _isArray
	  ifTrue: [
	    (ty at: 2) do: [:opt | hash := String stringHash: opt initialHash: hash ].
	    ty := ty at: 1].
	hash := String stringHash: ty initialHash: hash.
	variables do: [:v | hash := String stringHash: v name initialHash: hash ].
	^ hash
%
run
MCClassDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #hash.
true
%

category: 'initializing'
method: MCClassDefinition
initializeWithName: nameString
superclassName: superclassString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
type: typeSymbol
comment: commentString
commentStamp: stampStringOrNil
	name := nameString asSymbol.
	superclassName := superclassString ifNil: ['nil'] ifNotNil: [superclassString asSymbol].
	category := categoryString.
	name = #CompiledMethod ifTrue: [type := #compiledMethod] ifFalse: [type := typeSymbol].
	comment := commentString withSqueakLineEndings.
	commentStamp := stampStringOrNil ifNil: [self defaultCommentStamp].
	variables := OrderedCollection  new.
	self addVariables: ivarArray ofType: MCInstanceVariableDefinition.
	self addVariables: cvarArray asSortedCollection ofType: MCClassVariableDefinition.
	self addVariables: poolArray asSortedCollection ofType: MCPoolImportDefinition.
	self addVariables: civarArray ofType: MCClassInstanceVariableDefinition.
%
run
MCClassDefinition setStamp: 'bf 8/12/2009 10:55' forMethod: #initializeWithName:superclassName:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:commentStamp:.
true
%

category: 'initializing'
method: MCClassDefinition
initializeWithName: nameString
superclassName: superclassString
traitComposition: traitCompositionString
classTraitComposition: classTraitCompositionString
category: categoryString 
instVarNames: ivarArray
classVarNames: cvarArray
poolDictionaryNames: poolArray
classInstVarNames: civarArray
type: typeSymbol
comment: commentString
commentStamp: stampStringOrNil
	name := nameString asSymbol.
	superclassName := superclassString ifNil: ['nil'] ifNotNil: [superclassString asSymbol].
	traitComposition := traitCompositionString.
	classTraitComposition := classTraitCompositionString.
	category := categoryString.
	name = #CompiledMethod ifTrue: [type := #compiledMethod] ifFalse: [type := typeSymbol].
	comment := commentString withSqueakLineEndings.
	commentStamp := stampStringOrNil ifNil: [self defaultCommentStamp].
	variables := OrderedCollection  new.
	self addVariables: ivarArray ofType: MCInstanceVariableDefinition.
	self addVariables: cvarArray asSortedCollection ofType: MCClassVariableDefinition.
	self addVariables: poolArray asSortedCollection ofType: MCPoolImportDefinition.
	self addVariables: civarArray ofType: MCClassInstanceVariableDefinition.
%
run
MCClassDefinition setStamp: 'bf 8/12/2009 10:55' forMethod: #initializeWithName:superclassName:traitComposition:classTraitComposition:category:instVarNames:classVarNames:poolDictionaryNames:classInstVarNames:type:comment:commentStamp:.
true
%

category: 'accessing'
method: MCClassDefinition
instVarNames
	^ self selectVariables: #isInstanceVariable
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:33' forMethod: #instVarNames.
true
%

category: 'printing'
method: MCClassDefinition
instanceVariablesString
	^ self stringForVariablesOfType: #isInstanceVariable
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:35' forMethod: #instanceVariablesString.
true
%

category: 'testing'
method: MCClassDefinition
isClassDefinition
	^ true
%
run
MCClassDefinition setStamp: 'ab 12/4/2002 21:52' forMethod: #isClassDefinition.
true
%

category: 'testing'
method: MCClassDefinition
isCodeDefinition
	^ true
%
run
MCClassDefinition setStamp: 'ab 5/24/2003 13:49' forMethod: #isCodeDefinition.
true
%

category: 'accessing'
method: MCClassDefinition
kindOfSubclass

	^self class kindOfSubclassFor: self type

%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 13:13' forMethod: #kindOfSubclass.
true
%

category: 'installing'
method: MCClassDefinition
addMethodAdditionTo: aCollection
"Noop for MCClassDefinition"

%

category: 'installing'
method: MCClassDefinition
load
	| class |
	(class := self createClass) ~~ nil
		ifTrue: [ 
			self hasComment
				ifTrue: [ class classComment: comment stamp: commentStamp ] ]
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 12:07' forMethod: #load.
true
%

category: 'accessing'
method: MCClassDefinition
poolDictionaries
	^ (self selectVariables: #isPoolImport) collect: [:ea | ea asSymbol ]
%
run
MCClassDefinition setStamp: 'cwp 7/7/2003 23:53' forMethod: #poolDictionaries.
true
%

category: 'printing'
method: MCClassDefinition
printDefinitionOn: stream
		stream 
			nextPutAll: self superclassName;
			nextPutAll: self kindOfSubclass;
			nextPut: $# ;
			nextPutAll: self className;
			cr; tab.
		self hasTraitComposition ifTrue: [
			stream 
				nextPutAll: 'uses: ';
		 		nextPutAll: self traitCompositionString;
				cr; tab ].
		stream
			nextPutAll: 'instanceVariableNames: ';
			nextPutAll: self instanceVariablesString printString;
			cr; tab;
			nextPutAll: 'classVariableNames: ';
			nextPutAll: self classVariablesString printString;
			cr; tab;
			nextPutAll: 'poolDictionaries: ';
			nextPutAll: self sharedPoolsString printString;
			cr; tab;
			nextPutAll: 'category: ';
			nextPutAll: self category asString printString
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 11:24' forMethod: #printDefinitionOn:.
true
%

category: 'printing'
method: MCClassDefinition
printMetaDefinitionOn: stream
	stream 
		nextPutAll: self className;
		nextPutAll: ' class'; cr; tab.
	self hasClassTraitComposition ifTrue: [
		stream
			nextPutAll: 'uses: ';
			nextPutAll: self classTraitCompositionString;
			cr; tab ].
	stream
		nextPutAll: ' instanceVariableNames: '; 
		store: self classInstanceVariablesString
%
run
MCClassDefinition setStamp: 'lr 3/20/2010 21:23' forMethod: #printMetaDefinitionOn:.
true
%

category: 'comparing'
method: MCClassDefinition
provisions
	^ Array with: name
%
run
MCClassDefinition setStamp: 'ab 5/24/2003 14:12' forMethod: #provisions.
true
%

category: 'comparing'
method: MCClassDefinition
requirements
	^ (Array with: superclassName), self poolDictionaries
%
run
MCClassDefinition setStamp: 'avi 2/17/2004 03:13' forMethod: #requirements.
true
%

category: 'accessing'
method: MCClassDefinition
selectVariables: aSelector
	^ (variables select: [ :v | v perform: aSelector ]) collect: [ :v | v name ]
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 11:15' forMethod: #selectVariables:.
true
%

category: 'printing'
method: MCClassDefinition
sharedPoolsString
	^ self stringForSortedVariablesOfType: #isPoolImport
%
run
MCClassDefinition setStamp: 'eem 4/30/2009 16:47' forMethod: #sharedPoolsString.
true
%

category: 'accessing'
method: MCClassDefinition
sortKey
	^ self className
%
run
MCClassDefinition setStamp: 'ab 7/19/2003 18:00' forMethod: #sortKey.
true
%

category: 'accessing'
method: MCClassDefinition
sortedVariables
	"sort variables for comparison purposes"

	| sorted |
	sorted := variables select: [:var | var isOrderDependend].
	sorted addAll: ((variables reject: [:var | var isOrderDependend])
		asSortedCollection: [:a :b | a name <= b name]).
	^sorted
%
run
MCClassDefinition setStamp: 'bf 8/29/2006 11:45' forMethod: #sortedVariables.
true
%

category: 'printing'
method: MCClassDefinition
source
	^ self definitionString
%
run
MCClassDefinition setStamp: 'cwp 7/10/2003 01:29' forMethod: #source.
true
%

category: 'serializing'
method: MCClassDefinition
storeDataOn: aDataStream
	| instVarSize |
	instVarSize := (self hasTraitComposition or: [ self hasClassTraitComposition ])
		ifTrue: [ self class instSize ]
		ifFalse: [ self class instSize - 2 ].
	aDataStream
		beginInstance: self class
		size: instVarSize.
	1 to: instVarSize do: [ :index |
		aDataStream nextPut: (self instVarAt: index) ].
%
run
MCClassDefinition setStamp: 'al 7/4/2006 10:14' forMethod: #storeDataOn:.
true
%

category: 'installing'
method: MCClassDefinition
stringFor: aCollection
	
	^ String
		streamContents: [ :stream | | beforeFirst |
			beforeFirst := true.
			aCollection
				do: [ :ea | 
					beforeFirst
						ifTrue: [ beforeFirst := false ]
						ifFalse: [ stream space ].
					stream nextPutAll: ea ] ]
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/6/2010 13:00' forMethod: #stringFor:.
true
%

category: 'installing'
method: MCClassDefinition
stringForSortedVariablesOfType: aSymbol
	
	^self stringFor: (self selectVariables: aSymbol) asSortedCollection
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 11:20' forMethod: #stringForSortedVariablesOfType:.
true
%

category: 'installing'
method: MCClassDefinition
stringForVariablesOfType: aSymbol

	^self stringFor: (self selectVariables: aSymbol)

%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 11:20' forMethod: #stringForVariablesOfType:.
true
%

category: 'printing'
method: MCClassDefinition
summary
	^ name
%
run
MCClassDefinition setStamp: 'ab 11/16/2002 17:33' forMethod: #summary.
true
%

category: 'accessing'
method: MCClassDefinition
superclassName
	^ superclassName
%
run
MCClassDefinition setStamp: 'ab 11/13/2002 17:41' forMethod: #superclassName.
true
%

category: 'accessing'
method: MCClassDefinition
traitComposition
	^traitComposition
%
run
MCClassDefinition setStamp: 'al 10/9/2005 20:16' forMethod: #traitComposition.
true
%

category: 'accessing'
method: MCClassDefinition
traitCompositionString
	^self traitComposition ifNil: ['{}'].
%
run
MCClassDefinition setStamp: 'al 10/9/2005 21:55' forMethod: #traitCompositionString.
true
%

category: 'accessing'
method: MCClassDefinition
type
	^ type
%
run
MCClassDefinition setStamp: 'cwp 11/24/2002 22:35' forMethod: #type.
true
%

category: 'installing'
method: MCClassDefinition
unload
	MCPlatform current removeClassNamedFromSystem: name
%
run
MCClassDefinition setStamp: 'DaleHenrichs 10/1/2010 12:45' forMethod: #unload.
true
%

category: 'accessing'
method: MCClassDefinition
variables
	^ variables
%
run
MCClassDefinition setStamp: 'cwp 11/25/2002 06:51' forMethod: #variables.
true
%

category: 'cleanup'
classmethod: MCDefinition
cleanUp
	"Flush caches"

	self clearInstances.
%
run
MCDefinition class setStamp: 'StephaneDucasse 3/9/2010 16:33' forMethod: #cleanUp.
true
%

category: 'as yet unclassified'
classmethod: MCDefinition
clearInstances
        SessionTemps current removeKey: #INSTANCES_FOR_MCDefinition ifAbsent: []
%
run
MCDefinition class setStamp: 'DaleHenrichs 9/28/2010 15:16' forMethod: #clearInstances.
true
%

category: 'as yet unclassified'
classmethod: MCDefinition
instanceLike: aDefinition
        | instances |
        instances := SessionTemps current at: #INSTANCES_FOR_MCDefinition ifAbsent: [].
	instances ifNil: [
          instances := MCPlatform current weakSetClass new.
          SessionTemps current at: #INSTANCES_FOR_MCDefinition put: instances ].
	^ (instances includes: aDefinition) 
		ifTrue: [ aDefinition ]
		ifFalse: [instances add: aDefinition]
%
run
MCDefinition class setStamp: 'DaleHenrichs 9/28/2010 15:17' forMethod: #instanceLike:.
true
%

category: 'comparing'
method: MCDefinition
<= other
	^ self sortKey <= other sortKey
%
run
MCDefinition setStamp: 'ab 7/19/2003 17:59' forMethod: #'<='.
true
%

category: 'comparing'
method: MCDefinition
= aDefinition
	^(aDefinition isKindOf: MCDefinition) and: [self isRevisionOf: aDefinition]
%
run
MCDefinition setStamp: 'nice 10/31/2009 13:08' forMethod: #=.
true
%

category: 'installing'
method: MCDefinition
addMethodAdditionTo: aCollection
	self load
%
run
MCDefinition setStamp: 'AdrianLienhard 1/21/2010 22:14' forMethod: #addMethodAdditionTo:.
true
%

category: 'comparing'
method: MCDefinition
description
	self subclassResponsibility
%
run
MCDefinition setStamp: 'ab 7/19/2003 18:14' forMethod: #description.
true
%

category: 'comparing'
method: MCDefinition
fullTimeStamp
	^TimeStamp current
%
run
MCDefinition setStamp: 'nk 10/21/2003 23:18' forMethod: #fullTimeStamp.
true
%

category: 'comparing'
method: MCDefinition
hash
	^ self description hash
%
run
MCDefinition setStamp: 'ab 7/19/2003 18:14' forMethod: #hash.
true
%

category: 'testing'
method: MCDefinition
isClassDefinition
	^false
%
run
MCDefinition setStamp: 'ab 12/4/2002 21:51' forMethod: #isClassDefinition.
true
%

category: 'testing'
method: MCDefinition
isClassDefinitionExtension
	"Answer true if this definition extends the regular class definition"
	^false
%
run
MCDefinition setStamp: 'bf 11/12/2004 14:46' forMethod: #isClassDefinitionExtension.
true
%

category: 'testing'
method: MCDefinition
isMethodDefinition
	^false
%
run
MCDefinition setStamp: 'ab 12/4/2002 21:51' forMethod: #isMethodDefinition.
true
%

category: 'testing'
method: MCDefinition
isOrganizationDefinition
	^false
%
run
MCDefinition setStamp: 'cwp 7/11/2003 01:32' forMethod: #isOrganizationDefinition.
true
%

category: 'comparing'
method: MCDefinition
isRevisionOf: aDefinition
	^ (aDefinition isKindOf: MCDefinition) and: [aDefinition description = self description]
%
run
MCDefinition setStamp: 'damiencassou 11/27/2008 18:15' forMethod: #isRevisionOf:.
true
%

category: 'comparing'
method: MCDefinition
isSameRevisionAs: aDefinition
	^ self = aDefinition
%
run
MCDefinition setStamp: 'ab 7/19/2003 18:25' forMethod: #isSameRevisionAs:.
true
%

category: 'testing'
method: MCDefinition
isScriptDefinition
	^false
%
run
MCDefinition setStamp: 'bf 8/12/2009 22:55' forMethod: #isScriptDefinition.
true
%

category: 'installing'
method: MCDefinition
load
	
%
run
MCDefinition setStamp: 'ab 7/18/2003 21:31' forMethod: #load.
true
%

category: 'installing'
method: MCDefinition
loadOver: aDefinition
	self load
	
%
run
MCDefinition setStamp: 'avi 2/17/2004 13:19' forMethod: #loadOver:.
true
%

category: 'installing'
method: MCDefinition
postload
%
run
MCDefinition setStamp: 'ab 7/18/2003 19:48' forMethod: #postload.
true
%

category: 'installing'
method: MCDefinition
postloadOver: aDefinition
	self postload
%
run
MCDefinition setStamp: 'avi 2/17/2004 13:19' forMethod: #postloadOver:.
true
%

category: 'printing'
method: MCDefinition
printOn: aStream
	super printOn: aStream.
	aStream nextPutAll: '(', self summary, ')'
%
run
MCDefinition setStamp: 'ab 7/18/2003 19:43' forMethod: #printOn:.
true
%

category: 'accessing'
method: MCDefinition
provisions
	^ #()
%
run
MCDefinition setStamp: 'ab 5/24/2003 14:12' forMethod: #provisions.
true
%

category: 'accessing'
method: MCDefinition
requirements
	^ #()
%
run
MCDefinition setStamp: 'ab 5/24/2003 14:12' forMethod: #requirements.
true
%

category: 'comparing'
method: MCDefinition
sortKey
	self subclassResponsibility 
%
run
MCDefinition setStamp: 'ab 7/19/2003 18:04' forMethod: #sortKey.
true
%

category: 'printing'
method: MCDefinition
summary
	self subclassResponsibility 
%
run
MCDefinition setStamp: 'ab 7/19/2003 18:23' forMethod: #summary.
true
%

category: 'installing'
method: MCDefinition
unload
%
run
MCDefinition setStamp: 'ab 11/14/2002 00:08' forMethod: #unload.
true
%

category: 'class initialization'
classmethod: MCMethodDefinition
cachedDefinitions
	| dict |
	dict := SessionTemps current at: #CACHED_DEFINITIONS_FOR_MCMethodDefinition otherwise: nil.
	dict == nil 
		ifTrue: [
			dict := MCPlatform current newWeakIdentityKeyDictionary.
			SessionTemps current at: #CACHED_DEFINITIONS_FOR_MCMethodDefinition put: dict].
        ^dict
%
run
MCMethodDefinition class setStamp: 'DaleHenrichs 9/28/2010 15:13' forMethod: #cachedDefinitions.
true
%

category: 'instance creation'
classmethod: MCMethodDefinition
className: classString
classIsMeta: metaBoolean
selector: selectorString
category: catString
timeStamp: timeString
source: sourceString
	^ self instanceLike:
		(self new initializeWithClassName: classString
					classIsMeta: metaBoolean
					selector: selectorString
					category: catString
					timeStamp: timeString
					source: sourceString)
%
run
MCMethodDefinition class setStamp: 'ab 7/26/2003 02:05' forMethod: #className:classIsMeta:selector:category:timeStamp:source:.
true
%

category: 'instance creation'
classmethod: MCMethodDefinition
className: classString
selector: selectorString
category: catString
timeStamp: timeString
source: sourceString
	^ self	className: classString
			classIsMeta: false
			selector: selectorString
			category: catString
			timeStamp: timeString
			source: sourceString
%
run
MCMethodDefinition class setStamp: 'ab 4/1/2003 01:40' forMethod: #className:selector:category:timeStamp:source:.
true
%

category: 'cleanup'
classmethod: MCMethodDefinition
cleanUp
	"Flush caches"

	self shutDown.
%
run
MCMethodDefinition class setStamp: 'StephaneDucasse 3/9/2010 16:34' forMethod: #cleanUp.
true
%

category: 'instance creation'
classmethod: MCMethodDefinition
forMethodReference: aMethodReference
	| definition |
	definition := self cachedDefinitions at: aMethodReference compiledMethod ifAbsent: [].
	(definition isNil
		or: [definition selector ~= aMethodReference methodSymbol
		or: [definition className ~= aMethodReference classSymbol
		or: [definition classIsMeta ~= aMethodReference classIsMeta
		or: [definition category ~= aMethodReference category]]]])
			ifTrue: [definition := self 
						className: aMethodReference classSymbol
						classIsMeta: aMethodReference classIsMeta
						selector: aMethodReference methodSymbol
						category: aMethodReference category
						timeStamp: aMethodReference timeStamp
						source: aMethodReference source.
					self cachedDefinitions at: aMethodReference compiledMethod put: definition].
	^ definition
	
%
run
MCMethodDefinition class setStamp: 'jannik.laval 2/5/2010 21:45' forMethod: #forMethodReference:.
true
%

category: 'class initialization'
classmethod: MCMethodDefinition
shutDown
	SessionTemps current removeKey: #CACHED_DEFINITIONS_FOR_MCMethodDefinition ifAbsent: [].
%
run
MCMethodDefinition class setStamp: 'DaleHenrichs 9/28/2010 15:14' forMethod: #shutDown.
true
%

category: 'comparing'
method: MCMethodDefinition
= aDefinition
	^(super = aDefinition)
		and: [aDefinition source = self source
		and: [aDefinition category = self category
		and: [aDefinition timeStamp = self timeStamp]]]
%
run
MCMethodDefinition setStamp: 'nice 10/31/2009 13:12' forMethod: #=.
true
%

category: 'visiting'
method: MCMethodDefinition
accept: aVisitor
	^ aVisitor visitMethodDefinition: self
%
run
MCMethodDefinition setStamp: 'ab 7/18/2003 21:47' forMethod: #accept:.
true
%

category: 'accessing'
method: MCMethodDefinition
actualClass
	| class |
	class := MCPlatform current globalNamed: className ifAbsent: [ ^ nil ].
	^ classIsMeta
		ifTrue: [ class class ]
		ifFalse: [ class ]
%
run
MCMethodDefinition setStamp: 'DaleHenrichs 10/1/2010 15:07' forMethod: #actualClass.
true
%

category: 'installing'
method: MCMethodDefinition
addMethodAdditionTo: aCollection
	| methodAddition |
	methodAddition := MethodAddition new
		compile: source
		classified: category
		withStamp: timeStamp
		notifying: nil
		logSource: true
		inClass: self actualClass.
	"This might raise an exception and never return"
	methodAddition createCompiledMethod.
	aCollection add: methodAddition.

%
run
MCMethodDefinition setStamp: 'stephaneDucasse 5/8/2010 19:58' forMethod: #addMethodAdditionTo:.
true
%

category: 'accessing'
method: MCMethodDefinition
category
	^ category
%
run
MCMethodDefinition setStamp: 'ab 11/13/2002 01:59' forMethod: #category.
true
%

category: 'accessing'
method: MCMethodDefinition
classIsMeta
	^ classIsMeta
%
run
MCMethodDefinition setStamp: 'cwp 11/25/2002 07:26' forMethod: #classIsMeta.
true
%

category: 'accessing'
method: MCMethodDefinition
className
	^className
%
run
MCMethodDefinition setStamp: 'ab 11/15/2002 01:12' forMethod: #className.
true
%

category: 'printing'
method: MCMethodDefinition
description
	^ Array	
		with: className
		with: selector
		with: classIsMeta
%
run
MCMethodDefinition setStamp: 'ab 12/5/2002 21:25' forMethod: #description.
true
%

category: 'printing'
method: MCMethodDefinition
fullClassName
	"Using #class selector for classes for backwards compatibility"

	^ self classIsMeta
		ifFalse: [self className]
		ifTrue: [
			(self actualClass isNil or: [ self actualClass isTrait ])
				ifFalse: [self className, ' class']
				ifTrue: [self className, ' classSide']]
%
run
MCMethodDefinition setStamp: 'al 12/3/2005 12:15' forMethod: #fullClassName.
true
%

category: 'accessing'
method: MCMethodDefinition
fullTimeStamp
	^TimeStamp fromMethodTimeStamp: timeStamp
%
run
MCMethodDefinition setStamp: 'nk 10/21/2003 23:08' forMethod: #fullTimeStamp.
true
%

category: 'comparing'
method: MCMethodDefinition
hash
	| hash |
	hash := String stringHash: classIsMeta asString initialHash: 0.
	hash := String stringHash: source initialHash: hash.
	hash := String stringHash: category initialHash: hash.
	hash := String stringHash: className initialHash: hash.
	^ hash
%
run
MCMethodDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #hash.
true
%

category: 'serializing'
method: MCMethodDefinition
initializeWithClassName: classString
classIsMeta: metaBoolean
selector: selectorString
category: catString
timeStamp: timeString
source: sourceString
	className := classString asSymbol.
	selector := selectorString asSymbol.
	category := catString asSymbol.
	timeStamp := timeString.
	classIsMeta := metaBoolean.
	source := sourceString withSqueakLineEndings.

%
run
MCMethodDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithClassName:classIsMeta:selector:category:timeStamp:source:.
true
%

category: 'testing'
method: MCMethodDefinition
isCodeDefinition
	^ true
%
run
MCMethodDefinition setStamp: 'ab 5/24/2003 13:49' forMethod: #isCodeDefinition.
true
%

category: 'installing'
method: MCMethodDefinition
isExtensionMethod
	^ category beginsWith: '*'
%
run
MCMethodDefinition setStamp: 'avi 9/17/2003 22:27' forMethod: #isExtensionMethod.
true
%

category: 'testing'
method: MCMethodDefinition
isInitializer
	^ selector = #initialize and: [classIsMeta]
	
%
run
MCMethodDefinition setStamp: 'ab 8/8/2003 17:05' forMethod: #isInitializer.
true
%

category: 'testing'
method: MCMethodDefinition
isMethodDefinition
	^true
%
run
MCMethodDefinition setStamp: 'ab 12/4/2002 21:52' forMethod: #isMethodDefinition.
true
%

category: 'installing'
method: MCMethodDefinition
isOverrideMethod
	"this oughta check the package"
	^ self isExtensionMethod and: [category endsWith: '-override']
%
run
MCMethodDefinition setStamp: 'avi 11/10/2003 15:45' forMethod: #isOverrideMethod.
true
%

category: 'accessing'
method: MCMethodDefinition
load
	self actualClass
		compile: source
		classified: category
		withStamp: timeStamp
		notifying: nil
%
run
MCMethodDefinition setStamp: 'stephaneDucasse 5/8/2010 19:58' forMethod: #load.
true
%

category: 'installing'
method: MCMethodDefinition
postloadOver: aDefinition
	super postloadOver: aDefinition.
	(self isInitializer
		and: [ self actualClass isTrait not 
				and: [ aDefinition isNil or: [ self source ~= aDefinition source ]]]) ifTrue: [
			self actualClass theNonMetaClass initialize ].

%
run
MCMethodDefinition setStamp: 'DaleHenrichs 10/8/2010 13:22' forMethod: #postloadOver:.
true
%

category: 'installing'
method: MCMethodDefinition
removeSelector: aSelector fromClass: aClass
	"Safely remove the given selector from the target class.
	Be careful not to remove the selector when it has wondered
	to another package."
	| newCategory |
	newCategory := MCPlatform current categoryOfSelector: aSelector for: aClass .
	newCategory ifNotNil:[
		"If moved to and fro extension, ignore removal"
		(category beginsWith: '*') = (newCategory beginsWith: '*') ifFalse:[^self].
		"Check if moved between different extension categories"
		((category beginsWith: '*') and:[category ~= newCategory]) ifTrue:[^self]].
	aClass removeSelector: aSelector.

%
run
MCMethodDefinition setStamp: 'DaleHenrichs 10/1/2010 15:28' forMethod: #removeSelector:fromClass:.
true
%

category: 'comparing'
method: MCMethodDefinition
requirements
	^ Array with: className
%
run
MCMethodDefinition setStamp: 'ab 5/24/2003 14:11' forMethod: #requirements.
true
%

category: 'accessing'
method: MCMethodDefinition
selector
	^selector
%
run
MCMethodDefinition setStamp: 'ab 11/15/2002 01:11' forMethod: #selector.
true
%

category: 'comparing'
method: MCMethodDefinition
sortKey
	^ self className, '.', (self classIsMeta ifTrue: ['meta'] ifFalse: ['nonmeta']), '.', self selector
%
run
MCMethodDefinition setStamp: 'ab 7/19/2003 18:01' forMethod: #sortKey.
true
%

category: 'accessing'
method: MCMethodDefinition
source
	^ source
%
run
MCMethodDefinition setStamp: 'ab 11/13/2002 01:59' forMethod: #source.
true
%

category: 'printing'
method: MCMethodDefinition
summary
	^ self fullClassName , '>>' , selector
%
run
MCMethodDefinition setStamp: 'ab 4/8/2003 18:04' forMethod: #summary.
true
%

category: 'accessing'
method: MCMethodDefinition
timeStamp
	^ timeStamp
%
run
MCMethodDefinition setStamp: 'ab 1/15/2003 13:42' forMethod: #timeStamp.
true
%

category: 'installing'
method: MCMethodDefinition
unload

	MCPlatform current unloadMethodDefinition: self
%
run
MCMethodDefinition setStamp: 'DaleHenrichs 9/28/2010 15:10' forMethod: #unload.
true
%

category: 'as yet unclassified'
classmethod: MCMockDefinition
token: aString

	^ self new token: aString
%
run
MCMockDefinition class setStamp: 'ab 7/7/2003 23:21' forMethod: #token:.
true
%

category: 'as yet unclassified'
classmethod: MCMockDefinition
wantsChangeSetLogging
	^ false
%
run
MCMockDefinition class setStamp: 'cwp 7/21/2003 19:46' forMethod: #wantsChangeSetLogging.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
= definition
	^definition token = token
%
run
MCMockDefinition setStamp: 'ab 7/19/2003 18:25' forMethod: #=.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
asString

	^ token
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #asString.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
description

	^ token first
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #description.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
hash

	^ token hash
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #hash.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
printString

	^ token
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #printString.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
summary

	^ token
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #summary.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
token

	^ token
%
run
MCMockDefinition setStamp: 'ab 7/7/2003 23:21' forMethod: #token.
true
%

category: 'as yet unclassified'
method: MCMockDefinition
token: aString

	token := aString
%
run
MCMockDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #token:.
true
%

category: 'as yet unclassified'
classmethod: MCOrganizationDefinition
categories: anArray
	^ self instanceLike: (self new categories: anArray)
%
run
MCOrganizationDefinition class setStamp: 'ab 7/26/2003 02:06' forMethod: #categories:.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
= aDefinition
	^ (super = aDefinition)
		and: [categories = aDefinition categories]
%
run
MCOrganizationDefinition setStamp: 'ab 7/19/2003 18:25' forMethod: #=.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
accept: aVisitor
	^ aVisitor visitOrganizationDefinition: self
%
run
MCOrganizationDefinition setStamp: 'ab 7/18/2003 21:47' forMethod: #accept:.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
categories
	^ categories
%
run
MCOrganizationDefinition setStamp: 'ab 5/24/2003 13:51' forMethod: #categories.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
categories: anArray
	categories := anArray
%
run
MCOrganizationDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #categories:.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
commonPrefix
	| stream cats |
	categories isEmpty
		ifTrue: [ ^ '' ].
	stream := WriteStream on: String new.
	cats := categories at: 1.
	1 to: cats size do: [ :i | 
		| c |
		c := cats at: i.
		categories
			do: [ :ea | 
				ea size < i
					ifTrue: [ ^ stream contents ].
				(ea at: i) = c
					ifFalse: [ ^ stream contents ] ].
		stream nextPut: c ].
	^ stream contents
%
run
MCOrganizationDefinition setStamp: 'DaleHenrichs 10/7/2010 14:30' forMethod: #commonPrefix.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
description
	^ Array with: #organization with: self commonPrefix
%
run
MCOrganizationDefinition setStamp: 'avi 9/28/2004 14:53' forMethod: #description.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
isOrganizationDefinition
	^ true
%
run
MCOrganizationDefinition setStamp: 'cwp 7/11/2003 01:33' forMethod: #isOrganizationDefinition.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
reorderCategories: allCategories original: oldCategories
	| first |
	first := allCategories detect: [:ea | categories includes: ea] ifNone: [^ allCategories].
	^ 	((allCategories copyUpTo: first) copyWithoutAll: oldCategories, categories),
		categories,
		((allCategories copyAfter: first) copyWithoutAll: oldCategories, categories)

%
run
MCOrganizationDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #reorderCategories:original:.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
sortKey
	^ '<organization>'
%
run
MCOrganizationDefinition setStamp: 'ab 7/19/2003 18:01' forMethod: #sortKey.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
source
	^ String streamContents:
		[:s |
		categories do: [:ea | s nextPutAll: ea] separatedBy: [s cr]]
%
run
MCOrganizationDefinition setStamp: 'ab 7/22/2003 01:14' forMethod: #source.
true
%

category: 'as yet unclassified'
method: MCOrganizationDefinition
summary
	^ categories asArray printString
%
run
MCOrganizationDefinition setStamp: 'ab 5/24/2003 13:55' forMethod: #summary.
true
%

category: 'as yet unclassified'
classmethod: MCPostscriptDefinition
scriptSelector
	^ #postscript
%
run
MCPostscriptDefinition class setStamp: 'avi 2/28/2005 17:04' forMethod: #scriptSelector.
true
%

category: 'as yet unclassified'
method: MCPostscriptDefinition
postload
	self evaluate
%
run
MCPostscriptDefinition setStamp: 'avi 2/28/2005 17:16' forMethod: #postload.
true
%

category: 'as yet unclassified'
method: MCPostscriptDefinition
sortKey
	^ 'zzz' "force to the end so it gets loaded late"
%
run
MCPostscriptDefinition setStamp: 'avi 2/28/2005 17:16' forMethod: #sortKey.
true
%

category: 'as yet unclassified'
classmethod: MCPreambleDefinition
scriptSelector
	^ #preamble
%
run
MCPreambleDefinition class setStamp: 'avi 2/28/2005 17:04' forMethod: #scriptSelector.
true
%

category: 'as yet unclassified'
method: MCPreambleDefinition
load
	super load.
	self evaluate
%
run
MCPreambleDefinition setStamp: 'avi 2/28/2005 17:15' forMethod: #load.
true
%

category: 'as yet unclassified'
classmethod: MCRemovalPostscriptDefinition
scriptSelector
	^ #postscriptOfRemoval 
%
run
MCRemovalPostscriptDefinition class setStamp: 'avi 2/28/2005 17:04' forMethod: #scriptSelector.
true
%

category: 'as yet unclassified'
method: MCRemovalPostscriptDefinition
unload
	super unload.
	self evaluate
%
run
MCRemovalPostscriptDefinition setStamp: 'avi 2/28/2005 17:15' forMethod: #unload.
true
%

category: 'as yet unclassified'
classmethod: MCRemovalPreambleDefinition
scriptSelector
	^ #preambleOfRemoval
%
run
MCRemovalPreambleDefinition class setStamp: 'avi 2/28/2005 17:04' forMethod: #scriptSelector.
true
%

category: 'as yet unclassified'
method: MCRemovalPreambleDefinition
sortKey
	^ 'zzz' "force to the end so it gets unloaded early"
%
run
MCRemovalPreambleDefinition setStamp: 'avi 2/28/2005 17:14' forMethod: #sortKey.
true
%

category: 'as yet unclassified'
method: MCRemovalPreambleDefinition
unload
	super unload.
	self evaluate
%
run
MCRemovalPreambleDefinition setStamp: 'avi 2/28/2005 17:15' forMethod: #unload.
true
%

category: 'as yet unclassified'
classmethod: MCScriptDefinition
from: aPackageInfo
	^ self script: (aPackageInfo perform: self scriptSelector) contents asString packageName: aPackageInfo name
%
run
MCScriptDefinition class setStamp: 'bf 4/4/2005 12:20' forMethod: #from:.
true
%

category: 'as yet unclassified'
classmethod: MCScriptDefinition
script: aString packageName: packageString
	^ self instanceLike: (self new initializeWithScript: aString packageName: packageString)
%
run
MCScriptDefinition class setStamp: 'avi 2/28/2005 16:59' forMethod: #script:packageName:.
true
%

category: 'as yet unclassified'
classmethod: MCScriptDefinition
scriptSelector
	self subclassResponsibility
%
run
MCScriptDefinition class setStamp: 'avi 2/28/2005 17:00' forMethod: #scriptSelector.
true
%

category: 'as yet unclassified'
classmethod: MCScriptDefinition
scriptSelector: selectorString script: aString packageName: packageString
	^ (self subclassForScriptSelector: selectorString)
		script: aString packageName: packageString
%
run
MCScriptDefinition class setStamp: 'bf 8/13/2009 00:24' forMethod: #scriptSelector:script:packageName:.
true
%

category: 'as yet unclassified'
classmethod: MCScriptDefinition
subclassForScriptSelector: selectorString
	^(MCPlatform current allSubclassesOfMonticelloClass: self) detect: [:ea | ea scriptSelector = selectorString]
%
run
MCScriptDefinition class setStamp: 'bf 8/13/2009 00:25' forMethod: #subclassForScriptSelector:.
true
%

category: 'comparing'
method: MCScriptDefinition
= aDefinition
	^ (super = aDefinition)
		and: [script = aDefinition script]
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 16:55' forMethod: #=.
true
%

category: 'visiting'
method: MCScriptDefinition
accept: aVisitor
	aVisitor visitScriptDefinition: self
%
run
MCScriptDefinition setStamp: 'bf 8/12/2009 21:41' forMethod: #accept:.
true
%

category: 'accessing'
method: MCScriptDefinition
description
	^ Array with: packageName with: self scriptSelector
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:12' forMethod: #description.
true
%

category: 'initializing'
method: MCScriptDefinition
initializeWithScript: aString packageName: packageString
	script := aString.
	packageName := packageString
%
run
MCScriptDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithScript:packageName:.
true
%

category: 'installing'
method: MCScriptDefinition
installScript
	self installScript: script
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:11' forMethod: #installScript.
true
%

category: 'installing'
method: MCScriptDefinition
installScript: aString
	| sel pi |
	sel := (self scriptSelector, ':') asSymbol.
	pi := self packageInfo.
	(pi respondsTo: sel)
		ifTrue: [pi perform: sel with: aString]
%
run
MCScriptDefinition setStamp: 'bf 10/25/2005 18:55' forMethod: #installScript:.
true
%

category: 'testing'
method: MCScriptDefinition
isScriptDefinition
	^true
%
run
MCScriptDefinition setStamp: 'bf 8/12/2009 22:55' forMethod: #isScriptDefinition.
true
%

category: 'installing'
method: MCScriptDefinition
load
	self installScript
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:12' forMethod: #load.
true
%

category: 'accessing'
method: MCScriptDefinition
packageInfo
	^ PackageInfo named: packageName
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:22' forMethod: #packageInfo.
true
%

category: 'accessing'
method: MCScriptDefinition
packageName
	^ packageName
%
run
MCScriptDefinition setStamp: 'bf 8/13/2009 00:09' forMethod: #packageName.
true
%

category: 'accessing'
method: MCScriptDefinition
script
	^ script
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 16:54' forMethod: #script.
true
%

category: 'accessing'
method: MCScriptDefinition
scriptSelector
	^ self class scriptSelector
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:10' forMethod: #scriptSelector.
true
%

category: 'accessing'
method: MCScriptDefinition
sortKey
	^ '!', self scriptSelector "force to the front so it gets loaded first"
%
run
MCScriptDefinition setStamp: 'bf 10/25/2005 19:05' forMethod: #sortKey.
true
%

category: 'accessing'
method: MCScriptDefinition
source
	^ script
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:04' forMethod: #source.
true
%

category: 'accessing'
method: MCScriptDefinition
summary
	^ packageName, ' ', self scriptSelector
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:12' forMethod: #summary.
true
%

category: 'installing'
method: MCScriptDefinition
unload
	self installScript: nil
%
run
MCScriptDefinition setStamp: 'avi 2/28/2005 17:12' forMethod: #unload.
true
%

category: 'as yet unclassified'
classmethod: MCDefinitionIndex
definitions: aCollection
	^ self new addAll: aCollection
%
run
MCDefinitionIndex class setStamp: 'ab 6/2/2003 01:29' forMethod: #definitions:.
true
%

category: 'instance creation'
classmethod: MCDefinitionIndex
new

	^ self basicNew initialize

%
run
MCDefinitionIndex class setStamp: 'DaleHenrichs 9/29/2010 16:29' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
add: aDefinition
	^ definitions at: aDefinition description put: aDefinition
%
run
MCDefinitionIndex setStamp: 'StephaneDucasse 5/6/2010 08:52' forMethod: #add:.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
addAll: aCollection
	aCollection do: [:ea | self add: ea]
%
run
MCDefinitionIndex setStamp: 'ab 6/2/2003 00:38' forMethod: #addAll:.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
definitionLike: aDefinition ifPresent: foundBlock ifAbsent: errorBlock
	| definition |
	definition := definitions at: aDefinition description ifAbsent: [].
	^ definition
		ifNil: errorBlock
		ifNotNil: [foundBlock value: definition]
%
run
MCDefinitionIndex setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #definitionLike:ifPresent:ifAbsent:.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
definitions
	^ definitions values
%
run
MCDefinitionIndex setStamp: 'ab 6/2/2003 00:42' forMethod: #definitions.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
initialize
	definitions := Dictionary new
%
run
MCDefinitionIndex setStamp: 'DaleHenrichs 9/29/2010 16:30' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCDefinitionIndex
remove: aDefinition
	definitions removeKey: aDefinition description ifAbsent: []
%
run
MCDefinitionIndex setStamp: 'ab 6/2/2003 00:40' forMethod: #remove:.
true
%

category: 'as yet unclassified'
classmethod: MCDependencySorter
items: aCollection
	^ self new addAll: aCollection
%
run
MCDependencySorter class setStamp: 'ab 5/23/2003 14:17' forMethod: #items:.
true
%

category: 'class initialization'
classmethod: MCDependencySorter
new

	^ self basicNew initialize

%
run
MCDependencySorter class setStamp: 'DaleHenrichs 9/29/2010 16:32' forMethod: #new.
true
%

category: 'as yet unclassified'
classmethod: MCDependencySorter
sortItems: aCollection
	| sorter |
	sorter := self items: aCollection.
	sorter externalRequirements do: [:req  | sorter addProvision: req].
	^ sorter orderedItems.
%
run
MCDependencySorter class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #sortItems:.
true
%

category: 'building'
method: MCDependencySorter
add: anItem
	| requirements |
	requirements := self unresolvedRequirementsFor: anItem.
	requirements isEmpty
		ifTrue: [self addToOrder: anItem]
		ifFalse: [self addRequirements: requirements for: anItem].
	^ anItem
%
run
MCDependencySorter setStamp: 'StephaneDucasse 5/6/2010 08:52' forMethod: #add:.
true
%

category: 'building'
method: MCDependencySorter
addAll: aCollection
	(aCollection asArray sortBy:  [:a :b | a <= b]) do: [:ea | self add: ea]
%
run
MCDependencySorter setStamp: 'DaleHenrichs 10/15/2010 13:28' forMethod: #addAll:.
true
%

category: 'building'
method: MCDependencySorter
addExternalProvisions: aCollection
	| er |
	er := self externalRequirements.
	(aCollection select: [:each | er includes: each ])
		do: [:ea | self addProvision: ea]
%
run
MCDependencySorter setStamp: 'DaleHenrichs 10/1/2010 14:52' forMethod: #addExternalProvisions:.
true
%

category: 'private'
method: MCDependencySorter
addProvision: anObject
	| newlySatisfied |
	provided add: anObject.
	newlySatisfied := (required removeKey: anObject ifAbsent: [#()]) asSet.
required values do: [:stillRequired | newlySatisfied removeAllPresent: stillRequired ].
	self addAll: newlySatisfied.
%
run
MCDependencySorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addProvision:.
true
%

category: 'private'
method: MCDependencySorter
addRequirement: reqObject for: itemObject

	(self itemsRequiring: reqObject) add: itemObject
%
run
MCDependencySorter setStamp: 'ab 5/22/2003 23:24' forMethod: #addRequirement:for:.
true
%

category: 'private'
method: MCDependencySorter
addRequirements: aCollection for: anObject
	aCollection do: [:ea | self addRequirement: ea for: anObject]
%
run
MCDependencySorter setStamp: 'ab 5/22/2003 23:23' forMethod: #addRequirements:for:.
true
%

category: 'private'
method: MCDependencySorter
addToOrder: anItem
	orderedItems add: anItem.
	anItem provisions do: [:ea | self addProvision: ea].
%
run
MCDependencySorter setStamp: 'ab 5/22/2003 23:15' forMethod: #addToOrder:.
true
%

category: 'accessing'
method: MCDependencySorter
externalRequirements
	| unloaded providedByUnloaded |
	unloaded := self itemsWithMissingRequirements.
	providedByUnloaded := Set new.
	unloaded do: [:e | providedByUnloaded addAll: e provisions].
	^ required keys reject: [:ea | providedByUnloaded includes: ea ]
%
run
MCDependencySorter setStamp: 'DaleHenrichs 9/29/2010 16:54' forMethod: #externalRequirements.
true
%

category: 'initialization'
method: MCDependencySorter
initialize
	provided := Set new.
	required := Dictionary new.
	orderedItems := OrderedCollection new.
%
run
MCDependencySorter setStamp: 'DaleHenrichs 9/29/2010 16:31' forMethod: #initialize.
true
%

category: 'private'
method: MCDependencySorter
itemsRequiring: anObject
	^ required at: anObject ifAbsentPut: [Set new]
%
run
MCDependencySorter setStamp: 'ab 5/22/2003 23:24' forMethod: #itemsRequiring:.
true
%

category: 'accessing'
method: MCDependencySorter
itemsWithMissingRequirements
	| items |
	items := Set new.
	required do: [:ea | items addAll: ea].
	^ items

%
run
MCDependencySorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #itemsWithMissingRequirements.
true
%

category: 'sorting'
method: MCDependencySorter
orderedItems
	^ orderedItems
%
run
MCDependencySorter setStamp: 'ab 5/22/2003 23:25' forMethod: #orderedItems.
true
%

category: 'private'
method: MCDependencySorter
unresolvedRequirementsFor: anItem
	^ anItem requirements reject: [:each | provided includes: each ]
%
run
MCDependencySorter setStamp: 'DaleHenrichs 10/1/2010 15:35' forMethod: #unresolvedRequirementsFor:.
true
%

category: 'instance creation'
classmethod: MCFrontier
frontierOn: aVersionInfo
	^ self frontierOnAll: (Array with: aVersionInfo)
%
run
MCFrontier class setStamp: 'avi 9/17/2005 22:07' forMethod: #frontierOn:.
true
%

category: 'instance creation'
classmethod: MCFrontier
frontierOn: aVersionInfo and: otherVersionInfo
	^ self frontierOnAll: (Array with: aVersionInfo with: otherVersionInfo)
%
run
MCFrontier class setStamp: 'avi 9/17/2005 22:07' forMethod: #frontierOn:and:.
true
%

category: 'instance creation'
classmethod: MCFrontier
frontierOnAll: aCollection
	| remaining  allVersions |
	remaining := Bag new.
	allVersions := Set new.
	aCollection do: [:ea | allVersions addAll: ea withBreadthFirstAncestors].
	allVersions do: [:ea | remaining addAll: ea ancestors].
	^self new frontier: aCollection bag: remaining
%
run
MCFrontier class setStamp: 'DaleHenrichs 9/29/2010 16:55' forMethod: #frontierOnAll:.
true
%

category: 'accessing'
method: MCFrontier
frontier
	^frontier
%
run
MCFrontier setStamp: 'avi 9/17/2005 22:02' forMethod: #frontier.
true
%

category: 'initialization'
method: MCFrontier
frontier: f bag: remaining
	frontier := f asOrderedCollection.
	bag := remaining
%
run
MCFrontier setStamp: 'avi 9/17/2005 22:11' forMethod: #frontier:bag:.
true
%

category: 'advancing'
method: MCFrontier
remove: aVersionInfo
	frontier remove: aVersionInfo.
	aVersionInfo ancestors  do:
		[ :ancestor |
			bag remove: ancestor.
			(bag occurrencesOf: ancestor) = 0
				ifTrue: [frontier add: ancestor]].
	^aVersionInfo
%
run
MCFrontier setStamp: 'avi 9/17/2005 22:13' forMethod: #remove:.
true
%

category: 'advancing'
method: MCFrontier
removeAll: collection
	collection do: [ :n | self remove: n]
%
run
MCFrontier setStamp: 'avi 9/17/2005 22:02' forMethod: #removeAll:.
true
%

category: 'as yet unclassified'
classmethod: MCMergeRecord
version: aVersion
	^ self basicNew initializeWithVersion: aVersion
%
run
MCMergeRecord class setStamp: 'abc 2/13/2004 15:52' forMethod: #version:.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
ancestorInfo
	^ ancestorInfo ifNil: [ancestorInfo := version info commonAncestorWith: version workingCopy ancestry]
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #ancestorInfo.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
ancestorSnapshot
	^ ancestorSnapshot ifNil: [ancestorSnapshot := version workingCopy findSnapshotWithVersionInfo: self ancestorInfo]
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #ancestorSnapshot.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
imageIsClean
	| ancestors |
	ancestors := version workingCopy ancestors.
	^ ancestors size = 1
		and: [(ancestors first = self ancestorInfo)
				and: [self imagePatch isEmpty]]
%
run
MCMergeRecord setStamp: 'StephaneDucasse 4/27/2010 11:49' forMethod: #imageIsClean.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
imagePatch
	^ imagePatch ifNil: [imagePatch := self packageSnapshot patchRelativeToBase: self ancestorSnapshot]
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #imagePatch.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
initializeWithVersion: aVersion
	version := aVersion
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithVersion:.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
isAncestorMerge
	^ version workingCopy ancestry hasAncestor: version info
%
run
MCMergeRecord setStamp: 'abc 2/13/2004 17:14' forMethod: #isAncestorMerge.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
mergePatch
	^ mergePatch ifNil: [mergePatch := version snapshot patchRelativeToBase: self ancestorSnapshot]
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #mergePatch.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
packageSnapshot
	^ packageSnapshot ifNil: [packageSnapshot := version package snapshot]
%
run
MCMergeRecord setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #packageSnapshot.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
updateWorkingCopy
	self isAncestorMerge ifFalse:
		[self imageIsClean
			ifTrue: [version workingCopy loaded: version]
			ifFalse: [version workingCopy merged: version]]
%
run
MCMergeRecord setStamp: 'abc 2/13/2004 17:14' forMethod: #updateWorkingCopy.
true
%

category: 'as yet unclassified'
method: MCMergeRecord
version
	^ version
%
run
MCMergeRecord setStamp: 'abc 2/13/2004 15:52' forMethod: #version.
true
%

category: 'as yet unclassified'
method: MCMerger
addConflictWithOperation: anOperation
	self conflicts add: (MCConflict operation: anOperation)
%
run
MCMerger setStamp: 'ab 6/2/2003 01:10' forMethod: #addConflictWithOperation:.
true
%

category: 'as yet unclassified'
method: MCMerger
applyTo: anObject
	self isMerged ifFalse: [self error: 'You must resolve all the conflicts first'].
	conflicts do: [:ea | ea applyTo: anObject]
%
run
MCMerger setStamp: 'ab 6/2/2003 01:01' forMethod: #applyTo:.
true
%

category: 'as yet unclassified'
method: MCMerger
conflicts
	^ conflicts ifNil: [conflicts := OrderedCollection new]
%
run
MCMerger setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #conflicts.
true
%

category: 'as yet unclassified'
method: MCMerger
isMerged
	^ self conflicts allSatisfy: [:ea | ea isResolved]
%
run
MCMerger setStamp: 'ab 6/5/2003 19:09' forMethod: #isMerged.
true
%

category: 'as yet unclassified'
method: MCMerger
load
	| loader |
	loader := MCPackageLoader new.
	loader provisions addAll: self provisions.
	self applyTo: loader.
	loader load
%
run
MCMerger setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #load.
true
%

category: 'as yet unclassified'
method: MCMerger
loadWithNameLike: baseName
	| loader |
	loader := MCPackageLoader new.
	loader provisions addAll: self provisions.
	self applyTo: loader.
	loader loadWithNameLike: baseName
%
run
MCMerger setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loadWithNameLike:.
true
%

category: 'as yet unclassified'
method: MCMerger
mergedSnapshot
	^ MCPatcher apply: self to: self baseSnapshot
%
run
MCMerger setStamp: 'ab 6/2/2003 01:11' forMethod: #mergedSnapshot.
true
%

category: 'as yet unclassified'
method: MCMerger
operations
	^ #()
%
run
MCMerger setStamp: 'ab 7/18/2003 16:34' forMethod: #operations.
true
%

category: 'as yet unclassified'
method: MCMerger
provisions
	^ #()
%
run
MCMerger setStamp: 'avi 10/6/2004 15:19' forMethod: #provisions.
true
%

category: 'as yet unclassified'
classmethod: MCThreeWayMerger
base: aSnapshot patch: aPatch
	aPatch isEmpty ifTrue: [MCNoChangesException signal].
	^ self new
		addBaseSnapshot: aSnapshot;
		applyPatch: aPatch;
		yourself
		
%
run
MCThreeWayMerger class setStamp: 'avi 2/13/2004 01:53' forMethod: #base:patch:.
true
%

category: 'as yet unclassified'
classmethod: MCThreeWayMerger
base: aSnapshot target: targetSnapshot ancestor: ancestorSnapshot
	^ self base: aSnapshot patch: (targetSnapshot patchRelativeToBase: ancestorSnapshot)
%
run
MCThreeWayMerger class setStamp: 'ab 6/2/2003 01:09' forMethod: #base:target:ancestor:.
true
%

category: 'instance creation'
classmethod: MCThreeWayMerger
new

	^ self basicNew initialize

%
run
MCThreeWayMerger class setStamp: 'DaleHenrichs 9/29/2010 16:41' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
addBaseSnapshot: aSnapshot
	aSnapshot definitions do:
		[:ea |
		index add: ea.
		provisions addAll: ea provisions]
%
run
MCThreeWayMerger setStamp: 'avi 10/6/2004 15:18' forMethod: #addBaseSnapshot:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
addDefinition: aDefinition
	index
		definitionLike: aDefinition
		ifPresent: [:other | | op |
			(op := self removalForDefinition: aDefinition) ~~ nil
				ifTrue: [
					self addOperation: (MCModification of: other to: aDefinition).
					self removeOperation: op.
					^ self].
			other = aDefinition
				ifFalse: [self addConflictWithOperation: (MCModification of: other to: aDefinition)]
				ifTrue: [self redundantAdds add: aDefinition]]
		ifAbsent: [self addOperation: (MCAddition of: aDefinition)]
%
run
MCThreeWayMerger setStamp: 'DaleHenrichs 9/27/2010 16:49' forMethod: #addDefinition:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
addOperation: anOperation
	self operations add: anOperation
%
run
MCThreeWayMerger setStamp: 'ab 6/2/2003 01:30' forMethod: #addOperation:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
applyPatch: aPatch
	aPatch applyTo: self
%
run
MCThreeWayMerger setStamp: 'avi 2/13/2004 01:52' forMethod: #applyPatch:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
applyTo: anObject
	super applyTo: anObject.
	self operations do: [:ea | ea applyTo: anObject]
%
run
MCThreeWayMerger setStamp: 'ab 6/2/2003 01:32' forMethod: #applyTo:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
baseSnapshot
	^ (MCSnapshot fromDefinitions: index definitions)
%
run
MCThreeWayMerger setStamp: 'avi 2/13/2004 01:49' forMethod: #baseSnapshot.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
initialize

	index := MCDefinitionIndex new.
	provisions := Set new
%
run
MCThreeWayMerger setStamp: 'DaleHenrichs 9/29/2010 16:40' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
modificationConflictForDefinition: aDefinition
	^ conflicts ifNotNil:
		[conflicts detect:
			[:ea | (ea definition isRevisionOf: aDefinition) and:
				[ea operation isModification]] ifNone: []]
%
run
MCThreeWayMerger setStamp: 'avi 9/19/2005 02:22' forMethod: #modificationConflictForDefinition:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
modifyDefinition: baseDefinition to: targetDefinition
	index
		definitionLike: baseDefinition
		ifPresent: [:other | other = baseDefinition
								ifTrue: [self addOperation: (MCModification of:  baseDefinition to: targetDefinition)]
								ifFalse: [other = targetDefinition
											ifFalse: [self addConflictWithOperation:
														(MCModification of: other to: targetDefinition)]]]
		ifAbsent: [self addConflictWithOperation: (MCAddition of: targetDefinition)]
%
run
MCThreeWayMerger setStamp: 'ab 6/2/2003 01:34' forMethod: #modifyDefinition:to:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
operations
	^ operations ifNil: [operations := OrderedCollection new]
%
run
MCThreeWayMerger setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #operations.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
provisions
	^ provisions
%
run
MCThreeWayMerger setStamp: 'avi 10/6/2004 15:19' forMethod: #provisions.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
redundantAdds
	^ redundantAdds ifNil: [redundantAdds := Set new]
%
run
MCThreeWayMerger setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #redundantAdds.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
removalForDefinition: aDefinition
	^ operations ifNotNil:
		[operations
			detect: [:ea | (ea definition isRevisionOf: aDefinition) and: [ea isRemoval]]
			ifNone: []]
%
run
MCThreeWayMerger setStamp: 'avi 9/19/2005 02:40' forMethod: #removalForDefinition:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
removeConflict: aConflict
	conflicts remove: aConflict
%
run
MCThreeWayMerger setStamp: 'avi 9/19/2005 02:40' forMethod: #removeConflict:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
removeDefinition: aDefinition
	index
		definitionLike: aDefinition
		ifPresent: [ :other | 
			| c |
			other = aDefinition
				ifTrue: [ 
					(c := self modificationConflictForDefinition: aDefinition) ~~ nil
						ifTrue: [ 
							self addOperation: c operation.
							self removeConflict: c.
							^ self ].
					(self redundantAdds includes: aDefinition)
						ifFalse: [ self addOperation: (MCRemoval of: aDefinition) ] ]
				ifFalse: [ self addConflictWithOperation: (MCRemoval of: other) ] ]
		ifAbsent: [  ]
%
run
MCThreeWayMerger setStamp: 'DaleHenrichs 9/27/2010 16:50' forMethod: #removeDefinition:.
true
%

category: 'as yet unclassified'
method: MCThreeWayMerger
removeOperation: anOperation
	operations remove: anOperation
%
run
MCThreeWayMerger setStamp: 'avi 9/19/2005 02:40' forMethod: #removeOperation:.
true
%

category: 'as yet unclassified'
classmethod: MCMock
wantsChangeSetLogging
	^ false
%
run
MCMock class setStamp: 'cwp 7/21/2003 19:40' forMethod: #wantsChangeSetLogging.
true
%

category: 'as yet unclassified'
method: MCMockASubclass
variables
	^ x + Y + MCMockClassA
%
run
MCMockASubclass setStamp: 'ab 7/7/2003 23:21' forMethod: #variables.
true
%

category: 'as yet unclassified'
method: MCMockASubclass
variables2
	^ ivar + CVar
%
run
MCMockASubclass setStamp: 'ab 7/7/2003 23:21' forMethod: #variables2.
true
%

category: 'as yet unclassified'
classmethod: MCMockClassA
cVar
	^ CVar
%
run
MCMockClassA class setStamp: 'cwp 8/10/2003 02:31' forMethod: #cVar.
true
%

category: 'as yet unclassified'
classmethod: MCMockClassA
initialize
	CVar := #initialized
%
run
MCMockClassA class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initialize.
true
%

category: 'as yet unclassified'
classmethod: MCMockClassA
one

	^ 1
%
run
MCMockClassA class setStamp: 'ab 7/7/2003 23:21' forMethod: #one.
true
%

category: 'as yet unclassified'
classmethod: MCMockClassA
touchCVar
	CVar := #touched
%
run
MCMockClassA class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #touchCVar.
true
%

category: 'numeric'
method: MCMockClassA
a
	^ 'a2'
%
run
MCMockClassA setStamp: '' forMethod: #a.
true
%

category: 'numeric'
method: MCMockClassA
b
	^ 'b1'
%
run
MCMockClassA setStamp: '' forMethod: #b.
true
%

category: 'numeric'
method: MCMockClassA
c
	^ 'c1'
%
run
MCMockClassA setStamp: '' forMethod: #c.
true
%

category: 'as yet classified'
method: MCMockClassA
d
	^ 'd'
%
run
MCMockClassA setStamp: '' forMethod: #d.
true
%

category: 'boolean'
method: MCMockClassA
falsehood
	^ false
%
run
MCMockClassA setStamp: 'cwp 7/13/2003 02:49' forMethod: #falsehood.
true
%

category: 'boolean'
method: MCMockClassA
moreTruth

	^ true
%
run
MCMockClassA setStamp: 'ab 7/7/2003 23:21' forMethod: #moreTruth.
true
%

category: 'numeric'
method: MCMockClassA
one
	^ 1
%
run
MCMockClassA setStamp: 'cwp 8/2/2003 17:26' forMethod: #one.
true
%

category: 'drag''n''drop'
method: MCMockClassA
q
%
run
MCMockClassA setStamp: 'avi 9/23/2003 17:14' forMethod: #q.
true
%

category: 'boolean'
method: MCMockClassA
truth
	^ true
%
run
MCMockClassA setStamp: '' forMethod: #truth.
true
%

category: 'numeric'
method: MCMockClassA
two
	^ 2
%
run
MCMockClassA setStamp: 'avi 9/11/2004 15:59' forMethod: #two.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
<= other
	^ self name <= other name
%
run
MCMockDependentItem setStamp: 'bf 5/20/2005 16:15' forMethod: #'<='.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
name

	^ name
%
run
MCMockDependentItem setStamp: 'ab 7/7/2003 23:21' forMethod: #name.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
name: aString

	name := aString
%
run
MCMockDependentItem setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #name:.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
provides: anArray

	provides := anArray
%
run
MCMockDependentItem setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #provides:.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
provisions

	^ provides ifNil: [#()]
%
run
MCMockDependentItem setStamp: 'ab 7/7/2003 23:21' forMethod: #provisions.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
requirements

	^ requires ifNil: [#()]
%
run
MCMockDependentItem setStamp: 'ab 7/7/2003 23:21' forMethod: #requirements.
true
%

category: 'as yet unclassified'
method: MCMockDependentItem
requires: anArray

	requires := anArray
%
run
MCMockDependentItem setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #requires:.
true
%

category: 'as yet unclassified'
method: MCMockClassD
one
	^ 1
%
run
MCMockClassD setStamp: 'cwp 7/8/2003 21:21' forMethod: #one.
true
%

category: 'as yet unclassified'
classmethod: MCMockClassE
two
	^ 2
%
run
MCMockClassE class setStamp: 'cwp 7/8/2003 21:22' forMethod: #two.
true
%

category: 'instance creation'
classmethod: MCMockDependency
fromTree: anArray 
	^ self new initializeWithTree: anArray
%
run
MCMockDependency class setStamp: 'cwp 11/7/2004 14:43' forMethod: #fromTree:.
true
%

category: 'comparing'
method: MCMockDependency
= other
	^ self name = other name
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 13:32' forMethod: #=.
true
%

category: 'accessing'
method: MCMockDependency
children
	^ children collect: [:ea | self class fromTree: ea]
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 14:43' forMethod: #children.
true
%

category: 'resolving'
method: MCMockDependency
hasResolution
	^ hasResolution
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 14:42' forMethod: #hasResolution.
true
%

category: 'comparing'
method: MCMockDependency
hash
	^ self name hash
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 13:33' forMethod: #hash.
true
%

category: 'accessing'
method: MCMockDependency
initializeWithTree: expr
	expr isSymbol
		ifTrue: [name := expr.
				children := Array new.
				hasResolution := true.]
		ifFalse: [name := expr at: 1.
				(expr at: 2) isSymbol
					ifTrue: [hasResolution := false.
							children := Array new]
					ifFalse: [hasResolution := true.
							children := (expr at: 2)]]
%
run
MCMockDependency setStamp: 'DaleHenrichs 10/8/2010 11:41' forMethod: #initializeWithTree:.
true
%

category: 'mocks'
method: MCMockDependency
mockVersionInfo
	^ MCVersionInfo
		name: self name
		id: (self uuidForName: name)
		message: ''
		date: nil
		time: nil
		author: ''
		ancestors: #()
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 14:41' forMethod: #mockVersionInfo.
true
%

category: 'accessing'
method: MCMockDependency
name
	^ name
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 14:38' forMethod: #name.
true
%

category: 'resolving'
method: MCMockDependency
resolve
	^ self hasResolution
		ifTrue: [MCVersion new
					setPackage: MCSnapshotResource mockPackage
					info: self mockVersionInfo
					snapshot: MCSnapshotResource current snapshot
					dependencies: self children]
		ifFalse: [nil]
%
run
MCMockDependency setStamp: 'cwp 11/7/2004 14:16' forMethod: #resolve.
true
%

category: 'mocks'
method: MCMockDependency
uuidForName: aName 
	| nm id |
	nm := aName asString.
	id := '00000000-0000-0000-0000-0000000000' 
				, (nm size = 1 ifTrue: [nm , '0'] ifFalse: [nm]).
	^UUID fromString: id
%
run
MCMockDependency setStamp: 'nk 2/22/2005 21:17' forMethod: #uuidForName:.
true
%

category: 'as yet unclassified'
classmethod: MCPackage
named: aString
	^ self new name: aString
%
run
MCPackage class setStamp: 'ab 7/10/2003 01:17' forMethod: #named:.
true
%

category: 'comparing'
method: MCPackage
= other
	^ other species = self species and: [other name sameAs: name]
%
run
MCPackage setStamp: 'ar 4/26/2005 21:57' forMethod: #=.
true
%

category: 'working copies'
method: MCPackage
hasWorkingCopy
	^ MCWorkingCopy registry includesKey: self
%
run
MCPackage setStamp: 'bf 4/19/2005 16:26' forMethod: #hasWorkingCopy.
true
%

category: 'comparing'
method: MCPackage
hash
	^ name asLowercase hash
%
run
MCPackage setStamp: 'ar 4/26/2005 21:57' forMethod: #hash.
true
%

category: 'accessing'
method: MCPackage
name
	^ name
%
run
MCPackage setStamp: 'ab 7/7/2003 00:57' forMethod: #name.
true
%

category: 'accessing'
method: MCPackage
name: aString
	name := aString
%
run
MCPackage setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #name:.
true
%

category: 'accessing'
method: MCPackage
packageInfo
	^ PackageInfo named: name
%
run
MCPackage setStamp: 'ab 7/7/2003 13:33' forMethod: #packageInfo.
true
%

category: 'printing'
method: MCPackage
printOn: aStream
	super printOn: aStream.
	aStream
		nextPut: $(;
		nextPutAll: name;
		nextPut: $)
%
run
MCPackage setStamp: 'nk 7/28/2003 13:30' forMethod: #printOn:.
true
%

category: 'accessing'
method: MCPackage
snapshot
	| packageInfo definitions categories |
	packageInfo := self packageInfo.
	definitions := OrderedCollection new.
	categories := packageInfo systemCategories.
	categories isEmpty
		ifFalse: [ definitions add: (MCOrganizationDefinition categories: categories) ].
	MCPlatform current
		for: packageInfo methods
		do: [ :ea | definitions add: ea asMethodDefinition ]
		displayingProgress: 'Snapshotting methods...'.
	(packageInfo respondsTo: #overriddenMethods)
		ifTrue: [ 
			MCPlatform current
				for: packageInfo overriddenMethods
				do: [ :ea | definitions add: (packageInfo changeRecordForOverriddenMethod: ea) asMethodDefinition ]
				displayingProgress: 'Searching for overrides...' ].
	MCPlatform current
		for: packageInfo classes
		do: [ :ea | definitions addAll: ea classDefinitions ]
		displayingProgress: 'Snapshotting classes...'.
	(packageInfo respondsTo: #hasPreamble)
		ifTrue: [ 
			packageInfo hasPreamble
				ifTrue: [ definitions add: (MCPreambleDefinition from: packageInfo) ].
			packageInfo hasPostscript
				ifTrue: [ definitions add: (MCPostscriptDefinition from: packageInfo) ].
			packageInfo hasPreambleOfRemoval
				ifTrue: [ definitions add: (MCRemovalPreambleDefinition from: packageInfo) ].
			packageInfo hasPostscriptOfRemoval
				ifTrue: [ definitions add: (MCRemovalPostscriptDefinition from: packageInfo) ] ].
	^ MCSnapshot fromDefinitions: definitions
%
run
MCPackage setStamp: 'DaleHenrichs 9/28/2010 16:21' forMethod: #snapshot.
true
%

category: 'printing'
method: MCPackage
storeOn: aStream
	aStream
		nextPutAll: 'MCPackage';
		space; nextPutAll: 'named: '; store: name.
%
run
MCPackage setStamp: 'ab 7/10/2003 01:13' forMethod: #storeOn:.
true
%

category: 'working copies'
method: MCPackage
unload
	^ self workingCopy unload
%
run
MCPackage setStamp: 'cwp 11/13/2003 13:32' forMethod: #unload.
true
%

category: 'working copies'
method: MCPackage
workingCopy
	^ MCWorkingCopy forPackage: self.
%
run
MCPackage setStamp: 'cwp 11/13/2003 13:33' forMethod: #workingCopy.
true
%

category: 'as yet unclassified'
classmethod: MCPackageCache
new
	^ self basicNew initialize
%
run
MCPackageCache class setStamp: 'avi 1/22/2004 18:12' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCPackageCache
initialize
	sorter := MCVersionSorter new.
	fileNames := Dictionary new.
%
run
MCPackageCache setStamp: 'DaleHenrichs 9/29/2010 16:37' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCPackageCache
recordVersionInfo: aVersionInfo forFileNamed: aString
	fileNames at: aVersionInfo put: aString.
	sorter addVersionInfo: aVersionInfo
%
run
MCPackageCache setStamp: 'AdrianLienhard 1/21/2010 22:14' forMethod: #recordVersionInfo:forFileNamed:.
true
%

category: 'as yet unclassified'
method: MCPackageCache
versionInfos
	^ sorter sortedVersionInfos 
%
run
MCPackageCache setStamp: 'avi 1/22/2004 18:21' forMethod: #versionInfos.
true
%

category: 'private'
method: MCMultiPackageLoader
analyze
	| index |
	index := MCDefinitionIndex definitions: additions.
	removals removeAllSuchThat: [:removal |
		(index definitionLike: removal
			ifPresent: [:addition | obsoletions at: addition put: removal]
			ifAbsent: []) notNil].
	super analyze
%
run
MCMultiPackageLoader setStamp: 'bf 3/17/2006 15:51' forMethod: #analyze.
true
%

category: 'as yet unclassified'
classmethod: MCPackageLoader
installSnapshot: aSnapshot
	self new
		installSnapshot: aSnapshot;
		load
%
run
MCPackageLoader class setStamp: 'ab 7/6/2003 23:30' forMethod: #installSnapshot:.
true
%

category: 'instance creation'
classmethod: MCPackageLoader
new

	^ self basicNew initialize

%
run
MCPackageLoader class setStamp: 'DaleHenrichs 9/29/2010 16:38' forMethod: #new.
true
%

category: 'as yet unclassified'
classmethod: MCPackageLoader
unloadPackage: aPackage
	self new
		unloadPackage: aPackage;
		loadWithNameLike: aPackage name, '-unload'
%
run
MCPackageLoader class setStamp: 'bf 12/5/2004 12:00' forMethod: #unloadPackage:.
true
%

category: 'as yet unclassified'
classmethod: MCPackageLoader
updatePackage: aPackage withSnapshot: aSnapshot
	self new
		updatePackage: aPackage withSnapshot: aSnapshot;
		load
%
run
MCPackageLoader class setStamp: 'ab 7/7/2003 12:11' forMethod: #updatePackage:withSnapshot:.
true
%

category: 'patch ops'
method: MCPackageLoader
addDefinition: aDefinition

	additions add: aDefinition
%
run
MCPackageLoader setStamp: 'ab 5/24/2003 16:13' forMethod: #addDefinition:.
true
%

category: 'private'
method: MCPackageLoader
analyze
	| sorter |
	sorter := self sorterForItems: additions.
	additions := sorter orderedItems.
	requirements := sorter externalRequirements.
	unloadableDefinitions := sorter itemsWithMissingRequirements asSortedCollection.
	
	sorter := self sorterForItems: removals.
	removals := sorter orderedItems reverse.
%
run
MCPackageLoader setStamp: 'DaleHenrichs 10/6/2010 15:18' forMethod: #analyze.
true
%

category: 'private'
method: MCPackageLoader
basicLoad
	errorDefinitions := OrderedCollection new.
	MCPlatform current
		basicPackageLoad: [ 
			"FIXME. Do a separate pass on loading class definitions as the very first thing.
	This is a workaround for a problem with the so-called 'atomic' loading (you wish!)
	which isn't atomic at all but mixes compilation of methods with reshapes of classes.

	Since the method is not installed until later, any class reshape in the middle *will*
	affect methods in subclasses that have been compiled before. There is probably
	a better way of dealing with this by ensuring that the sort order of the definition lists
	superclass definitions before methods for subclasses but I need this NOW, and adding
	an extra pass ensures that methods are compiled against their new class definitions."
			MCPlatform current for: additions do: [ :ea | self loadClassDefinition: ea ] displayingProgress: 'Loading classes...'.
			MCPlatform current for: additions do: [ :ea | self tryToLoad: ea ] displayingProgress: 'Compiling methods...'.
                        MCPlatform current for: removals do: [ :ea | 
				GsFile gciLogServer: 'definition unloaded: ', ea printString printString.
				ea unload ] displayingProgress: 'Cleaning up...'.
			self shouldWarnAboutErrors
				ifTrue: [ self warnAboutErrors ].
			MCPlatform current
				for: errorDefinitions
				do: [ :ea | ea addMethodAdditionTo: methodAdditions ]
				displayingProgress: 'Reloading...'.
			methodAdditions do: [ :each | 
                            GsFile gciLogServer: 'method installed: ', each myClass name asString, '>>', each selector asString.
                            each installMethod ].
			methodAdditions do: [ :each | each notifyObservers ].
			MCPlatform current
				for: additions
				do: [ :ea | ea postloadOver: (self obsoletionFor: ea) ]
				displayingProgress: 'Initializing...' ]
		for: self
%
run
MCPackageLoader setStamp: 'DaleHenrichs 10/7/2010 12:18' forMethod: #basicLoad.
true
%

category: 'private'
method: MCPackageLoader
dependencyWarning
	^ String streamContents:
		[:s |
		s nextPutAll: 'This package depends on the following classes:'; cr.
		requirements do: [:ea | s space; space; nextPutAll: ea; cr].
		s nextPutAll: 'You must resolve these dependencies before you will be able to load these definitions: '; cr.
		unloadableDefinitions do: [:ea | s space; space; nextPutAll: ea summary; cr]] 
%
run
MCPackageLoader setStamp: 'ab 5/25/2003 01:24' forMethod: #dependencyWarning.
true
%

category: 'private'
method: MCPackageLoader
errorDefinitionWarning
	^ String streamContents:
		[:s |
		s nextPutAll: 'The following definitions had errors while loading.  Press Proceed to try to load them again (they may work on a second pass):'; cr.
		errorDefinitions do: [:ea | s space; space; nextPutAll: ea summary; cr]
] 
%
run
MCPackageLoader setStamp: 'avi 1/24/2004 17:44' forMethod: #errorDefinitionWarning.
true
%

method: MCPackageLoader
notify: aString
  (SessionTemps current at: #MCPackageLoader_stopOnWarnings otherwise: true) ifTrue:[
    super notify: aString . 
  ] ifFalse:[
    GsFile gciLogServer: aString .
    GsFile gciLogServer: 'MCPackageLoader_stopOnWarnings==false, continuing' .
  ]
%

category: 'private'
method: MCPackageLoader
initialize
	additions := OrderedCollection new.
	removals := OrderedCollection new.
	obsoletions := Dictionary new.
	methodAdditions := OrderedCollection new. 

%
run
MCPackageLoader setStamp: 'DaleHenrichs 9/29/2010 16:37' forMethod: #initialize.
true
%

category: 'public'
method: MCPackageLoader
installSnapshot: aSnapshot
	| patch |
	patch := aSnapshot patchRelativeToBase: MCSnapshot empty.
	patch applyTo: self.

%
run
MCPackageLoader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #installSnapshot:.
true
%

category: 'public'
method: MCPackageLoader
load
	self analyze.
	unloadableDefinitions isEmpty ifFalse: [self warnAboutDependencies].
	MCPlatform current useNewChangeSetDuring: [self basicLoad]
%
run
MCPackageLoader setStamp: 'DaleHenrichs 9/28/2010 15:01' forMethod: #load.
true
%

category: 'private'
method: MCPackageLoader
loadClassDefinition: aDefinition

[ aDefinition isClassDefinition ifTrue:[ 
    GsFile gciLogServer: 'class created: ', aDefinition className asString printString. 
    aDefinition load]
] on: Error do: [:ex | ex pass. 
  GsFile gciLogServer: 'class def error: ', ex description. 
  errorDefinitions add: aDefinition
].
%

category: 'public'
method: MCPackageLoader
loadWithName: baseName
	self analyze.
	unloadableDefinitions isEmpty ifFalse: [self warnAboutDependencies].
	MCPlatform current useChangeSetNamed: baseName during: [self basicLoad]
%
run
MCPackageLoader setStamp: 'DaleHenrichs 9/28/2010 15:03' forMethod: #loadWithName:.
true
%

category: 'public'
method: MCPackageLoader
loadWithNameLike: baseName
	self analyze.
	unloadableDefinitions isEmpty ifFalse: [self warnAboutDependencies].
	MCPlatform current useNewChangeSetNamedLike: baseName during: [self basicLoad]
%
run
MCPackageLoader setStamp: 'DaleHenrichs 9/28/2010 15:02' forMethod: #loadWithNameLike:.
true
%

category: 'patch ops'
method: MCPackageLoader
modifyDefinition: old to: new
	self addDefinition: new.
	obsoletions at: new put: old.
%
run
MCPackageLoader setStamp: 'avi 2/17/2004 13:14' forMethod: #modifyDefinition:to:.
true
%

category: 'private'
method: MCPackageLoader
obsoletionFor: aDefinition
	^ obsoletions at: aDefinition ifAbsent: [nil]
%
run
MCPackageLoader setStamp: 'avi 2/17/2004 13:15' forMethod: #obsoletionFor:.
true
%

category: 'private'
method: MCPackageLoader
orderDefinitionsForLoading: aCollection
	^ (self sorterForItems: aCollection) orderedItems
%
run
MCPackageLoader setStamp: 'ab 5/25/2003 01:19' forMethod: #orderDefinitionsForLoading:.
true
%

category: 'private'
method: MCPackageLoader
orderedAdditions
	^ additions
%
run
MCPackageLoader setStamp: 'ab 5/24/2003 16:52' forMethod: #orderedAdditions.
true
%

category: 'private'
method: MCPackageLoader
provisions
	^ provisions ifNil: [provisions := Set withAll: MCPlatform current globalNames]
%
run
MCPackageLoader setStamp: 'DaleHenrichs 10/1/2010 14:47' forMethod: #provisions.
true
%

category: 'patch ops'
method: MCPackageLoader
removeDefinition: aDefinition
	removals add: aDefinition
%
run
MCPackageLoader setStamp: 'ab 5/24/2003 16:14' forMethod: #removeDefinition:.
true
%

category: 'private'
method: MCPackageLoader
shouldWarnAboutErrors
	^ errorDefinitions isEmpty not and: [true "should make this a setting ?"]
%
run
MCPackageLoader setStamp: 'AlainPlantec 1/7/2010 22:20' forMethod: #shouldWarnAboutErrors.
true
%

category: 'private'
method: MCPackageLoader
sorterForItems: aCollection
	| sorter |
	sorter := MCDependencySorter items: aCollection.
	sorter addExternalProvisions: self provisions.
	^ sorter
%
run
MCPackageLoader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #sorterForItems:.
true
%

category: 'private'
method: MCPackageLoader
tryToLoad: aDefinition
	[aDefinition addMethodAdditionTo: methodAdditions] on: Error do: [:ex | "GsFile gciLogServer: 'method def error: ', ex description." errorDefinitions add: aDefinition ].
%
run
MCPackageLoader setStamp: 'DaleHenrichs 10/1/2010 14:49' forMethod: #tryToLoad:.
true
%

category: 'public'
method: MCPackageLoader
unloadPackage: aPackage
	self updatePackage: aPackage withSnapshot: MCSnapshot empty
%
run
MCPackageLoader setStamp: 'avi 10/5/2003 11:09' forMethod: #unloadPackage:.
true
%

category: 'public'
method: MCPackageLoader
updatePackage: aPackage withSnapshot: aSnapshot
	|  patch packageSnap |
	packageSnap := aPackage snapshot.
	patch := aSnapshot patchRelativeToBase: packageSnap.
	patch applyTo: self.
	packageSnap definitions do: [:ea | self provisions addAll: ea provisions]

%
run
MCPackageLoader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #updatePackage:withSnapshot:.
true
%

category: 'private'
method: MCPackageLoader
warnAboutDependencies 
	self notify: self dependencyWarning
%
run
MCPackageLoader setStamp: 'ab 5/25/2003 01:22' forMethod: #warnAboutDependencies.
true
%

category: 'private'
method: MCPackageLoader
warnAboutErrors
	self notify: self errorDefinitionWarning.

%
run
MCPackageLoader setStamp: 'avi 1/24/2004 17:42' forMethod: #warnAboutErrors.
true
%

category: 'as yet unclassified'
classmethod: MCPackageManager
allManagers
	^ self registry values
%
run
MCPackageManager class setStamp: 'ab 3/31/2003 20:45' forMethod: #allManagers.
true
%

category: 'system changes'
classmethod: MCPackageManager
classModified: anEvent
	self managersForClass: anEvent item do:[:mgr| mgr modified: true].
%
run
MCPackageManager class setStamp: 'ar 4/27/2005 14:28' forMethod: #classModified:.
true
%

category: 'system changes'
classmethod: MCPackageManager
classMoved: anEvent
	self classModified: anEvent.
	self managersForCategory: anEvent oldCategory do:[:mgr| mgr modified: true].
%
run
MCPackageManager class setStamp: 'ar 4/26/2005 21:31' forMethod: #classMoved:.
true
%

category: 'system changes'
classmethod: MCPackageManager
classRemoved: anEvent
	self classModified: anEvent
%
run
MCPackageManager class setStamp: 'ar 4/26/2005 21:31' forMethod: #classRemoved:.
true
%

category: 'as yet unclassified'
classmethod: MCPackageManager
forPackage: aPackage
	^ self registry at: aPackage ifAbsent:
		[|mgr|
		mgr := self new initializeWithPackage: aPackage.
		self registry at: aPackage put: mgr.
		mgr]
%
run
MCPackageManager class setStamp: 'DaleHenrichs 10/1/2010 15:05' forMethod: #forPackage:.
true
%

category: 'system changes'
classmethod: MCPackageManager
managersForCategory: aSystemCategory do: aBlock
	"Got to be careful here - we might get method categories where capitalization is problematic."
	| cat foundOne index |
	foundOne := false.
	cat := aSystemCategory ifNil:[^nil]. "yes this happens; for example in eToy projects"
	"first ask PackageInfos, their package name might not match the category"
	self registry do: [:mgr | 
		(mgr packageInfo includesSystemCategory: aSystemCategory)	ifTrue: [
			aBlock value: mgr.
			foundOne := true.
		]
	].
	foundOne ifTrue: [^self].
	["Loop over categories until we found a matching one"
	self registry at: (MCPackage named: cat) ifPresent:[:mgr|
		aBlock value: mgr.
		foundOne := true.
	].
	index := cat lastIndexOf: $-.
	index > 0]whileTrue:[
		"Step up to next level package"
		cat := cat copyFrom: 1 to: index-1.
	].
	foundOne ifFalse:[
		"Create a new (but only top-level)"
		aBlock value: (MCWorkingCopy forPackage: (MCPackage named: (aSystemCategory copyUpTo: $-) capitalized)).
	].
%
run
MCPackageManager class setStamp: 'md 3/14/2006 23:11' forMethod: #managersForCategory:do:.
true
%

category: 'system changes'
classmethod: MCPackageManager
managersForClass: aClass category: methodCategory do: aBlock
	(methodCategory isEmptyOrNil or:[methodCategory first ~= $*]) ifTrue:[
		"Not an extension method"
		^self managersForClass: aClass do: aBlock.
	].
	self managersForCategory: methodCategory allButFirst do: aBlock.
%
run
MCPackageManager class setStamp: 'ar 4/27/2005 14:11' forMethod: #managersForClass:category:do:.
true
%

category: 'system changes'
classmethod: MCPackageManager
managersForClass: aClass do: aBlock

	self registry do: [:mgr |
		(mgr packageInfo includesClass: aClass)
			ifTrue: [aBlock value: mgr]]
%
run
MCPackageManager class setStamp: 'bf 5/20/2005 16:50' forMethod: #managersForClass:do:.
true
%

category: 'system changes'
classmethod: MCPackageManager
managersForClass: aClass selector: aSelector do: aBlock
	^self managersForClass: aClass category: (MCPlatform current categoryOfSelector: aSelector for: aClass) do: aBlock
%
run
MCPackageManager class setStamp: 'DaleHenrichs 10/7/2010 15:17' forMethod: #managersForClass:selector:do:.
true
%

category: 'system changes'
classmethod: MCPackageManager
methodModified: anEvent
	^self managersForClass: anEvent itemClass selector: anEvent itemSelector do:[:mgr| mgr modified: true].
%
run
MCPackageManager class setStamp: 'ar 4/26/2005 21:40' forMethod: #methodModified:.
true
%

category: 'system changes'
classmethod: MCPackageManager
methodMoved: anEvent
	self managersForClass: anEvent itemClass category: anEvent oldCategory do:[:mgr| mgr modified: true].
	self methodModified: anEvent.
%
run
MCPackageManager class setStamp: 'ar 4/26/2005 21:40' forMethod: #methodMoved:.
true
%

category: 'system changes'
classmethod: MCPackageManager
methodRemoved: anEvent
	self managersForClass: anEvent itemClass category: anEvent itemProtocol do:[:mgr| mgr modified: true].

%
run
MCPackageManager class setStamp: 'ar 4/26/2005 22:12' forMethod: #methodRemoved:.
true
%

category: 'instance creation'
classmethod: MCPackageManager
new

	^ self basicNew initialize

%
run
MCPackageManager class setStamp: 'DaleHenrichs 9/29/2010 16:38' forMethod: #new.
true
%

category: 'as yet unclassified'
classmethod: MCPackageManager
registry
	^ MCPlatform current packageManagerRegistryFor: self
%
run
MCPackageManager class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #registry.
true
%


category: 'initialization'
method: MCPackageManager
initialize
	modified := false.
	self registerForNotifications.
%
run
MCPackageManager setStamp: 'DaleHenrichs 9/29/2010 16:38' forMethod: #initialize.
true
%

category: 'initialization'
method: MCPackageManager
initializeWithPackage: aPackage
	package := aPackage.
	self initialize.
%
run
MCPackageManager setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithPackage:.
true
%

category: 'system changes'
method: MCPackageManager
methodModified: anEvent
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #methodModified:.
true
%

category: 'system changes'
method: MCPackageManager
methodMoved: anEvent 
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #methodMoved:.
true
%

category: 'system changes'
method: MCPackageManager
methodRemoved: anEvent
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #methodRemoved:.
true
%

category: 'accessing'
method: MCPackageManager
modified
	^ modified
%
run
MCPackageManager setStamp: 'cwp 11/13/2003 14:12' forMethod: #modified.
true
%

category: 'accessing'
method: MCPackageManager
modified: aBoolean
	modified = aBoolean
		ifTrue: [ ^ self ].
	modified := aBoolean.

%
run
MCPackageManager setStamp: 'DaleHenrichs 10/1/2010 15:10' forMethod: #modified:.
true
%

category: 'accessing'
method: MCPackageManager
package
	^ package
%
run
MCPackageManager setStamp: 'ab 7/7/2003 16:47' forMethod: #package.
true
%

category: 'accessing'
method: MCPackageManager
packageInfo
	^ package packageInfo
%
run
MCPackageManager setStamp: 'ab 7/7/2003 13:33' forMethod: #packageInfo.
true
%

category: 'accessing'
method: MCPackageManager
packageName
	^ package name
%
run
MCPackageManager setStamp: 'ab 7/7/2003 12:18' forMethod: #packageName.
true
%

category: 'accessing'
method: MCPackageManager
packageNameWithStar
	^ modified
		ifTrue: ['* ', self packageName]
		ifFalse: [self packageName]
%
run
MCPackageManager setStamp: 'ab 7/5/2003 23:18' forMethod: #packageNameWithStar.
true
%

category: 'system changes'
method: MCPackageManager
registerForNotifications
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #registerForNotifications.
true
%

category: 'system changes'
method: MCPackageManager
registerForNotificationsFrom: aNotifier
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #registerForNotificationsFrom:.
true
%

category: 'system changes'
method: MCPackageManager
systemChange: anEvent
	"obsolete - remove this later"
%
run
MCPackageManager setStamp: 'ar 4/26/2005 22:17' forMethod: #systemChange:.
true
%

category: 'operations'
method: MCPackageManager
unregister
	self class registry removeKey: package.

%
run
MCPackageManager setStamp: 'DaleHenrichs 10/1/2010 14:57' forMethod: #unregister.
true
%

category: 'as yet unclassified'
classmethod: MCWorkingCopy
adoptVersionInfoFrom: anInstaller
	|viCache|
	viCache := Dictionary new.
	anInstaller versionInfo keysAndValuesDo: [:packageName :info |
		(self forPackage: (MCPackage named: packageName))
			versionInfo: (self infoFromDictionary:  info cache: viCache)].
	[anInstaller clearVersionInfo] on: Error do: ["backwards compat"].
%
run
MCWorkingCopy class setStamp: 'avi 9/13/2004 18:00' forMethod: #adoptVersionInfoFrom:.
true
%

category: 'as yet unclassified'
classmethod: MCWorkingCopy
ancestorsFromArray: anArray cache: aDictionary
	^ anArray ifNotNil: [anArray collect: [:dict | self infoFromDictionary: dict cache: aDictionary]]
%
run
MCWorkingCopy class setStamp: 'avi 2/17/2004 01:23' forMethod: #ancestorsFromArray:cache:.
true
%

category: 'as yet unclassified'
classmethod: MCWorkingCopy
infoFromDictionary: aDictionary cache: cache
	| id |
	id := aDictionary at: #id.
	^ cache at: id ifAbsentPut:
		[MCVersionInfo
			name: (aDictionary at: #name)
			id: (aDictionary at: #id)
			message: (aDictionary at: #message)
			date: (aDictionary at: #date)
			time: (aDictionary at: #time)
			author: (aDictionary at: #author)
			ancestors: (self ancestorsFromArray: (aDictionary at: #ancestors) cache: cache)]
%
run
MCWorkingCopy class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #infoFromDictionary:cache:.
true
%

category: 'as yet unclassified'
classmethod: MCWorkingCopy
updateInstVars
	self allInstances do: [:ea | ea updateInstVars]
%
run
MCWorkingCopy class setStamp: 'avi 2/17/2004 02:36' forMethod: #updateInstVars.
true
%

category: 'operations'
method: MCWorkingCopy
adopt: aVersion
	ancestry addAncestor: aVersion info.
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 01:07' forMethod: #adopt:.
true
%

category: 'accessing'
method: MCWorkingCopy
ancestors
	^ ancestry ancestors
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 01:07' forMethod: #ancestors.
true
%

category: 'accessing'
method: MCWorkingCopy
ancestry
	^ ancestry
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 01:13' forMethod: #ancestry.
true
%

category: 'operations'
method: MCWorkingCopy
backportChangesTo: aVersionInfo
	| baseVersion fullPatch currentVersionInfo currentVersion newSnapshot newAncestry partialPatch |
	currentVersionInfo := self currentVersionInfo.
	baseVersion := self repositoryGroup versionWithInfo: aVersionInfo.
	currentVersion := self repositoryGroup versionWithInfo: currentVersionInfo.
	fullPatch := currentVersion snapshot patchRelativeToBase: baseVersion snapshot.
	(partialPatch := (MCChangeSelectionRequest new)
		patch: fullPatch;
		label: 'Changes to Backport';
		signal) ~~ nil
		ifTrue: [ 
			newSnapshot := MCPatcher apply: partialPatch to: baseVersion snapshot.
			newAncestry := (MCWorkingAncestry new)
				addAncestor: aVersionInfo;
				addStepChild: currentVersionInfo;
				yourself.
			MCPackageLoader updatePackage: package withSnapshot: newSnapshot.
			ancestry := newAncestry.
			self
				modified: false;
				modified: true ]
%
run
MCWorkingCopy setStamp: 'DaleHenrichs 9/27/2010 17:00' forMethod: #backportChangesTo:.
true
%

category: 'operations'
method: MCWorkingCopy
changesRelativeToRepository: aRepository
	| ancestorVersion ancestorSnapshot |
	ancestorVersion := aRepository closestAncestorVersionFor: ancestry ifNone: [].
	ancestorSnapshot := ancestorVersion ifNil: [MCSnapshot empty] ifNotNil: [ancestorVersion snapshot].
	^ package snapshot patchRelativeToBase: ancestorSnapshot
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #changesRelativeToRepository:.
true
%

category: 'accessing'
method: MCWorkingCopy
clearRequiredPackages
	requiredPackages := nil
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #clearRequiredPackages.
true
%

category: 'accessing'
method: MCWorkingCopy
currentVersionInfo
	^ (self needsSaving or: [ancestry ancestors isEmpty])
		ifTrue: [self newVersion info]
		ifFalse: [ancestry ancestors first]
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 20:01' forMethod: #currentVersionInfo.
true
%

category: 'accessing'
method: MCWorkingCopy
currentVersionInfoWithMessage: aMessageString
	^ (self needsSaving or: [ancestry ancestors isEmpty])
		ifTrue: [(self newVersionWithMessage: aMessageString) info]
		ifFalse: [ancestry ancestors first]
%
run
MCWorkingCopy setStamp: 'AndrewBlack 9/4/2009 14:00' forMethod: #currentVersionInfoWithMessage:.
true
%

category: 'accessing'
method: MCWorkingCopy
description
	^ self packageNameWithStar, ' (', ancestry ancestorString, ')'
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 01:05' forMethod: #description.
true
%

category: 'private'
method: MCWorkingCopy
findSnapshotWithVersionInfo: aVersionInfo
	"when an ancestor inside the ancestor chain is not found, does not pass nil instead.
	With this change we can now browse history and delta between them without having to 
	have the complete history"

	| aVersion |
	^ aVersionInfo
		ifNil: [ MCSnapshot empty ]
		ifNotNil: [ 
			(aVersion := self repositoryGroup versionWithInfo: aVersionInfo)
				ifNil: [ MCSnapshot empty ]
				ifNotNil: [ aVersion snapshot ] ]
%
run
MCWorkingCopy setStamp: 'DaleHenrichs 9/27/2010 17:01' forMethod: #findSnapshotWithVersionInfo:.
true
%

category: 'private'
method: MCWorkingCopy
initialize
	super initialize.
	ancestry := MCWorkingAncestry new
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initialize.
true
%

category: 'operations'
method: MCWorkingCopy
loaded: aVersion
	ancestry := MCWorkingAncestry new addAncestor: aVersion info.
	requiredPackages := OrderedCollection withAll: (aVersion dependencies collect: [:ea | ea package]).
	self modified: false.
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loaded:.
true
%

category: 'operations'
method: MCWorkingCopy
merge: targetVersion
	| ancestorInfo merger ancestorSnapshot packageSnapshot |
	targetVersion dependencies do: [:ea | ea resolve merge].
	ancestorInfo := targetVersion info commonAncestorWith: ancestry.
	
	ancestorInfo = targetVersion info ifTrue: [^ MCNoChangesException signal].
	
	packageSnapshot := package snapshot.
	ancestorSnapshot := ancestorInfo
							ifNotNil: [(self findSnapshotWithVersionInfo: ancestorInfo)]
							ifNil: [self notifyNoCommonAncestorWith: targetVersion.  MCSnapshot empty].
	
	(ancestry ancestors size = 1
		and: [ancestry ancestors first = ancestorInfo
				and: [(packageSnapshot patchRelativeToBase: ancestorSnapshot) isEmpty]])
				ifTrue: [^ targetVersion load].
	
	merger := MCThreeWayMerger 
				base: packageSnapshot
				target: targetVersion snapshot
				ancestor: ancestorSnapshot.
	((MCMergeResolutionRequest new merger: merger)
		signal: 'Merging ', targetVersion info name) = true ifTrue:
			[merger loadWithNameLike: targetVersion info name.
			ancestry addAncestor: targetVersion info].
%
run
MCWorkingCopy setStamp: 'StephaneDucasse 4/27/2010 11:52' forMethod: #merge:.
true
%

category: 'operations'
method: MCWorkingCopy
merged: aVersion
	ancestry addAncestor: aVersion info.
%
run
MCWorkingCopy setStamp: 'abc 2/13/2004 15:57' forMethod: #merged:.
true
%

category: 'accessing'
method: MCWorkingCopy
needsSaving
	^ self modified or: [self requiredPackages anySatisfy: [:ea | ea workingCopy needsSaving]]
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 20:02' forMethod: #needsSaving.
true
%

category: 'operations'
method: MCWorkingCopy
newVersion
	| pair |
	^ (pair := self requestVersionNameAndMessageWithSuggestion: self uniqueVersionName)
		ifNotNil: [ self newVersionWithName: pair first message: pair last ]
%
run
MCWorkingCopy setStamp: 'DaleHenrichs 9/27/2010 17:02' forMethod: #newVersion.
true
%

category: 'operations'
method: MCWorkingCopy
newVersionWithMessage: aMessageString
	^ self newVersionWithName: self uniqueVersionName message: aMessageString.

	"^ (self requestVersionNameAndMessageWithSuggestion: self uniqueVersionName) ifNotNil:
		[:pair |
		self newVersionWithName: pair first message: aMessageString].
	"
%
run
MCWorkingCopy setStamp: 'AndrewBlack 9/4/2009 14:09' forMethod: #newVersionWithMessage:.
true
%

category: 'operations'
method: MCWorkingCopy
newVersionWithName: nameString message: messageString
	
	| info deps |
	info := ancestry infoWithName: nameString message: messageString.
	ancestry := MCWorkingAncestry new addAncestor: info.
	self modified: true; modified: false.
	
	deps := self requiredPackages collect:
		[:ea | 
		MCVersionDependency
			package: ea
			info:  (ea workingCopy currentVersionInfoWithMessage: messageString) ].

	^ MCVersion
		package: package
		info: info
		snapshot: package snapshot
		dependencies: deps
%
run
MCWorkingCopy setStamp: 'AndrewBlack 9/8/2009 07:33' forMethod: #newVersionWithName:message:.
true
%

category: 'private'
method: MCWorkingCopy
nextVersionName
	| branch oldName base author |
	branch := ''.
	ancestry ancestors isEmpty
		ifTrue: [counter ifNil: [counter := 0]. base := package name]
		ifFalse:
			[oldName := ancestry ancestors first name.
			oldName last isDigit
				ifFalse: [base := oldName]
				ifTrue: [
					base := oldName copyUpToLast: $-.
					branch := ((oldName copyAfterLast: $-) copyUpToLast: $.) copyAfter: $. ].
			counter ifNil: [
				counter := (ancestry ancestors collect: [:each |
					each name last isDigit
						ifFalse: [0]
						ifTrue: [(each name copyAfterLast: $.) extractNumber]]) max]].

	branch isEmpty ifFalse: [branch := '.',branch].
	counter := counter + 1.
	author := MCPlatform current authorFullName collect: [ :each | each isAlphaNumeric ifTrue: [ each ] ifFalse: [ $_ ] ].
	^ base , '-' , author , branch , '.' , counter asString
%
run
MCWorkingCopy setStamp: 'DaleHenrichs 10/8/2010 12:27' forMethod: #nextVersionName.
true
%

category: 'operations'
method: MCWorkingCopy
notifyNoCommonAncestorWith: aVersion
	self notify:
'Could not find a common ancestor between (',
aVersion info name,
') and (',
ancestry ancestorString, ').
Proceeding with this merge may cause spurious conflicts.'
%
run
MCWorkingCopy setStamp: 'avi 2/13/2004 01:07' forMethod: #notifyNoCommonAncestorWith:.
true
%

category: 'private'
method: MCWorkingCopy
possiblyNewerVersions

	^Array streamContents: [:strm |
		self repositoryGroup repositories do: [:repo |
			strm nextPutAll: (self possiblyNewerVersionsIn: repo)]]
%
run
MCWorkingCopy setStamp: 'bf 9/8/2005 10:58' forMethod: #possiblyNewerVersions.
true
%

category: 'private'
method: MCWorkingCopy
possiblyNewerVersionsIn: aRepository

	^aRepository possiblyNewerVersionsOfAnyOf: self ancestors
%
run
MCWorkingCopy setStamp: 'bf 9/8/2005 10:58' forMethod: #possiblyNewerVersionsIn:.
true
%

category: 'printing'
method: MCWorkingCopy
printOn: aStream

	super printOn: aStream.
	package name ifNotNil: [ aStream nextPutAll: '(' , package name asString, ')'].
%
run
MCWorkingCopy setStamp: 'sd 3/15/2008 14:13' forMethod: #printOn:.
true
%

category: 'accessing'
method: MCWorkingCopy
removeRequiredPackage: aPackage

	requiredPackages remove: aPackage ifAbsent: []

%
run
MCWorkingCopy setStamp: 'stephane.ducasse 2/6/2009 18:31' forMethod: #removeRequiredPackage:.
true
%

category: 'repositories'
method: MCWorkingCopy
repositoryGroup
	^ repositoryGroup ifNil: [repositoryGroup := MCRepositoryGroup new]
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #repositoryGroup.
true
%

category: 'repositories'
method: MCWorkingCopy
repositoryGroup: aRepositoryGroup
	repositoryGroup := aRepositoryGroup
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #repositoryGroup:.
true
%

category: 'private'
method: MCWorkingCopy
requestVersionNameAndMessageWithSuggestion: aString
	^ (MCVersionNameAndMessageRequest new suggestedName: aString) signal
%
run
MCWorkingCopy setStamp: 'ab 8/24/2003 20:38' forMethod: #requestVersionNameAndMessageWithSuggestion:.
true
%

category: 'accessing'
method: MCWorkingCopy
requirePackage: aPackage
	(self requiredPackages includes: aPackage) ifFalse: [requiredPackages add: aPackage]
%
run
MCWorkingCopy setStamp: 'avi 1/20/2004 16:04' forMethod: #requirePackage:.
true
%

category: 'accessing'
method: MCWorkingCopy
requiredPackages
	^ requiredPackages ifNil: [requiredPackages := OrderedCollection new]
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #requiredPackages.
true
%

category: 'private'
method: MCWorkingCopy
uniqueVersionName
	|versionName|
	counter := nil.
	[versionName := self nextVersionName.
	self repositoryGroup includesVersionNamed: versionName] whileTrue.
	^ versionName
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #uniqueVersionName.
true
%

category: 'operations'
method: MCWorkingCopy
unload
	MCPackageLoader unloadPackage: self package.
	self unregister.
%
run
MCWorkingCopy setStamp: 'avi 10/5/2003 11:09' forMethod: #unload.
true
%

category: 'migration'
method: MCWorkingCopy
updateInstVars
	ancestry ifNil:
		[ancestry := MCWorkingAncestry new.
		versionInfo ifNotNil:
			[versionInfo ancestors do: [:ea | ancestry addAncestor: ea].
			versionInfo := nil]]
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #updateInstVars.
true
%

category: 'accessing'
method: MCWorkingCopy
versionInfo: aVersionInfo
	ancestry := MCWorkingAncestry new addAncestor: aVersionInfo
%
run
MCWorkingCopy setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #versionInfo:.
true
%

category: 'private'
method: MCWorkingCopy
versionSeparator
	^ $_
%
run
MCWorkingCopy setStamp: 'avi 2/4/2004 14:11' forMethod: #versionSeparator.
true
%

category: 'as yet unclassified'
classmethod: MCPatch
fromBase: baseSnapshot target: targetSnapshot
	^ self new initializeWithBase: baseSnapshot target: targetSnapshot
%
run
MCPatch class setStamp: 'avi 9/11/2004 15:49' forMethod: #fromBase:target:.
true
%

category: 'as yet unclassified'
classmethod: MCPatch
operations: aCollection
	^ self basicNew initializeWithOperations: aCollection
%
run
MCPatch class setStamp: 'avi 9/11/2004 15:50' forMethod: #operations:.
true
%

category: 'applying'
method: MCPatch
applyTo: anObject
	operations do: [:ea | ea applyTo: anObject].

%
run
MCPatch setStamp: 'ab 5/24/2003 16:12' forMethod: #applyTo:.
true
%

category: 'intializing'
method: MCPatch
initializeWithBase: baseSnapshot target: targetSnapshot
	| base target |
	operations := OrderedCollection new.
	base := MCDefinitionIndex definitions: baseSnapshot definitions.
	target := MCDefinitionIndex definitions: targetSnapshot definitions.
	MCPlatform current
		for: target definitions
		do: [ :t | 
			base
				definitionLike: t
				ifPresent: [ :b | 
					(b isSameRevisionAs: t)
						ifFalse: [ operations add: (MCModification of: b to: t) ] ]
				ifAbsent: [ operations add: (MCAddition of: t) ] ]
		displayingProgress: 'Diffing...'.
	base definitions
		do: [ :b | target definitionLike: b ifPresent: [ :t |  ] ifAbsent: [ operations add: (MCRemoval of: b) ] ]
%
run
MCPatch setStamp: 'DaleHenrichs 10/1/2010 14:40' forMethod: #initializeWithBase:target:.
true
%

category: 'intializing'
method: MCPatch
initializeWithOperations: aCollection
	operations := aCollection
%
run
MCPatch setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithOperations:.
true
%

category: 'querying'
method: MCPatch
isEmpty
	^ operations isEmpty
%
run
MCPatch setStamp: 'cwp 6/9/2003 11:53' forMethod: #isEmpty.
true
%

category: 'accessing'
method: MCPatch
operations
	^ operations
%
run
MCPatch setStamp: 'ab 5/13/2003 12:18' forMethod: #operations.
true
%

category: 'as yet unclassified'
classmethod: MCAddition
of: aDefinition
	^ self new intializeWithDefinition: aDefinition
%
run
MCAddition class setStamp: 'cwp 11/27/2002 10:03' forMethod: #of:.
true
%

category: 'accessing'
method: MCAddition
applyTo: anObject
	anObject addDefinition: definition
%
run
MCAddition setStamp: 'ab 5/24/2003 16:11' forMethod: #applyTo:.
true
%

category: 'accessing'
method: MCAddition
baseDefinition
	^ nil
%
run
MCAddition setStamp: 'ab 6/1/2003 13:09' forMethod: #baseDefinition.
true
%

category: 'accessing'
method: MCAddition
definition
	^ definition
%
run
MCAddition setStamp: 'cwp 11/27/2002 09:32' forMethod: #definition.
true
%

category: 'accessing'
method: MCAddition
fromSource
	^ ''
%
run
MCAddition setStamp: 'ab 7/18/2003 16:45' forMethod: #fromSource.
true
%

category: 'initializing'
method: MCAddition
intializeWithDefinition: aDefinition
	definition := aDefinition
%
run
MCAddition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #intializeWithDefinition:.
true
%

category: 'as yet unclassified'
method: MCAddition
inverse
	^ MCRemoval of: definition
%
run
MCAddition setStamp: 'ab 8/22/2003 02:26' forMethod: #inverse.
true
%

category: 'testing'
method: MCAddition
isAddition
	^ true
%
run
MCAddition setStamp: 'cwp 11/28/2002 07:22' forMethod: #isAddition.
true
%

category: 'as yet unclassified'
method: MCAddition
isClassPatch
	^definition isClassDefinition
%
run
MCAddition setStamp: 'nk 2/25/2005 17:28' forMethod: #isClassPatch.
true
%

category: 'accessing'
method: MCAddition
summary
	^ definition summary
%
run
MCAddition setStamp: 'ab 5/13/2003 12:18' forMethod: #summary.
true
%

category: 'accessing'
method: MCAddition
targetClass
	^definition actualClass 
%
run
MCAddition setStamp: 'nk 2/23/2005 18:17' forMethod: #targetClass.
true
%

category: 'accessing'
method: MCAddition
targetDefinition
	^ definition
%
run
MCAddition setStamp: 'ab 6/1/2003 13:09' forMethod: #targetDefinition.
true
%

category: 'accessing'
method: MCAddition
toSource
	^ definition source
%
run
MCAddition setStamp: 'ab 7/18/2003 16:45' forMethod: #toSource.
true
%

category: 'as yet unclassified'
classmethod: MCModification
of: base to: target
	^ self new initializeWithBase: base target: target
%
run
MCModification class setStamp: 'cwp 11/28/2002 07:19' forMethod: #of:to:.
true
%

category: 'accessing'
method: MCModification
applyTo: anObject
	anObject modifyDefinition: obsoletion to: modification
%
run
MCModification setStamp: 'ab 5/24/2003 16:12' forMethod: #applyTo:.
true
%

category: 'accessing'
method: MCModification
baseDefinition
	^ obsoletion
%
run
MCModification setStamp: 'ab 6/1/2003 13:10' forMethod: #baseDefinition.
true
%

category: 'accessing'
method: MCModification
definition
	^ modification
%
run
MCModification setStamp: 'cwp 11/28/2002 06:55' forMethod: #definition.
true
%

category: 'accessing'
method: MCModification
fromSource
	^ obsoletion source
%
run
MCModification setStamp: 'ab 7/18/2003 16:44' forMethod: #fromSource.
true
%

category: 'initializing'
method: MCModification
initializeWithBase: base target: target
	obsoletion := base.
	modification := target.
%
run
MCModification setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithBase:target:.
true
%

category: 'as yet unclassified'
method: MCModification
inverse
	^ MCModification of: modification to: obsoletion
%
run
MCModification setStamp: 'ab 8/22/2003 02:27' forMethod: #inverse.
true
%

category: 'as yet unclassified'
method: MCModification
isClassPatch
	^obsoletion isClassDefinition
%
run
MCModification setStamp: 'nk 2/25/2005 17:29' forMethod: #isClassPatch.
true
%

category: 'testing'
method: MCModification
isModification
	^ true
%
run
MCModification setStamp: 'cwp 11/28/2002 07:23' forMethod: #isModification.
true
%

category: 'accessing'
method: MCModification
modification
	^ modification
%
run
MCModification setStamp: 'cwp 11/27/2002 09:46' forMethod: #modification.
true
%

category: 'accessing'
method: MCModification
obsoletion
	^ obsoletion
%
run
MCModification setStamp: 'cwp 11/27/2002 09:48' forMethod: #obsoletion.
true
%

category: 'as yet unclassified'
method: MCModification
printAnnotations: request on: aStream
	aStream nextPutAll: 'old: '.
	obsoletion printAnnotations: request on: aStream.
	aStream cr.
	aStream nextPutAll: 'new: '.
	modification printAnnotations: request on: aStream.
%
run
MCModification setStamp: 'nk 11/10/2003 21:44' forMethod: #printAnnotations:on:.
true
%

category: 'accessing'
method: MCModification
summarySuffix
	^self fromSource = self toSource
		ifTrue: [ ' (source same but rev changed)' ]
		ifFalse: [ ' (changed)' ]
%
run
MCModification setStamp: 'nk 10/21/2003 22:54' forMethod: #summarySuffix.
true
%

category: 'accessing'
method: MCModification
targetClass
	^ obsoletion actualClass
%
run
MCModification setStamp: 'nk 2/23/2005 18:18' forMethod: #targetClass.
true
%

category: 'accessing'
method: MCModification
targetDefinition
	^ modification
%
run
MCModification setStamp: 'ab 6/1/2003 13:10' forMethod: #targetDefinition.
true
%

category: 'accessing'
method: MCModification
toSource
	^ modification source
%
run
MCModification setStamp: 'ab 7/18/2003 16:44' forMethod: #toSource.
true
%

category: 'comparing'
method: MCPatchOperation
<= other
	^ self definition <= other definition
%
run
MCPatchOperation setStamp: 'ab 7/19/2003 18:11' forMethod: #'<='.
true
%

category: 'accessing'
method: MCPatchOperation
definition
	^ self subclassResponsibility 
%
run
MCPatchOperation setStamp: 'cwp 11/28/2002 06:59' forMethod: #definition.
true
%

category: 'accessing'
method: MCPatchOperation
inverse
	self subclassResponsibility
%
run
MCPatchOperation setStamp: 'cwp 11/27/2002 09:26' forMethod: #inverse.
true
%

category: 'testing'
method: MCPatchOperation
isAddition
	^ false
%
run
MCPatchOperation setStamp: 'cwp 11/27/2002 09:30' forMethod: #isAddition.
true
%

category: 'as yet unclassified'
method: MCPatchOperation
isClassPatch
	^false
%
run
MCPatchOperation setStamp: 'nk 2/25/2005 17:28' forMethod: #isClassPatch.
true
%

category: 'testing'
method: MCPatchOperation
isModification
	^ false
%
run
MCPatchOperation setStamp: 'cwp 11/27/2002 09:30' forMethod: #isModification.
true
%

category: 'testing'
method: MCPatchOperation
isRemoval
	^ false
%
run
MCPatchOperation setStamp: 'cwp 11/27/2002 09:30' forMethod: #isRemoval.
true
%

category: 'accessing'
method: MCPatchOperation
prefixForOperation: aSymbol
	aSymbol == #insert ifTrue: [^ '+'].
	aSymbol == #remove ifTrue: [^ '-'].
	^ ' '
%
run
MCPatchOperation setStamp: 'avi 8/31/2003 17:53' forMethod: #prefixForOperation:.
true
%

category: 'accessing'
method: MCPatchOperation
source
	^ self sourceText
%
run
MCPatchOperation setStamp: 'avi 8/31/2003 17:55' forMethod: #source.
true
%

category: 'accessing'
method: MCPatchOperation
summary
	^ self definition summary, self summarySuffix
%
run
MCPatchOperation setStamp: 'ab 7/6/2003 00:06' forMethod: #summary.
true
%

category: 'accessing'
method: MCPatchOperation
summarySuffix
	^ ''
%
run
MCPatchOperation setStamp: 'ab 7/6/2003 00:06' forMethod: #summarySuffix.
true
%

category: 'as yet unclassified'
method: MCPatchOperation
targetClass
	self subclassResponsibility.
%
run
MCPatchOperation setStamp: 'nk 2/23/2005 18:17' forMethod: #targetClass.
true
%

category: 'as yet unclassified'
classmethod: MCRemoval
of: aDefinition
	^ self new intializeWithDefinition: aDefinition
%
run
MCRemoval class setStamp: 'cwp 11/27/2002 10:03' forMethod: #of:.
true
%

category: 'accessing'
method: MCRemoval
applyTo: anObject
	anObject removeDefinition: definition
%
run
MCRemoval setStamp: 'ab 5/24/2003 16:11' forMethod: #applyTo:.
true
%

category: 'accessing'
method: MCRemoval
baseDefinition
	^ definition
%
run
MCRemoval setStamp: 'ab 6/1/2003 13:10' forMethod: #baseDefinition.
true
%

category: 'accessing'
method: MCRemoval
definition
	^ definition
%
run
MCRemoval setStamp: 'cwp 11/27/2002 10:02' forMethod: #definition.
true
%

category: 'accessing'
method: MCRemoval
fromSource
	^ definition source
%
run
MCRemoval setStamp: 'ab 7/18/2003 16:44' forMethod: #fromSource.
true
%

category: 'initializing'
method: MCRemoval
intializeWithDefinition: aDefinition
	definition := aDefinition
%
run
MCRemoval setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #intializeWithDefinition:.
true
%

category: 'as yet unclassified'
method: MCRemoval
inverse
	^ MCAddition of: definition
%
run
MCRemoval setStamp: 'ab 8/22/2003 02:26' forMethod: #inverse.
true
%

category: 'as yet unclassified'
method: MCRemoval
isClassPatch
	^definition isClassDefinition
%
run
MCRemoval setStamp: 'nk 2/25/2005 17:28' forMethod: #isClassPatch.
true
%

category: 'testing'
method: MCRemoval
isRemoval
	^ true
%
run
MCRemoval setStamp: 'cwp 11/28/2002 07:24' forMethod: #isRemoval.
true
%

category: 'accessing'
method: MCRemoval
summary
	^ definition summary, ' (removed)'
%
run
MCRemoval setStamp: 'ab 5/13/2003 12:22' forMethod: #summary.
true
%

category: 'accessing'
method: MCRemoval
summarySuffix
	^ ' (removed)'
%
run
MCRemoval setStamp: 'ab 7/6/2003 00:05' forMethod: #summarySuffix.
true
%

category: 'accessing'
method: MCRemoval
targetClass
	^ definition actualClass
%
run
MCRemoval setStamp: 'nk 2/25/2005 17:23' forMethod: #targetClass.
true
%

category: 'accessing'
method: MCRemoval
targetDefinition
	^ nil
%
run
MCRemoval setStamp: 'ab 6/1/2003 13:10' forMethod: #targetDefinition.
true
%

category: 'accessing'
method: MCRemoval
toSource
	^ ''
%
run
MCRemoval setStamp: 'ab 7/18/2003 16:44' forMethod: #toSource.
true
%

category: 'as yet unclassified'
classmethod: MCPatcher
apply: aPatch to: aSnapshot
	| loader |
	loader := self snapshot: aSnapshot.
	aPatch applyTo: loader.
	^ loader patchedSnapshot
%
run
MCPatcher class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #apply:to:.
true
%

category: 'as yet unclassified'
classmethod: MCPatcher
snapshot: aSnapshot
	^ self new initializeWithSnapshot: aSnapshot
%
run
MCPatcher class setStamp: 'ab 6/1/2003 14:22' forMethod: #snapshot:.
true
%

category: 'as yet unclassified'
method: MCPatcher
addDefinition: aDefinition
	definitions add: aDefinition
%
run
MCPatcher setStamp: 'ab 6/2/2003 00:46' forMethod: #addDefinition:.
true
%

category: 'as yet unclassified'
method: MCPatcher
initializeWithSnapshot: aSnapshot
	definitions := MCDefinitionIndex definitions: aSnapshot definitions
%
run
MCPatcher setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithSnapshot:.
true
%

category: 'as yet unclassified'
method: MCPatcher
modifyDefinition: baseDefinition to: targetDefinition
	self addDefinition: targetDefinition
%
run
MCPatcher setStamp: 'ab 6/1/2003 14:23' forMethod: #modifyDefinition:to:.
true
%

category: 'as yet unclassified'
method: MCPatcher
patchedSnapshot
	^ MCSnapshot fromDefinitions: definitions definitions
%
run
MCPatcher setStamp: 'ab 7/6/2003 23:48' forMethod: #patchedSnapshot.
true
%

category: 'as yet unclassified'
method: MCPatcher
removeDefinition: aDefinition
	definitions remove: aDefinition
%
run
MCPatcher setStamp: 'ab 6/2/2003 00:46' forMethod: #removeDefinition:.
true
%

category: 'class initialization'
classmethod: MCGemStonePlatform
initialize
	self select
%
run
MCGemStonePlatform class setStamp: 'DaleHenrichs 9/28/2010 14:50' forMethod: #initialize.
true
%

category: 'reflection'
method: MCGemStonePlatform
allClasses
        "used by PackageInfo, so reasons about visible classes"
	^ClassOrganizer new classes
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/7/2010 14:56' forMethod: #allClasses.
true
%

category: 'reflection'
method: MCGemStonePlatform
subclassesOfMonticelloClass: aClass
  "used to find subclasses of class installed in Monticello-Globals, which may not be visible"

  ^self classOrganizerForMonticelloGlobals subclassesOf: aClass thisClass
%

category: 'reflection'
method: MCGemStonePlatform
allSubclassesOfMonticelloClass: aClass
  "used to find allSubclasses of class installed in Monticello-Globals, which may not be visible"

  ^self classOrganizerForMonticelloGlobals allSubclassesOf: aClass thisClass
%

category: 'reflection'
method: MCGemStonePlatform
classOrganizerForMonticelloGlobals
| inst symbolDict |
inst := ClassOrganizer basicNew.
inst rootClass: Object.
inst classes: ClassSet new.
(symbolDict := (GsPackageLibrary packageNamed: #'Monticello_Globals') symbolDict) keysAndValuesDo:[ :aKey :aValue |
  aValue isBehavior ifTrue: [ inst classes add: aValue ]].
inst classes addAll: (ClassOrganizer new allSubclassesOf: Object).
inst rebuildHierarchy.
^inst
%

category: 'reflection'
method: MCGemStonePlatform
allImplementorsOf: aSelector 
        "used by tests, need to search through Monticello-Globals too"
	| aCollection |
	aCollection := SortedCollection new.
	(self classOrganizerForMonticelloGlobals implementorsOf: aSelector) do: [:meth |
		aCollection add: (MethodReference new setStandardClass: meth inClass methodSymbol: aSelector).
	].
	^aCollection
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 14:37' forMethod: #allImplementorsOf:.
true
%

category: 'utility'
method: MCGemStonePlatform
authorFullName

	savedFullName == nil ifTrue: [ savedFullName := self authorInitials ].
	^savedFullName
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 12:28' forMethod: #authorFullName.
true
%

category: 'utility'
method: MCGemStonePlatform
authorFullName: aString

	savedFullName := aString
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 12:28' forMethod: #authorFullName:.
true
%

category: 'private'
method: MCGemStonePlatform
authorInitials: aString 

        ^self authorFullName: aString
%

category: 'private'
method: MCGemStonePlatform
authorInitials

	^GsPackagePolicy current authorInitials
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 12:25' forMethod: #authorInitials.
true
%

category: 'repositories'
method: MCGemStonePlatform
cacheRepository

	^MCFilesystemCacheRepository default
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/20/2010 12:32' forMethod: #cacheRepository.
true
%

category: 'reflection'
method: MCGemStonePlatform
categoryOfClassNamed: aClassName

	^(self globalNamed: aClassName ifAbsent: [^nil]) category
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 13:36' forMethod: #categoryOfClassNamed:.
true
%

category: 'reflection'
method: MCGemStonePlatform
categoryOfSelector: aSelector for: aClass

	^aClass categoryOfSelector: aSelector
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 9/28/2010 16:25' forMethod: #categoryOfSelector:for:.
true
%

category: 'private'
method: MCGemStonePlatform
changeStamp 
	"Answer a string to be pasted into source code to mark who changed it and when."

	^ self authorInitials , ' ' , (Date today asStringUsingFormat: #(2 1 3 $/ 1 1 $: false )), ' ',
		(Time now asString copyFrom: 1 to: 5)

%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 9/28/2010 16:33' forMethod: #changeStamp.
true
%

category: 'reflection'
method: MCGemStonePlatform
classCommentFor: aClass

	^aClass classComment
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 12:36' forMethod: #classCommentFor:.
true
%

category: 'reflection'
method: MCGemStonePlatform
classesAndMetaclassesInSystemCategories: systemCategories

	| categoryDict s |
	categoryDict := ClassOrganizer new categories.
	s := IdentitySet new.
	systemCategories do: [ :cat | | classes |
		classes := categoryDict at: cat asString ifAbsent: [ #() ].
		s addAll: classes.
		s addAll: (classes collect: [:each | each class ])].
	^s
		
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 13:31' forMethod: #classesAndMetaclassesInSystemCategories:.
true
%

category: 'reflection'
method: MCGemStonePlatform
classesInSystemCategories: systemCategories

	| categoryDict |
	categoryDict := ClassOrganizer new categories.
	^ (systemCategories gather: [ :cat | categoryDict at: cat asString ifAbsent: [ #() ] ])
		sortWithBlock: [ :a :b | a name <= b name ]
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/7/2010 15:00' forMethod: #classesInSystemCategories:.
true
%

category: 'reflection'
method: MCGemStonePlatform
commentStampFor: aClass

	^aClass commentStamp
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 12:37' forMethod: #commentStampFor:.
true
%

category: 'method additions'
set compile_env: 0
method: MCGemStonePlatform
compileMethodAddition: aMethodAddition ifFail: failBlock
        | meth |
        meth := self doCompileForMethodAddition: aMethodAddition installMethod: false.
        meth class == GsNMethod
                ifTrue: [
                        aMethodAddition selector: meth selector.
                        aMethodAddition compiledMethod: meth ]
%

run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/7/2010 11:18' forMethod: #compileMethodAddition:ifFail:.
true
%

category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
createBasicClassFrom: aClassDefinition
        | type opts |
        opts := #() .
        (type := aClassDefinition type ) _isArray
            ifTrue:[ opts := type at: 2 . type := type at: 1 ] .
        type = #normal
            ifTrue: [ ^ self createNormalClassFrom: aClassDefinition options: opts ].
        type = #variable
            ifTrue: [ ^ self createIndexableClassFrom: aClassDefinition options: opts ].
        type = #bytes
            ifTrue: [ ^ self createByteClassFrom: aClassDefinition options: opts ].
        type = #transient
            ifTrue: [
                opts := opts, #(#dbTransient).
                ^ self createNormalClassFrom: aClassDefinition options: opts ].
        self error: 'Unrecognized class type'
%

category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
createClassFrom: aClassDefinition
	^self 
            defineClassFrom: aClassDefinition 
            with: [ self createBasicClassFrom: aClassDefinition ].
%

category: 'class definition support'
method: MCGemStonePlatform
createByteClassFrom: aClassDefinition options: opts
	"need work for poolDictionaries and inDictionary args"

	| superClass class dict |
	dict := self defaultSymbolDictionary.
	superClass := System myUserProfile symbolList objectNamed: aClassDefinition superclassName.
        (superClass == nil and: [aClassDefinition superclassName asString ~= 'nil']) ifTrue: [self error: 'non-existent superclass'].
	class := superClass
		byteSubclass: aClassDefinition className asString
		classVars: aClassDefinition classVarNames asArray
		classInstVars: aClassDefinition classInstVarNames asArray
		poolDictionaries: (self poolArrayFor: aClassDefinition)
		inDictionary: dict
    		newVersionOf: (System _classNamed: aClassDefinition className inDictionary: dict)
		description: nil
		options: opts.
	class ~~ nil
		ifTrue: [ class category: aClassDefinition category asString ].
	^ class
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 12:07' forMethod: #createByteClassFrom:.
true
%

category: 'class definition support'
method: MCGemStonePlatform
createIndexableClassFrom: aClassDefinition options: opts
	"need work for poolDictionaries and inDictionary args"

	| superClass class dict |
	dict := self defaultSymbolDictionary.
	superClass := System myUserProfile symbolList objectNamed: aClassDefinition superclassName.
        (superClass == nil and: [aClassDefinition superclassName asString ~= 'nil']) ifTrue: [self error: 'non-existent superclass'].
	class := superClass
		indexableSubclass: aClassDefinition className asString
		instVarNames: aClassDefinition instVarNames asArray
		classVars: aClassDefinition classVarNames asArray
		classInstVars: aClassDefinition classInstVarNames asArray
		poolDictionaries: (self poolArrayFor: aClassDefinition)
		inDictionary: dict
    		newVersionOf: (System _classNamed: aClassDefinition className inDictionary: dict)
 		description: nil
		options: opts.
	class ~~ nil
		ifTrue: [ class category: aClassDefinition category asString ].
	^ class
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 12:08' forMethod: #createIndexableClassFrom:.
true
%

category: 'class definition support'
method: MCGemStonePlatform
createNormalClassFrom: aClassDefinition options: opts 
	"need work for poolDictionaries and inDictionary args"

	| superClass class dict classVarsName sharedPoolSubclass |
	dict := self defaultSymbolDictionary.
	superClass := System myUserProfile symbolList objectNamed: aClassDefinition superclassName.
        (superClass == nil and: [aClassDefinition superclassName asString ~= 'nil']) ifTrue: [self error: 'non-existent superclass'].
	(System myUserProfile symbolList objectNamed: #SharedPool)
		ifNotNil: [:sharedPoolClass |
			(superClass notNil and: [superClass isSubclassOf: sharedPoolClass])
				ifTrue: [
					(System myUserProfile symbolList objectNamed: aClassDefinition className)
						ifNotNil: [:aSharedPoolClass |
							sharedPoolSubclass := aSharedPoolClass.
							classVarsName := aSharedPoolClass _classVars name ]]].
				
	class := superClass
		subclass: aClassDefinition className asString
		instVarNames: aClassDefinition instVarNames asArray
		classVars: aClassDefinition classVarNames asArray
		classInstVars: aClassDefinition classInstVarNames asArray
		poolDictionaries: (self poolArrayFor: aClassDefinition)
		inDictionary: dict
    		newVersionOf: (System _classNamed: aClassDefinition className inDictionary: dict)
		description: nil
		options: opts.

	sharedPoolSubclass
		ifNotNil: [ class _classVars name ifNil: [ class _classVars name: class name asSymbol ] ].

	class ~~ nil
		ifTrue: [ class category: aClassDefinition category asString ].
	^ class
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 12:08' forMethod: #createNormalClassFrom:.
true
%

category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
copyMethodsFrom: sourceClass to: destinationClass dictionaries: dicts
	"Copies command and all instance and class methods from sourceClass 
	 to destinationClass.  Returns an Array of methods in the source 
	 class which failed to compile.  Some of them might be class methods.  
	 The Array will be empty if none failed."

	| failed srccls targcls cats clsComment |

	destinationClass _validatePrivilege.
	failed := Array new.

	"Copy class comment"
	(clsComment := sourceClass classComment) notEmpty
		ifTrue: [ destinationClass classComment: sourceClass classComment stamp: sourceClass commentStamp ].

	"Copy class and instance methods"
	1 to: 2 do: [ :i | | originalConversionBoolean currentConversionBoolean |
		i == 1 
			ifTrue: [ srccls := sourceClass.  targcls := destinationClass ] 
			ifFalse: [ srccls := sourceClass class.  targcls := destinationClass class ].
		cats := srccls _unifiedCategorys: 0.
		currentConversionBoolean := originalConversionBoolean := System configurationAt:#GemConvertArrayBuilder.
		cats keysAndValuesDo: [ :cat :sels |
			sels do: [ :sel |  | stamp |
				stamp := srccls stampForMethod: sel.
				[ 
       					[ 
					System configurationAt:#GemConvertArrayBuilder put: currentConversionBoolean.
					self 
						recompileMethod: (srccls sourceCodeAt: sel)
						inCategory: cat
						withStamp: stamp 
						inDictionaries: dicts
						for: targcls 
					] ensure: [ System configurationAt:#GemConvertArrayBuilder put: originalConversionBoolean ] 
				] 
				onException: CompileError 
				do:[:ex | 
					(System configurationAt:#GemConvertArrayBuilder) 
						ifTrue: [ ex pass ].
					GsFile gciLogServer: 'Method recompilation error: retrying...', sel printString.
					currentConversionBoolean := true.
					ex retry.
				]]]].
	^failed.
%

category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
defineClassFrom: aClassDefinition with: aBlock

	| originalClass classOrganizer cls |
	originalClass := System myUserProfile symbolList objectNamed: aClassDefinition className asSymbol.
	originalClass ~~ nil 
		ifTrue: [ 
			"pre-create the classOrganizer, so that original subclasses are preserved."
			classOrganizer := ClassOrganizer new ].
	cls := aBlock value.
	(originalClass ~~ nil and: [cls notNil ])
		ifTrue: [ | failedMethods |
			(failedMethods := self 
				copyMethodsFrom: originalClass 
				to: cls 
				dictionaries: System myUserProfile symbolList) do: [:method |
					GsFile gciLogServer: '  the method ', method selector printString, ' failed to recompile' ].
			self
				redefineSubclassesOf: originalClass 
				using: classOrganizer ].
        self resolveUndeclaredSymbolsFor: cls name asSymbol.
	^cls
%
category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
definitionForClass: aClass
   "bypass definition cache"
   ^ MCClassDefinition new
        initializeWithName: aClass name
        superclassName: aClass superclass name
        traitComposition: '{}'
        classTraitComposition: '{}'
        category: aClass category asSymbol
        instVarNames: aClass instVarNames
        classVarNames: aClass _sortedClassVarNames
        poolDictionaryNames: aClass poolDictionaryNames
        classInstVarNames: aClass class instVarNames
        type:    aClass _mcDefinitionType 
        comment: aClass classComment
        commentStamp: aClass commentStamp
%

category: 'class definition support'
method: MCGemStonePlatform
poolArrayFor: aClassDefinition

        ^self poolDictionariesForNames: aClassDefinition poolDictionaries
%

category: 'class definition support'
method: MCGemStonePlatform
poolDictionariesForNames: poolDictionaryNames

	| ar existingDict symList sharedPool |
	ar := Array new.
  symList := GsSession currentSession userProfile symbolList .
	poolDictionaryNames do: [:poolName |
		existingDict := symList objectNamed: poolName.
		existingDict ifNil:[ | pool |
				pool := SymbolDictionary new.
				pool name: poolName asSymbol.
				ar add: pool.
	  ] ifNotNil:[ 
		  (existingDict isKindOf: SymbolDictionary) ifTrue: [ 
        ar add: existingDict 
      ] ifFalse:[
        sharedPool ifNil:[ sharedPool := symList objectNamed: #SharedPool ].
		    ((existingDict isKindOf: Class) and:[ existingDict isSubclassOf: sharedPool ]) ifTrue: [ 
           | cvars pName |
				   ar add: (cvars := existingDict _createClassVarsDict) .
           pName := poolName asSymbol .
           "only change dictionary name if needed , to avoid SecurityError"
           cvars name ~~ pName ifTrue:[ cvars name: pName ].
        ]
			].
    ].
	].
  ^ar
%

category: 'class definition support'
set compile_env: 0
method: MCGemStonePlatform
redefineSubclassesOf: aClass using: aClassOrganizer

	| organizerClass |
	organizerClass := aClassOrganizer classes detect: [:class | class name == aClass name ].
	(aClassOrganizer subclassesOf: organizerClass) do: [:subClass | | newClass |
		newClass := (self definitionForClass: subClass) createClass.
		self redefineSubclassesOf: subClass using: aClassOrganizer.
	].
%


! deleted _nilOrClassNamed:

category: 'working copies'
method: MCGemStonePlatform
packageManagerRegistryFor: aClass
	| dict |
	dict := SessionTemps current at: #MC_PACKAGE_MANAGER_REGISTRY_FOR_MCGemStonePlatform otherwise: nil.
	dict == nil 
		ifTrue: [
			dict := Dictionary new.
			SessionTemps current at: #MC_PACKAGE_MANAGER_REGISTRY_FOR_MCGemStonePlatform put: dict].
        ^dict 
          at: aClass name 
          ifAbsent: [ dict at: aClass name put: Dictionary new ].
%
category: 'repositories'
method: MCGemStonePlatform
defaultCacheRepository

	^MCDictionaryRepository new
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/8/2010 12:42' forMethod: #defaultCacheRepository.
true
%

category: 'private'
method: MCGemStonePlatform
defaultSymbolDictionary

    ^GsPackagePolicy current homeSymbolDict
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 11:58' forMethod: #defaultSymbolDictionary.
true
%

category: 'method additions'
set compile_env: 0      
method: MCGemStonePlatform      
doCompileForMethodAddition: aMethodAddition installMethod: installMethod
        | source category compilationBlock |
        source := aMethodAddition text asString withGemStoneLineEndings.
        category := aMethodAddition category asSymbol.
        compilationBlock := installMethod
                ifTrue: [
                        "install method in class method dictionary"
                        [:symbolList |
                                aMethodAddition myClass
                                        compileMethod: source
                                        dictionaries: symbolList
                                        category: category
                                        environmentId: 0 ]]
                ifFalse: [ 
                        "just compile the method without installing in class method dictionary. Return compiledMethod"              
                        [:symbolList |
                                aMethodAddition myClass
                                        compileMethod: source
                                        dictionaries: symbolList
                                        category: category
                                        intoMethodDict: GsMethodDictionary new
                                        intoCategories: GsMethodDictionary new
                                        intoPragmas: nil
                                        environmentId: 0 ]].
        ^self
                handleUndefinedSymbolsCompiling: compilationBlock
                symbolList: System myUserProfile symbolList
%

category: 'undefined symbols'
set compile_env: 0
method: MCGemStonePlatform
handleUndefinedSymbolsCompiling: compilationBlock symbolList: aSymbolList

        [ ^compilationBlock value: aSymbolList ]
                on: CompileError
                do: [:ex |
                        | undefSymbol symbols undefinedSymbols undefinedSymbolList method |
                        undefSymbol := true.
                        symbols := { } .
                        ex errorDetails do:[ :errArray |
                                (errArray atOrNil: 1) == 1031
                                        ifTrue: [ 
                                            [ symbols add: (errArray atOrNil: 5) asSymbol ] on: Error do: [:ignored | ex pass ].
                                            undefSymbol := UndefinedSymbolNotification signal ]
                                        ifFalse: [ undefSymbol := false ]].

                        undefSymbol ifFalse:[ ^ex outer].
                        (undefinedSymbols := aSymbolList objectNamed: #UndefinedSymbols) ifNil:[ ^ex outer ].

                        "attempt auto-define of undefined symbols"
                        symbols do: [:sym | | s |
                                s := undefinedSymbols at: sym ifAbsent: [
                                        s := Set new.
                                        undefinedSymbols at: sym put: s ].
                                undefinedSymbolList := aSymbolList objectNamed: #UndefinedSymbolList.
                                [ method := compilationBlock value: aSymbolList, undefinedSymbolList ]
                                        on: CompileError
                                        do:[ :exb | ^exb outer ]
                        ].
                        "recompile ok, add to undefinedSymbols dict"
                        symbols do: [:sym |
				GsFile gciLogServer: '    Encountered undefined symbol ', sym printString, ' in ', method selector printString.
                                (undefinedSymbols at: sym) add: (method inClass -> method selector)].
                        ^method].

%

category: 'undefined symbols'
set compile_env: 0
method: MCGemStonePlatform
resolveUndeclaredSymbolsFor: aSymbol
        | undefinedSymbols coll |
        undefinedSymbols := GsSession currentSession symbolList objectNamed: #UndefinedSymbols.
        undefinedSymbols ifNil:[ ^self ].
        coll := undefinedSymbols at: aSymbol ifAbsent: [ ^self ].
        coll copy do: [:assoc | | class selector |
                ((class := assoc key) includesSelector: (selector := assoc value))
                        ifTrue: [
                                (self recompile: selector for: class)
                                        ifTrue: [ coll remove: assoc ]]].
        coll size == 0
                ifTrue: [ undefinedSymbols removeKey: aSymbol ifAbsent:[]].
%

category: 'smalltalk'
method: MCGemStonePlatform
monticelloGlobalNamed: aName
    "Should only be used for looking up globals that should be found in the Monticello_Globals symbol dictionary ... primarily
     deserialization of Monticello model"

    ^(GsPackageLibrary packageNamed: #'Monticello_Globals') symbolDict at: aName ifAbsent: [ self globalNamed: aName ifAbsent: [ ]]
%

category: 'smalltalk'
method: MCGemStonePlatform
globalNamed: aName

	^self globalNamed: aName ifAbsent: [ self error: 'class not found' ]
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 10:59' forMethod: #globalNamed:.
true
%

category: 'smalltalk'
method: MCGemStonePlatform
globalNamed: aName ifAbsent: aBlock

	| global |
	(global := System myUserProfile symbolList objectNamed: aName ) == nil
		ifTrue: [ ^aBlock value ].
	^global
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 10:58' forMethod: #globalNamed:ifAbsent:.
true
%

category: 'smalltalk'
method: MCGemStonePlatform
globalNames
	| result symbolList |
	symbolList := System myUserProfile symbolList.
	result := Array new.
	1 to: symbolList size do: [ :j | 
		| aDict |
		aDict := symbolList at: j.
		aDict == nil
			ifFalse: [ result addAll: aDict keys ] ].
	^ result
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 14:46' forMethod: #globalNames.
true
%

category: 'smalltalk'
method: MCGemStonePlatform
globals
	| result symbolList |
	symbolList := System myUserProfile symbolList.
	result := Array new.
	1 to: symbolList size do: [ :j | 
		| aDict |
		aDict := symbolList at: j.
		aDict == nil
			ifFalse: [ result addAll: aDict values ] ].
	^ result
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/6/2010 13:31' forMethod: #globals.
true
%

category: 'smalltalk'
method: MCGemStonePlatform
hasClassNamed: aName

	^(System myUserProfile symbolList objectNamed: aName asSymbol) isBehavior
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 10:58' forMethod: #hasClassNamed:.
true
%

category: 'reflection'
method: MCGemStonePlatform
includesLocalSelector: selector for: aClass

	^aClass includesSelector: selector
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 9/28/2010 16:13' forMethod: #includesLocalSelector:for:.
true
%

category: 'method additions'
set compile_env: 0
method: MCGemStonePlatform
installMethodAddition: aMethodAddition
        "in GemStone we must compile source again to install method in class method dictionary"

        self doCompileForMethodAddition: aMethodAddition installMethod: true.
    aMethodAddition logSource
                ifTrue: [ aMethodAddition myClass setStamp: aMethodAddition changeStamp forMethod: aMethodAddition selector ].
%

category: 'reading'
method: MCGemStonePlatform
integerFromHexString: aString

	^Integer fromHexString: aString
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 10:21' forMethod: #integerFromHexString:.
true
%

category: 'reflection'
method: MCGemStonePlatform
methodCategoriesFor: aClass

	^aClass categoryNames
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 9/28/2010 15:47' forMethod: #methodCategoriesFor:.
true
%

category: 'parsing'
method: MCGemStonePlatform
parse: aStream class: aClass noPattern: noPattern context: context notifying: requestor ifFail: failBlock
	"noop"
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/7/2010 15:33' forMethod: #parse:class:noPattern:context:notifying:ifFail:.
true
%

category: 'reflection'
method: MCGemStonePlatform
removeClassFromSystem: aClass

  ((GsSession currentSession objectNamed: #UserGlobals) 
      at: #'GS_BOOTSTRAP_MONTICELLO_SKIP_REMOVE_CLASS' ifAbsent: [ false ]) 
    ifTrue: [
      "Bug 46217 - during bootstrap don't remove any classes.
        during initial bootstrap no classes will be removed
        during upgrade unexpected classes should not be removed during the
          bootstrap operation" ]
    ifFalse: [
	| ar |
	aClass subclasses isEmpty not ifTrue: [ ^self error: 'class has subclasses' ].
	ar := System myUserProfile dictionaryAndSymbolOf: aClass.
	ar ifNil: [ ^self error: 'class not found in current user profile' ].
	(ar at: 1) removeKey: (ar at: 2) ]
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 10:55' forMethod: #removeClassFromSystem:.
true
%

category: 'reflection'
method: MCGemStonePlatform
selectorsFor: aClass inCategory: cat

	^aClass selectorsIn: cat
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 9/28/2010 15:51' forMethod: #selectorsFor:inCategory:.
true
%

category: 'reflection'
method: MCGemStonePlatform
st80ClassDefinitionFor: aClass

	| stream strBlock |
	stream := WriteStream on: String new.
	strBlock := [ :list | 
	| str beforeFirst |
	str := WriteStream on: String new.
	beforeFirst := true.
	list
		do: [ :ea | 
			beforeFirst
				ifTrue: [ beforeFirst := false ]
				ifFalse: [ str space ].
			str nextPutAll: ea ].
	str contents ].
	stream
		nextPutAll: aClass superclass name;
		nextPutAll: (MCClassDefinition kindOfSubclassFor: aClass typeOfClass);
		nextPut: $#;
		nextPutAll: aClass name;
		cr;
		tab;
		nextPutAll: 'instanceVariableNames: ';
		nextPutAll: (strBlock value: aClass instVarNames) printString;
		cr;
		tab;
		nextPutAll: 'classVariableNames: ';
		nextPutAll: (strBlock value: aClass _sortedClassVarNames) printString;
		cr;
		tab;
		nextPutAll: 'poolDictionaries: ';
		nextPutAll: (strBlock value: aClass poolDictionaryNames) printString;
		cr;
		tab;
		nextPutAll: 'category: ';
		nextPutAll: aClass category printString.
	^ stream contents
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/1/2010 13:16' forMethod: #st80ClassDefinitionFor:.
true
%

category: 'reflection'
method: MCGemStonePlatform
systemCategories
	^(ClassOrganizer new categories keys collect: [:each | each asSymbol]) asArray
%
run
MCGemStonePlatform setStamp: 'MartinMcClure 12/30/2011 16:21' forMethod: #systemCategories.
true
%

category: 'reflection'
method: MCGemStonePlatform
timeStampForMethod: aCompiledMethod
	"for now"

	^aCompiledMethod inClass stampForMethod: aCompiledMethod selector
%
run
MCGemStonePlatform setStamp: 'DaleHenrichs 10/7/2010 16:14' forMethod: #timeStampForMethod:.
true
%

category: 'undefined symbols'
set compile_env: 0
method: MCGemStonePlatform
recompile: selector for: class
        "Answer <true> if no undefined symbols encountered"

	| undefinedSymbolEncountered |
        undefinedSymbolEncountered := false.
        [self
		recompileMethod: (class sourceCodeAt: selector)
		inCategory: (class categoryOfSelector: selector)
		withStamp: (class stampForMethod: selector)
		inDictionaries: System myUserProfile symbolList
		for: class ]
            on: UndefinedSymbolNotification
            do: [:ex | 
                undefinedSymbolEncountered := true.
                ex resume: true ].
        ^undefinedSymbolEncountered not
%
category: 'undefined symbols'
set compile_env: 0
method: MCGemStonePlatform
recompileMethod: source inCategory: category withStamp: stamp inDictionaries: aSymbolList for: class

        | method |
	method := self
                handleUndefinedSymbolsCompiling:
                        [:symbolList |
                                class
                                        compileMethod: source
                                        dictionaries: symbolList
                                        category: category
                                        environmentId: 0 ]
                symbolList: aSymbolList.
        class setStamp: stamp forMethod: method selector
%

category: 'registration'
classmethod: MCPlatform
current

	| val |
        val := SessionTemps current at: #CURRENT_FOR_MCPlatform ifAbsent: [].
        val == nil ifTrue: [ SessionTemps current at: #CURRENT_FOR_MCPlatform put: (val := MCGemStonePlatform new) ].
        ^val
%
run
MCPlatform class setStamp: 'DaleHenrichs 9/28/2010 14:43' forMethod: #current.
true
%

category: 'registration'
classmethod: MCPlatform
current: aPlatform
        SessionTemps current at: #CURRENT_FOR_MCPlatform put: aPlatform
%
run
MCPlatform class setStamp: 'DaleHenrichs 9/28/2010 14:43' forMethod: #current:.
true
%

category: 'registration'
classmethod: MCPlatform
select
	MCPlatform current: self new
%
run
MCPlatform class setStamp: 'DaleHenrichs 9/28/2010 14:44' forMethod: #select.
true
%

category: 'registration'
classmethod: MCPlatform
unselect
	MCPlatform current class = self ifTrue: [ MCPlatform current: nil ]
%
run
MCPlatform class setStamp: 'DaleHenrichs 9/28/2010 14:44' forMethod: #unselect.
true
%

category: 'reflection'
method: MCPlatform
allClasses

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 14:53' forMethod: #allClasses.
true
%

category: 'reflection'
method: MCPlatform
allClassesDo: aBlock

	self allClasses do: aBlock
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 14:57' forMethod: #allClassesDo:.
true
%

category: 'reflection'
method: MCPlatform
allImplementorsOf: aSelector 

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 14:33' forMethod: #allImplementorsOf:.
true
%

category: 'reflection'
method: MCPlatform
allTraits

	^#()
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 15:04' forMethod: #allTraits.
true
%

category: 'utility'
method: MCPlatform
authorFullName

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 12:23' forMethod: #authorFullName.
true
%

category: 'utility'
method: MCPlatform
authorFullName: aString

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 12:28' forMethod: #authorFullName:.
true
%

category: 'loading'
method: MCPlatform
basicPackageLoad: aBlock for: aPackageLoader
	"by default, just execute the block"
	
	aBlock value
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 12:16' forMethod: #basicPackageLoad:for:.
true
%

category: 'repositories'
method: MCPlatform
cacheRepository

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/20/2010 12:30' forMethod: #cacheRepository.
true
%

category: 'reflection'
method: MCPlatform
categoryOfClassNamed: aClassName

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 13:34' forMethod: #categoryOfClassNamed:.
true
%

category: 'reflection'
method: MCPlatform
categoryOfSelector: aSelector for: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:25' forMethod: #categoryOfSelector:for:.
true
%

category: 'reflection'
method: MCPlatform
classCommentFor: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 12:35' forMethod: #classCommentFor:.
true
%

category: 'smalltalk'
method: MCPlatform
classNamed: aName

	^self globalNamed: aName
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:37' forMethod: #classNamed:.
true
%

category: 'reflection'
method: MCPlatform
classesAndMetaclassesInSystemCategories: categories

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 13:28' forMethod: #classesAndMetaclassesInSystemCategories:.
true
%

category: 'reflection'
method: MCPlatform
classesInSystemCategories: categories

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 14:46' forMethod: #classesInSystemCategories:.
true
%

category: 'reflection'
method: MCPlatform
commentStampFor: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 12:37' forMethod: #commentStampFor:.
true
%

category: 'method additions'
method: MCPlatform
compileMethodAddition: aMethodAddition ifFail: failBlock

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/6/2010 16:17' forMethod: #compileMethodAddition:ifFail:.
true
%

category: 'class definition support'
method: MCPlatform
createClassFrom: aClassDefinition

	self subclassResponsibility

%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:18' forMethod: #createClassFrom:.
true
%

category: 'repositories'
method: MCPlatform
defaultCacheRepository

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 12:37' forMethod: #defaultCacheRepository.
true
%

category: 'displaying'
method: MCPlatform
for: aCollection do: aBlock displayingProgress: aString

	aCollection do: aBlock
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:20' forMethod: #for:do:displayingProgress:.
true
%

category: 'displaying'
method: MCPlatform
for: aStream untilEnd: aBlock displayingProgress: aString

	[ aStream atEnd ] whileFalse: aBlock
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 15:52' forMethod: #for:untilEnd:displayingProgress:.
true
%

category: 'conflict support'
method: MCPlatform
formatSummaryFor: anMCConflict

	^anMCConflict operation summary
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 13:05' forMethod: #formatSummaryFor:.
true
%

category: 'smalltalk'
method: MCPlatform
globalNamed: aName
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 14:47' forMethod: #globalNamed:.
true
%

category: 'smalltalk'
method: MCPlatform
globalNamed: aName ifAbsent: aBlock
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:06' forMethod: #globalNamed:ifAbsent:.
true
%

category: 'smalltalk'
method: MCPlatform
globalNames
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 14:44' forMethod: #globalNames.
true
%

category: 'smalltalk'
method: MCPlatform
globals
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/6/2010 13:31' forMethod: #globals.
true
%

category: 'smalltalk'
method: MCPlatform
hasClassNamed: aName
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 14:47' forMethod: #hasClassNamed:.
true
%

category: 'reflection'
method: MCPlatform
includesLocalSelector: selector for: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:13' forMethod: #includesLocalSelector:for:.
true
%

category: 'method additions'
method: MCPlatform
installMethodAddition: aMethodAddition

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/6/2010 15:52' forMethod: #installMethodAddition:.
true
%

category: 'reading'
method: MCPlatform
integerFromHexString: aString

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 10:20' forMethod: #integerFromHexString:.
true
%

category: 'reflection'
method: MCPlatform
methodCategoriesFor: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:43' forMethod: #methodCategoriesFor:.
true
%

category: 'reflection'
method: MCPlatform
methodSource: selector for: aClass

	^(aClass sourceCodeAt: selector) asString
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:40' forMethod: #methodSource:for:.
true
%

category: 'weak support'
method: MCPlatform
newWeakIdentityKeyDictionary
	^IdentityDictionary new
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:12' forMethod: #newWeakIdentityKeyDictionary.
true
%

category: 'method additions'
method: MCPlatform
notifyMethodAdditionObservers: aMethodAddition
	"noop by default"
%
run
MCPlatform setStamp: 'DaleHenrichs 10/6/2010 16:12' forMethod: #notifyMethodAdditionObservers:.
true
%

category: 'parsing'
method: MCPlatform
parse: aStream class: aClass noPattern: noPattern context: context notifying: requestor ifFail: failBlock

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/7/2010 15:31' forMethod: #parse:class:noPattern:context:notifying:ifFail:.
true
%

category: 'reflection'
method: MCPlatform
removeClassFromSystem: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 10:50' forMethod: #removeClassFromSystem:.
true
%

category: 'reflection'
method: MCPlatform
removeClassNamedFromSystem: className

	(self hasClassNamed: className)
		ifTrue: [ self removeClassFromSystem: (self classNamed: className) ]
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 10:53' forMethod: #removeClassNamedFromSystem:.
true
%

category: 'weak support'
method: MCPlatform
removeWeakDependent: aWeakDependent
	"noop"
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:15' forMethod: #removeWeakDependent:.
true
%

category: 'reflection'
method: MCPlatform
selectorsFor: aClass inCategory: cat

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:51' forMethod: #selectorsFor:inCategory:.
true
%

category: 'utility'
method: MCPlatform
shuffle: aSequenceableCollection
	"Durstenfeld's version of the Fisher-Yates shuffle"
	"suggested by L. Uzonyi"

	| copy generator |
	generator := Random new.
	copy := aSequenceableCollection copy.
	copy size to: 2 by: -1 do: [ :i | 
		| element index |
		index := generator nextInt: i.
		element := copy at: i.
		copy at: i put: (copy at: index).
		copy at: index put: element ].
	^ copy
%
run
MCPlatform setStamp: 'DaleHenrichs 10/8/2010 11:38' forMethod: #shuffle:.
true
%

category: 'reflection'
method: MCPlatform
st80ClassDefinitionFor: aClass

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 10/1/2010 13:04' forMethod: #st80ClassDefinitionFor:.
true
%

category: 'reflection'
method: MCPlatform
systemCategories
	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/29/2010 15:16' forMethod: #systemCategories.
true
%

category: 'reflection'
method: MCPlatform
timeStampForMethod: aCompiledMethod

	self subclassResponsibility
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 16:29' forMethod: #timeStampForMethod:.
true
%

category: 'method definition support'
method: MCPlatform
unloadMethodDefinition: aMethodDefinition
	| class |
	(class := aMethodDefinition actualClass) ~~ nil
		ifTrue: [ aMethodDefinition removeSelector: aMethodDefinition selector fromClass: class ]
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:09' forMethod: #unloadMethodDefinition:.
true
%

category: 'change set support'
method: MCPlatform
useChangeSetNamed: baseName during: aBlock

	aBlock value
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:03' forMethod: #useChangeSetNamed:during:.
true
%

category: 'change set support'
method: MCPlatform
useNewChangeSetDuring: aBlock

	aBlock value
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 14:57' forMethod: #useNewChangeSetDuring:.
true
%

category: 'change set support'
method: MCPlatform
useNewChangeSetNamedLike: baseName during: aBlock

	aBlock value
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:02' forMethod: #useNewChangeSetNamedLike:during:.
true
%

category: 'weak support'
method: MCPlatform
weakArrayClass

	^Array
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:12' forMethod: #weakArrayClass.
true
%

category: 'weak support'
method: MCPlatform
weakSetClass

	^Set
%
run
MCPlatform setStamp: 'DaleHenrichs 9/28/2010 15:16' forMethod: #weakSetClass.
true
%

category: 'testing'
classmethod: MCReader
canReadFileNamed: fileName
	^ (fileName endsWith: self extension)
%
run
MCReader class setStamp: 'avi 1/21/2004 19:00' forMethod: #canReadFileNamed:.
true
%

category: 'testing'
classmethod: MCReader
concreteSubclasses
	^ (MCPlatform current allSubclassesOfMonticelloClass: self) reject: [:c | c isAbstract]
%
run
MCReader class setStamp: 'avi 1/21/2004 19:01' forMethod: #concreteSubclasses.
true
%

category: 'testing'
classmethod: MCReader
isAbstract
	^ (self respondsTo: #extension) not
%
run
MCReader class setStamp: 'avi 1/21/2004 19:01' forMethod: #isAbstract.
true
%

category: 'instance creation'
classmethod: MCReader
on: aStream
	^ self new stream: aStream
%
run
MCReader class setStamp: 'avi 1/21/2004 19:02' forMethod: #on:.
true
%

category: 'instance creation'
classmethod: MCReader
on: aStream name: aFileName
	| class |
	class := self readerClassForFileNamed: aFileName.
	^ class
		ifNil: [self error: 'Unsupported format: ', aFileName]
		ifNotNil: [class on: aStream]
%
run
MCReader class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #on:name:.
true
%

category: 'testing'
classmethod: MCReader
readerClassForFileNamed: fileName
	^ self concreteSubclasses
		detect: [:c | c canReadFileNamed: fileName]
		ifNone: [nil]
%
run
MCReader class setStamp: 'avi 1/21/2004 19:03' forMethod: #readerClassForFileNamed:.
true
%

category: 'accessing'
method: MCReader
stream: aStream
	stream := aStream
%
run
MCReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #stream:.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshotReader
snapshotFromStream: aStream
	^ (self on: aStream) snapshot
%
run
MCSnapshotReader class setStamp: 'avi 1/21/2004 22:56' forMethod: #snapshotFromStream:.
true
%

category: 'as yet unclassified'
method: MCSnapshotReader
definitions
	definitions ifNil: [self loadDefinitions].
	^ definitions
%
run
MCSnapshotReader setStamp: 'avi 1/21/2004 23:09' forMethod: #definitions.
true
%

category: 'as yet unclassified'
method: MCSnapshotReader
snapshot
	^ MCSnapshot fromDefinitions: self definitions
%
run
MCSnapshotReader setStamp: 'avi 1/21/2004 23:10' forMethod: #snapshot.
true
%

category: 'as yet unclassified'
classmethod: MCMcdReader
extension
	^ 'mcd'
%
run
MCMcdReader class setStamp: 'avi 2/13/2004 23:09' forMethod: #extension.
true
%

category: 'as yet unclassified'
method: MCMcdReader
baseInfo
	^ baseInfo ifNil: [self loadBaseInfo]
%
run
MCMcdReader setStamp: 'avi 2/14/2004 21:33' forMethod: #baseInfo.
true
%

category: 'as yet unclassified'
method: MCMcdReader
basicVersion
	^ MCDiffyVersion
		package: self package
		info: self info
		dependencies: self dependencies
		baseInfo: self baseInfo
		patch: self patch
%
run
MCMcdReader setStamp: 'avi 2/13/2004 23:41' forMethod: #basicVersion.
true
%

category: 'as yet unclassified'
method: MCMcdReader
buildPatchFrom: oldDefinitions to: newDefinitions
	^ MCPatch
		fromBase: (MCSnapshot fromDefinitions: oldDefinitions)
		target: (MCSnapshot fromDefinitions: newDefinitions)
%
run
MCMcdReader setStamp: 'avi 2/14/2004 21:37' forMethod: #buildPatchFrom:to:.
true
%

category: 'as yet unclassified'
method: MCMcdReader
loadBaseInfo
	^ baseInfo := self extractInfoFrom: (self parseMember: 'base')
%
run
MCMcdReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loadBaseInfo.
true
%

category: 'as yet unclassified'
method: MCMcdReader
loadPatch
	| old new member |
	(member := self zip memberNamed: 'patch.bin') ~~ nil ifTrue: 
		[ [^ patch := (DataStream on: member contentStream) next ]
			on: Error do: [:fallThrough | ]].
	definitions := OrderedCollection new.
	(self zip membersMatching: 'old/*')
		do: [:m | self extractDefinitionsFrom: m].
	old := definitions asArray.
	definitions := OrderedCollection new.
	(self zip membersMatching: 'new/*')
		do: [:m | self extractDefinitionsFrom: m].
	new := definitions asArray.
	^ patch := self buildPatchFrom: old to: new.
	
%
run
MCMcdReader setStamp: 'DaleHenrichs 9/28/2010 10:36' forMethod: #loadPatch.
true
%

category: 'as yet unclassified'
method: MCMcdReader
patch
	^ patch ifNil: [self loadPatch]
%
run
MCMcdReader setStamp: 'avi 2/14/2004 21:34' forMethod: #patch.
true
%

category: 'accessing'
classmethod: MCMczReader
extension
	^ 'mcz'
%
run
MCMczReader class setStamp: 'cwp 8/1/2003 14:59' forMethod: #extension.
true
%

category: 'testing'
classmethod: MCMczReader
supportsDependencies
	^ true
%
run
MCMczReader class setStamp: 'avi 1/19/2004 14:48' forMethod: #supportsDependencies.
true
%

category: 'testing'
classmethod: MCMczReader
supportsVersions
	^ true
%
run
MCMczReader class setStamp: 'cwp 8/1/2003 12:19' forMethod: #supportsVersions.
true
%

category: 'as yet unclassified'
method: MCMczReader
associate: inputTokens
	| stack result tokens done ans |
	stack := Array new.
	ans := result := Dictionary new.
	tokens := inputTokens.
      done := false.
	[ done ]
 		whileFalse: [
			tokens pairsDo: [:key :value | | v |
				v := value.
				v isString
					ifTrue: [ result at: key put: v ]
					ifFalse: [ | col |
						col := v speciesForCollect new.
						result at: key put: col.
						v do: [:ea | | d |
							d := Dictionary new.
							col add: d.
							stack addLast: (Array with: d with: ea).
						].				
					]
				].
			stack isEmpty
				ifTrue: [ done := true ] 
				ifFalse: [ | a |
					a := stack removeLast.
					result := a at: 1.
					tokens := a at: 2.
				].
	].
	^ ans
%
run
MCMczReader setStamp: 'DaleHenrichs 10/13/2010 10:02' forMethod: #associate:.
true
%

category: 'as yet unclassified'
method: MCMczReader
extractDefinitionsFrom: member
	| reader rc |
	(rc := MCSnapshotReader readerClassForFileNamed: member fileName) ~~ nil
		ifTrue: [ 
			reader := rc on: member contentStream text.
			definitions addAll: reader definitions ]
%
run
MCMczReader setStamp: 'DaleHenrichs 9/28/2010 10:38' forMethod: #extractDefinitionsFrom:.
true
%

category: 'as yet unclassified'
method: MCMczReader
extractDependencyFrom: zipMember
	^ MCVersionDependency
		package: (MCPackage named: (zipMember fileName copyAfterLast: $/))
		info: (self extractInfoFrom: (self parseMember: zipMember fileName))
%
run
MCMczReader setStamp: 'avi 1/19/2004 16:11' forMethod: #extractDependencyFrom:.
true
%

category: 'as yet unclassified'
method: MCMczReader
extractInfoFrom: origDict
	| vn queue creationBlock ic |
	ic := self infoCache.
	vn := self infoCache at: (origDict at: #id) ifAbsent: [nil].
	vn ~~ nil ifTrue: [ ^vn ].
	queue := OrderedCollection new.
	creationBlock := [:dict | | newV name msg date time author |
		newV := self infoCache at: (dict at: #id) ifAbsent: [nil].
		name := dict at: #name ifAbsent: [''].
		msg := dict at: #message ifAbsent: [''].
		date := [ | d |
				[d := Date fromString: (dict at: #date)] on: Error do: [ :ex | ex return: nil ].
				d == nil ifTrue: [ d := Date fromString: (dict at: #date) usingFormat: #(2 1 3 $/ 1 2 $: false ) ].
				d ] on: Error do: [ :ex | ex return: nil ].
		time := [ Time fromString:(dict at: #time)] on: Error do: [ :ex | ex return: nil ].
		author := dict at: #author ifAbsent: [''].
		newV == nil 
			ifTrue: [
				newV := MCVersionInfo
					name: name
					id: (UUID fromString: (dict at: #id))
					message: msg
					date: date
					time: time
					author: author
					ancestors: Array new
					stepChildren: Array new]
			ifFalse: [ "fill in empty slots"
				(newV name isEmpty and: [name isEmpty not])
					ifTrue: [
						newV 
							initializeWithName: name 
							id: newV id 
							message: msg
							date: date 
							time: time 
							author: author 
							ancestors: newV ancestors 
							stepChildren: newV stepChildren]].
		newV].
	vn := creationBlock value: origDict.
	self infoCache at: (origDict at: #id) put: vn.
	queue add: (vn -> origDict).
	[ queue isEmpty ] whileFalse: [ | v assoc vi d |
		assoc := queue removeFirst.
		v := assoc key.
		d := assoc value.
		(d at: #ancestors ifAbsent: [ #() ] ) do: [:ea | 
			vi := self infoCache at: (ea at: #id) ifAbsent: [ nil ].
			vi == nil 
				ifTrue: [
					vi := creationBlock value: ea.
					v ancestors addLast: vi.
					self infoCache at: (ea at: #id) put: vi]
				ifFalse: [vi name isEmpty ifTrue: [ creationBlock value: ea ]].
			queue addFirst: (vi -> ea). 
			self infoCache at: (ea at: #id) put: vi].
		(d at: #stepChildren ifAbsent: [ #() ] ) do: [:ea | 
			vi := self infoCache at: (ea at: #id) ifAbsentPut: [ 
				vi := creationBlock value: ea.
				v stepChildren addLast: vi.
				vi].
			queue addFirst: (vi -> ea). 
			self infoCache at: (ea at: #id) put: vi]].
	^vn
%
run
MCMczReader setStamp: 'avi 9/17/2005 23:38' forMethod: #extractInfoFrom:.
true
%

category: 'as yet unclassified'
method: MCMczReader
infoCache
	^ infoCache ifNil: [infoCache := Dictionary new]
%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #infoCache.
true
%

category: 'as yet unclassified'
method: MCMczReader
loadDefinitions
	|member |
	definitions := OrderedCollection new.
	(member := self zip memberNamed: 'snapshot.bin') ~~ nil ifTrue: 
		[[^ definitions := (DataStream on: member contentStream) next definitions]
			on: Error do: [:fallThrough | self error: 'about to fallThrough' ]].
	"otherwise"
	(self zip membersMatching: 'snapshot/*')
		do: [:m | self extractDefinitionsFrom: m].

%
run
MCMczReader setStamp: 'DaleHenrichs 10/20/2010 14:09' forMethod: #loadDefinitions.
true
%

category: 'as yet unclassified'
method: MCMczReader
loadDependencies
	dependencies := (self zip membersMatching: 'dependencies/*') collect: [:m | self extractDependencyFrom: m].
	dependencies := dependencies asArray.

%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loadDependencies.
true
%

category: 'as yet unclassified'
method: MCMczReader
loadPackage
	| dict |
	dict := self parseMember: 'package'.
	package := MCPackage named: (dict at: #name)
%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loadPackage.
true
%

category: 'as yet unclassified'
method: MCMczReader
loadVersionInfo
	info := self extractInfoFrom: (self parseMember: 'version')
%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #loadVersionInfo.
true
%

category: 'as yet unclassified'
method: MCMczReader
parseMember: fileName
	| tokens |
	tokens := (self scanner scanTokens: (self zip contentsOf: fileName)) first.
	^ self associate: tokens
%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #parseMember:.
true
%

category: 'as yet unclassified'
method: MCMczReader
scanner
	^ MCScanner
%
run
MCMczReader setStamp: 'avi 1/22/2004 20:33' forMethod: #scanner.
true
%

category: 'as yet unclassified'
method: MCMczReader
zip
	zip ifNil:
		[zip := ZipArchive new.
		zip readFrom: stream].
	^ zip
%
run
MCMczReader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #zip.
true
%

category: 'reading'
classmethod: MCVersionReader
on: s fileName: f
	^ self on: s
%
run
MCVersionReader class setStamp: 'bf 3/23/2005 01:20' forMethod: #on:fileName:.
true
%

category: 'reading'
classmethod: MCVersionReader
versionFromStream: aStream
	^ (self on: aStream) version
%
run
MCVersionReader class setStamp: 'avi 1/21/2004 22:58' forMethod: #versionFromStream:.
true
%

category: 'reading'
classmethod: MCVersionReader
versionInfoFromStream: aStream
	^ (self on: aStream) info
%
run
MCVersionReader class setStamp: 'avi 1/21/2004 22:59' forMethod: #versionInfoFromStream:.
true
%

category: 'accessing'
method: MCVersionReader
basicVersion
	^ MCVersion
		package: self package
		info: self info
		snapshot: self snapshot
		dependencies: self dependencies
%
run
MCVersionReader setStamp: 'avi 1/19/2004 16:52' forMethod: #basicVersion.
true
%

category: 'accessing'
method: MCVersionReader
definitions
	definitions ifNil: [self loadDefinitions].
	^ definitions
%
run
MCVersionReader setStamp: 'avi 1/21/2004 23:10' forMethod: #definitions.
true
%

category: 'accessing'
method: MCVersionReader
dependencies
	dependencies ifNil: [self loadDependencies].
	^ dependencies
%
run
MCVersionReader setStamp: 'avi 1/19/2004 14:50' forMethod: #dependencies.
true
%

category: 'accessing'
method: MCVersionReader
info
	info ifNil: [self loadVersionInfo].
	^ info
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:53' forMethod: #info.
true
%

category: 'loading'
method: MCVersionReader
loadDefinitions
	self subclassResponsibility 
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:54' forMethod: #loadDefinitions.
true
%

category: 'loading'
method: MCVersionReader
loadDependencies
	self subclassResponsibility 
%
run
MCVersionReader setStamp: 'avi 1/19/2004 14:50' forMethod: #loadDependencies.
true
%

category: 'loading'
method: MCVersionReader
loadPackage
	self subclassResponsibility 
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:54' forMethod: #loadPackage.
true
%

category: 'loading'
method: MCVersionReader
loadVersionInfo
	self subclassResponsibility
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:54' forMethod: #loadVersionInfo.
true
%

category: 'accessing'
method: MCVersionReader
package
	package ifNil: [self loadPackage].
	^ package
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:53' forMethod: #package.
true
%

category: 'accessing'
method: MCVersionReader
snapshot
	^ MCSnapshot fromDefinitions: self definitions
%
run
MCVersionReader setStamp: 'ab 8/20/2003 19:54' forMethod: #snapshot.
true
%

category: 'accessing'
method: MCVersionReader
version
	^ self basicVersion
%
run
MCVersionReader setStamp: 'avi 10/9/2003 12:38' forMethod: #version.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
= other
	^ self == other
%
run
MCDictionaryRepository setStamp: 'ab 8/21/2003 12:56' forMethod: #=.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
allVersionInfos
	^ dict values collect: [:ea | ea info]
%
run
MCDictionaryRepository setStamp: 'ab 8/20/2003 21:04' forMethod: #allVersionInfos.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
basicStoreVersion: aVersion
	dict at: aVersion info put: aVersion
%
run
MCDictionaryRepository setStamp: 'avi 8/26/2004 14:20' forMethod: #basicStoreVersion:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
closestAncestorVersionFor: anAncestry ifNone: errorBlock
	| info |
	info := anAncestry breadthFirstAncestors
			detect: [:ea | self includesVersionWithInfo: ea]
			ifNone: [^ errorBlock value].
	^ self versionWithInfo: info
%
run
MCDictionaryRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #closestAncestorVersionFor:ifNone:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
description

	^ description ifNil: ['cache']
%
run
MCDictionaryRepository setStamp: 'ab 7/26/2003 02:47' forMethod: #description.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
description: aString

	description := aString 
%
run
MCDictionaryRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #description:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
dictionary

	^ dict
%
run
MCDictionaryRepository setStamp: 'ab 7/26/2003 02:47' forMethod: #dictionary.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
dictionary: aDictionary

	dict := aDictionary
%
run
MCDictionaryRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #dictionary:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
includesVersionNamed: aString
	^ dict anySatisfy: [:ea | ea info name = aString]
%
run
MCDictionaryRepository setStamp: 'ab 7/21/2003 23:39' forMethod: #includesVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
includesVersionWithInfo: aVersionInfo
	^ dict includesKey: aVersionInfo
%
run
MCDictionaryRepository setStamp: 'ab 8/21/2003 19:49' forMethod: #includesVersionWithInfo:.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
initialize

	super initialize.
	dict := Dictionary new.

%
run
MCDictionaryRepository setStamp: 'alain.plantec 5/28/2009 10:02' forMethod: #initialize.
true
%

category: 'cache repository'
method: MCDictionaryRepository
removeVersionsMatching: pattern
	"just flush the whole dictionary for now"
	
	dict := Dictionary new.

%
run
MCDictionaryRepository setStamp: 'DaleHenrichs 10/8/2010 16:19' forMethod: #removeVersionsMatching:.
true
%

category: 'cache repository'
method: MCDictionaryRepository
repositoryCacheExists

	^true
%
run
MCDictionaryRepository setStamp: 'DaleHenrichs 10/8/2010 12:41' forMethod: #repositoryCacheExists.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
sortedVersionInfos
	| sorter |
	sorter := MCVersionSorter new.
	self allVersionInfos do: [:ea | sorter addVersionInfo: ea].
	^ sorter sortedVersionInfos

%
run
MCDictionaryRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #sortedVersionInfos.
true
%

category: 'as yet unclassified'
method: MCDictionaryRepository
versionWithInfo: aVersionInfo ifAbsent: errorBlock
	^ dict at: aVersionInfo ifAbsent: errorBlock
%
run
MCDictionaryRepository setStamp: 'ab 8/16/2003 18:22' forMethod: #versionWithInfo:ifAbsent:.
true
%

category: 'cleanup'
classmethod: MCFileBasedRepository
cleanUp
	"Flush caches"

	self flushAllCaches.
%
run
MCFileBasedRepository class setStamp: 'StephaneDucasse 3/9/2010 16:33' forMethod: #cleanUp.
true
%

category: 'as yet unclassified'
classmethod: MCFileBasedRepository
flushAllCaches
	self allSubInstancesDo: [:ea | ea flushCache]
%
run
MCFileBasedRepository class setStamp: 'avi 2/3/2005 00:43' forMethod: #flushAllCaches.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
allFileNames
	self subclassResponsibility
%
run
MCFileBasedRepository setStamp: 'ab 8/21/2003 00:35' forMethod: #allFileNames.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
allFileNamesForVersionNamed: aString
	^ self filterFileNames: self readableFileNames forVersionNamed: aString
%
run
MCFileBasedRepository setStamp: 'ab 8/21/2003 20:01' forMethod: #allFileNamesForVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
allFileNamesOrCache
	^ allFileNames ifNil: [self allFileNames]
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 16:40' forMethod: #allFileNamesOrCache.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
allVersionNames
	^ self readableFileNames collect: [:ea | self versionNameFromFileName: ea]
%
run
MCFileBasedRepository setStamp: 'ab 8/21/2003 00:40' forMethod: #allVersionNames.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
basicStoreVersion: aVersion
	self
		writeStreamForFileNamed: aVersion fileName
		do: [:s | aVersion fileOutOn: s].
	aVersion isCacheable ifTrue: [
		cache ifNil: [cache := Dictionary new].
		cache at: aVersion fileName put: aVersion].

%
run
MCFileBasedRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #basicStoreVersion:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
cache
	^ cache ifNil: [cache := Dictionary new]
%
run
MCFileBasedRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #cache.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
cacheAllFileNamesDuring: aBlock
	allFileNames := self allFileNames.
	^ aBlock ensure: [allFileNames := nil]
%
run
MCFileBasedRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #cacheAllFileNamesDuring:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
cachedFileNames
	^cache == nil
		ifTrue: [#()]
		ifFalse: [cache keys]
%
run
MCFileBasedRepository setStamp: 'bf 6/9/2005 15:47' forMethod: #cachedFileNames.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
canReadFileNamed: aString
	| reader |
	reader := MCVersionReader readerClassForFileNamed: aString.
	^ reader notNil
%
run
MCFileBasedRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #canReadFileNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
closestAncestorVersionFor: anAncestry ifNone: errorBlock
	^ self cacheAllFileNamesDuring:
		[super closestAncestorVersionFor: anAncestry ifNone: errorBlock]
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 16:40' forMethod: #closestAncestorVersionFor:ifNone:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
filterFileNames: aCollection forVersionNamed: aString
	^ aCollection select: [:ea | (self versionNameFromFileName: ea) = aString] 
%
run
MCFileBasedRepository setStamp: 'ab 8/21/2003 20:01' forMethod: #filterFileNames:forVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
flushCache
	cache := nil
%
run
MCFileBasedRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #flushCache.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
includesVersionNamed: aString
	^ self allVersionNames includes: aString
%
run
MCFileBasedRepository setStamp: 'ab 8/21/2003 00:36' forMethod: #includesVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
loadVersionFromFileNamed: aString
	^ self versionReaderForFileNamed: aString do: [:r | r version]
%
run
MCFileBasedRepository setStamp: 'avi 1/22/2004 13:34' forMethod: #loadVersionFromFileNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
loadVersionInfoFromFileNamed: aString
	^ self versionReaderForFileNamed: aString do: [:r | r info]
	
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 18:37' forMethod: #loadVersionInfoFromFileNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
maxCacheSize
	^ 8
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 16:52' forMethod: #maxCacheSize.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
notifyList
	(self allFileNames includes: 'notify') ifFalse: [^ #()].
	^ self readStreamForFileNamed: 'notify' do:
		[:s |
		s upToEnd withSqueakLineEndings lines]
%
run
MCFileBasedRepository setStamp: 'HenrikSperreJohansen 6/12/2010 02:47' forMethod: #notifyList.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
possiblyNewerVersionsOfAnyOf: someVersions
	| pkgs |
	pkgs := Dictionary new.

	someVersions do: [:aVersionInfo |
		pkgs at: (aVersionInfo name copyUpToLast: $-)
			put: (aVersionInfo name copyAfterLast: $.) asNumber].

	^[self allVersionNames select: [:each |
		(pkgs at: (each copyUpToLast: $-) ifPresent: [:verNumber |
			verNumber < (each copyAfterLast: $.) asNumber
				or: [verNumber = (each copyAfterLast: $.) asNumber
					and: [someVersions noneSatisfy: [:v | v name = each]]]]) == true]
	] on: Error do: [:ex | ex return: #()]
%
run
MCFileBasedRepository setStamp: 'bf 3/11/2005 18:01' forMethod: #possiblyNewerVersionsOfAnyOf:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
readableFileNames
	| all cached new |
	all := self allFileNamesOrCache.	"from repository"
	cached := self cachedFileNames.	"in memory"
	new := all reject: [:each |  cached includes: each ].
	^ (cached asArray, new)
		select: [:ea | self canReadFileNamed: ea]
%
run
MCFileBasedRepository setStamp: 'DaleHenrichs 10/1/2010 15:36' forMethod: #readableFileNames.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
resizeCache: aDictionary
	[aDictionary size <= self maxCacheSize] whileFalse:
		[aDictionary removeKey: aDictionary keys atRandom]
%
run
MCFileBasedRepository setStamp: 'avi 9/18/2005 22:43' forMethod: #resizeCache:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
versionFromFileNamed: aString
	| v |
	v := self cache at: aString ifAbsent: [self loadVersionFromFileNamed: aString].
	self resizeCache: cache.
	(v notNil and: [v isCacheable]) ifTrue: [cache at: aString put: v].
	^ v
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 23:09' forMethod: #versionFromFileNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
versionInfoFromFileNamed: aString
	self cache at: aString ifPresent: [:v | ^ v info].
	^ self loadVersionInfoFromFileNamed: aString
%
run
MCFileBasedRepository setStamp: 'avi 9/17/2005 18:37' forMethod: #versionInfoFromFileNamed:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
versionNameFromFileName: aString
	^ (aString copyUpToLast: $.) copyUpTo: $(
%
run
MCFileBasedRepository setStamp: 'bf 5/30/2005 22:52' forMethod: #versionNameFromFileName:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
versionReaderForFileNamed: aString do: aBlock
	| class |
	^ self
		readStreamForFileNamed: aString
		do: [:s |
			(class := MCVersionReader readerClassForFileNamed: aString) ~~ nil ifTrue: 
				[ aBlock value: (class on: s fileName: aString) ]]

%
run
MCFileBasedRepository setStamp: 'DaleHenrichs 9/28/2010 10:58' forMethod: #versionReaderForFileNamed:do:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
versionWithInfo: aVersionInfo ifAbsent: errorBlock
	
	(self allFileNamesForVersionNamed: aVersionInfo name) do:
		[:fileName | | version |
		version := self versionFromFileNamed: fileName.
		version info = aVersionInfo ifTrue: [^ version]].
	^ errorBlock value
%
run
MCFileBasedRepository setStamp: 'nice 1/5/2010 15:59' forMethod: #versionWithInfo:ifAbsent:.
true
%

category: 'as yet unclassified'
method: MCFileBasedRepository
writeStreamForFileNamed: aString do: aBlock
	^ self writeStreamForFileNamed: aString replace: false do: aBlock
%
run
MCFileBasedRepository setStamp: 'avi 10/31/2003 14:32' forMethod: #writeStreamForFileNamed:do:.
true
%

category: 'as yet unclassified'
classmethod: MCFilesystemCacheRepository
checkCache
        | value |
        value := SessionTemps current at: #DEFAULT_VALUE_FOR_MCFilesystemCacheRepository ifAbsent: [].
	value notNil and: [value repositoryCacheExists ifFalse: [SessionTemps current at: #DEFAULT_VALUE_FOR_MCFilesystemCacheRepository put: nil]]
%
run
MCFilesystemCacheRepository class setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #checkCache.
true
%

category: 'as yet unclassified'
classmethod: MCFilesystemCacheRepository
default
        | value |
	self checkCache.
        value := SessionTemps current at: #DEFAULT_VALUE_FOR_MCFilesystemCacheRepository otherwise: nil.
        value == nil
                ifTrue: [
                        value := MCPlatform current defaultCacheRepository.
                        SessionTemps current at: #DEFAULT_VALUE_FOR_MCFilesystemCacheRepository put: value].
        ^value
%
run
MCFilesystemCacheRepository class setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #default.
true
%

category: 'as yet unclassified'
classmethod: MCFilesystemCacheRepository
isAbstract
        ^true
%

category: 'as yet unclassified'
classmethod: MCFilesystemCacheRepository
initialize
	self checkCache
%
run
MCFilesystemCacheRepository class setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
basicStoreVersion: aVersion
	(aVersion isCacheable and: [self allFileNames includes: aVersion fileName])
		ifFalse: [super basicStoreVersion: aVersion]

%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #basicStoreVersion:.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
cacheForPackage: aPackage
	packageCaches ifNil: [packageCaches := Dictionary new].
	^ packageCaches at: aPackage ifAbsentPut: [MCPackageCache new]
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #cacheForPackage:.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
newFileNames 
	| seen |
	seen := self seenFileNames.
	^self allFileNames reject: [:each | seen includes: each ]
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #newFileNames.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
packageForFileNamed: aString
	^ self packageCache at: aString ifAbsentPut: [self versionReaderForFileNamed: aString do: [:r | r package]]
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #packageForFileNamed:.
true
%

category: 'cache repository'
method: MCFilesystemCacheRepository
removeVersionsMatching: pattern

	| dir |
	dir := self directory.
	(dir fileNamesMatching: pattern) do: [:ea | dir deleteFileNamed: ea].

%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #removeVersionsMatching:.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
rescan
	MCPlatform current
		for: self newFileNames
		do: [ :ea | 
			self
				versionReaderForFileNamed: ea
				do: [ :reader | 
					(self cacheForPackage: reader package) recordVersionInfo: reader info forFileNamed: ea.
					self seenFileNames add: ea ] ]
		displayingProgress: 'Scanning cache...'
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #rescan.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
seenFileNames
	^ seenFiles ifNil: [seenFiles := OrderedCollection new]
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #seenFileNames.
true
%

category: 'as yet unclassified'
method: MCFilesystemCacheRepository
versionInfoForFileNamed: aString
	^ self infoCache at: aString ifAbsentPut: [self versionReaderForFileNamed: aString do: [:r | r info]]
%
run
MCFilesystemCacheRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #versionInfoForFileNamed:.
true
%

category: 'instance creation'
classmethod: MCFilesystemRepository
defaultDirectoryName
        ^SessionTemps current at: #DEFAULT_DIRECTORYNAME_FOR_MCFilesystemRepositor ifAbsent: [ FSDiskFilesystem pwd printString ]
%
run
MCFilesystemRepository class setStamp: 'DaleHenrichs 10/20/2010 12:13' forMethod: #defaultDirectoryName.
true
%

category: 'instance creation'
classmethod: MCFilesystemRepository
defaultDirectoryName: aDirectoryName

        SessionTemps current at: #DEFAULT_DIRECTORYNAME_FOR_MCFilesystemRepository put: aDirectoryName
%
run
MCFilesystemRepository class setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #defaultDirectoryName:.
true
%

category: 'as yet unclassified'
classmethod: MCFilesystemRepository
isAbstract
        ^false
%

category: 'as yet unclassified'
method: MCFilesystemRepository
allFileNames
	^ (directory entries sortBy: [:a :b | a modificationSeconds >= b modificationSeconds]) collect: [:ea | ea basename]
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:13' forMethod: #allFileNames.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
description
	^ directory pathName
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #description.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
directory
	^ directory
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #directory.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
directory: anFSReference
	directory := anFSReference
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:15' forMethod: #directory:.
true
%

category: 'comparing'
method: MCFilesystemRepository
hash
	^ directory hash
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:20' forMethod: #hash.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
initialize
	super initialize.
	directory := FSDiskFilesystem pwd
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:15' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
isValid
	^directory exists
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #isValid.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
readStreamForFileNamed: aString do: aBlock

	| val |
	val := (directory / aString) readOnlyStreamDo: [:file | aBlock value: file ].
	^ val
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:17' forMethod: #readStreamForFileNamed:do:.
true
%

category: 'cache repository'
method: MCFilesystemRepository
repositoryCacheExists

	^self directory exists
%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:02' forMethod: #repositoryCacheExists.
true
%

category: 'as yet unclassified'
method: MCFilesystemRepository
writeStreamForFileNamed: aString replace: aBoolean do: aBlock

	| reference |
	reference := directory / aString.
	aBoolean ifTrue: [ reference exists ifTrue: [ reference delete ]].
	reference writeStreamDo: [:file | aBlock value: file ].

%
run
MCFilesystemRepository setStamp: 'DaleHenrichs 10/20/2010 12:19' forMethod: #writeStreamForFileNamed:replace:do:.
true
%

category: 'as yet unclassified'
classmethod: MCRepository
allConcreteSubclasses
	^ (MCPlatform current allSubclassesOfMonticelloClass: self), {self} reject: [:ea | ea isAbstract]
%
run
MCRepository class setStamp: 'ab 8/21/2003 00:30' forMethod: #allConcreteSubclasses.
true
%

category: 'as yet unclassified'
classmethod: MCRepository
creationTemplate
	self subclassResponsibility.
%
run
MCRepository class setStamp: 'bkv 2/18/2004 20:59' forMethod: #creationTemplate.
true
%

category: 'as yet unclassified'
classmethod: MCRepository
isAbstract
        ^true 
%

category: 'as yet unclassified'
classmethod: MCRepository
fillInTheBlankRequest
	self subclassResponsibility.
%
run
MCRepository class setStamp: 'bkv 2/18/2004 20:58' forMethod: #fillInTheBlankRequest.
true
%

category: 'as yet unclassified'
classmethod: MCRepository
isAbstract
	^ self description isNil
%
run
MCRepository class setStamp: 'ab 8/21/2003 12:59' forMethod: #isAbstract.
true
%

category: 'instance creation'
classmethod: MCRepository
new

	^ self basicNew initialize

%
run
MCRepository class setStamp: 'DaleHenrichs 9/29/2010 16:33' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCRepository
= other
	^ other species = self species and: [other description = self description]
%
run
MCRepository setStamp: 'ab 8/21/2003 12:36' forMethod: #=.
true
%

category: 'as yet unclassified'
method: MCRepository
alwaysStoreDiffs
	^ storeDiffs ifNil: [false]
%
run
MCRepository setStamp: 'avi 8/31/2004 01:08' forMethod: #alwaysStoreDiffs.
true
%

category: 'as yet unclassified'
method: MCRepository
asCreationTemplate
	^ self creationTemplate
%
run
MCRepository setStamp: 'bkv 2/18/2004 20:48' forMethod: #asCreationTemplate.
true
%

category: 'as yet unclassified'
method: MCRepository
basicStoreVersion: aVersion
	self subclassResponsibility
%
run
MCRepository setStamp: 'avi 8/26/2004 14:20' forMethod: #basicStoreVersion:.
true
%

category: 'as yet unclassified'
method: MCRepository
closestAncestorVersionFor: anAncestry ifNone: errorBlock
	| v |
	anAncestry breadthFirstAncestorsDo:
		[:ancestorInfo |
		(v := self versionWithInfo: ancestorInfo) ~~ nil ifTrue: [^ v]].
	^ errorBlock value
%
run
MCRepository setStamp: 'DaleHenrichs 9/28/2010 11:00' forMethod: #closestAncestorVersionFor:ifNone:.
true
%

category: 'as yet unclassified'
method: MCRepository
creationTemplate
	^ creationTemplate
%
run
MCRepository setStamp: 'bkv 2/18/2004 20:46' forMethod: #creationTemplate.
true
%

category: 'as yet unclassified'
method: MCRepository
creationTemplate: aString
	self creationTemplate ifNotNil: [ self error: 'Creation template already set for this MCRepository instance.' ].
	
	creationTemplate := aString.
%
run
MCRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #creationTemplate:.
true
%

category: 'as yet unclassified'
method: MCRepository
description
	^ self class name
%
run
MCRepository setStamp: 'avi 10/9/2003 12:53' forMethod: #description.
true
%

category: 'as yet unclassified'
method: MCRepository
doAlwaysStoreDiffs
	storeDiffs := true
%
run
MCRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #doAlwaysStoreDiffs.
true
%

category: 'as yet unclassified'
method: MCRepository
doNotAlwaysStoreDiffs
	storeDiffs := false
%
run
MCRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #doNotAlwaysStoreDiffs.
true
%

category: 'as yet unclassified'
method: MCRepository
hash
	^ self description hash
%
run
MCRepository setStamp: 'ab 8/21/2003 12:36' forMethod: #hash.
true
%

category: 'interface'
method: MCRepository
includesVersionNamed: aString
	self subclassResponsibility
%
run
MCRepository setStamp: 'ab 8/21/2003 12:40' forMethod: #includesVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCRepository
initialize

%
run
MCRepository setStamp: 'DaleHenrichs 9/29/2010 16:34' forMethod: #initialize.
true
%

category: 'testing'
method: MCRepository
isValid
	^true
%
run
MCRepository setStamp: 'nk 11/2/2003 10:55' forMethod: #isValid.
true
%

category: 'as yet unclassified'
method: MCRepository
notifyList
	^ #()
%
run
MCRepository setStamp: 'avi 8/26/2004 14:23' forMethod: #notifyList.
true
%

category: 'as yet unclassified'
method: MCRepository
possiblyNewerVersionsOfAnyOf: someVersions
	^#()
%
run
MCRepository setStamp: 'bf 3/10/2005 23:01' forMethod: #possiblyNewerVersionsOfAnyOf:.
true
%

category: 'as yet unclassified'
method: MCRepository
prepareVersionForStorage: aVersion
	^ self alwaysStoreDiffs
		ifTrue: [aVersion asDiffAgainst:
				 (self closestAncestorVersionFor: aVersion info ifNone: [^ aVersion])]
		ifFalse: [aVersion]
%
run
MCRepository setStamp: 'avi 8/31/2004 01:06' forMethod: #prepareVersionForStorage:.
true
%

category: 'as yet unclassified'
method: MCRepository
printOn: aStream
	super printOn: aStream.
	aStream
		nextPut: $(;
		nextPutAll: self description;
		nextPut: $).
%
run
MCRepository setStamp: 'mas 9/24/2003 04:21' forMethod: #printOn:.
true
%

category: 'cache repository'
method: MCRepository
removeVersionsMatching: pattern

	self subclassResponsibility
%
run
MCRepository setStamp: 'DaleHenrichs 10/8/2010 16:15' forMethod: #removeVersionsMatching:.
true
%

category: 'cache repository'
method: MCRepository
repositoryCacheExists

	^self subclassResponsibility
%
run
MCRepository setStamp: 'DaleHenrichs 10/8/2010 12:41' forMethod: #repositoryCacheExists.
true
%

category: 'as yet unclassified'
method: MCRepository
sendNotificationsForVersion: aVersion
	| notification notifyList |
	notifyList := self notifyList.
	notifyList isEmpty ifFalse:
		[notification := self notificationForVersion: aVersion.
		notifyList do: [:ea | notification notify: ea]]
%
run
MCRepository setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #sendNotificationsForVersion:.
true
%

category: 'as yet unclassified'
method: MCRepository
storeVersion: aVersion
	self basicStoreVersion: (self prepareVersionForStorage: aVersion).
	self sendNotificationsForVersion: aVersion
%
run
MCRepository setStamp: 'avi 8/31/2004 01:05' forMethod: #storeVersion:.
true
%

category: 'interface'
method: MCRepository
versionWithInfo: aVersionInfo
	^ self versionWithInfo: aVersionInfo ifAbsent: [nil]
%
run
MCRepository setStamp: 'avi 10/9/2003 12:42' forMethod: #versionWithInfo:.
true
%

category: 'interface'
method: MCRepository
versionWithInfo: aVersionInfo ifAbsent: aBlock
	self subclassResponsibility 
%
run
MCRepository setStamp: 'ab 8/16/2003 18:22' forMethod: #versionWithInfo:ifAbsent:.
true
%

category: 'as yet unclassified'
classmethod: MCRepositoryGroup
default
        | value |
        value := SessionTemps current at: #DEFAULT_VALUE_FOR_MCRepositoryGroup otherwise: nil.
        value == nil
                ifTrue: [
                        value := self new.
                        SessionTemps current at: #DEFAULT_VALUE_FOR_MCRepositoryGroup put: value].
        ^value
%
run
MCRepositoryGroup class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #default.
true
%

category: 'instance creation'
classmethod: MCRepositoryGroup
new

	^ self basicNew initialize

%
run
MCRepositoryGroup class setStamp: 'DaleHenrichs 9/29/2010 16:40' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
addRepository: aRepository
	((repositories includes: aRepository) or: [aRepository == MCPlatform current cacheRepository])
		ifFalse: [repositories add: aRepository.
				self class default addRepository: aRepository].
	^ aRepository
%
run
MCRepositoryGroup setStamp: 'DaleHenrichs 10/20/2010 12:33' forMethod: #addRepository:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
disableCache
	useCache := false
%
run
MCRepositoryGroup setStamp: 'NorbertHartl 6/20/2008 10:11' forMethod: #disableCache.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
includes: aRepository
	^ self repositories includes: aRepository
%
run
MCRepositoryGroup setStamp: 'avi 11/7/2003 00:20' forMethod: #includes:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
includesVersionNamed: aString
	self repositoriesDo: [:ea | (ea includesVersionNamed: aString) ifTrue: [^ true]].
	^ false	
%
run
MCRepositoryGroup setStamp: 'abc 11/6/2004 20:32' forMethod: #includesVersionNamed:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
initialize

	repositories := OrderedCollection new
%
run
MCRepositoryGroup setStamp: 'DaleHenrichs 9/29/2010 16:39' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
removeRepository: aRepository
	repositories remove: aRepository ifAbsent: [].
%
run
MCRepositoryGroup setStamp: 'lr 5/9/2010 19:04' forMethod: #removeRepository:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
repositories
	^ (self useCache 
		ifTrue: [Array with: MCPlatform current cacheRepository] 
		ifFalse: [Array new]) , (repositories select: [:each | each isValid ]) 
%
run
MCRepositoryGroup setStamp: 'DaleHenrichs 10/20/2010 12:33' forMethod: #repositories.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
repositoriesDo: aBlock
	self repositories do: [:ea | [aBlock value: ea] on: Error do: []]
%
run
MCRepositoryGroup setStamp: 'avi 11/7/2003 00:51' forMethod: #repositoriesDo:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
useCache
	^ useCache ifNil: [
		useCache := true
	]
%
run
MCRepositoryGroup setStamp: 'abc 6/20/2008 10:02' forMethod: #useCache.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
versionWithInfo: aVersionInfo
	^self versionWithInfo: aVersionInfo ifNone: [ self error: 'Could not find version ', aVersionInfo name printString,'. Maybe you need to add a repository?' ]
%
run
MCRepositoryGroup setStamp: 'dvf 8/10/2004 23:02' forMethod: #versionWithInfo:.
true
%

category: 'as yet unclassified'
method: MCRepositoryGroup
versionWithInfo: aVersionInfo ifNone: aBlock
	| v |
	self repositoriesDo: [:ea | (v := ea versionWithInfo: aVersionInfo) ~~ nil ifTrue:  [^ v]].
	^aBlock value
%
run
MCRepositoryGroup setStamp: 'DaleHenrichs 9/28/2010 11:01' forMethod: #versionWithInfo:ifNone:.
true
%

category: 'as yet unclassified'
classmethod: MCScanner
scan: aStream
	^ (self new stream: aStream) next
%
run
MCScanner class setStamp: 'avi 1/22/2004 20:14' forMethod: #scan:.
true
%

category: 'as yet unclassified'
classmethod: MCScanner
scanTokens: aString
	"compatibility"
	^ Array with: (self scan: aString readStream)
%
run
MCScanner class setStamp: 'avi 1/22/2004 20:32' forMethod: #scanTokens:.
true
%

category: 'as yet unclassified'
method: MCScanner
next
  "non-recursive variant of next, to avoid stack overflow conditions in Gemstone"
	| c stack token |
	stack := Array new.
	[stream atEnd] 
		whileFalse: [
			stream skipSeparators.
			c := stream peek.
			c = $# ifTrue: [c := stream next; peek].
			c = $' 
				ifTrue: [token := self nextString]
				ifFalse: [
					c = $( 
						ifTrue: [	
							stream next. "("
							stack addLast: (WriteStream on: Array new).
						]
						ifFalse: [
							c =$)
								ifTrue: [
									stream next. ")"
									token := stack last contents.
									stack removeLast .
								]
								ifFalse: [
									c isAlphaNumeric 
										ifTrue: [token := self nextSymbol]
										ifFalse: [ self error: 'Unknown token type' ].
								].
						]
				].
			stack isEmpty 
				ifTrue: [ ^token ]
				ifFalse: [ token ~~ nil ifTrue: [ stack last nextPut: token ]].
			token := nil.
		].
	stack size > 1 ifTrue: [self error: 'Unclosed array'].
	^stack last contents
%
run
MCScanner setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #next.
true
%

category: 'as yet unclassified'
method: MCScanner
nextArray
	stream next. "("
	^ Array streamContents:
		[:s |
		[stream skipSeparators.
		(stream peek = $)) or: [stream atEnd]] whileFalse: [s nextPut: self next].
		stream next = $) ifFalse: [self error: 'Unclosed array']]
%
run
MCScanner setStamp: 'avi 1/22/2004 20:27' forMethod: #nextArray.
true
%

category: 'as yet unclassified'
method: MCScanner
nextString
	^ stream nextDelimited: $'
%
run
MCScanner setStamp: 'avi 1/22/2004 20:09' forMethod: #nextString.
true
%

category: 'as yet unclassified'
method: MCScanner
nextSymbol
	^ (String streamContents:
		[:s |
		[stream peek isAlphaNumeric] whileTrue: [s nextPut: stream next]]) asSymbol
			
%
run
MCScanner setStamp: 'avi 1/22/2004 20:16' forMethod: #nextSymbol.
true
%

category: 'as yet unclassified'
method: MCScanner
stream: aStream
	stream := aStream
%
run
MCScanner setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #stream:.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshot
empty
	^ self fromDefinitions: #()
%
run
MCSnapshot class setStamp: 'ab 7/6/2003 23:48' forMethod: #empty.
true
%

category: 'as yet unclassified'
classmethod: MCSnapshot
fromDefinitions: aCollection
	^ self new initializeWithDefinitions: aCollection
%
run
MCSnapshot class setStamp: 'ab 7/6/2003 23:48' forMethod: #fromDefinitions:.
true
%

category: 'accessing'
method: MCSnapshot
= other
	^ definitions asArray = other definitions asArray
%
run
MCSnapshot setStamp: 'ab 7/10/2003 01:05' forMethod: #=.
true
%

category: 'accessing'
method: MCSnapshot
definitions
	^ definitions
%
run
MCSnapshot setStamp: 'ab 12/4/2002 18:09' forMethod: #definitions.
true
%

category: 'accessing'
method: MCSnapshot
hash
	^ definitions asArray hash
%
run
MCSnapshot setStamp: 'ab 7/10/2003 01:05' forMethod: #hash.
true
%

category: 'initializing'
method: MCSnapshot
initializeWithDefinitions: aCollection
	definitions := aCollection.
%
run
MCSnapshot setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithDefinitions:.
true
%

category: 'loading'
method: MCSnapshot
install
	MCPackageLoader installSnapshot: self
%
run
MCSnapshot setStamp: 'ab 7/6/2003 23:31' forMethod: #install.
true
%

category: 'patching'
method: MCSnapshot
patchRelativeToBase: aSnapshot
	^ MCPatch fromBase: aSnapshot target: self
%
run
MCSnapshot setStamp: 'ab 7/7/2003 00:37' forMethod: #patchRelativeToBase:.
true
%

category: 'loading'
method: MCSnapshot
updatePackage: aPackage
	MCPackageLoader updatePackage: aPackage withSnapshot: self
%
run
MCSnapshot setStamp: 'ab 7/7/2003 12:11' forMethod: #updatePackage:.
true
%

category: 'as yet unclassified'
classmethod: MCClassInstanceVariableDefinition
type
	^ #classInstance
%
run
MCClassInstanceVariableDefinition class setStamp: 'cwp 7/7/2003 22:59' forMethod: #type.
true
%

category: 'as yet unclassified'
method: MCClassInstanceVariableDefinition
isClassInstanceVariable
	^ true
%
run
MCClassInstanceVariableDefinition setStamp: 'cwp 7/7/2003 23:31' forMethod: #isClassInstanceVariable.
true
%

category: 'as yet unclassified'
classmethod: MCClassVariableDefinition
type
	^ #class
%
run
MCClassVariableDefinition class setStamp: 'cwp 7/7/2003 22:58' forMethod: #type.
true
%

category: 'as yet unclassified'
method: MCClassVariableDefinition
isClassVariable
	^ true
%
run
MCClassVariableDefinition setStamp: 'cwp 7/7/2003 23:32' forMethod: #isClassVariable.
true
%

category: 'as yet unclassified'
method: MCClassVariableDefinition
isOrderDependend
	^false
%
run
MCClassVariableDefinition setStamp: 'bf 8/29/2006 11:41' forMethod: #isOrderDependend.
true
%

category: 'as yet unclassified'
classmethod: MCInstanceVariableDefinition
type
	^ #instance
%
run
MCInstanceVariableDefinition class setStamp: 'cwp 7/7/2003 22:59' forMethod: #type.
true
%

category: 'as yet unclassified'
method: MCInstanceVariableDefinition
isInstanceVariable
	^ true
%
run
MCInstanceVariableDefinition setStamp: 'cwp 7/7/2003 23:32' forMethod: #isInstanceVariable.
true
%

category: 'as yet unclassified'
classmethod: MCPoolImportDefinition
type
	^ #pool
%
run
MCPoolImportDefinition class setStamp: 'cwp 7/7/2003 22:59' forMethod: #type.
true
%

category: 'testing'
method: MCPoolImportDefinition
isOrderDependend
	^false
%
run
MCPoolImportDefinition setStamp: 'bf 8/29/2006 11:41' forMethod: #isOrderDependend.
true
%

category: 'testing'
method: MCPoolImportDefinition
isPoolImport
	^ true
%
run
MCPoolImportDefinition setStamp: 'cwp 7/7/2003 23:51' forMethod: #isPoolImport.
true
%

category: 'as yet unclassified'
classmethod: MCVariableDefinition
name: aString
	^ self new name: aString
	
%
run
MCVariableDefinition class setStamp: 'cwp 7/7/2003 23:18' forMethod: #name:.
true
%

category: 'comparing'
method: MCVariableDefinition
= other
	^ (self species = other species)
		and: [self name = other name]
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:02' forMethod: #=.
true
%

category: 'comparing'
method: MCVariableDefinition
hash
	^ name hash
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:02' forMethod: #hash.
true
%

category: 'testing'
method: MCVariableDefinition
isClassInstanceVariable
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:31' forMethod: #isClassInstanceVariable.
true
%

category: 'testing'
method: MCVariableDefinition
isClassInstanceVariableDefinition
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:08' forMethod: #isClassInstanceVariableDefinition.
true
%

category: 'testing'
method: MCVariableDefinition
isClassVariable
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:30' forMethod: #isClassVariable.
true
%

category: 'testing'
method: MCVariableDefinition
isInstanceVariable
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:31' forMethod: #isInstanceVariable.
true
%

category: 'testing'
method: MCVariableDefinition
isInstanceVariableDefinition
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:10' forMethod: #isInstanceVariableDefinition.
true
%

category: 'testing'
method: MCVariableDefinition
isOrderDependend
	^true
%
run
MCVariableDefinition setStamp: 'bf 8/29/2006 11:41' forMethod: #isOrderDependend.
true
%

category: 'testing'
method: MCVariableDefinition
isPoolImport
	^ false
%
run
MCVariableDefinition setStamp: 'cwp 7/7/2003 23:51' forMethod: #isPoolImport.
true
%

category: 'accessing'
method: MCVariableDefinition
name
	^ name
%
run
MCVariableDefinition setStamp: 'cwp 11/25/2002 05:57' forMethod: #name.
true
%

category: 'accessing'
method: MCVariableDefinition
name: aString
	name := aString
%
run
MCVariableDefinition setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #name:.
true
%

category: 'as yet unclassified'
method: MCVariableDefinition
printOn: aStream
	super printOn: aStream.
	aStream nextPut: $(; nextPutAll: self name; nextPut: $)
%
run
MCVariableDefinition setStamp: 'nk 7/24/2003 14:56' forMethod: #printOn:.
true
%

category: 'name utilities'
classmethod: MCDiffyVersion
baseNameFrom: diffName
	| baseId verName |
	baseId := (diffName copyAfter: $() copyUpTo: $).
	baseId ifEmpty: [^baseId].
	(baseId beginsWith: '@')
		ifTrue: [^baseId copyAfter: $@].
	verName := self verNameFrom: diffName.
	^(baseId includes: $.)
		ifTrue: [(verName copyUpToLast: $-), '-', baseId]
		ifFalse: [(verName copyUpToLast: $.), '.', baseId]

%
run
MCDiffyVersion class setStamp: 'bf 5/30/2005 18:45' forMethod: #baseNameFrom:.
true
%

category: 'name utilities'
classmethod: MCDiffyVersion
canonicalNameFor: aFileName
	^(self nameForVer: (self verNameFrom: aFileName)
		base: (self baseNameFrom: aFileName))
			, '.', MCMcdReader extension

%
run
MCDiffyVersion class setStamp: 'bf 5/30/2005 18:58' forMethod: #canonicalNameFor:.
true
%

category: 'name utilities'
classmethod: MCDiffyVersion
nameForVer: versionName base: baseName
	| baseId |
	baseId := (versionName copyUpToLast: $.) = (baseName copyUpToLast: $.)
		ifTrue: [baseName copyAfterLast: $.]
		ifFalse: [(versionName copyUpToLast: $-) = (baseName copyUpToLast: $-)
			ifTrue: [baseName copyAfterLast: $-]
			ifFalse: ['@', baseName]].
	^ versionName, '(', baseId, ')'
%
run
MCDiffyVersion class setStamp: 'bf 5/30/2005 17:39' forMethod: #nameForVer:base:.
true
%

category: 'instance creation'
classmethod: MCDiffyVersion
package: aPackage info: aVersionInfo dependencies: aCollection baseInfo: baseVersionInfo patch:
aPatch
	^ self basicNew initializeWithPackage: aPackage info: aVersionInfo dependencies: aCollection baseInfo: baseVersionInfo patch:
aPatch
%
run
MCDiffyVersion class setStamp: 'avi 2/13/2004 23:07' forMethod: #package:info:dependencies:baseInfo:patch:.
true
%

category: 'instance creation'
classmethod: MCDiffyVersion
package: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: aCollection baseVersion: aVersion
	^ self 
		package: aPackage
		info: aVersionInfo
		dependencies: aCollection
		baseInfo: aVersion info
		patch: (aSnapshot patchRelativeToBase: aVersion snapshot)
%
run
MCDiffyVersion class setStamp: 'avi 2/13/2004 23:06' forMethod: #package:info:snapshot:dependencies:baseVersion:.
true
%

category: 'name utilities'
classmethod: MCDiffyVersion
verNameFrom: diffName
	^diffName copyUpTo: $(
%
run
MCDiffyVersion class setStamp: 'bf 5/30/2005 18:19' forMethod: #verNameFrom:.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
baseInfo
	^ base
%
run
MCDiffyVersion setStamp: 'avi 2/13/2004 23:17' forMethod: #baseInfo.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
baseSnapshot
	^ (self workingCopy repositoryGroup versionWithInfo: base) snapshot
%
run
MCDiffyVersion setStamp: 'avi 2/13/2004 23:39' forMethod: #baseSnapshot.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
canOptimizeLoading
	"Answer wether I can provide a patch for the working copy without the usual diff pass"
	^ package hasWorkingCopy
		and: [package workingCopy modified not
			and: [package workingCopy ancestors includes: self baseInfo]]
%
run
MCDiffyVersion setStamp: 'bf 5/23/2005 15:42' forMethod: #canOptimizeLoading.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
fileName
	^ (self class nameForVer: info name base: base name), '.', self writerClass extension
%
run
MCDiffyVersion setStamp: 'bf 5/30/2005 17:39' forMethod: #fileName.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
initializeWithPackage: aPackage info: aVersionInfo dependencies: aCollection baseInfo: baseVersionInfo patch: aPatch
	patch := aPatch.
	base := baseVersionInfo.
	super initializeWithPackage: aPackage info: aVersionInfo snapshot: nil dependencies: aCollection.

%
run
MCDiffyVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithPackage:info:dependencies:baseInfo:patch:.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
isDiffy
	^ true
%
run
MCDiffyVersion setStamp: 'avi 2/13/2004 23:24' forMethod: #isDiffy.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
patch
	^ patch
%
run
MCDiffyVersion setStamp: 'avi 2/13/2004 23:17' forMethod: #patch.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
snapshot
	^ snapshot ifNil: [snapshot := MCPatcher apply: patch to: self baseSnapshot]
%
run
MCDiffyVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #snapshot.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
summary
	^ '(Diff against ', self baseInfo name, ')', String cr, super summary
%
run
MCDiffyVersion setStamp: 'avi 2/19/2004 22:03' forMethod: #summary.
true
%

category: 'as yet unclassified'
method: MCDiffyVersion
writerClass
	^ MCMcdWriter 
%
run
MCDiffyVersion setStamp: 'avi 2/13/2004 23:17' forMethod: #writerClass.
true
%

category: 'instance creation'
classmethod: MCVersion
package: aPackage
	^ self package: aPackage info: MCVersionInfo new
%
run
MCVersion class setStamp: 'ab 7/7/2003 16:13' forMethod: #package:.
true
%

category: 'instance creation'
classmethod: MCVersion
package: aPackage info: aVersionInfo
	^ self package: aPackage info: aVersionInfo snapshot: aPackage snapshot
%
run
MCVersion class setStamp: 'ab 7/7/2003 16:13' forMethod: #package:info:.
true
%

category: 'instance creation'
classmethod: MCVersion
package: aPackage info: aVersionInfo snapshot: aSnapshot
	^ self package: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: #()
%
run
MCVersion class setStamp: 'cwp 11/7/2004 13:02' forMethod: #package:info:snapshot:.
true
%

category: 'instance creation'
classmethod: MCVersion
package: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: aCollection
	^ self new initializeWithPackage: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: aCollection
%
run
MCVersion class setStamp: 'avi 1/19/2004 13:11' forMethod: #package:info:snapshot:dependencies:.
true
%

category: 'actions'
method: MCVersion
addToCache
	MCPlatform current cacheRepository storeVersion: self
%
run
MCVersion setStamp: 'DaleHenrichs 10/20/2010 12:33' forMethod: #addToCache.
true
%

category: 'actions'
method: MCVersion
adopt
	self workingCopy adopt: self
%
run
MCVersion setStamp: 'avi 2/12/2004 19:37' forMethod: #adopt.
true
%

category: 'enumerating'
method: MCVersion
allAvailableDependenciesDo: aBlock
	
	self dependencies do:
		[:ea |
		[ | version |version := ea resolve.
		version allAvailableDependenciesDo: aBlock.
		aBlock value: version]
			on: Error do: []]
%
run
MCVersion setStamp: 'nice 1/5/2010 15:59' forMethod: #allAvailableDependenciesDo:.
true
%

category: 'enumerating'
method: MCVersion
allDependenciesDo: aBlock
	self allDependenciesDo: aBlock ifUnresolved: [:ignored | true]
%
run
MCVersion setStamp: 'cwp 11/7/2004 11:58' forMethod: #allDependenciesDo:.
true
%

category: 'enumerating'
method: MCVersion
allDependenciesDo: aBlock ifUnresolved: failBlock
	| dict |
	dict := Dictionary new.
	self allDependenciesNotIn: dict do: aBlock ifUnresolved: failBlock
%
run
MCVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #allDependenciesDo:ifUnresolved:.
true
%

category: 'enumerating'
method: MCVersion
allDependenciesNotIn: aDictionary do: aBlock ifUnresolved: failBlock
	
	self dependencies do: 
		[:ea | | version | 
		version := aDictionary at: ea ifAbsent: [ea resolve].
		version 
			ifNil: [failBlock value: ea]
			ifNotNil: [(aDictionary includes: version) ifFalse:
						[aDictionary at: ea put: version.
						version 
							allDependenciesNotIn: aDictionary 
							do: aBlock
							ifUnresolved: failBlock.
						aBlock value: version]]]
%
run
MCVersion setStamp: 'nice 1/5/2010 15:59' forMethod: #allDependenciesNotIn:do:ifUnresolved:.
true
%

category: 'converting'
method: MCVersion
asDiffAgainst: aVersion
	aVersion info = self info ifTrue: [self error: 'Cannot diff against self!'].
	^ MCDiffyVersion
		package: self package
		info: self info
		snapshot: self snapshot
		dependencies: self dependencies
		baseVersion: aVersion
%
run
MCVersion setStamp: 'avi 2/19/2004 21:00' forMethod: #asDiffAgainst:.
true
%

category: 'testing'
method: MCVersion
canOptimizeLoading
	"Answer wether I can provide a patch for the working copy without the usual diff pass"
	^false
%
run
MCVersion setStamp: 'bf 5/23/2005 15:43' forMethod: #canOptimizeLoading.
true
%

category: 'accessing'
method: MCVersion
changes
	^ self snapshot patchRelativeToBase: package snapshot
%
run
MCVersion setStamp: 'avi 2/13/2004 22:42' forMethod: #changes.
true
%

category: 'accessing'
method: MCVersion
dependencies
	^ dependencies ifNil: [#()]
%
run
MCVersion setStamp: 'avi 1/22/2004 00:24' forMethod: #dependencies.
true
%

category: 'accessing'
method: MCVersion
fileName
	^ info name, '.', self writerClass extension
%
run
MCVersion setStamp: 'avi 1/22/2004 12:44' forMethod: #fileName.
true
%

category: 'actions'
method: MCVersion
fileOutOn: aStream
	self writerClass fileOut: self on: aStream
%
run
MCVersion setStamp: 'avi 1/22/2004 12:44' forMethod: #fileOutOn:.
true
%

category: 'accessing'
method: MCVersion
info
	^ info
%
run
MCVersion setStamp: 'ab 7/7/2003 14:28' forMethod: #info.
true
%

category: 'initialization'
method: MCVersion
initializeWithPackage: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: aCollection
	package := aPackage.
	info := aVersionInfo.
	snapshot := aSnapshot.
	dependencies := aCollection.
	self addToCache.
%
run
MCVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithPackage:info:snapshot:dependencies:.
true
%

category: 'testing'
method: MCVersion
isCacheable
	^true
%
run
MCVersion setStamp: 'bf 3/22/2005 23:00' forMethod: #isCacheable.
true
%

category: 'testing'
method: MCVersion
isDiffy
	^ false
%
run
MCVersion setStamp: 'avi 2/13/2004 23:24' forMethod: #isDiffy.
true
%

category: 'actions'
method: MCVersion
load
	MCVersionLoader loadVersion: self
%
run
MCVersion setStamp: 'avi 1/24/2004 20:13' forMethod: #load.
true
%

category: 'actions'
method: MCVersion
merge
	MCVersionMerger mergeVersion: self
%
run
MCVersion setStamp: 'abc 2/13/2004 15:58' forMethod: #merge.
true
%

category: 'accessing'
method: MCVersion
package
	^ package
%
run
MCVersion setStamp: 'ab 7/7/2003 14:19' forMethod: #package.
true
%

category: 'printing'
method: MCVersion
printOn: aStream
	super printOn: aStream.
	aStream nextPut: $(.
	aStream nextPutAll: self info name.
	aStream nextPut: $).
%
run
MCVersion setStamp: 'nk 3/8/2004 23:54' forMethod: #printOn:.
true
%

category: 'initialization'
method: MCVersion
setPackage: aPackage info: aVersionInfo snapshot: aSnapshot dependencies: aCollection
	package := aPackage.
	info := aVersionInfo.
	snapshot := aSnapshot.
	dependencies := aCollection
%
run
MCVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #setPackage:info:snapshot:dependencies:.
true
%

category: 'accessing'
method: MCVersion
snapshot
	^ snapshot
%
run
MCVersion setStamp: 'ab 7/7/2003 14:10' forMethod: #snapshot.
true
%

category: 'accessing'
method: MCVersion
summary
	^ String streamContents:
		[:s |
		s nextPutAll: info summaryHeader.
		(dependencies isNil or: [dependencies isEmpty]) ifFalse:
			[s cr; nextPutAll: 'Dependencies: '.
			dependencies
				do: [:ea | s nextPutAll: ea versionInfo name]
				separatedBy: [s nextPutAll: ', ']].
		s cr; cr; nextPutAll: info message]
%
run
MCVersion setStamp: 'adrian_lienhard 1/7/2009 17:32' forMethod: #summary.
true
%

category: 'enumerating'
method: MCVersion
withAllDependenciesDo: aBlock
	self allDependenciesDo: aBlock ifUnresolved: [:ignored | ].
	aBlock value: self
%
run
MCVersion setStamp: 'DaleHenrichs 9/28/2010 11:02' forMethod: #withAllDependenciesDo:.
true
%

category: 'enumerating'
method: MCVersion
withAllDependenciesDo: aBlock ifUnresolved: failBlock
	| dict |
	dict := Dictionary new.
	self allDependenciesNotIn: dict do: aBlock ifUnresolved: failBlock.
	aBlock value: self
%
run
MCVersion setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #withAllDependenciesDo:ifUnresolved:.
true
%

category: 'accessing'
method: MCVersion
workingCopy
	^ package workingCopy
%
run
MCVersion setStamp: 'avi 2/12/2004 19:38' forMethod: #workingCopy.
true
%

category: 'accessing'
method: MCVersion
writerClass
	^ MCMczWriter 
%
run
MCVersion setStamp: 'avi 1/22/2004 12:44' forMethod: #writerClass.
true
%

category: 'as yet unclassified'
classmethod: MCVersionDependency
package: aPackage info: aVersionInfo
	^ self basicNew initializeWithPackage: aPackage info: aVersionInfo
%
run
MCVersionDependency class setStamp: 'avi 1/19/2004 13:13' forMethod: #package:info:.
true
%

category: 'comparing'
method: MCVersionDependency
= other
	^ other species = self species
		and: [other versionInfo = versionInfo
				and: [other package = package]]
%
run
MCVersionDependency setStamp: 'avi 1/19/2004 16:12' forMethod: #=.
true
%

category: 'comparing'
method: MCVersionDependency
hash
	^ versionInfo hash
%
run
MCVersionDependency setStamp: 'avi 1/19/2004 16:06' forMethod: #hash.
true
%

category: 'initialization'
method: MCVersionDependency
initializeWithPackage: aPackage info: aVersionInfo
	package := aPackage.
	versionInfo := aVersionInfo
%
run
MCVersionDependency setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #initializeWithPackage:info:.
true
%

category: 'testing'
method: MCVersionDependency
isCurrent
	^ package hasWorkingCopy
		and: [self isFulfilled
			and: [package workingCopy modified not]]
%
run
MCVersionDependency setStamp: 'bf 4/19/2005 16:29' forMethod: #isCurrent.
true
%

category: 'testing'
method: MCVersionDependency
isFulfilled
	^package hasWorkingCopy
		and: [self isFulfilledBy: package workingCopy ancestry]
%
run
MCVersionDependency setStamp: 'bf 4/19/2005 16:29' forMethod: #isFulfilled.
true
%

category: 'testing'
method: MCVersionDependency
isFulfilledBy: anAncestry
	^ anAncestry ancestors includes: versionInfo
%
run
MCVersionDependency setStamp: 'avi 3/4/2004 00:34' forMethod: #isFulfilledBy:.
true
%

category: 'testing'
method: MCVersionDependency
isFulfilledByAncestors
	^ package hasWorkingCopy
		and: [self isFulfilledByAncestorsOf: package workingCopy ancestry]
%
run
MCVersionDependency setStamp: 'bf 4/19/2005 16:29' forMethod: #isFulfilledByAncestors.
true
%

category: 'testing'
method: MCVersionDependency
isFulfilledByAncestorsOf: anAncestry
	^ anAncestry hasAncestor: versionInfo
%
run
MCVersionDependency setStamp: 'nk 7/13/2004 08:45' forMethod: #isFulfilledByAncestorsOf:.
true
%

category: 'testing'
method: MCVersionDependency
isOlder
	"Answer true if I represent an older version of a package that is loaded."
	^ package hasWorkingCopy
		and: [self isFulfilled not
			and: [ self isFulfilledByAncestors
				and: [package workingCopy modified not]]]
%
run
MCVersionDependency setStamp: 'bf 4/19/2005 16:29' forMethod: #isOlder.
true
%

category: 'accessing'
method: MCVersionDependency
package
	^ package
%
run
MCVersionDependency setStamp: 'avi 1/19/2004 15:40' forMethod: #package.
true
%

category: 'accessing'
method: MCVersionDependency
repositoryGroup
	^ self package workingCopy repositoryGroup
%
run
MCVersionDependency setStamp: 'avi 2/12/2004 19:38' forMethod: #repositoryGroup.
true
%

category: 'resolving'
method: MCVersionDependency
resolve
	^ self repositoryGroup
		versionWithInfo: versionInfo
		ifNone: [ MCRepositoryGroup default versionWithInfo: versionInfo ifNone: []]
%
run
MCVersionDependency setStamp: 'nk 6/13/2004 19:21' forMethod: #resolve.
true
%

category: 'accessing'
method: MCVersionDependency
versionInfo
	^ versionInfo
%
run
MCVersionDependency setStamp: 'avi 1/19/2004 15:40' forMethod: #versionInfo.
true
%

category: 'as yet unclassified'
classmethod: MCVersionLoader
loadVersion: aVersion
	self new
		addVersion: aVersion;
		load
%
run
MCVersionLoader class setStamp: 'avi 1/24/2004 20:06' forMethod: #loadVersion:.
true
%

category: 'instance creation'
classmethod: MCVersionLoader
new

	^ self basicNew initialize

%
run
MCVersionLoader class setStamp: 'DaleHenrichs 9/29/2010 16:42' forMethod: #new.
true
%

category: 'loading'
method: MCVersionLoader
addDependency: aDependency
	| dep |
	aDependency isCurrent ifTrue: [^ self].
	(self depAgeIsOk: aDependency) ifFalse: [^ self].
	dep := aDependency resolve.
	dep
		ifNil: [self confirmMissingDependency: aDependency]
		ifNotNil: [(versions includes: dep) ifFalse: [self addVersion: dep]]
%
run
MCVersionLoader setStamp: 'cwp 11/7/2004 17:06' forMethod: #addDependency:.
true
%

category: 'loading'
method: MCVersionLoader
addVersion: aVersion
	aVersion dependencies do: [ :ea | self addDependency: ea].
	versions add: aVersion.

%
run
MCVersionLoader setStamp: 'cwp 11/7/2004 17:04' forMethod: #addVersion:.
true
%

category: 'checking'
method: MCVersionLoader
checkForModifications
	| modifications |
	modifications := versions select: [:ea | ea package workingCopy modified].
	modifications isEmpty ifFalse: [self warnAboutLosingChangesTo: modifications].
%
run
MCVersionLoader setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #checkForModifications.
true
%

category: 'checking'
method: MCVersionLoader
checkIfDepIsOlder: aDependency
	^ aDependency isOlder not 
		or: [self confirm: 'load older dependency ', aDependency versionInfo name , '?']
%
run
MCVersionLoader setStamp: 'cwp 11/7/2004 17:00' forMethod: #checkIfDepIsOlder:.
true
%

category: 'checking'
method: MCVersionLoader
confirmMissingDependency: aDependency
	| name |
	name := aDependency versionInfo name.
	(self confirm: 'Can''t find dependency ', name, '. ignore?')
		ifFalse: [self error: 'Can''t find dependency ', name]
%
run
MCVersionLoader setStamp: 'cwp 11/7/2004 17:06' forMethod: #confirmMissingDependency:.
true
%

category: 'checking'
method: MCVersionLoader
depAgeIsOk: aDependency
	^ aDependency isOlder not 
		or: [self confirm: 'load older dependency ', aDependency versionInfo name , '?']
%
run
MCVersionLoader setStamp: 'cwp 11/7/2004 17:02' forMethod: #depAgeIsOk:.
true
%

category: 'initialization'
method: MCVersionLoader
initialize

	versions := OrderedCollection new
%
run
MCVersionLoader setStamp: 'DaleHenrichs 9/29/2010 16:41' forMethod: #initialize.
true
%

category: 'loading'
method: MCVersionLoader
load
	self loadWithNameLike: versions first info name.

%
run
MCVersionLoader setStamp: 'bf 3/16/2006 19:03' forMethod: #load.
true
%

category: 'loading'
method: MCVersionLoader
loadWithNameLike: aString
	| loader |
	self checkForModifications.
	loader := versions size > 1
		ifTrue: [MCMultiPackageLoader new]
		ifFalse: [MCPackageLoader new].
	versions do: [:ea |
		ea canOptimizeLoading
			ifTrue: [ea patch applyTo: loader]
			ifFalse: [loader updatePackage: ea package withSnapshot: ea snapshot]].
	loader loadWithNameLike: aString.
	versions do: [:ea | ea workingCopy loaded: ea]
%
run
MCVersionLoader setStamp: 'bf 3/17/2006 15:38' forMethod: #loadWithNameLike:.
true
%

category: 'checking'
method: MCVersionLoader
warnAboutLosingChangesTo: versionCollection
	self notify: (String streamContents: [:s |
		s nextPutAll: 'You are about to load new versions of the following packages that have unsaved changes in the image.  If you continue, you will lose these changes.'; cr.
		versionCollection do:
			[:ea |
			s cr; space; space; nextPutAll: ea package name]])
%
run
MCVersionLoader setStamp: 'avi 1/24/2004 20:17' forMethod: #warnAboutLosingChangesTo:.
true
%

category: 'as yet unclassified'
classmethod: MCVersionMerger
mergeVersion: aVersion
	self new
		addVersion: aVersion;
		mergeWithNameLike: aVersion info name
%
run
MCVersionMerger class setStamp: 'bf 12/5/2004 12:35' forMethod: #mergeVersion:.
true
%

category: 'instance creation'
classmethod: MCVersionMerger
new

	^ self basicNew initialize

%
run
MCVersionMerger class setStamp: 'DaleHenrichs 9/29/2010 16:42' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCVersionMerger
addVersion: aVersion
	
	records add: (MCMergeRecord version: aVersion).
	aVersion dependencies do:
		[:ea | | dep |
		dep := ea resolve.
		(records anySatisfy: [:r | r version = dep]) ifFalse: [self addVersion: dep]]
%
run
MCVersionMerger setStamp: 'nice 1/5/2010 15:59' forMethod: #addVersion:.
true
%

category: 'as yet unclassified'
method: MCVersionMerger
initialize

	records := OrderedCollection new.
	merger := MCThreeWayMerger new.
%
run
MCVersionMerger setStamp: 'DaleHenrichs 9/29/2010 16:42' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCVersionMerger
merge
	records do: [:ea | merger addBaseSnapshot: ea packageSnapshot].
	records do: [:ea | merger applyPatch: ea mergePatch].
	self resolveConflicts ifTrue:
		[merger load.
		records do: [:ea | ea updateWorkingCopy]].
%
run
MCVersionMerger setStamp: 'abc 2/13/2004 17:15' forMethod: #merge.
true
%

category: 'as yet unclassified'
method: MCVersionMerger
mergeWithNameLike: baseName
	records do: [:ea | merger addBaseSnapshot: ea packageSnapshot].
	records do: [:ea | merger applyPatch: ea mergePatch].
	self resolveConflicts ifTrue:
		[merger loadWithNameLike: baseName.
		records do: [:ea | ea updateWorkingCopy]].
%
run
MCVersionMerger setStamp: 'bf 12/5/2004 12:32' forMethod: #mergeWithNameLike:.
true
%

category: 'as yet unclassified'
method: MCVersionMerger
resolveConflicts
	(records allSatisfy: [:ea | ea isAncestorMerge]) ifTrue: [MCNoChangesException signal. ^ false].
	^ ((MCMergeResolutionRequest new merger: merger)
		signal: 'Merging ', records first version info name) = true
%
run
MCVersionMerger setStamp: 'bf 4/26/2005 14:29' forMethod: #resolveConflicts.
true
%

category: 'as yet unclassified'
method: MCFilteredVersionSorter
addVersionInfo: aVersionInfo
	(aVersionInfo hasAncestor: target)
		ifTrue: [super addVersionInfo: aVersionInfo]

%
run
MCFilteredVersionSorter setStamp: 'bf 5/28/2005 01:14' forMethod: #addVersionInfo:.
true
%

category: 'as yet unclassified'
method: MCFilteredVersionSorter
processVersionInfo: aVersionInfo
	| success |
	aVersionInfo = target ifTrue: [^ true].
	(aVersionInfo hasAncestor: target) ifFalse: [^false].
	self pushLayer.
	success := (self knownAncestorsOf: aVersionInfo) anySatisfy:
				[:ea | self processVersionInfo: ea].
	self popLayer.
	success ifTrue: [self addToCurrentLayer: aVersionInfo].
	^ success	
%
run
MCFilteredVersionSorter setStamp: 'MarianoMartinezPeck 12/25/2009 23:08' forMethod: #processVersionInfo:.
true
%

category: 'as yet unclassified'
method: MCFilteredVersionSorter
target: aVersionInfo
	target := aVersionInfo
%
run
MCFilteredVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #target:.
true
%

category: 'instance creation'
classmethod: MCVersionSorter
new

	^ self basicNew initialize

%
run
MCVersionSorter class setStamp: 'DaleHenrichs 9/29/2010 16:27' forMethod: #new.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
addAllAncestorsOf: aVersionInfo to: aSet
	| queue |
	(aSet includes: aVersionInfo)
		ifTrue: [ ^ self ].
	aSet add: aVersionInfo.
	queue := OrderedCollection with: aVersionInfo.
	[ queue isEmpty ]
		whileFalse: [ 
			| vi |
			vi := queue removeFirst.
			(self knownAncestorsOf: vi)
				do: [ :ea | 
					(aSet includes: ea)
						ifFalse: [ 
							aSet add: ea.
							queue addLast: ea ] ] ]
%
run
MCVersionSorter setStamp: 'DaleHenrichs 9/30/2010 15:24' forMethod: #addAllAncestorsOf:to:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
addAllVersionInfos: aCollection
	aCollection do: [:ea | self addVersionInfo: ea]
%
run
MCVersionSorter setStamp: 'avi 8/31/2003 21:30' forMethod: #addAllVersionInfos:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
addToCurrentLayer: aVersionInfo
	| layer |
	layer := layers at: depthIndex.
	(layer includes: aVersionInfo) ifFalse:
		[depths at: aVersionInfo ifPresent:
			[:i |
			i < depthIndex
				ifTrue: [(layers at: i) remove: aVersionInfo]
				ifFalse: [^ false]].
		layer add: aVersionInfo.
		depths at: aVersionInfo put: depthIndex.
		^ true].
	^ false 
%
run
MCVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addToCurrentLayer:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
addVersionInfo: aVersionInfo
	roots add: aVersionInfo.
	self registerStepChildrenOf: aVersionInfo seen: Set new
%
run
MCVersionSorter setStamp: 'avi 9/11/2004 10:49' forMethod: #addVersionInfo:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
allAncestorsOf: aVersionInfo
	| all |
	all := Set new.
	self addAllAncestorsOf: aVersionInfo to: all.
	^ all
%
run
MCVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #allAncestorsOf:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
initialize
	stepparents := Dictionary new.
	roots := OrderedCollection new.
%
run
MCVersionSorter setStamp: 'DaleHenrichs 9/29/2010 16:24' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
knownAncestorsOf: aVersionInfo
	^ aVersionInfo ancestors, (self stepParentsOf: aVersionInfo) asArray
%
run
MCVersionSorter setStamp: 'avi 9/11/2004 14:37' forMethod: #knownAncestorsOf:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
layers
	^ layers
%
run
MCVersionSorter setStamp: 'ab 8/17/2003 15:53' forMethod: #layers.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
popLayer
	depthIndex := depthIndex - 1
%
run
MCVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #popLayer.
true
%

category: 'private'
method: MCVersionSorter
processStackEntry: action for: queue
	| versionInfo |
	action == #beginAncestors
		ifTrue: [ ^ self pushLayer ].
	action == #endAncestors
		ifTrue: [ ^ self popLayer ].
	versionInfo := action.
	(self addToCurrentLayer: versionInfo)
		ifTrue: [ 
			queue addLast: #endAncestors.
			queue addAll: (self knownAncestorsOf: versionInfo) reverse.
			queue addLast: #beginAncestors ].
	^ self
%
run
MCVersionSorter setStamp: 'DaleHenrichs 9/30/2010 15:23' forMethod: #processStackEntry:for:.
true
%

category: 'private'
method: MCVersionSorter
processVersionInfo: aVersionInfo
	| queue |
	queue := OrderedCollection with: aVersionInfo.
	[ queue isEmpty ] whileFalse: [ self processStackEntry: queue removeLast for: queue ]
%
run
MCVersionSorter setStamp: 'DaleHenrichs 9/30/2010 15:23' forMethod: #processVersionInfo:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
pushLayer
	depthIndex := depthIndex + 1.
	depthIndex > layers size ifTrue: [layers add: OrderedCollection new].
	
%
run
MCVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #pushLayer.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
registerStepChildrenOf: aVersionInfo seen: aSet
	| registerBlock queue |
	registerBlock := [ :vi :q | 
	(aSet includes: vi)
		ifFalse: [ 
			aSet add: vi.
			vi stepChildren do: [ :ea | (self stepParentsOf: ea) add: vi ].
			q addAll: vi ancestors ] ].
	queue := OrderedCollection with: aVersionInfo.
	[ queue isEmpty ] whileFalse: [ registerBlock value: queue removeFirst value: queue ]
%
run
MCVersionSorter setStamp: 'DaleHenrichs 9/30/2010 15:22' forMethod: #registerStepChildrenOf:seen:.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
sortedVersionInfos
	layers := OrderedCollection with: OrderedCollection new.
	depthIndex := 1.
	depths := Dictionary new.
	roots do: [:ea | self processVersionInfo: ea].
	^ layers gather: [:ea | ea]
%
run
MCVersionSorter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #sortedVersionInfos.
true
%

category: 'as yet unclassified'
method: MCVersionSorter
stepParentsOf: aVersionInfo
	^ (stepparents at: aVersionInfo ifAbsentPut: [Set new])
%
run
MCVersionSorter setStamp: 'avi 9/11/2004 10:40' forMethod: #stepParentsOf:.
true
%

category: 'as yet unclassified'
classmethod: MCMcdWriter
readerClass
	^ MCMcdReader
%
run
MCMcdWriter class setStamp: 'avi 2/13/2004 23:09' forMethod: #readerClass.
true
%

category: 'as yet unclassified'
method: MCMcdWriter
writeBaseInfo: aVersionInfo
	| string |
	string := self serializeVersionInfo: aVersionInfo.
	self addString: string at: 'base'.

%
run
MCMcdWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #writeBaseInfo:.
true
%

category: 'as yet unclassified'
method: MCMcdWriter
writeDefinitions: aVersion
	self writeBaseInfo: aVersion baseInfo.
	self writePatch: aVersion patch.
%
run
MCMcdWriter setStamp: 'avi 2/17/2004 01:48' forMethod: #writeDefinitions:.
true
%

category: 'as yet unclassified'
method: MCMcdWriter
writeNewDefinitions: aCollection
	self addString: (self serializeDefinitions: aCollection) at: 'new/source.', self snapshotWriterClass extension.
%
run
MCMcdWriter setStamp: 'avi 2/17/2004 02:07' forMethod: #writeNewDefinitions:.
true
%

category: 'as yet unclassified'
method: MCMcdWriter
writeOldDefinitions: aCollection
	self addString: (self serializeDefinitions: aCollection) at: 'old/source.', self snapshotWriterClass extension.
%
run
MCMcdWriter setStamp: 'avi 2/17/2004 02:07' forMethod: #writeOldDefinitions:.
true
%

category: 'as yet unclassified'
method: MCMcdWriter
writePatch: aPatch
	| old new |
	old := OrderedCollection new.
	new := OrderedCollection new.
	aPatch operations do:
		[:ea |
		ea isRemoval ifTrue: [old add: ea definition].
		ea isAddition ifTrue: [new add: ea definition].
		ea isModification ifTrue: [old add: ea baseDefinition. new add: ea definition]].
	self writeOldDefinitions: old.
	self writeNewDefinitions: new.
	self addString: (self serializeInBinary: aPatch) at: 'patch.bin'.
%
run
MCMcdWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #writePatch:.
true
%

category: 'as yet unclassified'
classmethod: MCMczWriter
fileOut: aVersion on: aStream
	| inst |
	inst := self on: aStream.
	inst writeVersion: aVersion.
	inst flush.
	

%
run
MCMczWriter class setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #fileOut:on:.
true
%

category: 'as yet unclassified'
classmethod: MCMczWriter
readerClass
	^ MCMczReader
%
run
MCMczWriter class setStamp: 'cwp 8/1/2003 12:35' forMethod: #readerClass.
true
%

category: 'as yet unclassified'
classmethod: MCStWriter
extension
    "override to avoid having to port MCStReader to GemStone"

    ^'st'
%

category: 'writing'
method: MCMczWriter
addString: string at: path
	| member |
	member := zip addString: string as: path.
	member desiredCompressionMethod: ZipArchive compressionDeflated 
	
%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #addString:at:.
true
%

category: 'writing'
method: MCMczWriter
flush
	zip writeTo: stream.
	stream close
%
run
MCMczWriter setStamp: 'avi 2/17/2004 02:17' forMethod: #flush.
true
%

category: 'accessing'
method: MCMczWriter
format
	^ '1'
%
run
MCMczWriter setStamp: 'avi 2/17/2004 01:54' forMethod: #format.
true
%

category: 'initializing'
method: MCMczWriter
initialize
	super initialize.
	zip := ZipArchive new.

%
run
MCMczWriter setStamp: 'alain.plantec 5/28/2009 10:03' forMethod: #initialize.
true
%

category: 'serializing'
method: MCMczWriter
serializeDefinitions: aCollection
	| writer s |
	s := RWBinaryOrTextStream on: String new.
	writer := self snapshotWriterClass on: s.
	writer writeDefinitions: aCollection.
	^ s contents
%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #serializeDefinitions:.
true
%

category: 'serializing'
method: MCMczWriter
serializeInBinary: aSnapshot
	| writer s |
	s := RWBinaryOrTextStream on: String new.
	writer := DataStream on: s.
	writer nextPut: aSnapshot.
	^ s contents
%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #serializeInBinary:.
true
%

category: 'serializing'
method: MCMczWriter
serializePackage: aPackage
	^ '(name ''', aPackage name, ''')'
%
run
MCMczWriter setStamp: 'cwp 8/13/2003 01:06' forMethod: #serializePackage:.
true
%

category: 'serializing'
method: MCMczWriter
serializeVersionInfo: aVersionInfo
	infoWriter ifNil: [infoWriter := MCVersionInfoWriter new].
	^ String streamContents:
		[:s |
		infoWriter stream: s.
		infoWriter writeVersionInfo: aVersionInfo]
%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #serializeVersionInfo:.
true
%

category: 'accessing'
method: MCMczWriter
snapshotWriterClass
	^ MCStWriter
%
run
MCMczWriter setStamp: 'avi 2/17/2004 02:07' forMethod: #snapshotWriterClass.
true
%

category: 'visiting'
method: MCMczWriter
writeDefinitions: aVersion
	self writeSnapshot: aVersion snapshot
%
run
MCMczWriter setStamp: 'avi 2/17/2004 01:48' forMethod: #writeDefinitions:.
true
%

category: 'visiting'
method: MCMczWriter
writeFormat
"	self addString: self format at: 'format'."
%
run
MCMczWriter setStamp: 'avi 2/17/2004 01:56' forMethod: #writeFormat.
true
%

category: 'visiting'
method: MCMczWriter
writePackage: aPackage
	self addString: (self serializePackage: aPackage) at: 'package'
%
run
MCMczWriter setStamp: 'avi 2/17/2004 01:48' forMethod: #writePackage:.
true
%

category: 'visiting'
method: MCMczWriter
writeSnapshot: aSnapshot
	self addString: (self serializeDefinitions: aSnapshot definitions) at: 'snapshot/source.', self snapshotWriterClass extension.
	self addString: (self serializeInBinary: aSnapshot) at: 'snapshot.bin'
%
run
MCMczWriter setStamp: 'avi 9/28/2004 14:26' forMethod: #writeSnapshot:.
true
%

category: 'visiting'
method: MCMczWriter
writeVersion: aVersion
	self writeFormat.
	self writePackage: aVersion package.
	self writeVersionInfo: aVersion info.
	self writeDefinitions: aVersion.
	aVersion dependencies do: [:ea | self writeVersionDependency: ea]
%
run
MCMczWriter setStamp: 'avi 9/13/2004 16:49' forMethod: #writeVersion:.
true
%

category: 'visiting'
method: MCMczWriter
writeVersionDependency: aVersionDependency
	| string |
	string := (self serializeVersionInfo: aVersionDependency versionInfo).
	self addString: string at: 'dependencies/', aVersionDependency package name
%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #writeVersionDependency:.
true
%

category: 'visiting'
method: MCMczWriter
writeVersionInfo: aVersionInfo
	| string |
	string := self serializeVersionInfo: aVersionInfo.
	self addString: string at: 'version'.

%
run
MCMczWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #writeVersionInfo:.
true
%

category: 'accessing'
method: MCMczWriter
zip
	^ zip
%
run
MCMczWriter setStamp: 'cwp 8/1/2003 00:06' forMethod: #zip.
true
%

category: 'writing'
method: MCStWriter
chunkContents: aBlock
	stream cr; nextChunkPut: (String streamContents: aBlock); cr
%
run
MCStWriter setStamp: 'cwp 8/2/2003 02:34' forMethod: #chunkContents:.
true
%

category: 'visiting'
method: MCStWriter
visitClassDefinition: definition
	self writeClassDefinition: definition.
	definition hasClassInstanceVariables ifTrue: [self writeMetaclassDefinition: definition].
	definition hasComment ifTrue: [self writeClassComment: definition].
%
run
MCStWriter setStamp: 'cwp 8/2/2003 11:02' forMethod: #visitClassDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitClassTraitDefinition: definition
	self chunkContents: [:s | s
		nextPutAll: definition baseTrait;
		nextPutAll: ' classTrait';
		cr; tab;
		nextPutAll: 'uses: ';
		nextPutAll: (definition classTraitComposition ifNil: ['{}'])]

%
run
MCStWriter setStamp: 'al 10/9/2005 19:52' forMethod: #visitClassTraitDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitMetaclassDefinition: definition
	self writeMetaclassDefinition: definition
%
run
MCStWriter setStamp: 'al 10/9/2005 19:40' forMethod: #visitMetaclassDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitMethodDefinition: definition
	self writeMethodPreamble: definition.
	self writeMethodSource: definition.
	self writeMethodPostscript.
	self writeMethodInitializer: definition.
%
run
MCStWriter setStamp: 'avi 2/17/2004 02:23' forMethod: #visitMethodDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitOrganizationDefinition: defintion
	defintion categories do: [:cat | self writeCategory: cat].

%
run
MCStWriter setStamp: 'cwp 8/2/2003 11:02' forMethod: #visitOrganizationDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitScriptDefinition: definition
	self writeScriptDefinition: definition

%
run
MCStWriter setStamp: 'bf 8/12/2009 21:41' forMethod: #visitScriptDefinition:.
true
%

category: 'visiting'
method: MCStWriter
visitTraitDefinition: definition
	self writeClassDefinition: definition.
	definition hasComment ifTrue: [self writeClassComment: definition].
%
run
MCStWriter setStamp: 'al 10/9/2005 19:40' forMethod: #visitTraitDefinition:.
true
%

category: 'writing'
method: MCStWriter
writeCategory: categoryName
	stream
		nextChunkPut: 'SystemOrganization addCategory: ', categoryName printString;
		cr
%
run
MCStWriter setStamp: 'cwp 8/2/2003 01:46' forMethod: #writeCategory:.
true
%

category: 'writing'
method: MCStWriter
writeClassComment: definition
	stream
		cr;
		nextPut: $!;
		nextPutAll: definition className;
		nextPutAll: ' commentStamp: ';
		nextPutAll: definition commentStamp printString;
		nextPutAll: ' prior: 0!';
		cr;
		nextChunkPut: definition comment;
		cr.
%
run
MCStWriter setStamp: 'DaleHenrichs 10/6/2010 13:09' forMethod: #writeClassComment:.
true
%

category: 'writing'
method: MCStWriter
writeClassDefinition: definition
	self chunkContents: [:s | definition printDefinitionOn: stream]
%
run
MCStWriter setStamp: 'cwp 8/2/2003 02:16' forMethod: #writeClassDefinition:.
true
%

category: 'writing'
method: MCStWriter
writeDefinitions: aCollection
	"initStream is an ugly hack until we have proper init defs"
	initStream := WriteStream on: String new.

	MCPlatform current
		for: (MCDependencySorter sortItems: aCollection)
		do: [:ea | ea accept: self]
		displayingProgress: 'Writing definitions...'.
	
	stream nextPutAll: initStream contents.
%
run
MCStWriter setStamp: 'DaleHenrichs 10/6/2010 12:48' forMethod: #writeDefinitions:.
true
%

category: 'writing'
method: MCStWriter
writeMetaclassDefinition: definition
	self chunkContents: [:str |
		str	nextPutAll: definition className;
			nextPutAll: ' class';
			cr; tab.
			definition hasClassTraitComposition ifTrue: [
				str	nextPutAll: 'uses: ';
					nextPutAll: definition classTraitCompositionString;
					cr; tab].
			str	nextPutAll: 'instanceVariableNames: ''';
				nextPutAll: definition classInstanceVariablesString;
				nextPut: $']
%
run
MCStWriter setStamp: 'al 12/2/2005 15:17' forMethod: #writeMetaclassDefinition:.
true
%

category: 'writing'
method: MCStWriter
writeMethodInitializer: aMethodDefinition
	aMethodDefinition isInitializer ifTrue:
		[initStream nextChunkPut: aMethodDefinition className, ' initialize'; cr]
%
run
MCStWriter setStamp: 'avi 2/17/2004 02:24' forMethod: #writeMethodInitializer:.
true
%

category: 'writing'
method: MCStWriter
writeMethodPostscript
	stream
		space;
		nextPut: $!;
		cr
%
run
MCStWriter setStamp: 'cwp 8/2/2003 12:43' forMethod: #writeMethodPostscript.
true
%

category: 'writing'
method: MCStWriter
writeMethodPreamble: definition
	stream
		cr;
		nextPut: $!;
		nextPutAll: definition fullClassName;
		nextPutAll: ' methodsFor: ';
		nextPutAll: definition category asString printString;
		nextPutAll: ' stamp: ';
		nextPutAll: definition timeStamp asString printString;
		nextPutAll: '!';
		cr
%
run
MCStWriter setStamp: 'avi 9/23/2003 17:42' forMethod: #writeMethodPreamble:.
true
%

category: 'writing'
method: MCStWriter
writeMethodSource: definition
	stream nextChunkPut: definition source
%
run
MCStWriter setStamp: 'cwp 8/4/2003 01:35' forMethod: #writeMethodSource:.
true
%

category: 'writing'
method: MCStWriter
writeScriptDefinition: definition
	stream nextChunkPut: (
		'(PackageInfo named: {1}) {2}: {3}'
		format: {
			"{1}" definition packageName printString.
			"{2}" definition scriptSelector. 
			"{3}" definition script printString
		}); cr
%
run
MCStWriter setStamp: 'bf 8/13/2009 00:21' forMethod: #writeScriptDefinition:.
true
%

category: 'writing'
method: MCStWriter
writeSnapshot: aSnapshot
	self writeDefinitions: aSnapshot definitions
%
run
MCStWriter setStamp: 'avi 2/17/2004 02:25' forMethod: #writeSnapshot:.
true
%

category: 'as yet unclassified'
method: MCVersionInfoWriter
isWritten: aVersionInfo
	^ self written includes: aVersionInfo
%
run
MCVersionInfoWriter setStamp: 'avi 1/22/2004 21:10' forMethod: #isWritten:.
true
%

category: 'as yet unclassified'
method: MCVersionInfoWriter
writeVersionInfo: aVersionInfo
	(self isWritten: aVersionInfo)
		ifTrue: [^ stream nextPutAll: '(id ', aVersionInfo id asString printString, ')'].
	stream nextPut: $(.
	#(name message id date time author) 
		do: [:sel | 
			stream nextPutAll: sel.
			stream nextPut: $ .
			((aVersionInfo perform: sel) ifNil: ['']) asString printOn: stream.
			stream nextPut: $ ].
	stream nextPutAll: 'ancestors ('.
	aVersionInfo ancestors do: [:ea | self writeVersionInfo: ea].
	stream nextPutAll: ') stepChildren ('.
	aVersionInfo stepChildren do: [:ea | self writeVersionInfo: ea].
	stream nextPutAll: '))'.
	self wrote: aVersionInfo
%
run
MCVersionInfoWriter setStamp: 'avi 9/13/2004 16:53' forMethod: #writeVersionInfo:.
true
%

category: 'as yet unclassified'
method: MCVersionInfoWriter
written
	^ written ifNil: [written := Set new]
%
run
MCVersionInfoWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #written.
true
%

category: 'as yet unclassified'
method: MCVersionInfoWriter
wrote: aVersionInfo
	self written add: aVersionInfo
%
run
MCVersionInfoWriter setStamp: 'avi 1/22/2004 21:10' forMethod: #wrote:.
true
%

category: 'accessing'
classmethod: MCWriter
extension
	^ self readerClass extension
%
run
MCWriter class setStamp: 'cwp 8/1/2003 15:00' forMethod: #extension.
true
%

category: 'instance creation'
classmethod: MCWriter
new

	^ self basicNew initialize

%
run
MCWriter class setStamp: 'DaleHenrichs 10/12/2010 13:11' forMethod: #new.
true
%

category: 'writing'
classmethod: MCWriter
on: aStream
	^ self new stream: aStream
%
run
MCWriter class setStamp: 'cwp 8/1/2003 01:16' forMethod: #on:.
true
%

category: 'accessing'
classmethod: MCWriter
readerClass
	^ self subclassResponsibility 
%
run
MCWriter class setStamp: 'cwp 7/28/2003 23:46' forMethod: #readerClass.
true
%

category: 'initialize-release'
method: MCWriter
initialize
%
run
MCWriter setStamp: 'DaleHenrichs 10/12/2010 13:11' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCWriter
stream
	^ stream
%
run
MCWriter setStamp: 'cwp 8/1/2003 01:14' forMethod: #stream.
true
%

category: 'as yet unclassified'
method: MCWriter
stream: aStream
	stream := aStream
%
run
MCWriter setStamp: 'stephaneducasse 2/4/2006 20:47' forMethod: #stream:.
true
%

category: 'accessing'
method: MethodAddition
category
	
	^category
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:04' forMethod: #category.
true
%

category: 'accessing'
method: MethodAddition
changeStamp
	
	^changeStamp
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:15' forMethod: #changeStamp.
true
%

category: 'as yet unclassified'
method: MethodAddition
compile: aString classified: aString1 withStamp: aString2 notifying: aRequestor logSource: aBoolean inClass: aClass

	text := aString.
	category := aString1.
	changeStamp := aString2.
	requestor := aRequestor.
	logSource := aBoolean.
	myClass := aClass
%
run
MethodAddition setStamp: 'rej 2/25/2007 20:36' forMethod: #compile:classified:withStamp:notifying:logSource:inClass:.
true
%

category: 'accessing'
method: MethodAddition
compiledMethod
	
	^compiledMethod
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:51' forMethod: #compiledMethod.
true
%

category: 'accessing'
method: MethodAddition
compiledMethod: aCompiledMethod

	compiledMethod := aCompiledMethod
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:46' forMethod: #compiledMethod:.
true
%

category: 'as yet unclassified'
method: MethodAddition
createCompiledMethod
	MCPlatform current compileMethodAddition: self ifFail: [ ^ nil ]
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:18' forMethod: #createCompiledMethod.
true
%

category: 'as yet unclassified'
method: MethodAddition
installMethod

	MCPlatform current installMethodAddition: self

%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:05' forMethod: #installMethod.
true
%

category: 'accessing'
method: MethodAddition
logSource
	
	^logSource
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:15' forMethod: #logSource.
true
%

category: 'accessing'
method: MethodAddition
methodAndNode: aMethodAndNode

	methodAndNode := aMethodAndNode
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:50' forMethod: #methodAndNode:.
true
%

category: 'accessing'
method: MethodAddition
myClass
	
	^myClass
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:53' forMethod: #myClass.
true
%

category: 'as yet unclassified'
method: MethodAddition
notifyObservers

	MCPlatform current notifyMethodAdditionObservers: self
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:13' forMethod: #notifyObservers.
true
%

category: 'accessing'
method: MethodAddition
priorMethodOrNil
	
	^priorMethodOrNil
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:10' forMethod: #priorMethodOrNil.
true
%

category: 'accessing'
method: MethodAddition
priorMethodOrNil: aPriorMethodOrNil

	priorMethodOrNil := aPriorMethodOrNil
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:46' forMethod: #priorMethodOrNil:.
true
%

category: 'accessing'
method: MethodAddition
requestor
	
	^requestor
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:11' forMethod: #requestor.
true
%

category: 'accessing'
method: MethodAddition
selector
	
	^selector
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:51' forMethod: #selector.
true
%

category: 'accessing'
method: MethodAddition
selector: aSelector

	selector := aSelector
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 15:45' forMethod: #selector:.
true
%

category: 'accessing'
method: MethodAddition
text
	
	^text
%
run
MethodAddition setStamp: 'DaleHenrichs 10/6/2010 16:14' forMethod: #text.
true
%

category: 'instance creation'
classmethod: MethodReference
class: aClass selector: aSelector
	^ self new setStandardClass: aClass methodSymbol: aSelector
%
run
MethodReference class setStamp: 'ab 2/6/2005 16:22' forMethod: #class:selector:.
true
%

category: 'Package'
classmethod: MethodReference
class: aClass selector: aSelector package: aPackage

	^ (self class: aClass selector: aSelector ) package: aPackage ; yourself
%
run
MethodReference class setStamp: 'stephane.ducasse 7/10/2009 09:27' forMethod: #class:selector:package:.
true
%

category: 'comparisons'
method: MethodReference
<= anotherMethodReference

	classSymbol < anotherMethodReference classSymbol ifTrue: [^true].
	classSymbol > anotherMethodReference classSymbol ifTrue: [^false].
	classIsMeta = anotherMethodReference classIsMeta ifFalse: [^classIsMeta not].
	^methodSymbol <= anotherMethodReference methodSymbol

%
run
MethodReference setStamp: 'RAA 5/28/2001 11:56' forMethod: #'<='.
true
%

category: 'comparisons'
method: MethodReference
= anotherMethodReference 
	"Answer whether the receiver and the argument represent the 
	same object."
	^ self species == anotherMethodReference species
		and: [(self classSymbol = anotherMethodReference classSymbol)
				and: [(self classIsMeta = anotherMethodReference classIsMeta)
						and: [self methodSymbol = anotherMethodReference methodSymbol]]]
%
run
MethodReference setStamp: 'StephaneDucasse 4/27/2010 11:46' forMethod: #=.
true
%

category: 'accessing'
method: MethodReference
actualClass
	| actualClass |
	actualClass := MCPlatform current globalNamed: classSymbol ifAbsent: [ ^ nil ].
	classIsMeta
		ifTrue: [ ^ actualClass classSide ].
	^ actualClass
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:11' forMethod: #actualClass.
true
%

category: '*monticello-base'
method: MethodReference
asMethodDefinition
	^ MCMethodDefinition forMethodReference: self
%
run
MethodReference setStamp: 'ab 8/22/2003 17:55' forMethod: #asMethodDefinition.
true
%

category: 'accessing'
method: MethodReference
category
	^ category ifNil: [ category := MCPlatform current categoryOfSelector: methodSymbol for: self actualClass ]
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:27' forMethod: #category.
true
%

category: 'accessing'
method: MethodReference
category: aString
	
	 category := aString
%
run
MethodReference setStamp: 'stephane.ducasse 10/12/2008 20:08' forMethod: #category:.
true
%

category: 'queries'
method: MethodReference
classIsMeta

	^classIsMeta
%
run
MethodReference setStamp: 'RAA 5/28/2001 08:11' forMethod: #classIsMeta.
true
%

category: 'queries'
method: MethodReference
classSymbol

	^classSymbol
%
run
MethodReference setStamp: 'RAA 5/28/2001 08:10' forMethod: #classSymbol.
true
%

category: '*monticello-base'
method: MethodReference
compiledMethod
	^ self actualClass compiledMethodAt: methodSymbol
%
run
MethodReference setStamp: 'ab 8/22/2003 17:58' forMethod: #compiledMethod.
true
%

category: 'comparisons'
method: MethodReference
hash
	"Answer a SmallInteger whose value is related to the receiver's  
	identity."
	^ (self species hash bitXor: self classSymbol hash)
		bitXor: self methodSymbol hash
%
run
MethodReference setStamp: 'dgd 3/8/2003 11:54' forMethod: #hash.
true
%

category: 'queries'
method: MethodReference
isDoIt

	^ (self methodSymbol == #DoIt) or: [self methodSymbol == #DoItIn:].
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:03' forMethod: #isDoIt.
true
%

category: '*monticello-base'
method: MethodReference
isLocalSelector
	^ MCPlatform current includesLocalSelector: self methodSymbol for: self actualClass
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:14' forMethod: #isLocalSelector.
true
%

category: 'queries'
method: MethodReference
isValid
	"Answer whether the receiver represents a current selector or Comment"

	| aClass |
	self isDoIt ifTrue: [^ false].
	(aClass := self actualClass) ifNil: [^ false].
	^ (aClass includesSelector: methodSymbol) or:
		[methodSymbol == #Comment]
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:03' forMethod: #isValid.
true
%

category: 'accessing'
method: MethodReference
methodClass

	^ self actualClass 
%
run
MethodReference setStamp: 'stephane.ducasse 6/2/2009 16:02' forMethod: #methodClass.
true
%

category: 'queries'
method: MethodReference
methodSymbol

	^methodSymbol
%
run
MethodReference setStamp: 'RAA 5/28/2001 08:10' forMethod: #methodSymbol.
true
%

category: 'accessing'
method: MethodReference
package
	"we will have to change that in the future since we will not rely on * convention"
	
	^ package
%
run
MethodReference setStamp: 'stephane.ducasse 7/8/2009 11:26' forMethod: #package.
true
%

category: 'accessing'
method: MethodReference
package: aPackage
	
	package := aPackage
%
run
MethodReference setStamp: 'stephane.ducasse 7/8/2009 11:27' forMethod: #package:.
true
%

category: 'queries'
method: MethodReference
printOn: aStream
	"Print the receiver on a stream"

	super printOn: aStream.
	aStream nextPutAll: ' ', self actualClass name, ' >> #', methodSymbol
%
run
MethodReference setStamp: 'stephane.ducasse 10/27/2008 20:40' forMethod: #printOn:.
true
%

category: 'accessing'
method: MethodReference
selector

	^ methodSymbol
%
run
MethodReference setStamp: 'stephane.ducasse 7/22/2009 11:47' forMethod: #selector.
true
%

category: 'setting'
method: MethodReference
setClass: aClass methodSymbol: methodSym stringVersion: aString 

	classSymbol := aClass theNonMetaClass name.
	classIsMeta := aClass isMeta.
	methodSymbol := methodSym.
	stringVersion := aString.
%
run
MethodReference setStamp: 'RAA 5/28/2001 08:06' forMethod: #setClass:methodSymbol:stringVersion:.
true
%

category: 'setting'
method: MethodReference
setClassAndSelectorIn: csBlock

	^csBlock value: self actualClass value: methodSymbol
%
run
MethodReference setStamp: 'RAA 5/28/2001 07:34' forMethod: #setClassAndSelectorIn:.
true
%

category: 'setting'
method: MethodReference
setClassSymbol: classSym classIsMeta: isMeta methodSymbol: methodSym stringVersion: aString 

	classSymbol := classSym.
	classIsMeta := isMeta.
	methodSymbol := methodSym.
	stringVersion := aString.
%
run
MethodReference setStamp: 'RAA 5/28/2001 06:04' forMethod: #setClassSymbol:classIsMeta:methodSymbol:stringVersion:.
true
%

category: 'setting'
method: MethodReference
setStandardClass: aClass methodSymbol: methodSym

	classSymbol := aClass theNonMetaClass name.
	classIsMeta := aClass isMeta.
	methodSymbol := methodSym.
	stringVersion := aClass name , ' ' , methodSym.
%
run
MethodReference setStamp: 'RAA 5/28/2001 11:34' forMethod: #setStandardClass:methodSymbol:.
true
%

category: '*monticello-base'
method: MethodReference
source
	^ MCPlatform current methodSource: methodSymbol for: self actualClass
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:40' forMethod: #source.
true
%

category: 'queries'
method: MethodReference
sourceString
	^ (self actualClass sourceCodeAt: self methodSymbol) asString
%
run
MethodReference setStamp: 'sr 6/4/2004 01:55' forMethod: #sourceString.
true
%

category: '*monticello-base'
method: MethodReference
timeStamp

	^MCPlatform current timeStampForMethod: self compiledMethod
%
run
MethodReference setStamp: 'DaleHenrichs 9/28/2010 16:35' forMethod: #timeStamp.
true
%

category: 'as yet unclassified'
classmethod: MCDirtyPackageInfo
initialize
	[self new register] on: MessageNotUnderstood do: [:ex | ]
%
run
MCDirtyPackageInfo class setStamp: 'DaleHenrichs 9/28/2010 12:09' forMethod: #initialize.
true
%

category: 'as yet unclassified'
classmethod: MCDirtyPackageInfo
wantsChangeSetLogging
	^ false
%
run
MCDirtyPackageInfo class setStamp: 'cwp 7/21/2003 19:45' forMethod: #wantsChangeSetLogging.
true
%

category: 'as yet unclassified'
method: MCDirtyPackageInfo
classes
	^ Array new: 0.
%
run
MCDirtyPackageInfo setStamp: 'ab 7/7/2003 23:21' forMethod: #classes.
true
%

category: 'as yet unclassified'
method: MCDirtyPackageInfo
methods
	^ MCMockClassA selectors
		select: [:ea | ea beginsWith: 'ordinal']
		thenCollect:
			[:ea | 
				MethodReference new 
					setStandardClass: MCMockClassA 
					methodSymbol: ea].
%
run
MCDirtyPackageInfo setStamp: 'al 2/16/2006 09:53' forMethod: #methods.
true
%

category: 'as yet unclassified'
method: MCDirtyPackageInfo
packageName
	^ 'MCDirtyPackage'
%
run
MCDirtyPackageInfo setStamp: 'ab 7/7/2003 23:21' forMethod: #packageName.
true
%

category: 'as yet unclassified'
classmethod: MCEmptyPackageInfo
initialize
	[self new register] on: MessageNotUnderstood do: [:ex | ]
%
run
MCEmptyPackageInfo class setStamp: 'DaleHenrichs 9/28/2010 12:10' forMethod: #initialize.
true
%

category: 'as yet unclassified'
classmethod: MCEmptyPackageInfo
wantsChangeSetLogging
	^ false
%
run
MCEmptyPackageInfo class setStamp: 'cwp 7/21/2003 19:45' forMethod: #wantsChangeSetLogging.
true
%

category: 'as yet unclassified'
method: MCEmptyPackageInfo
classes
	^ #()
%
run
MCEmptyPackageInfo setStamp: 'ab 7/7/2003 23:21' forMethod: #classes.
true
%

category: 'as yet unclassified'
method: MCEmptyPackageInfo
methods
	^ #()
%
run
MCEmptyPackageInfo setStamp: 'ab 7/7/2003 23:21' forMethod: #methods.
true
%

category: 'as yet unclassified'
method: MCEmptyPackageInfo
packageName
	^ 'MCEmptyPackage'
%
run
MCEmptyPackageInfo setStamp: 'ab 7/7/2003 23:21' forMethod: #packageName.
true
%

category: 'as yet unclassified'
classmethod: MCMockPackageInfo
initialize
	[self new register] on: MessageNotUnderstood do: [:ex | ]
%
run
MCMockPackageInfo class setStamp: 'DaleHenrichs 9/28/2010 12:11' forMethod: #initialize.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
classNames
	^ #(	MCMockClassA
		 	MCMockASubclass
			MCMockClassB
			MCMockClassD
			MCMockClassE
			MCMockClassF
			MCMockClassG
			MCMockClassH
			MCMockClassI
		)
%
run
MCMockPackageInfo setStamp: 'cwp 8/10/2003 01:09' forMethod: #classNames.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
classes
	^ (self classNames select: [ :name | MCPlatform current hasClassNamed: name ])
		collect: [ :name | MCPlatform current globalNamed: name ]
%
run
MCMockPackageInfo setStamp: 'DaleHenrichs 9/28/2010 15:40' forMethod: #classes.
true
%

category: '*Tests-Monticello'
method: MCMockPackageInfo
extensionMethods
	^ Array with: (MethodReference new 
					setStandardClass: MCSnapshotTest 
					methodSymbol: #mockClassExtension)
%
run
MCMockPackageInfo setStamp: 'cwp 8/1/2003 20:25' forMethod: #extensionMethods.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
includesClass: aClass
	^self classes includes: aClass
%
run
MCMockPackageInfo setStamp: 'bf 5/20/2005 16:54' forMethod: #includesClass:.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
includesSystemCategory: categoryName
	^self systemCategories anySatisfy: [:cat | cat sameAs: categoryName]
%
run
MCMockPackageInfo setStamp: 'bf 5/20/2005 17:18' forMethod: #includesSystemCategory:.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
packageName
	^ 'MonticelloMocks'
%
run
MCMockPackageInfo setStamp: 'cwp 8/1/2003 20:31' forMethod: #packageName.
true
%

category: 'as yet unclassified'
method: MCMockPackageInfo
systemCategories
	^ Array with: 'Monticello-Mocks'
%
run
MCMockPackageInfo setStamp: 'cwp 7/31/2003 15:30' forMethod: #systemCategories.
true
%

category: 'packages access'
classmethod: PackageInfo
allPackages
	^PackageOrganizer default packages
%
run
PackageInfo class setStamp: 'Alexandre.Bergel 4/4/2009 09:26' forMethod: #allPackages.
true
%

category: 'compatibility'
classmethod: PackageInfo
default
	^ self allPackages detect: [:ea | ea class = self] ifNone: [self new register]
%
run
PackageInfo class setStamp: 'avi 3/9/2004 16:28' forMethod: #default.
true
%

category: 'testing'
classmethod: PackageInfo
existPackageNamed: aString
	"
	self existPackageNamed: 'PackageInfo'
	self existPackageNamed: 'Zork'
	"
	^ (self allPackages anySatisfy: [:each | each packageName = aString])
			
%
run
PackageInfo class setStamp: 'Alexandre.Bergel 4/4/2009 09:29' forMethod: #existPackageNamed:.
true
%

category: 'initialization'
classmethod: PackageInfo
initialize
	(MCPlatform current allSubclassesOfMonticelloClass: self) do: [:ea | ea new register]
%
run
PackageInfo class setStamp: 'avi 2/18/2004 00:46' forMethod: #initialize.
true
%

category: 'packages access'
classmethod: PackageInfo
named: aString
	^ PackageOrganizer default packageNamed: aString ifAbsent: [(self new packageName: aString) register]
%
run
PackageInfo class setStamp: 'avi 11/12/2003 23:00' forMethod: #named:.
true
%

category: 'packages access'
classmethod: PackageInfo
registerPackageName: aString
	^ PackageOrganizer default registerPackageNamed: aString
%
run
PackageInfo class setStamp: 'avi 11/11/2003 17:19' forMethod: #registerPackageName:.
true
%

category: 'comparing'
method: PackageInfo
= other
	^ other species = self species and: [other packageName = self packageName]
%
run
PackageInfo setStamp: 'avi 10/11/2003 00:09' forMethod: #=.
true
%

category: 'modifying'
method: PackageInfo
addMethod: aMethodReference
	(self includesClass: aMethodReference actualClass)
		ifTrue: [self addCoreMethod: aMethodReference]
		ifFalse: [self addExtensionMethod: aMethodReference]
%
run
PackageInfo setStamp: 'StephaneDucasse 8/18/2009 23:17' forMethod: #addMethod:.
true
%

category: 'modifying'
method: PackageInfo
baseCategoryOfMethod: aMethodReference
	| oldCat oldPrefix tokens | 
	oldCat := aMethodReference category.
	({ 'as yet unclassified'. 'all' } includes: oldCat) ifTrue: [ oldCat := '' ].
	tokens := oldCat findTokens: '*-' keep: '*'.

	"Strip off any old prefixes"
	((tokens at: 1 ifAbsent: [ '' ]) = '*') ifTrue: [
		[ ((tokens at: 1 ifAbsent: [ '' ]) = '*') ]
			whileTrue: [ tokens removeFirst ].
		oldPrefix := tokens removeFirst asLowercase.
		[ (tokens at: 1 ifAbsent: [ '' ]) asLowercase = oldPrefix ]
			whileTrue: [ tokens removeFirst ].
	].

	tokens isEmpty ifTrue: [^ 'as yet unclassified'].
	^ String streamContents:
		[ :s |
		tokens
			do: [ :tok | s nextPutAll: tok ]
			separatedBy: [ s nextPut: $- ]]
%
run
PackageInfo setStamp: 'stephaneducasse 2/4/2006 20:40' forMethod: #baseCategoryOfMethod:.
true
%

category: 'testing'
method: PackageInfo
category: categoryName matches: prefix

	| prefixSize catSize |
	categoryName ifNil: [ ^false ].
	catSize := categoryName size.
	prefixSize := prefix size.
	catSize < prefixSize ifTrue: [ ^false ].
	(categoryName findString: prefix startingAt: 1 caseSensitive: false) = 1
		ifFalse: [ ^false ].
	catSize = prefixSize ifTrue: [ ^true ].
	^(categoryName at: prefixSize + 1) = $-
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 14:25' forMethod: #category:matches:.
true
%

category: 'naming'
method: PackageInfo
categoryName
	
	^self class category
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 14:28' forMethod: #categoryName.
true
%

category: 'listing'
method: PackageInfo
classes
	^ MCPlatform current classesInSystemCategories: self systemCategories
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 14:52' forMethod: #classes.
true
%

category: 'listing'
method: PackageInfo
classesAndMetaClasses
	"Return a Set with all classes and metaclasses belonging to this package"

	| baseClasses result |
	baseClasses := self classes.
	result := (Set new: baseClasses size * 2) 
		addAll: baseClasses;
		yourself.
	baseClasses do: [ :c | 
		result add: c classSide].
	^result

%
run
PackageInfo setStamp: 'ul 11/13/2009 16:29' forMethod: #classesAndMetaClasses.
true
%

category: 'testing'
method: PackageInfo
coreCategoriesForClass: aClass
	^ (MCPlatform current methodCategoriesFor: aClass) select: [:cat | (self isForeignClassExtension: cat) not]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:07' forMethod: #coreCategoriesForClass:.
true
%

category: 'listing'
method: PackageInfo
coreMethods
	^ self classesAndMetaClasses gather: [:class | self coreMethodsForClass: class]
%
run
PackageInfo setStamp: 'ab 11/13/2002 01:23' forMethod: #coreMethods.
true
%

category: 'testing'
method: PackageInfo
coreMethodsForClass: aClass
	| foreignSelectors |
	foreignSelectors := (self foreignExtensionMethodsForClass: aClass) collect: [ :r | r methodSymbol ].
	^ (aClass selectors asSet reject: [ :each | foreignSelectors includes: each ]) asArray
		collect: [ :sel | self referenceForMethod: sel ofClass: aClass ]
%
run
PackageInfo setStamp: 'DaleHenrichs 9/28/2010 15:57' forMethod: #coreMethodsForClass:.
true
%

category: 'testing'
method: PackageInfo
extensionCategoriesForClass: aClass
	^ (MCPlatform current methodCategoriesFor: aClass) select: [:cat | self isYourClassExtension: cat]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:07' forMethod: #extensionCategoriesForClass:.
true
%

category: 'listing'
method: PackageInfo
extensionClasses
	^ self externalBehaviors reject: [:classOrTrait | (self extensionCategoriesForClass: classOrTrait) isEmpty]
%
run
PackageInfo setStamp: 'al 3/1/2006 21:51' forMethod: #extensionClasses.
true
%

category: 'listing'
method: PackageInfo
extensionMethods
	^ self externalBehaviors gather: [:classOrTrait | self extensionMethodsForClass: classOrTrait]
%
run
PackageInfo setStamp: 'al 3/1/2006 21:51' forMethod: #extensionMethods.
true
%

category: 'testing'
method: PackageInfo
extensionMethodsForClass: aClass
	^ (self extensionCategoriesForClass: aClass)
		gather: [:cat | ((MCPlatform current selectorsFor: aClass inCategory: cat) ifNil: [#()])
							collect: [:sel | self referenceForMethod: sel ofClass: aClass]]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:12' forMethod: #extensionMethodsForClass:.
true
%

category: 'testing'
method: PackageInfo
extensionMethodsFromClasses: classes
	^classes
		gather: [:class | self extensionMethodsForClass: class]
%
run
PackageInfo setStamp: 'dvf 10/18/2002 23:22' forMethod: #extensionMethodsFromClasses:.
true
%

category: 'modifying'
method: PackageInfo
externalBehaviors
	^self externalClasses , self externalTraits
%
run
PackageInfo setStamp: 'al 3/1/2006 21:42' forMethod: #externalBehaviors.
true
%

category: 'dependencies'
method: PackageInfo
externalClasses
	| myClasses |
	myClasses := self classesAndMetaClasses.
	^ Array streamContents:
		[:s |
		MCPlatform current allClassesDo:
			[:class |
			(myClasses includes: class) ifFalse: [s nextPut: class]]]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:01' forMethod: #externalClasses.
true
%

category: 'naming'
method: PackageInfo
externalName
	^ self packageName
%
run
PackageInfo setStamp: 'ab 10/16/2002 21:22' forMethod: #externalName.
true
%

category: 'modifying'
method: PackageInfo
externalTraits
	
	
	^ Array streamContents: [:s | | behaviors |
		behaviors := self classesAndMetaClasses.
		MCPlatform current allTraits do: [:trait |
			(behaviors includes: trait) ifFalse: [s nextPut: trait].
			(behaviors includes: trait classSide) ifFalse: [s nextPut: trait classSide]]].			
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:04' forMethod: #externalTraits.
true
%

category: 'listing'
method: PackageInfo
foreignClasses

	^MCPlatform current classesAndMetaclassesInSystemCategories: self foreignSystemCategories

%
run
PackageInfo setStamp: 'DaleHenrichs 10/8/2010 13:29' forMethod: #foreignClasses.
true
%

category: 'testing'
method: PackageInfo
foreignExtensionCategoriesForClass: aClass
	^ (MCPlatform current methodCategoriesFor: aClass) select: [:cat | self isForeignClassExtension: cat]
%
run
PackageInfo setStamp: 'DaleHenrichs 9/28/2010 15:46' forMethod: #foreignExtensionCategoriesForClass:.
true
%

category: 'testing'
method: PackageInfo
foreignExtensionMethodsForClass: aClass
	^ (self foreignExtensionCategoriesForClass: aClass)
		gather: [ :cat | 
			(MCPlatform current selectorsFor: aClass inCategory: cat)
				collect: [ :sel | self referenceForMethod: sel ofClass: aClass ] ]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 14:36' forMethod: #foreignExtensionMethodsForClass:.
true
%

category: 'listing'
method: PackageInfo
foreignSystemCategories
	^ MCPlatform current systemCategories
		reject: [:cat | self includesSystemCategory: cat] 
%
run
PackageInfo setStamp: 'DaleHenrichs 10/8/2010 13:32' forMethod: #foreignSystemCategories.
true
%

category: 'comparing'
method: PackageInfo
hash
	^ packageName hash
%
run
PackageInfo setStamp: 'avi 10/11/2003 14:20' forMethod: #hash.
true
%

category: 'testing'
method: PackageInfo
includesClass: aClass
	^ self includesSystemCategory: aClass theNonMetaClass category
%
run
PackageInfo setStamp: 'ab 11/13/2002 01:23' forMethod: #includesClass:.
true
%

category: 'testing'
method: PackageInfo
includesClassNamed: aClassName
	^ self includesSystemCategory: ((MCPlatform current categoryOfClassNamed: aClassName) ifNil: [^false])
%
run
PackageInfo setStamp: 'DaleHenrichs 10/8/2010 13:35' forMethod: #includesClassNamed:.
true
%

category: 'testing'
method: PackageInfo
includesMethod: aSymbol ofClass: aClass
	aClass ifNil: [^ false].
	^ self
		includesMethodCategory: ((MCPlatform current categoryOfSelector: aSymbol for: aClass)
										ifNil: [' '])
		ofClass: aClass
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:14' forMethod: #includesMethod:ofClass:.
true
%

category: 'testing'
method: PackageInfo
includesMethodCategory: categoryName ofClass: aClass
	^ (self isYourClassExtension: categoryName)
		or: [(self includesClass: aClass)
				and: [(self isForeignClassExtension: categoryName) not]]
%
run
PackageInfo setStamp: 'dvf 9/17/2002 00:18' forMethod: #includesMethodCategory:ofClass:.
true
%

category: 'testing'
method: PackageInfo
includesMethodCategory: categoryName ofClassNamed: aClass
	^ (self isYourClassExtension: categoryName)
		or: [(self includesClassNamed: aClass)
				and: [(self isForeignClassExtension: categoryName) not]]
%
run
PackageInfo setStamp: 'dvf 7/23/2003 14:06' forMethod: #includesMethodCategory:ofClassNamed:.
true
%

category: 'testing'
method: PackageInfo
includesMethodReference: aMethodRef
	^ self includesMethod: aMethodRef methodSymbol ofClass: aMethodRef actualClass
%
run
PackageInfo setStamp: 'ab 11/14/2002 18:06' forMethod: #includesMethodReference:.
true
%

category: 'testing'
method: PackageInfo
includesSystemCategory: categoryName
	^ self category: categoryName matches: self systemCategoryPrefix
%
run
PackageInfo setStamp: 'ab 11/13/2002 01:23' forMethod: #includesSystemCategory:.
true
%

category: 'testing'
method: PackageInfo
isForeignClassExtension: categoryName
	^ categoryName first = $* and: [(self isYourClassExtension: categoryName) not]
%
run
PackageInfo setStamp: 'ab 11/13/2002 01:23' forMethod: #isForeignClassExtension:.
true
%

category: 'testing'
method: PackageInfo
isOverrideCategory: aString
	^ aString endsWith: '-override'
%
run
PackageInfo setStamp: 'StephaneDucasse 2/6/2010 16:41' forMethod: #isOverrideCategory:.
true
%

category: 'testing'
method: PackageInfo
isOverrideMethod: aMethodReference
	^ self isOverrideCategory: aMethodReference category
%
run
PackageInfo setStamp: 'StephaneDucasse 2/6/2010 16:41' forMethod: #isOverrideMethod:.
true
%

category: 'testing'
method: PackageInfo
isOverrideOfYourMethod: aMethodReference
	"Answers true if the argument overrides a method in this package"
	^ (self isYourClassExtension: aMethodReference category) not and:
		[(self changeRecordForOverriddenMethod: aMethodReference) notNil]
%
run
PackageInfo setStamp: 'StephaneDucasse 2/6/2010 16:41' forMethod: #isOverrideOfYourMethod:.
true
%

category: 'testing'
method: PackageInfo
isYourClassExtension: categoryName
	^ categoryName notNil and: [self category: categoryName asLowercase matches: self methodCategoryPrefix]
%
run
PackageInfo setStamp: 'avi 3/10/2004 12:37' forMethod: #isYourClassExtension:.
true
%

category: 'naming'
method: PackageInfo
methodCategoryPrefix
	^ methodCategoryPrefix ifNil: [methodCategoryPrefix := '*', self packageName asLowercase]
%
run
PackageInfo setStamp: 'stephaneducasse 2/4/2006 20:40' forMethod: #methodCategoryPrefix.
true
%

category: 'listing'
method: PackageInfo
methods
	^ (self extensionMethods, self coreMethods) select: [:method |
		method isValid
			and: [method isLocalSelector
			and: [method isDoIt not]]]
%
run
PackageInfo setStamp: 'DaleHenrichs 9/28/2010 16:03' forMethod: #methods.
true
%

category: 'testing'
method: PackageInfo
methodsInCategory: aString ofClass: aClass 
	^Array streamContents: [:stream |
		self methodsInCategory: aString ofClass: aClass 
			do: [:each | stream nextPut: each]]

%
run
PackageInfo setStamp: 'StephaneDucasse 2/6/2010 16:44' forMethod: #methodsInCategory:ofClass:.
true
%

category: 'enumerating'
method: PackageInfo
methodsInCategory: aString ofClass: aClass do: aBlock
	((MCPlatform current selectorsFor: aClass inCategory: aString) ifNil: [^self])
		do: [:sel | aBlock value: (self referenceForMethod: sel ofClass: aClass)]
%
run
PackageInfo setStamp: 'DaleHenrichs 10/7/2010 15:16' forMethod: #methodsInCategory:ofClass:do:.
true
%

category: 'naming'
method: PackageInfo
packageName
	^ packageName ifNil: [packageName := self categoryName]
%
run
PackageInfo setStamp: 'stephaneducasse 2/4/2006 20:40' forMethod: #packageName.
true
%

category: 'naming'
method: PackageInfo
packageName: aString
	packageName := aString
%
run
PackageInfo setStamp: 'stephaneducasse 2/4/2006 20:40' forMethod: #packageName:.
true
%

category: 'printing'
method: PackageInfo
printOn: aStream

	super printOn: aStream.
	aStream nextPutAll: '(',self packageName,')'.
%
run
PackageInfo setStamp: 'stephane.ducasse 8/26/2008 20:43' forMethod: #printOn:.
true
%

category: 'testing'
method: PackageInfo
referenceForMethod: aSymbol ofClass: aClass
	^ MethodReference new setStandardClass: aClass methodSymbol: aSymbol
%
run
PackageInfo setStamp: 'ab 11/13/2002 01:25' forMethod: #referenceForMethod:ofClass:.
true
%

category: 'registering'
method: PackageInfo
register
	PackageOrganizer default registerPackage: self
%
run
PackageInfo setStamp: 'avi 11/12/2003 23:12' forMethod: #register.
true
%

category: 'modifying'
method: PackageInfo
removeMethod: aMethodReference
%
run
PackageInfo setStamp: 'avi 10/11/2003 15:14' forMethod: #removeMethod:.
true
%

category: 'listing'
method: PackageInfo
selectors
	^ self methods collect: [:ea | ea methodSymbol]
%
run
PackageInfo setStamp: 'ab 11/14/2002 18:39' forMethod: #selectors.
true
%

category: 'listing'
method: PackageInfo
systemCategories
	^ MCPlatform current systemCategories select: [:cat | self includesSystemCategory: cat]
%
run
PackageInfo setStamp: 'DaleHenrichs 9/29/2010 15:19' forMethod: #systemCategories.
true
%

category: 'naming'
method: PackageInfo
systemCategoryPrefix
	^ self packageName
%
run
PackageInfo setStamp: 'ab 10/28/2002 10:38' forMethod: #systemCategoryPrefix.
true
%

category: 'as yet unclassified'
classmethod: PackageOrganizer
default
        | dict defaultVal |
        dict := SessionTemps current at: #DEFAULT_FOR_PackageOrganizer otherwise: nil.
        dict == nil
                ifTrue: [
                        dict := Dictionary new.
                        SessionTemps current at: #DEFAULT_FOR_PackageOrganizer put: dict].
        ^dict 
            at: self name 
            ifAbsent: [
                defaultVal := self new.
                dict at: self name put: defaultVal.
                defaultVal ]
%
run
PackageOrganizer class setStamp: 'stephaneducasse 2/4/2006 20:40' forMethod: #default.
true
%

category: 'as yet unclassified'
classmethod: PackageOrganizer
new
	^ self basicNew initialize
%
run
PackageOrganizer class setStamp: 'avi 10/13/2003 15:25' forMethod: #new.
true
%

category: 'initializing'
method: PackageOrganizer
initialize
	packages := Dictionary new
%
run
PackageOrganizer setStamp: 'DaleHenrichs 9/28/2010 12:35' forMethod: #initialize.
true
%

category: 'private'
method: PackageOrganizer
mostSpecificPackageIn: aCollection ifNone: aBlock
	aCollection isEmpty
		ifTrue: [ ^ aBlock value ].
	^ (aCollection asArray
		sort: [ :a :b | a packageName size > b packageName size ])
		first
%
run
PackageOrganizer setStamp: 'stephane.ducasse 9/4/2008 12:51' forMethod: #mostSpecificPackageIn:ifNone:.
true
%

category: 'searching'
method: PackageOrganizer
mostSpecificPackageOfClass: aClass
	^ self mostSpecificPackageOfClass: aClass ifNone: [self noPackageFound]
%
run
PackageOrganizer setStamp: 'stephane.ducasse 9/4/2008 12:50' forMethod: #mostSpecificPackageOfClass:.
true
%

category: 'searching'
method: PackageOrganizer
mostSpecificPackageOfClass: aClass ifNone: aBlock
	
	^ self 
		mostSpecificPackageIn: (self packages select: [ :each | each includesClass: aClass ])
		ifNone: aBlock
%
run
PackageOrganizer setStamp: 'stephane.ducasse 9/4/2008 12:51' forMethod: #mostSpecificPackageOfClass:ifNone:.
true
%

category: 'searching'
method: PackageOrganizer
mostSpecificPackageOfMethod: aMethodReference
	^ self mostSpecificPackageOfMethod: aMethodReference ifNone: [self noPackageFound]
%
run
PackageOrganizer setStamp: 'stephane.ducasse 9/4/2008 12:50' forMethod: #mostSpecificPackageOfMethod:.
true
%

category: 'searching'
method: PackageOrganizer
mostSpecificPackageOfMethod: aMethodReference ifNone: aBlock

	^ self  
		mostSpecificPackageIn: (self packages select: [ :each | each includesMethodReference: aMethodReference ])
		ifNone: aBlock
%
run
PackageOrganizer setStamp: 'stephane.ducasse 9/4/2008 12:52' forMethod: #mostSpecificPackageOfMethod:ifNone:.
true
%

category: 'searching'
method: PackageOrganizer
noPackageFound
	self error: 'No package found'
%
run
PackageOrganizer setStamp: 'avi 10/11/2003 14:21' forMethod: #noPackageFound.
true
%

category: 'searching'
method: PackageOrganizer
packageNamed: aString ifAbsent: errorBlock
	^ packages at: aString ifAbsent: errorBlock
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 23:08' forMethod: #packageNamed:ifAbsent:.
true
%

category: 'accessing'
method: PackageOrganizer
packageNames
	^ packages keys
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 23:01' forMethod: #packageNames.
true
%

category: 'searching'
method: PackageOrganizer
packageOfClass: aClass
	^ self packageOfClass: aClass ifNone: [self noPackageFound]
%
run
PackageOrganizer setStamp: 'avi 10/11/2003 14:21' forMethod: #packageOfClass:.
true
%

category: 'searching'
method: PackageOrganizer
packageOfClass: aClass ifNone: errorBlock
	| classCategory |
	classCategory := aClass theNonMetaClass category.
	packages at: classCategory ifPresent: [:v | ^ v].
	
	(classCategory includes: $-)
		ifTrue: [ packages at: (classCategory copyUpTo: $-) ifPresent: [:v | ^ v] ].
	
	^ self packages detect: [:ea | ea includesClass: aClass] ifNone: errorBlock
%
run
PackageOrganizer setStamp: 'MarcusDenker 3/11/2010 11:28' forMethod: #packageOfClass:ifNone:.
true
%

category: 'searching'
method: PackageOrganizer
packageOfMethod: aMethodReference
	^ self packageOfMethod: aMethodReference ifNone: [self noPackageFound]
%
run
PackageOrganizer setStamp: 'avi 10/11/2003 14:21' forMethod: #packageOfMethod:.
true
%

category: 'searching'
method: PackageOrganizer
packageOfMethod: aMethodReference ifNone: errorBlock
	^ self packages detect: [:ea | ea includesMethodReference: aMethodReference] ifNone: errorBlock
%
run
PackageOrganizer setStamp: 'avi 10/11/2003 14:22' forMethod: #packageOfMethod:ifNone:.
true
%

category: 'accessing'
method: PackageOrganizer
packages
	^ packages values
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 23:01' forMethod: #packages.
true
%

category: 'registering'
method: PackageOrganizer
registerPackage: aPackageInfo
	packages at: aPackageInfo packageName put: aPackageInfo.

%
run
PackageOrganizer setStamp: 'DaleHenrichs 9/29/2010 15:13' forMethod: #registerPackage:.
true
%

category: 'registering'
method: PackageOrganizer
registerPackageNamed: aString
	^ self registerPackage: (PackageInfo named: aString)
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 21:08' forMethod: #registerPackageNamed:.
true
%

category: 'registering'
method: PackageOrganizer
unregisterPackage: aPackageInfo
	packages removeKey: aPackageInfo packageName ifAbsent: [].	
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 23:08' forMethod: #unregisterPackage:.
true
%

category: 'registering'
method: PackageOrganizer
unregisterPackageNamed: aString
	self unregisterPackage: (self packageNamed: aString ifAbsent: [^ self])
%
run
PackageOrganizer setStamp: 'avi 11/12/2003 21:10' forMethod: #unregisterPackageNamed:.
true
%

category: 'numeric'
method: MCMockClassB
two

	^ 2
%
run
MCMockClassB setStamp: 'ab 7/7/2003 23:21' forMethod: #two.
true
%

category: 'instance creation'
classmethod: UUIDGenerator
default
        | default |
        default := SessionTemps current at: #DEFAULT_GENERATOR_FOR_UUIDGenerator otherwise: nil.
        default == nil
                ifTrue: [
                        default := self generateDefault.
                        SessionTemps current at: #DEFAULT_GENERATOR_FOR_UUIDGenerator put: default ].
        ^default
%
run
UUIDGenerator class setStamp: 'JMM 11/22/2001 13:41' forMethod: #default.
true
%

category: 'instance creation'
classmethod: UUIDGenerator
generateDefault
    ^self new
%
run
UUIDGenerator class setStamp: 'nk 7/30/2004 21:51' forMethod: #generateDefault.
true
%

category: 'instance creation'
classmethod: UUIDGenerator
new

	^ self basicNew initialize

%
run
UUIDGenerator class setStamp: 'DaleHenrichs 9/30/2010 16:05' forMethod: #new.
true
%

category: 'instance creation'
method: UUIDGenerator
generateBytes: aPlaceHolder forVersion: aVersion
	aVersion = 4 ifTrue: [self generateFieldsVersion4]
		ifFalse: [self error: 'Unsupported version'].
	self placeFields: aPlaceHolder.
%
run
UUIDGenerator setStamp: 'JMM 11/22/2001 13:45' forMethod: #generateBytes:forVersion:.
true
%

category: 'instance creation'
method: UUIDGenerator
generateFieldsVersion4

	timeLow := self generateRandomBitsOfLength: 32.
	timeMid := self generateRandomBitsOfLength: 16.
	timeHiAndVersion := 16r4000 bitOr: (self generateRandomBitsOfLength: 12).
	clockSeqHiAndReserved := 16r80 bitOr: (self generateRandomBitsOfLength: 6).
	clockSeqLow := self generateRandomBitsOfLength: 8.
	node := self generateRandomBitsOfLength: 48.
	
%
run
UUIDGenerator setStamp: 'JMM 11/22/2001 23:13' forMethod: #generateFieldsVersion4.
true
%

category: 'generator'
method: UUIDGenerator
generateOneOrZero
	^self semaphoreForGenerator
		critical: [
			| value | 
			value := self randomGenerator next.
			self randomCounter: self randomCounter + 1.
			self randomCounter > 100000
				ifTrue: [self setupRandom].
			value < 0.5
					ifTrue: [0]
					ifFalse: [1]]
%
run
UUIDGenerator setStamp: 'nice 1/5/2010 20:55' forMethod: #generateOneOrZero.
true
%

category: 'generator'
method: UUIDGenerator
generateRandomBitsOfLength: aNumberOfBits
| target |
	target := 0.
	aNumberOfBits == 0 ifTrue: [^target].
	target := self generateOneOrZero.
	(aNumberOfBits - 1)  timesRepeat:
		[target := (target bitShift: 1)  bitOr: self generateOneOrZero].
	^target
%
run
UUIDGenerator setStamp: 'DaleHenrichs 9/30/2010 16:29' forMethod: #generateRandomBitsOfLength:.
true
%

category: 'instance creation'
method: UUIDGenerator
initialize
	self setupRandom.
	semaphoreForGenerator := Semaphore forMutualExclusion.
	
%
run
UUIDGenerator setStamp: 'DaleHenrichs 9/29/2010 15:00' forMethod: #initialize.
true
%

category: 'random seed'
method: UUIDGenerator
makeSeed
	"Try various methods of getting good seeds"
	| seed |
	seed := self makeUnixSeed.
	seed ifNotNil: [^seed].

	"not sure if this is reliably random... commented out for now. -dew"
	"seed := self makeSeedFromSound.
	seed ifNotNil: [^seed]."
	
	"default"
	[seed := (Time millisecondClockValue bitAnd: 16r3FFFFFFF) bitXor: self hash.
	seed := seed bitXor: (DateAndTime now asSeconds asInteger bitAnd: 16r3FFFFFFF).
	seed = 0] whileTrue: ["Try again if ever get a seed = 0"].

	^seed

%
run
UUIDGenerator setStamp: 'DaleHenrichs 9/30/2010 16:28' forMethod: #makeSeed.
true
%

category: 'random seed'
method: UUIDGenerator
makeUnixSeed
	
	^nil
%
run
UUIDGenerator setStamp: 'DaleHenrichs 9/29/2010 15:03' forMethod: #makeUnixSeed.
true
%

category: 'instance creation'
method: UUIDGenerator
placeFields: aByteArray

	aByteArray at: 1 put: ((timeLow bitShift: -24) bitAnd: 16rFF).
	aByteArray at: 2 put: ((timeLow bitShift: -16) bitAnd: 16rFF).
	aByteArray at: 3 put: ((timeLow bitShift: -8) bitAnd: 16rFF).
	aByteArray at: 4 put: (timeLow bitAnd: 16rFF).
	aByteArray at: 5 put: ((timeMid bitShift: -8) bitAnd: 16rFF).
	aByteArray at: 6 put: (timeMid bitAnd: 16rFF).
	aByteArray at: 7 put: ((timeHiAndVersion bitShift: -8) bitAnd: 16rFF).
	aByteArray at: 8 put: (timeHiAndVersion bitAnd: 16rFF).
	aByteArray at: 9 put: clockSeqHiAndReserved.
	aByteArray at: 10 put: clockSeqLow.
	0 to: 5 do: [:i |
		aByteArray at: 11 + i put: ((node bitShift: (-8*i)) bitAnd: 16rFF)]

%
run
UUIDGenerator setStamp: 'JMM 11/22/2001 23:12' forMethod: #placeFields:.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
randomCounter
	^randomCounter
%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:28' forMethod: #randomCounter.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
randomCounter: aNumber
	randomCounter := aNumber

%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:29' forMethod: #randomCounter:.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
randomGenerator
	^randomGenerator

%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:27' forMethod: #randomGenerator.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
randomGenerator: aGenerator
	randomGenerator := aGenerator

%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:27' forMethod: #randomGenerator:.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
semaphoreForGenerator
	^semaphoreForGenerator
%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:29' forMethod: #semaphoreForGenerator.
true
%

category: 'accessors and mutators'
method: UUIDGenerator
semaphoreForGenerator: aSema
	semaphoreForGenerator := aSema

%
run
UUIDGenerator setStamp: 'JMM 11/21/2001 14:29' forMethod: #semaphoreForGenerator:.
true
%

category: 'instance creation'
method: UUIDGenerator
setupRandom
	randomCounter := 0.
	randomGenerator := Random seed: self makeSeed.
%
run
UUIDGenerator setStamp: 'CdG 11/19/2002 21:30' forMethod: #setupRandom.
true
%
commit
time
run
MCMockClassA initialize.
true
%
run
MCGemStonePlatform initialize.
true
%
run
MCFilesystemCacheRepository initialize.
true
%
commit
time
run
MCDirtyPackageInfo initialize.
true
%
run
MCEmptyPackageInfo initialize.
true
%
run
MCMockPackageInfo initialize.
true
%
run
PackageInfo initialize.
true
%
commit
time

