!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: number2.gs 31940 2013-11-22 17:44:33Z lalmarod $
!
! Superclass Hierarchy:
!   Number, Magnitude, Object.
!
!=========================================================================

category: 'Instance Creation'
set compile_env: 0
classmethod: Number
fromStream: aStream
  "BinaryExponent = ( 'e' | 'E' | 'd' | 'D' | 'q') ['-' | '+'] Digits
   DecimalExponent = ( 'f' | 'F' ) ['-' | '+'] Digits
   Digit = '0' | '1' | '2' | ... | '9'
   Digits = Digit {Digit}
   Exponent = BinaryExponent | DecimalExponent | ScaledDecimalExponent | FixedPointExponent
   FractionalPart = '.' Digits [Exponent]
   FixedPointExponent = 'p' [ ['-' | '+'] Digits ] 
   Number = RadixedLiteral | NumericLiteral
   Numeric = Digit | 'A' | 'B' | ... | 'Z'
   NumericLiteral = Digits ( [FractionalPart] | [Exponent] )
   Numerics = Numeric { Numeric }
   RadixedLiteral = Digits ( '#' | 'r' ) ['-'] Numerics
   ScaledDecimalExponent = 's' [ ['-' | '+'] Digits ]
"
  | ch integerPart factor signFound |
  self _checkReadStream: aStream forClass: CharacterCollection.
  ch := aStream next.
  [ ch unicodeIsWhitespace] whileTrue: [ ch := aStream next ].
  aStream skip: -1.
  integerPart := 0.
  factor := 1.
  signFound := false.
  (aStream peek isEquivalent: $-)
    ifTrue: [ 
      aStream next.
      signFound := true.
      factor := -1 ]
    ifFalse: [ 
      (aStream peek isEquivalent: $+)
        ifTrue: [ 
          aStream next.
          signFound := true ] ].
  (aStream atEnd or: [ aStream peek isDigit not ])
    ifTrue: [ ^ self _errIncorrectFormat: aStream ].
  [ aStream atEnd not and: [ (ch := aStream peek) isDigit ] ]
    whileTrue: [ 
      aStream next.
      integerPart := integerPart * 10 + ch digitValue ].

  (ch == $r or: [ ch == $# ])
    ifTrue: [ 
      "found a radix separator"
      aStream next.
      ^ Integer
        _finishFromStream: aStream
        signFound: signFound
        factor: factor
        radix: integerPart ].
  (ch isEquivalent: (Locale decimalPoint at: 1))
    ifTrue: [ 
      "found a decimal point"
      aStream next.
      ^ BinaryFloat
        _finishFromStream: aStream
        signFound: signFound
        factor: factor
        integerPart: integerPart ].
  (#( $e $E $d $D $q $s $p $f $F ) includesIdentical: ch) ifTrue:[ 
      aStream next.
      ^ BinaryFloat
        _finishFromStream: aStream
        signFound: signFound
        factor: factor
        integerPart: integerPart
        fractionalPart: 0
        exponent: ch ].
  ^ integerPart * factor
%
set compile_env: 0
classmethod: Number
_finishFromStream: aStream signFound: signFound factor: factor integerPart: integerPart fractionalPart: fractionalPart exponent: exponent exponentPart: exponentPart
  "BinaryExponent = ( 'e' | 'E' | 'd' | 'D' | 'q' ) ['-' | '+'] Digits
   DecimalExponent = ( 'f' | 'F' ) ['-' | '+'] Digits
   Digit = '0' | '1' | '2' | ... | '9'
   Digits = Digit {Digit}
   Exponent = BinaryExponent | DecimalExponent | ScaledDecimalExponent | FixedPointExponent
   FractionalPart = '.' Digits [Exponent]
   FixedPointExponent = 'p' [ ['-' | '+'] Digits ] 
   Number = RadixedLiteral | NumericLiteral
   Numeric = Digit | 'A' | 'B' | ... | 'Z'
   NumericLiteral = Digits ( [FractionalPart] | [Exponent] )
   Numerics = Numeric { Numeric }
   RadixedLiteral = Digits ( '#' | 'r' ) ['-'] Numerics
   ScaledDecimalExponent = 's' [ ['-' | '+'] Digits ]
"

  "create appropriate subclass from the pieces ... by hook or by crook"

| aString |

 aString :=   (factor * integerPart) asString , (Locale decimalPoint at: 1) asString , fractionalPart asString , exponent asString , exponentPart asString.
(exponent == $s) ifTrue: [^ScaledDecimal fromString: aString].
(exponent == $p) ifTrue: [^FixedPoint fromString: aString].
(exponent isEquivalent: $f) ifTrue: [^DecimalFloat fromString: aString].
  ^ BinaryFloat fromString: aString
%

run
"now let fromString: be inherited from Magnitude"
Number class removeSelector: #fromString: .
true
%

category: 'Indexing Support'
method: Number
_idxOptimizedCompareWithClass: aClass
  "Returns true if the receiver may be inserted into a BtreePlusNode whose 
   #lastElementClass is <aClass> and whose comparisons are optimized."

  "Sent when index option optimizeComparison is true and aClass responds true to #_idxCanOptimizeComparison"

  "Optimized comparisons allowed for Numbers that are not NaN"

  ^ (self _idxBasicCanCompareWithClass: aClass) and: [ self _isNaN not]
%
