!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   WriteStream, PositionableStream, Stream, Object.
!
! See installStreamHierarchy.topaz for filein information
!
!=========================================================================

! to filein this file interactively for debugging compile errors,
!   UserGlobals at: #WriteStream put: WriteStreamLegacy

expectvalue /String
run
Stream _initializeWriteStreamClassVars: WriteStream
%    

set class WriteStream
removeallmethods 
removeallclassmethods 

doit
WriteStream comment: 'WriteStream / WriteStreamLegacy is a PositionableStream that allows its 
 objects to be written, but not read.'.
true
%

category: 'Instance Creation'
classmethod:
new

"Disallowed.  To create a new WriteStream, use the class method on: instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod:
with: aCollection

"Returns an instance of the receiver open for writing. that is positioned at the end of 
 aCollection."
   | res | 
   (res := self on: aCollection) setToEnd .
   ^ res
%

category: 'Accessing'
method:
next

"Disallowed.  You cannot read a WriteStream."

self shouldNotImplement: #next
%

! fix 37918/36521: add _nextPut:

category: 'Adding'
method:
_nextPut: anObject
"see PrintStream>>_nextPut:"

itsCollection at: position put: anObject.
position := position + 1.
^ anObject
%

category: 'Adding'
method:
nextPut: anObject

"Inserts anObject as the next element that the receiver can access for writing.
 Returns anObject."

^ self _nextPut: anObject
%

category: 'Adding'
method:
nextPutAll: aCollection

"Inserts the elements of aCollection as the next elements that the receiver can
 access.  Returns aCollection."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAll: aCollection ].
itsCollection addAll: aCollection.
position := position + (aCollection size).
^ aCollection
%

category: 'Adding'
method:
nextPutAllBytes: aCharacterCollection

"Inserts the byte contents of aCharacterCollection as the next elements 
 that the receiver can access.  Returns aCollection.  The receiver's collection
 must be a type of String."

"Used in the implementation of PassiveObject."

position == (itsCollection size + 1)
ifFalse:
  [ ^ super nextPutAllBytes: aCharacterCollection ].
itsCollection addAllBytes: aCharacterCollection.
position := position + (aCharacterCollection _basicSize).
^ aCharacterCollection
%

category: 'Adding'
method:
print: anObject

	anObject printOn: self.
%

category: 'Accessing'
method:
contents

"WriteStreams return the portion of their collection that has been written:
 the collection up to the next write-position."

position < 2 ifTrue: [ ^itsCollection species new ].
^itsCollection copyFrom: 1 to: position-1
%

category: 'ANSI'
method:
flush
	"Update a stream's backing store.
	Upon return, if the receiver is a write-back stream, the state of the
	stream backing store must be consistent with the current state of the 
	receiver.
	If the receiver is not a write-back stream, the effect of this 
	message is unspecified."

	"We do nothing; this method is provided for ANSI compatibility"
%

###############################################
# 46428
# Begin methods copied from writestPortable.gs
###############################################
# 46533   - do no overload cr here.
#           cr method deleted.#           cr method deleted.#           cr method deleted.

category: 'Character writing'
method:
crlf
"Append a carriage return character followed by a line feed character to the receiver."

self nextPutAll: CrLf .
%

category: 'Character writing'
method:
crtab
"Append a return character, followed by a single tab character, to the 
receiver."

self nextPutAll: CrTab .
%

category: 'Character writing'
method:
crtab: anInteger 
"Append a return character, followed by anInteger tab characters, to the 
receiver."

self nextPut: Cr     .
anInteger timesRepeat: [self nextPut: Tab ]
%

category: 'Character writing'
method:
space: anInteger 
"Append anInteger space characters to the receiver."

anInteger timesRepeat: [ self nextPut: $   ]
%

category: 'Character writing'
method:
tab: anInteger 
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self nextPut: Tab ]
%

! Test optimized character literals
lev 1
expectvalue true
run
  "Note WriteStreamLegacy inherits Stream>>cr which appends codepoint 10"
  | strm ary exp | 
  strm := WriteStream on: String new .
  strm cr ; crlf; crtab ; crtab: 2 ; lf ; space ; tab ; space: 2; tab: 2 .
  ary := { } .
  strm contents do:[:c | ary add: c  codePoint ] .
  ary = #( 10 13 10 13 9 13 9 9 10 32 9 32 32 9 9 ) ifFalse:[ ^ ary ].
  true
%
lev 0
