set compile_env: 0
! ------------------- Class definition for GSTestCase
expectvalue /Class
doit
TestCase subclass: 'GSTestCase'
  instVarNames: #()
  classVars: #( PersistentObject)
  classInstVars: #()
  poolDictionaries: #()
  inDictionary: Globals
  options: #()

%
! ------------------- Remove existing behavior from GSTestCase
expectvalue /Metaclass3       
doit
GSTestCase removeAllMethods.
GSTestCase class removeAllMethods.
%
set compile_env: 0
! ------------------- Class methods for GSTestCase
category: 'other'
classmethod: GSTestCase
confirm: aSelector

	^[
		self debug: aSelector.
		true.
	] on: Error , TestFailure do: [:ex | 
		false.
	].
%
category: 'other'
classmethod: GSTestCase
debug: aSelector
  SessionTemps current at:#Ernie_debug put: true . "supress stack report in exception message"
  self openSunitLog: #stdout .
  ^ super debug: aSelector
%
category: 'other'
classmethod: GSTestCase
debugEx

"receiver should be a concrete test case class .
 run and get stack at first error."
^ self debugSuite: self suite
%
category: 'other'
classmethod: GSTestCase
debugEx: aTestCaseClass

"Run suite for specified class and get stack at first error."

^ self debugSuite: aTestCaseClass suite
%
category: 'other'
classmethod: GSTestCase
debugSuite: aTestSuite

  GSTestCase openSunitLog: #stdout .
  [
    SessionTemps current at:#Ernie_debug put: true . "supress stack report in exception message"
    aTestSuite tests do: [:each | 
      (each isKindOf: TestSuite)
        ifTrue:  [self debugSuite: each] 
        ifFalse: [each debugInSuite].
    ].
  ] ensure: [
    TestResource resetResources: self resources.
  ].
  GSTestCase flushLog .
  ^ 'ok'  
%
category: 'other'
classmethod: GSTestCase
flushLog

| sunitLog |
sunitLog := System sessionStateAt: 1 .
sunitLog ifNotNil:[ sunitLog flush ].
%
category: 'other'
classmethod: GSTestCase
isAbstract
	"Override to true if a TestCase subclass is Abstract and should not have
	TestCase instances built from it"

	^self sunitName = #GSTestCase
%
category: 'other'
classmethod: GSTestCase
isLinux
   ^ (System gemVersionAt: 'osName') = 'Linux'
%
classmethod: GSTestCase
isUbuntuLinux
  ^ self isLinux and:[ (System gemVersionAt: 'osVersion') includesString:'Ubuntu' ] 
%

classmethod: GSTestCase
isLinuxOrSolaris
| os |
os := System gemVersionAt: 'osName'.
^ os = 'Linux' or:[ os = 'SunOS' ]
%

classmethod: GSTestCase
isUbuntu20Linux
  ^ self isUbuntuLinux and:[ (System performOnServer: 'cat /etc/os-release') includesString: 'Ubuntu 20' ] 
%

category: 'other'
classmethod: GSTestCase
isSolaris
  "Neede on class side by GsSocketTestCase"
  ^(System gemVersionAt: 'osName') = 'SunOS'
%
category: 'other'
classmethod: GSTestCase
isWindows

  ^ GsFile gciClientIsWindows .
%
classmethod: GSTestCase
asPrintable: aString
| res |
GsFile stdoutServer isTerminal ifFalse:[ ^ aString ]
"avoid freezing certain Xterm windows with control chars".
res := String new .
1 to: aString size do:[:n | | ch |
  ch := aString codePointAt: n .
  ch < 16r20 ifTrue:[
    (ch == 10"\n" or:[ ch == 9"\t" ]) ifTrue:[ res addCodePoint: ch ]
             ifFalse:[ res add: $^ ; addCodePoint: 16r40 + ch ]
     ] ifFalse:[
  ch < 16r7F ifTrue:[ res addCodePoint: ch ] ifFalse:[ 
  ch == 16r7F ifTrue:[ res addAll:'^?' ] ifFalse:[ | cpStr sz |
    res addAll:'\u' .
    cpStr := ch asHexString . 
    sz := cpStr size .
    [ sz < 4 ] whileTrue:[ res add: $0 . sz := sz + 1 ].
    res addAll: cpStr .
 ]]]
].   
^ res
%
category: 'other'
classmethod: GSTestCase
log: aString
| sunitLog |
sunitLog := System sessionStateAt: 1 .
sunitLog ifNil:[
  "if not already open, assume in an external session's gem, log to filesystem"
  sunitLog := self openSunitLog: #filesystem
].
sunitLog nextPutAll: (self asPrintable: aString) ; flush
%
category: 'other'
classmethod: GSTestCase
logCr: aString

| str |
str := aString , Character lf .
GSTestCase log: str 
%
category: 'other'
classmethod: GSTestCase
openSunitLog: aKind
"aKind == #stdout means to GsFile stdout, otherwise to SUnit.log file"
| aLog |
aLog := System sessionStateAt: 1.
aLog ifNil:[
  aKind == #stdout ifFalse:[
    aLog := GsFile openAppendOnServer: GSTestSuite logFilePath.
  ].
  aLog ifNil:[ 
    "use stdout if file system open failed. Example: remote topaz -l
     and logFilePath generates file system path 
     based on extent locations without /export ."
    aLog := GsFile stdout 
  ].
  System sessionStateAt: 1 put: aLog.
] ifNotNil:[
  GsFile gciLogClient:'SUnit log file already open' .
].
^ aLog
%
category: 'Running'
classmethod: GSTestCase
persistentCounterUsage

"documentation of ernie uses of System(C) >> persistentCounterAt: ... "

^ ' GsSocketTestCase    counter 23   in _serverReadyFlag
    GsSecureSocketTestCase      23   in _serverReadyFlag
    GsSocketTestCase  counters 1..4  
    UserProfileTestCase >> test_loginHook_   counter 6 .
    TestPersistentCounters   counter 7 .
    BugTst1TestCase  softBreak tests counter 8
    UnorderedCollectionTestCase  counter 24 .
    GsTestCase debug correlation of tranlog  to SUnit.log  counter 25 .
    RcQueueTestCase >> test_47647   counter 26

  '
%
category: 'other'
classmethod: GSTestCase
random

        ^ SessionTemps current at:#Random ifAbsentPut: [Random new].
%
category: 'other'
classmethod: GSTestCase
runEx

"receiver should be a concrete test case class"
^ GSTestCase runEx: self
%
category: 'other'
classmethod: GSTestCase
runEx: aTestCaseClass

	| results defects |
	results := aTestCaseClass suite run .
	(defects := results defects) isEmpty ifTrue: [
		^results printString.
	].
  "Return result in order in which they occurred; do not sort."
	^ defects collect: [:each | each printString ].
%
category: 'other'
classmethod: GSTestCase
suite

	| suite tests |
	suite := super suite.
	tests := suite tests.
	tests copy do: [:each | 
		(each isKindOf: GSTestSuite) ifTrue: [
			| assoc |
			assoc := System myUserProfile resolveSymbol: each name asSymbol.
			(assoc notNil and: [assoc value wantsToBeRunByItself]) ifTrue: [
				tests remove: each.
			].
		].
	].
	^suite.
%
category: 'other'
classmethod: GSTestCase
suiteAsExecutionSource

  " return an execution string of all test cases that
    don't need to be run by themselves, for use
    in debugging a new VM from topaz -l  ."
  | str LF |
  str := String new .
  LF := Character lf .
  str addAll:'run'; add: LF .
  GSTestCase suite tests do:[:aTst | 
    str addAll:'GSTestCase debugEx: '; addAll: aTst name ; add: $. ; add: LF
  ].
  str add: $% ; add: LF .
  ^ str
%
category: 'other'
classmethod: GSTestCase
suiteClass
	^GSTestSuite
%
category: 'other'
classmethod: GSTestCase
wantsToBeRunByItself

	^false.
%
classmethod: GSTestCase
dummyHostCallDebugger
GsFile stdoutServer isTerminal ifFalse:[ | f |
  f := GsFile openWriteOnServer:'HostCallDebugger.log' .
  f nextPutAll:'HostCallDebugger', ': process ' , System gemProcessId asString,
     ' waiting for topaz -r to attach with DEBUGGEM' ; lf .
  f close .
].
%

classmethod:
isDebug
  | tmps now |
  now := DateAndTime now asStringMs .
  tmps := SessionTemps current .
  (tmps at:#Ernie_debug otherwise: false) ifTrue:[ 
    ^ true
    "running a test case via debug: or debugEx , let topaz handle the error" 
  ].
  (System gemEnvironmentVariable:'ErnieWaitForDebug') ~~ nil ifTrue:[
    self dummyHostCallDebugger . 
    GsFile gciLogServer:'Waiting for debugger to attach, use topaz -r, DEBUGGEM' .
    tmps at: #GSTestCaseWaitForDebug put: true .
    [ tmps at: #GSTestCaseWaitForDebug  ] whileTrue:[ Delay waitForSeconds: 1 ]. "Wait for DEBUGGEM"
  ].
  ^ false "log failure to SUnit.log and keep running"
%   

! ------------------- Instance methods for GSTestCase
category: 'other'
method: GSTestCase
abort
	System abortTransaction.
%
category: 'other'
method: GSTestCase
addAllTestsTo: aList

	aList add: self.
%
category: 'other'
method: GSTestCase
addSession: aSession
"return a session for similarity with collection methods"
	^self sessions add: aSession
%
category: 'Accessing'
method: GSTestCase
assert: aBoolean 
  
  self assert: aBoolean description:'' .
%
category: 'Accessing'
method: GSTestCase
assert: aBoolean description: aString
  | str | 
  aBoolean == true  ifFalse: [
    str := aString .
    str _isExecBlock ifTrue:[ str := aString value ].
    self logFailure: str.
    GSTestResult resumableFailure sunitSignalWith: str
  ]
%
category: 'Accessing'
method: GSTestCase
assert: aBoolean description: aString resumable: resumableBoolean
  | exception |
  aBoolean == true  ifFalse: [
    self logFailure: aString.
    exception := resumableBoolean ifTrue: [
      GSTestResult resumableFailure
    ] ifFalse: [
      GSTestResult failure
    ].
    exception sunitSignalWith: aString
  ]
%
category: 'other'
method: GSTestCase
assert: a equals: b description: c
  self assert: a = b description: 
    a asString, ' not equal to ' , b asString , ' for ', c
%
category: 'other'
method: GSTestCase
assert: a identical: b
  self assert: a == b description: 'OOP ' , a asOop asString, ' not identical to OOP ' , b asOop asString
%
category: 'other'
method: GSTestCase
assert: a identical: b description: c
  self assert: a == b description: 
   'OOP ' , a asOop asString, ' not identical to OOP ' , b asOop asString , ' for ', c
%
category: 'other'
method: GSTestCase
assert: a isEquivalentTo: b
	| difference epsilon |
	epsilon := (a abs max: b abs) * 1.0e-08.
	difference := (a - b) abs asScaledDecimal: 12.
	self assert: difference <= epsilon description: a printString, ' is not equivalent to ', b printString.
%
category: 'other'
method: GSTestCase
assert: a lessThan: b 
  self assert: a < b description: 
    a asString, ' not < ' , b asString  
%
category: 'other'
method: GSTestCase
assert: aString matchPattern: aPatternArray

	self assert: (aString matchPattern: aPatternArray) description: aString printString, ' does not match ', aPatternArray printString.
%
category: 'other'
method: GSTestCase
assert: a notIdentical: b
  self assert: a ~~ b description: ' expected a ', a printString, ' to not be identical to b '
%
category: 'other'
method: GSTestCase
assertQuietNan: f1
  self assert: (f1 _isNaN _and: [ f1 kind == #quietNaN ])
%
category: 'other'
method: GSTestCase
begin
	
	System beginTransaction.
%
category: 'other'
method: GSTestCase
commit

	^System commitTransaction or: [self error: 'commit failed'].
%
category: 'other'
method: GSTestCase
compileMethod: aStr class: anObject

	self assert: (anObject compileMethod: aStr dictionaries: System myUserProfile symbolList category: 'other') == nil.
%
category: 'other'
method: GSTestCase
continue

	^System continueTransaction
%
category: 'other'
method: GSTestCase
debug
   [ (self class selector: testSelector) runCase
   ] ensure: [
     [ TestResource resetResources: self resources
     ] on: Notification do:[:ex | 
        ex class defaultHandlers size > 0 ifTrue:[ ex pass ].
        Error signal: ex asString 
     ]
   ].
%
category: 'other'
method: GSTestCase
debugInSuite
   "used from GsTestCase class >> debugSuite: that does its own cleanup" 

   (GSTestResult excludeInSoloSession: self) ifTrue:[
     GSTestCase logCr: self printString , ' -  Excluding in SoloSession' .
   ] ifFalse: [
     (self class selector: testSelector) runCase 
   ]
%
category: 'other'
method: GSTestCase
deny: a equals: b
  self assert: (a = b) not description: 'OOP ' , a asOop asString, ' is equal to OOP ' , b asOop asString
%
category: 'other'
method: GSTestCase
deny: a identical: b
  self assert: a ~~ b description: 'OOP ' , a asOop asString, ' is identical to OOP ' , b asOop asString
%
category: 'other'
method: GSTestCase
ensureExtentsExist: anInteger

	| existingName i lastNumber |
	SystemRepository numberOfExtents >= anInteger ifTrue: [^self].
	existingName := SystemRepository fileNames last.
	i := existingName size - 3.
	(existingName copyFrom: i to: i + 3) = '.dbf'ifFalse: [
		self error: 'unexpected extent name'.
	].
	[
		i > 1 and: [(existingName at: i - 1) isDigit].
	] whileTrue: [
		i := i - 1.
	].
	i = (existingName size - 3) ifTrue: [
		self error: 'extent name does not end in digit'.
	].
	lastNumber := (existingName copyFrom: i to: existingName size - 4) asNumber.
	[
		SystemRepository numberOfExtents < anInteger.
	] whileTrue: [
		| newName |
		lastNumber := lastNumber + 1.
		newName := (existingName copyFrom: 1 to: i - 1) , 
			lastNumber printString , '.dbf'.
		SystemRepository createExtent: newName.
	].
	System hasMissingGcGems ifTrue: [
		System stopAllGcGems.
		System startAllGcGems.
	].
%
category: 'other'
method: GSTestCase
ensureGcRunning
	System ensureGcRunning.
	self deny: System hasMissingGcGems description: 'System hasMissingGcGems in ensureGcRunning'.
%
category: 'other'
method: GSTestCase
forceLogoutSessions
  self sessions ifNotNil:[:list | 
    list do: [:each | each ifNotNil:[ each forceLogout ] ].
    list size: 0 .
  ].
%
category: 'other'
method: GSTestCase
gciErrorClass

	^(System gemVersionAt: 'osName') = 'AIX'
		ifTrue: [GciLegacyError] 
		ifFalse: [GciError].
%
category: 'other'
method: GSTestCase
gemHost

	^GsGemProcess new host nodeName
%
category: 'other'
method: GSTestCase
ignoringDeprecatedDo: aBlock
  ^ aBlock on: Deprecated do:[:ex | ex resume  ]
%
category: 'other'
method: GSTestCase
ignoringDeprecatedShould: aBlock raise: anObject
  ^ self should: [  aBlock on: Deprecated do:[:ex | ex resume ]] 
      raise: anObject  description:''
%
category: 'other'
method: GSTestCase
isAix
  ^ (System gemVersionAt: 'osName') = 'AIX'
%
category: 'other'
method: GSTestCase
isAix6 
^ self isAix and:[ (System gemVersionReport at: #osVersion) = '6' ].
%
category: 'other'
method: GSTestCase
isAix7
^ self isAix and:[ (System gemVersionReport at: #osVersion) = '7' ].
%
category: 'other'
method: GSTestCase
isDarwin
  ^ (System gemVersionAt: #osName) = 'Darwin'
%
category: 'other'
method: GSTestCase
isLinuxOrSolaris
	^self class isLinuxOrSolaris
%
method: GSTestCase
isLinux
	^self class isLinux
%
method: 
isUbuntuLinux
  ^ self class isUbuntuLinux
%
category: 'other'
method: GSTestCase
isLinuxOrDarwin
  
  ^self isLinux or: [self isDarwin]
%
category: 'other'
method: GSTestCase
isLinuxOrDarwinOrAix

  ^self isLinuxOrDarwin or: [self isAix]
%
category: 'other'
method: GSTestCase
isRubyDbf
	"Return true if we started with extent0.ruby.dbf"

	^ (Globals at: #RubySystemExit otherwise:nil) ~~ nil
%
category: 'other'
method: GSTestCase
isSlowHost
  | host |
  host := System hostname .
  #( 'rain'"because of AIX JFS" 'wind'
     'nimbus' 'fez' 'pagri' 'phaser' ) do:[:str |
    (str includesString: host) ifTrue:[ ^ true ].
  ].
  ^ false .
%
method: GSTestCase
isFastHost
 | host |
  host := System hostname .
 #( hood moop kauai mizar acrux capella) do:[:str |
    (str includesString: host) ifTrue:[ ^ true ].
  ].
  ^ false .
%

category: 'other'
method: GSTestCase
isSolaris
  ^ self class isSolaris
%
category: 'other'
method: GSTestCase
isSolo
  ^GsSession isSolo
%
category: 'other'
method: GSTestCase
isValidException: expClass

	expClass _isArray 
		ifTrue: [ 
			(expClass includesIdentical: AbstractException) 
				ifTrue: ["error in test code"
					self assert: false 
						description:'expected classes must not include AbstractException']] 
		ifFalse: [
			self assert: expClass ~~ AbstractException 
				description:'expected class must not == AbstractException'
	].
	^true
%
category: 'other'
method: GSTestCase
isWindows

	^self class isWindows
%
category: 'other'
method: GSTestCase
loadAverageString
  | str idx |
  str := System performOnServer:'uptime' .
  idx := str findString: 'load average' startingAt: 1 .
  idx ~~ 0 ifTrue:[
    idx > 1 ifTrue:[ 
      str at: idx-1 put: $[ ; at: str size put: $] .
      idx := idx-1
    ].          
    ^ str copyFrom: idx to: str size .
  ].
  ^ 'load average not available'
%
category: 'other'
method: GSTestCase
log: aString

GSTestCase log: aString
%
category: 'other'
method: GSTestCase
logCr: aString

GSTestCase logCr: aString
%
category: 'others'
method: GSTestCase
logFailure: aString

 self logCr:' ' , Time now asStringMs , ' FAILURE: ', aString  .
 GSTestCase isDebug ifFalse:[
   self logCr:'------------------------------(' ;
   logCr: (GsProcess stackReportToLevel:300) ;
"   logCr: (GsProcess _fullStackReport ) ;  "   "uncomment this to get more output in SUnit.log "
   logCr:'------------------------------)' .
 ].
%
category: 'other'
method: GSTestCase
logLoadAverage
  self logCr:' ' , self loadAverageString , ' ' .
%
category: 'other'
method: GSTestCase
newExternalSession	

	^self sessions add: GsExternalSession login
%
category: 'Running'
method: GSTestCase
nilTestCaseInstanceVariables
  "nil out instance variables of the test case AFTER tearDown has been called. Since all test cases
   are kept around by the testSuite, we need to clear out any objects that may be referenced by the
   test cases themselves to avoid blowing out temp obj memory while running ernie0."

  "skip #testSelector in slot 1"
  2 to: self class allInstVarNames size do: [:ivIndex |
    self instVarAt: ivIndex put: nil ]
%
category: 'other'
method: GSTestCase
performTest

	self shouldRepeatIfInterruptedByGC ifTrue: [
		self repeatIfInterruptedByGC: [super performTest].
	] ifFalse: [
		super performTest.
	].
%
category: 'other'
method: GSTestCase
printOn: aStream

	aStream
		nextPutAll: self class printString;
		nextPutAll: ' debug: #';
		nextPutAll: (testSelector isNil ifTrue: ['??'] ifFalse: [testSelector]).

%
category: 'other'
method: GSTestCase
random
  
	^ SessionTemps current at:#Random ifAbsentPut: [Random new].
%
category: 'other'
method: GSTestCase
removeUserId: userId
	| user |

	(user := AllUsers userWithId: userId ifAbsent: [nil]) == nil
		ifFalse: [AllUsers removeAndCleanup: user].
%
category: 'other'
method: GSTestCase
removeUserIds: userIds

	userIds do: [:userId | self removeUserId: userId].
%
category: 'other'
method: GSTestCase
repeatIfInterruptedByGC: aBlock

	| oldScavenge oldMarkSweep newScavenge newMarkSweep |
	10 timesRepeat: [
		oldScavenge := System myCacheStatisticWithName: 'ScavengeCount'.
		oldMarkSweep := System myCacheStatisticWithName: 'MarkSweepCount'.
		aBlock value.
		newScavenge := System myCacheStatisticWithName: 'ScavengeCount'.
		newMarkSweep := System myCacheStatisticWithName: 'MarkSweepCount'.
		(oldScavenge = newScavenge and: [oldMarkSweep = newMarkSweep]) ifTrue: [^self].
		System  _generationScavenge_vmMarkSweep .
	].
	self error: 'Block could not be performed without being interrupted by GC'.
%
category: 'other'
method: GSTestCase
resultDirectory
  ^ (System clientEnvironmentVariable: 'resultdir') ifNil:[
      (System gemEnvironmentVariable: 'resultdir') ifNil:[
         "assume interactive debugging"
         GsFile serverCurrentDirectory
   ]].
%
category: 'Running'
method: GSTestCase
run
        | result |
        result := GSTestResult new.
        self run: result.
        ^result
%
category: 'other'
method: GSTestCase
runCase
	| msg pagesBefore pagesAfter cpuTime elapsedTime time cnt cntStr isRO |
	pagesBefore := System pageReads + System pageWrites.
	msg := Time now asStringMs .
	msg add: $   ;
		addAll: self printString;
		addAll:' - start...' .
	GSTestCase log: msg.
  [
	  elapsedTime := Time millisecondsElapsedTime: [
		  cpuTime := System millisecondsToRun: [
			[ super runCase ] ensure: [ self nilTestCaseInstanceVariables ] ].
	  ].
  ] on: Notification do:[:ex | 
    ex class defaultHandlers size > 0 ifTrue:[ ex pass ].
    Error signal: ex asString 
  ].
  cntStr := String new .
  (isRO := GsSession isSolo) ifFalse:[
	  cnt := System persistentCounterAt: 25 incrementBy: 1 .
	  cntStr add: $Z ; addAll: cnt asString .
  ].
	pagesAfter := System pageReads + System pageWrites.
	time := 0 == elapsedTime
		ifTrue: [100]
		ifFalse: [cpuTime * 100s1 / elapsedTime].
	(msg := String new)
		add: 'pass; ';
		add: (pagesAfter - pagesBefore) printString;
		add: ' page(s); ';
		add: 'CPU=';
		add: time printString;
		add: '%; ';
		add: elapsedTime printString;
		add: ' ms. ' .
  isRO ifFalse:[ msg add: ' tranlogMark ' ; add: cntStr  ].
	GSTestCase logCr: msg.
  isRO ifFalse:[ System _markTranlogWith: cntStr ].
%
category: 'other'
method: GSTestCase
sessions
  | tmps | 
  ^ (tmps := SessionTemps current) at:#GSTestCase_sessions ifAbsent:[
    ^ tmps at: #GSTestCase_sessions put: { } .
  ]
%
category: 'other'
method: GSTestCase
setAbortTimeout: sigAbTime
  sigAbTime ~~ 60 ifTrue:[ | systemUser timeStr |
    timeStr := sigAbTime asString .
    (System stoneConfigurationAt: #StnGemAbortTimeoutSeconds) = sigAbTime ifFalse:[
      (systemUser := GsExternalSession newDefault) username: 'SystemUser'; login .
       systemUser executeString:
  'System stoneConfigurationAt: #StnGemAbortTimeoutSeconds put: ', timeStr, ' . 
   System stoneConfigurationAt: #StnGemLostOtTimeout put: ', timeStr, '.' .
       systemUser logout .
      self assert: (System stoneConfigurationAt: #StnGemAbortTimeoutSeconds) equals: sigAbTime .
      self assert: (System stoneConfigurationAt: #StnGemLostOtTimeout) equals: sigAbTime .
    ].
  ]
%
category: 'other'
method: GSTestCase
setUp
  super setUp.
  SessionTemps current at:#GSTestCase_sessions put: { } 
%
category: 'other'
method: GSTestCase
should: aBlock
  "reimplement to catch any unexpected exceptions"
  [ 
    self assert: aBlock value 
  ] onException: AbstractException do:[:ex |
    self assert: false description: 'unexpected exception'
  ]
%
category: 'other'
method: GSTestCase
should: aBlock raise: anObject 

 ^ self should: aBlock raise: anObject description:''
%
category: 'other'
method: GSTestCase
should: aBlock raise: anObject description: descString

	| expectedErrorNumber expClass |
	
	anObject _isInteger 
		ifTrue: [	expectedErrorNumber := anObject] 
		ifFalse: [
			anObject _isSymbol  
				ifTrue: [expectedErrorNumber := ErrorSymbols at: anObject] 
				ifFalse: [
					^(anObject isBehavior and: [anObject isSubclassOf: AbstractException])
						ifTrue: [self should: aBlock raiseClasses: anObject numbers: #() description: descString] 
						ifFalse: [super should: aBlock raise: anObject]
			]		
	].	
	
	(expClass := Exception legacyNumberToClasses: expectedErrorNumber) ifNil:[
		^self assert: false description: 'invalid error number' 
	].
	self 
		should: aBlock 
		raiseClasses: expClass 
		numbers: (Array with: expectedErrorNumber) 
		description: descString
%
category: 'other'
method: GSTestCase
should: aBlock raiseClasses: expClass numbers: expectedErrorNumbers description: descString
  "expClass is either a Class or an Array of Classes."
  
	| saveEx success exString actualErrorNumber |
	saveEx := nil . "force method temps here for debugging"
	actualErrorNumber := nil .
	exString := ' no exception raised ' .
	success := false .
  
	self isValidException: expClass.
	[
	  aBlock onException: expClass do: [:ex | 
		saveEx := ex . "for debugging"
		actualErrorNumber := ex number.
		exString := ex description , ' (' , actualErrorNumber printString , ')'.
		success := true 
			or: [expectedErrorNumbers isEmpty 
			or: [expectedErrorNumbers includes: actualErrorNumber]]].
	] onException: AbstractException do: [:ex |
		saveEx := ex .
		actualErrorNumber := ex number.
		exString := ex description , ' (' , actualErrorNumber printString , ')'.
		[
			(GsCurrentSession currentSession resolveSymbol:#GciError)  ifNotNil: [ :assoc |
				ex class == assoc _value 
					ifTrue:[
						success 
							ifFalse: [success := ex matchesClasses: expClass]. 
				]
			]
		] onSynchronous: AbstractException do: [:exb |  exb return "ignore"].
     
		"do the assert inside handler, so original signal  point still on the stack!"
		self 
			assert: success 
			description: 'Expected ', expClass printString , 
				' (' , expectedErrorNumbers printString , ') ' , 
				descString , ', GOT ' , exString.
		^self "if execution continued..."
	].
	self 
		assert: success 
		description: 'Expected ', expClass printString , 
			' (' , expectedErrorNumbers printString , ') ' , 
			descString , ', GOT ' , exString.
%
category: 'other'
method: GSTestCase
should: aBlock raiseOneOf: anArray 

  "anArray should be an Array of Integers or error symbols or exception classes "
  | expClasses expNumbers |
  expClasses := { } .
  expNumbers := { } .
  anArray do:[:elem | | errNum aClass |
     elem _isSymbol ifTrue:[ 
       errNum := ErrorSymbols at: elem 
     ] ifFalse:[ 
       elem _isInteger ifTrue:[ 
         errNum := elem .
         expNumbers add: errNum .
       ] ifFalse:[
         (elem isBehavior and:[ elem isSubclassOf: Exception]) ifTrue:[ 
            aClass := elem
         ] ifFalse:[
            ^ self assert: false description: 'invalid element in arg raiseOneOf:'
     ]]].
     aClass ifNil:[ (aClass := Exception legacyNumberToClasses: errNum) ifNil:[
       ^ self assert: false description: 'invalid error number' 
     ]].
     aClass _isArray ifTrue:[ expClasses addAll: aClass ]
       ifFalse:[ expClasses add: aClass ]. 
  ].
  self should: aBlock raiseClasses: expClasses numbers: expNumbers description: ''
%
category: 'other'
method: GSTestCase
shouldRepeatIfInterruptedByGC

	^false.
%
category: 'Accessing'
method: GSTestCase
signalFailure: aString
        GSTestResult failure sunitSignalWith: aString
%
category: 'other'
method: GSTestCase
smFloatLiteralClass 
^ 1.0 class .

%
category: 'other'
method: GSTestCase
smFloatResultClass 
^ (1.0 + 1.0) class
%
category: 'other'
method: GSTestCase
tearDown
  | sessions |
  sessions := SessionTemps current removeKey: #GSTestCase_sessions ifAbsent:[ #() ].
  sessions size > 1 ifTrue:[ "fastest logout of many sessions"
    1 to: sessions size do:[:j | | sess |
      (sess := sessions at: j ) ifNotNil:[
        sess isLoggedIn ifFalse:[ sess := nil ].
        sess ifNotNil:[ 
          [
            sess isCallInProgress ifTrue:[ sess forceLogout . sess := nil ] 
                                 ifFalse:[ sess nbLogout ].
          ] on: GciError do:[:ex | ex originalNumber == 4100 ifTrue:["ignore invalid session"] 
                                          ifFalse:[ ex pass ]].
        ].
      ].
      sessions at: j put: sess.
    ].
    sessions do:[:aSess | aSess ifNotNil:[ aSess _waitForLogout ]].
  ] ifFalse:[
    sessions do: [:each | each ifNotNil:[ each forceLogout ] ].
  ].
  super tearDown.
%
category: 'other'
method: GSTestCase
untrappableError

" Send this message for debugging the test framework,
  so you can get a stack with no trapping of the error by the test framework.
  Error 6004 (HardBreak) is not trappable by Smalltalk code ."

System signal:6004 args:#() signalDictionary:GemStoneError
%
