!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!=========================================================================

doit
TestSuite subclass: 'GSTestSuite'
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
%

! Remove existing behavior from GSTestSuite
doit
GSTestSuite removeAllMethods.
GSTestSuite class removeAllMethods.
%
! ------------------- Class methods for GSTestSuite
! ------------------- Instance methods for GSTestSuite
category: 'other'
method: GSTestSuite
addAllTestsTo: aList

	tests do: [:each | 
		each addAllTestsTo: aList.
	].
%
category: 'other'
method: GSTestSuite
allTests

	| list |
	list := OrderedCollection new.
	self addAllTestsTo: list.
	^list.
%
category: 'other'
method: GSTestSuite
errorIfDefects

        | result list |
        result := self run.
        (list := result defects) notEmpty ifTrue: [list error: 'Found ' , list size printString , ' defects'].
        ^true.
%
category: 'other'
classmethod: GSTestSuite
firstElementOfNRS

  | firstElement dbfNRS |
      
  firstElement := SystemRepository fileNames at: 1.
  dbfNRS := (firstElement isKindOf: Array)
    ifTrue:  [ firstElement first ] "32-bit has an array of arrays of { extent, replicate}"
    ifFalse: [ firstElement].       "64-bit has an array of strings"
  ^ dbfNRS
%
category: 'other'
classmethod: GSTestSuite
logFilePath

  | path |
  path := './SUnit.log'.
  ^ path .
%
category: 'other'
method: GSTestSuite
run
  | result |
  result := GSTestResult new.
  GSTestCase openSunitLog: #filesystem .
  [self run: result] sunitEnsure: [self resources do: [:each | each reset]].
  GSTestCase flushLog .
  ^result
%
category: 'Running'
method: GSTestSuite
run: aResult

  self tests do: [:each |  "each may be either a TestSuite or a TestCase"
    self sunitChanged: each.
    each run: aResult
  ]
%
category: 'debugging'
method: GSTestSuite
_asExecString: runStr
  | str lf |
  str := String new . lf := Character lf .
  str addAll:'run'; add: lf  .
  self tests do: [:each |
    str addAll: each class name ; addAll: runStr ;
      addAll: ' #'; addAll: each selector ; addAll: ' .'; add: lf 
  ].
  str add: $% ; add: lf .
  ^ str
%

category: 'debugging'
method: GSTestSuite
asDebugString
^ self _asExecString: ' debug: '
%
category: 'debugging'
method: GSTestSuite
asRunString
^ self _asExecString: ' run: '
%

