! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================

expectvalue %String
run
^ GsTlsCredential _newKernelSubclass: #GsTlsPrivateKey
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: nil
%

doit
GsTlsPrivateKey category: 'X509'.
true
%

! Remove existing behavior from GsTlsPrivateKey
removeallmethods GsTlsPrivateKey
removeallclassmethods GsTlsPrivateKey
set class GsTlsPrivateKey
! ------------------- Class methods for GsTlsPrivateKey
classmethod:
comment
^'GsTlsPrivateKey encapsulates a TLS/SSL private key.'
%


category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises and exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver.

 The private key is assumed to not have a passphrase."
 
^ self tls3ArgPrim: 0 with: fileNameString with: nil with: 1
%

category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString withPassphrase: aPf
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. If the PEM file contains multiple keys, only the
 first is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver or if the 
 passphrase is incorrect."
 
^ self tls3ArgPrim: 0 with: fileNameString with: aPf with: 1
%

category: 'Instance Creation'
classmethod:
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.

 Raises an exception if the string is not in PEM format or if the type 
 of object in the PEM string does not match the receiver.

 The private key is assumed to not have a passphrase."
 
^ self tls3ArgPrim: 1 with: aPemString with: nil with: 1
%

category: 'Instance Creation'
classmethod:
newFromPemString: aPemString withPassphrase: aPf
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read.  

 Raises an exception if the string is not in PEM format or if the type 
 of object in the PEM string does not match the receiver or if the 
 passphrase is incorrect."

^ self tls3ArgPrim: 1 with: aPemString with: aPf with: 1
%

category: 'Class Membership'
classmethod:
speciesForPublicKey
  ^ GsTlsPublicKey
%

category: 'Class Membership'
method:
speciesForPublicKey
  ^ self class speciesForPublicKey
%

category: 'Testing'
method:
isPrivateKey
 ^ true
%
category: 'Testing'
method:
isPublicKey
 ^ false
%
category: 'Testing'
method:
isX509Certificate
 ^ false
%

category: 'Testing'
method:
canCreateDigitalSignatures
^ self supportsDigitalSignatures
%

category: 'Testing'
method:
canVerifyDigitalSignatures
"Only public keys and certificates may be used to verify signatures."
^ false
%
category: 'Private'
method:
_validateIsRsaPss
^ self sslAlgorithm == #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: expected an RSS_PSS private key']
%
category: 'Private'
method:
_validateIsNotRsaPss
^ self sslAlgorithm ~~ #EVP_PKEY_RSA_PSS
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key type: illegal RSS_PSS private key']
%
category: 'Private'
method:
_validateIsRsa
^ self algorithm == #RSA
    ifTrue:[ true ]
   ifFalse:[ CryptoError signal: 'Incorrect key algorithm: expected an RSA private key']
%

category: 'Converting'
method:
asPublicKey
"Answers a new object which represents the public key for the receiver.
 The class of the new instance is the result of the message 
 #speciesForPublicKey, which is GsTlsPublicKey by default"
 
^ self tls1ArgInstPrim: 1 with: self speciesForPublicKey
%

category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString withPassphraseFile: aPfFile
"Reads data from the given file name in PEM format and the passphrase from 
 the text file aPfFile, then creates a new instance of the receiver.
 If the PEM file contains multiple keys, only the first key is read.

 Raises an exception if the file is not in PEM format or if
 the type of object in the file does not match the receiver or if 
 aPfFile does not exist or cannot be read."
 
^ self tls3ArgPrim: 5 with: fileNameString with: aPfFile with: 1
%

category: 'Instance Creation'
classmethod:
newFromPemString: aPemString withPassphraseFile: aPfFile
"Creates a new instance of the receiver based on the PEM string. If the PEM
 string contains multiple keys, only the first is read. Reads the passphrase
 from the file aPfFile.

 Raises an exception if the string is not in PEM format, if the type 
 of object in the PEM string does not match the receiver, if the 
 passphrase is incorrect, or if aPfFile does not exist or cannot
 be read."

^ self tls3ArgPrim: 6 with: aPemString with: aPfFile with: 1
%
