expectvalue %String
run
^ Array _newKernelSubclass: #GsX509CertificateChain
  instVarNames: #()
  classVars: #()
  classInstVars: #()
  poolDictionaries: { }
  inDictionary: Globals
  options: #()
  reservedOop: nil
%


doit
GsX509CertificateChain category: 'X509'.
true
%


! Remove existing behavior from GsX509CertificateChain
removeallmethods GsX509CertificateChain
removeallclassmethods GsX509CertificateChain
set class GsX509CertificateChain
! ------------------- Class methods for GsX509CertificateChain



input $upgradeDir/tlsclassprim.gs

classmethod:
comment
^'GsX509CertificateChain encapsulates a TLS/SSL certificate chain. '
%

category: 'Class Membership'
classmethod:
certificateSpecies

^ GsX509Certificate
%

category: 'Instance Creation'
classmethod:
newFromPemFile: fileNameString
"Reads data from the given file name in PEM format and creates a new instance
 of the receiver. All certificates in the given file are loaded in same order
 as they appear in the PEM file.

 Raises an exception if the file is not in PEM format."
 
^ self tls3ArgPrim: 2 with: fileNameString with: self certificateSpecies with: 3
%


category: 'Instance Creation'
classmethod:
newFromPemString: aPemString
"Creates a new instance of the receiver based on the PEM string. 
 All certificates in the given file are loaded in same order
 as they appear in the PEM string.

 Raises an exception if the string is not in PEM format."
 
^ self tls3ArgPrim: 3 with: aPemString with:  self certificateSpecies with: 3
%

category: 'Converting'
method:
asPemString

|sz result|
sz := self size.
(sz == 1)
  ifTrue:[ ^ (self at: 1) asPemString] .

result := String new.
1 to: sz do:[:n| result addAll: (self at: n) asPemString ].
^ result
%

