!=========================================================================
! Copyright (C) GemTalk Systems 2008-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   IO, Object 
!  
!=========================================================================

set class IO

removeallmethods 
removeallclassmethods 

category: 'For Documentation Installation only'
classmethod: 
installDocumentation

self comment:
'IO is the superclass of both GsFile and GsSocket.  

 The fileDescriptor instVar represents a server file descriptor (of the gem process).
 It will be -1 in instances of GsFile which represent client files.

 The lineNumber instVar was maintained by Ruby gets  methods .

Constraints:
	fileDescriptor: SmallInteger
	lineNumber: SmallInteger
' .
%

category: 'Private'
classmethod: 
_rememberFileDescriptor: anInt obj: anObject

" anObject should be a GsFile or GsSocket"
"NOT ENABLED YET
   GsSocket needs additional code to call this method
# | dict temps |
# (anInt _isSmallInteger and:[ anInt >= 0]) ifTrue:[ 
#   temps := SessionTemps current .
#   dict := temps at:#IO_fd_map otherwise: nil.
#   dict == nil ifTrue:[
#     temps at:#IO_fd_map put: (dict := KeySoftValueDictionary new) .
#   ].
#   dict at: anInt put: anObject 
# ].
"
% 

category: 'Private'
classmethod: IO
_forgetFileDescriptor: anInt
"NOT ENABLED YET
# (anInt _isSmallInteger and:[ anInt >= 0]) ifTrue:[
#  temps := SessionTemps current .
#  dict := temps at:#IO_fd_map otherwise: nil.
#  dict ~~= nil ifTrue:[
#    dict removeKey: anInt otherwise: nil .
#  ].
"
% 

category: 'Instance Creation'
classmethod: IO
new
"disallowed"

self shouldNotImplement: #new
%

classmethod: IO
new: aFileDescriptor mode: aString

"Returns an instance of GsFile or GsSocket , or nil if the specified
  file descriptor (a SmallInteger >= 0) is not open.
 
 The Mode string is currently not used.
"

^ nil
"NOT ENABLED YET
# | dict temps |
# temps := SessionTemps current .
# aFileDescriptor _isSmallInteger ifFalse:[ 
#  aFileDescriptor error:'not a legal file descriptor'
# ].
#aFileDescriptor >= 0 ifTrue:[
#  aFileDescriptor <= 2 ifTrue:[
#    ^ GsFile _getStdFile: aFileDescriptor onClient: false
#  ].
#  dict := temps at:#IO_fd_map otherwise: nil.
#  dict ~~ nil ifTrue:[ 
#    ^ dict at: aFileDescriptor otherwise: nil .
#  ]
#].
#^ nil
"
%

category: 'Accessing'
method: 
fileDescriptor

"Returns the SmallInteger file descriptor, or -1 not available"
^  fileDescriptor 
%

