!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

set class MessageNotUnderstood

! no removeall
!  MessageNotUnderstood>>initialize in Exception.gs

category: 'For Documentation Installation only'
classmethod: 
installDocumentation

self comment:
'The class protocol describe the behavior of the value of the global 
named MessageNotUnderstood.

This object is used to as an exception selector to catch failed message 
sends. Message not understood exceptions are resumable so any message 
in this protocol that signal such an exception may ultimately return 
to their sender.

This object is not specifed as an <exceptionSignaler> or an 
<exceptionInstantiator>. It as assumed that message not understood 
exceptions are signaled by the implemention dependent implementaton 
of the message <Object> #doesNotUnderstand:.

The instance protocol describes the behavior of exceptions that are 
signalled if the receiver of a message does not have a method with a 
matching selector.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object
	selector: String
	envId: SmallInteger
	receiver: Object'.
%

category: 'Instance initialization'
method:
receiver: anObject selector: aSymbol args: anArray envId: envIdArg

  "inline super initialize"  
  gsNumber := ERR_MessageNotUnderstood.
  gsResumable := true .
  gsTrappable := true .

  selector := aSymbol .
  envId := envIdArg ifNil:[ 0 ].
  receiver := anObject .
  gsArgs:= anArray .
%

! ---------------------------------------------------------
category: 'Accessing'

method:
message: aFailedMessage

   gsArgs := aFailedMessage arguments .
   selector :=  aFailedMessage selector .
%

method:
receiver
  "Answer the object that was the receiver of the message that failed."

  ^ receiver
%

method:
receiver: anObject
  "Set the object which did not understand the message to be anObject"
    
  receiver := anObject 
%

category: 'Accessing - failedMessage'
method:
arguments

  ^ gsArgs ifNil:[ #() ].
%

method:
arguments: anArray 

  gsArgs := anArray 
%

method:
selector

  ^ selector
%

method:
selector: aSymbol

  selector := aSymbol
%

method:
environmentId
  ^ envId 
%

method:
asString
^ self _description:(
  [ 
   | str |
    (str := String withAll:'a ') add: receiver class name ;
       add: ' does not understand  ' ; add: selector printString .
    envId ~~ 0 ifTrue:[ str add:' (env ' ; add: envId asString; add: $) ].
    str
  ] onException: Error do:[:ex |
    ex return: nil
  ]
)
%

method:
defaultAction
  | result |
  (result := super defaultAction) == self ifFalse:[ ^ result ].

  ^ receiver perform: selector env: envId withArguments: gsArgs
%

category: 'Accessing - compatibility'
method:
gsArguments
  | arr |
  arr :=  { receiver . selector }  .
  gsArgs ifNotNil:[:a | arr add: a ] ifNil:[ arr add: #() ].
  ^ arr
%

