!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
!=========================================================================

removeallmethods Notification
removeallclassmethods Notification

category: 'For Documentation Installation only'
classmethod: Notification
installDocumentation

self comment:
'The class protocol describe the behavior of the global Notification. 
The value of the standard global Notification is a class object that 
conforms to this protocol. The class Notification is explicitly specified 
to be subclassable in a standard conforming program. Conforming 
implementations must implement its behaviors in a non-fragile manner.

The signaled exceptions generated by this type of object conform to 
the protocol <Notification>.

The instance protocol describes the behavior of instances of the class 
Notification. These are used to represent exceptional conditions that 
may occur but which are not considered errors. Actual notification 
exceptions used by an application may be subclasses of this class.

As Notification is explicitly specified to be subclassable, conforming 
implementations must implement its behavior in a non-fragile manner.

Constraints:
	gsResumable: Boolean
	gsTrappable: Object
	gsNumber: SmallInteger
	currGsHandler: GsExceptionHandler
	gsStack: Object
	gsReason: String
	gsDetails: Object
	tag: Object
	messageText: Object
	gsArgs: Object'.
%

category: 'Instance initialization'
method:
initialize

 "subclasses may override but must should    super initialize
  at start of the reimplementation. "

 super initialize .
 resumable := true .
 number := 2487 . 
%

category: 'ANSI - signaledException'
method: Notification
defaultAction
  "No action is taken. The value 'nil' is returned as the value
   of the message that signaled the exception."

  ^nil.
%

