! file  TimeZone2007_2.gs
!
!
run
TimeZone default == nil ifTrue: [
	| old new |
	ObsoleteTimeZone cache keysAndValuesDo: [:key :value |
		old := value.
		old class == ObsoleteTimeZone ifTrue: [
			new := TimeZone fromObsolete: old.
			old become: new.
		].
		TimeZone 
			for: key
			put: old.
	].
	old := ObsoleteTimeZone default.
	old class == ObsoleteTimeZone ifTrue: [
		new := TimeZone fromObsolete: old.
		old become: new.
	].
	TimeZone default: old.
].
true.
%

! Recompile methods to use current rather than default (bug 39497)
! If we do this earlier, then the above replacement of ObsoleteTimeZone 
! results in an error.

category: 'private'
method: DateAndTimeANSI
_secondsLocal: aNumber offset: anObject

	seconds := aNumber.
	anObject == nil ifTrue: [
		offset := self currentTimeZone offsetAtLocal: self.
	] ifFalse: [
		offset  := anObject asSeconds.
	].
	seconds := seconds - offset.
%
category: 'private'
method: DateAndTimeANSI
_secondsUTC: aNumber offset: anObject

	seconds := aNumber.
	anObject == nil ifTrue: [
		offset := self currentTimeZone offsetAtUTC: self.
	] ifFalse: [
		offset  := anObject asSeconds.
	].
%

! Make sure that we have current references in the cache (bug #42485)
run
TimeZone cache do: [:each | each initializeCache].
true
%

! Bug #42474 calls for additional instance variables
! fix 47727
expectvalue %String
run
| res |
(TimeZone instVarNames includes: #'secondsForDst') ifFalse: [
	| oldClass newClass |
    oldClass := TimeZone changeNameTo: #'ObsoleteTimeZone2'.
	Globals at: #'ObsoleteTimeZone2' put: oldClass.
    Globals removeKey: #'TimeZone'.		"Association might be invariant"
    res := TimeZoneInfo 
		_newKernelSubclass: 'TimeZone'
		instVarNames: #( standardPrintString dstPrintString dstStartTimeList
						dstEndTimeList secondsForDst secondsFromGmt yearStartDst)
		classVars: #()
		classInstVars: #()  "VM dependency, must not define any new civs"
		poolDictionaries: { }
		inDictionary: Globals
		options:#( modifiable )
		reservedOop: nil.
	newClass := Globals at: #'TimeZone'.
	oldClass classHistory newVersion: newClass.
	newClass classHistory: oldClass classHistory.
	oldClass migrateTo: newClass.
] ifTrue: [
  res := '(TimeZone instVarNames includes: #secondsForDST)    was true '
].  
^ res 
%
run
TimeZone immediateInvariant.
true.
%

input $upgradeDir/TimeZone.gs
input $upgradeDir/TimeZone2.gs

run
TimeZone default == nil ifTrue: [
	ObsoleteTimeZone2 cache keysAndValuesDo: [:key :value |
		value class == ObsoleteTimeZone2 ifTrue: [
			value migrate.
		].
		TimeZone 
			for: key
			put: value.
	].
	TimeZone default: ObsoleteTimeZone2 default migrate.
].
true.
%
