!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Definition of TimeZoneTransition (from TimeZone2007.gs)
!
!=========================================================================

set class TimeZoneTransition

removeallmethods 
removeallclassmethods 

! ------------------- Class methods for TimeZoneTransition
! ------------------- Instance methods for TimeZoneTransition
category: 'For Documentation Installation only'
classmethod: TimeZoneTransition
installDocumentation

self comment:
'Instances of this class represent records in a ZoneInfo database.
It describes characteristics of a transition to/from DST.'.
%

category: 'other'
method: TimeZoneTransition
= aTimeZoneTransition

	^(aTimeZoneTransition isKindOf: TimeZoneTransition)
		and: [self transitionTimeUTC	= aTimeZoneTransition transitionTimeUTC
		and: [self offsetFromUTC 		= aTimeZoneTransition offsetFromUTC
		and: [self isDST 					= aTimeZoneTransition isDST
		and: [self abbreviation 		= aTimeZoneTransition abbreviation]]]].
%
category: 'other'
method: TimeZoneTransition
hash

	^transitionTime hash.
%
category: 'other'
method: TimeZoneTransition
abbreviation

	^abbreviation.
%
category: 'other'
method: TimeZoneTransition
asDateAndTimeUTC

	^DateAndTime 
		posixSeconds: transitionTime
		offset: Duration zero.
%
category: 'other'
method: TimeZoneTransition
isDST

	^isDST.
%
category: 'other'
method: TimeZoneTransition
localTimeTypeID: anInteger
	"Borrow the offsetFromUTC instance variable for a moment"

	offsetFromUTC := anInteger.
%
category: 'other'
method: TimeZoneTransition
offsetFromUTC

	^offsetFromUTC.
%
category: 'other'
method: TimeZoneTransition
printOn: aStream

	| dt duration |
	duration := Duration seconds: offsetFromUTC.
	dt := DateAndTime 
		posixSeconds: transitionTime
		offset: duration.
	dt printOn: aStream.
	aStream space.
	duration printOnHoursMinutes: aStream.
	aStream space.
	abbreviation printOn: aStream.
%
category: 'other'
method: TimeZoneTransition
transitionTime: anInteger

	transitionTime := anInteger.
%
category: 'other'
method: TimeZoneTransition
transitionTimeLocal

	^transitionTime + offsetFromUTC.
%
category: 'other'
method: TimeZoneTransition
transitionTimeUTC

	^transitionTime.
%
category: 'other'
method: TimeZoneTransition
typeList: anArray

	| data |
	data := anArray at: offsetFromUTC.	"temporary use as localTimeTypeID"
	offsetFromUTC := data at: 1.				"now used for its named purpose"
	isDST := data at: 2.
	abbreviation := data at: 3.
%
