!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: TranscriptStreamPortable.gs 25549 2011-03-24 21:51:57Z jfoster $
!
! Based on ANSI spec
!
! Superclass Hierarchy:
!   TranscriptStreamPortable, Stream, Object.
!
! See installStreamHierarchy.topaz for filein information
!
!=========================================================================

! class created by installStreamHierarchy.topaz

removeallmethods TranscriptStreamPortable
removeallclassmethods TranscriptStreamPortable


! ------------------- Class methods for TranscriptStreamPortable
doit
TranscriptStreamPortable comment: '
 ANSI compliant implementation of Transcript.

 Sending stream protocol such as nextPut: or nextPutAll: causes the characters 
 to be cached in a session-specific WriteStream, avoiding conflicts.

 On flush or show:, the contents of the WriteStream are written to the sessions
 log on the server via GsFile class>>gciLogServer:
'.
true
%
category: 'initialization'
set compile_env: 0
classmethod: TranscriptStreamPortable
initialize
	"self initialize"
	
	Globals at: #Transcript put: self new.
	 "world write permission"
	(Globals associationAt: #Transcript) objectSecurityPolicy: nil
%
! ------------------- Instance methods for TranscriptStreamPortable
category: 'Character writing'
set compile_env: 0
method: TranscriptStreamPortable
crlf
"Append a carriage return character followed by a line feed character to the receiver."

self nextPut: Character cr; nextPut: Character lf
%
category: 'Character writing'
set compile_env: 0
method: TranscriptStreamPortable
crtab
"Append a return character, followed by a single tab character, to the 
receiver."

self nextPut: Character cr.
self nextPut: Character tab
%
category: 'Character writing'
set compile_env: 0
method: TranscriptStreamPortable
crtab: anInteger 
"Append a return character, followed by anInteger tab characters, to the 
receiver."

self nextPut: Character cr.
anInteger timesRepeat: [self nextPut: Character tab]
%
category: 'private'
set compile_env: 0
method: TranscriptStreamPortable
endEntry

	self mutex critical: [ | contents |
		contents := self stream contents.
		self stream reset.
		(contents size > 1 and: [ (contents at: 1) = Character lf])
			ifTrue: [ 
				"gciLogServer tacks a lf on end of previous contents"
				contents := contents copyFrom: 2 to: contents size].
		GsFile gciLogServer: contents ].
%
category: 'ANSI'
set compile_env: 0
method: TranscriptStreamPortable
flush

	self endEntry
%
category: 'private'
set compile_env: 0
method: TranscriptStreamPortable
mutex
	| tmps |   
	tmps := SessionTemps current  .
	^ (tmps at: #TranscriptStream_SessionMutex otherwise: nil)
	     ifNil:[ tmps at: #TranscriptStream_SessionMutex 
			put: Semaphore forMutualExclusion ]
%
category: 'Adding'
set compile_env: 0
method: TranscriptStreamPortable
nextPut: anObject

	self mutex critical: [ ^self stream nextPut: anObject ]
%
category: 'Adding'
set compile_env: 0
method: TranscriptStreamPortable
nextPutAll: aCollection

	self mutex critical: [ ^self stream nextPutAll: aCollection ]
%
category: 'Adding'
set compile_env: 0
method: TranscriptStreamPortable
show: anObject

	self nextPutAll: anObject printString.
	self endEntry
%
category: 'Character writing'
set compile_env: 0
method: TranscriptStreamPortable
space: anInteger 
"Append anInteger space characters to the receiver."

anInteger timesRepeat: [self space]
%
category: 'private'
set compile_env: 0
method: TranscriptStreamPortable
stream

	| tmps |   
	tmps := SessionTemps current  .
	^( tmps at: #'TranscriptStream_SessionStream' otherwise: nil)
		ifNil:[ tmps at: #'TranscriptStream_SessionStream' 
				put: (WriteStream on: String new) ] 
			
%
category: 'Character writing'
set compile_env: 0
method: TranscriptStreamPortable
tab: anInteger 
"Append anInteger tab characters to the receiver."

anInteger timesRepeat: [self tab]
%
category: 'Adding'
set compile_env: 0
method: TranscriptStreamPortable
_nextPut: anObject
"see PrintStream>>_nextPut:"

self nextPut: anObject
%

!Install Transcript global
doit
TranscriptStreamPortable initialize.
true
%

