!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Description - 
!  Final changes to kernel classes and reserved objects during filein.
!
!  Not Used during repository conversion
!=========================================================================

!  define btreePlusIndex as default GsIndexOptions for 3.4.0
expectvalue true
run
GsIndexOptions default: GsIndexOptions btreePlusIndex + GsIndexOptions optimizedComparison.
^ true
%

!input all the changes that are used only during upgrades.
input $upgradeDir/bomlastconv.gs

! ===================================================================
! create instances of new class ClusterBucket
expectvalue 0
run
  "Expect SmallInteger 0"
^ AllClusterBuckets size
%

level 0
run
System currentObjectSecurityPolicy: DataCuratorObjectSecurityPolicy.
  "Cluster bucket 1"
  (ClusterBucket new) 
    description: 'Generic bucket 1. The default bucket after login.' ;
    immediateInvariant  "This bucket may not be changed".

  "Cluster bucket 2"
  (ClusterBucket new) description: 'Generic bucket 2' .

  "Cluster bucket 3"
  (ClusterBucket new) description: 'Generic bucket 3' .

  "Cluster bucket 4"
  (ClusterBucket new) description: 'Kernel classes behavior bucket' .

  "Cluster bucket 5"
  (ClusterBucket new) description: 'Kernel classes description bucket' .

  "Cluster bucket 6"
  (ClusterBucket new) description: 'Kernel bucket for AllSymbols and other kernel objects' .

  "Cluster bucket 7"  
  "  provided so the maximum clusterId returns a generic bucket in the
     GemStone kernel for compatibility with prior releases"
  (ClusterBucket new) description: 'Generic bucket 7' .

^ AllClusterBuckets size == 7 "expect result == true "
%

commit

expectvalue false
run
"  now cluster AllClusterBuckets, which must be in the default cluster bucket"
AllClusterBuckets clusterInBucket: 1.
%

commit

run
System currentObjectSecurityPolicy: SystemObjectSecurityPolicy .
^ true
%

!------------------------------------------------------------
! set timestamp , userId, etc on classes that were created in bom.c
method: Class
instVar: aSymbol put: aValue
self _unsafeAt: (self class _ivOffsetOf: aSymbol) put: aValue
%

run
| classes epoch |
System currentObjectSecurityPolicy: SystemObjectSecurityPolicy .
epoch :=  DateTime now  .
classes := Array new .
Globals valuesDo:[ :aValue|
  (aValue isKindOfClass: Class) ifTrue:[ classes add: aValue].
].

classes do:[ :aClass |
  aClass timeStamp == nil ifTrue:[
                                        "do not alter description , fix 36429"
    aClass instVar: #timeStamp put: epoch .
    aClass instVar: #userId put: 'SystemUser'.
    "let extraDict be created as needed by setters"
    "classHistory initialized by bom.c / repository conversion "
    "destClass instance variable left as nil "
  ].
].
^ true
%

run
Class removeSelector: #instVar:put: ifAbsent:[ nil ] .
^ true
%


!------------------------------------------------------------
! create security data dictionary and userId dictionary on AllUsers
run
AllUsers _initialize  .
^ true
%
commit

! Migration of groups moved to bomlastconv.gs

!------------------------------------------------------------
! Deleted: Add the SharedDependencyLists so that they are treated as weak references 
!------------------------------------------------------------

!-------------
! removal of _unsafesetoop method done later in filein
 
! end of bomlast.gs

