!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Description - Create reserved objects from Smalltalk, that are 
!   newly created in gemstone64. These are objects that may be created
!   directly in the target repository, if in repository conversion.
! 
! Repository conversion uses this file.
!
!=========================================================================


! install the method required for kernel class creation of classes with
! reserved OOPs
!
category: 'Repository Conversion'
method: Object
_unsafeSet11Oop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v1.1 OopType" 

  <primitive: 385>
  ^ self _primitiveFailed: #_unsafeSet11Oop: args: { aPositiveInteger }
%

category: 'Repository Conversion'
method: Object
_unsafeSetOop: aPositiveInteger

  "aPositiveInteger must be the integer value of a gs64v2.x OopType" 

  <primitive: 535>
  ^ self _primitiveFailed: #_unsafeSetOop: args: { aPositiveInteger }
%

! fix 32731, _objectForOop now in image

!  fix 31162 , added new privilege #CodeModification and
!     removed rename obsolete privleges as #Obsolete<priv>
!
! 41804 - add #CompilePrimitives privlege.
!
! fixed 42198 - changed FedAdminPrivilege to PrivUnused5
run
UserProfile _classVars
    at: #PrivilegeNames
	put:
           #(#SystemControl #ObsoleteStatistics #SessionAccess #UserPassword
	     #DefaultObjectSecurityPolicy #PrivUnused5 #OtherPassword
	     #ObjectSecurityPolicyCreation #ObjectSecurityPolicyProtection #FileControl
	     #GarbageCollection #CodeModification
             #NoPerformOnServer #NoUserAction 
	     #NoGsFileOnServer #NoGsFileOnClient 
             #SessionPriority #CompilePrimitives #ChangeUserId ) ;
    at: #InversePrivileges put:
	#( NoPerformOnServer NoUserAction NoGsFileOnServer NoGsFileOnClient ).
^ true
%

expectvalue %String
run
| str |
str := String new .
{ 211969  "NscNode".
  212225  "NscInteriorNode".
  212481  "NscSetLeaf".
  212737  "NscBagLeaf".
  209409  "LargeObjectNode".
  245761  "Large2ByteLeaf".
  246017  "Large4ByteLeaf".
  246273  "Large8ByteLeaf" } do:[:anOop | | cls key |
    cls := Object _objectForOop: anOop . 
    cls removeAllMethods .
    cls class removeAllMethods .
    (Globals includesKey: (key := cls name)) ifTrue:[
      " remove Associations of private classes from Globals"
      Globals removeKey: key .
      str add: 'removed ' , key ; lf .
    ]
  ].
^ str
%

