!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id: canonstringdict_old.gs 24011 2010-08-10 22:28:58Z otisa $
!
!   CanonicalStringDictionary is the old (32-bit GemStone/S) class of 
!      AllSymbols.  In GS/64, AllSymbols is a CanonSymbolDict.
!
! Superclass Hierarchy:
!   CanonicalStringDictionary, StringKeyValueDictionary, 
!   KeyValueDictionary, AbstractDictionary, Collection, Object.
!
!=========================================================================

removeallmethods CanonicalStringDictionary
removeallclassmethods CanonicalStringDictionary

category: 'For Documentation Installation only'
classmethod: CanonicalStringDictionary
installDocumentation

self comment:
'A CanonicalStringDictionary is a StringKeyValueDictionary that provides
 protocol that is similar to Set in addition to its dictionary protocol.
 This is the old (32-bit GS/S) class of AllSymbols.

Constraints:
	numElements: SmallInteger
	numCollisions: SmallInteger
	collisionLimit: SmallInteger
	tableSize: SmallInteger' .
%

category: 'Hashing'
method: CanonicalStringDictionary
hashFunction: aKey

"The hash function performs an operation on the value of the
 key (aKey) and returns a value in the range 1..tableSize."

^((self _hashOfKey: aKey) \\  self tableSize) + 1
%

category: 'Private'
method: CanonicalStringDictionary
compareKey: key1 with: key2

"Returns whether key1 is equivalent to key2."

 key1 == key2 ifTrue:[ ^ true ].

 (key1 _isSymbol ~~ key2 _isSymbol) 
    ifTrue:[ ^ key1 asString = key2 asString ]
   ifFalse:[ ^ key1 = key2 ].
%

category: 'Updating'
method: CanonicalStringDictionary
addAssociation: anAssociation

"Add the argument anAssociation to the receiver."

^ super add: anAssociation
%

category: 'Updating'
method: CanonicalStringDictionary
addAll: aCollection

"Adds elements of aCollection to the receiver. Returns aCollection."

aCollection == self ifTrue:[ ^ aCollection ].
(aCollection isKindOf: AbstractDictionary) 
  ifTrue:[ ^ super addAll: aCollection].
aCollection accompaniedBy: self do:[ :me :aString | me add: aString ].
^ aCollection
%

category: 'Updating'
method: CanonicalStringDictionary
remove: aString

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, generates an error."

^ self removeKey: aString
%

category: 'Updating'
method: CanonicalStringDictionary
remove: aString ifAbsent: aBlock

"Removes aString if present in the receiver and returns the removed value.  If
 aString is not present, returns the result of evaluating the zero
 argument Block aBlock."

^ self removeKey: aString ifAbsent: aBlock
%

category: 'Updating'
method: CanonicalStringDictionary
add: aString

"Adds aString if it is not already present in the receiver, and returns
 either aString or the canonical string already present."

| aValue |
(aString isKindOf: String) ifTrue:[
  aValue := self at: aString otherwise: nil .
  aValue == nil ifTrue:[
    aString immediateInvariant .
    self at: aString put: aString .
    ^ aString
    ].
  ^ aValue
  ].
"assume aString is an Association."
^ super add: aString  
%

category: 'Accessing'
method: CanonicalStringDictionary
includes: aString

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil
%

category: 'Accessing'
method: CanonicalStringDictionary
includesValue: aString

"Returns true if the receiver contains aString as a key, false otherwise."

| aValue |
aValue := self at: aString otherwise: nil .
^ aValue ~~ nil
%

category: 'Accessing'
method: CanonicalStringDictionary
_validateGroupString: aString

| aValue |
aValue := self at: aString otherwise: nil .
aValue == nil ifTrue:[ 
  aString _error: #segErrBadGroup .
  ^ nil
].
^ aValue
%

category: 'Repository Conversion'
method: CanonicalStringDictionary
_migrateSymbolSet: aSymbolSet

"Using the receiver as the canonicalization dictionary, migrate aSymbolSet
 to an IdentitySet of canonical Strings, and return the IdentitySet."

| newSet |

((aSymbolSet isKindOf: SymbolSet) or:[
   aSymbolSet isKindOf: (Globals at:#ObsoleteSymbolSet
                                ifAbsent:[ ObsoleteClasses at: #ObsoleteSymbolSet ])])
  ifTrue:[
  newSet := IdentitySet new .
  aSymbolSet do:[ :aSym | | aStr groupStr |
    aStr := String withAll: aSym .
    groupStr := self add: aStr .
    newSet add: groupStr .
    ].
  newSet objectSecurityPolicy: aSymbolSet objectSecurityPolicy .
  ^ newSet 
  ].

^ aSymbolSet
%
category: 'Testing'
method: 
_isLarge

"Returns true if the object is implemented as a tree of private smaller objects"

^ true 
%
