expectvalue %String
run
^((Globals at: #DeletedUserProfile otherwise: nil) ~~ nil)
    ifTrue:['DeletedUserProfile class already exists']
    ifFalse:[
       Object _newKernelSubclass: 'DeletedUserProfile'
         instVarNames: #( userId symbolList whenDeleted)
         classVars: #()
         classInstVars: #( )
         poolDictionaries: { }
         inDictionary: Globals
         options: #() 
         reservedOop: nil .
      'Created class DeletedUserProfile'] .
%

! Remove existing behavior from DeletedUserProfile
doit
DeletedUserProfile removeAllMethods.
DeletedUserProfile class removeAllMethods.
true
%
! ------------------- Class methods for DeletedUserProfile
category: 'For Documentation Installation only'
classmethod: DeletedUserProfile
installDocumentation

self comment:
'DeletedUserProfile holds the key information about a UserProfile that was deleted from AllUsers.  
An instance is created and added to AllDeletedUsers when methods such as UserProfileSet>>removeAndCleanup:, 
removeAndCleanupUserWithId:ifAbsent:, etc., are executed.

A DeletedUserProfile refers to the SymbolList of the deleted user, since that is needed to reach data that 
was referred to by the deleted user.  After a UserProfile is removed, the DeletedUserProfile should be examined
for references to data that may need to be cleaned up so they can be garbage collected.'.
%

category: 'Instance Creation'
classmethod: DeletedUserProfile
createFrom: aUserProfile

| result |
result := self new .
result userId: aUserProfile userId copy.
result symbolList: aUserProfile symbolList .
result whenDeleted: DateTime now .
^ result
%
! ------------------- Instance methods for DeletedUserProfile
category: 'Accessing'

method: DeletedUserProfile
symbolList

   "Return the value of the instance variable 'symbolList'."
   ^symbolList
%
category: 'Updating'
method: DeletedUserProfile
symbolList: newValue

   "Modify the value of the instance variable 'symbolList'."
   symbolList := newValue
%
category: 'Accessing'
method: DeletedUserProfile
userId

   "Return the value of the instance variable 'userId'."
   ^userId
%
category: 'Updating'
method: DeletedUserProfile
userId: newValue

   "Modify the value of the instance variable 'userId'."
   userId := newValue
%
category: 'Accessing'
method: DeletedUserProfile
whenDeleted

   "Return the value of the instance variable 'whenDeleted'."
   ^whenDeleted
%
category: 'Updating'
method: DeletedUserProfile
whenDeleted: newValue

   "Modify the value of the instance variable 'whenDeleted'."
   whenDeleted := newValue
%
