! ========================================================================
! Copyright (C) by GemTalk Systems 1991-2020.  All Rights Reserved
!
! $Id$
!
! ========================================================================
removeallmethods DoubleByteSymbol
removeallclassmethods DoubleByteSymbol
set class DoubleByteSymbol

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'A DoubleByteSymbol is an invariant String for which all comparisons are
 case-sensitive.  DoubleByteSymbols are used internally to represent variable
 names and selectors.  DoubleByteSymbols are always invariant and cannot be
 modified at any time after they are created.  Hence, the new and new: methods
 are disallowed.

 All Symbols and DoubleByteSymbols are canonical, which means that it is not
 possible to create two of them that have the same value.  If two canonical
 symbols compare as equal, then they are the same (identical) object.  Every
 instance of DoubleByteSymbol will contain at least one Character whose value is
 greater than 255.  A Symbol whose Character values are all less than 256 is
 always an instance of Symbol.

 GemStone does permit you to commit a canonical Symbol.
 GemStone also gathers
 all canonical symbols into one collection (a CanonicalStringDictionary) called
 AllSymbols.

 Since canonical symbols are universally visible, it is not recommended that 
 they be used for names that should remain private or secure.  Such objects
 should be instances of InvariantString instead.

 Since canonical symbols must be universally available, you cannot lock a
 Symbol or DoubleByteSymbol.

 Since each canonical symbol has a unique value, you cannot copy a Symbol or
 DoubleByteSymbol.  In addition, to guarantee canonicalization, you cannot send
 the become: or changeClassTo: messages to a Symbol or DoubleByteSymbol.

 For historical reasons dealing with the now-deprecated constraints, 
 DoubleByteSymbol is in the ClassHistory of Symbol.

 EUCSymbols are not canonicalized and cannot be used interchangeably with
 canonical symbols.  They do not satisfy a constraint of Symbol, and are not
 accepted by the virtual machine as message selectors.' .
%

! ------------------- Class methods for DoubleByteSymbol
category: 'Instance Creation'
classmethod:
new

"Disallowed.  To create a new DoubleByteSymbol, use the class method 
 #withAll: instead."

self shouldNotImplement: #new
%

category: 'Instance Creation'
classmethod:
migrateNew

"Override default migrateNew behavior with #_basicNew."

^ self _basicNew
%

category: 'Instance Creation'
classmethod:

new: size

"Disallowed.  To create a new DoubleByteSymbol, use the class method #withAll: 
 instead."

self shouldNotImplement: #new:
%
classmethod:
_basicNew
^ self shouldNotImplement: #_basicNew
%
classmethod:
_basicNew: aSize
^ self shouldNotImplement: #_basicNew:
%

! edits for 41699
category: 'Instance Creation'
classmethod:
withAll: aString

"Returns a canonical symbol that has the same Characters as aString."

<primitive: 300> 
^ Symbol withAll: aString
%

category: 'Instance Creation'
classmethod:
_existingWithAll: aString

"Return an existing canonical symbol that has the same value as 'aString'.  
 If no such Symbol or DoubleByteSymbol already exists, returns nil."

<primitive: 310>
^ Symbol _existingWithAll: aString
%

category 'Instance Creation'
classmethod:
_newString

"Return a new instance of DoubleByteString."

^ DoubleByteString new
%

category 'Instance Creation'
classmethod:
_newString: aSize

"Return a new instance of DoubleByteString of the specified size."

^ DoubleByteString new: aSize
%

! ------------------- Instance methods for DoubleByteSymbol
category: 'Comparing'
method:
= anObject

"Returns true if anObject is equal to the receiver.  Since symbols 
 are canonicalized, this method does the check based on the 
 identities of the receiver and the argument."

^ self == anObject. 
%
category: 'Comparing'
method:
~= aCharCollection

"This method can be optimized for symbols since they are canonical."

^ self ~~ aCharCollection
%

category: 'Converting'
method:
asDoubleByteString

"Returns a copy of the receiver as a DoubleByteString."

^ DoubleByteString withAll: self.
%

category: 'Converting'
method:
asString

"Returns a copy of the receiver as a String."

^ String withAll: self.
%

category: 'Converting'
method:
asSymbol

"Returns the receiver.  All Symbols and DoubleByteSymbols are canonical."

^ self
%

category: 'Converting'
method:
asSymbolKind

"Returns the receiver.  All Symbols and DoubleByteSymbols are canonical."

^ self
%

category: 'Clustering'
method:
cluster

"Has no effect.  Clustering of DoubleByteSymbols is only performed by
 the clusterAllSymbols method in class System . "

^ true
%

category: 'Clustering'
method:
clusterInBucket: aClusterBucketOrId

"Has no effect.  Clustering of Symbols is only performed by
 the clusterAllSymbols method in class System . "

^ true
%


category: 'Copying'
method:
copy

"Returns self.  Copies of (canonical) double byte symbols are not allowed."

^ self
%

method:
copyReplacing: oldObject withObject: newObject
	"Returns a String comprising a copy of the receiver in which all occurrences
	 of objects equal to oldObject have been replaced by newObject."

	^self asDoubleByteString copyReplacing: oldObject withObject: newObject
%

method:
shallowCopy

"Returns self.  Copies of (canonical) double byte symbols are not allowed."

^ self
%

category: 'Concatenating'
method:
, aCharOrCharCollection

"Returns a new instance of DoubleByteString that contains the elements of
 the receiver followed by the elements of aCharOrCharCollection.
 A DoubleByteString is returned rather than a DoubleByteSymbol to avoid 
 the expense of unnecessary creation and canonicalization of Symbols."

| result |

result := DoubleByteString withAll: self .
result  addAll: aCharOrCharCollection.
^ result
%

category: 'Storing and Loading'
classmethod:
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

| theSize str marker result |

"since Symbols can't refer to other objects, the 'hasRead:' message
 may be sent after values have been filled in."

theSize := passiveObj readSize . 
str := String new: theSize .
marker := passiveObj objectPositionMarker .
passiveObj next: theSize bytesTo: str ;  
           next .
result :=  (str _changeClassToMultiByte: DoubleByteString) asSymbol .
passiveObj hasRead: result marker: marker .
^ result
%

category: 'Comparing'
method:
hash

"Returns a numeric hash key for the receiver."

^ self identityHash
%

category: 'Converting'
method:
-> anObject

"Returns a SymbolAssociation with the receiver as the key and the given object
 as the value."

^ SymbolAssociation newWithKey: self value: anObject
%

category: 'Converting'
method:
keywords

"Returns an Array of the keywords in the receiver, treating
 any colon-delimited segment as if it was a legal keyword."

^ Symbol _keywords: self
%


category: 'Class Membership'
method:
species

"Returns a class similar to, or the same as, the receiver's class which
 can be used for containing derived copies of the receiver."

^ DoubleByteString
%

! added based on code inspection , while working on 31257
category: 'Private'
method:
speciesForConversion

^ DoubleByteString .
%

category: 'Formatting'
method:
printOn: aStream

"Puts a displayable representation of the receiver on the given stream.
 That representation conforms to GemStone Smalltalk parsing rules."

aStream nextPut: $# .
super printOn: aStream 
%

category: 'New Indexing Comparison'
method:
_idxForCompareEqualTo: arg

""

^arg _idxForCompareEqualToDoubleByteSymbol: self
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForCompareEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ aCharacterCollection _idxForCompareEqualToDoubleByteSymbol: self
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForSortEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ self asString
    _idxForSortEqualTo: aCharacterCollection
    collator: anIcuCollator
%
category: 'New Indexing Comparison'
set compile_env: 0
method:
_idxForSortNotEqualTo: aCharacterCollection collator: anIcuCollator
  ""

  ^ (self _idxForSortEqualTo: aCharacterCollection collator: anIcuCollator) not
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareEqualToUnicode: aUnicodeString collator: aCollator
"second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:collator:."

  ^ false
%

category: 'Compatiblity'
method:
argumentCount

 ^ self numArgs
%

category: 'Testing'
method:
precedence

"Returns the precedence of the receiver, were it a message selector, with
 1=unary, 2=binary and 3=keyword."

^ self isInfix
    ifTrue: [ 2 ]
    ifFalse: [ self isKeyword ifTrue: [ 3 ]
                              ifFalse: [ 1 ] ]
%

category: 'Formatting'
method:
withNoColons

"Returns a String containing the value of the receiver with all colons removed.

 A String is returned rather than a symbol to avoid the expense of unnecessary 
 creation and canonicalization of symbols."

^ self copyWithout: $:   .
%

category: 'Decompiling without Sources'
method:
_asSource

| result |
result := String new .
result add: $#  .
result addAll: super _asSource .
^ result
%

! removed _decompress, inherit from Object

category: 'New Indexing Comparison'
method: 
_idxForSortEqualTo: arg
  ""

  ^ arg _idxForSortEqualToSymbol: self
%
category: 'New Indexing Comparison'
method: DoubleByteSymbol
_idxForSortEqualToSymbol: aSymbol
  "second half of a double dispatch call from Symbol>>_idxForSortEqualTo:."

  ^ self asString _idxPrimCompareEqualTo: aSymbol asString
%
category: 'New Indexing Comparison - for Compare'
method:
_idxForCompareEqualToCharacterCollection: aCharacterCollection
  "second half of a double dispatch call from CharacterCollection>>_idxForCompareEqualTo:."

  ^ false
%
category: 'Class Membership'
classmethod: 
_classHistoryIncludesIdentical: aClass
  ^ aClass == Symbol or:[ aClass == DoubleByteSymbol or:[ aClass == QuadByteSymbol]]
%
category: 'Class Membership'
classmethod:
isSubclassOf: aClassHistoryOrClass
  
  (self _classHistoryIncludesIdentical: aClassHistoryOrClass) ifTrue:[ ^ true].
  ^ super isSubclassOf: aClassHistoryOrClass
%

