!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   EqualityCollisionBucket, CollisionBucket, AbstractCollisionBucket, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! EqualityCollisionBucket created in bom.c

! remove existing behavior from IdentityCollisionBucket
removeallmethods EqualityCollisionBucket
removeallclassmethods EqualityCollisionBucket
set class EqualityCollisionBucket

category: 'For Documentation Installation only'
classmethod:
installDocumentation

self comment:
'An EqualityCollisionBucket is a CollisionBucket that is used in 
 StringKeyValueDictionary, IntegerKeyValueDictionary, and other
 kinds of KeyValueDictionary using the default hash and key compare
 semantics for equality based dictionaries.  

 Such dictionaries send #hash to keys to obtain the hash value, and 
 send #=  to compare two keys.  They do not use  #hashFunction: and 
 #compareKey:with:  methods.  

Constraints:
	numElements: SmallInteger
	keyValueDictionary: Object' .
%

category: 'Private'
method:
compareKey: key1 with: key2

"Not used by implementation of EqualityCollisionBucket"

self shouldNotImplement: #compareKey:with:
%

category: 'Searching'
method:
searchForKey: argKey

"Returns the index of argKey, or if not found, nil."
   | idx |
   argKey ifNil:[ ^ self _error: #rtErrNilKey ] .
   idx := 1 .
   1 to: self tableSize do: [ :n | | aKey |
      aKey := self _at: idx . "inline keyAt:"
      aKey ifNotNil:[  
        argKey = aKey ifTrue:[ ^ n ].
      ].
      idx := idx + 2
   ].
   ^ nil "Key not found"
%

method:
at: aKey put: aValue keyValDict_coll: aKeyValDict
 "Stores the aKey/aValue pair in the receiver.
  Returns self size if this at:put: added a new key, 0 if this at:put:
  replaced the value of an existing key."
 | emptySlotIdx startTableSize thisKey numElem |

  startTableSize := self tableSize .
  aKey ifNil:[ ^ self _error: #rtErrNilKey ] .
  (numElem := numElements) == 0 ifTrue:[
    emptySlotIdx := 1
  ] ifFalse:[ | idx |
    "search for aKey, or for the first empty slot "
    idx := 1 .
    1 to: startTableSize do:[:n |
      thisKey := self _at: idx . "inline keyAt:"
      thisKey ifNotNil:[
        (aKey = thisKey) ifTrue:[ "Key found.  Store given value"
          self _at: idx + 1 put: aValue .  "inline at:putValue:"
          aKeyValDict _markDirty .
          ^ 0
        ].
      ] ifNil:[
        emptySlotIdx ifNil:[ emptySlotIdx := idx ].
      ].
      idx := idx + 2 .
    ] .
    "Key not found so add key and value"
    emptySlotIdx ifNil:[ " bucket is full so grow it "
      emptySlotIdx := self _basicSize + 1 .
      self size: emptySlotIdx + 7  .  "accommodate 4 more key,value pairs"
    ] .
  ].
  numElem := numElem + 1 .
  numElements := numElem .
  self _at: emptySlotIdx put: aKey. "inline at:putKey:"
  self _at: emptySlotIdx + 1 put: aValue . "inline at:putValue"
  ^ numElem 
%
