!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
! 
!  additional methods for GsMethod
!
!=========================================================================

run
 "dictionary built later in filein in bomlastconv.gs "
 GsMethod _addClassVar: #ObsoleteClassesDict value: nil . 
 true
%

! edited for 42285
category: 'Repository Conversion'
method: GsMethod
recompileIntoMethodDict: aMethodDict intoCategories: aCategDict

"Recompiles the method for execution in a Gs64 v3.0 or later system.

 Literal variables whose key is in the GsMethod class variable ObsoleteClassesDict
 are replaced by the appropriate association from the ObsoleteClassesDict .
 Other literal variables are looked up in the literal pool of the receiver,
 before searching class variables, class pool dictionaries, or 
 the current symbolList.  Thus recompilation should work without knowing
 what symbolList was used when the receiver was created.   

 The result is a GsNMethod if compilation succeeds, otherwise
 an error is generated.  environmentId zero is used for all compilations.

 If aMethodDict is not nil, and the compilation succeeds,
 the resulting method is added to aMethodDict instead of to
 the receiver's method dictionary.  This is used to add methods
 to per-session dictionaries.

 If aMethodDict is not nil and aCategDict is not nil and
 the compilation succeeds, the resulting method is added aCategDict
 instead of the receiver's categories.

 If the receiver is an anonymous method, the sender of this method is
 reponsible for saving the result."

| cls litVars symAssocCls obsDict newSrc |
litVars := { }  . 
symAssocCls := SymbolAssociation .
obsDict := ObsoleteClassesDict .
literalsOffset to: self size do: [:j | | aLit |
  aLit := self at: j .
  (aLit isKindOf: symAssocCls) ifTrue:[ | litName aVal newLit srcName lookupKey obsArr |
    litName := aLit key .
    (obsArr := obsDict at: litName otherwise: nil) ifNotNil:[ 
      aVal := aLit value .
      (aVal ~~ nil and:[ aVal == (obsArr at:1)]) ifTrue:[ 
         srcName := obsArr at: 2 . 
         lookupKey := obsArr at: 3 .
         newLit := Globals associationAt: lookupKey otherwise: nil .
      ].
    ].
    newLit ifNotNil:[ litVars add: srcName ; add: newLit ] 
           ifNil:[    litVars add: litName ; add: aLit ].
  ]
].
SessionTemps current at:#OldLitVars put: litVars .
newSrc := GsNMethod convertArrayBuildersInString: sourceString  .
cls := self inClass .
cls ifNil:[ 
  ^ newSrc _compileInContext: nil symbolList: nil oldLitVars: litVars
		environmentId: 0 flags: 0
] ifNotNil:[ | categ |
 categ := cls categoryOfSelector: selector . 
  ^ cls _checkCompileResult: ( cls _primitiveCompileMethod: newSrc symbolList: nil 
         category: categ oldLitVars: litVars 
         intoMethodDict: aMethodDict intoCategories: aCategDict
         environmentId: 0 )
       source: newSrc .
]
%

