!=========================================================================
! Copyright (C) GemTalk Systems 2013-2020.  All Rights Reserved.
!
! $Id: idxmethods.topaz 30931 2013-05-29 22:46:30Z otisa $
!
!=========================================================================

expectvalue %Boolean
doit
GsQueryTokenParser comment:
'GsQueryTokenParser is part of the Indexing and Querying subsystem. It implements 
GemStone internals and is not intended for direct use by customers.'.
true
%

! Remove existing behavior from GsQueryTokenParser
removeallmethods GsQueryTokenParser
removeallclassmethods GsQueryTokenParser
! ------------------- Class methods for GsQueryTokenParser
category: 'initialization'
set compile_env: 0
classmethod: GsQueryTokenParser
initialize
        SeparatorPredicate := PPCharSetPredicate on: [ :char | char isSeparator ]
%
! ------------------- Instance methods for GsQueryTokenParser
category: 'parsing'
set compile_env: 0
method: GsQueryTokenParser
parseOn: aStream
  | start token |
  [ aStream atEnd not and: [ SeparatorPredicate value: aStream uncheckedPeek ] ]
    whileTrue: [ aStream next ].
  start := aStream position.
  token := super parseOn: aStream.
  token isPetitFailure
    ifTrue: [
      aStream position: start.
      ^ token ].
  ^ token
%
expectValue %Boolean
doit
GsQueryTokenParser category: 'Index-Query'.
true
%

! ------------------- Class initializers

expectvalue true
doit
GsQueryTokenParser initialize.
true
%

