!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   IdentitySet, IdentityBag, UnorderedCollection, Collection, Object.
!
!=========================================================================

removeallmethods IdentitySet
removeallclassmethods IdentitySet

category: 'For Documentation Installation only'
classmethod: IdentitySet
installDocumentation

self comment:
'An IdentitySet is an IdentityBag in which any distinct object can occur only
 once.  Adding the same (identical) object to an IdentitySet multiple times is
 redundant.  The result is the same as adding it once.

 Since an IdentitySet is an identity-based collection, different (non-identical)
 but equivalent (equal) objects are treated as distinct from each other.  In
 Sets, they are not distinct.  Adding multiple equivalent objects to an
 IdentitySet yields an IdentitySet with as many elements as there are distinct
 equivalent objects.  In short, two different elements of an IdentitySet are
 never identical, but they may be equivalent.' .
%

category: 'Adding'
method: IdentitySet
addValue: anObject

"Adds anObject to the receiver only if it is not already an element of the
 receiver, and if the receiver does not contain an equivalent object.  Has no
 effect if anObject is nil.  Returns anObject."

(self includesValue: anObject) ifFalse:[ self add: anObject ].
^ anObject
%

! add: now inherited from IdentityBag

!-----------------------------
! following two methods not in customer's image
!    see duplicated code in   tests/gcitst/nsctestprivate.opl
! category: 'Private'
! method: IdentitySet
! _addToPrivateSet: anObject
! 
! "For use in testing the virtual machine ONLY.  This primitive does
!  not operate correctly on persistent instances or on instances of
! subclasses.  also Indexes are not maintained. "
!
! <primitive: 303>
! self _primitiveFailed: #add: args: { anObject } .
! self _uncontinuableError
! %
! category: 'Private'
! method: IdentitySet
! _removeFromPrivateSet: anObject ifAbsent: exceptionBlock
! 
! "For use in testing the virtual machine only."
! 
! <primitive: 63>  "primitive fails if anObject not found"
! ^ exceptionBlock value
! %
!    see duplicated code in   tests/gcitst/nsctestprivate.opl
!-----------------------------


category: 'Adding'
method: IdentitySet
add: anObject withOccurrences: anInteger

"Disallowed.  Each element of an IdentitySet must be unique."

self shouldNotImplement: #add:withOccurrences:
%

category: 'Adding'
method: IdentitySet
addAll: aCollection

"Adds each element of aCollection to the receiver only if the element is not
 already present in the receiver.  Occurrences of nil in aCollection are not
 added to the receiver."

^ super addAll: aCollection
%

category: 'Converting'
method: IdentitySet
asIdentitySet

"Returns an IdentitySet with the contents of the receiver."

^ self.
%

! Fix 39587
category: 'Converting'
method: IdentitySet
asSet

^Set withAll: self
%


category: 'Updating Indexes - Private'
method: IdentitySet
_cleanUpDependencies

"The receiver is having all of its indexes removed.  Remove dependency
 list entries for objects along the path of the indexes.

 Optimized version for IdentitySet where we don't worry about duplicates."

| rootTerms iList rootTermsSize |

iList := self _indexedPaths.
rootTerms := iList rootTerms.
rootTermsSize := rootTerms size .

1 to: self size do: [ :i | | obj |
  obj := self _at: i.
  1 to: rootTermsSize do: [ :j |
        (rootTerms at: j) cleanupDependencyListFor: obj
   ].
].

iList hasTrackingObjects
  ifTrue: [ iList removeAllIndexesFor: self ]
  ifFalse: [ self _indexedPaths: nil ].

" resize the Array of path terms to avoid object audit errors "
rootTerms size: 0.
%

! fix 46713
category: 'Set Arithmetic'
method: IdentitySet
_union: aBagOrSet

^ self + aBagOrSet
%

