!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!  IndexManagerAutoCommitPolicy, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods IndexManagerAutoCommitPolicy
removeallclassmethods IndexManagerAutoCommitPolicy

category: 'For Documentation Installation only'
classmethod: IndexManagerAutoCommitPolicy
installDocumentation

self comment:
'IndexManagerAutoCommitPolicy implements the behavior for determining when commits should be
 performed when the IndexManager autoCommit feature is enabled. Commits will be performed 
 whenever the number of persistent objects modified exceeds the dirtyObjectCommitThreshold or
 when the tempObjSpacePercentUsed crosses the percentTempObjSpaceCommitThreshold.

 When autoCommit is enabled, the system will also commit on TransactionBacklog notification.
'.
%

! ------------------- Class methods for IndexManagerAutoCommitPolicy
category: 'Instance Creation'
classmethod: IndexManagerAutoCommitPolicy
on: anIndexManager

^ self new indexManager: anIndexManager
%
! ------------------- Instance methods for IndexManagerAutoCommitPolicy
category: 'Accessing'
method: IndexManagerAutoCommitPolicy
dirtyObjectCommitThreshold

^ dirtyObjectCommitThreshold
%
category: 'Evaluation'
method: IndexManagerAutoCommitPolicy
evaluate: aBlock for: anIndexManager
  | thresh |
  (thresh := percentTempObjSpaceCommitThreshold)
    ifNil: [ 
      "no % memory threshold protection"
      [ 
      [ 
      TransactionBacklog enableSignalling.
      aBlock value ]
        onException: TransactionBacklog
        do: [ :ex | 
          anIndexManager _doCommit.
          TransactionBacklog enableSignalling.
          ex resume ] ]
        ensure: [ TransactionBacklog disableSignalling ] ]
    ifNotNil: [ 
      [ 
      [ 
      TransactionBacklog enableSignalling.
      aBlock value ]
        onException:
          (AlmostOutOfMemory enableAtThreshold: thresh) , TransactionBacklog
        do: [ :ex | 
          | systm |
          anIndexManager _doCommit.	"get the commit out of the way"
          (ex isKindOf: AlmostOutOfMemory)
            ifTrue: [ 
              (systm := System) _vmMarkSweep.
              systm _tempObjSpacePercentUsedLastMark < thresh
                ifTrue: [ 
                  "dropped below the threshold, reenable the signal"
                  AlmostOutOfMemory enable ]
                ifFalse: [ 
                  "likely started already above the threshold
                   and commits won't necessarily help with out of memory problems"
                   ] ]
            ifFalse: [ 
              "assume TransactionBacklog and re-enable signalling"
              TransactionBacklog enableSignalling ].
          ex resume ] ]
        ensure: [ 
          TransactionBacklog disableSignalling.
          AlmostOutOfMemory disable ] ]
%
category: 'Initialization'
method: IndexManagerAutoCommitPolicy
indexManager: anIndexManager

dirtyObjectCommitThreshold := anIndexManager dirtyObjectCommitThreshold.
percentTempObjSpaceCommitThreshold := anIndexManager percentTempObjSpaceCommitThreshold.
%
category: 'Accessing'
method: IndexManagerAutoCommitPolicy
percentTempObjSpaceCommitThreshold

^ percentTempObjSpaceCommitThreshold
%
category: 'Testing'
method: IndexManagerAutoCommitPolicy
shouldCommit
  "Answer true if enough dirty objects have been modified, or memory is close to full."

  "do not look at % memory used, since we use an exception handler for AlmostOutOfMemory"

 ^ System _numPersistentObjsModified > dirtyObjectCommitThreshold
%
