!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   JapaneseString, CharacterCollection, SequenceableCollection, Collection,
!   Object.
!
!=========================================================================

removeallmethods JapaneseString
removeallclassmethods JapaneseString

category: 'For Documentation Installation only'
classmethod: JapaneseString
installDocumentation

self comment: 
'Deprecated in 3.0 and later, replaced by Extended Character Set support
 and DoubleByteStrings/QuadByteStings.
 
 This class represents behavior common to all JapaneseString classes.

 Subclasses must reimplement the following selectors:

 #size  #size: #at: #at:put:

 However these selectors do not generate the subclass-responsibility error
 (error 2008) because to do so would break Object | printString method.'.
%

category: 'Instance Creation'
classmethod:
new: anInteger

"Returns an instance of the receiver with the specified size,
 with all codepoints set to zero.
 Generates an error if anInteger is not a positive SmallInteger."

<primitive: 53>
(anInteger _isInteger)
  ifFalse:[ anInteger _validateClass: Integer . ^ self new ]
  ifTrue:[
    (anInteger < 0) ifTrue:[ anInteger _error: #rtErrArgNotPositive .
                            ^ self new].
    anInteger _error: #rtErrArgOutOfRange .
    ^ self new
  ].
self _primitiveFailed: #new: args: { anInteger }.
self _uncontinuableError
%

classmethod:
new

"Returns an instance of the receiver of size zero"
<primitive: 51>
self _primitiveFailed: #new .
self _uncontinuableError
%

! size  size:  at:  at:put:  removed so they can be inherited to make
!   printString bulletproof.  If these selectors were to generate
!  subclass responsibility errors, then new must be disallowed and reimplemented
!  by subclasses also.

category: 'Formatting'
method: JapaneseString
printString

"Returns a String whose contents are a displayable representation of the
 receiver."

| ws str |

str := Unicode16 new.
ws := PrintStream printingOn: str.
self printOn: ws.
^str
%

category: 'Formatting'
method: JapaneseString
printOn: aStream

"Puts a displayable representation of the receiver on the given stream."

"This implementation uses JISString as the unifying collection class for the
 stream.  For literal classes, the result should contain formatting information.
 For example the following expression should evaluate to true:

 #abc asString = String withAll: '#abc'"

1 to: (self size min: 200) do:[:j |
  aStream nextPut: (Character codePoint: (self codePointAt: j))
].
%

category: 'Converting'
method: JapaneseString
asEUCString

"Returns an EUCString representing the receiver."

"Must be reimplemented in EUCString to return self !!
 This implementation handles other weird kinds of multiple-byte Strings
 that the user or engineers might dream up."

| s |
s := EUCString new .
self do:[ :aChar | s add: aChar asJISCharacter ].
^ s 
%

category: 'Concatenating'
method: JapaneseString
, aCharOrCharCollection

"Returns a new instance of the receiver's class that contains the elements of
 the receiver followed by the elements of aCharOrCharCollection.

 Warning: Creating a new instance and copying the receiver take time.  If you
 can safely modify the receiver, it can be much faster to use the addAll:
 method.  See the documentation of the Concatenating category of class
 SequenceableCollection for more details."

| resultClass jisStrCls res |

resultClass := self class  .
aCharOrCharCollection class == (jisStrCls := JISString) ifTrue:[
  resultClass := jisStrCls . 
  ]. 

(res := resultClass new) add: self;
                  add: aCharOrCharCollection.
^ res
%

! fix bug 9447
category: 'Storing and Loading'
method: JapaneseString
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into the receiver."

passiveObj hasRead: self.
passiveObj next: self _basicSize basicBytesTo: self.
passiveObj next.  "consume the space put after all strings"
^self
%

category: 'Storing and Loading'
method: JapaneseString
writeTo: passiveObj

"Converts the receiver to its passive form and writes that information on
 passiveObj."

| s mySize |

"copy bytes of self into an instance of String, with no translation."
mySize := self _basicSize .
s := String new: mySize .
1 to: mySize do:[:j | s _basicAt: j put: (self _basicAt: j) ].
passiveObj writeClass: self class;
  writeSize: mySize ;
  nextPutAll: s; space .
%

! deleted _copyFrom:to:intoString:startingAt:

category: 'Searching'
method: JapaneseString
findString: subString startingAt: startIndex

"If the receiver contains subString beginning at some point at or after
 startIndex, returns the index at which subString begins.  If the receiver does
 not contain subString, returns zero."

"check for errors"
subString _validateClass: CharacterCollection.
(((startIndex < 1) or: [startIndex > self size]) or: [self size == 0])
   ifTrue: [ ^ self _errorIndexOutOfRange: startIndex ].

"now find the substring"
(subString size == 0) ifTrue: [^startIndex].
startIndex to: ((self size) - (subString size) + 1) do: [:i |
   (self at: i equals: subString)
   ifTrue: [ ^i ]
].
^0
%

category: 'Removing'
method: JapaneseString
removeFrom: startIndex to: stopIndex

"Deletes the elements of the receiver from startIndex to stopIndex.  The
 size of the receiver is decreased by stopIndex - startIndex + 1.

 Both startIndex and stopIndex must be positive integers not larger than the
 size of the receiver, with startIndex <= stopIndex."
| mySize |
((stopIndex > (mySize := self size)) or: [(stopIndex < 1)])
   ifTrue: [ ^ self _errorIndexOutOfRange: stopIndex].
stopIndex == mySize ifTrue:[
  self size: (startIndex - 1) .
  ^ self
  ].
"self copyFrom: stopIndex + 1 to: self size into: self startingAt: startIndex . "
self replaceFrom: startIndex to: startIndex + mySize - (stopIndex + 1) 
            with: self startingAt: stopIndex + 1 .
self size: mySize - (stopIndex - startIndex + 1)
%

category: 'Adding'
method: JapaneseString
insertAll: aCharOrCharColl at: anIndex

"Inserts aCharOrCharColl at the specified index.  Returns aCharOrCharColl."

| argSize origSize destIdx |
(anIndex < 1 or:[ anIndex > (self size + 1)])
   ifTrue: [ ^ self _errorIndexOutOfRange: anIndex].
argSize := aCharOrCharColl size .
anIndex == (self size + 1) ifTrue:[
  self addAll: aCharOrCharColl .
  ^ aCharOrCharColl
  ].
origSize := self size.
self size: origSize + argSize.
destIdx := anIndex + argSize .
self replaceFrom: destIdx to: argSize + origSize with: self startingAt: anIndex .
self replaceFrom: anIndex to: destIdx - 1 with: aCharOrCharColl startingAt: 1 .
^ aCharOrCharColl
%
! deleted JapaneseString>>_idxCompareEqualTo: in v2.0 (bugfix 34042)
category: 'Converting'
method: JapaneseString
asFloat
  ^ Float fromString:( self asString)
%
category: 'Instance Creation'
classmethod: JapaneseString
withBytes: aByteObject

"Returns a new instance of the receiver that contains the bytes in the
 argument aByteObject. "

| result size |
size := aByteObject _basicSize.
((size \\ self charSize) ~= 0) ifTrue: [
  self _error: #objErrBadSize args: { size . self class }
].
result:= self new _basicSize: size.
1 to: size do: [:i | result _basicAt: i put: (aByteObject _basicAt: i) ].
^ result.
%

category: 'Accessing'
method: JapaneseString
byteAt: index

"Considers the receiver as an Array of bytes and returns the byte at position
 index."

^ self _basicAt: index.
%

category: 'Updating'
method: JapaneseString
byteAt: index put: newElement

"Considers the receiver as an Array of bytes and sets the byte at position
 index to newElement.  The argument newElement replaces any previously stored
 value and must be an Integer between 0 and 255."

^ self _basicAt: index put: newElement.
%

category: 'Comparing'
method:
< aCharCollection

"Returns true if the receiver collates before the argument.  Returns false
 otherwise."

^ (self _charCollCompare: aCharCollection) == -1
%
category: 'Comparing'
method:
<= aCharCollection

"Returns true if the receiver collates before the argument or if all of the
 corresponding Characters in the receiver and argument are equal.
 Returns false otherwise."

^ (self _charCollCompare: aCharCollection) <= 0
%
category: 'Comparing'
method:
= aCharCollection

"Returns true if all of the corresponding Characters in the receiver and
 argument are equal.  Returns false otherwise."

self == aCharCollection ifTrue:[ ^ true].
(aCharCollection isKindOf: CharacterCollection)
  ifFalse: [ ^ false ].

(self size) ~~ (aCharCollection size)
  ifTrue: [ ^ false ].

^ (self _charCollCompare: aCharCollection) == 0
%

category: 'Comparing'
method:
> aCharCollection

"Returns true if the receiver collates after the argument.  Returns false
 otherwise."

^ (self _charCollCompare: aCharCollection) == 1
%

category: 'Comparing'
method:
>= aCharCollection

"Returns true if the receiver collates after the argument or if all of the
 corresponding Characters in the receiver and argument are equal.  Returns
 false otherwise."

^ (self _charCollCompare: aCharCollection) >= 0
%
method:
at: idx equals: aString
  idx _validateClass: SmallInteger.
  aString _validateClass: CharacterCollection.
  (((self size - idx) + 1) == aString size) ifTrue:[
    ^ (self copyFrom: idx to: self size ) = aString
  ].
  ^ false
%
method:
hash
  ^ super hash
% 
