category: '*gsmonticello'
method: Class
classComment: comment stamp: aString
self comment: comment.
aString == nil
        ifTrue: [ self commentStamp: self class changeStamp ]
        ifFalse: [ self commentStamp: aString ].
%

category: '*gsmonticello'
method: Class
classSide
	^self theMetaClass
%

category: '*gsmonticello'
method: Class
poolDictionariesForNames: poolDictionaryNames

        | ar existingDict |
        ar := Array new.
        poolDictionaryNames do: [:poolName |
                existingDict := GsSession currentSession userProfile symbolList objectNamed: poolName.
                (existingDict isKindOf: SymbolDictionary)
                        ifTrue: [ ar add: existingDict ].
                ((existingDict isKindOf: Class) and: [existingDict isSubclassOf: SharedPool])
                        ifTrue: [
                                ar add: existingDict _createClassVarsDict.
                                existingDict _classVars name: poolName asSymbol.
                        ].
                existingDict == nil
                        ifTrue: [ | pool |
                                pool := SymbolDictionary new.
                                pool name: poolName asSymbol.
                                ar add: pool.
                        ].
        ].
^ar
%

category: '*gsmonticello'
method: Class
classComment
 (self _extraDictAt: #'comment') ifNotNil: [ :cmt | ^ cmt ].
 ^ ''
%

category: '*gsmonticello'
method: Class
_sortedClassVarNames
	"Returns a sorted list of class variable names. "

	^ SortedCollection withAll: self classVarNames
%

category: '*gsmonticello'
method: Class
poolDictionaryNames
| ar anArray |
ar := Array new.
self sharedPools do: [:each |
  anArray := System myUserProfile dictionaryAndSymbolOf: each.
  anArray == nil
        ifTrue: [ | d |
            (d := System myUserProfile objectNamed: each name) ~~ nil 
			ifTrue: [ 
				((d isKindOf: Class) and: [d isSubclassOf: (GsSession currentSession userProfile symbolList objectNamed: #SharedPool)])
					ifTrue: [ ar add: each name  ]
					ifFalse: [ ar add: ' "(not named)" ' ]
			]
			ifFalse: [ar add: ' "(not named)" ' ]
        ]
        ifFalse: [ ar add: (anArray at: 2)].
].
^ar
%

category: '*gsmonticello'
method: Class
_mcDefinitionType
  | type opts superC |
  superC := self superClass .
  (self isBytes and:[ superC isBytes not ]) ifTrue:[ 
    type := #bytes
  ] ifFalse:[
    (self isIndexable and:[ superC isIndexable not]) ifTrue:[
      type := #variable 
    ] ifFalse:[
      type := #normal  
  ]].
  opts := self _nonInheritedOptions .
  ^ opts size > 0 ifTrue:[ { type . opts } ] ifFalse:[ type ] . 
%

category: '*gsmonticello'
method: Class
copyVariables
| chSize chist priorVersion priorVars civNames priorCivNames toIgnoreCount |
(chSize := (chist := classHistory) size) = 1 ifTrue:[ 
  ^ self
].
priorVersion := chist at: chSize - 1.
(priorVars := priorVersion _classVars) notNil ifTrue: [
  | cvars |
  cvars := classVars.
  priorVars associationsDo: [:anAssociation | |aKey |
    anAssociation value == priorVars
      ifTrue: [
	  "ensure creation of class var symbol dictionary"
	  self _createClassVarsDict name: anAssociation key ]
      ifFalse: [
        cvars notNil ifTrue: [ 
	    (cvars includesKey: (aKey := anAssociation key)) ifTrue: [
            cvars removeKey: aKey .
            cvars addAssociation: anAssociation.
        ].
      ].
    ].
  ].
].
priorCivNames := priorVersion class allInstVarNames.
toIgnoreCount := Class allInstVarNames size.
toIgnoreCount < priorCivNames size ifTrue: [
	priorCivNames := priorCivNames 
		copyFrom: toIgnoreCount + 1
		to: priorCivNames size.
	civNames := self class allInstVarNames.
	priorCivNames do: [:each | 
		(civNames includesIdentical: each) ifTrue: [
			self atClassInstVar: each put: (priorVersion atClassInstVar: each).
		].
	].
].
%

