category: '*gsmonticello'
classmethod: Time
readFrom: aStream

	"Read a Time from the stream in the form:
		<hour>:<minute>:<second> <am/pm>
	<minute>, <second> or <am/pm> may be omitted.  e.g. 1:59:30 pm; 8AM; 15:30"

	| hour minute second ampm totalSeconds |
	hour := Integer fromStream: aStream.
	minute := 0.
	second := 0.
	(aStream peekFor: $:) ifTrue:
	[ minute := Integer fromStream: aStream.
		(aStream peekFor: $:) ifTrue: [ second := Integer fromStream: aStream ]].
	aStream skipSeparators.
	(aStream atEnd not and: [aStream peek isLetter]) ifTrue: 
		[ampm := aStream next asLowercase.
	(ampm = $p and: [hour < 12]) ifTrue: [hour := hour + 12].
		(ampm = $a and: [hour = 12]) ifTrue: [hour := 0].
	(aStream peekFor: $m) ifFalse: [aStream peekFor: $M ]].

	totalSeconds := (hour * 3600) + (minute * 60) + second.
	^ self fromSeconds: totalSeconds .

	"Time readFrom: (ReadStream on: '2:23:09 pm')"
%

category: '*gsmonticello'
classMethod: Time
totalSeconds

"Returns an Integer that represents the receiver in units of seconds since
 midnight January 1, 1901, UTC (not local, because local time is too expensive)."

^(DateAndTime secondsUTC: DateAndTime secondsSince2001 offset: Duration zero) asSeconds asInteger  + 3155760000
%

category: '*gsmonticello'
classMethod: Time
dateAndTimeFromSeconds: secondCount
 
 	^ Array
 		with: (Date fromSeconds: secondCount)
 		with: (Time fromSeconds: secondCount \\ 86400)
%

