!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcBtreeBasicInteriorNode, BtreeBasicInteriorNode, BtreeInteriorNode, BtreeNode, Array,
!   SequenceableCollection, Collection, Object.
!
!=========================================================================

! class created in idxclasses.topaz

removeallmethods RcBtreeBasicInteriorNode
removeallclassmethods RcBtreeBasicInteriorNode

category: 'For Documentation Installation only'
classmethod: RcBtreeBasicInteriorNode
installDocumentation

self comment:
'A RcBtreeBasicInteriorNode represents an interior node of a B-tree for which a
binary search can be done for a key. Updates to instances of this class are 
logged and can  be replayed in the case of commit conflicts.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	numElements: SmallInteger
	lastValue: Object' .
%

! ------------------- Class methods for RcBtreeBasicInteriorNode
! ------------------- Instance methods for RcBtreeBasicInteriorNode
category: 'Updating'
method: RcBtreeBasicInteriorNode
at: aKey put: aValue

self shouldNotImplement: #at:put:
%
category: 'Updating'
method: RcBtreeBasicInteriorNode
btreeAt: aKey put: aValue

""

self shouldNotImplement: #btreeAt:put:
%
category: 'Updating'
method: RcBtreeBasicInteriorNode
btreeAt: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := self _at: aKey put: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
category: 'Constants'
method: RcBtreeBasicInteriorNode
parentNodeClass

"Returns the class of node to be created as the parent when a split occurs."

^ RcBtreeBasicInteriorNode
%
category: 'Removing'
method: RcBtreeBasicInteriorNode
removeKey: aKey value: aValue

self shouldNotImplement: #removeKey:value:
%
category: 'Removing'
method: RcBtreeBasicInteriorNode
removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil

| res |
(selectiveAbortSetOrNil ~~ nil and: [ (selectiveAbortSetOrNil includes: self) not ])
        ifTrue: [ 
                selectiveAbortSetOrNil add: self.
                self _selectiveAbort ].
res := self _removeKey: aKey value: aValue for: anIndexObj selectiveAbortSet: selectiveAbortSetOrNil.
System _addRootObjectToRcReadSet: self.
System redoLog addConflictObject: self for: anIndexObj.
^res
%
