!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   RcQueueElement, Object.
!
!=========================================================================

expectvalue %String
run
^ Object _newKernelSubclass: 'RcQueueElement'
        instVarNames: #( 'value' 'sequenceNumber' 'createTime')
        classVars: #()
        classInstVars: #()
        poolDictionaries: { }
        inDictionary: Globals
        options: #()
        reservedOop: 849
%

removeallmethods RcQueueElement
removeallclassmethods RcQueueElement

category: 'For Documentation Installation only'
classmethod: RcQueueElement
installDocumentation

self comment:
'RcQueueElement describes an individual entry in a reduced-conflict queue.

This class implements GemStone internals. It is not intended for customer use, 
by creating instances or by subclassing.

Constraints:
	value: Object
	sequenceNumber: SmallInteger
	createTime: SmallInteger
--- instVar createTime
A SmallInteger that represents a time stamp, indicating the time at which the
 RcQueue >> add: method was invoked to add this element to the queue.
--- instVar sequenceNumber
A SmallInteger that indicates this element''s retrieval position.
--- instVar value
The object (any kind) stored in the queue.
'
%

category: 'Accessing'
method: RcQueueElement
createTime

"Returns the value of the element's time stamp, the createTime instance
 variable."

^createTime
%

category: 'Accessing'
method: RcQueueElement
sequenceNumber

"Returns the value of this element's retrieval sequence indicator,
 the sequenceNumber instance variable."

^sequenceNumber
%

category: 'Accessing'
method: RcQueueElement
value

"Returns the object stored in this queue element, the value instance variable."

^value
%

category: 'Updating'
method: RcQueueElement
createTime: newValue

"Modifies the value of the time stamp, the createTime instance variable."

createTime := newValue
%

category: 'Updating'
method: RcQueueElement
sequenceNumber: newValue

"Modifies the value of the sequenceNumber instance variable."

sequenceNumber := newValue
%

category: 'Updating'
method: RcQueueElement
value: newValue

"Assigns a new object to this queue element."

value := newValue
%

category: 'Storing and Loading'
method: RcQueueElement
loadNamedIVsFrom: passiveObj

"Reads named instance variables from the given passive object.  The
 first instance variable should already have been parsed and be
 available in the passiveObj argument."

| name offset nameSym aValue |

passiveObj version >= 500 ifTrue:[ ^ super loadNamedIVsFrom: passiveObj ].

[ name := passiveObj ivName.
  name ifNotNil: [
    nameSym := Symbol _existingWithAll: name .
    nameSym ifNotNil:[
      offset := self class _ivOffsetOf: nameSym.
      offset ifNotNil:[
        aValue := passiveObj ivValue .
        (offset == 3"createTime" and:[ aValue ~~ nil]) ifTrue:[
          aValue := aValue - 788922768 "convert timeGmt to timeGmt95" .
          ].
        self instVarAt: offset put: aValue .
      ] ifNil:[ 
         self dynamicInstVarAt: nameSym put: passiveObj ivValue
      ].
    ] ifNil:[ 
      self dynamicInstVarAt: name asSymbol put: passiveObj ivValue
    ].
    passiveObj readNamedIV
  ] ifNil: [
    false
  ]
] untilFalse.

passiveObj skipNamedInstVars.
%

category: 'Comparing'
method: RcQueueElement
createTimeAsGmt95

"createTime is always gmt95 for RcQueueElement"
^createTime
%

category: 'Comparing'
method: RcQueueElement
createTimeAsGmt2005

"Convert our create time, which is always in gmt95 format,
 to a timestamp with gmt2005 format."
^createTime - 315619200
%

category: 'Comparing'
method: RcQueueElement
isOlderThan: anotherElementOrEntry

"Compare the creation time of this object to that of anotherElementOrEntry,
 which must be an instance of RcQueueElement or RcQueueEntry object.
 Answers true if this object is older than anotherElementOrEntry or
 if anotherElementOrEntry is nil.   Answers false otherwise."

(anotherElementOrEntry == nil)
  ifTrue:[^true].

^self createTimeAsGmt2005 < anotherElementOrEntry createTimeAsGmt2005
%

category: 'Accessing'
method: RcQueueElement
createTimeUs

"There is no microsecond timestamp in RcQueueElement, so answer zero."

^0
%

category: 'Updating'
method: RcQueueElement
setTimestamp

"Sets the timestamp for this entry."
 createTime := System timeGmt2005.
%

