!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SimpleBlock, ExecutableBlock, BlockClosure, Object.
!
!=========================================================================

removeallmethods SimpleBlock
removeallclassmethods SimpleBlock

category: 'For Documentation Installation only'
classmethod: SimpleBlock
installDocumentation

self comment:
'SimpleBlock is obsolete in Gemstone64 v3.0 and above. It is no longer used
 for execution.

 A SimpleBlock is an ExecutableBlock that does not refer to any enclosing scope
 variables.  Thus, unlike complex blocks, it needs no variable context at any
 time.

Constraints:
	method: GsMethod
	firstPC: SmallInteger
	spare1: Object
	numberArgs: SmallInteger
	numberTemps: SmallInteger
	firstSourceOffset: SmallInteger
	lastSourceOffset: SmallInteger
	argsAndTemps: Array
	blockSelfUsed: Boolean' .
%

category: 'Block Evaluation'
method: SimpleBlock
value

"Return the value of the receiver evaluated with no arguments.
 If the block expects any arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: anObject

"Return the value of the receiver evaluated with anObject as its argument.  If
 the block expects a different number of arguments, an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject

"Return the value of the receiver evaluated with the two objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: firstObject value: secondObject value: thirdObject

"Return the value of the receiver evaluated with the three objects as its
 arguments.  If the block expects a different number of arguments, an error is
 generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth

"Return the value of the receiver evaluated with the four objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
value: first value: second value: third value: fourth value: fifth

"Return the value of the receiver evaluated with the five objects as
 its arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%

category: 'Block Evaluation'
method: SimpleBlock
valueWithArguments: argList

"Return the value of the receiver evaluated with the elements of the Array
 argList as arguments.  If the block expects a different number of arguments,
 an error is generated."

self _uncontinuableError  "must recompile methods and regenerate block for v3.0"
%


category: 'Accessing'
method: SimpleBlock
_sourceString

"Return a string that will create a block similar to the receiver when
 the string is compiled."

| result |
(result := '^ ' copy )
   addAll: ( method _sourceString copyFrom: firstSourceOffset to: lastSourceOffset  ) .
^result
%

! removed _sourceStringForConversion

category: 'Testing'
method: SimpleBlock
isSimple

"Return true.  The receiver is a simple block."

^ true
%

! deleted convertTo5With: symbolList oldNamesDict: oldNamesDict

category: 'Disassembly'
classmethod: SimpleBlock
_cost

^ 1

%
