!=========================================================================
! Copyright (C) GemTalk Systems 1986-2020.  All Rights Reserved.
!
! $Id$
!
! Superclass Hierarchy:
!   SmallFloat, BinaryFloat, Number, Magnitude, Object.
!
! class SmallFloat created in floatclasses.gs
!=========================================================================

! ObsSmallFloat and SmallFloat classes are created in bom.c

removeallmethods ObsSmallFloat
removeallclassmethods ObsSmallFloat

category: 'Documentation'
classmethod: ObsSmallFloat
comment
^ '
 Instances of ObsSmallFloat contain 4-byte IEEE binary floats in
 big-endian order.  In Gs64 v2.x this class was named SmallFloat.

 The superclass of ObsSmallFloat is Object, the only method supported
 is #convert .

 All instances are mutated in a read-only manner on fault into VM memory
 to be instances of SmallFloat.  Send #convert to the instance to
 cause it to be written by the current transaction as an instance of SmallFloat.
 See also Number>>convert .
'
%

removeallmethods SmallFloat
removeallclassmethods SmallFloat

category: 'For Documentation Installation only'
classmethod: SmallFloat
installDocumentation

self comment:
'This class represents 4 byte binary floating point numbers, as defined in IEEE
 standard 754.
 
 This class is deprecated.  
 Most numeric operations will return instances of SmallDouble or Float .

 You may not create subclasses of SmallFloat.

 Float status flags, exception handlers, and non-default rounding modes are
 maintained only for a single execution of the virtual machine, and are cleared
 when a new invocation of the virtual machine begins.'.
%

category: 'Converting'
method: SmallFloat
asSmallFloat

"Returns the receiver."

^ self
%

category: 'Converting'
method: SmallFloat
asFloat

"Returns a SmallDouble or Float with the same value as the receiver."

<primitive: 154>
^ self _primitiveFailed: #asFloat
%

category: 'Converting'
method: SmallFloat
_coerce: aNumber

"Returns an instance of SmallFloat with the same value as 'aNumber'.
 Since SmallFloat is deprecated, use asFloat which may return a 
 SmallDouble or a Float."

"This method must be defined by all subclasses of Number."

^ aNumber asFloat 
%

category: 'Accessing'
method: SmallFloat
denominator

"Returns the denominator of a Fraction representing the receiver."

^ self asFloat denominator
%

category: 'Accessing'
method: SmallFloat
numerator

"Returns the numerator of a Fraction representing the receiver."

^ self asFloat numerator
%

! sign - inherit from Number
! negative - inherit from Number

category: 'Accessing'
method: SmallFloat
asFraction

"Returns a Fraction that represents the receiver.  If the receiver is a NaN,
 or Infinity, returns the receiver."

^ self asFloat asFraction
%

category: 'Converting'
method: SmallFloat
_generality

"Returns the integer that represents the ordering of the receiver in the
 generality hierarchy."

"Reimplemented from Number"

^ 80
%

category: 'Truncation and Rounding'
method: SmallFloat
truncated

"Returns the integer that is closest to the receiver, on the same side
 of the receiver as zero is located.  In particular, returns the receiver
 if the receiver is an integer."

^ self asFloat truncated
%

category: 'Arithmetic'
method: SmallFloat
* aNumber

"Multiply the receiver by aNumber and returns the result."

^ self asFloat * aNumber
%

category: 'Arithmetic'
method: SmallFloat
- aNumber

"Returns the difference between the receiver and aNumber."

^ self asFloat - aNumber
%

category: 'Arithmetic'
method: SmallFloat
+ aNumber

"Returns the sum of the receiver and aNumber."

^ self asFloat + aNumber
%

category: 'Arithmetic'
method: SmallFloat
/ aNumber

"Divide the receiver by aNumber and returns the result."

^ self asFloat / aNumber
%

category: 'Comparing'
method: SmallFloat
_compare: aNumber opcode: opcode selector: aSymbol

"Private."

"opcode function
   0     =
   1     ~=
   2     <
   3     <= 

 The primitive returns nil if the receiver and argument are not
 comparable, and the sender must then retry the compare."

<primitive: 176>
opcode <= 1 ifTrue:[ aNumber _isNumber ifFalse:[ ^ opcode == 1 ]].
^ self _retry: aSymbol coercing: aNumber 
%

category: 'Comparing'
method: SmallFloat
~= aNumber

"Returns true if the receiver is not equal to aNumber; returns false
 otherwise."

^ self _compare: aNumber opcode: 1 selector: #~= 
%

category: 'Comparing'
method: SmallFloat
< aNumber

"Returns true if the receiver is less than aNumber; returns false otherwise."

^ self _compare: aNumber opcode: 2 selector: #< 
%

category: 'Comparing'
method: SmallFloat
<= aNumber

"Returns true if the receiver is less than or equal to a aNumber;
 returns false otherwise."

^ self _compare: aNumber opcode: 3 selector: #<=
%

category: 'Comparing'
method: SmallFloat
= aNumber

"Returns true if the receiver is equal to aNumber; returns false otherwise."

^ self _compare: aNumber opcode: 0 selector: #=
%

! hash inherited from Number

category: 'Indexing Support'
method: SmallFloat
_isNaN

"Returns whether the receiver is quiet NaN or signaling NaN.
 This method is only to be used by the indexing subsystem."

^ self _getKind > 4
%

category: 'Accessing'
method: SmallFloat
_getKind

"Returns an integer, 1...6, for the kind of the receiver."

^ self asFloat _getKind
%

category: 'Formatting'
method: SmallFloat
asStringUsingFormat: anArray

"Returns a String corresponding to the receiver, using the format specified by
 anArray.  The Array contains three elements: two Integers and a Boolean.
 Generates an error if any element of the Array is missing or is of the wrong
 class.

 The first element of the Array (an Integer between -1000 and 1000)
 specifies a minimum number of Characters in the result String (that is,
 the 'width' of the string).  If this element is positive, the resulting
 String is padded with blanks to the right of the receiver.  If this element
 is negative, the blanks are added to the left of the receiver.  If the
 value of this element is not large enough to completely represent the Float,
 a longer String will be generated.


 The second element of the Array (a positive Integer less than or equal to 
 1000) specifies the number of digits to display to the right of the decimal 
 point.  If the value of this element exceeds the number of digits required to 
 specify the Float, the result is right-padded with 0 to the required width.
 If the value of this element is insufficient to completely specify the Float, 
 the value of the Float is rounded (see #rounded).

 The third element of the Array (a Boolean) indicates whether or not to display
 the magnitude using exponential notation.  (The value true indicates
 exponential notation and false indicates decimal notation.)

 For example, the number 12.3456 displayed with two different format Arrays
 would appear as follows:

 Format          Output
 #(10 5 true)    '1.23456E01'
 #(10 2 false)   '12.35     '"

^ self asFloat asStringUsingFormat: anArray
%

! fixed 43842 , 45338
category: 'Formatting'
method: SmallFloat
asStringLegacy

"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'."

^ self asFloat asStringUsingFormat: #(1 8 true)
%

category: 'Formatting'
method: SmallFloat
asString
 
"Returns a String corresponding to the value of the receiver.  Where applicable,
 returns one of the following Strings: 'PlusInfinity', 'MinusInfinity',
 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or 'MinusSignalingNaN'.

 The receiver is printed using the C printf format string '%.7g' "
 
^ self asFloat _smallFloatAsString 
%

category: 'Formatting'
method: SmallFloat
asStringLocaleC

"Result is same as for asString, except that decimal point is always
 using  $.   For use in passivation/activation "

^ self asFloat _smallFloatAsStringLocaleC
%

category: 'Instance Creation'
classmethod: SmallFloat
fromString: aString

"Returns an instance of Float or SmallDouble, constructed from aString.  The String
 must contain only Characters representing the object to be created, although
 leading and trailing blanks are permitted.

 If the string represents an exceptional float, it must contain one of the
 following strings, with leading and trailing blanks permitted: 'PlusInfinity',
 'MinusInfinity', 'PlusQuietNaN', 'MinusQuietNaN', 'PlusSignalingNaN', or
 'MinusSignalingNaN'.

 If the string does not conform to the above rules, this method generates an
 error or returns a signaling NaN.

 If the string is larger than 8191 bytes, an error is generated."

^ (Float fromString: aString) asSmallFloat
%

! fix 45339
category: 'Instance Creation'
classmethod: SmallFloat
fromStringLocaleC: aString

"Same as fromString:  except that decimal point in aString must use  $.  "

^ (Float fromStringLocaleC: aString) asSmallFloat
%

category: 'Accessing'
method: SmallFloat
sign

"Returns 1 if the receiver is greater than zero, -1 if the receiver is
 less than zero, and zero if the receiver is zero."

^ self asFloat sign
%
method: SmallFloat
signBit

  "Returns  1 for a negative receiver and 0 for a positive receiver"

^ self asFloat signBit
%

category: 'Converting'
method: SmallFloat
asDecimalFloat

"Returns a DecimalFloat representing the receiver."

^ self asFloat asDecimalFloat
%

! fixed 44048
category: 'Storing and Loading'
classmethod: SmallFloat
loadFrom: passiveObj

"Reads from passiveObj the passive form of an object.  Converts the object to
 its active form by loading the information into a new instance of the receiver.
 Returns the new instance."

^ (Float loadFrom: passiveObj) _asSmallFloat 
%
