
array set vsdhelp {
{Context Switch} {
An operating system context switch occurs when a thread is moved from executing to non-executing status. If a thread needs a non-cpu resource (disk, lock, semaphore, and timer are examples) then its called an voluntary context switch (VolCWS). If a thread still wants to execute but the operating system scheduler decides to preempt it so some other thread can execute then its called a involuntary context switch (IVolCSW).
}
{Chart Window Features} {
You may have multiple chart windows open, including on different statmon data files/monitoring sessions.

!Chart Information
   * [General Interface Features]
   * [Creating Chart Windows > How to Create a New Chart]

!Chart Menus
   * [Chart menu > Chart Window Chart Menu]
   * [Line menu > Chart Window Line Menu]

!Chart Controls
   * optional [X: > Chart Window X: Display]
   * optional [Y: > Chart Window Y: Display]
   * optional [Min: > Chart Window Min: Display]
   * optional [Max: > Chart Window Max: Display]
   * [Statistic Selector > Chart Window Statistic ComboBox]
   * [Filter Selector > Chart Window Filter MenuButton]
   * [Operator Selector > Chart Window Operator MenuButton]
   * [Number Entry > Chart Window Number Entry]
   * [Graph > Chart Window Graph]
}

{Chart Window X: Display} {
This display shows the time coordinate of the data point currently under the mouse pointer. The format of the displayed information it determined by [Chart Menu <b>Time Format</b> SubMenu].
This display will only exist if [Chart Menu <b>Show Current Values</b> Item] is on. 
This display is on each [chart window > Chart Window Features].
}
{Chart Window Y: Display} {
This display shows the value coordinate of the data point currently under the mouse pointer.
This display will only exist if [Chart Menu <b>Show Current Values</b> Item] is on. 
This display is on each [chart window > Chart Window Features].
}
{Chart Window Min: Display} {
This display shows the minimum value of the currently selected line's data points. Only data points displayed on the graph are considered (see [trimming > File Trimming] and [zooming > How to Zoom] to learn how to control what data points are displayed).
This display will only exist if [Chart Menu <b>Show Min and Max</b> Item] is on.
This display is on each [chart window > Chart Window Features].
}
{Chart Window Max: Display} {
This display shows the maximum value of the currently selected line's data points. Only data points displayed on the graph are considered (see [trimming > File Trimming] and [zooming > How to Zoom] to learn how to control what data points are displayed).
This display will only exist if [Chart Menu <b>Show Min and Max</b> Item] is on.
This display is on each [chart window > Chart Window Features].
}
{Chart Window Statistic ComboBox} {
This control allows you to change the statistic of the currently selected line. It also display the statistic of the currently selected line. Changing the selection will also update the [Statistic Information Window].

!Key operations
   * Clicking on a name with the <em>mouse</em> both selects it and causes it to become the current line's statistic.
   * The <em>down</em> arrow key selects the next statistic.
   * The <em>up</em> arrow key selects the previous statistic.
   * The <em>letter keys</em> select the next statistic whose first letter matches the key.
   * <tt>control-s</tt> starts a [search > List Search Control] which results in selecting a statistic.
   * <em>Return</em> causes the selected statistic to become the current line's statistic.
   * <em>Esc</em> cancels the change leaving the current line's statistic unchanged.
This combobox is on each [chart window > Chart Window Features].
}
{Chart Window Filter MenuButton} {
Displays the current line's filter and allows the filter to be changed. Possible filters are:
   * No Filter (None)
   * PerSecond
   * PerSample
   * Aggregate
See [How to Filter Statistics] for a description of what each filter does.
This menu button is on each [chart window > Chart Window Features].
}
{Chart Window Operator MenuButton} {
Displays and sets the transforming operation that will be applied to the current line using the value in the [number entry > Chart Window Number Entry]. The supported operations are:
   * <b>S</b>: [scale > Display Scaling a Line]; uses the line's <em>display scale</em> constant
   * <b>/</b>: [divide > Value Scaling a Line]; uses the line's <em>value scale</em> constant
   * <b>*</b>: [multiply > Value Scaling a Line]; uses the line's <em>value scale</em> constant
   * <b>+</b>: [add > Offsetting a Line]; uses the line's <em>offset</em> constant
   * <b>-</b>: [subtract > Offsetting a Line]; uses the line's <em>offset</em> constant
This menu button is on each [chart window > Chart Window Features].
}
{Chart Window Number Entry} {
This entry displays and sets numeric constants associated with the current line. Which constant is displayed is controlled by which operator is selected by the [operator menu button > Chart Window Operator MenuButton]. Each line has three constants:
   * a <em>display scale</em> used by the <b>S</b> operator.
   * a <em>value scale</em> used by the <b>/</b> and <b>*</b> operators.
   * an <em>offset</em> used by the <b>+</b> and <b>-</b> operators.
For the scale constants the up spinner button doubles the constant and the down spinner button halves the constant.
For the offset constant the up spinner button adds one to the constant and the down spinner subtracts one from the constant.
Scale constants cannot be set to zero.
This entry is on each [chart window > Chart Window Features].
}

{Chart Window Graph} {
!Graph Controls
   * [Graph Display]
   * [X Axis]
   * [Left Y Axis]
   * [Right Y Axis]
   * optional [Graph Legend]
A graph is on each [chart window > Chart Window Features].
}

{Graph Display} {
Contains a graphical display of each line on the chart. An effort is made to give each line a unique color or style. The selected line's color is determined by the [Main Chart Menu <b>Selected Line Color...</b> Item].

Information about the current line is shown in the upper left corner of the graph. This information can be [disabled > Chart Menu Show Line Stats Item]. Two small red triangles at the bottom of the graph display indicate the range of data points used to calculate the line statistics. During [auto updating > File Menu Auto Update Item] this range will not automatically expand. To get it to expand <em>right click</em> in the graph display.

If [cross hairs > Chart Menu Show CrossHairs Item] are enabled then a single vertical and horizontal black line will be drawn and they will always intersect where the mouse points in the graph. If the mouse leaves the graph the cross hairs disappear.

If [grid lines > Chart Menu Show Grid Lines Item] are enabled then faint dashed lines are drawn from every axis tick.

!Key operations
   * <em>Left clicking</em> on a line will select it.
   * <em>Middle clicking</em> will do a [time zoom > How to Zoom].
   * <em>Right clicking</em> [zooms out > How to Zoom] one level.
   * <em>Moving</em> the mouse over a data point temporarily selects the line and [displays > Chart Menu Show Current Values Item] the data point's coordinates.
 
This display is on each [graph > Chart Window Graph].
}

{X Axis} {
The ticks on this axis are labeled with the time in a format determined by [Chart Menu <b>Time Format</b> SubMenu]. The labels reflect the data plotted in the graph of this axis. Each line's time coordinates are plotted on this axis.
This axis's title, if not [disabled > Chart Menu Show Time Axis Title Item], will show a description of the file the current line's data came from.
This axis is on each [graph > Chart Window Graph].
}

{Left Y Axis} {
The ticks on this axis are labeled with numbers that reflect the data plotted in the graph on this axis. Each line's values are plotted on either this axis or the other Y axis. An axis only exists if at least one line is plotted on it.
This axis's title, if not [disabled > Chart Menu Show Left Axis Title Item], will show a description of the current line's units if it was [plotted > Line Menu Graph on Left Axis Item] on the left axis.
This axis is on each [graph > Chart Window Graph].
}

{Right Y Axis} {
The ticks on this axis are labeled with numbers that reflect the data plotted in the graph on this axis. Each line's values are plotted on either this axis or the other Y axis. An axis only exists if at least one line is plotted on it.
This axis's title, if not [disabled > Chart Menu Show Right Axis Title Item], will show a description of the current line's units if it was [plotted > Line Menu Graph on Left Axis Item] on the right axis.
This axis is on each [graph > Chart Window Graph].
}

{Graph Legend} {
A graph's legend has an entry for every line on a graph. For each line the legend shows:
   * the line's unselected color
   * a description of the process and statistic the line represents
   * the line's [symbol > Line Menu Symbol SubMenu]
A graph's legend can be [hidden > Chart Menu Show Legend Item] to save space. If it is hidden then a description of the current's line process will be written in the upper left corner of the [graph > Graph Display]. Legends are very helpful so are usually not disabled. The best reason for disabling a legend is if your graph contains a large number of lines.

!Key operations
   * <em>Left clicking</em> on a legend entry toggles selection of that line.
   * <em>Middle clicking</em> on a legend entry deletes the line.

A legend is on each [graph > Chart Window Graph].
}
{Chart Window Chart Menu} {
Operations on this menu apply to the entire chart.
Changes made with this menu will only effect its chart.\
For changes that you want to be global, use the [Main Window menu bar's Chart menu > Main Window Chart Menu].

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This menu is on each [chart window > Chart Window Features].

!Items
   * [Add From Template > Chart Menu Add From Template SubMenu]
   * [Save Template > Chart Menu Save Template Item]
   * [Paste > Chart Menu Paste Item]
   * [Snapshot > Chart Snapshot Menu Item]
   * [Print > Chart Menu Print Item] (Unix only)
   * [Help... > Chart Menu Help... Item]
   * [Zoom In > Chart Menu Zoom In Item]
   * [Zoom Out > Chart Menu Zoom Out Item]
   * [Compute Scale All > Chart Menu Compute Scale All Item]
   * [Unscale All > Chart Menu Unscale All Item]
   * [Show Legend > Chart Menu Show Legend Item]
   * [Time Format > Chart Menu Time Format SubMenu]
   * [Show Time Axis Title > Chart Menu Show Time Axis Title Item]
   * [Show Left Axis Title > Chart Menu Show Left Axis Title Item]
   * [Show Right Axis Title > Chart Menu Show Right Axis Title Item]
   * [Show Current Values > Chart Menu Show Current Values Item]
   * [Show Min and Max > Chart Menu Show Min and Max Item]
   * [Show Line Stats > Chart Menu Show Line Stats Item]
   * [Show CrossHairs > Chart Menu Show CrossHairs Item]
   * [Show Grid Lines > Chart Menu Show Grid Lines Item]
   * [Close > Chart Menu Close Item]
}

{vsdsh} {
vsdsh is the text version of vsd. It allows scripts to be written that will load and process statmonitor data.
When vsdsh is started it will first attempt to load and interpret [Tcl code > Tcl Language] from the file <tt>~/.vsdshrc</tt>.
Then if it was given a file on the command line it will load and interpret it as [Tcl code > Tcl Language] and exit. Otherwise it display a prompt at which [Tcl code > Tcl Language] can be interactively entered. To exit back to the environment that started vsdsh type <tt>exit</tt>.
}

{Tcl Language} {
Tcl stands for tool command language. Tcl is pronounced <em>tickle</em>.\

In the context of VSD and [vsdsh] the following extension to standard Tcl are available. These extensions tend to be valuable when writing scripting code that VSD or [vsdsh] will load:
   * [RBC Vectors]
   * [sltcl]
   
In the context of VSD the following additional extensions to standard Tcl are available. These extensions are used for GUI features are probably not of interest to those writing scripting code:
   * Tk
   * Tix
   * RBC
}
{RBC Vectors} {
!Synopsis
   * <tt>vector create</tt> <em>vecName</em> <em>?switches?</em>
   * <tt>vector destroy</tt> <em>vecName</em>
   * <tt>vector expr</tt> <em>expression</em>
   * <tt>vector names</tt> <em>?pattern...?</em>

!Description
The <tt>vector</tt> command creates a vector of floating poing values. The vector's values can be manipulated through a Tcl array variable or with Tcl commands.

!Introduction
A vector is simply an ordered set of numbers. The components of a vector are real numbers, indexed by counting numbers. 
Vectors are common data structures for many applications. For example, a graph may use two vectors to represent the X-Y coordinates of the data plotted. The graph will automatically be redrawn when the vectors are updated or changed. By using vectors, you can separate data analysis from the graph widget. This makes it easier, for example, to add data transformations, such as splines. It's possible to plot the same data to in multiple graphs, where each graph presents a different view or scale of the data. 
You could try to use Tcl's associative arrays as vectors. Tcl arrays are easy to use. You can access individual elements randomly by specifying the index, or the set the entire array by providing a list of index and value pairs for each element. The disadvantages of associative arrays as vectors lie in the fact they are implemented as hash tables. 
   * There's no implied ordering to the associative arrays. If you used vectors for plotting, you would want to insure the second component comes after the first, an so on. This isn't possible since arrays are actually hash tables. For example, you can't get a range of values between two indices. Nor can you sort an array. ·
   * Arrays consume lots of memory when the number of elements becomes large (tens of thousands). This is because each element's index and value are stored as strings in the hash table. The C programming interface is unwieldy. Normally with vectors, you would like to view the Tcl array as you do a C array, as an array of floats or doubles. But with hash tables, you must convert both the index and value to and from decimal strings, just to access an element in the array. This makes it cumbersome to perform operations on the array as a whole. 

The <tt>vector</tt> command tries to overcome these disadvantages while still retaining the ease of use of Tcl arrays. The <tt>vector</tt> command creates both a new Tcl command and associate array which are linked to the vector components. You can randomly access vector components though the elements of array. Not have all indices are generated for the array, so printing the array (using the <tt>parray</tt> procedure) does not print out all the component values. You can use the Tcl command to access the array as a whole. You can copy, append, or sort vector using its command. If you need greater performance, or customized behavior, you can write your own C code to manage vectors. 

!Examples
   * When you create a new vector you give it a name. Both a Tcl command and an array variable with that name are created. You can use either the command or variable to query or modify components of the vector. The number of components in a vector can be given when it is created. By default they are initialized to zero. This example creates a vector named y that contains fifty components:  <tt>vector create y(50)</tt>
   * Indexing vector components
      * Vector components are indexed from zero. The vector's array variable can be used to read or set individual components. This example sets y's first element:  <tt>set y(0) 9.25</tt>
      * The array index must be a number less than the number of components. For example, it's an error if you try to set the 51st element of y:  <tt>puts "y has &#91;y length] components"; set y(50) 0.02</tt>
      * You can also specify a range of indices using a colon <tt>:</tt> to separate the first and last indices of the range. This example sets the first six components in y to 25.2:  <tt>set y(0:5) 25.2</tt>
      * If you don't include an index, then it will default to the first and/or last component of the vector. This example leaves out both indexes so it will print out all the components of y:  <tt>puts "y = $y(:)"</tt>  
      * Non-numeric Indices
         * <tt>end</tt> The index end, specifies the last component of the vector. It's an error to use this index if the vector is empty (length is zero).
         * <tt>++end</tt> The index ++end can be used to extend the vector by one component and initialize it to a specific value. You can't read from the array using this index, though. For example <tt>set y(++end) 0.02</tt> extends the vector by one component.
         * <tt>min</tt> The index min returns the component with the smallest value.
         * <tt>max</tt> The index max returns the component with the largest value.
   * To delete components from a vector, simply unset the corresponding array element. In the following example, the first component of y is deleted. All the remaining components of y will be moved down by one index as the length of the vector is reduced by one. Example: <tt>unset y(0); puts "new first element is $y(0)"</tt>
   * In this example a vector x is created without an initial length specification. In this case, the length is zero. The <b>set</b> operation resets the vector, extending it and setting values for each new component. The name of the vector is used as a command to set its component values given a list of them: <tt>vector create x; x set { 0.02 0.04 0.06 0.08 0.10 0.12 0.14 0.16 0.18 0.20}</tt>
   * The <b>range</b> operation lists the components of a vector between two indices. This example lists all the components in vector x: <tt>puts "x = &#91;x range 0 end]"</tt>
   * You can search for a particular value using the <b>search</b> operation. It returns a list of indices of the components with the same value. If no component has the same value, it returns "". This example finds the index of the components with the largest value: <tt>x search $x(max)</tt>
   * You can append vectors or new values onto an existing vector with the <b>append</b> operation. This example appends assorted vectors and values to x: <tt>x append x2 x3 { 2.3 4.5 } x4</tt>
   * The <b>sort</b> operation sorts the vector. If any additional vectors are specified, they are rearranged in the same order as the vector. For example, you could use it to sort data points represented by x and y vectors. In this example the vector x is sorted while the components of y are rearranged so that the original x,y coordinate pairs are retained: <tt>x sort y</tt>
   * The <b>expr</b> operation lets you perform arithmetic on vectors. The result is stored in the vector. This example adds y to x and then multiplies x by 2: <tt>x expr { x + y }; x expr { x * 2 }</tt>
   * When a vector is modified, resized, or deleted, it may trigger call-backs to notify the clients of the vector. For example, when a vector used in the graph widget is updated, the vector automatically notifies the widget that it has changed. The graph can then redrawn itself at the next idle point. By default, the notification occurs when Tk is next idle. This way you can modify the vector many times without incurring the penalty of the graph redrawing itself for each change. You can change this behavior using the <b>notify</b> operation. To make vector x notify after every change: <tt>x notify always</tt>. To turn off notification on vector x: <tt>x notify never</tt>. To force a notification now: <tt>x notify now</tt>.
   * To delete a vector, use the vector <b>delete</b> command. Both the vector and its corresponding Tcl command are destroyed. For example to remove vector x: <tt>vector destroy x</tt>

!Syntax
Vectors are created using the vector <b>create</b> operation. The create operation can be invoked in one of three forms: 
   * <tt>vector create</tt> <em>vecName</em>:  This creates a new vector <em>vecName</em> which initially has no components. 
   * <tt>vector create</tt> <em>vecName</em> <tt>(</tt><em>size</em><tt>)</tt>:  This form creates a new vector which will contain <em>size</em> number of components. The components will be indexed starting from zero <tt>(0)</tt>. The default value for the components is zero.
   * <tt>vector create</tt> <em>vecName</em> <tt>(</tt><em>first</em><tt>:</tt><em>last</em><tt>)</tt>: This form creates a new vector with components indexed <em>first</em> through <em>last</em>. <em>First</em> and <em>last</em> can be any integer value so long as <em>first</em> is less than <em>last</em>.

Vector names must start with a letter and consist of letters, digits, or underscores. 

You can automatically generate vector names using the <tt>#auto</tt> vector name. The <b>create</b> operation will return the unique vector name.

!Vector Indices
Vectors are indexed by integers. You can access the individual vector components via its array variable or Tcl command. The string representing the index can be an integer, a numeric expression, a range, or a special keyword.
The index must lie within the current range of the vector, otherwise an an error message is returned. Normally the indices of a vector are start from 0. But you can use the <b>offset</b> operation to change a vector's indices on-the-fly. 
You can also use numeric expressions as indices. The result of the expression must be an integer value. 
The following special non-numeric indices are available: <b>min</b>, <b>max</b>, <b>end</b>, and <b>++end</b>.
The indices <b>min</b> and <b>max</b> will return the minimum and maximum values of the vector.
The index <b>end</b> returns the value of the last component in the vector.
The index <b>++end</b> is used to append new value onto the vector. It automatically extends the vector by one component and sets its value.
A range of indices can be indicated by a colon <tt>:</tt> separating two indices. The colon separated indices can be integers, keywords, or empty. If no index is supplied the first or last component is assumed. 

For more information on RBC vectors get the public domain RBC distribution and see the <b>vector</b> man page or html file.
}

{sltcl} {
The sltcl set of commands all start with the <tt>sl_</tt> prefix. These are the actual commands used to read statmon files and convert their data to [vectors > RBC Vectors].
!Builtin Commands
   * [sl_create]
   * [sl_stat]
   * [sl_kill]
}

{Instance List Data} {
For each instance a sublist of the following exists:
   1 instance name
   1 object name
   1 start time
   1 isActive
   1 sample count
   1 file id
   1 instanceId
}

{Data File Commands} {
Whenever a file is created with [sl_create -file > sl_create] a new Tcl data file command is created. File commands support the following options:
   * <b>-info</b>: return a list of information about the file. The list has the following items:
      1 name
      1 version
      1 platform
      1 productVersion
      1 machine
      1 time string
      1 estimated sampleInterval
      1 isEnabled
      1 list of object types
      1 first timestamp
      1 trimLeft timestamp
      1 trimRight timestamp
   * <b>-instancecount</b>: returns the number of instances the file has.
   * <b>-instances</b>: returns a list of all the files instances. See [Instance List Data] for a description of the result.
   * <b>-objinstances</b> <em>objName</em>: returns a list of all the files instances of the named object type. See [Instance List Data] for a description of the result.
   * <b>-free</b>: frees up all resources used by loading the file and deletes the command.
   * <b>-dump</b>: dump the internal data structures, that contain the files data, in a printable form, to stdout.
   * <b>-update</b>: rereads the file to so if it has more data that can be read. This can be used to continue an interrupted create or read more data from a file that has grown.
   * <b>-disable</b>: Act as if the file has not been loaded.
   * <b>-enable</b>: Act as if the file has been loaded.
   * <b>-trimleft</b> <em>timeStamp</em>: Trim all of the data collected before the timestamp from the file. See [File Trimming] for more information.
   * <b>-trimright</b> <em>timeStamp</em>: Trim all of the data collected after the timestamp from the file. See [File Trimming] for more information.
   * <b>-append</b> <em>fileName</em>: causes this file to start reading the new named file onto the end of the current data. The new files data needs to be newer than the current data. Also the current file needs to be fully loaded.
}

{Line Commands} {
Whenever a file is created with [sl_create -line > sl_create] or [sl_create -derivedline > sl_create] a new Tcl line command is created. Line commands support the following options:
   * <b>-info</b>: return a list of information about the line. The list has the following items:
      1 instance name
      1 statistic name
      1 x vector name
      1 y vector name
      1 scale
      1 filter
      1 object name
      1 fileId list
      1 source list
      1 combo operator
      1 instId
      1 isNormalized
      1 normalize offset
      1 divider
   * <b>-changectr</b> <em>statName</em>: changes the line's statistic.
   * <b>-refilter</b> <em>filter</em>: changes the line's filter.
   * <b>-scale</b> <em>number</em>: scales the y values by <em>number</em>.
   * <b>-adder</b> <em>number</em>: offset the y values by <em>number</em>.
   * <b>-divider</b> <em>number</em>: divides the y values by <em>number</em>.
   * <b>-normalize</b>: forces the min y value to always be zero by subtracting to raw y min value from every y data point.
   * <b>-unnormalize</b>: undoes any normalization.
   * <b>-stats</b> <em>ts1 ts2</em>: returns a list of stats for y data between the specified timestamps. This returned list is:
      1 total number of samples in the range
      1 minimum y value in the range
      1 maximum y value in the range
      1 average of all y values in the range
      1 standard deviation of all y values in the range
      1 first actual timestamp in the range
      1 last actual timestamp in the range
   * <b>-trimleft</b> <em>timeStamp</em>: Trim all of the data collected before the timestamp from all the files used to make the line. See [File Trimming] for more information.
   * <b>-trimright</b> <em>timeStamp</em>: Trim all of the data collected after the timestamp from all the files used to make the line. See [File Trimming] for more information.
   * <b>-copy</b>: copies a line and returns the name of the copies line command.
   * <b>-free</b>: frees up all the resources used by the line and deletes the command.
}

{sl_create} {
The sl_create command lets you create [Data File Commands] and [Line Commands].
!Usages
   * <b>sl_create -file</b> <em>filename</em> ?<em>progressCallback</em>?: Creates a [Data File Commands] by loading the named statmon file. Returns the name of the created [command > Data File Commands]. If a progress callback is specified then it must be a Tcl proc that takes a single argument which is an integer in the range 0..100. The callback will always be called with a value of 100 when reading is complete. The callback should return 1 if loading should continue and 0 if it should be interrupted.
   * <b>sl_create -line</b> <em>instIdList statName filter isAbsolute</em>: Creates a [line > Line Commands] for the given instances and statistic name, and using the given [filter > Statistic Definitions]. Returns the name of the created [command > Line Commands]. If more than one instance is given then their data is all [combined > Combine Menu Item] together. The <em>isAbsolute</em> boolean determines if the time data for the created line will be [absolute or relative > Absolute TimeStamps Menu Item].
   * <b>sl_create -derivedline</b> <em>lineList</em> <b>+|-|/</b> <em>filter copyChildren</em>: Creates a [line > Line Commands] for the given lines using the given operator,and [filter > Statistic Definitions]. Returns the name of the created [command > Line Commands].  The <em>copyChildren</em> boolean determines if the input lines will be [copied or referenced > Main Menu Copy Referenced Lines Item]. For more information see [Line Arithmetic].
}

{sl_stat} {
The sl_stat command is used to perform global operations that are not limited to a particular data file.
!Usages
   * <b>sl_stat -names</b>: Returns a list of all known statistic names.
   * <b>sl_stat -enabledinstances</b>: Returns a list of instances from all the enabled files. See [Instance List Data] for a description of the result.
   * <b>sl_stat -enabledobjinstances</b> <em>objTypeList</em>: Returns a list of instances from all the enabled files of the given obj types. See [Instance List Data] for a description of the result.
   * <b>sl_stat -ctrzero</b> <em>statName instIdList</em>: Returns boolean indicating if named statistic is zero for all the given instances.
   * <b>sl_stat -enabledfiles</b>: Returns a list of [files > Data File Commands] that are enabled.
   * <b>sl_stat -allfiles</b>: Returns a list of all the [files > Data File Commands] that are loaded.
   * <b>sl_stat -alias</b> <em>oldname newname</em>: Causes the statistic <em>newname</em> to be used whenever <em>oldname</em> is found in a loaded statmon file.
   * <b>sl_stat -info</b> <em>name</em> ?<em>infolist</em>?: Returns a list of information on the named statistic. If the optional <em>infolist</em> exists then it must have at most three elements. Empty elements will be ignored. Non-empty ones will modify that value in the statistic's definition:
      1 statistic's [kind > Statistic Definitions]
      1 statistic's [level > Statistic Definitions]
      1 statistic's [default filter > Statistic Definitions]
          The result list has the following elements:
      1 statistic's [kind > Statistic Definitions]
      1 statistic's [level > Statistic Definitions]
      1 statistic's [default filter > Statistic Definitions]
      1 possible empty list of object types that use the statistic
   * <b>sl_stat -getdate</b> <em>ts</em> ?<b>elapsed</b>|<b>date</b>|<b>time</b>?: Given a timestamp convert it to a formatted string and return it. In no format is specified it defaults to <tt>date</tt>.
   * <b>sl_stat -objctrs</b> <em>objList</em>: returns a list of statistic names for the given object types.
   * <b>sl_stat -instinfo</b> <em>instId</em>: returns data describing the given instance id. See [Instance List Data] for a description of the result.
}
{sl_kill} {
The sl_kill command can be usd to kill a process. Vsd uses it to stop a statmonitor it is managing.
!Usages
   * <b>sl_kill</b> <em>pid</em>: kills the process with the given pid.
}

{VSD Files} {
The following files are created or used by VSD.  

!Configuration Files

These files are created in the VSD home directory.  The VSD home directory is, by default, <tt>/home/username/</tt> on UNIX and <tt>c:\users\username\</tt> on Windows. 

If you set the environment variable <tt>$VSDHOME</tt> or <tt>%VSDHOME%</tt> in the environment before starting the vsd executable, this directory is used instead of the user's home directory.

If you are not sure what directory VSD is using, you can see the absolute paths to these files in [About VSD > About VSD].

   * <tt>.vsdrc</tt> The <em>memory file</em> is written each time VSD exits, unless the Main Windows [Save Settings On Exit > Settings SubMenu Save Settings On Exit Menu Item] is selected. It can also be saved using the Main Window Main menu menu item [Save Settings > Main Menu Save Settings Item]. It is read each time VSD starts. VSD uses it to remember its configuration, including window sizes and locations. Deleting it will force VSD back to its default settings. Its syntax is [Tcl > Tcl Language].
   
   * <tt>.vsdconfig</tt> The <em>config file</em> is not written by VSD, unless it does not exist when VSD is started up. It is read and interpreted each time VSD is started. It can be edited (outside of VSD, using a text editor) to reconfigure VSD's defaults; however, any settings in .vsdrc will overwrite settings in this file. Its syntax is [Tcl > Tcl Language]. 

   * <tt><.vsdtemplates</tt> The <em>template file</em> contains templates, convenient shortcuts for commonly used graphs. It is read when VSD is started and any time the [Template Menu <b>Reload Template File</b> Item] is selected. It is written whenever the [Chart Menu <b>Save Template</b> Item] is selected. See [Template Syntax] for a description of its contents.

!Product Files

These files are in the distribution executable directory.

   * <tt>bin/vsd</tt> The <em>source file</em> is never written be VSD. It is read and interpreted each time VSD is started. It contains most of VSD's implementation. Its syntax is [Tcl > Tcl Language]. 

   * <tt>bin/vsdwish</tt><em>OS</em> The <em>binary file</em> is never written be VSD. It is the virtual machine that interprets the [Tcl > Tcl Language] code. The <em>OS</em> part of the name is a platform dependent suffix that names the operating system the binary file will run on.

}

{CacheTooSmall Template} {
The intent of this template is to give you the statistics that will allow you to determine if the shared page cache needs to be made larger.
   * FreeFrameCount for each [shrpc > Shrpc Type] on the [Right Y Axis].
   * FramesFromFindFree for [shrpc > Shrpc Type], [stn > Stn Type], [gems > Gem Type].
   * FramesFromFreeList for [shrpc > Shrpc Type], [stn > Stn Type], [gems > Gem Type].

}

{CommitInfo Template} {
The intent of this template is to give a picture of the overall transactional throughput.
   * TotalCommits for each [stone > Stn Type].
   * CommitRecordCount for each [stone > Stn Type] on the [Right Y Axis].
   * CommitQueueSize for each [stone > Stn Type] on the [Right Y Axis].
}

{EpochSweeps Template} {
The intent of this template is to show statistics related to repository epoch garbage collection.  

   * EpochGcCount for the [stone > Stn Type].
   * EpochScannedObjs for the [stone > Stn Type], on the [Right Y Axis].
   * EpochNewObjsSize for the [stone > Stn Type], on the [Right Y Axis].
   * EpochPossibleDeadSize for the [stone > Stn Type], on the [Right Y Axis].
   * PossibleDeadSize> for the [stone > Stn Type], on the [Right Y Axis].
   
   Epoch GC is diabled by default in GemStone/S 64 Bit, and if the [<b>No Flatlines</b> Menu Item] is enabled, a chart will not be opened.
}

{Garbage Template} {
The intent of this template is to give a picture of the overall repository garbage collection activity.
   * PagesNeedReclaimSize by [combining > Combine Menu Item] all [stone > Stn Type] on the [Right Y Axis].
   * ReclaimedPagesCount by [combining > Combine Menu Item] all [stone > Stn Type] on the [Right Y Axis].
   * EpochCount by [combining > Combine Menu Item] all [stone > Stn Type].
   * ReclaimCount by [combining > Combine Menu Item] all [stone > Stn Type].
   * CommitCount by [combining > Combine Menu Item] all [sessions > Gem Type] named <b>*Gc</b>.
}

{PageServer Template} {
This template gives a picture of the overall async-io done by page servers.
   * AioDirtyCount by [combining > Combine Menu Item] all [page servers > Pgsvr Type].
   * AioCkptCount by [combining > Combine Menu Item] all [page servers > Pgsvr Type].
   * LocalDirtyPageCount for each [shrpc > Shrpc Type].

}

{SpaceFree Template} {
This template gives you the statistics that allow you to determine how much of a resource is available. Currently the only resources supported by this template are the shared page cache and the object repository.
   * FreeFrameCount for each [shrpc > Shrpc Type].
   * FreePages for each [stone > Stn Type] on the [Right Y Axis].

}

{CPU Template} {
This template gives a picture of overall CPU usage. It shows one set of statistics for Unix, and another for Windows.
!Unix
   * UserTime by [combining > Combine Menu Item] all processes.
   * PercentCpuActive for all processes on the [Right Y Axis].
   * PercentCpuWaiting for all processes on the [Right Y Axis].
!Windows
   * SysTime by [combining > Combine Menu Item] all processes.
   * TotalProcessorTime for each [NT system > NtSystem Type].
   * ProcessorQueueLength for each [NT system > NtSystem Type] on the [Right Y Axis].
}

{CacheMix Template} {
The intent of this template is to give a picture of the overall Shared Page Cache Health. When you bring up this template, the following stats are displayed:
   * FreeFrameCount for each [shrpc > Shrpc Type] on the [Right Y Axis].
   * LocalDirtyPageCount for each [shrpc > Shrpc Type]
   * FreeFrameLimit for each [shrpc > Shrpc Type]
   * BitlistPagesWrittenByGem for each [shrpc > Shrpc Type]
   * BitlistPagesWrittenByStone for each [shrpc > Shrpc Type]
   * BmInternalPagesWrittenByGem for each [shrpc > Shrpc Type]
   * BmInternalPagesWrittenByStone for each [shrpc > Shrpc Type]
   * BmLeafPagesWrittenByGem for each [shrpc > Shrpc Type]
   * BmLeafPagesWrittenByStone for each [shrpc > Shrpc Type]
   * CommitRecordPagesWrittenByGem for each [shrpc > Shrpc Type]
   * CommitRecordPagesWrittenByStone for each [shrpc > Shrpc Type]
   * DataPagesWrittenByGem for each [shrpc > Shrpc Type]
   * OtInternalPagesWrittenByGem for each [shrpc > Shrpc Type]
   * OtInternalPagesWrittenByStone for each [shrpc > Shrpc Type]
   * OtLeafPagesWrittenByGem for each [shrpc > Shrpc Type]
   * OtLeafPagesWrittenByStone for each [shrpc > Shrpc Type]
}

{Shared Page Cache} {
The SPC serves several types of data to the processes attached to the cache:

   * data pages
      * DataPagesWrittenByGem
   * object table pages
      * OtInternalPagesWrittenByGem
      * OtLeafPagesWrittenByGem
   * commit record pages
      * BitlistPagesWrittenByGem
      * BmInternalPagesWrittenByGem
      * BmLeafPagesWrittenByGem
      * CommitRecordPagesWrittenByGem

There are some other types of pages, but these are the most common.

If you create a VSD chart from the [CacheMix Template], you can see the mix of these different types of pages in the cache as it performs various operations.

}

{Chart Menu Add From Template SubMenu} {
This submenu has an item for every template.\
Selecting one of these items causes that template to be [expanded > Template Expansion]\
and every line the expansion produces is added to this chart.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-a</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Save Template Item} {
Selecting this menu item causes all of the lines on the chart to be saved as a template.

The saved template is written to the [template file > VSD Files]. The name of the template is based upon the chart window's name.

You can rename the template by editing the [template file > VSD Files] and [reloading > Template Menu Reload Template File Item] it.

Each line on the chart is used as a pattern when saving it to the template. Specific information on the processes is not put in the template, since it is intended to be able to be reused later with other data files. 

Some template features require directly editing the [template file > VSD Files]. 

[Selection Key > Keyboard Selection Keys]: <tt>Alt-s</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Paste Item} {
Selecting this menu item causes the last item that was cut or copied\
to be added to this chart as one or more lines. If it finds something\
on the clipboard to paste it will remove that item from the clipboard.\
A paste operation does nothing if the clipboard is empty.

A paste can also be done with a host dependent <em>Paste</em> key.

[Accelerator Key > Keyboard Accelerators]: <tt>control-v</tt>

See [How to Cut, Copy, and Paste] for more information.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Print Item} {
Selecting this menu item causes the chart to be printed. This is only supported on Unix platforms. The command name stored in the <tt>vsd(exec:lpr)</tt> variable is executed with the contents of a postscript file. The default value of this variable is <tt>lpr</tt> and can be customized in the [config file > VSD Files].

The temporary postscript file is written to VSD's working directory. Use [Main Menu Change Directory... Item] to change this directory.

[Accelerator Key > Keyboard Accelerators]: <tt>control-p</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Snapshot Menu Item} {
Selecting this menu item causes a picture of the chart to be taken and written in .gif format to a file. A dialog is opened allowing you to select the name and location in which the file is written. The default directory is VSD's working directory, and the default name is chart_snapshot.gif.  

 Use [Main Menu Change Directory... Item] to change the working directory.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Help... Item} {
Selecting this menu item causes a [help window > Help Window Features] to\
popup with a description of the [chart window > Chart Window Features].

[Selection Key > Keyboard Selection Keys]: <tt>Alt-h</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Zoom In Item} {
Selecting this menu item begins a zoom in operation on the chart's\
graph. A zoom in consists of the following steps:
   1 Click in the graph at the point you wish to be the upper left hand corner.
   1 Click in the graph at the point you wish to be the lower right hand corner.

Once the operation has begun it can be canceled at any time with\
a right click of the mouse.

See [How to Zoom] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-z</tt>

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Zoom Out Item} {
Selecting this menu item does a zoom out operation on the chart's\
graph. A zoom out will reverse the effects of the most recent zoom in.\
A zoom out does nothing unless the graph is zoomed in at least\
once.

A right click of the mouse over the graph will also do a zoom out.

See [How to Zoom] for more information.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Data Statistics} {
The following statistics on sets of data values are supported by VSD:
   * <b>count</b>: the number of points in the data set.
   * <b>min</b>: the minimum Y value of the points in the data set.
   * <b>max</b>: the maximum Y value of the points in the data set.
   * <b>mean</b>: the average Y value of all the points in the data set.
   * <b>stddev</b>: the standard deviation of all the Y values in the data set.\
Larger standard deviation values mean that more values far away from the\
average exist.
}

{Selecting a Point for an Operation} {
Various chart operations require that you select one or more points on a\
chart's graph. In most of these cases the mouse cursor changes to cross hairs\
to tell you that the graph is in a special mode. Once the mouse cursor is\
over a valid point that can be selected the it changes to a target.\
If you click when its a target the point will be selected.

Note that during this process the mouse will automatically highlights the\
line its closest to and display the coordinates of the line point its\
closest to. See [How to Get Information About a Location] for more information.

In some cases the point must be on a certain line. If another line is\
nearby you may have trouble with its point always being selected instead\
the line you need. Move the line to its own chart or rescale it or change\
its Y axis to remedy this problem.
}

{Chart Menu Compute Scale All Item} {
Selecting this menu item causes every line on the chart to have an\
[optimal scale > Line Menu Compute Scale Item] computed for it.

[Accelerator Key > Keyboard Accelerators]: <tt>control-S</tt>

For more information on scaling see [Display Scaling a Line].

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Unscale All Item} {
Selecting this menu item causes every line on the chart to be\
[unscaled > Line Menu Compute Scale Item].

[Accelerator Key > Keyboard Accelerators]: <tt>control-N</tt>

For more information on scaling see [Display Scaling a Line].

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Legend Item} {
If this item is on then the [chart window > Chart Window Features] will have a [legend > Graph Legend] control.\
Screen space can be saved by turning it off. If it is turned off then\
a description of the selected line will be printed in the  upper left corner of\
the [graph > Graph Display].

Use [Main Chart Menu <b>Show Legend</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Time Format SubMenu} {
This submenu controls what format a timestamp will be displayed in.\
It allows any one, and only one, of the following formats to be selected:
   * [Elapsed Time in Seconds > Elapsed Time in Seconds Format] 
   * [Hour:Minute:Second > Hour:Minute:Second Format]
   * [Month/Day Hour:Minute:Second > Month/Day Hour:Minute:Second Format]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

Use [Main Chart Menu <b>Time Format</b> SubMenu] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Elapsed Time in Seconds Format} {
Use this format to get the least amount of information printed about the timestamp.

If the time stamp is [relative > Absolute TimeStamps Menu Item]\
then this is the number of seconds since the first sample in the file\
it is from. The exact format is <u><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Absolute TimeStamps Menu Item]\
then just the time of day in hours, minutes, and seconds is printed.\
This is exactly the same as the [Hour:Minute:Second Format].
}

{Hour:Minute:Second Format} {
If the time stamp is [relative > Absolute TimeStamps Menu Item]\
then this is the number of hours, minutes, and seconds\
since the first sample in the file it is from.\
Only non-zero counts are show.\
The exact format is\
<u><em>num</em><b>h</b><em>num</em><b>m</b><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>h</b> stands for hours
   * <b>m</b> stands for minutes
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Absolute TimeStamps Menu Item]\
then just the time of day in hours, minutes, and seconds is printed.\
The exact format is <u><em>hours</em><b>:</b><em>minutes</em><b>:</b><em>seconds</em></u> where:
   * <em>hours</em> is a value in the range 0..23; two digits are always printed.
   * <em>minutes</em> is a value in the range 0..59.
   * <em>seconds</em> is a value in the range 0..61;\
the value 60 allows for the occasional leap second;\
the value 61 allows for the occasional double leap second.
}

{Month/Day Hour:Minute:Second Format} {
If the time stamp is [relative > Absolute TimeStamps Menu Item]\
then this is the elapsed number of days, hours, minutes, and seconds\
since the first sample in the file it is from.\
Only non-zero counts are show.\
The exact format is\
<u><em>num</em><b>d</b><em>num</em><b>h</b><em>num</em><b>m</b><em>num</em><b>s</b></u> where:
   * <em>num</em> is a sequence of digits
   * <b>h</b> stands for days
   * <b>h</b> stands for hours
   * <b>m</b> stands for minutes
   * <b>s</b> stands for seconds

If the time stamp is [absolute > Absolute TimeStamps Menu Item]\
then the month, day of the month, and  the time of day in hours, minutes, and seconds is printed.\
The exact format is <u><em>month</em><b>/</b><em>day</em> <em>hours</em><b>:</b><em>minutes</em><b>:</b><em>seconds</em></u> where:
   * <em>month</em> is a value in the range 1..12; two digits are always printed.
   * <em>day</em> is a value in the range 1..31; two digits are always printed.
   * <em>hours</em> is a value in the range 0..23; two digits are always printed.
   * <em>minutes</em> is a value in the range 0..59.
   * <em>seconds</em> is a value in the range 0..61;\
the value 60 allows for the occasional leap second;\
the value 61 allows for the occasional double leap second.
}

{Chart Menu Show Time Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title under the graph's [X Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Time Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Left Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title next to the graph's [Left Y Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Left Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Right Axis Title Item} {
If this item is on then the [chart window > Chart Window Features] will display a title next to the graph's [Right Y Axis].
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Right Axis Title</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Current Values Item} {
If this item is on then the [chart window > Chart Window Features] will have\
[X: > Chart Window X: Display] and [Y: > Chart Window Y: Display] controls
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Current Values</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Min and Max Item} {
If this item is on then the [chart window > Chart Window Features]\
will have [Min: > Chart Window Min: Display] and [Max: > Chart Window Max: Display] controls.
Screen space can be saved by turning it off.

Use [Main Chart Menu <b>Show Min and Max</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Line Stats Item} {
If this item is on then the [chart window > Chart Window Features]\
will display [line statistics > Data Statistics] in the upper left corner of its [graph > Graph Display].
Turning it off saves the cost of computing these statistics and can make it easier to view lines with points in the upper left corner.

Use [Main Chart Menu <b>Show Line Stats</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show CrossHairs Item} {
If this item is on then the [chart window > Chart Window Features] will draw cross hair lines on its [graph > Graph Display].

Use [Main Chart Menu <b>Show CrossHairs</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Show Grid Lines Item} {
If this item is on then the [chart window > Chart Window Features] will draw dotted grid lines on its [graph > Graph Display].

Use [Main Chart Menu <b>Show Grid Lines</b> Item] to control the initial state\
of this item.

This item is part of the [chart menu > Chart Window Chart Menu].
}

{Chart Menu Close Item} {
Selecting this item causes the chart window to no longer exist.\
This can also be done using the native window manager.

To close all your chart windows use the [Main Chart Menu <b>Close All Charts</b> Item].

This item is part of the [chart menu > Chart Window Chart Menu].
}


{Chart Window Line Menu} {
This menu is disable until a [line is selected > How to Select a Line].
Operations on this menu apply to the selected line.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-l</tt>

This menu is on each [chart window > Chart Window Features].

!Items
   * [Log Info > Line Menu Log Info Item]
   * [Log Delta > Line Menu Log Delta Item]
   * [Compute Scale > Line Menu Compute Scale Item]
   * [Unscale > Line Menu Unscale Item]
   * [Graph on Left Axis > Line Menu Graph on Left Axis Item]
   * [Symbol > Line Menu Symbol SubMenu]
   * [Style > Line Menu Style SubMenu]
   * [Update > Line Menu Update Item]
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]
   * [Change Integer Type > Line Menu Change Integer Type Item]
   * [Normalize > Line Menu Normalize Item]
   * [Trim Left > Line Menu Trim Left Item]
   * [Trim Right > Line Menu Trim Right Item]
   * [Untrim Left > Line Menu Untrim Left Item]
   * [Untrim Right > Line Menu Untrim Right Item]
   * [Copy > Line Menu Copy Item]
   * [Cut > Line Menu Cut Item]
   * [Delete > Line Menu Delete Item]
}

{Line Menu Change Integer Type Item} {
The <em>Change Integer Type</em> item on the [Chart window line menu > Chart Window Line Menu]
 allows you to change how VSD interpretes numbers in the selected line. 
 Options are <em>Signed 32 bit</em>, <em>Unsigned 32 bit</em>, <em>Signed 64 bit</em>, and <em>Unsigned 64 bit</em>.
}


{Line Menu Log Info Item} {
Selecting this item causes information on the current line to be written to the [log window >Log Window]. The information includes:
   * The process entity name or a combined identifier, and the statistic for this line
   * the line's [value scale > Value Scaling a Line] if any
   * the line's [offset > Offsetting a Line] if any
   * the line's filter. The prefix <tt>filter:</tt> is used.
   * the line's units. The prefix <tt>units:</tt> is used.
   * an indicator if the line was normalized. The keyword <tt>normalized</tt> is used.
   * the line's files. The prefix <tt>file:</tt> or <tt>files:</tt> is used.
   * if the line is a [combination > Combine Menu Item] of more than one process list entity, then a list of each of the process names. The keyword <tt>dataSources:</tt> heads this section.
   * if the line was created using [arithmetic > Line Arithmetic] then full information, except for line statistics, is given on each of the derived lines. Also the operator used is shown.
   * the line's statistics which include:
      * the statistic range. This consists of the times of the first and last sample used to compute the statistics
      * the minimum value in the statistic range
      * the maximum value in the statistic range
      * the average of all the values in the statistic range
      * the standard deviation of all the values in the statistic range

[Selection Key > Keyboard Selection Keys]: <tt>Alt-i</tt>

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Log Delta Item} {
This operation item allows you to [log > Log Window] information obtained\
by comparing two points.

[Accelerator Key > Keyboard Accelerators]: <tt>control-d</tt>

Once the operation has begun it can be canceled at any time with\
a right click of the mouse.

!Usage
   1 Select the line the two points are on.
   1 Select the item.
   1 [Select > Selecting a Point for an Operation] the first point.
   1 [Select > Selecting a Point for an Operation] the second point. A thin black line will be drawn between the\
first point and the mouse cursor to remind you of what you are comparing.
   1 View the [logged > Log Window] information.

!Logged Information
The following information is logged by this operation:
   * A description of the line the points were on.
   * The exact coordinates of the two points.
   * <b>time delta</b>: the absolute difference between the two point's X coordinates.
   * <b>value delta</b>: the difference between the two point's Y coordinates.\
This is done by subtracting the first point's Y value from the second point's\
Y value.
   * <b>value/time delta</b>: the result of dividing the <em>value delta</em>\
by the <em>time delta</em>.
   * <b>data statistics</b>: [statistics > Data Statistics] for all the data points\
on the line between the two selected points.

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Compute Scale Item} {
Selecting this item sets the current lines [display scale > Display Scaling a Line] to a value such that the lines maximum value will display at the top of the Y axis its plotted on.

[Accelerator Key > Keyboard Accelerators]: <tt>control-s</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Unscale Item} {
Selecting this item sets the current line's [display scale > Display Scaling a Line] to one.

[Accelerator Key > Keyboard Accelerators]: <tt>control-n</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Graph on Left Axis Item} {
If this item is checked then the current line is plotted on the [left axis > Left Y Axis]. Otherwise its plotted on the [right axis > Right Y Axis]. If you have two lines whose values differ greatly then plotting them on separate axis can help in comparing the two lines visually.

[Accelerator Key > Keyboard Accelerators]: <tt>control-a</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Symbol SubMenu} {
This submenu lets you select the symbol that will be used to display the data points of the current line. By default no symbol is used to the data points blend in with the lines that connect them. Using a symbol lets you see the actual data points. Symbols tend to blend together if you have a large number of data points so only use this feature when you have [zoomed > How to Zoom] in to a smaller region. The symbols are:
   * <b>scross</b>: a simple X
   * <b>splus</b>: a simple +
   * <b>square</b>: a square
   * <b>triangle</b>: a triangle
   * <b>circle</b>: a circle
   * <b>diamond</b>: a diamond
   * <b>plus</b>: a fancy +
   * <b>cross</b>: a fancy X

[Selection Key > Keyboard Selection Keys]: <tt>Alt-s</tt>

This submenu is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Style SubMenu} {
This submenu lets you select the style used to connect the data points when displaying the current line. The default style is <b>linear</b>. The style does not change the actual data points just the lines drawn between them. The available styles are:
   * <b>linear</b>: a simple line segment is drawn between each pair of data points.
   * <b>step</b>: two line segments are drawn between each pair of data points. The first is a horizontal line segment that steps to the next X-coordinate. The second is a vertical line that steps to the next Y-coordinate.
   * <b>natural</b>: multiple line segments, generated using a cubic spline, are drawn between each pair of data points.
   * <b>quadratic</b>: multiple line segments, generated using a quadratic spline, are drawn between each pair of data points.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This submenu is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Update Item} {
Selecting this item will cause all the files used by the current line to be [updated > How to Update the View of a Data File] which may result in the line becoming longer.

[Accelerator Key > Keyboard Accelerators]: <tt>control-u</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Add Lines Item} {
Selecting this item starts the process of adding another line to the current line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of adding the first two lines together. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-+</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Diff Lines Item} {
Selecting this item starts the process of subtracting another line from the current line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of subtracting the first line from the second. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control--</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Divide Lines Item} {
Selecting this item starts the process of dividing the current line by another line. Vsd will prompt you to select the other line. You can <em>left click</em> on either the line or its [legend > Graph Legend] entry to select it. You can <em>right click</em> to cancel the operation. If you do select another line then a new line is produced which is the result of dividing the first line by the second. See [line arithmetic > Line Arithmetic] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-/</tt>

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Normalize Item} {
If this item is checked then the line will be [normalized > Normalizing a Line]. It is renormalized any time its data points change.
If its not checked then you are free to set the line's [offset > Offsetting a Line] to any value.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Trim Left Item} {
Selecting this item starts a trim left operation. You can either select a data point on the current line or <em>right click</em> to cancel the operation. To select a data point move the mouse over the line. The cursor will turn into a circle when its over a valid trim point. If you want to ignore all the data to the left of this trim point then <em>left click</em>.

See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Trim Right Item} {
Selecting this item start a trim right operation. You can either select a data point on the current line or <em>right click</em> to cancel the operation. To select a data point move the mouse over the line. The cursor will turn into a circle when its over a valid trim point. If you want to ignore all the data to the right of this trim point then <em>left click</em>.

See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Untrim Left Item} {
Selecting this item causes any left trims done to the current line's files to be undone. See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Untrim Right Item} {
Selecting this item causes any right trims done to the current line's files to be undone. See [File Trimming] for more information.

This item is part of the [line menu > Chart Window Line Menu].
}

{Line Menu Copy Item} {
Selecting this item makes a copy of the currently selected line and puts it on the paste clipboard. For more information see [How to Cut, Copy, and Paste].

[Accelerator Key > Keyboard Accelerators]: <tt>control-c</tt> or a host dependent <em>Copy</em> key.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Cut Item} {
Selecting this item removes the currently selected line from the graph and puts it on the paste clipboard. For more information see [How to Cut, Copy, and Paste].

[Accelerator Key > Keyboard Accelerators]: <tt>control-x</tt> or a host dependent <em>Cut</em> key.

This item is part of the [line menu > Chart Window Line Menu].
}
{Line Menu Delete Item} {
Selecting this item deletes the currently selected line. Once its deleted it cannot be undeleted.

You can also delete a line by middle clicking the mouse on its [legend > Graph Legend] entry.

[Accelerator Key > Keyboard Accelerators]: <tt>Del</tt>

This item is part of the [line menu > Chart Window Line Menu].
}

{Display Scaling a Line} {
You usually want to change the scale of a line because it looks like a\
flat line due to another line with very large values. The easiest thing\
you can do is graph the line on the other y axis. This will cause the\
line to be scaled independently of lines on the other axis.
The next easiest thing is to use the [Line Menu <b>Compute Scale</b> Item]. This will\
compute a scale value for the current line that make it visable on the\
current graph. You can quickly undo this with the [Line Menu <b>Unscale</b> Item].
You can also manually change the scale using the up or down arrow\
by the [number entry > Chart Window Number Entry] in the upper right corner of a chart. First click\
on the [button > Chart Window Operator MenuButton] next the number entry and pick <b>S</b> from the dropdown.\
Each click doubles or halves the scale.
You can also enter any scale you want by clicking on the existing value and\
changing it using the keyboard.
The default scale is one. Changing the\
scale just causes the line to be drawn differently, it does not modify\
the actual values of the data points.
}

{Value Scaling a Line} {
The data points of a line can all be multiplied (or divided) by a constant. This is done\
by adding (or subtracting) a constant value from every data point on the line.
To specify a multiplier constant select a line and then click on the [button > Chart Window Operator MenuButton] next\
to the number entry in the upper right corner of a chart window. Pick <b>*</b>\
or <b>/</b> from the dropdown and then enter the constant into the [number entry > Chart Window Number Entry].\
Each click of the up or down arrow doubles or halves the constant.
Multiplier constants are always done after the data is filtered and\
before an offset constant and scale constant are applied.
Note that unlike a scale, which is for display purposes only, a multiplier\
actually changes the y values of the line's data points. A common use\
is to change the units of a line. For example kilobytes can be changed to\
bytes by multiplying by 1024.
}

{Offsetting a Line} {
The data points of a line can all be offset by a constant. This is done\
by adding (or subtracting) a constant value from every data point on the line.
To specify an offset constant select a line and then click on the [button > Chart Window Operator MenuButton] next\
to the number entry in the upper right corner of a chart window. Pick <b>+</b>\
or <b>-</b> from the dropdown and then enter the constant into the [number entry > Chart Window Number Entry].\
Each click of the up or down arrow change the offset constant by one.
Offset constants are always done after a multiplier constant is applied\
and before a scale constant is applied.
Note that the normalization feature automatically computes the offset so if\
a line is normalized then a user supplied constant is ignored.
}

{Normalizing a Line} {
If a line is normalized then an offset is computed so that its\
minimum data point will have a value of zero.\
The normalization offset is recomputed any time the data for the line changes.
If a line is normalized then it cannot be offset by a constant value\
other than the one computed by the normalization code. 
Normalization is ignored unless the filter is "none".
}

{List Multiple Selection} {
Some list items allow more than one item in the list to be selected.
   * A single item can be selected by clicking on it.
   * Multiple disjoint items can be selected by holding the <tt>Control</tt>\
key down when clicking on the items.
   * Multiple contiguous items can be selected by holding the <tt>Shift</tt> key down\
or by drag selecting.
   * A selected item can be deselected by holding the <tt>Control</tt>\
key down and clicking on it.
}

{String Entry Editing} {
When entering a string the following  special editing operations are available:
   * <tt>Control-a</tt> or the <em>Home</em> moves the cursor to the beginning of the string. If the shift modifier is used with the <em>Home</em> key then the selection is also extended to the beginning.
   * <tt>Control-e</tt> or the <em>End</em> key moves the cursor to the end of the string. If the shift modifier is used with the <em>End</em> key then the selection is also extended to the end.
   * <tt>Control-b</tt> moves the cursor back one character.
   * <tt>Control-f</tt> moves the cursor forward one character.
   * <tt>Control-t</tt> reverses the order of the two characters to the left of the cursor.
   * <tt>Control-k</tt> deletes all the characters to the right of the cursor.
   * <tt>Control-d</tt> or the <em>Delete</em> key deletes a single character to the right of the cursor.
   * <tt>Meta-d</tt> deletes a single word to the right of the cursor.
   * <tt>Control-/</tt> selects all the text.
   * <tt>Control-\</tt> clears any selection.
   * <tt>Control-h</tt> or the <em>Backspace</em> key deletes a single character to the left of the cursor if nothing is selected. Otherwise they delete the selection.
   * <tt>Meta-w</tt>, <tt>F16</tt>, or the <em>Copy</em> key copies the selection to the clipboard. Does nothing if no selection.
   * <tt>Control-w</tt>, <tt>F20</tt>, or the <em>Cut</em> key copies the selection to the clipboard and deletes the selection. Does nothing if no selection.
   * <tt>Control-y</tt>, <tt>F18</tt>, or the <em>Paste</em> key inserts the contents of the clipboard at the position of the cursor.
}

{Mouse Help} {
If you hold the mouse pointer over a widget explanatory text will appear\
in the [status box > Main Window Status Display].
}

{Bell Messages} {
If vsd ever beeps this indicates a warning or error.\
Look for the reason why in the [status box > Main Window Status Display].
Bell messages timeout after 10 seconds.
}

{Keyboard Selection Keys} {
Many menus, menu items, and buttons have a selection key. Selection keys are\
indicated by underlining a letter in the name of the control.\
It is used by holding down the <tt>Alt</tt> key and pressing the selection key.\
Using the selection key is equivalent to clicking the mouse on the control.
Keyboard selection keys are case-insensitive.
Keyboard selection keys only work if the control the selection key is bound\
to is visible on the screen and its window is selected.
}

{Keyboard Accelerators} {
Some menu items have keyboard accelerators.\
Accelerators allow you to quickly invoke a menu item.\
Accelerators are displayed next to the name of the menu item.\
Using the accelerator is equivalent to clicking the mouse on the item.
Keyboard accelerators are case-sensitive.
Keyboard accelerators work as long as the window the menu belongs to is selected.
}

{General Interface Features} {
Some features are common to all operations in VSD. 

   * [List Multiple Selection]
   * [String Entry Editing]
   * [Mouse Help]
   * [Context Sensitive Help]
   * [Bell Messages]
   * [Keyboard Selection Keys]
   * [Keyboard Accelerators]
}

{Context Sensitive Help} {
A [help window > Help Window Features] containing context sensitive help can be created by pressing the <tt>F1</tt> key.
The help text will pertain to the window and widget that has keyboard focus.
}

{How to Load a Data File} {
The [Main Menu <b>Load Data File...</b> Item] can be used to browse for a file to load.

You may also just [enter > String Entry Editing] the full path in the [File: > Main Window File ComboBox] field, and hit return.

The command line can specify files to load when [vsd is started > How to Start VSD].

While a file is loading you can interrupt that load by clicking on\
the <b>Interrupt</b> button in the progress window. All the data already read\
will be available and the load can be continued later with the [File Menu <b>Update</b> Item].

You can switch to a data file you already have loaded by dropping\
down the [File: > Main Window File ComboBox] control's list and selecting it.

For more information related to loaded files see [Controlling the Enabled Files].
}

{How to Update the View of a Data File} {
The [File Menu <b>Update</b> Item] will reread the current data file if it has\
changed since the last time vsd read it. 
Any charts displaying data from that file will also be updated.
If the [File Menu <b>Auto Update</b> Item] is turned on then vsd will keep doing the update\
operation everytime the file changes. The auto update interval is based\
on the sample interval of the data file.
}

{How to Create a Data File} {
Data files are created by a [statmonitor] or by GBS/VW.  
You can run the <tt>statmonitor</tt> command directly from the server product command line 
or in more recent versions by automatic startup from the configuration files.  
You can also create a file by live monitoring, using the [Main Menu <b>Monitor...</b> Item]. Note that you must have defined $GEMSTONE in the VSD environment for the version that you wish to monitor. 
The [Monitor Window] will show you all the GemStone caches on the local machine\
that you can monitor. Click on the cache you want to monitor, set the statmonitor arguments, and then click on Start.\
Vsd will automatically load the data file once it has some samples in it.
When you are done monitoring, click on Stop in the [Monitor Window]. Vsd will shutdown any monitors it started when you exit vsd.  The statmonitor data files are not deleted. 

See the GBS/VW Users Guide for how to create GBS statistics files, which are generated when enabled within GBS.  GBS generates data files in the binary .gfs format.  This format also encodes the Process List Entity Types, and the names and descriptions of the individual statistics.  
}

{How to Compare Files} {
In many cases vsd is used to compare multiple runs of the same load under\
different configurations or versions of the product.\

The following features facilitate comparision of files:
   * Turn off the Main Menu [<b>Single File Mode</b> Menu Item] so that more than one file can be loaded.
   * Turn off the Main Menu [<b>Combine</b> Menu Item].
   * Turn off the Main Menu [<b>Absolute TimeStamps</b> Menu Item] so that vsd will act as if each data\
run started at the same time.

Many data runs have a startup period at the beginning and a shutdown period at\
the end which are usually misleading for comparison purposes. To get rid\
of these do the following:
   * Chart a good representative line from each file.
   * Then for each line use the [Line Menu <b>Trim Left</b> Item] to get rid of all the data from the\
file's startup period and the [Line Menu <b>Trim Right</b> Item] to get rid of all the data from the\
file's shutdown period.

See [File Trimming] for more information.

If you want to compute the difference between two data runs then try this:
   * Chart a line from each data run's file.
   * Then select one of the lines and pick the [Line Menu <b>Diff Lines</b> Item] and\
then select the other line.

The result will be a third line whose values are the difference between the two original lines.\
See [Line Arithmetic] for more information.
}
 
{How to Merge Files} {
In some cases you may have multiple data files that you want to treat as a single file. \

If the files are for the same system and version, in chronological order, and have data for the same processes, \
then you can use the [Append Data File... > Main Menu Append Data File... Item].

}

{Statmonitor Output Format} {
Files written by [statmonitor] have a simple text format. They may be compressed using the standard gzip or lz4 format; VSD handles the compressed files transparently.

[statmonitor] support for writing file in lz4 format requires GemStone/64 version 3.4 or later.
Vsd also allows files to be concatenated. You should only concatenate files which do not overlap in time and they should be ordered by time when concatenated.

The first line of the file must be of the form:
   * <tt>STATMON "</tt><em>N</em><tt>"</tt>
where <em>N</em> is one or more digits. This number represents the format version used in writing the rest of the file. 
GemStone/S 64 Bit v3.6 and later statmonitor writes files in version <b>4</b>, while 32-bit GemStone/S 6.2 through GS64 v3.5.x write version <b>3</b>. 
VSD v5.5.x reads files written with version <b>4</b>, <b>3</b>, or earlier.

A <em>propertyDefinition</em> has the form:
   * <em>propertyName</em><tt> = "</tt><em>propertyValue</em><tt>"</tt>
where <em>propertyName</em> is a name and <em>propertyValue</em> is a string.
The next four lines are <em>propertyDefinitions</em> with these names:
   1 <tt>Platform</tt>  the value describes the operating system that the file was generated on.
   1 <tt>GemStoneVersion</tt>  the value describes the version of statmonitor's product.
   1 <tt>Machine</tt>  the value describes specific details about the machine the file was generated on.
   1 <tt>Time</tt>  the value describes the time, including timezone, that the first sample was written.
   1 <tt>CmdLine</tt>  the command line arguments used to start statmonitor (added v3.6).

The next item in the format is a definition of the process list types used. The form is:
   * <tt>StatTypes = &#91;</tt><em>typeList</em><tt>]</tt>
where a <em>typeList</em> is zero or more comma separated <em>typeDefinitions</em>. A <em>typeDefinition</em> has the form:
   * <em>typeName</em><tt> ( </tt><em>statNames</em><tt> ) </tt><em>typeId</em>
where <em>typeName</em> is the name of the type, <em>typeId</em> is a number used to identity this type, and <em>statNames</em> is five or more names representing the type's statistics. These names define the meaning of the fields in each snapshot (see the following) is. The first five <em>statNames</em> must always be:
   1 <tt>StatTypeNum</tt>  the numeric id of the snapshot's type
   1 <tt>Time</tt>  the time the snapshot was taken
   1 <tt>ProcessName</tt>  a string describing the snapshot's entity
   1 <tt>ProcessId</tt>  a number describing the process associated with the snapshot's entity. Zero if there is no associated OS process.
   1 <tt>SessionId</tt>  For processes that create a session in the cache, a number uniquely identifying the session. Zero if not applicable.

The next line has the form:
   * <tt>%%%%Generated by the statistics monitor</tt>
The next line has the form:
   * <tt>ENDHEADER</tt>
The next line is a blank line.

After this each line is a snapshot. Each snapshot is for a specific process and includes a value for each statistic associated with that process type. The snapshot is a list of whitespace separated strings. Most of the strings are unsigned numbers.
For example: 
   16 1642634579 StatMon 15152 0 0 0 0 1
The number of entries must be the same as the number of statNames for that snapshot's type. 
}

{How to Start VSD} {
Vsd can be started on the command line with zero or more command line arguments. The arguments include switches, an optional startup directory path, and optionally one or more data files to load.
VSD can also be started on windows by double clicking on the icon or dropping a data file onto the icon.
!Switches
   * [<tt>-a</tt> > append load command line switch] -- append 
   * [<tt>-A</tt> > append and auto-update command line switch] -- append and auto-update (unix only)
   * [<tt>-b color</tt> > Background Color] -- set background color
   * [<tt>-u</tt> > open and auto-update command line switch] -- open and auto-update (unix only)
}

{append and auto-update command line switch} {
The <tt>-A</tt> command line switch causes all files loaded on the command line after this switch to be concatenated together. This is done by loading the first one after the <tt>-a</tt> normally and then [appending > Main Menu Append Data File... Item] the rest of the files to it. In addition, it enables continuous append with auto-append mode.
}

{open and auto-update command line switch} {
The <tt>-u</tt> command line switch causes all files loaded on the command line after this switch to be opened as individual files. In addition, it enables continuous append with auto-append mode.
}

{append load command line switch} {
The <tt>-a</tt> command line switch causes all files loaded after this switch to be concatenated together. This is done by loading the first one after the <tt>-a</tt> normally and then [appending > Main Menu Append Data File... Item] the rest of the files to it. 
}

{Background Color} {
VSD supports setting a background color for all windows in a particular instance of VSD.  This allows you to have multiple VSD instances running, analyzing or monitoring different files, and be able to immediately identify which charts are associated with which system.  

There are several ways to set the master background color:

   * The master background color can be set by the Main Window Main menu item <b>Set Master Background Color...</b>.  This opens a platform-specific color selection dialog allowing you to choose a color.  
   * The master background color can be set with the <tt>-b color</tt> command line switch.  The color may be specified by name (e.g.: white) or by RGB value (e.g.: #d3d3ff).  
   * The master background color may also be set in the environment variable <tt>VSD_MASTER_BG_COLOR</tt>, also by  name or RGB value.

The master background color is NOT written to the .vsdrc, since the expectation is that each vsd instance would want a different background color.

Setting a master background color cannot be undone.

The following web page shows a complete list of colors accepted by VSD: <tt><u>http://www.tcl.tk/man/tcl8.4/TkCmd/colors.htm</u></tt>
}

{How to Select Processes and Statistics for Analysis} {
The [process list pane > Process List Entity Definition] displays a list of the processes and other enties in the loaded files.  There are different statistics available for various [process types > Process List Item Type Definition]. 

To graph a line you need to select one or more entries in the process list, and one or more statistics that are of interest. 

The following links tell you how to control what processes and statistics will be available to select, and how to do the actual selection.
   * [Controlling the Enabled Files]
   * [Controlling the Process List Entries]
   * [Controlling the Listed Statistic Names]
   * [How to Select Process List Entities]
   * [How to Select Statistics]
}
 
{Controlling the Enabled Files} {
The main window will only display processes in the process list that are in files that are loaded and not disabled.\

If the [<b>Single File Mode</b> Menu Item] is checked then only one loaded file can be\
enabled at a time. In this mode each time a file is loaded it will enabled, \
and the previous file disabled. If an already loaded file is picked from\
the [File: > Main Window File ComboBox] control then it becomes the enabled file.

If the [<b>Single File Mode</b> Menu Item] is unchecked then more than one loaded file can be\
enabled. Processes for all  enabled files will be shown in the\
main window. The [File: > Main Window File ComboBox] control will show the current selected loaded file.\

The [Main Window File Menu] items operate on this file. Each file can be\
explicitly enabled or disabled with the [File Menu <b>Enabled</b> Item].
}
 
{Controlling the Process List Entries} {
The order that the process are listed in can be controlled by clicking on the column header. 

The primary sort key will be the clicked on column which will include an up or down arrow.  

Click on the same column again to reverse the order.  The secondary sort key may be selected by right-clicking on any column except the primary sort key column.  
The secondary sort key is indicated by italic font in the column header.\

The secondary sort column is always sorted in the same order (ascending or descending) as\
the primary sort column.

If the [<b>Single File Mode</b> Menu Item] is checked then only process entities from the\
most currently selected file will be listed. 
Otherwise the process entities from every enabled file are listed. 

You can control which files are\
enabled by selecting the file with the [File: > Main Window File ComboBox] control and\
then using the [File Menu <b>Enabled</b> Item].
}
 
{Controlling the Listed Statistic Names} {
The statistics list will only contain the name of statistics that\
all of the selected processes in the process list have in common. If no process is \
selected then all known statistics are listed.
If the [<b>No Flatlines</b> Menu Item] is unchecked then statistics whose values\
are all zero have names show in a light font.\
Otherwise these statistic names are not listed.
}
 
{How to Select Process List Entities} {
The Main Window Process list pane allows you to select one or more processes. In most cases, just select the process or processes of interest; you can select multiple processes by shift-select. 

If you are interested in all of processes or entities of a certain type or name, then you can manually select them all, or use the Main Menu menu item [Select Instances By Menu Item] to specified criteria.  

Control-S or control-F also provides the ability to search. A search window will popup\
in which you can type. Enter <tt>control-s</tt> or <tt>tab</tt> to find the next match.\
Enter <tt>return</tt> to get rid of the search window. If you enter a number then\
the search will be based on the process id field. Otherwise the name field is used.

Only statistics the selected processes all have in common will be shown.\

If the Main Menu [<b>Combine</b> Menu Item] is checked then all the data for the selected processes\
will be added together when a line is created. Otherwise the statistics for each process\
will get its own line.\

Right clicking over the process list pane gets a [popup menu > Process List Pane PopupMenu]. 
}
 
{How to Select Statistics} {
Click on the statistic you want to select.
If you select [more than one > List Multiple Selection] statistic you get a line for each one.

To search for a statistic whose name starts with a known prefix simply\
type the letters of that prefix and the first statistic with that\
prefix will be shown.

To find a statistic whose name contains a known substring do a [search > List Search Control] by typing <tt>control-s</tt>.
}

{List Search Control} {
This control allows a list to be searched. The search always finds the next item in the list that has a substring containing the text being searched for. As text is typed in the search is done automatically. The control contains the text from the last search.

When doing an [process list > Main Window Process List Table] search if you just type in a number then only the <b>Pid</b> column is searched and vsd beeps when it finds a completely matching pid. Otherwise the search is done on the <b>Name</b> column. If you want to search for a number in the name column then you must also include a non-numeric prefix. For example to search for a session id prefix it with the <tt>-</tt> character.

!Key operations
   * [standard editing > String Entry Editing]
   * <tt>control-s</tt> , <tt>control-f</tt> or <tt>tab</tt> to find the next matching list element
   * <tt>control-r</tt> to find the previous matching list element
   * <tt>return</tt> or click somewhere else to terminate the search

The following controls support this control:
   * [Main Window Process List Table]
   * [Main Window Statistic List]
   * [Chart Window Statistic ComboBox]
   * [Statistic Window Name ComboBox]
}
 
{How to Understand a Statistic} {
If the [Main Menu <b>Show Statistic Info</b> Item] is checked then a\
[separate window > Statistic Information Window]\
will be created that will be kept updated with information on the most\
currently selected statistic.
In the [statistic information window > Statistic Information Window] you can browse all the available statistics\
and modify the statistic's default filter.\
Any modification will be saved when you exit vsd.
}
 
{How to Filter Statistics} {
The filters are: Default, None, PerSecond, PerSample, and Aggregate.
<b>Default</b> gets you None if the statistic represents a snapshot of a value.\
It gets you PerSecond if the statistic represents a value that always increases.
<b>None</b> shows you the raw values for the statistic with no filtering at all.
<b>PerSample</b> shows you the difference between two consecutive samples\
of the statistic.
<b>PerSecond</b> is the same as PerSample except it divides the difference by the number\
of elapsed seconds between the two samples.
<b>Aggregate</b> shows you a running total of per sample deltas for the statistic.\
The running total is reset to zero when the current delta is zero or\
changes direction. For example if the last couple of delta where positive\
then a change in direction would be a delta with a negative value.
When a line is added to a chart the default filter is used.\
The default filter for a statistic can be redefined using the [Default Filter MenuButton].
Once the line is added you can change its filter using the [Chart Window Filter MenuButton].
}
 
{How to Create a New Chart} {
Select the [process > How to Select Process List Entities] and [statistics > How to Select Statistics]\
to display in the new chart and click on the [Main Window New Chart Button].

You can let VSD generate a name for the new chart or enter one yourself\
in the [Chart: entry field > Main Window Chart: Entry Field ComboBox].

The new chart will be configured based on options found in the [Main Window Chart Menu].\
If you change these options they will be saved and used the next time you start vsd.

A chart window can be created with the following controls:
   * [Add Line > Main Window Add Line Button]
   * [New Chart > Main Window New Chart Button]
   * [Add To Chart > Main Chart Menu Add To Chart Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]

To learn more about what can be done with a chart see [Chart Window Features].
}
 
{How to Add a Line to an Existing Chart} {
Select the [process or processes > How to Select Process List Entities] and [statistics > How to Select Statistics]\
to add, and click on the [Main Window <b>Add Line</b> Button].

The line will be added to the chart shown in the [Chart: entry field > Main Window Chart: Entry Field ComboBox].
}
 
{How to Cut, Copy, and Paste} {
You can copy or cut the selected line from a chart.\
Once this is done it can be pasted once to a chart.\
This allows you to easily move lines from one chart to another and\
to create a copy of a line to modify without changing the orignal.
You can copy and paste the current process and statistic selection\
from the main window to a chart window. This allows for easier chart\
targeting in cases that you have a large number of charts.
A copy or cut puts an item on the clipboard and deletes any item that was\
already on the clipboard.
A paste causes the clipboard to be emptied.

!Key operations
   * <b>Copy</b> is done with <tt>control-c</tt> or a host dependent <em>Copy</em> key.
   * <b>Cut</b> is done with <tt>control-x</tt> or a host dependent <em>Cut</em> key.
   * <b>Paste</b> is done with <tt>control-v</tt> or a host dependent <em>Paste</em> key.

!Related Menu Items
   * [copy selection > Main Menu Copy Selection Item]
   * [copy selected line > Line Menu Copy Item]
   * [cut selected line > Line Menu Cut Item]
   * [paste selection or line > Chart Menu Paste Item]
}
 
{How to Select a Line} {
Move the mouse onto the line you want to select. Once the line\
is highlighted click on it.
You can also select a line by clicking on it in the legend.
Deselect a line by clicking on it again.
}
 
{How to Get Information About a Location} {
Move the mouse in the graph itself.\
If the mouse gets close to a line it will be highlighted. Also if the\
mouse is close to an actual data point its X and Y values will be displayed.
}
 
{How to Delete a Line} {
Select the line and then use the [Line Menu <b>Delete</b> Item].
Or move the mouse over the line's [legend > Graph Legend] entry\
and click on the middle mouse button.
}
 
{How to Zoom} {
Zooming allows you see details in a particular area of a chart.\
It also removes some visual loss that occurs when lots of samples\
are displayed on a finite sized chart. Multiple zoom levels are supported\
for each chart. Note that when a chart is zoomed data points that lie\
outside the zoom window will not be visible. Also the stats displayed for\
the selected line will exclude data points to the left or right of the zoom window.

A zoom in can be done in a number of ways.
<b>Time Zooms:</b> The easiest is to middle click the mouse in the area you want to\
see better. This only zooms the time (x) axis so it lets you easily focus\
on a point in time without any loss of value (y) axis in that time period.
<b>Box Zooms:</b> You can also zoom in using the [Chart Menu <b>Zoom In</b> Item].\
First start a zoom using the menu item.\
Then set the first point of the zoom by clicking on it with the left button.\
Now move the mouse to the other point and click again.\
A zoom can be cancelled by clicking the right mouse button.\
This zooms both the x and y axis so some data in the time period might\
not be visible on the graph.

To zoom out one level click the right mouse button over the graph or use
the [Chart Menu <b>Zoom Out</b> Item].
}
 
{How to Change a Line} {
First select the line. Then you can change its:
   * <b>statistic</b> using the [Chart Window Statistic ComboBox].
   * <b>filter</b> using the [Chart Window Filter MenuButton].
   * <b>data set</b> using [File Trimming].
   * <b>adder</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Normalizing a Line] and [Offsetting a Line] for more information.
   * <b>muliplier</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Value Scaling a Line] for more information.
   * <b>scale</b> using the [Chart Window Operator MenuButton] and the [Chart Window Number Entry]. See [Display Scaling a Line] for more information.
   * <b>display symbol</b> using the [Line Menu <b>Symbol</b> SubMenu].
   * <b>display axis</b> using the [Line Menu <b>Graph on Left Axis</b> Item].
}
 
{How to Compare Data} {
   * To see the difference between two points on the same line use the [Line Menu <b>Log Delta</b> Item].
   * To see the difference between all the points on two lines use the [Line Menu <b>Diff Lines</b> Item].
}

{How to Customize a Chart} {
Many menu items exist in the [Chart Window Chart Menu] that allow the chart display\
to be customized. Feel free to play with these; they will only change\
the current chart.
}

{Help Links} {
Help links are show in blue and underlined.\
If you click on a link then the link will be followed\
to the new help topic which will be displayed in the current window.\
If you <tt>control</tt> click or right click on a link then the new help\
topic will be shown in a new help window.
}

{Help Window Features} {
Any number of help windows can exist.

!How to Use A Help Window
   * [General Interface Features]
   * [Help Links]

!Key operations
   * <tt>control-b</tt> goes back to the previous help view.
   * <tt>control-f</tt> goes forward after a back.
   * <tt>control-s</tt> pops up a [search window > Help Search Control].

!Help Controls
   * <b>Back</b> goes back to the previous help topic
   * <b>Forward</b> returns to a help topic left by going back.
   * <b>Search...</b> pops up a [search window > Help Search Control].
   * <b>Dismiss</b> closes the help window.
}

{Help Search Control} {
This control allows the text of help topics to be searched. Type in the text you are interested in finding. You will hear a beep if the text cannot be found in the current help topic. By default the search is done on the help topic in the current window. You can search all topics by clicking on the <b>All Topics</b> button.
Searches are case-insensitive.

!Key operations
   * [standard editing > String Entry Editing]
   * <tt>control-s</tt>, <tt>tab</tt>, or the <b>Next</b> button to find the next match in the current help topic.
   * <tt>control-r</tt> or the <b>Prev</b> button to find the previous match in the current help topic.
   * the <b>All Topics</b> button causes a search to be done on all help topics. The help window's contents will change to a results topic which is a list of links to all the topics that contain the text.
   * <tt>return</tt> or click somewhere else to terminate the search
}

{Font Window} {
This dialog window allows you to set a font. This is system dialog and will vary somewhat between platforms.
It is a modal dialog so it needs to be closed before the rest of VSD is responsive.

This windows is opened by the four menu items in the [Main Window Choose Fonts... Menu Item > Choose Fonts... Menu Item]. Fonts are set separately for the Main Window, Chart Window, Help System and the Chart Window's log window.
   
You may select the following font attributes:
   * Font name 
   * Font style (bold, etc.)
   * Size
   
The Sample field shows you immediately what the font looks like.  To see it applied to the actual window, use the <b>Apply</b> button. Since the Font Window is a dialog, you may need to open the relevant window (chart window or help text), before starting the process of selecting the font.
   
!Buttons
   * <b>Ok</b> causes any font picked to be used and the dialog to be closed.
   * <b>Cancel</b> closes the dialog without applying changes. 
   * <b>Apply</b> causes the font picked to be used, but leaves the Font Window open. This allows you to see what it looks like in an actual window and make further changes.  Note that the <b>Cancel</b> button does not back out changes once they have been applied. 
   
For more information on fonts, see the [Choose Fonts... menu item > Choose Fonts... Menu Item].
}

{Log Window} {
VSD uses a singleton log window as a destination for writing text details from Chart Windows.  All Charts share the same log window. If you close the log window, any information written to it is deleted. You can copy information from the Log Window to a text editor for later reference.

The operations that write to the log window are:
   * [Log... button > File Info Log... Button]
   * [Log Info menu item > Line Menu Log Info Item]
   * [Log Delta menu item > Line Menu Log Delta Item]
  
To capture graphics to a file, see [Chart Snapshot Menu Item]  
  
}
{File Information Window} {
This window is opened when the [file info... item > File Menu Info... Item] is selected. It shows the information on the current file:
   * the product version of the [statmonitor] that generated the file
   * a description of the machine and operating system that [statmonitor] ran on when generating the file
   * the time that the first data sample in the file was taken and an estimate of the interval.
   * the file format (plain text, gzip-compressed, lz4-compressed, or GFS Binary (GBS) )
   * the statmonitor command line argument used (for GemStone/S 64 Bit v3.6 and later)
   
The [Log...button > File Info Log... Button] opens a text window with the absolute file name of the file as well as some of the file information.
To close the window, use the <b>Dismiss</b> button.
}

{File Info Log... Button} {
Clicking on this button causes the following information to be [logged > Log Window]:
   * the absolute file name
   * the product version of the [statmonitor] that generated the file
   * a description of the machine and operating system that [statmonitor] ran on when generating the file
   * the time that the first data sample in the file was taken and the interval.

This button is on the [File Information Window].
}

{Monitor Window} {
Provided that the $GEMSTONE environment variable is set in the environment in which VSD was started, you can monitor caches on the local machine. VSD may open a single monitor window. This allows you to run a [statmonitor], whose output will be automatically loaded into vsd, with auto-update.  The monitor window is opened or brought to the front by selecting the [Monitor... > Main Menu Monitor... Item] item.

The main display in this window shows a list of caches that can be monitored. This list includes caches of any other versions that are running on this host.  You can monitor caches running any version of GemStone; $GEMSTONE is only used to locate the caches, VSD uses information in the process to start the correct statmonitor. 

Each line of this list displays the following:
   * <b>Cache Name</b>:  the name of an existing cache on the local machine.
   * <b>StatMon</b>:  if VSD is monitoring this cache, the PID of the statmonitor process is show, otherwise <tt><none></tt>. You can only monitor a cache once from a given VSD process, although you may run statmonitor from the command line or monitor from more than one VSD. 
   * <b>Version</b>:  the GemStone version of that cache.
   * <b>Creator</b>:  the name of the user that started the Stone and cache.

![Controls > Statmonitor Option Controls]

!Buttons
   * <b>Refresh</b>:  updates the list of caches.
   * <b>Start</b>:  starts a [statmonitor] on the selected statistic source. This button is disabled until a valid statistic source is selected. The start will use the values of the [statmonitor options > Statmonitor Option Controls].
   * <b>Status</b>:  shows the status of a running [statmonitor]. This button is disabled until a statistic source with a running statmonitor is selected.
   * <b>Stop</b>:  stops a running [statmonitor]. This button is disabled until a statistic source with a running statmonitor is selected.
   * <b>Dismiss</b>:  closes the monitor window.
}

{Statmonitor Option Controls} {
The following controls provide a way to specify statmonitor arguments. Set the options you need, then click on the <b>Start</b> button.

   * <b>StatMon Output:</b> shows the name of the running statmonitor's output file. If left blank when starting then vsd will generate a unique name. 
   * <b>Sample Interval:</b> specifies the sampling interval in seconds.  To sample in milliseconds, use <tt>-I ms</tt> in  the StatMon Arguments control.
   * <b>Write Interval:</b> tells statmonitor how long to buffer samples internally before flushing them to the output file. Setting this to zero causes the <b>Sample Interval</b> to be used.
   * <b>Compression:</b>  if gzip or lz4 is checked, causes the output file to be compressed, which saves a significant amount of disk space.
   * <b>Statmon Argument:</b>  this allows you to pass in statmonitor arguments that are valid for your version and for monitoring.
   
These controls are on the [Monitor Window].
   
}

{Statistic Information Window} {
Vsd can have only one Statistics Information window open. Its purpose is to display information on a selected statistic. It can also be used to customize the default filter and the level of any statistic. It is opened by checking the [Show Statistic Info > Main Menu Show Statistic Info Item] checkbox.

!Controls
   * [statistic name selector > Statistic Window Name ComboBox]
   * [Default Filter MenuButton]

!Displays
   * <b>Kind:</b> shows what kind of statistic it is. It will be one of the following:
      * <b>counter</b>: a statistic whose value always increases
      * <b>counter64</b>: a statistic whose value is a signed 64 bit integer and always increases
      * <b>svalue</b>: a statistic whose value is a signed 32 bit integer.
      * <b>svalue64</b>: a statistic whose value is a signed 64 bit integer.
      * <b>uvalue</b>: a statistic whose value is an unsigned 32 bit integer.
      * <b>float</b>: a statistic whose value is a floating point number
   * <b>Types:</b> shows which [process types > Process List Item Type Definition] are known to support this statistic. If none are known then <tt>unknown</tt> is shown. Until a file is loaded vsd has no idea of which types support a statistic.
   * <b>Statistic Description</b> show a textual description of the statistic.
   * <b>Units:</b> shows the units that the statistic's value represents. Some of the more common unit strings are:
      * <b>seconds</b>
      * <b>milliseconds</b>
      * <b>items</b>
      * <b>bytes</b>
      * <b>kilobytes</b>
      * <b>megabytes</b>
      * <b>pages</b>
      * <b>locks</b>
      * <b>frames</b>
      * <b>commit records</b>
      * <b>log records</b>
      * <b>objects</b>
      * <b>messages</b>
      * <b>threads</b>
      * <b>processes</b>
      * <b>events</b>
      * <b>%</b>:  the value is a percentage
      * <b>false</b> or <b>true</b>:  the value is 0 (false) or 1 (true). 
       * <b>id</b>:  the value is just a numeric identifier.
      * <b>bits/sec</b>:  bits per second.
      * <b>ios/sec</b>:  input/output operations per second.
      * <b>operations</b>
      * <b>aborts</b>
      * <b>commits</b>
      * <b>reclaims</b>
      * <b>checkpoints</b>
      * <b>scavenges</b>
}


{Default Filter MenuButton} {
Shows and sets the default filter of the current statistic. The default filter is the one that will be used when a line is created for this statistic. It can be any of the following:
   * <b>Default</b>
   * <b>None</b>
   * <b>PerSecond</b>
   * <b>PerSample</b>
   * <b>Aggregate</b>
   
After this is modified, the change will be written to the [.vsdrc file > VSD Files] when VSD exits, so it will be available in future VSD executions.
   
See [How to Filter Statistics] for a description of the various filters.

This button is on the [statistic information window > Statistic Information Window].
}
{Statistic Window Name ComboBox} {
This control displays the current statistic. It also will let you change it.

!Key operations
   * Clicking on a name with the <em>mouse</em> both selects it and causes it to become the current statistic.
   * The <em>down</em> arrow key selects the next statistic.
   * The <em>up</em> arrow key selects the previous statistic.
   * The <em>letter keys</em> select the next statistic whose first letter matches the key.
   * <tt>control-s</tt> starts a [search > List Search Control] which results in selecting a statistic.
   * <em>Return</em> causes the selected statistic to become the current statistic.
   * <em>Esc</em> cancels the change leaving the current statistic unchanged.

This control is on the [statistic information window > Statistic Information Window].
}
{Main Window Features} {
VSD has a single <b>Main Window</b> and it always exists. If this window is closed or killed, then vsd will terminate.

The Main Window allows you to [load > How to Load a Data File] statmonitor or GBS data files, or start and stop [monitoring > How to Update the View of a Data File] a running system.  

Once data is loaded, a list of processes from that file is displayed, and a list of statistics. 

You can [select a process or processes > How to Select Process List Entities], and a [statistic or statistics > How to Select Statistics], and [open a Chart Window > How to Create a New Chart] to display a graphical representation of the statistic values for those processes. 

!How to Use The Main Window
   * [General Interface Features]
   * [How to Create a Data File]
   * [How to Compare Files]
   * [How to Merge Files]
   * [How to Select Processes and Statistics for Analysis]
   * [Controlling the Enabled Files]
   * [Controlling the Process List Entries]
   * [Controlling the Listed Statistic Names]
   * [How to Understand a Statistic]
   * [How to Add a Line to an Existing Chart]

!Main Menus
   * [Main menu > Main Window Main Menu]
   * [File menu > Main Window File Menu]
   * [Chart menu > Main Window Chart Menu]
   * [Template menu > Main Window Template Menu]
   * [Help menu > Main Window Help Menu]

!Main Controls
   * [File: > Main Window File ComboBox]
   * [Process List Table > Main Window Process List Table]
   * [Statistic List > Main Window Statistic List]
   * [Chart: > Main Window Chart: Entry Field ComboBox]
   * [Add Line Button > Main Window Add Line Button]
   * [New Chart Button > Main Window New Chart Button]
   * [Status Display area > Main Window Status Display]
}

{Main Window Main Menu} {
The Main Menu is on the [Main Window > Main Window Features].

It has the following menu items:

!Items
   * [Load Data File... > Main Menu Load Data File... Item]
   * [Append Data File... > Main Menu Append Data File... Item]
   * [Monitor... > Main Menu Monitor... Item]
   * [Change Directory... > Main Menu Change Directory... Item]
   * [Change Time Offset... > Main Menu Change Time Offset... Item]
   * [Set Master Background Color... > Background Color]
   * [Copy Selection > Main Menu Copy Selection Item]
   * [Show Statistic Info > Main Menu Show Statistic Info Item]
   * [Select Instances By... > Select Instances By Menu Item]  (also on Process List Pane popup menu)
   * [Hide Instances By Type... > Hide Instances By Type Menu Item] (also on Process List Pane popup menu)
   * [Combine > Combine Menu Item]  (also on Process List Pane popup menu)
   * [No Flatlines > No Flatlines Menu Item]  (also on Process List Pane popup menu)
   * [Single File Mode > Single File Mode Menu Item]  (also on Process List Pane popup menu)
   * [Absolute TimeStamps > Absolute TimeStamps Menu Item] (also on Process List Pane popup menu)
   * [Copy Referenced Lines > Main Menu Copy Referenced Lines Item]
   * [Settings > Main Menu Settings SubMenu]
   * [Save Settings > Main Menu Save Settings Item]
   * [Dump Statistic Info > Main Menu Dump Statistic Info Item] ([Wizard Mode] only)
   * [Trace API Calls > Main Menu Trace API Calls Item] ([Wizard Mode] only)
   * [ForceError > Main Menu ForceError Item] ([Wizard Mode] only)
   * [Exit > Main Menu Exit Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-m</tt>

}

{Select Instances By Menu Item}  {
The <b>Select Instances By...</b> menu item allows to you find and limit the display to certain process instances. 

The options are: 
   * <b>All</b> selects all processes.
   * <b>Clear</b> unselects all selected processes
   * <b>Name...</b> opens a dialog to let you enter a string, and selects all process with names that match. Supports wild cards * and ?, and case-sensitive or insensitive.
   * <b>Process ID...</b> opens a dialog to let you enter a process id, and selects all process with that process Id.
   * <b>Session ID...</b> opens a dialog to let you enter a session id, and selects all process with that session Id.
   * <b>Statistic</b> selects all processes that define the currently selected statistic or statistics.
   * <b>Type</b> selects all processes that are the same type as the currently selected process or processes.

This item is part of the [main menu > Main Window Main Menu] and the [Process List Pane Popup menu > Process List Pane PopupMenu].

}

{Hide Instances By Type Menu Item} {
The <b>Hide Instances By Type...</b> menu item allows you to control the visiblity of processes in the process list pane. 

This menu item allows you to hide specific process types in the Process list. 
The options are:
   * AppStat
   * Gem
   * Host System
   * Netldi
   * Page Server
   * StatMon
   * ShrPcMonitor
   * Stone
 
This item is part of the [main menu > Main Window Main Menu] and the [Process List Pane Popup menu > Process List Pane PopupMenu].
}

{Main Menu Load Data File... Item} {
Pops up file selection dialog which can be used to pick the data file to load.
See [How to Load a Data File] for more information.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-l</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Append Data File... Item} {
Pops up file selection dialog which can be used to pick one or more data files to append to the currently loaded file. This allows you to easily concatenate multiple physical files. Data will no longer be read from the current file location. Instead it will only be read from the new appended location. You should only append files that are newer than the current data.
This operation will fail if the current file load has been interrupted. You need to do an [update > File Menu Update Item] to finish the load before an append can be done.
See [How to Load a Data File] for more information.

This item is part of the [main menu > Main Window File Menu].
}

{Main Menu Monitor... Item} {
Pops up the [Monitor Window].
See [How to Create a Data File] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-m</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Change Directory... Item} {
Pops up a dialog that asks for the directory VSD should use as its working directory. Initially this is the directory VSD was started from but it can be changed using this item.
The operations that use the VSD working directory are:
   * [Chart Menu Print Item]
   * [Chart Snapshot Menu Item]

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Change Time Offset... Item} {
Pops up a spinbox that allows the time offset to be altered.  The time offset represents a value (in hours) that is added to all timestamps in all stat files loaded by VSD.  The default value is zero and the valid range runs from -23 to +23 hours.  Time Offset settings are not saved and the value will be reset to zero each time VSD is started.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Copy Selection Item} {
Copies the currently selected [process list entities > How to Select Process List Entities] and [statistics > How to Select Statistics] to the clipboard.
See [How to Cut, Copy, and Paste] for more information.

[Accelerator Key > Keyboard Accelerators]: <tt>control-c</tt>

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Show Statistic Info Item} {
The Main Window [main menu > Main Window Main Menu] <b>Show Statistic Info</b>  menu item controls whether the [statistic information window > Statistic Information Window] is displayed.

See [How to Understand a Statistic] for more information on the Statistics Information Window.

}

{Combine Menu Item} {
Controls what is done with [multiple processes > List Multiple Selection] are [selected > How to Select Process List Entities] in the process list pane, and a new chart or line is [created > How to Add a Line to an Existing Chart].

If this item is checked then all the data for the selected processes\
will be added together into a single line. Otherwise a line is created for each process list item selected.

This item is part of the [main menu > Main Window Main Menu] and the [Process List Popup menu > Process List Pane PopupMenu].
}

{No Flatlines Menu Item} {
If checked then:
   * the names of statistics with all zero raw values for the selected process will not be displayed.
   * lines will not be created if all their filtered values are zero. A [bell message > Bell Messages] will be displayed if this causes no lines to be created. Note that this option is ignored when creating a line using [line arithmetic > Line Arithmetic].

If unchecked then:
   * the names of statistics with all zero raw values for the selected process list item will be displayed in a faint font.

See [Controlling the Listed Statistic Names] for more information.

This item is part of the [main menu > Main Window Main Menu] and the [Process list Pane popup menu > Process List Pane PopupMenu].
}

{Single File Mode Menu Item} {
VSD supports loading multiple files. These files can be analyzed separately, or all data can be viewed together.  If you want to load more than one file that are independent of each other, you can check the Single File Mode menu item. 

See the following for more help:
   * [How to Compare Files]
   * [How to Merge Files]

If checked then:
   * only one loaded file, the current file, is viewed at a time.

If unchecked then:
   * all loaded files that are [enabled > Controlling the Enabled Files] are viewed, with all process instances in these files displayed in the process list pane.

See the following for more information:
   * [Controlling the Enabled Files]
   * [Controlling the Process List Entries]
   * [Main Window File ComboBox]

This item is part of the [main menu > Main Window Main Menu] and the [Process List Pane Popup menu > Process List Pane PopupMenu].
}

{Absolute TimeStamps Menu Item} {
If checked then:
   * Created lines will use absolute timestamps which can be useful when [merging > How to Merge Files] files.

If unchecked then:
   * Created lines will use relative timestamps which can be useful when [comparing > How to Compare Files] files.

Once a line is created its timestamps cannot be changed. If you want to change them just set this item and recreate the line.

Absolute and relative timestamps have different display formats. For more on this see [Chart Menu Time Format SubMenu].

This item is part of the [main menu > Main Window Main Menu] and the [Process List Pane Popup menu > Process List Pane PopupMenu].
}

{Main Menu Copy Referenced Lines Item} {
If checked then:
   * copies of the source lines are made when [line arithmetic > Line Arithmetic] is done. This prevents subsequent changes to the sources lines effecting the result line.

If unchecked then:
   * references of the source lines are used when [line arithmetic > Line Arithmetic] is done. This allows subsequent changes to the sources lines to also change the result line.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Save Settings Item} {
Selecting this menu item saves the current settings to [.vsdrc file > VSD Files].  
This is useful when you do not have [automatic save > Settings SubMenu Save Settings On Exit Menu Item] enabled.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Settings SubMenu} {
The Settings submenu from the [main menu Main menu > Main Window Main Menu] allows you to configure vsd. 

!Items:
   * [Change Inactive File Timeout Menu Item]
   * [Choose Fonts... Menu Item]
   * [Settings SubMenu Confirm Exit Menu Item]
   * [Settings SubMenu Save Settings On Exit Menu Item]
   * [Settings SubMenu Show Commas in Numbers Menu Item]
}

{Change Inactive File Timeout Menu Item} {
The Main Window [Settings submenu > Main Menu Settings SubMenu] <br>Change Inactive File Timeout</b> menu item allows you to set the inactive file timeout. 

When live monitoring, the font of processes that are being updated is in green font. To allow you to see when a file has rolled over or is otherwise no longer being updated, after a period of time as passed the font become black. The timeout can be configured using this menu item.  

The inactive timeout must be longer than the write interval to be useful.
}

{Choose Fonts... Menu Item}  {
The menu item <b> Choose Fonts...</b> on the [Main Menu Settings submenu > Main Menu Settings SubMenu] allows you to configure the fonts on your system.

!Items 
There are four fonts that can be customized, with the following menu items:
   * <b>Main Window</b> opens a [Font Window] that allows you to set the font for the Main Window.
   * <b>Charts</b> opens a [Font Window] that allows you to set the font for Chart Windows.
   * <b>Chart Data Logs</b> opens a [Font Window] that allows you to set the font for the log windows used for Chart Line info and diff operations.
   * <b>Help Text</b> opens a [Font Window] that allows you to set the font for the Help System.
 
Font changes are written to the [.vsdrc file > VSD Files] when VSD exits so they can be used in subsequent VSD executions. 
}

{Settings SubMenu Save Settings On Exit Menu Item} {
The Main Window [Settings submenu > Main Menu Settings SubMenu] menu item <b>Save Settings On Exit</b> determines if changes are written to the [.vsdrc file > VSD Files] when VSD exits. 

If unchecked, settings are not written to  the [.vsdrc file > VSD Files] on exit
}

{Settings SubMenu Show Commas in Numbers Menu Item} {
The Main Window [Settings submenu > Main Menu Settings SubMenu] menu item <b>Show Commas in Numbers</b> allows you to configure comma handling in numbers.

Numbers with many digits may be difficult to read; the menu item allows you to enable display of commas within these numbers.  

For example, 1000000 can be displayed as 1,000,000.
}

{Main Menu Dump Statistic Info Item} {
Causes information on all known statistics to be dumped to a log window.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Settings SubMenu Confirm Exit Menu Item} {
If checked then:
   * vsd will ask for confirmation before it completes an [exit > Main Menu Exit Item] operation.

If unchecked then:
   * vsd will perform an [exit > Main Menu Exit Item] operation without asking the user for confirmation.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Exit Item} {
Causes vsd to terminate. Before terminating vsd will:
   * confirm with the user that the exit was intended if the [Settings SubMenu Confirm Exit Menu Item] is checked.
   * kill off any monitors left running. See [Monitor Window] for more information.
   * writes the <u><tt>~/.vsdrc</tt></u> file. See [VSD Files] for more information.

If the window manager closes the main window then these same actions are taken. If you want to exit vsd without performing any of these actions then kill the vsd process.

This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu Trace API Calls Item} {
If checked then:
   * any call by vsd to its lower level C APIs will result in a trace message written to its stderr. This is intended to help debug crashes that are hard to reproduce.

If unchecked then:
   * API calls are not traced.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Main Menu ForceError Item} {
Picking this item forces an error. This allows vsd developers to make sure the error catching logic is functioning correctly.

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [main menu > Main Window Main Menu].
}

{Wizard Mode} {
Wizard mode enables certain advanced vsd features. This mode is intended for use by VSD developers while working on VSD itself. 

Wizard mode can be enabled either of the following:
   * Setting the <b>VSD_WIZARD</b> enviroment variable in the environment that starts vsd.
   * Setting the Tcl variable <b>vsd(wizard)</b> in <u><tt>~/.vsdconfig</tt></u>. See [VSD Files] for more information.
}

{Main Window File Menu} {
All of the items on this menu operate on the [<em>current file</em> > Main Window File ComboBox].
If no [<em>current file</em> > Main Window File ComboBox] exists then all the items will be disabled.

!Items
   * [Info... > File Menu Info... Item]
   * [Update > File Menu Update Item]
   * [Update All > File Menu Update All Item]
   * [Auto Update > File Menu Auto Update Item]
   * [Enabled > File Menu Enabled Item]
   * [Untrim Left > File Menu Untrim Left Item]
   * [Untrim Right > File Menu Untrim Right Item]
   * [Set Rolling Time Window > File Menu Set Rolling Time Window]
   * [Dump > File Menu Dump Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-f</tt>

This menu is on the [Main Window > Main Window Features].
}

{File Menu Info... Item} {
Causes the [File Information Window] to be loaded with information on the [<em>current file</em> > Main Window File ComboBox].

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Update All Item} {
Causes any data not already read from any [enabled > Controlling the Enabled Files] file to be read now. This can be used on files that [statmonitor] is still writing data to or on files whose load was interrupted.

[Accelerator Key > Keyboard Accelerators]: <tt>control-U</tt>

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Update Item} {
Causes any data not already read from the [<em>current file</em> > Main Window File ComboBox] to be read now. This can be used on files that [statmonitor] is still writing data to or on files whose load was interrupted.

[Accelerator Key > Keyboard Accelerators]: <tt>control-u</tt>

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Auto Update Item} {
If checked causes an automatic update to be done on the [<em>current file</em> > Main Window File ComboBox] whenever it should have changed. The interval of the first couple of timestamps in a file are used to estimate when a file should have changed.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Enabled Item} {
This item is only useful or applicable in [multi-file mode > Single File Mode Menu Item]. It applies to the [<em>current file</em> > Main Window File ComboBox] (displayed in the <tt>File:</tt> field), and is checked (enabled) by default. 

Unchecking <tt>Enabled</tt> on this menu causes the selected file to be omitted from display in the process list. 

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Untrim Left Item} {
This item is only enabled if the [<em>current file</em> > Main Window File ComboBox] was trimmed left. Selecting it undoes all left trims to the file.
See [File Trimming] for more information.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Untrim Right Item} {
This item is only enabled if the [<em>current file</em> > Main Window File ComboBox] was trimmed right. Selecting it undoes all right trims to the file.
See [File Trimming] for more information.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Set Rolling Time Window} {
Selecting this item opens a dialog box to enable or modify rolling time trimming for the current file.  When enabled, rolling time trimming tells VSD to disregard all data in the file except for the most recent data.  For example, setting the rolling time window to 5 minutes will cause VSD to disregard all samples older than 5 minutes. Because the time window is <em>rolling</em>, VSD adjusts the time window whenever new data is loaded so that only the most recent 5 minutes of data is shown. 

Other file trimming options are disabled when rolling time trimming is active.
To cancel rolling time trimming, set the time window to zero by clicking the Zero button and then clicking the Apply button.

This item is part of the [file menu > Main Window File Menu].
}

{File Menu Dump Item} {
Causes vsd to write to its stdout details in the internal data structures its using to contain the data read from the [<em>current file</em> > Main Window File ComboBox].

This item will only appear if vsd is run in [Wizard Mode].
This item is part of the [file menu > Main Window File Menu].
}

{Main Window Chart Menu} {
!Items
   * [Add To Chart > Main Chart Menu Add To Chart Item]
   * [New Chart... > Main Chart Menu New Chart... Item]
   * [Show Legend > Main Chart Menu Show Legend Item]
   * [Time Format > Main Chart Menu Time Format SubMenu]
   * [Default Line Style > Main Chart Menu Default Line Style SubMenu]
   * [Show Time Axis Title > Main Chart Menu Show Time Axis Title Item]
   * [Show Left Axis Title > Main Chart Menu Show Left Axis Title Item]
   * [Show Right Axis Title > Main Chart Menu Show Right Axis Title Item]
   * [Show Current Values > Main Chart Menu Show Current Values Item]
   * [Show Min and Max > Main Chart Menu Show Min and Max Item]
   * [Show Line Stats > Main Chart Menu Show Line Stats Item]
   * [Show CrossHairs > Main Chart Menu Show CrossHairs Item]
   * [Show Grid Lines > Main Chart Menu Show Grid Lines Item]
   * [Selected Line Color... > Main Chart Menu Selected Line Color... Item]
   * [Close All Charts > Main Chart Menu Close All Charts Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This menu is on the [Main Window > Main Window Features].
}

{Main Chart Menu Add To Chart Item} {
Does the same thing as the [Add Line > Main Window Add Line Button] button.
This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu New Chart... Item} {
Does the same thing as the [New Chart > Main Window New Chart Button] button.
This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Legend Item} {
This item determines if a new [chart window > Chart Window Features] will have  a [legend > Graph Legend] control.

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Legend</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Time Format SubMenu} {
This submenu determines the default time format for a new chart.

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Time Format</b> SubMenu] to change this item for a particular chart.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Default Line Style SubMenu} {
This submenu determines the default line style used when creating lines.

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

See [line styles > Line Menu Style SubMenu] to learn more.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Time Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string under the graph's [X Axis].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Time Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Left Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string next to the graph's [Left Y Axis].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Left Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Right Axis Title Item} {
This item determines if a new [chart window > Chart Window Features] will display a title string next to the graph's [Right Y Axis].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Right Axis Title</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Current Values Item} {
This item determines if a new [chart window > Chart Window Features] will have  [X: > Chart Window X: Display] and [Y: > Chart Window Y: Display] controls.

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Current Values</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Min and Max Item} {
This item determines if a new [chart window > Chart Window Features] will have  [Min: > Chart Window Min: Display] and [Max: > Chart Window Max: Display] controls.

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Min and Max</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Line Stats Item} {
This item determines if a new [chart window > Chart Window Features] will display [line statistics > Data Statistics] in the upper left corner of its [graph > Graph Display].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Line Stats</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show CrossHairs Item} {
This item determines if a new [chart window > Chart Window Features] will draw cross hair lines on its [graph > Graph Display].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show CrossHairs</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Show Grid Lines Item} {
This item determines if a new [chart window > Chart Window Features] will draw dotted grid lines on its [graph > Graph Display].

The value it is set to will be remembered by vsd in its [memory file > VSD Files].

Use [Chart Menu <b>Show Grid Lines</b> Item] to change this item for a particular chart.

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Selected Line Color... Item} {
Selecting this item will cause a color chooser dialog window to popup.\
Use it to pick the color to use for the selected line.\
You will not be able to do anything else until you finish or cancel the color choice.\
Your choice will be recorded in the [memory file > VSD Files].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Chart Menu Close All Charts Item} {
Selecting this item causes all the existing chart windows to no longer exist.

To close just a single chart window use the [Chart Menu <b>Close</b> Item].

This item is part of the [main chart menu > Main Window Chart Menu].
}

{Main Window Template Menu} {
!Items
   * [Reload Template File > Template Menu Reload Template File Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Templates Use Selection > Template Menu Templates Use Selection Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-t</tt>

This menu is on the [Main Window > Main Window Features].
}

{Template Menu Reload Template File Item} {
Causes the [template file > VSD Files] to be reloaded. Use this if you have edited the template file and want the changes to be used immediately.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-r</tt>

This item is part of the [main template menu > Main Window Template Menu].
}

{Template Menu New Template Chart SubMenu} {
Each item on this submenu represents a template from the [template file > VSD Files]. Selecting an item from this submenu causes a [new chart > Chart Window Features] to be created. The [contents > Template Syntax] of the template [determines what lines > Template Expansion] will be added to the created chart.

Vsd has a set of [predefined templates > Predefined Templates]. Each one of these will show up as an item on this submenu. Also any [user defined templates > Chart Menu Save Template Item] will show up.

[Selection Key > Keyboard Selection Keys]: <tt>Alt-c</tt>

This item is part of the [main template menu > Main Window Template Menu].
}

{Predefined Templates} {
The following are template definitions that come with VSD. 

They are stored in the [template file > VSD Files] and can be used from the [New Template Chart > Template Menu New Template Chart SubMenu] menu or the [Add From Template > Chart Menu Add From Template SubMenu].

   * [CPU > CPU Template]
   * [CacheMix > CacheMix Template]
   * [CacheTooSmall > CacheTooSmall Template]
   * [CommitInfo > CommitInfo Template]
   * [EpochSweeps > EpochSweeps Template]
   * [Garbage > Garbage Template]
   * [PageServer > PageServer Template]
   * [SpaceFree > SpaceFree Template]

<b>NOTE:</b> If you get an updated VSD release the definitions of these templates may have changed and new definitions may exist. Your old [template file > VSD Files] will still contain the definitions from an older VSD release. The only way to get the new definitions is to delete or rename your template file. This will cause VSD to write a new default template file. You can then edit it and copy any of your own template definitions to it.
}

{Template Menu Templates Use Selection Item} {
If a template as a * pattern match, then when <em>Templates Use Selection</em> is selected, only the selected process or processes will match the * in the template entry.  Other template entries will display as usual.  
When unselected, then [selected proceses > Main Window Process List Table] are ignored when creating a chart based on a template.

This item is part of the [main template menu > Main Window Template Menu].
}

{Main Window Help Menu} {
The [Main Window > Main Window Features] <b>Help</b> menu provides access to VSD's help system.

!Items
   * [How to... > Help Menu How to... Item]
   * [Main Window... > Help Menu Main Window... Item]
   * [Chart Window... > Help Menu Chart Window... Item]
   * [All Topics... > Help Menu All Topics... Item]
   * [All Help Text... > Help Menu All Help Text... Item]
   * [About VSD... > Help Menu About VSD... Item]

[Selection Key > Keyboard Selection Keys]: <tt>Alt-h</tt>

}

{Help Menu How to... Item} {
Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>How to...</b>, opens a new [help window > Help Window Features] containing links to all topics with "How To" names, in alphabetic order. 
}

{Help Menu Main Window... Item} {
The [Main Window > Main Window Features] is the main window for VSD, providing access to loading and analyzing data files. 

Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>Main Window...</b>, opens a new [help window > Help Window Features] containing help for the Main window.
}

{Help Menu Chart Window... Item} {
The [Chart Window > Chart Window Features] is, after the [Main Window > Main Window Features], the most important interface in VSD. The Chart Window provides interactive graphical display of the specific data elements identified from a Main Window.

Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>Chart Window...</b>, opens a new [help window > Help Window Features] containing help for the Chart window.
}

{Help Menu All Topics... Item} {
Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>All Topics...</b>, opens a new [help window > Help Window Features] containing links to all topics within the help system. 

The links are sorted alphabetically.
}

{Help Menu All Help Text... Item} {
Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>All Help Text...</b>, opens a new [help window > Help Window Features] containing all content for all topics in the help system. 

The contents are sorted by topic name. Note that on some systems. creation of this help window can take a long time.
}

{Help Menu About VSD... Item} {
Selecting the [Main Window's Help Menu > Main Window Help Menu] menu item <b>About VSD...</b>, opens a new [help window > Help Window Features] containing information about VSD and about this release of VSD. 

This information includes:
   * version and build numbers
   * the disk locations for VSD files
   * link to the VSD home page on the GemTalk website
}

{Main Window Add Line Button} {
Creates one or more lines from the selected [process list entry > How to Select Process List Entities] and [statistics > How to Select Statistics],\
and adds them to the current chart window. If a chart window does not exist, then a new chart is created.

The current chart's name is displayed in the [Chart: entry field > Main Window Chart: Entry Field ComboBox]; you can select a different chart,\
if you wish to add the line to a different Chart.  

If a new chart will be created, you can enter a name for the new chart in the [Chart: entry field > Main Window Chart: Entry Field ComboBox] before clicking the Add Line button.

For details on how the selection is used to create lines see [Line Creation].

This operation can also be done by double clicking when selecting a [process > How to Select Process List Entities] or [statistic > How to Select Statistics].

[Accelerator Key > Keyboard Accelerators]: <tt>control-a</tt>

This control is on the [Main Window > Main Window Features].
}

{Line Creation} {
For a line to be created at least one [process > How to Select Process List Entities] and one [statistic > How to Select Statistics] must be selected.

If more than one process is selected, then vsd can either combine them or create separate lines; see [combine > Combine Menu Item] for a description of how this is done.

If [no flatlines > No Flatlines Menu Item] is true, and you are not using [line arithmetic > Line Arithmetic], then the line will not be created if all its values are zero. 

The default filter for the statistic on the line is used when creating the line.

A unique color and dash style for the line is selected, based on what lines are already in the chart.

!Operations That Create Lines
   * [New Chart > Main Window New Chart Button]
   * [Add Line > Main Window Add Line Button]
   * [copy & paste > How to Cut, Copy, and Paste]
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Add From Template > Chart Menu Add From Template SubMenu]
}
{Main Window New Chart Button} {
Does the same thing as the [Add Line > Main Window Add Line Button] button with the following exceptions:
   * It will never use an existing chart.
   * An empty chart window is created if no lines are created. So this is the operation to use to get an empty chart that you plan to [paste > How to Cut, Copy, and Paste] a line to.

[Accelerator Key > Keyboard Accelerators]: <tt>control-n</tt>
This control is on the [Main Window > Main Window Features].
}

{Main Window File ComboBox} {
The file control has the following functions:
   * display name of current file
   * display names of all loaded files
   * change the current file
   * load a new file

!Drop Down List
The file control's drop down list contains:
   * The first element is always <tt>Browse For File...</tt> which if selected will do the same thing as the [Main Menu <b>Load Data File...</b> Item].
   * Currently loaded files, which are displayed in the same [syntax > Loaded File Description Syntax] as that used for the <em>current file</em>. 
   Selecting one causes it to become the <em>current file</em>.

!Current File
The <em>current file</em> is a loaded file whose [description > Loaded File Description Syntax] is displayed in the file control's string entry field. It is the one that is operated on by the [Main Window <b>File</b> Menu]. If [single file mode > Single File Mode Menu Item] is on, then only the processes and other entities in the current file are displayed in the process list.

!Loading a New File
See [How to Load a Data File].

This control is on the [Main Window > Main Window Features].
}

{Main Window Process List Table} {
This table lists all the [processes and other entities > Process List Entity Definition] from each [enabled > Controlling the Enabled Files] [file > Main Window File ComboBox].

The Process List Table (or pane) allows processes to be [selected > How to Select Process List Entities] so that lines can be [created > Line Creation] for that process's [statistics > Main Window Statistic List].

For each entity in the process list, the following items are displayed:
   * <b>StartTime</b>: The time the first sample was taken for this entity.
   * <b>EndTime</b>: The time the most recent or final sample was taken for this entity.
   * <b>File</b>: the [id > Loaded File Description Syntax] of the file the entity's samples where read from.
   * <b>Samples</b>: The number of samples taken so far for this entity. This can change if data is still being collected the file is [updated > How to Update the View of a Data File].
   * <b>Pid</b>: The process id of the process associated with this entity. Not required; primarily applies for GemStone processes.
   * <b>Type</b>: see [Process List Item Type Definition].
   * <b>Name</b>: a string of characters that identifies the entity; ideally this is unique, but it is not required. This can be set using System >> cacheName:, topaz set cachename, or by topaz command line -u argument.
   
A green font is used when samples are actively being collected in automatic update mode. 

!Sorting
The Process List is sorted with a primary and secondary sort key.  The primary sort key has a small arrow following the column name, pointing up or down to indicate ascending or descending sort order. Clicking on a column header selects that as the primary sort key, or if already selected, changes the sort order.  

The secondary sort key is in italic font. Right clicking on a column header selects the secondary sort key. 
The sort order for the secondary sort key is the same as for the primary sort key (ascending or descending).

If the entities in the Process List sort the same for primary and secondary sort keys, ordering is by Type in the same direction as the primary sort key.

!Selecting Process List Entities
See [How to Select Process List Entities].

!Key operations
   * <tt>control-s</tt> starts a [search > List Search Control].
   * <tt>right mouse button</tt> accesses the [popup menu > Process List Pane PopupMenu].
   * [List Multiple Selection]
   * <tt>double click</tt> on an item does an [add line operation > Main Window Add Line Button].

This control is on the [Main Window > Main Window Features].
}

{Main Window Statistic List} {
This statistics list pane on the [Main Window > Main Window Features] lists all the statistics for the selected [process or processes > Main Window Process List Table]. Only statistics common to all selected processes are displayed.  If no processes are selected, then all known statistics will be shown. The statistics are sorted in alphabetic order.

See [How to Select Statistics] for more information on searching and filtering statistics.

!Key operations
   * <tt>control-s</tt> starts a statistic [search > List Search Control].
   * [List Multiple Selection]
   * <tt>double click</tt> on an item does an [add line operation > Main Window Add Line Button].

}

{Main Window Status Display} {
The status display is located at the bottom of the [Main Window > Main Window Features].  This pane displays errors, [messages > Bell Messages] and [mouse help > Mouse Help].
}

{Process List Pane PopupMenu} {
Many of the items on this menu can also be found the [Main Window <b>Main</b> Menu]. 

!Items
   * [Search... > Process List PopupMenu Search... Item]
   * [Apply Alias Template For Type > Apply Alias Template For Type Menu Item]
   * [Remove Aliases > Remove Aliases Menu Item]
   * [Hide Instances By Type... > Hide Instances By Type Menu Item]
   * [Select Instances By... > Select Instances By Menu Item]
   * [Combine > Combine Menu Item]
   * [No Flatlines > No Flatlines Menu Item]
   * [Single File Mode > Single File Mode Menu Item]
   * [Absolute TimeStamps > Absolute TimeStamps Menu Item]

This popup menu is on the [Process List Pane > Main Window Process List Table] of the [Main Window > Main Window Features].
}

{Apply Alias Template For Type Menu Item} {
Gem Statistics includes Session Statistics, which can be used to monitor application-specific behavior.  Session Statistics are used internall in  GemStone code for important system processes, such as Backup, MarkForCollection, and Reclaim. To allow mapping from the Session Statistics number to a meaningful name, VSD provides aliases, which are mapped automatically for system Gems such as the ReclaimGem and AdminGem. Aliases work by matching the pattern of the Gem name in the statmonitor data file. For example, the ReclaimGem has a name like GcReclaim6. These system aliases are mapped by process name and are version-specific. 

Since operations such as markForCollection and restoreFromBackup are executed by ordinary Gems, which by default have the cache name GemN \
or TopazL, aliases cannot be applied by default. You can set the name of the gem performing the operation; for example, execute \
System cacheName: 'MarkForCollection'; then, the MarkForCollection template will be automatically applied when the statmonitor file is loaded. 

Otherwise, if you know the session that ran the given operation, you can apply the system alias by name; options are:
  * FullBackup
  * ListInstances
  * MarkForCollection
  * ObjectAudit
  * PageAudit
  * RestoreFromBackup

The <b>Apply Alias Template For Type</b> menu item procides a list of templates that you can select from to apply to the selected gem process in the process list pane. 

This items is on the [Process List Pane Popup menu > Process List Pane PopupMenu].
}

{Remove Aliases Menu Item} {
This removes any aliases for the given process, either a [system alias > Apply Alias Template For Type Menu Item] or custom alias. 

This items is on the [Process List Pane Popup menu > Process List Pane PopupMenu].
}


{Process List PopupMenu Search... Item} {
Starts an process list entity [search > List Search Control] operation.

[Accelerator Key > Keyboard Accelerators]: <tt>control-s</tt>
This item is part of the [Process List Popup menu > Process List Pane PopupMenu].
}

{Process List Entity Definition} {
The term <b>instance</b> is an older term used to refer to a logical identifiable entity which has associated with it a set of statistics. \
These are more commonly called <b>processes</b> in VSD documentation, although each entity may correspond to a OS process or a thread within an OS process, or an entity without a process such as a HardDisk.\

The statmonitor data includes some number of data samples for each entity in the Process List; these samples are snapshops of the statistic values for that process or other entity at a particular point in time.

An Process List Item's identity is determined by the following properties:
   * a name
   * a [type > Process List Item Type Definition]
   * an process id, for entities associated with OS processes
   * the file containing the entity's samples
}

{Process List Item Type Definition} {
Each [entry in the Process List > Process List Entity Definition] has a type. Each type has:
   * a name (such as Stn)
   * a version number (this is not related to a software version)
   * a set of statistic names
   
Usually the type is identified by its name. For the first file loaded, VSD assigns each types with version number 1, but this is not displayed. 

If additional files are loaded, in which the set of statistics for that type is not identical, VSD assigns the second type a new version number, and the process list may show, for example, both <em>Stn</em> and <em>Stn.2</em>. 

These may be statistics for a different version of GemStone, or the same version but with different statmonitor arguments that omit/include per-process host statistics.

!Well Known Process List Types
[statmonitor] is the GemStone server utility that generates statmonitor data files that are read by VSD.  The specific Process List Types that are included in a statmonitor data file will vary, depending on the version of the GemStone server, the host operating system, and the arguments to statmonitor. 

There are some well-known types that are commonly generated by statmonitor. They fall into two main categories; GemStone process types that come from the shared page cache, and host system types that are based on the operating system.  
   * <b>GemStone Types</b>
      * [Stn Type]
      * [Gem Type]
      * [Shrpc Type]
      * [Pgsvr Type]
      * [NetLDI Type]
      * [Statmon Type]
      * [AppStat Type]
      
   * <b>Host System Types</b>
      * [TCP Type]
      * [Linux_System Type]
      * [SimpleNetwork Type]
      * [ComplexNetwork Type]
      * [NtSystem Type]
      * [NtMemory Type]
      * [NtNetwork Type]
      * [NtPagingFile Type]

Data files that are generated from GBS are in the VSD binary format which encodes the type and statistics within the file.  See the GBS User's Guide for information on GBS statistics. 

VSD is not restricted so different types can be defined in data files that are generated in other ways.
}

{Gem Type} {
Represents a Smalltalk virtual machine. This type has a great number of statistics.
They include:
   * OS statistics
   * statistics for gem internals
   * statistics for Smalltalk code that may be executed in this gem.
   
}

{NetLDI Type} {
Represent a Network long distance information service. The NetLDI type primarily reports host statistics for memory management.

It is collected by default unless the <tt>-T</tt> or <tt>-Y</tt> option is used. 

}

{Pgsvr Type} {
Represents several different kinds of processes:
   * the page server on the Stone's node to service remote Gems
   * The remote cache page server on a remote node
   * Free frame page server/s
   * AIO page server/s

}

{Shrpc Type} {
Represents the shared page cache monitor. There is one of these per Stone. 
The statistics measure how the frames in the shared cache are being used.

}

{Stn Type} {
Represents the stone service. This is a single process that is present in each GemStone system. The statistics for the Stone measure overall system behavior and performance.

}

{Statmon Type} {
Represents the [statmonitor] process that collected the data.

Statmon type has only a small number of statistics other than [host system statistics>Host Operating System Statistics].

}

{AppStat Type} {
Represents the application statistics/shared counters collected by [statmonitor]. Statmonitor can be told when it starts to collection a certain number of appstats by using the <tt>-n</tt> command line switch. 

These shared counter statistics will always be zero unless application code has been written to change their values.

}

{Host Operating System Statistics} {
Also referred to as Host System Statistics. These statistics originate in the host operating system. These statistics apply both to Operating System processes such as Linux_System and to GemStone processes such as Stn and Gem. Host Statistics may or may not be collected, depending on the statmonitor arguments used. 

Since they are in the operating system not in the cache, a different API is required to collect these programmatically from GemStone
}

{Linux_System Type} {
Represents a Linux host machine. These statistics provide overall resource usage on a machine, both GemStone and non-GemStone loads.

Collected by [statmonitor] unless started with the -Y option, or (in older versions) with a <tt>-s</tt> level greater than zero.

}

{NtSystem Type} {
Represents a Windows host machine (for 32-bit GemStone/S). These statistics provide overall resource usage on a machine, both GemStone and non-GemStone loads.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

}

{NtMemory Type} {
Represents the memory management subsystem of a Windows NT machine. These statistics let you determine how much paging your machine is doing.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than zero.

}

{NtPagingFile Type} {
Represents a single Windows NT paging file. Paging files are used to provide virtual memory swap space. If it fills up you will start to get out of memory errors.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

}

{NtNetwork Type} {
Represents a Windows NT network subsystem.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than one.

}

{TCP Type} {
Represents a machines TCP networking subsystem.

It is only collected by [statmonitor] with <tt>-N</tt>, <tt>-A</tt>, <tt>-a</tt>, or (on older versions) with a higher <tt>-s</tt> argument. 

}

{SimpleNetwork Type} {
Represents a machines simple network adaptors. Typically this is the loopback adaptor. The loopback adapter is used when inter-process communication is done with sockets on the same machine.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

}

{ComplexNetwork Type} {
Represents a machines complex network adaptors. Typically this is any adaptor except for loopback.

Only collected by [statmonitor] if it started with a <tt>-s</tt> level greater than two.

}

{Loaded File Description Syntax} {
For loaded files vsd displays a short descriptive string to identify the file.
The exact syntax is <u><em>id</em><tt>. </tt><em>name os host version</em></u> where:
   * <em>id</em> is a unique number. It is used in the [process list table's > Main Window Process List Table] <b>File</b> column.
   * <em>name</em> is a trimmed form of the absolute file name. It will only be trimmed if the trimmed name differs from all other loaded file trimmed names.
   * <em>os</em> the operating system that the file's data was collected on.
   * <em>host</em> the host name of the machine the file's data was collected on.
   * <em>version</em> the version of the product the file's data was collected on.
}

{Main Window Chart: Entry Field ComboBox} {
The <tt>Chart:</tt> entry field (combo box) on the [Main Window > Main Window Features] has the following functions:
   * displays the name of the current chart
   * display a list of names of all existing charts (in the drop-down)
   * allows entering a name for a new chart
   * allows selection of the current chart

!Current Chart
The most recent selected [chart window > Chart Window Features] is the current chart. The name of this chart is displayed in the <tt>Chart:</tt> entry field.

To change the current chart, select that chart window or drop down the chart entry fields's drpop down list, and select from the list. The drop down list contains the names of all existing chart windows.

!Naming a New Chart
Each [chart window > Chart Window Features] is created with a unique name. By default the name is <u><tt>Chart </tt><em>x</em></u> where <em>x</em> is a number which continuously increases as new charts are created (the numbers are not reused). You can use the chart entry field near the bottom of the main windows, to enter a specific chart name; see [String Entry Editing > String Entry Editing] for string edit features. 

Since names must be unique (case sensitive), if a chart with the specified name already exists, the created chart will use the name <u><tt>Chart </tt><em>x</em></u>.

}

{Version History} {
Please visit the following web page for a history of VSD versions: http://gemtalksystems.com/products/vsd/history/

}

{File Trimming} {
Trimming data causes vsd to act as if that data does not exist.\
Each loaded file can have a two sequences of its data trimmed.
The <em>Left</em> sequence always starts with the file's first data sample.
The <em>Right</em> sequence always ends with the file's last data sample.
Trimming is always done with a single line even though it will cause the\
entire file to be trimmed. Using a line gives the trimmer a graphical\
display to pick the most meaningful trim point.
Trimming can be done more than once to a sequence making the sequence
larger each time.\
Untrimming totally reverses all trim operations on the sequence.

File and line trimming and untrimming may be disabled when rolling time \
trimming is active. See [rolling time trimming > File Menu Set Rolling Time Window].

The menu items that support file trimming are:
   * Line [Trim Left > Line Menu Trim Left Item]
   * Line [Trim Right > Line Menu Trim Right Item]
   * Line [Untrim Left > Line Menu Untrim Left Item]
   * Line [Untrim Right > Line Menu Untrim Right Item]
   * File [Untrim Left > File Menu Untrim Left Item]
   * File [Untrim Right > File Menu Untrim Right Item]
   * File [Set rolling time window > File Menu Set Rolling Time Window]
}

{Line Arithmetic} {
Two source lines on the same chart can be used to produce a new result line.\
The values in the result line are the result of adding, subtracting, or\
dividing the values of the source lines.\
The menu items that support line arithmetic are:
   * [Add Lines > Line Menu Add Lines Item]
   * [Diff Lines > Line Menu Diff Lines Item]
   * [Divide Lines > Line Menu Divide Lines Item]

The resulting line will only have data in the time period the two original lines had in common. Line arithmetic cannot be done on disjoint lines. You can [combine > Combine Menu Item] disjoint statistics which is much like adding lines.

If a [copy > Main Menu Copy Referenced Lines Item] of the source lines\
is made then subsequent changes to the sources lines will have no effect\
on the result line.

If the result line has a [reference > Main Menu Copy Referenced Lines Item]\
to the source lines then subsequent changes in the source lines will be\
propagated the result line.
}

{Multiple Files} {
Vsd supports working with multiple files:
   * The [process list table > Main Window Process List Table] shows the file id of the file that this process list item comes from. You can [control > Controlling the Enabled Files] which file's processes will be displayed.
   * [Template expansion > Template Expansion] will create a chart for each file, making it easy to compare files.
   * See also [comparing > How to Compare Files] and [merging files > How to Merge Files].
}

{statmonitor} {
<tt>statmonitor</tt> is a utility that is part of the GemStone server.  It periodically samples statistics and writes their values to a file. The source of the statistics can be a shared cache created by a [stone > Stn Type], either a local cache or a remote cache, or the host operating system. For both sources they must reside on the machine the statistic monitor is running on. By default, statmonitor will sample both a shared cache and some parts of the operating system.

<tt>statmonitor</tt> is located in the <tt>$GEMSTONE/bin</tt> subdirectory. When you invoke statmonitor from VSD, it is important to use the statmonitor executable that was distributed with the product whose shared cache you wish to monitor. If the versions are different, statmonitor may fail to start with a version mismatch error.

Statmonitor will keep running until it is stopped, the cache is it attached to is terminated, or until statmonitor reaches a limit set by <tt>-h</tt> or <tt>-t</tt>.

Statmonitor requires at least one argument when you start it, the name of the [stone > Stn Type] whose cache statistics will be monitored, the name of the cache, or -X if you are only monitoring system statistics. 

For a description of the format of the files written by statmonitor see [Statmonitor Output Format].

Statmonitor accepts a large number of optional switches after the required stone name; the specific set varies between GemStone versions. For specific information for your version of GemStone, see statmonitor -h output.  

Some of the most commonly used options are:

   * <tt>-i</tt> <em>interval</em>:  specifies the sampling interval in seconds. The default is twenty seconds. The minimum is one second. 
   * <tt>-I</tt> <em>msInterval</em>:  specifies the sampling interval in milliseconds (thousandths of a second). In server versions earlier than 3.3, true milliseconds were not supported and counter samples were written to the data file.  As of v3.3, timestamps may be in milliseconds, the default is twenty seconds, and the minimum is 10 milliseconds. 
   
   * <tt>-f</tt> <em>fileName</em>:  specifies the name of the file statmonitor will write its output to. If not specified defaults to <u><tt>statmon</tt><em>id</em><tt>.out</tt></u>. If you want statmonitor to write to its standard output, instead of a file, then use the string <tt>stdout</tt> as the <em>fileName</em> argument.
   * <tt>-z</tt>:  causes statmonitor's output file to be compressed using gzip. Vsd is able to read these files transparently. 
   * <tt>-Z</tt>:  causes statmonitor's output file to be compressed using lz4. Vsd is able to read these files transparently. 
   * <tt>-r</tt>:  causes statmonitor to restart a new output file when the current one completes. The <tt>-h</tt> or <tt>-t</tt> switches control when a restart is done. The base name of each file is given a unique suffix. Note that the generated files can be concatenated together and treated by vsd as a single file.
   * <tt>-h</tt> <em>hours</em>: causes statmonitor to only write to its output file for the given number of hours. Once that time is up statmonitor exits or restarts a new file (see <tt>-r</tt>). By default statmonitor writes until its interrupted or killed.
   * <tt>-t</tt> <em>times</em>: causes statmonitor to only write to its output file the given number of samples. Once that limits has been reached statmonitor exits or restarts a new file (see <tt>-r</tt>). By default statmonitor writes until its interrupted or killed.
   * <tt>-u</tt> <em>seconds</em>: tells statmonitor how long to buffer samples internally before flushing them to the output file. By default it will buffer for 60 seconds. Setting this to zero causes the interval (<tt>-i</tt> or <tt>-I</tt>) value to be used.
}

{Template Expansion} {
A template is made up of a list of [<em>lineSpecs</em> > Template Syntax]. Each lineSpec can end up [creating > Line Creation] zero or more lines on a chart. If you want all the lines generated by the expansion to go to a single chart window then use [Add From Template > Chart Menu Add From Template SubMenu]. Otherwise a chart is created for each unique file in the list of loaded files.

!Operations that Expand Templates
   * [New Template Chart > Template Menu New Template Chart SubMenu]
   * [Add From Template > Chart Menu Add From Template SubMenu]
}

{Statistic Aliases} {
Statistic aliases can be added to the [config file > VSD Files].
A statistic alias causes vsd to always use an existing statistic definition when it sees an aliased name. Aliases can be used to map older non-existent names to an existing statistic.
For each alias you want to define add a line of the following form:
   * <tt>sl_stat -alias</tt> <em>oldname newname</em>
where <em>oldname</em> is the statistic name you want mapped to <em>newname</em>.
}

{Statistic Definitions} {
Statistic definitions can be added to the [config file > VSD Files].
Each statistic definition must have the following attributes defined:
   * <b>name:</b> Names the statistic. This attribute is required. Should be an alphanumeric string.
   * <b>kind:</b> See [Statistic Information Window]'s <b>Displays</b> section for a description. This attribute is optional and defaults to <tt>uvalue</tt>. Legal values are:
      * <tt>counter</tt>
      * <tt>counter64</tt>
      * <tt>uvalue</tt>
      * <tt>svalue</tt>
      * <tt>svalue64</tt>
      * <tt>float</tt>
   * <b>units:</b> Describes the units that the statistic's value represents. This attribute is optional and defaults to <tt>none</tt>. Can be any string. See [Statistic Information Window]'s <b>Displays</b> section for list of common unit strings. 
   * <b>isOSStat:</b> Use a true value to indicate that the statistic value is generated by the operating system. This attribute is optional and defaults to <tt>false</tt>. Must be a boolean value.
   * <b>filter:</b> See [Default Filter MenuButton] for a description. This attribute is optional and defaults to <tt>default</tt>. Legal values are:
      * <tt>default</tt>
      * <tt>none</tt>
      * <tt>persecond</tt>
      * <tt>persample</tt>
      * <tt>aggregate</tt>
   * <b>description:</b> Documents the statistic. This attribute is optional and defaults to an empty string. Can be any string. To start a new paragraph in the description use an end of line. When referring to another statistic in the description text use this form to make it a hyper-link:
      * <tt> &#91;</tt><em>SN</em><tt> > </tt><em>SN</em><tt> Statistic]</tt> where <em>SN</em> is the name of the other statistic. Note that if your description string is enclosed in quotes <tt>""</tt> instead of curly brackets <tt>{}</tt> then you will need to escape the first square bracket with a backslash <tt>\</tt>.
Any user defined statistics will override definitions shipped with vsd.
For each statistic you want to define add a line of this form:
   * <tt>set statdef(</tt><em>name</em><tt>) {</tt><em>type level units isOSStat filter description</em><tt>}</tt>
To leave an optional attribute empty use an empty pair of curly brackets <tt>{}</tt>.
}
{Template Syntax} {
The contents of the [template file > VSD Files] must be [tcl code > Tcl Language]. The code in this file should define templates. Each template definition consists of a <em>name</em> and a <em>templateSpec</em>. To define a template an element must be added to the Tcl array named <b>vsdtemplates</b> and the index of the element must be the templates <em>name</em>.

The standard format of a template definition is: <tt>set vsdtemplates(</tt><em>name</em><tt>) </tt><em>templateSpec</em>.

What follows is the syntax for <em>templateSpecs</em>.
Square brackets <tt>[[]</tt> are used in the syntax descriptions to designate\
an optional element.

A <em>list</em> starts with an open curly brace <b>{</b> and is terminated\
by a matching close curly brace <b>}</b>. Whitespace is use to separate\
elements in a <em>list</em>. The curly braces are not required for single element lists.

A <em>templateSpec</em> is a <em>list</em> of <em>lineSpec</em>.
A <em>lineSpec</em> is either a <em>namesLineSpec</em>, a <em>simpleLineSpec</em> or an <em>operatorLineSpec</em>.
A <em>namesLineSpec</em> is a <em>list</em> in the following format:
   * <b>@</b> <em>nameList</em>
The <em>nameList</em> is a <em>list</em> of zero or more template names. A <em>namesLineSpec</em> is treated as the collection of all the named templates.

A <em>simpleLineSpec</em> is a <em>list</em> in the following format: 
   * <b>{</b><em>typeList namePattern stat scale filter axis</em> <tt>[[</tt><em>divider offset normalize</em><tt>] [[</tt><em>statFilter</em><tt>]</tt><b>}</b>
An <em>operatorLineSpec</em> is a <em>list</em> in the following format: 
   * <b>{</b><em>operator lineSpec1 lineSpec2 scale filter axis</em> <tt>[[</tt><em>divider offset normalize</em><tt>] [[</tt><em>statFilter</em><tt>]</tt><b>}</b>

The <em>typeList</em>, <em>namePattern</em>, and <em>stat</em> are used to select the data that will be plotted.
The <em>typeList</em> is a <em>list</em> of zero or more object type strings and/or file numbers.\
Examples of object type strings are Stn, Shrpc, Gem, Extent and Pgsvr.\
Each type in the list will be selected.
File numbers can be used to limit the spec to the numbered file.
If no types are specified then all the types that support <em>stat</em> will be selected.
If no file numbers are specified then all enabled files will be selected.
An optional plus character <b>+</b> can be appended to the last type in the\
list. This will cause all of the processe list items that match this <em>lineSpec</em>\
to be [combined > Combine Menu Item].

The <em>namePattern</em> can be used to restrict which process list items of the\
 types should be selected. It can be a simple name or a [pattern > Glob Style Pattern Syntax]. Use the pattern <b>*</b> if you don't care about the name.

The <em>stat</em> must be a valid statistic name for the given <em>typeList</em>.

The <em>operator</em> field must be one of the following strings:
   * <b>plus</b>
   * <b>diff</b>
   * <b>divide</b>

Both <em>lineSpec1</em> and <em>lineSpec2</em> are a <em>lineSpec</em>.\
The lines produced by these specs are combined together using the <em>operator</em>\
to produce the visible line. If one spec produces more lines than the\
other than the final line from the lessor spec is used repeatedly.

The <em>scale</em> must be a number. See [Display Scaling a Line] to learn what this number will do.

The <em>filter</em> must be one of the following strings:
  <b>none</b>, <b>persecond</b>, <b>persample</b>, or <b>aggregate</b>.
See [How to Filter Statistics] to learn what this string will do.

The <em>axis</em> must be the string <b>y</b> or <b>y2</b>.\
This [controls what Y axis > Line Menu Graph on Left Axis Item] the line will be graphed on

The <em>divider</em> must be a number. See [Value Scaling a Line]\
to learn what this number will do.

The <em>offset</em> must be a number. See [Offsetting a Line]\
to learn what this number will do.
The <em>offset</em> number is ignored if <em>normalize</em> is not zero.

The <em>normalize</em> must be the number zero or one.\
See [Normalizing a Line] to learn what this number will do.

!Statistic Filters
The optional <em>statFilter</em> is a <em>list</em> that lets you exclude lines\
based on their stat values. Its format is:
   <b>{</b><em>count min max mean stddev</em><b>}</b>
Each line produced by a template's lineSpec is checked against this filter before its added to the chart. Each line's values must pass each of the constraints imposed by the non-empty items in the filter.
Any statFilter item can be an empty string <b>{}</b>,
a single number, or a list of two numbers.

If an item is the empty string <b>{}</b> it is ignored.

If an item is a list of two numbers (i.e. <b>{36 100}</b>) then\
the first number must be less than the second number and\
if the stat is less than the first or greater than the second\
then it is excluded.

If an item is a number then it is used as follows:
   * If <em>count</em> >= 0 then any line with less samples than the filter is excluded.
   * If <em>count</em> < 0 then any line with more samples than the absolute value\
of the filter is excluded.
   * If <em>min</em> >= 0 then any line whose min is less than the filter is excluded.
   * If <em>min</em> < 0 then any line whose min is greater than the filter is excluded.
   * If <em>max</em> >= 0 then any line whose max is less than the filter is excluded.
   * If <em>max</em> < 0 then any line whose max is greater than the absolute value of the filter is excluded.
   * If <em>mean</em> >= 0 then any line whose mean is less than the filter is excluded.
   * If <em>mean</em> < 0 then any line whose mean is greater than the absolute value of the filter is excluded.
   * If <em>stddev</em> >= 0 then any line whose stddev is less than the filter is excluded.
   * If <em>stddev</em> < 0 then any line whose stddev is greater than the absolute value of the filter is excluded.

!Filter examples:
   * <tt>{100}</tt> only includes stats who have at least 100 samples.
   * <tt>{{} {} 100}</tt> only includes stats whose max is >= 100.
   * <tt>{{} 20 {} {} -5}</tt> only includes stats whose min >= 20\
and whose standard deviation is less than 5.
   * <tt>{{100 200} {} {-500} {120 240}}</tt> only includes stats who have\
at least 100 samples but no more than 200 samples\
and whose maximum value is less than 500\
and whose average value is between 120 and 240.
}
{Glob Style Pattern Syntax} {
   * <b>*</b> Matches any sequence of characters including a null string.
   * <b>?</b> Matches any single character.
   * <b>[[</b><em>chars</em><b>]</b> Matches any character in the set given by\
<em>chars</em>. If a sequence of the form <em>x</em><b>-</b><em>y</em> appears\
in <em>chars</em>, then any character between <em>x</em> and <em>y</em>,\
inclusive, will match.
   * <b>\</b><em>x</em> Matches the single character <em>x</em>.\
This provides a way of avoiding the special\
interpretation of the characters <b>*?[[]\</b> in the pattern.
}
}

