################################################################################
# vsd.internal.stat.aliases.tcl
#
# Tcl script to setup "internal" statistic aliases for all versions of GemStone
#
# Internal aliases can be setup in 1 of 2 ways:
#
# 1) Match a pattern to the cache name of the gem
# This is taken care of by VSD automatically.  VSD looks for gems with a cache
# name that matches one the provided cache name patterns, AND whose version
# matches a version pattern.  When both conditions are met, the alias names
# are automatically applied to SessionStat00 - SessionStat47.
#
# 2) VSD user can choose to select an alias template to apply to a gem
# Some gems with aliases are not recognizable by VSD.  For instance, the main
# process of an MFC may have the cache name Topaz2-23.  However if the VSD user
# knows this is an MFC, they can choose to apply the MarkForCollection alias
# to Topaz2-23 by right-clicking on the process and selecting "Apply Alias For Template"
# MarkForCollection.  The Tcl command to add a command to that right click menu is:
#   setInternalCtrAliasTemplateType <commandName>
#
# All square brackets ([ and ]) MUST be escaped with a \, else tcl will choke.

################################################################################
# 3.x
################################################################################
# Some versions use reclaim-*, some use Reclaim-*
# [R|r]eclaim-* threads
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat00 Task svalue64 none Task \
    {ID of the current task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat01 ReclaimPagesTime counter64 none microseconds \
    {Cumulative number of real microseconds performing reclaim} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat02 DeadOopsToPagesTime counter64 none microseconds \
    {Cumulative number of real microseconds looking up page ID for dead objects} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat03 EmptyDeltasTime counter64 none microseconds \
    {Cumulative number of real microseconds emptying OT deltas} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat04 SleepBetweenReclaimTime counter64 none microseconds \
  {Cumulative number of real microseconds sleeping between reclaims} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat05 SleepTime counter64 none microseconds \
    {Cumulative number of real microseconds sleeping} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat06 PinnedPages svalue64 none Pages \
    {Number of pages currently pinned} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat07 DpMgrPages svalue64 none Pages \
    {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat08 FreePages svalue64 none Pages \
    {Number of pages in the free pool} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat09 OopsMoved counter64 none Oops \
    {Cumulative number of live objects moved to new pages} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat10 OopsReclaimed counter64 none Oops \
    {Cumulative number of dead objects reclaimed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat11 PagesReclaimed counter64 none Pages \
    {Cumulative number of pages reclaimed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat12 ConflictCount counter64 none Conflicts \
    {Cumulative number of objects for which a write-write conflict was resolved during reclaim} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat13 DepMapConflictCount counter64 none Conflicts \
    {Cumulative number of dependency map conflicts resolved during reclaim} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  # SessionStat14 for main thread only
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat15 DeadOopsConvertedCount counter64 none Oops \
    {Cumulative number of dead objects resolved to page IDs} {3.\[5-9\].* 3.4* 3.3* 3.2*}
 # SessionStat16 for main thread only  
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat17 AugmentQueueSize svalue64 none \
    {OT Entries} {Number of OT entries in the augment queue} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat18 LastSleepTime svalue64 none Milliseconds \
    {Requested duration of the last sleep interval} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {Reclaim-* reclaim-*} SessionStat19 SleepCount counter64 none Sleeps \
  {Cumulative number of sleep operations} {3.\[5-9\].* 3.4* 3.3* 3.2*}

  # reclaim main thread
  setInternalCtrAlias GcReclaim* SessionStat00 Task svalue64 none Task \
    {ID of the current task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat01 ReclaimPagesTime counter64 none microseconds \
    {Cumulative number of real microseconds performing reclaim} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat02 DeadOopsToPagesTime counter64 none microseconds \
    {Cumulative number of real microseconds looking up page ID for dead objects} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat03 EmptyDeltasTime counter64 none microseconds \
    {Cumulative number of real microseconds emptying OT deltas} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat04 SleepBetweenReclaimTime counter64 none microseconds \
    {Cumulative number of real microseconds sleeping between reclaims} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat05 SleepTime counter64 none microseconds \
    {Cumulative number of real microseconds sleeping} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat06 PinnedPages svalue64 none Pages \
    {Number of pages currently pinned} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat07 DpMgrPages svalue64 none Pages \
    {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat08 FreePages svalue64 none Pages \
    {Number of pages in the free pool} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat09 OopsMoved counter64 none Oops \
    {Cumulative number of live objects moved to new pages} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat10 OopsReclaimed counter64 none Oops \
    {Cumulative number of dead objects reclaimed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat11 PagesReclaimed counter64 none Pages \
    {Cumulative number of pages reclaimed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat12 ConflictCount counter64 none Conflicts \
    {Cumulative number of objects for which a write-write conflict was resolved during reclaim} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat13 DepMapConflictCount counter64 none Conflicts \
    {Cumulative number of dependency map conflicts resolved during reclaim} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}  
  setInternalCtrAlias GcReclaim* SessionStat14 ConvertDeadCount counter64 none Operations \
    {Number of times the convertDead operation was started} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat15 DeadOopsConvertedCount counter64 none Oops \
    {Cumulative number of dead objects resolved to page IDs} {3.\[5-9\].* 3.4* 3.3* 3.2*}  
  setInternalCtrAlias GcReclaim* SessionStat16 StnTempPagesCount svalue64 none Pages \
    {Number of temporary pages stone has allocated to this session} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat17 AugmentQueueSize svalue64 none \
    {OT Entries} {Number of OT entries in the augment queue} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat18 LastSleepTime svalue64 none Milliseconds \
    {Requested duration of the last sleep interval} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat19 SleepCount counter64 none Sleeps \
    {Cumulative number of sleep operations} {3.\[5-9\].* 3.4* 3.3* 3.2*}  
  setInternalCtrAlias GcReclaim* SessionStat20 StayInTransCount counter64 none Operations \
    {Number of times the session remained in transaction after a reclaim commit} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat21 CacheTooDirtyCount counter64 none Operations \
    {Number of times reclaim was suspended because of too many dirty pages in the cache} \
    {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat22 FreeSpaceLowCount counter64 none Operations \
    {Number of times reclaim was suspended because of low free space} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcReclaim* SessionStat23 GetPriorityDeadCount counter64 none Operations \
    {Number of times priority dead objects were requested from stone} {3.4* 3.3*}
  setInternalCtrAlias GcReclaim* SessionStat23 WorkQueueSize svalue64 none Size \
    {Number of DeltaBuf entries in the WorkQueue} {3.\[5-9\].*}
  setInternalCtrAlias GcReclaim* SessionStat24 ResultQueueSize svalue64 none Size \
    {Number of DeltaBuf entries in the ResultQueue} {3.\[5-9\].*}
  setInternalCtrAlias GcReclaim* SessionStat24 PriorityDeadOops counter64 none Oops \
    {Cumulative number of priority dead objects processed} {3.4* 3.3*}
  setInternalCtrAlias GcReclaim* SessionStat25 PriorityPages counter64 none Pages \
    {Cumulative number of priority pages processed} {3.\[5-9\].* 3.4* 3.3*}
  setInternalCtrAlias GcReclaim* SessionStat26 PagesBelowGcHw svalue64 none Pages \
    {Number of pages found below the GC HW mark} {3.\[5-9\].* 3.4* 3.3*}
  setInternalCtrAlias GcReclaim* SessionStat27 LoopState svalue64 none State \
    {State of the main GC reclaim loop} {3.\[5-9\].* 3.4* 3.3*}
  setInternalCtrAlias GcReclaim* SessionStat28 AlertCount counter64 none Alerts \
    {Number of Alerts received from the stone} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcReclaim* SessionStat29 CommitReason svalue64 none Value \
    {The reason it was determined to be timeToCommit} {3.\[5-9\].*}

# 3.3 specific stats
  setInternalCtrAlias GcReclaim* SessionStat30 ReclaimMinPages svalue64 none Pages \
    {Value of reclaimMinPages config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat31 DeferReclaimCacheDirtyThreshold svalue64 none Percent \
    {Value of deferReclaimCacheDirtyThreshold config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat32 ReclaimMinFreeSpaceMb svalue64 none Megabytes \
  {Value of reclaimMinFreeSpaceMb config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat33 SleepTimeBetweenReclaimMs svalue64 none Milliseconds \
    {Value of sleepTimeBetweenReclaimMs config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat34 SleepTimeWithCrBacklogMs svalue64 none Milliseconds \
    {Value of sleepTimeWithCrBacklogMs config setting} {3.3 }
  setInternalCtrAlias GcReclaim* SessionStat35 ReclaimDeadEnabled svalue64 none Boolean \
    {Value of reclaimDeadEnabled config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat36 ObjsMovedPerCommitThreshold svalue64 none Objects \
    {Value of objsMovedPerCommitThreshold config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat37 DeadObjsReclaimedCommitThreshold svalue64 none Objects \
    {Value of deadObjsReclaimedCommitThreshold config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat38 MaxTransactionDuration svalue64 none Seconds \
    {Value of maxTransactionDuration config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat39 ObjectTableCleanupIdleTime svalue64 none Seconds \
    {Value of objectTableCleanupIdleTime config setting} {3.3*}
  setInternalCtrAlias GcReclaim* SessionStat40 ReclaimVerboseLogging svalue64 none Boolean \
    {Value of reclaimVerboseLogging config setting} {3.3*}

# 3.4
  setInternalCtrAlias GcReclaim* SessionStat37 ReclaimMinPages svalue64 none Pages \
    {Value of reclaimMinPages config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat38 ReclaimMinFreeSpaceMb svalue64 none Megabytes \
    {Value of reclaimMinFreeSpaceMb config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat39 DeferReclaimCacheDirtyThreshold svalue64 none Percent \
    {Value of deferReclaimCacheDirtyThreshold config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat40 SleepTimeBetweenReclaimMs svalue64 none Milliseconds \
    {Value of sleepTimeBetweenReclaimMs config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat41 SleepTimeWithCrBacklogMs svalue64 none Milliseconds \
    {Value of sleepTimeWithCrBacklogMs config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat42 ReclaimDeadEnabled svalue64 none Boolean \
    {Value of reclaimDeadEnabled config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat43 ObjsMovedPerCommitThreshold svalue64 none Objects \
    {Value of objsMovedPerCommitThreshold config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat44 DeadObjsReclaimedCommitThreshold svalue64 none Objects \
    {Value of deadObjsReclaimedCommitThreshold config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat45 MaxTransactionDuration svalue64 none Seconds \
    {Value of maxTransactionDuration config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat46 ObjectTableCleanupIdleTime svalue64 none Seconds \
    {Value of objectTableCleanupIdleTime config setting} {3.4*}
  setInternalCtrAlias GcReclaim* SessionStat47 ReclaimVerboseLogging svalue64 none Boolean \
    {Value of reclaimVerboseLogging config setting} {3.4*}

# 3.5
  setInternalCtrAlias GcReclaim* SessionStat30 DeadOopsLimit svalue64 none Oops \
    {The limit that controls the number of deadOops converted to pages for a commit} {3.\[5-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat31 ActiveReclaimMinPages svalue64 none Oops \
    {Value of reclaimMinPages currently in use.} {3.5.*}
  setInternalCtrAlias GcReclaim* SessionStat32 ActiveObjsMovedPerCommitThreshold svalue64 none Oops \
    {Value of objsMovedPerCommitThreshold currently in use.} {3.5.*}
  setInternalCtrAlias GcReclaim* SessionStat33 ActiveDeadObjsReclaimedCommitThreshold  svalue64 none Oops \
    {Value of deadObjsReclaimedCommitThreshold currently in use.} {3.5.*}
  setInternalCtrAlias GcReclaim* SessionStat34 ActiveReclaimDeadEnabled svalue64 none Oops \
    {Value of reclaimDeadEnabled currently in use.} {3.5.*}

  setInternalCtrAlias GcReclaim* SessionStat38 ReclaimMinPages svalue64 none Pages \
    {Value of reclaimMinPages config setting} {3.\[5-9\].*}
  setInternalCtrAlias GcReclaim* SessionStat39 ReclaimMinFreeSpaceMb svalue64 none Megabytes \
  {Value of reclaimMinFreeSpaceMb config setting} {3.\[5-6\].* 3.7.\[0-1\]}
# ReclaimMinFreeSpaceMb removed in 3.7.2. All higher stats move down 1 starting with DeferReclaimCacheDirtyThreshold
# Warning: double digit matching must be regex correct.
# Wrong:   {3.\[5-12\].*}
# Correct: {3.\[5-9\]|1\[0-2\].*}
  setInternalCtrAlias GcReclaim* SessionStat40 DeferReclaimCacheDirtyThreshold svalue64 none Percent \
  {Value of deferReclaimCacheDirtyThreshold config setting} {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat39 DeferReclaimCacheDirtyThreshold svalue64 none Percent \
  {Value of deferReclaimCacheDirtyThreshold config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat41 SleepTimeBetweenReclaimMs svalue64 none MilliSeconds \
  {Value of sleepTimeBetweenReclaimMs config setting} {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat40 SleepTimeBetweenReclaimMs svalue64 none MilliSeconds \
  {Value of sleepTimeBetweenReclaimMs config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat42 SleepTimeWithCrBacklogMs svalue64 none MilliSeconds \
  {Value of sleepTimeWithCrBacklogMs config setting} {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat41 SleepTimeWithCrBacklogMs svalue64 none MilliSeconds \
  {Value of sleepTimeWithCrBacklogMs config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat43 ReclaimDeadEnabled svalue64 none Boolean \
  {Value of reclaimDeadEnabled config setting} {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat42 ReclaimDeadEnabled svalue64 none Boolean \
  {Value of reclaimDeadEnabled config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat44 ObjsMovedPerCommitThreshold svalue64 none Objects \
  {Value of objsMovedPerCommitThreshold config setting} {3.\[5-6\].* 3.7.\[0-1\]}
 setInternalCtrAlias GcReclaim* SessionStat43 ObjsMovedPerCommitThreshold svalue64 none Objects \
  {Value of objsMovedPerCommitThreshold config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat45 DeadObjsReclaimedCommitThreshold svalue64 none Objects \
  {Value of deadObjsReclaimedCommitThreshold config setting} {3.\[5-6\].* 3.7.\[0-1\]}
 setInternalCtrAlias GcReclaim* SessionStat44 DeadObjsReclaimedCommitThreshold svalue64 none Objects \
  {Value of deadObjsReclaimedCommitThreshold config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat46 MaxTransactionDuration svalue64 none Seconds \
  {Value of maxTransactionDuration config setting} {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat45 MaxTransactionDuration svalue64 none Seconds \
  {Value of maxTransactionDuration config setting} {3.7.\[2-9\] 3.\[8-9\].*}

  set desc \
    {Value of reclaimVerboseLogging config setting: values are:
      0 -      only summary information every 5 minutes in slow, 15 minutes in a fast
      1 -      log sigAbort, gcGemAlert, gcHwPage, etc
      2 -      numDead from stone, numDead processed per thread
      3 -      Summary: comitCount, stayInTrans, crPage, numLive, numDead, numReclPages
      4 -      Abort, Start, Phases, Finish
      5 -      Conflict set
      6 -      num live and dead found per page
      7 -      summary of info added to ot slot
      8 -      deltas in rootPage
      9 -      push live or dead
    }

  setInternalCtrAlias GcReclaim* SessionStat47 ReclaimVerboseLogging svalue64 none Boolean \
  $desc {3.\[5-6\].* 3.7.\[0-1\]}
  setInternalCtrAlias GcReclaim* SessionStat46 ReclaimVerboseLogging svalue64 none Boolean \
  $desc {3.7.\[2-9\] 3.\[8-9\].*}
  unset desc


# Admin GC gem for 3.5, 3.4, 3.3, 3.2
  setInternalCtrAlias GcAdmin* SessionStat01 ScanPhase counter64 none Phase \
  {Scan phase:
    6 - epoch GC
    7 - sweep write set union} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat02 OtPagesRead counter64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat06 MarkSweepPhase counter64 none Phase \
  {Phase the mark/sweep is in. 17 = WsUnion - PossibleDead, 18 = WsUnion sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat07 MarkedMinusSweptScans counter64 none Scans \
  {Number of marked - swept scans} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat08 LeafObjsCount counter64 none Objects \
  {Number of leaf objects found during mark/sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat09 LeafObjsOptUsed counter64 none Objects \
  {Number of leaf objects used during mark/sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat10 PagesFoundInCache counter64 none Pages \
  {Number of pages found in the shared cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat11 NumPagesToSweep counter64 none Pages \
  {Number of pages to be swept} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat12 NumPagesSwept counter64 none Pages \
  {Number of pages swept} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat13 NumNewMarked counter64 none Objects \
  {Number of new marked objects found by the most recent scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat14 NumPinnedPages counter64 none Pages \
  {Number of pages currently pinned in the cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat15 TotalPinnedPages counter64 none Pages \
  {Total number of pages which were pinned in the cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat16 GetDataPagesTime counter64 none NanoSeconds \
  {Time spent getting shared data pages to sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat17 DataPagesCount counter64 none Pages \
  {Total data pages swept} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat18 AlreadySweptPages counter64 none Pages \
  {Total number of pages containing 1 or more already swept objects} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat30 EpochGcObjsSwept counter64 none Objects \
  {Total number of objects swept in EpochGc} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias GcAdmin* SessionStat34 LeafCacheSize counter64 none Objects \
  {Num objects in leafCache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  
# Admin GC gem config stats for 3.3 
  setInternalCtrAlias GcAdmin* SessionStat30 AdminVerboseLogging counter64 none Boolean \
  {Value of AdminVerboseLogging config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat31  SaveWriteSetUnionToFile counter64 none Boolean \
  {Value of SaveWriteSetUnionToFile config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat32 EpochGcTimeLimit counter64 none Seconds \
  {Value of epochGcTimeLimit config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat33 EpochGcTransLimit counter64 none Transactions \
  {Value of epochGcTransLimit config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat34 EpochGcMaxThreads counter64 none Threads \
  {Value of epochGcMaxThreads config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat35 EpochGcPageBufferSize counter64 none Pages \
  {Value of epochGcPageBufferSize config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat36 EpochGcPercentCpuActiveLimit counter64 none Percent \
  {Value of epochGcPercentCpuActiveLimit config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat37 SweepWsUnionMaxThreads counter64 none Threads \
  {Value of sweepWsUnionMaxThreads config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat38 SweepWsUnionPageBufferSize counter64 none Pages \
  {Value of sweepWsUnionPageBufferSize config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat39 SweepWsUnionPercentCpuActiveLimit counter64 none Percent \
  {Value of sweepWsUnionPercentCpuActiveLimit config setting} {3.3*}
  setInternalCtrAlias GcAdmin* SessionStat47 AlertCount counter64 none Alerts \
    {Number of Alerts received from the stone} {3.3* 3.2*}

# Admin GC gem for 3.5, 3.4
  setInternalCtrAlias GcAdmin* SessionStat28 AlertCount counter64 none Alerts \
  {Number of Alerts received from the stone} {3.\[5-9\].* 3.4*}

# Admin GC gem config stats for 3.5, 3.4
  setInternalCtrAlias GcAdmin* SessionStat37 AdminVerboseLogging counter64 none Boolean \
  {Value of AdminVerboseLogging config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat38  SaveWriteSetUnionToFile counter64 none Boolean \
  {Value of SaveWriteSetUnionToFile config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat39 EpochGcTimeLimit counter64 none Seconds \
  {Value of epochGcTimeLimit config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat40 EpochGcTransLimit counter64 none Transactions \
  {Value of epochGcTransLimit config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat41 EpochGcMaxThreads counter64 none Threads \
  {Value of epochGcMaxThreads config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat42 EpochGcPageBufferSize counter64 none Pages \
  {Value of epochGcPageBufferSize config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat43 EpochGcPercentCpuActiveLimit counter64 none Percent \
  {Value of epochGcPercentCpuActiveLimit config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat44 SweepWsUnionMaxThreads counter64 none Threads \
  {Value of sweepWsUnionMaxThreads config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat45 SweepWsUnionPageBufferSize counter64 none Pages \
  {Value of sweepWsUnionPageBufferSize config setting} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias GcAdmin* SessionStat46 SweepWsUnionPercentCpuActiveLimit counter64 none Percent \
  {Value of sweepWsUnionPercentCpuActiveLimit config setting} {3.\[5-9\].* 3.4*}

# MarkForCollection 3.\[5-9\].*, 3.4*
# This set of aliases may be used as a template for sessions stats of gems with non-matching cache patterns
setInternalCtrAliasTemplateType MarkForCollection

setInternalCtrAlias MarkForCollection SessionStat00 OpId svalue64 none ID \
  {Operation ID} {3.\[5-9\].* 3.4* 3.3* 3.2*}
# 1 not used here
# 2 not used here
  setInternalCtrAlias MarkForCollection SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
# 5 not used here
  setInternalCtrAlias MarkForCollection SessionStat06 MarkSweepPhase counter64 none Phase \
  {Phase the mark/sweep is in. 17 = WsUnion - PossibleDead, 18 = WsUnion sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat07 MarkedMinusSweptScans counter64 none Scans \
  {Number of marked - swept scans} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat08 LeafObjsCount counter64 none Objects \
  {Number of leaf objects found during mark/sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat09 LeafObjsOptUsed counter64 none Objects \
  {Number of leaf objects used during mark/sweep} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat10 PagesFoundInCache counter64 none Pages \
  {Number of pages found in the shared cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat11 NumPagesToSweep counter64 none Pages \
  {Number of pages to be swept} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat12 NumPagesSwept counter64 none Pages \
  {Number of pages swept} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat13 NumNewMarked counter64 none Objects \
  {Number of new marked objects found by the most recent scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat14 NumPinnedPages counter64 none Pages \
  {Number of pages currently pinned in the cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat15 TotalPinnedPages counter64 none Pages \
  {Total number of pages which were pinned in the cache} {3.\[5-9\].* 3.4* 3.3* 3.2*}

  # 3.5/3.4
  setInternalCtrAlias {TopazL* MarkForCollection} SessionStat16 GetObjPagesTime svalue64 none Nanoseconds \
    {Time spent looking up objects in the object table} {3.\[5-9\].* 3.4*}
  setInternalCtrAlias {TopazL* MarkForCollection} SessionStat17 GetObjPagesCount svalue64 none Operations \
    {Number of shared OT lookups} {3.\[5-9\].* 3.4*}
# 3.3/3.2
   setInternalCtrAlias MarkForCollection SessionStat16 EndGamePageReads svalue64 none Reads \
    {Number of page read during the end game phase.} {3.3* 3.2*}
  setInternalCtrAlias MarkForCollection SessionStat17 EndGamePagesInCache svalue64 none Pages \
  {Number pages found in the cache during the end game phase.} {3.3* 3.2*}
setInternalCtrAlias {TopazL* MarkForCollection} SessionStat18 AlreadySweptPages counter64 none Pages \
  {Total number of pages containing 1 or more already swept objects} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* MarkForCollection} SessionStat19 NumMarkedMinusSwept svalue64 none Objects \
  {Number of objects in the marked - swept set} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* MarkForCollection} SessionStat20 NewMarkedCount svalue64 none Objects \
  {Number of objects in the new marked set} {3.\[5-9\].* 3.4* 3.3* 3.2*}
# 21 not used here

 # 3.5/3.4
setInternalCtrAlias MarkForCollection SessionStat22 NumLargeByteObjectRoots svalue64 none Objects \
  {Number of large byte object roots found} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat23 NumLargeByteObjectLeaves svalue64 none Objects \
  {Number of large byte object leaves found} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat24 NumLargeOopObjectRoots svalue64 none Objects \
  {Number of large oop object roots found} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat25 NumLargeOopObjectRefs  svalue64 none Objects \
  {Number of objects referenced by large oop object root nodes.} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat26 LrgNscRoots svalue64 none Objects \
  {Number of large NSC root objects found} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat27 LrgNscRefs svalue64 none Objects \
  {Number of objects referenced by large NSC root nodes.} {3.\[5-9\].* 3.4*}
setInternalCtrAlias MarkForCollection SessionStat28 ThreadsInSweep svalue64 none Threads \
  {Number of threads performing the mark/sweep} {3.\[5-9\].* 3.4*}

# 3.3/3.2
setInternalCtrAlias MarkForCollection SessionStat22 PagesNotRead svalue64 none Pages \
  {desc} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat23 NumLargeByteObjectRoots svalue64 none Objects \
  {Number of large byte object roots found} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat24 NumLargeByteObjectLeaves svalue64 none Objects \
  {Number of large byte object leaves found} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat25 NumLargeOopObjectRoots svalue64 none Objects \
  {Number of large oop object roots found} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat26 NumLargeOopObjectRefs  svalue64 none Objects \
  {Number of objects referenced by large oop object root nodes.} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat27 LrgNscRoots svalue64 none Objects \
  {Number of large NSC root objects found} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat28 LrgNscRefs svalue64 none Objects \
  {Number of objects referenced by large NSC root nodes.} {3.3* 3.2*}
setInternalCtrAlias MarkForCollection SessionStat29 ThreadsInSweep svalue64 none Threads \
  {Number of threads performing the mark/sweep} {3.3* 3.2*}

# mfc threads
# 0 is CURRENT_TASK but is not implemented

# add TopazL to cover 3.6.7
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat01  TimeInMarkedMinusSwept svalue64 none Microseconds \
  {Total number of microseconds spent in the marked minus swept task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat02  TimeInOopsToPages svalue64 none Microseconds \
  {Total number of microseconds spent in the oops to pages task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat03  TimeInAddPagesToSweep svalue64 none Microseconds \
  {Total number of microseconds spent in the add pages to sweep task} {3.2*}
# 3 is TIME_IN_ADD_PAGES_TO_SWEEP only in 3.2*
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat04  TimeInLoadPages svalue64 none Microseconds \
  {Total number of microseconds spent in the load pages task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat05  TimeInProcessPages svalue64 none Microseconds \
  {Total number of microseconds spent in the process pages task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat06  TimeInReadPages svalue64 none Microseconds \
  {Total number of microseconds spent in the read pages task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat07  TimeInSweepNewMarked svalue64 none Microseconds \
  {Total number of microseconds spent sweeping new marked objects for this thread} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat08  TimeSleeping svalue64 none Microseconds \
  {Total number of microseconds spent sleeping} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat09  OopsFoundInMarkedMinusSwept svalue64 none Oops \
  {Total number of oops found by the marked minus swept task} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat10  SlaveNumPinnedPages svalue64 none Pages \
  {Number of pages currently pinned by this thread} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat11  PagesInBuffer svalue64 none Pages \
  {Number of pages currently in the pages to sweep buffer} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat129  OopsFoundInLastMarkedMinusSwept svalue64 none Oops \
  {Number of oops found by the last marked minus swept task} {3.6.\[7-9\]}
# 12 is PAGES_IN_BUF_CHAINS but is not implemented
  setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat13 NumNewMarked counter64 none Objects \
  {Number of new marked objects found by the most recent scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat14 NumPinnedPages counter64 none Pages \
  {Number of pages currently pinned in the cache} {3.6* 3.5* 3.4* 3.3* 3.2*}
  setInternalCtrAlias {TopazL* mfc-* findDisconnecedObjs*} SessionStat15 TotalPinnedPages counter64 none Pages \
  {Total number of pages which were pinned in the cache} {3.6* 3.5.* 3.4* 3.3* 3.2*}

# Full backup
setInternalCtrAliasTemplateType FullBackup

setInternalCtrAlias FullBackup SessionStat00 OpId svalue64 none ID \
  {Operation ID (121 = Object Audit)} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias FullBackup SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias FullBackup SessionStat02 OtPagesRead svalue64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias FullBackup SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias FullBackup SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}

# Restore from backup
setInternalCtrAliasTemplateType RestoreFromBackup

setInternalCtrAlias RestoreFromBackup SessionStat00 OpId svalue64 none ID \
  {Operation ID (11 = Restore From Backup)} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan (8 = restore data pages)} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat29 BuffersInQueue counter64 none Buffers \
  {Number of buffers in the backup record queue} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat30 OtDeltasSize svalue64 none Deltas \
  {Size of the object table deltas buffer} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias RestoreFromBackup SessionStat32 NumFreePages svalue64 none Pages \
  {Number of pages in the free pages buffer} {3.\[5-9\].* 3.4* 3.3* 3.2*}


# Page Audit
setInternalCtrAliasTemplateType PageAudit

setInternalCtrAlias PageAudit SessionStat00 OpId svalue64 none ID \
  {Operation ID (14 = Page Audit)} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias PageAudit SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan (2 = Scan object table, 3 = Scan data pages)} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias PageAudit SessionStat02 OtPagesRead counter64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias PageAudit SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias PageAudit SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}

# Object Audit
setInternalCtrAliasTemplateType ObjectAudit

setInternalCtrAlias ObjectAudit SessionStat00 OpId svalue64 none ID \
  {Operation ID} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ObjectAudit SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan:
    0  - inactive
    2  - scan object table
    11 - audit scavengable pages
    12 - audit data pages
    13 - rescan object table
    14 - rescan data pages} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ObjectAudit SessionStat02 OtPagesRead svalue64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ObjectAudit SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ObjectAudit SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}

# cache warmer
setInternalCtrAlias CacheWarmer* SessionStat00 OpId svalue64 none ID \
  {Operation ID} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias CacheWarmer* SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias CacheWarmer* SessionStat02 OtPagesRead svalue64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias CacheWarmer*  SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias CacheWarmer* SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}

#Log Sender
# Stats were added in 3.3.7, 3.4.2 and 3.5.0
# stats for log sender client 0
setInternalCtrAlias logsender* SessionStat00 FileReader0State svalue64 none State \
  {State of the file reader thread for client 0:
    0 - Idle
    1 - semaphore wait
    2 - mutex wait
    3 - disk read
    4 - sleep
  } 3.3.7
setInternalCtrAlias logsender* SessionStat00 FileReaderBlockId svalue64 none Block \
  {Block ID of the tranlog record being read} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[8-9\]}
setInternalCtrAlias logsender* SessionStat01 FileReader0TimeInSemWait svalue64 none Milliseconds \
  {Time the file reader thread for client 0 spent waiting on a semaphore} \
{3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat02 FileReader0TimeInRead svalue64 none Milliseconds \
  {Time the file reader thread for client 0 spent performing disk reads} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat03 FileReader0TimeInSleep svalue64 none Milliseconds \
  {Time the file reader thread for client 0 spent sleeping} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat04 FileReader0NumReads svalue64 none Operations \
  {Number of disk reads performed by the file reader thread for client 0} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat05 FileReader0NumSleeps svalue64 none Operations \
  {Number of times the file reader thread for client 0 slept} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat06 FileReader0KbRead svalue64 none Kilobytes \
  {Number of kilobytes read from disk by the file reader thread for client 0} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat07 FileReader0FileId svalue64 none Id \
  {ID number of the tranlog being read by the file reader thread for client 0} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}

setInternalCtrAlias logsender* SessionStat08 DataXmit0State svalue64 none State \
  {State of the data transmit thread for client 0:
    0 - Idle
    1 - semaphore wait
    2 - mutex wait
    3 - data compression
    4 - network send
  } {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}

setInternalCtrAlias logsender* SessionStat09 DataXmit0TimeInSemWait svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 0 spent waiting on a semaphore} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat10 DataXmit0TimeInCompress svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 0 spent performing data compression} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat11 DataXmit0TimeInSend svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 0 spent sending data on the network} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat12 DataXmit0NumCompress svalue64 none Operations \
  {Number of data compressions performed by the data transmitter thread for client 0} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat13 DataXmit0NumSends svalue64 none Operations \
  {Number of network sends performed by the data transmitter thread for client 0} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}

setInternalCtrAlias logsender* SessionStat14 DataXmit0NumCompleteWrites svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 0 where
 all data was sent in a single write.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat15 DataXmit0NumIncompleteWrites svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 0 where
 all data was not sent in a single write.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat16 DataXmit0NumWritesWouldBlock svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 0 which
 required a retry because the data buffer was full.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat17 DataXmit0NumWriteErrors svalue64 none Errors \
  {Number of network writes performed by the data transmitter thread for client 0 where
an error was detected} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat18 DataXmit0NumPolls svalue64 none Operations \
  {Number of network poll operations performed by the data transmitter thread for client 0} \
{3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat19 DataXmit0NumSleeps svalue64 none Operations \
  {Number of sleeps performed by the data transmitter thread for client 0 while retrying a
  network write} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat20 DataXmit0TimeInWrite svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 0 performing network writes} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat21 DataXmit0TimeInPoll svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 0 performing poll operations} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat22 DataXmit0TimeInSleep svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 0 sleeping before retrying a write} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat23 DataXmit0KbSent svalue64 none Kilobytes \
  {Number of kilobytes of compressed data sent by the data transmitter thread for client 0} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}

# stats for log sender client 1
setInternalCtrAlias logsender* SessionStat24 FileReader1State svalue64 none State \
  {State of the file reader thread for client 1:
    0 - Idle
    1 - semaphore wait
    2 - mutex wait
    3 - disk read
    4 - sleep
  } {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat25 FileReader1TimeInSemWait svalue64 none Milliseconds \
  {Time the file reader thread for client 1 spent waiting on a semaphore} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat26 FileReader1TimeInRead svalue64 none Milliseconds \
  {Time the file reader thread for client 1 spent performing disk reads} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat27 FileReader1TimeInSleep svalue64 none Milliseconds \
  {Time the file reader thread for client 1 spent sleeping} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat28 FileReader1NumReads svalue64 none Operations \
  {Number of disk reads performed by the file reader thread for client 1} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat29 FileReader1NumSleeps svalue64 none Operations \
  {Number of times the file reader thread for client 1 slept} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat30 FileReader1KbRead svalue64 none Kilobytes \
  {Number of kilobytes read from disk by the file reader thread for client 1} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat31 FileReader1FileId svalue64 none Id \
  {ID number of the tranlog being read by the file reader thread for client 1} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat32 DataXmit1State svalue64 none State \
  {State of the data transmit thread for client 1:
    0 - Idle
    1 - semaphore wait
    2 - mutex wait
    3 - data compression
    4 - network send
  } {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat33 DataXmit1TimeInSemWait svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 1 spent waiting on a semaphore} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat34 DataXmit1TimeInCompress svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 1 spent performing data compression} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat35 DataXmit1TimeInSend svalue64 none Milliseconds \
  {Time the data trasmitter thread for client 1 spent sending data on the network} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat36 DataXmit1NumCompress svalue64 none Operations \
  {Number of data compressions performed by the data transmitter thread for client 1} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat37 DataXmit1NumSends svalue64 none Operations \
  {Number of network sends performed by the data transmitter thread for client 1} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat38 DataXmit1NumCompleteWrites svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 1 where
 all data was sent in a single write.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat39 DataXmit1NumIncompleteWrites svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 1 where
 all data was not sent in a single write.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat40 DataXmit1NumWritesWouldBlock svalue64 none Operations \
  {Number of network writes performed by the data transmitter thread for client 1 which
 required a retry because the data buffer was full.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat41 DataXmit1NumWriteErrors svalue64 none Errors \
  {Number of network writes performed by the data transmitter thread for client 1 where
an error was detected} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat42 DataXmit1NumPolls svalue64 none Operations \
  {Number of network poll operations performed by the data transmitter thread for client 1} \
{3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat43 DataXmit1NumSleeps svalue64 none Operations \
  {Number of sleeps performed by the data transmitter thread for client 1 while retrying a
  network write} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat44 DataXmit1TimeInWrite svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 1 performing network writes} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat45 DataXmit1TimeInPoll svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 1 performing poll operations} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat46 DataXmit1TimeInSleep svalue64 none Milliseconds \
  {Number of milliseconds spent by the data transmitter thread for client 1 sleeping before retrying a write} \
  {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logsender* SessionStat47 DataXmit1KbSent svalue64 none Kilobytes \
  {Number of kilobytes of compressed data sent by the data transmitter thread for client 1} \
  {3.\[5-9\].* 3.4.* 3.3.\[7-9\]}

# Log Receiver
setInternalCtrAlias logreceiver* SessionStat00 FileWriterState svalue64 none State \
  {State of the File Writer Thread:
    0 - Idle
    1 - Semaphore wait
    2 - Mutex wait
    3 - Write to disk
    4 - Flush to disk (fsync)
  } {3.\[5-9\].* 3.4.* 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat01 FileWriterTimeInSemWait svalue64 none Milliseconds \
  {Time the file writer thread spent waiting on a semaphore} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat02 FileWriterTimeInWrite svalue64 none Milliseconds \
  {Time the file writer thread spent performing writes to disk} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat03 FileWriterTimeInFlush svalue64 none Milliseconds \
  {Time the file writer thread spent performing flushes to disk (fsync)} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat04 FileWriterNumWrites svalue64 none Operations \
  {Number of disk writes performed by the file writer thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat05 FileWriterNumFlushes svalue64 none Operations \
  {Number of disk flushes (fsync) performed by the file writer thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat06 FileWriterKbWritten svalue64 none Kilobytes \
  {Number of kilobytes of data written to disk by the file writer thread} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat07 FileWriterFileId svalue64 none FileID \
  {ID of the tranlog being written to by the file writer thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat08 DataRecvState svalue64 none State \
  {State of the Data Receiver Thread:
    0 - Idle
    1 - Semaphore wait
    2 - Mutex wait
    3 - Read from network
    4 - Data validation
  } {3.\[5-9\].* 3.4.* 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat09 DataRecvTimeInSemWait svalue64 none Milliseconds \
  {Time the data receiver thread spent waiting on a semaphore} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat10 DataRecvTimeInRead svalue64 none Milliseconds \
  {Time the data receiver thread spent reading data from the network} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat11 DataRecvTimeInValidate svalue64 none Milliseconds \
  {Time the data receiver thread spent validating data received from its peer} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat12 DataRecvNumReads svalue64 none Operations \
  {Number of reads performed by the data receiver thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat13 DataRecvNumValidates svalue64 none Operations \
  {Number of data validations performed by the data receiver thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat14 DataRecvNumSocketReads svalue64 none Operations \
  {Number of socket reads performed by the data receiver thread.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat15 DataRecvNumSocketReadsWouldBlock svalue64 none Operations \
  {Number of socket reads performed by the data receiver thread that required a retry.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat16 DataRecvNumSocketReadsError svalue64 none Operations \
  {Number of socket reads performed by the data receiver thread indicated an error condition.} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat17 DataRecvNumSocketPolls svalue64 none Operations \
  {Number of socket polls performed by the data receiver thread} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat18 DataRecvNumSleeps svalue64 none Operations \
  {Number of times the data receiver thread went to sleep before retrying a read} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat19 DataRecvTimeInSocketRead svalue64 none Milliseconds \
  {Time the data receiver thread spent in socket reads} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat20 DataRecvTimeInSocketPoll svalue64 none Milliseconds \
  {Time the data receiver thread spent in the poll call} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat21 DataRecvTimeInSleep svalue64 none Milliseconds \
  {Time the data receiver thread spent sleeping before retrying a socket read} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat22 DataRecvSocketKbRead svalue64 none Kilobytes \
  {Number of kilobytes of data from the peer read from the socket} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[7-9\]}
setInternalCtrAlias logreceiver* SessionStat23 FileWriterBlockId svalue64 none Block \
  {Block Id of the tranlog record being processed by the file writer thread} {3.\[5-9\].* 3.4.\[2-9\] 3.3.\[8-9\]}


# listInstances
setInternalCtrAliasTemplateType ListInstances

setInternalCtrAlias ListInstances SessionStat00 OpId svalue64 none ID \
  {Operation ID
    101 - List instances to hidden set
    102 - List instances to files
    103 - List instances in page order
    104 - List objects in security policy
    105 - List objects in security policy to hidden set
    106 - List objects in security policy to files
    107 - Find Objects Larger Than
    108 - Count Instances
    109 - Object Inventory (in memory only)
    110 - Object Inventory repository
    111 - Object Inventory to hidden set
    112 - Object Inventory in page order
    113 - List references
    114 - List references to instances of classes
    115 - Find reference Paths
    116 - All instances
    117 - All references
    118 - All references to instances of classes
    119 - All objects in object security policy
    120 - All objects larger than
    121 - Object audit
  } {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ListInstances SessionStat01 ScanPhase svalue64 none Phase \
  {Phase of the scan:
    0  - inactive
    2  - scan object table
    4  - scan shadow pages
    5  - scan data pages } {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ListInstances SessionStat02 OtPagesRead svalue64 none Pages \
  {Number of object table pages read} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ListInstances SessionStat03 DpMgrPages counter64 none Pages \
  {Number of pages currently in the DP manager list} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ListInstances SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[5-9\].* 3.4* 3.3* 3.2*}
setInternalCtrAlias ListInstances SessionStat05 TotalObjectsFound counter64 none Pages \
  {Number of objects found during the scan} {3.\[5-9\].* 3.4* 3.3* 3.2*}

################################################################################
# 6.x (32 bit)
################################################################################
setInternalCtrAlias PageManager* SessionStat00 PollCount counter none Operations \
  {Number of times PageMager called the poll function} {6.*}
setInternalCtrAlias PageManager* SessionStat01 SleepCount counter none Milliseconds \
  {Number of milliseconds PageManager spent sleeping} {6.*}
setInternalCtrAlias PageManager* SessionStat02 IsSleeping uvalue none Boolean \
  {A boolean indicating if PageManager is currently sleeping} {6.*}
setInternalCtrAlias PageManager* SessionStat03 LoopCount counter none Operations \
  {Number of times PageMager execute its main service loop} {6.*}
setInternalCtrAlias PageManager* SessionStat04 RemoteCacheErrorCount counter none Errors \
  {Number of times PageMager encountered an error when communicating with a remote shared page cache} {6.*}
setInternalCtrAlias PageManager* SessionStat05 State counter none State \
  {Current state of the Page Manger:
    1 - NetPoll
    2 - Finish remote cache 1
    3 - Finish remote cache 2
    4 - Finish remote cache 3
    5 - Finish remote cache 4
    6 - Get pages to remove
    7 - Send pages to remove
    8 - Wait to send pages
    9 - Wait for responses
   10 - Read responses
   11 - Handle cache timeout
   12 - Start remote cache 1
   13 - Start remote cache 2
   14 - Start remote cache 3
   15 - Start remote cache 4
   16 - Start remote cache 5
   17 - Service lost OT queue
   18 - Service pid query queue
   19 - Service kill queue
   20 - Report dead remote caches
   21 - Sleep} {6.*}

setInternalCtrAlias PageManager* SessionStat06 RetryCount counter none Operations \
  {Number of times PageMager retried removing one or more pages from a
    remote shared page cache.} {6.*}
setInternalCtrAlias PageManager* SessionStat07 RetryPageCount counter none Pages \
  {Number of pages PageMager retried removing from a remote shared page cache.} {6.*}
setInternalCtrAlias PageManager* SessionStat08 LastSendTime uvalue none Milliseconds \
  {Number of milliseconds PageMager spent to sending the most recent list of pages to
    remote shared page caches} {6.*}
setInternalCtrAlias PageManager* SessionStat09 ClientsTimedOutInSendCount counter none Clients \
  {Number of remote shared page caches for which the page manager encountered a timeout error
    while attempting to send data.} {6.*}
setInternalCtrAlias PageManager* SessionStat10 SendTimeOutCount counter none TimeOuts \
  {Number of times the page manager encountered a timeout error while
    attempting to send data.} {6.*}
setInternalCtrAlias PageManager* SessionStat11 ClientsTimedOutInRecvCount counter none Clients \
  {Number of remote shared page caches for which the page manager encountered a timeout error
    while attempting to receive data.} {6.*}
setInternalCtrAlias PageManager* SessionStat12 RecvTimeOutCount counter none TimeOuts \
  {Number of times the page manager encountered a timeout error while
    attempting to receive data.} {6.*}
setInternalCtrAlias PageManager* SessionStat13 SlowSendClientCount counter none Clients \
  {Number of remote shared page caches for which the page manager encountered slow performance
    while attempting to send data.} {6.*}
setInternalCtrAlias PageManager* SessionStat14 SlowSendCount counter none TimeOuts \
  {Number of times the page manager encountered slow performance while sending data to a client} {6.*}
setInternalCtrAlias PageManager* SessionStat15 SlowRecvClientCount counter none Clients \
  {Number of remote shared page caches for which the page manager encountered slow
    performance while attempting to receive data.} {6.*}
setInternalCtrAlias PageManager* SessionStat16 SlowRecvCount counter none TimeOuts \
  {Number of times the page manager encountered slow performance while
    receiving data from a client} {6.*}
setInternalCtrAlias PageManager* SessionStat17 ResponsesPending uvalue none Responses \
  {Number of remote shared page caches which have yet to respond to the most recent
    request from the PageManager} {6.*}
setInternalCtrAlias PageManager* SessionStat18 TimeInNonblockingSend counter none Milliseconds \
  {Number of milliseconds the PageMager spent in nonblocking network sends} {6.*}
setInternalCtrAlias PageManager* SessionStat19 TimeInNonblockingRecv counter none Milliseconds \
  {Number of milliseconds the PageMager spent in nonblocking network receives} {6.*}
setInternalCtrAlias PageManager* SessionStat20 TimeWaitingToSend counter none Milliseconds \
  {Number of milliseconds the PageMager spent waiting for a socket to be ready to send data} {6.*}
setInternalCtrAlias PageManager* SessionStat21 TimeWaitingToRecv counter none Milliseconds \
  {Number of milliseconds the PageMager spent waiting for a socket to be ready to receive data} {6.*}

# GcGems
setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat00 PrepareToGetTokenTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit preparing to request the commit token} {6.*}
setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat01 GetTokenTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit preparing waiting for the commit token} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat02 LoadSharedOtRootTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit loading the object table root} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat03 ResolveConflictsTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit resolving conflicts} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat04 BuildNewPagesListTIme counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit building the list of new pages for the commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat05 CountNewDataPagesTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit counting the number of new data pages} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat06 RemoveReclaimedOopsTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit removing reclaimed oops from the object table} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat07 ObjectTableAugmentTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit augmenting the shared object table} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat08  ReinitOtCacheTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit reinitializing the shared OT cache} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat09  BuildNewCommitRecordTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit building the new commit record} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat10  BuildNewPagesTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit building the list of new pages} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat11  CompressCommitRecordTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit compressing the new commit record} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat12  StoneTranCommitTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit waiting for stone to complete the commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat13  PostCommitTime counter none Milliseconds \
  {Time in milliseconds the GcGem spent in the most recent commit performing post commit tasks} {6.*}
setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat14  PagesReadsInOtAugment uvalue none Pages \
  {Number of pages read by GcGem while performing the object table augment operation during the most recent commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat40 ResolveWWConflictsCount counter none Operations \
  {Number of times the GcGem resolved write-write conflicts during commit} {6.*}
setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat41 ObjectsAbortedCount counter none Objects \
  {Number of objects selectively aborted to resolve write-write conflicts during commit} {6.*}
setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat42 ResolveValidOopsWsuConflictsCount counter none Operations \
  {Number of times the GcGem resolved conflicts between valid objects and the write set union during commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat43 ObjectsRemovedAllValid counter none Objects \
  {Number of objects removed from the all valid list to resolve write-write conflicts during commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat44 PagesRemovedAllValid counter none Pages \
  {Number of pages removed from the all valid list to resolve write-write conflicts during commit} {6.*}

setInternalCtrAlias {Gc.RCL.* GcGem*} SessionStat47 AllValidPages counter none Pages \
  {Number of pages processed by GcGem which contained no shadow objects} {6.*}

# GcGem and Epoch GC mark/sweep
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat15 MarkSweepState uvalue none State \
  {State of the mark/sweep algorithm:
     0 - Inactive
     1 - Mark/sweep
     2 - Abort
     3 - DeterminePagesToSweep
     4 - DeterminePagesToSweep BmDiff 1
     5 - DeterminePagesToSweep BmDiff 2
     6 - DeterminePagesToSweep OtLookup
     7 - DeterminePagesToSweep sort page IDs
     8 - Locate Sequential Pages
     9 - Locate Sequential Pages find set pages
    10 - Locate Sequential Pages locate in cache 1
    11 - Locate Sequential Pages locate in cache 2
    12 - Locate Sequential Pages read
    13 - Locate Sequential Pages set from sorted
    14 - Sweep data pages
    15 - Sweep data pages 1st pass
    16 - Sweep data pages OT lookup
    17 - Sweep new marked
    18 - Sweep new marked with limit set
    19 - Process leaf objects} {6.*}

setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat16 EpochNewObjs uvalue none Objects \
  {Number of new objects in the epoch GC sweep} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat17 EpochWrittenObjs uvalue none Objects \
  {Number of written objects in the epoch GC sweep} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat18 EpochDepMapObjs uvalue none Objects \
  {Number of dependency map objects in the epoch GC sweep} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat19 SweepNewMarkedCount counter none Operations \
  {Number of sweep new marked operatinos} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat20 DeterminePagesToSweepCount counter none Operations \
  {Number of determine pages to sweep operatinos} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat21 DeterminePagesToSweepObjectsCount \
  counter none Objects \
  {Number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat22 DeterminePagesToSweepObjectsTotal \
  counter none Objects \
  {Total number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat23 DeterminePagesToSweepObjectsMax \
  counter none Objects \
  {Maximum number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat24 DeterminePagesToSweepPagesCount \
  counter none Pages \
  {Number of pages determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat25 DeterminePagesToSweepPagesTotal \
  counter none Pages \
  {Total number of pages determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat26 DeterminePagesToSweepPagesMax \
  counter none Pages \
  {Maximum number of pages determine pages to sweep found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat27 PagesInBuffer uvalue none Pages \
  {Number of pages in the buffer} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat28 PagesSweptAllValid uvalue none Pages \
  {Number of pages swept which contained no shadow objects} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat29 PagesSweptShadowed uvalue none Pages \
  {Number of swept which continaed one or more shadow objects} {6.*}

setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat30 DeterminePagesToSweepTime \
  uvalue none Milliseconds \
  {Time spent in determine pages to sweep} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat31 SweepAllValidPagesTime \
  uvalue none Milliseconds \
  {Time spent sweeping all valid pages} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat32 LocateSequentialPagesTime \
  uvalue none Milliseconds \
  {Time spent in locate sequential pages} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat33 SweepNewMarkedTime \
  uvalue none Milliseconds \
  {Time spent in sweep new marked} {6.*}

setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat34 HaskMapKProbes \
  counter none KProbes \
  {Number of hash map probes in thousands.} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat35 HaskMapKCollisions \
  counter none KCollisions \
  {Number of hash map collisions in thousands.} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat36 HaskMapEntries \
  counter none Entries \
  {Number of hash map entries} {6.*}

setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat37 PageBufferSize \
  counter none Pages \
  {Number of page buffer in pages} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat38 LeafObjectsAddedToSwept counter none Objects \
  {Number of leaf objects added to the swept set} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat39 LeafObjectsFound counter none Objects \
  {Number of leaf objects found} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat40  PageBufferHits counter none Hits \
  {Number of hits on the page buffer} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat41 PageBufferMisses counter none Misses \
  {Number of misses on the page buffer} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat42 PageBufferReads counter none Entries \
  {Number of reads into the page buffer} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat43 SweepDataPages1stPassTime \
  counter none Milliseconds \
  {Time spent in sweep data page first pass} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat44 SweepDataPagesOtLookupTime \
counter none Milliseconds \
  {Time spent in sweep data page OT lookup} {6.*}
setInternalCtrAlias {Gc.EPC.* GcGem*} SessionStat45 RebuildAllSymbolsCount counter none Operations \
  {Number of times the GcGem rebuilt the list of objects in AllSymbols} {6.*}
setInternalCtrAlias {MarkForCollection} SessionStat45 SweepDataPages2ndPassTime  counter none Operations \
  {Time spent in sweep data page second pass} {6.*}
setInternalCtrAlias {Gc.EPC.* MarkForCollection GcGem*} SessionStat46 AddNewMarkedLeafsToSweptTime \
  counter none Milliseconds \
  {Time spent adding new marked leaf objects to the swept objects set} {6.*}

# MT markForCollection

setInternalCtrAlias MarkForCollectionMt SessionStat00 MarkSweepState uvalue none State \
  {State of the mark/sweep algorithm:
     0 - Inactive
     1 - Mark/sweep
     2 - Abort
     3 - DeterminePagesToSweep
     4 - DeterminePagesToSweep BmDiff 1
     5 - DeterminePagesToSweep BmDiff 2
     6 - DeterminePagesToSweep OtLookup
     7 - DeterminePagesToSweep sort page IDs
     8 - Sweep objects in pages: load buffers
     9 - Sweep objects in pages: wait for read
    10 - Sweep data pages
    11 - Sweep data pages with limit set
    12 - Sweep data pages OT lookup
    13 - Sweep new marked
    14 - After sweep new marked
    19 - Process leaf objects} {6.*}

setInternalCtrAlias MarkForCollectionMt SessionStat01 SweepNewMarkedCount counter none Operations \
  {Number of sweep new marked operatinos} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat02 DeterminePagesToSweepCount counter none Operations \
  {Number of determine pages to sweep operatinos} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat03 DeterminePagesToSweepObjectsCount \
  counter none Objects {Number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat04 DeterminePagesToSweepObjectsTotal \
  counter none Objects {Total number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat05 DeterminePagesToSweepObjectsMax \
  counter none Objects {Maximum number of objects determine pages to sweep found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat06 DeterminePagesToSweepPagesCount \
  counter none Pages {Number of pages determine pages to sweep found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat07 DeterminePagesToSweepPagesTotal \
  counter none Pages {Total number of pages determine pages to sweep found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat08 DeterminePagesToSweepPagesMax \
  counter none Pages {Maximum number of pages determine pages to sweep found} {6.*}

setInternalCtrAlias MarkForCollectionMt SessionStat09 PageIdsInBuffer0 \
  counter none Pages {Number of page IDs in buffer 0} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat10 PageIdsInFreeListBuffer0 \
  counter none Pages {Number of free slots in page ID buffer 0} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat11 PageIdsReadsDoneBuffer0 \
  counter none Pages {Number of page IDs in the reads done list for buffer 0} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat12 PageIdsSweepDoneBuffer0 \
  counter none Pages {Number of page IDs in the sweep done list for buffer 0} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat13 PageIdsPendingSweepBuffer0 \
  counter none Pages {Number of page IDs in pending sweep for buffer 0} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat14 PageIdsSweptBuffer0 \
  counter none Pages {Number of page IDs swept in buffer 0} {6.*}


setInternalCtrAlias MarkForCollectionMt SessionStat15 PageIdsInBuffer1 \
  counter none Pages {Number of page IDs in buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat16 PageIdsInFreeListBuffer1 \
  counter none Pages {Number of free slots in page ID buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat17 PageIdsReadsDoneBuffer1 \
  counter none Pages {Number of page IDs in the reads done list for buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat18 PageIdsSweepDoneBuffer1 \
  counter none Pages {Number of page IDs in the sweep done list for buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat19 PageIdsPendingSweepBuffer1 \
  counter none Pages {Number of page IDs in pending sweep for buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat20 PageIdsSweptBuffer1 \
  counter none Pages {Number of page IDs swept in buffer 1} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat21 ReadThdsPagesRead \
  counter none Pages {Number of page read by the reader threads} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat22 ReadThdsBlocked \
  counter none Threads {Number of reader threads blocked by a semaphore} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat23 ReadThdsBlockedFreePageBuffer \
  counter none Threads {Number of reader threads blocked on the free page buffer} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat24 ReadThdsBlockedPageIdQueue \
  counter none Threads {Number of reader threads blocked on the page ID queue} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat25 ReadThdsInRead \
  counter none Threads {Number of reader threads performing reads} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat26 TimeInDeterminePagesToSweep \
  counter none Milliseconds {Time spent in determine pages to sweep} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat27 TimeWaitingForReads \
  counter none Milliseconds {Time spent waiting for reads to finish} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat28 TimeSweepNewMarked \
  counter none Milliseconds {Time spent in sweep new marked} {6.*}

setInternalCtrAlias MarkForCollectionMt SessionStat29 HaskMapKProbes \
  counter none KProbes {Number of hash map probes in thousands.} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat30 HaskMapKCollisions \
  counter none KCollisions {Number of hash map collisions in thousands.} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat31 HaskMapEntries \
  counter none Entries {Number of hash map entries} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat32 PageBufferSize \
  counter none Pages {Size of the page buffer} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat33 LeafObjectsAddedToSwept counter none Objects \
  {Number of leaf objects added to the swept set} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat34 LeafObjectsFound counter none Objects \
  {Number of leaf objects found} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat35 SweepDataPageCount counter none Pages \
  {Number of pages processed by sweep data pages} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat36 TimeInSweepDataPages1stPass \
  counter none Milliseconds {Time spent in sweep data pages 1st pass} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat37 TimeInSweepDataPagesOtLookup \
  counter none Milliseconds {Time spent in sweep data object table lookup} {6.*}
setInternalCtrAlias MarkForCollectionMt SessionStat38 TimeInSweepDataPages2ndPass \
  counter none Milliseconds {Time spent in sweep data pages 2nd pass} {6.*}

# MarkForCollectinMt (6.x only)
setInternalCtrAliasTemplateType MarkForCollectionMt

################################################################################
# 2.4.x (64 bit)
################################################################################
# FastFdc  2.4.x only
setInternalCtrAliasTemplateType FastFdc

setInternalCtrAlias FastFdc SessionStat00 CurrentExtentId \
  svalue64 none ExtentId {ID of the extent currently being scanned} {2.4*}
setInternalCtrAlias FastFdc SessionStat01 CurrentRecordId \
  svalue64 none RecordId {ID of the record currently being scanned} {2.4*}
setInternalCtrAlias FastFdc SessionStat02 DataPageHits \
  svalue64 none Hits {Number of data pages found in the shared cache} {2.4*}
setInternalCtrAlias FastFdc SessionStat03 DataPageMisses \
  svalue64 none Misses {Number of data pages not found in the shared cache} {2.4*}
setInternalCtrAlias FastFdc SessionStat04 NumPagesToSweep svalue64 none Pages \
  {Number of pages in the pages to sweep list} {2.4*}
setInternalCtrAlias FastFdc SessionStat05 PagesToWarmSize svalue64 none Pages \
  {Number of pages in the pages to warm list} {2.4*}
setInternalCtrAlias FastFdc SessionStat06 FdcState svalue64 none State \
  {State of the FDC sweep:
    0 - Inactive
    1 - Sweep marked not swept
    2 - Waiting for warmers to read
    3 - Determine pages to sweep
    4 - Waiting for warmers to sync
    5 - Object table lookup
    6 - Sweep new marked
    7 - Process data page
    8 - Unpin pages
    9 - Object table lookup for next pass
   10 - Determine pages to sweep for next pass} {2.4*}
setInternalCtrAlias FastFdc SessionStat07 UnreachableObjects svalue64 none Objects \
  {Number of unreachable objects found} {2.4*}
setInternalCtrAlias FastFdc SessionStat08 PagePreemptionsFailed svalue64 none Pages \
  {Number of pages which could not be removed from the cache} {2.4*}
setInternalCtrAlias FastFdc SessionStat09 MarkedNotSweptSize svalue64 none Objects \
  {Number of marked not swept objects} {2.4*}
setInternalCtrAlias FastFdc SessionStat10 SweepNewMarkedObjsCount svalue64 none Objects \
  {Number of objects swept by the most recent sweep new marked operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat11 SweepNewMarkedObjsTotal svalue64 none Objects \
  {Total objects swept by the sweep new marked operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat12 ObjectsInBuffer svalue64 none Objects \
  {Number of objects currently in the buffer} {2.4*}
setInternalCtrAlias FastFdc SessionStat13 ProgressCount svalue64 none Objects \
  {Number of objects swept so far} {2.4*}
 setInternalCtrAlias FastFdc SessionStat14 HashMapEntries counter64 none Entries \
  {Number of hash map entries} {2.4*}
setInternalCtrAlias FastFdc SessionStat15 HashMapProbes counter64 none Operations \
  {Number of hash map probes} {2.4*}
setInternalCtrAlias FastFdc SessionStat16 HashMapCollisions counter64 none Operations \
  {Number of hash map collisions} {2.4*}
setInternalCtrAlias FastFdc SessionStat17 PageIdsToWarmSize0 counter64 none PageIDs \
  {Number of page IDs to warm in buffer 0} {2.4*}
setInternalCtrAlias FastFdc SessionStat18 PageIdsToWarmSize1 counter64 none PageIDs \
  {Number of page IDs to warm in buffer 1} {2.4*}
setInternalCtrAlias FastFdc SessionStat19 ByteObjectsSweptCount counter64 none Objects \
  {Number of byte objects swept} {2.4*}
setInternalCtrAlias FastFdc SessionStat20 LargeRootObjectsSweptCount counter64 none Objects \
  {Number of large object roots swept} {2.4*}
setInternalCtrAlias FastFdc SessionStat21 LeafObjectsLastPassCount counter64 none Objects \
  {Number of leaf objects swept in the last pass} {2.4*}
setInternalCtrAlias FastFdc SessionStat22 LeafObjectsAddedToSweptCount counter64 none Objects \
  {Number of leaf objects added to the swept set} {2.4*}
setInternalCtrAlias FastFdc SessionStat23 LocateAndSweepPagesLoopCount counter64 none Objects \
  {Number of times the locate and sweep pages loop has executed} {2.4*}
setInternalCtrAlias FastFdc SessionStat24 NewLeafObjectsSweptCount counter64 none Objects \
  {Number of newly marked leaf objects which were swept immediately} {2.4*}
setInternalCtrAlias FastFdc SessionStat25 PreemptablePagesCount counter64 none Pages \
  {Number of pages on the shared preemptable pages list} {2.4*}
setInternalCtrAlias FastFdc SessionStat26 NewMarkedObjectsInBufferCount counter64 none Objects \
  {Number of newly marked objects in the buffer} {2.4*}
setInternalCtrAlias FastFdc SessionStat27 SinglePageReadsCount counter64 none Pages \
  {Number of pages read from disk individually} {2.4*}
setInternalCtrAlias FastFdc SessionStat28 PageBufferSize counter64 none Pages \
  {Capacity of the page buffer in pages} {2.4*}
setInternalCtrAlias FastFdc SessionStat29 PagesInPageBuffer counter64 none Pages \
  {Number of pages present in the page buffer} {2.4*}
setInternalCtrAlias FastFdc SessionStat30 WaitForCacheWarmerLoopCount counter64 none Loops \
  {Number of times the wait loop was executed during the most recent readOnPage operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat31 WaitForCacheWarmerCount svalue64 none Waits \
  {Total number of times the readOnPage operation waited for a cache warmer to read a page} {2.4*}
setInternalCtrAlias FastFdc SessionStat32 PagesRemovedFromWarmersList svalue64 none Pages \
  {Total number times the readOnPage operation removed a page from the cache warmers list in order to read the page} {2.4*}
setInternalCtrAlias FastFdc SessionStat33 WaitForWarmerTimeoutCount svalue64 none Timeouts \
  {Total number times the readOnPage operation timed out waiting for the cache warmers to read a page} {2.4*}
setInternalCtrAlias FastFdc SessionStat34 TimeInBitlistFindSetBits svalue64 none Milliseconds \
  {Number of milliseconds spent in the find set bits operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat35 TimeIndoOtLookupsTotal svalue64 none Milliseconds \
  {Total number of milliseconds spent in the doOtLookups routine} {2.4*}
setInternalCtrAlias FastFdc SessionStat36 TimeInFindPagesForNextPass svalue64 none Milliseconds \
  {Number of milliseconds spent in the most recent findPagesForNextPass operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat37 TimeInFindPagesForNextPassTotal svalue64 none Milliseconds \
  {Total number of milliseconds spent in the findPagesForNextPass operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat38 PagesFoundForNextPass svalue64 none Pages \
  {Number of pags found in the most recent findPagesForNextPass operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat39 PagesFoundForNextPassTotal svalue64 none Pages \
  {Total number of pages found in the findPagesForNextPass operation} {2.4*}
setInternalCtrAlias FastFdc SessionStat40 TimeInObjectTableLookups svalue64 none Milliseconds \
  {Number of milliseconds spent in the most recent object table lookup} {2.4*}
setInternalCtrAlias FastFdc SessionStat41 ObjectTableLookupsTotal svalue64 none Operations \
  {Total number of object table lookups} {2.4*}
setInternalCtrAlias FastFdc SessionStat42 ObjectTableLookupObjectsTotal svalue64 none Objects \
  {Total number of objects looked up in the object table} {2.4*}
setInternalCtrAlias FastFdc SessionStat43 TimeInObjectTableLookupsTotal svalue64 none Milliseconds \
  {Total number of milliseconds spent in object table lookups} {2.4*}

# GcCacheWarmer (2.4.x only)
setInternalCtrAlias GcCacheWarmer* SessionStat00 LastExtentId svalue64 none ExtentId \
  {Extent ID of the last page read} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat01 LastRecordId svalue64 none RecordId \
  {Record ID of the last page read} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat02 PagesLoaded svalue64 none Pages \
  {Number of pages loaded into the cache} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat03 TimeWaitingForFreeFrames svalue64 none Milliseconds \
  {Total number of milliseconds spent waiting for free frames} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat04 TimeWaitingForPageIds svalue64 none Milliseconds \
  {Total number of milliseconds spent waiting for page IDs} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat05 TotalPagesSkipped svalue64 none Pages \
  {Total number of pages skipped by the warmer} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat06 CacheWarmingState svalue64 none State \
  {State of the cache warmer:
    0 - Running
    1 - Waiting for pages
    2 - Waiting for free frames
    3 - Waiting for abort
  } {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat07 TimeWaitingForAbort svalue64 none Milliseconds \
  {Total number of milliseconds spent waiting for the mark/sweep process to abort} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat08 SequentialReadCount svalue64 none Operations \
  {Number of times more than one page was read by a single disk read} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat09 SequentialReadPageCount svalue64 none Pages \
  {Number of pages read by sequential reads} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat09 SequentialReadPageCount svalue64 none Pages \
  {Number of pages read by sequential reads} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat10 CurrentBufferIndex svalue64 none Index \
  {Index of the active page buffer (0 or 1)} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat11 PageIdBatchSize svalue64 none PageIds \
  {Number of page IDs in the current batch} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat12 PagesReadNotLoadedCount svalue64 none Pages \
  {Number of pages that were read into a private buffer but were found to already be in the cache} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat13 SinglePageReadsCount svalue64 none Operations \
  {Number of pages that were read individually into the shared cache} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat14 PagesPerReadCount svalue64 none Pages \
  {Number of pages that were read by the most recent disk read operation} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat15 PageIdBufferSizes svalue64 none PageIds \
  {Size of the page ID buffer. Set using env var GS_CACHE_WARM_PAGE_BUF_SIZE. Default=64} {2.4*}
setInternalCtrAlias GcCacheWarmer* SessionStat16 MaximumPageIdGap svalue64 none PageIds \
  {Maximum gap between page IDs where the warmer will do a sequential read:
    1 - no gaps allowed
    2 - maximum gap of 1 page
    3 - maximum gap of 2 pages
  Set using the GS_CACHE_WARM_MAX_PAGE_ID_GAP env var. Default=2} {2.4*}


# PageManager gem
  setInternalCtrAlias PageManager* SessionStat00 NetPollCount svalue64 none Operations \
  {Number of times poll was called} {2.4*}
  setInternalCtrAlias PageManager* SessionStat01 TotalSleepMs svalue64 none Milliseconds \
  {Total number of milliseconds spent sleeping} {2.4*}
  setInternalCtrAlias PageManager* SessionStat02 Sleeping svalue64 none Boolean \
  {Boolean indicating if PageManager is currently sleeping.} {2.4*}
  setInternalCtrAlias PageManager* SessionStat03 LoopCount counter64 none Loops \
  {Number of times PageManager has executed its main service loop.} {2.4*}

# AdminGc Gem and MFC
 setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat00 MarkSweepState svalue64 none State \
  { 0 - inactive
    1 - mark/sweep
    2 - abort
    3 - determine pages to sweep
    4 - determine pages to sweep difference 1
    5 - determine pages to sweep difference 2
    6 - determine pages to sweep OT lookup
    7 - determine pages to sweep page ID sort
    8 - locate sequential pages
    9 - locate sequential pages find set pages
   10 - locate sequential pages locate in cache 1
   11 - locate sequential pages locate in cache 2
   12 - locate sequential pages sequential read
   13 - locate sequential pages set from sorted
   14 - sweep data pages
   15 - not used
   16 - sweep data pages OT lookup
   17 - sweep new marked
   18 - sweep new marked with limit set 
  } {2.4*}

   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat01  EpochNewObjs svalue64 none Objects \
  {Number of new objects to be scanned by epoch GC} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat02  EpochWrittenObjs svalue64 none Objects \
  {Number of written objects to be scanned by epoch GC} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat03  EpochDepMapObjs svalue64 none Objects \
  {Number of dependency map objects to be scanned by epoch GC} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat04  SweepNewMarkedCount svalue64 none Operations \
  {Number of times sweepNewMarked was called} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat05  DeterminePagesToSweepCount svalue64 none Operations \
  {Number of times determinePagesToSweep was called} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat06  DeterminePagesToSweepObjs svalue64 none Objects \
  {Number of objects found by determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat07 DeterminePagesToSweepTotalObjs svalue64 none Objects \
  {Total number of objects found by determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat08 DeterminePagesToSweepMaxObjs svalue64 none Objects \
  {Maximum number of objects found by determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat09 DeterminePagesToSweepPages svalue64 none Pages \
  {Number of pages found by determinePagesToSweep } {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat10 DeterminePagesToSweepTotalPages svalue64 none Pages \
  {Total number of pages found by determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat11 DeterminePagesToSweepMaxPages svalue64 none Pages \
  {Maximum number of pages found by determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat12 PagesInBuffer svalue64 none Pages \
  {Number of pages in the sequential read buffer } {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat13 PagesSweptAllValid svalue64 none Pages \
  {Number of all valid pages swept} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat14 PagesSweptShadowed svalue64 none Pages \
  {Number of shadow pages swept} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat15 DeterminePagesToSweepTime svalue64 none Milliseconds \
  {Number of milliseconds spent in determinePagesToSweep} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat16 SweepDataPagesTime svalue64 none Milliseconds \
  {Number of milliseconds spent in sweepDataPages} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat17 PageLocateSequentialTime svalue64 none Milliseconds \
  {Number of milliseconds spent in PageLocateSequential} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat18 SweepNewMarkedTime svalue64 none Milliseconds \
  {Number of milliseconds spent in sweepNewMarked } {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat19 HashMapProbes counter64 none Operations \
  {Number of hash table probes} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat20 HashMapCollisions counter64 none Operations \
  {Number of hash table collisions} {2.4*}
   setInternalCtrAlias {GcAdmin* MarkForCollection} SessionStat21 HashMapEntries counter64 none Entries \
  {Number of hash table entries} {2.4*}
    setInternalCtrAlias GcAdmin* SessionStat22 LockedObjsAddedToWsu svalue64 none Objects \
  {Number of locked objects added to the write set union} {2.4*}
    setInternalCtrAlias GcAdmin* SessionStat23  DepMapObjsAddedToWsu svalue64 none Objects \
  {Number of dependency map objects added to the write set union} {2.4*}

# reclaim gem
  setInternalCtrAlias GcReclaim* SessionStat00 WriteLogRecTime svalue64 none Milliseconds \
    {Time spent writing the tranlog record for the reclaim commit} {2.4*}
  setInternalCtrAlias GcReclaim* SessionStat01 SortDeltasTime svalue64 none Milliseconds \
    {Time spent sorting OT deltas} {2.4*}
  setInternalCtrAlias GcReclaim* SessionStat02 FlushDataPagesTime svalue64 none Milliseconds \
  {Time spent flushing data pages} {2.4*}
  setInternalCtrAlias GcReclaim* SessionStat03 GetCommitTokenTime svalue64 none Milliseconds \
  {Time spent getting the commit token} {2.4*}
  setInternalCtrAlias GcReclaim* SessionStat04 EmptyDeltasPrepareTime svalue64 none Milliseconds \
  {Time spent preparing to empty OT deltas} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat05 EmptyDeltasTime svalue64 none Milliseconds \
  {Time spent emptying OT deltas} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat06 BuildPersistPagesTime svalue64 none Milliseconds \
  {Time spent building the list of persistent pages} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat07 StnCallTranCommitTime svalue64 none Milliseconds \
  {Time spent in StnCallTranCommit} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat08 PostCommitTime svalue64 none Milliseconds \
  {Time spent in post commit tasks} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat09 PagesReadDuringCommit svalue64 none Pages \
  {Number of pages read during commit} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat10 TotalOopsMoved svalue64 none Oops \
  {Total number of live objects moved} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat11 TotalOopsReclaimed svalue64 none Oops \
  {Total number of objects reclaimed} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat12 TotalOtDeltas svalue64 none Deltas \
  {Total number of OT deltas (moved + reclaimed)} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat13 TotalScavengedPages svalue64 none Pages \
  {Total number of scavenged pages} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat14 TotalNewDataPages svalue64 none Pages \
  {Total number of new data pages} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat15 NumOopsMoved svalue64 none Oops \
  {Number of live objects moved this transaction} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat16 NumOopsReclaimed svalue64 none Oops \
  {Number of objects reclaimed this transaction} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat17 NumOtDeltas svalue64 none Deltas \
  {Number of OT deltas (moved + reclaimed) this transaction} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat18 NumScavengedPages svalue64 none Pages \
  {Number of scavenged pages this transaction} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat19 NumNewDataPages svalue64 none Pages \
  {Number of new data pages this transaction} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat20 NewDataPagesDisposed svalue64 none Pages \
  {Number of new data pages disposed due to conflict resolution} {2.4*}
# 21 not used
 setInternalCtrAlias GcReclaim* SessionStat22 DeadObjsReclaimedCommitThreshold svalue64 none Objects \
  {Value of deadObjsReclaimedCommitThreshold config setting} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat23 ObjsMovedPerCommitThreshold svalue64 none Objects \
  {Value of objsMovedPerCommitThreshold config setting} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat24 TempPagesCount svalue64 none Pages \
  {Number of temp pages owned by this reclaim session} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat25 StnTempPagesCount svalue64 none Objects \
  {Number of temp pages stone has assigned to this reclaim session} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat26 GetMoreDeadNotInCommitCount svalue64 none Objects \
  {Number of times more dead objects were requested from stone while not in commit} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat27 GetMoreDeadInCommitCount svalue64 none Operations \
  {Number of times more dead objects were requested from stone post commit} {2.4*}
 setInternalCtrAlias GcReclaim* SessionStat28 DeadNotReclaimedCopySize svalue64 none Objects \
  {Size of the deadNotReclaimed bitmap copy} {2.4*}
# 29 - 36 not used
 setInternalCtrAlias GcReclaim* SessionStat37 ReclaimState svalue64 none State \
  { 0 - sleep no work
    1 - do reclaim
    2 - get shadow pages
    3 - get dead pages
    4 - OT lookup dead
    5 - read data pages
    6 - process data page
    7 - OT lookup
    8 - reclaim commit
    9 - reclaim init
   10 - get dead objects copy
   11 - get config
   12 - sleep between reclaim
   13 - sleep cache too dirty 
   14 - sleep for HW page
   15 - sleep low free space
  } {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat38 WaitForHwPageCount svalue64 none Operations \
  {Number of times reclaim was suspended for the high water page} {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat39 WaitForDirtyCacheCount svalue64 none Operations \
  {Number of times reclaim was suspended because the cache was too dirty} {2.4.6* 2.4.7* 2.4.8*}
# 40 not used
 setInternalCtrAlias GcReclaim* SessionStat41 SignalGcHwPageCount svalue64 none Operations \
  {Number of times a high water page signal was received.} {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat42 SleepNoWorkCount svalue64 none Operations \
  {Number of times the reclaim gem went to sleep due to no work} {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat43 ReclaimHwPageState svalue64 none State \
  { 0 - no reclaim (delayReclaimMaxPageId <  lowestPageId)
    1 - some reclaim (delayReclaimMaxPageId >= lowestPageId && delayReclaimMaxPageId <= highestPageId)
    2 - any reclaim (delayReclaimMaxPageId >  higestPageId)
  } {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat44 WaitForFreeSpaceCount svalue64 none Operations \
  {Number of times reclaim was suspended due to low free space} {2.4.6* 2.4.7* 2.4.8*}
 setInternalCtrAlias GcReclaim* SessionStat47 AlertCount counter64 none Alerts \
  {Number of Alerts received from the stone} {2.4*}

# 3.7.0 ReclaimGem main thread
  setInternalCtrAlias GcReclaim* SessionStat00  MtOpId svalue64 none OpId \
    {ID of the current multi threaded operation, in reclaim gem always OP_RECLAIM} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat01 ReclaimPhase counter64 none Value \
    {Current reclaim phase -
       RECL_IDLE            - sleeping             
       RECL_DEAD_OOPS_TO_PAGES - lookup dead in ot, add to dpMgr pages to reclaim
       RECL_PAGES           - process pages in transaction, build live and dead delta buffers 
       RECL_MERGE_DELTAS    - sort the live delta buffers produced
       RECL_MERGE_DEAD      - sort the dead delta buffers produced
       RECL_CHECK_CONFLICTS - make slave threads to wait for conflict checks
       RECL_CONFLICT_OOPS_TO_PAGES    - lookup conflict oops to get pages, mark deltas
       RECL_SEL_ABORT       - do selectiveAbort on conflict objects
       RECL_REM_MARKED      - removeMarkedDeltas
       RECL_PUSH_DEAD       - augment, push dead deltas into shadowOt leaves
       RECL_PUSH_LIVE       - augment, push live object deltas into shadowOt
   } {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat02 TimeInDeadOopsToPages counter64 none Microseconds \
    {Time in RECL_DEAD_OOPS_TO_PAGES - lookup dead objects in ot, add pages to reclaim set} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat03 TimeInReclaimPages counter64 none Microseconds \
    {Time in RECL_PAGES - process data pages, add deltas to buffers} {3.\[7-9\].\*}

  setInternalCtrAlias GcReclaim* SessionStat04 TimeInMergeDeltas counter64 none Microseconds \
    {Time in RECL_MERGE_DELTAS, merge sort the live object delta buffers} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat05 TimeInMergeDead counter64 none Microseconds \
    {Time in RECL_MERGE_DEAD, merge sort the dead object delta buffers} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat06 TimeInCheckConflicts counter64 none Microseconds \
    {Time in RECL_CHECK_CONFLICTS, getToken, determine conflicts} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat07 TimeInConflictOopsToPages counter64 none Microseconds \
    {Time in RECL_CONFLICT_OOPS_TO_PAGES, convert conflict oops to pages} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat08 TimeInSelectiveAbort counter64 none Microseconds \
    {Time in RECL_SEL_ABORT, perform selective abort on conflict objects} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat09 TimeInRemoveConflictDeltas counter64 none Microseconds \
    {Time in RECL_REM_MARKED, remove conflict objects from merged deltas} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat10 TimeInPushDead counter64 none Microseconds \
    {Time in pushing the dead deltas to ot leaf pages} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat11 TimeInPushLive counter64 none Microseconds \
    {Time in pushing the live deltas to ot} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat12 SleepBetweenReclaimTime counter64 none microseconds \
    {Cumulative number of real microseconds sleeping between reclaims}  {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat13 SleepTimer counter64 none microseconds \
    {Cumulative number of real microseconds sleeping for all phases in slave threads}  {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat14 LastSleepTime svalue64 none Milliseconds \
    {Requested duration of the last sleep interval} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat15 SleepCount counter64 none Sleeps \
    {Cumulative number of sleep operations} {3.\[7-9\].*}  

  setInternalCtrAlias GcReclaim* SessionStat16 TotalPinnedPages counter64 none Pages \
    {Total number of pages which were pinned in the cache} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat17 DataPagesNeedReclaiming svalue64 none Pages \
    {Total number of dataPagesNeedReclaiming, pages in dpmgr} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat18 NumOopsMoved svalue64 none Oops \
    {Number of live objects moved this transaction} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat19 NumOopsReclaimed svalue64 none Oops \
    {Number of objects reclaimed this transaction} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat20 NumOopsShadowed svalue64 none Oops \
    {Number of objects skipped because they were shadowed (the current version on a different page) } {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat21 NumOopsPrevReclaimed svalue64 none Oops \
    {Number of dead objects skipped because they were not valid in this page} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat22 PagesReclaimed counter64 none Pages \
    {Cumulative number of pages reclaimed} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat23 ConflictCount counter64 none Conflicts \
    {Cumulative number of objects for which a write-write conflict was resolved during reclaim}  {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat24 DepMapConflictCount counter64 none Conflicts \
    {Cumulative number of dependency map conflicts resolved during reclaim} {3.\[7-9\].*}  

  setInternalCtrAlias GcReclaim* SessionStat25 FreeDeltaBufsCount svalue64 none \
    {OT Entries} {Number Delta buffers in the freeDeltaBufsPool} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat26 MergeArraySizes svalue64 none \
    {OT Entries} {Size of the all the MergeArrays in use} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat27 StayInTransCount counter64 none Operations \
    {Number of times the session remained in transaction after a reclaim commit} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat28 CacheTooDirtyCount counter64 none Operations \
    {Number of times reclaim was suspended because of too many dirty pages in the cache} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat29 FreeSpaceLowCount counter64 none Operations \
    {Number of times reclaim was suspended because of low repository free space} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat30 PriorityPages counter64 none Pages \
    {Cumulative number of priority pages processed} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat31 AlertCount counter64 none Alerts \
    {Number of Alerts received from the stone} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat32 CommitReason svalue64 none Value \
    {The reason it was determined to be timeToCommit -
	1 - reclaimed priority pages > 0
	2 - maxTransactionDuriation reached
	3 - done processing all the pages we can - might be at HwLimit
	4 - ackGcHwNeeded and transactionDuration > 50
	5 - did the limit of work for this transacton (total objects reclaimed > objsMovedPerCommitThreshold)
    } {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat33 MtFreePagesCount svalue64 none Pages \
    {The number of freePages available in the pool used by slave threads for page allocation.} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat34 DeadOopsToPages svalue64 none Oops \
    {Number of dead oops converted to pages.} {3.\[7-9\].*}

  setInternalCtrAlias GcReclaim* SessionStat35 PagesFromDeadOops svalue64 none Pages \
    {Number of pages produced from lookup of dead oops in the OT.} {3.\[7-9\].*}

# 3.7.0 AdminGem main thread
  setInternalCtrAlias GcAdmin* SessionStat00  MtOpId svalue64 none OpId \
    {ID of the current multi threaded operation} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat01 ScanPhase counter64 none Phase \
  {Scan phase:
    6 - epoch GC
    7 - sweep write set union} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat02 OtPagesRead counter64 none Pages \
  {Number of object table pages read} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat06 MarkSweepPhase counter64 none Phase \
  {Phase the mark/sweep is in. 17 = WsUnion - PossibleDead, 18 = WsUnion sweep} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat07 MarkedMinusSweptScans counter64 none Scans \
  {Number of marked - swept scans} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat08 LeafObjsCount counter64 none Objects \
  {Number of leaf objects found during mark/sweep} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat09 LeafObjsOptUsed counter64 none Objects \
  {Number of leaf objects used during mark/sweep} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat10 PagesFoundInCache counter64 none Pages \
  {Number of pages found in the shared cache} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat11 NumPagesToSweep counter64 none Pages \
  {Number of pages to be swept} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat12 NumPagesSwept counter64 none Pages \
  {Number of pages swept} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat13 NumNewMarked counter64 none Objects \
  {Number of new marked objects found by the most recent scan} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat14 NumPinnedPages counter64 none Pages \
  {Number of pages currently pinned in the cache} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat15 TotalPinnedPages counter64 none Pages \
  {Total number of pages which were pinned in the cache} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat16 GetDataPagesTime counter64 none NanoSeconds \
  {Time spent getting shared data pages to sweep} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat17 DataPagesCount counter64 none Pages \
  {Total data pages swept} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat18 AlreadySweptPages counter64 none Pages \
  {Total number of pages containing 1 or more already swept objects} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat19 NumMarkedMinusSwept counter64 none Objects \
  {Total number of in markedMinusSwept} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat19 NumMarkedMinusSwept counter64 none Objects \
  {Total number of in markedMinusSwept} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat31 LeafCacheSize counter64 none Objects \
  {Number of objects in leafCache} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat29 WsUnionObjectsSwept counter64 none Objects \
  {Total number of objects swept in WsUnionSweep} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat30 EpochGcObjsSwept counter64 none Objects \
  {Total number of objects swept in EpochGc} {3.\[5-9\].* 3.4* 3.3* 3.2*}

# 3.7.0 Session stats for main thread in topaz (for when mfc, backup, restore, audit are run directly in topaz -l)
  setInternalCtrAlias TopazL* SessionStat00  MtOpId svalue64 none OpId \
    {ID of the current multi threaded operation:
       05 markForCollection,
       06 epochGc,
       07 sweepWsUnion,
       08 find disconnected objects,
       09 find connected objects,
       10 backup,
       11 restore,
       12 data pages not referenced from object table,
       13 pages percent free,
       14 page audit,
       15 secure backup,
       16 secure restore,
       17 migrate } {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat01 ScanPhase counter64 none Phase \
    {Scan phase:
       00  Inactive
       01  Warm Dependency Map
       02  Scan Object Table
       03  Scan Data Pages
       04  Scan Shadowed (scavengable) Data Pages
       05  Scan Remaining Data Pages
       06  Backup Scavengable Pages
       07  Backup Remaining Pages
       08  Restore Data Pages
       09  Rescan Shadowed Pages (for listRefToInstOfClasses)
       10  Rescan Remaining Pages 
       11  Audit Scavengable Pages
       12  Audit Remaining Pages
       13  Audit Rescan Object Table (rescan to find references to non existent objects)
       14  Audit Rescan Data
       15  All Symbols Sweep 
       16  Mark Sweep
       17  Write Set Union Sweep
       18  Find Connected Objects Sweep
       19  Migrate Merge Deltas }    {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat02 OtPagesRead counter64 none Pages \
  {Number of object table pages read} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat03 NumDataPages counter64 none Pages \
  {Number of data pages referenced from object table} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat04 DataPagesProcessed counter64 none Pages \
  {Number of data pages processed} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat05 TotalInstancesFound counter64 none Objects \
  {Total number of instances found in allInstances, inventory} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat06 MarkSweepPhase counter64 none Phase \
  {Phase the mark/sweep is in. 17 = WsUnion - PossibleDead, 18 = WsUnion sweep} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat07 MarkedMinusSweptScans counter64 none Scans \
  {Number of marked - swept scans} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat08 LeafObjsCount counter64 none Objects \
  {Number of leaf objects found during mark/sweep} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat09 LeafObjsOptUsed counter64 none Objects \
  {Number of leaf objects used during mark/sweep} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat10 PagesFoundInCache counter64 none Pages \
  {Number of pages found in the shared cache} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat11 NumPagesToSweep counter64 none Pages \
  {Number of pages to be swept} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat12 NumPagesSwept counter64 none Pages \
  {Number of pages swept} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat13 NumNewMarked counter64 none Objects \
  {Number of new marked objects found by the most recent scan} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat14 NumPinnedPages counter64 none Pages \
  {Number of pages currently pinned in the cache} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat15 TotalPinnedPages counter64 none Pages \
  {Total number of pages which were pinned in the cache} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat16 GetDataPagesTime counter64 none NanoSeconds \
  {Time spent getting shared data pages to sweep} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat17 DataPagesCount counter64 none Pages \
  {Total data pages swept} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat18 AlreadySweptPages counter64 none Pages \
  {Total number of pages containing 1 or more already swept objects} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat19 NumMarkedMinusSwept counter64 none Objects \
  {Total number of in markedMinusSwept} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat20 NewMarkedCount counter64 none Objects \
  {Total number of new marked objects swept} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat21 RestoreFileVerifyMs counter64 none Objects \
  {Milliseconds spent verifing file for restore} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat22 LrgByteRoots counter64 none Objects \
  {Total number of large byte root objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat23 LrgByteLeaves counter64 none Objects \
  {Total number of large byte leaf objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat24 LrgOopRoots counter64 none Objects \
  {Total number of large oop root objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat25 LrgOopLeaves counter64 none Objects \
  {Total number of large oop leaf objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat26 LrgNscRoots counter64 none Objects \
  {Total number of large Nsc root objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat27 LrgNscRefs counter64 none Objects \
  {Total number of nsc internal objects found} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat28 ThreadsInSweep counter64 none Threads \
  {Number of active threads} {3.6.\[7-9\] 3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat29 OtDeltasSize counter64 none Deltas \
  {Size of the OtDeltasBuf in restore} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat30 MtFreePagesCount counter64 none Pages \
  {Number of free pages in the multi threaded free pages pool} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat31 LeafCacheSize counter64 none Objects \
  {Num objects in leafCache} {3.\[7-9\].*}
  setInternalCtrAlias TopazL* SessionStat32 BuffersInQueue counter64 none Buffers \
  {Number of buffers in the queue waiting to be processed by backup/restore} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat33 WsUnionObjsSwept counter64 none Buffers \
  {Number of objects swept by WsUnion processing in admin gem} {3.\[7-9\].*}
  setInternalCtrAlias GcAdmin* SessionStat34 EpochObjsSwept counter64 none Buffers \
  {Number of objects swept by Epoch processing in admin gem} {3.\[7-9\].*}

  # 3.7.1 stats
  setInternalCtrAlias {mfc-*} SessionStat00  CurrentTask svalue64 none Task \
  {Current MFC task} {3.6.\[7-9\] 3.7.\[1-9\] 3.\[8-9\].*}

  # 3.7.1 - leaf cache stats reused
  setInternalCtrAlias TopazL* SessionStat08 ComputeDpLastDelta counter64 none Pages \
  {DataPageManager page delta} {3.7.\[1-9\] 3.\[8-9\].* }
  setInternalCtrAlias TopazL* SessionStat09 ComputeDpCount counter64 none Operations \
  {DataPageManager recompute page count} {3.7.\[1-9\] 3.\[8-9\].* }


 setInternalCtrAlias {mfc-*} SessionStat15 HashMapProbes counter64 none Probes \
  {Total number of probes into the hash map} {3.\[6-9\].*}
 setInternalCtrAlias {mfc-*} SessionStat16 HashMapCollisions counter64 none Collisions \
  {Total number of hash map collisions} {3.\[6-9\].*}
 setInternalCtrAlias {mfc-*} SessionStat17 HashMapEntries counter64 none Entries \
  {Total number of entries in the hash map} {3.\[6-9\].*}

# 3.7.1
  setInternalCtrAlias {mfc-*} SessionStat13 MarkedMinusSweptLoops counter64 none Loops \
  {Number of times the most recent marked minus swept loop was executed} {3.7.\[1-9\] 3.\[8-9\].*}
  setInternalCtrAlias {mfc-* } SessionStat14 CurrentMfcSubTask uvalue none SubTask \
  {Current MFC sub task} {3.7.\[1-9\] 3.\[8-9\].*}
  setInternalCtrAlias {mfc-* } SessionStat18 ProcessDataPageNoWork uvalue none Operations \
  {Number of times a data page contained no objects eligible for scanning} {3.6.\[7-9\] 3.7.\[1-9\] 3.\[8-9\].*}

# 3.6.7
  setInternalCtrAlias TopazL* SessionStat00  MtOpId svalue64 none OpId \
    {ID of the current multi threaded operation:
       05 markForCollection,
       06 epochGc,
       07 sweepWsUnion,
       08 find disconnected objects,
       09 find connected objects,
       10 backup,
       11 restore,
       12 data pages not referenced from object table,
       13 pages percent free,
       14 page audit,
       15 secure backup,
       16 secure restore } {3.6.\[7-9\]}
  setInternalCtrAlias TopazL* SessionStat12 NumPagesSwept counter64 none Pages \
  {Number of pages swept} {3.6.\[7-9\]}

 setInternalCtrAlias {mfc-* } SessionStat12 OopsFoundInLastMarkSweep uvalue none Objects \
  {Number of oops found in the most recent marked minus swept} {3.6.\[7-9\]}
 setInternalCtrAlias {mfc-* } SessionStat19 CurrentMfcSubTask uvalue none SubTask \
  {Current MFC sub task} {3.6.\[7-9\]}
 setInternalCtrAlias {mfc-* } SessionStat20 GetPagesToSweepEmpty counter64 none Events \
  {Number of times no pages were found to sweep} {3.6.\[7-9\]}
