"
Wrapper for $GEMSTONE/bin/startstone
===================================
man page
--------
SYNOPSIS
       startstone [ gemStoneName ] [ -N ] [ -R ] [ -l logFile ] [ -e exeConfig ]
       [ -z systemConfig ] [ -H ] [ -A ]

       startstone[ gemStoneName ] [ -N ] [ -R ] [ -l logFile ] [ -e exeConfig ]
       [ -z systemConfig ] [ -H ] [ -A ] -D privKeyFile -K keyringDirs [ -K keyringDirs+ ]
       [ -j encryptPassphrase | -J encryptPassphraseFile ] ]

       startstone -v | -h

DESCRIPTION
       The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process. Options such as the configuration files
       and log file can be provided as arguments, read from environment variables, or rely on default values.

       The -C, -N, and -R arguments are special cases of startup; -C is for conversion over certain kinds of upgrades, per the Installation Guide. -N  starts
       up without reading transaction logs, and -R leaves the repository in restore state; see the System Adminstation Guide for details.

       When  starting a stone with encrypted extents, you must also specify the private key corresponding to the public key used to encrypt the extents, with
       -D, and the directory or directories containing public and private keys, with -K. If the private key has a pass phrase, you  must  also  provide  this
       with  the  -j or -J arguments. If the repository was uncleanly shutdown, the associated encrypted transaction logs must be encrypted with the same key
       as the repository extents, for the automatic recovery to succeed. However, if you will be restoring tranlogs from backup, you  may  specify  alternate
       private keys. See the System Adminstation Guide for details.

       startstone  blocks until the stone startup is complete, which make take some time if it is necessarily to recover after a unclean shutdown. startstone
       does not wait for cache warming to complete before returning. Set the configuration parameter STN_CACHE_WARMER_WAIT_MODE to  configure  startstone  to
       block until cache warming is complete.

       Before running more than one Stone process at your site, be sure to read the ""Configuration Files"" chapter of your System Administration Guide.

PARAMETERS
       gemStoneName
              The  name of the Stone (GemStone repository monitor) process to be started. If you do not specify this parameter, the startstone command starts
              a Stone process named ""gs64stone"" on your current host. Legal stone name characters are a..z, A..Z, 0..9, and period, dash, and underscore; the
              name many not begin with these characters.

       -A     startup a stone to perform a page audit. See the pageaudit command for details

       -D privKeyFile
              For  encrypted  extents,  specifies  the  private  key file corresponding to the public key used to encrypt the extents. The file name must not
              include a path; use -K to specify the path to this private key file. The file must be in PEM format. If the private key has a passphrase,  then
              either -j or -J are also required.

       -e exeConfig
              Executable-specific  configuration  file.  If  this  argument is not present, the startstone command uses the GEMSTONE_EXE_CONF search sequence
              described below. startstone command uses the GEMSTONE_SYS_CONF search sequence described below.

       -h     print a usage line and exit.

       -H     By default, hostnames for clients are printed as IP address only. With this option, the stone also does a reverse DNS lookups  on  the  IP  and
              prints both IP and hostname in the log.

       -j encryptPassphrase
              When using encrypted extents, specify the passphrase for the private key specified by -D.

       -J encryptPassphraseFile
              When using encrypted extents, specify the passphrase contained in the file encryptPassphraseFile for the private key specified by -D.

       -K keyringDirs
              When  using  encrypted  extents,  specifies one or more keyring directories that are used for the key for encrypted extents. Directories may be
              separated by colons; and the -K may be specified multiple times.

       -l     logfile The log file for the Stone's standard output and standard error. If you do not specify this parameter, the startstone command uses  (1)
              a GEMSTONE_LOG environment variable, if defined, or (2) $GEMSTONE/data/gemStoneName.log

       -N     Startup  when no transaction logs are available. If the transaction logs specified in the configuration file cannot be found and if the repository
              needs recovery, startup up anyway, even though transactions committed since the last checkpoint will be lost. If the  Stone  detects  that
              the logs actually are present, it ignores the option and performs a normal startup. If a transaction log file is present but corrupted, you may
              have to remove that log file before restarting. This option may be used to start a stone if the transaction files have been lost or  corrupted,
              but the extents are still available. A new transaction log will be initialized as part of the startup.

       -R     Startup  from  the  most recent checkpoint and go into restore-from-transaction-logs state. Topaz must be then be used to execute the 
               commitRestore method before any normal commits will be allowed.

              If the extents against which stone is being started require recovery, then use of the -R option will result in an  error  and  stone  will  not
              start. This error may be overridden with by using both -N and -R .

       -v     print version information and exit.

       -z systemConfig
              System  configuration file. If this argument is not present, the environment variable GEMSTONE_SYS_CONF is checked; finally, the default, 
              $GEMSTONE/data/system.conf is used. If none of these are found, the Stone will not start.

RETURN VALUE
       The return value of startstone is one of the following:

           * 0 (success) on successful start
           * 1 (informational) the specified stonename is already running
           * 2 (warning) the specified stonename is already running, but the exectuables for that stone have been deleted/overwritten
           * 3 (error) an error occurred and the specified stone was not started.

help
-----
Usage:
  startstone [-e exeConf ] [-z sysConf ] [-N] [-R] [-l logfilename] stonename
  startstone [-e exeConf ] [-z sysConf ] [-N] [-R] [-l logfilename] -D privKey
     -K dir [ -K dir+] [-j passPhrase | -J pfFile ] [-H] stonename
  startstone -h | -v
where:
  -A   startup a stone to perform a page audit - see the pageaudit command for details
  -e   Specifies executable specific configuration file. Default is $GEMSTONE_EXE_CONF
       environment varible if defined, else  ./<name>.conf . If not found -z must
       be specified have a usable default (see below).
  -h   Prints usage information and exits.
  -H   Do reverse DNS lookup and print peer hostnames in addition to IP address in logs.
  -l   Specifies the name of the stone log file. Default is per $GEMSTONE_LOG
       environment variable if defined, else $GEMSTONE/data/<name>.log
  -N   Startup does not require transaction logs.
  -R   Start from most recent checkpoint to go into restore mode.
  -v   Print version and exit.
  -z   Specifies system configuration file. Default is per $GEMSTONE_SYS_CONF
       environment variable if defined, else $GEMSTONE/data/system.conf .
Secure Database Options:
  -D   Specifies the private key file used to access the encrypted database. 
       The file must be in PEM format. If the private key has a passphrase, then 
       either -j or -J are also required. The file name must not include a path.
       Use -K to specify the path to the private key file.
  -j   Specifies the passphrase for the private key specified by -D.
  -J   Specifies a file containing the passphrase for the private key specified
       by -D. Requires the full path to the filename.
  -K   Specifies one or more keyring directories. Directories may be separated
       by colons and/or -K may be specified multiple times.
  stonename is the name of the process.  Default is gs64stone.
startstone returns:
   0 on successful start
   1 if the specified stone is already running
   2 if already running but the exectuables have been deleted
   3 or above, an error occurred and the specified stone was not started
"
Class {
	#name : 'GsStartStone',
	#superclass : 'GsHostProcess',
	#category : 'GsCommands-Commands'
}

{ #category : 'invocation' }
GsStartStone class >> startStone: stoneName [
	"The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process."

	"rely on defaults for everything except stoneName"

	^ self startStone: stoneName logFile: nil
]

{ #category : 'invocation' }
GsStartStone class >> startStone: stoneName exeConfFile: exeConfFile [
	"The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process."

	^ self
		startStone: stoneName
		exeConfFile: exeConfFile
		sysConfFile: nil
		logFile: nil
		noTranlogs: false
		restoreMode: false
		conversionMode: false
]

{ #category : 'invocation' }
GsStartStone class >> startStone: stoneName exeConfFile: exeConfFile logFile: logFile [
	"The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process."

	^ self
		startStone: stoneName
		exeConfFile: exeConfFile
		sysConfFile: nil
		logFile: logFile
		noTranlogs: false
		restoreMode: false
		conversionMode: false
]

{ #category : 'invocation' }
GsStartStone class >> startStone: stoneName exeConfFile: exeConfFile sysConfFile: sysConfFile logFile: logFile noTranlogs: noTranlogsBool restoreMode: restoreModeBool conversionMode: conversionModeBool [
	"The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process."

	"
	exit status
       The exit status of startstone is one of the following:

		0 on successful start
		1 if the specified stone is already running
		2 if already running but the exectuables have been deleted
		3 or above, an error occurred and the specified stone was not started
"

	| commandLineString options |
	options := String new.
	conversionModeBool
		ifTrue: [ options add: ' -C ' ]
		ifFalse: [ 
			noTranlogsBool
				ifTrue: [ options add: ' -N ' ].
			restoreModeBool
				ifTrue: [ options add: ' -R  ' ] ].
	exeConfFile ifNotNil: [ options add: ' -e ' , exeConfFile , ' ' ].
	sysConfFile ifNotNil: [ options add: ' -z ' , sysConfFile , ' ' ].
	logFile ifNotNil: [ options add: ' -l ' , logFile , ' ' ].
	commandLineString := '$GEMSTONE/bin/startstone' asFileReference pathString
		, ' ' , stoneName , options.
	^ self _execute: commandLineString input: nil	"{ stdout, stderr}"
]

{ #category : 'invocation' }
GsStartStone class >> startStone: stoneName logFile: logFile [
	"The  startstone  command  submits a background process to start a Stone (GemStone repository monitor) process."

	"exeConfFile and/or sysConfFile defined with environment vars: GEMSTONE_EXE_CONF and GEMSTONE_EXE_CONF "

	^ self
		startStone: stoneName
		exeConfFile: nil
		sysConfFile: nil
		logFile: logFile
		noTranlogs: false
		restoreMode: false
		conversionMode: false
]
