"
Wrapper for $GEMSTONE/bin/stopstone
===================================
man page
--------
SYNOPSIS
       stopstone [ gemStoneName [ gemStoneUserName [ gemStonePassword ] ] ] [ -i ]
       [ -t timeout ] [ -h ]

DESCRIPTION
       The  stopstone command conducts an orderly shutdown of a running Stone (GemStone repository monitor) process. In the process a checkpoint is performed
       in which all committed transactions are written to the extents and to any replicates. To issue this command, you must have explicit privilege for System 
       Control in your GemStone UserProfile. (Privileges are discussed in Chapter 5 of the System Administration Guide.)

PARAMETERS
       gemStoneName
              The  name  of the Stone process that you want to terminate. This corresponds to the GemStone name that you specified in the startstone command,
              by default gs64stone. This parameter can be specified as a network resource string. (See the System Administration Guide for  network  resource
              string syntax.) If you don't explicitly specify the GemStone name on the command line, stopstone will prompt you to supply one.

       gemStoneUserName
              A  privileged  GemStone  user ID, typically DataCurator. If you don't explicitly specify the user ID on the command line, stopstone will prompt
              you for it.

       gemStonePassword
              The password for the GemStone user ID specified. If you don't explicitly specify the password on the command line, stopstone  will  prompt  you
              for it.

              If  your  GemStone password contains an embedded space, you cannot use the stopstone command. Reset the password to a password without embedded
              spaces to renable execution of the stopstone command.

       -i     If you specify this command line option, the stopstone command will terminate all current sessions, shut down the Stone, and write  a  shutdown
              message to the workstation of each logged-in user.

              If  you do not specify the -i option, and any other user sessions are still logged in, the Stone will not be shut down and you will receive the
              message ""Other users logged in, Stone not shut down."" (If no other user sessions are logged in, the  Stone  will  be  shut  down  as  described
              above.)

       -t timeout
              specifies how long to wait for other processes to detach the cache before returning. Default is -1 which means wait forever.

       -h     print a usage line and exit

RETURN VALUE
       The return value of stopstone is one of the following:

           * 0 (success) Successful stop
           * 1 (informational) No running stone with that stonename
           * 2 (warning)
           * 3 or above (error) an error occurred and the specified stone was not stopped.
           * 10 syntax error
           * 11 bad user or password
           * 12 specified user does not have privilege to stop the stone.
           * 13 stone not stopped; other users logged in. Use -i to override.

help
-----
Usage: stopstone [-h] [-i] [-t timeout] [name [account [password]]]
  where -h       prints usage information and exits.
        -i       stops the stone immediately even if others are logged in.
        -t       specifies how long to wait for other processes to detach the cache.
                 Default is -1 which means wait forever.
        name     is the name of the stone to stop (default is gs64stone).
        account  a privileged GemStone user ID, typically DataCurator.
        password for the specified account (default will be prompted for).
  stopstone returns:
    0 on successful stop
    1 if the specified stone was not running
    3 or above, an error occurred and the specified stone could not be stopped
"
Class {
	#name : 'GsStopStone',
	#superclass : 'GsHostProcess',
	#category : 'GsCommands-Commands'
}

{ #category : 'invocation' }
GsStopStone class >> stopStone: stoneName [
	^ self stopStone: stoneName userName: 'DataCurator' password: 'swordfish'
]

{ #category : 'invocation' }
GsStopStone class >> stopStone: stoneName userName: userName password: password [
	^ self
		stopStone: stoneName
		userName: userName
		password: password
		timeout: nil
		immediate: true
]

{ #category : 'invocation' }
GsStopStone class >> stopStone: stoneName userName: userName password: password timeout: timeout immediate: immediateBool [
	"
	exit status
       The exit status of stopstone is one of the following:

           * 0 (success) Successful stop
           * 1 (informational) No running stone with that stonename
           * 2 (warning)
           * 3 or above (error) an error occurred and the specified stone was not stopped.
           * 10 syntax error
           * 11 bad user or password
           * 12 specified user does not have privilege to stop the stone.
           * 13 stone not stopped; other users logged in. Use -i to override.
"

	| commandLineString options |
	options := String new.
	userName
		ifNotNil: [ 
			options add: ' ' , userName , ' '.
			password ifNotNil: [ options add: ' ' , password , ' ' ] ].
	timeout ifNotNil: [ options add: ' -t ' , timeout asString , ' ' ].
	immediateBool
		ifTrue: [ options add: ' -i ' ].
	commandLineString := '$GEMSTONE/bin/stopstone' asFileReference pathString , ' '
		, stoneName , options.
	^ self _execute: commandLineString input: nil	"{ stdout, stderr}"
]
