/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - getpwnam.c
 *
 *========================================================================
 */

#include <stdio.h>
#include <pwd.h>
#include <ctype.h>
#include <errno.h>
#include <unistd.h>
#include <stdlib.h>

int main(int argc, char *argv[])
{

if (argc != 2) {
  printf("Usage: %s <user-name>\n", argv[0]);
  exit(1);
  }

struct passwd *pw = getpwnam(argv[1]);
if (pw == NULL) {
  printf("%s:  (no entry, errno = %d)\n", argv[1], errno);
  exit(1);
  }

printf("pw_name='%s', pw_passwd='%s', pw_uid=%d, pw_gid=%d\n",
    pw->pw_name, pw->pw_passwd, pw->pw_uid, pw->pw_gid);

printf("pw_gecos='%s', pw_dir='%s', pw_shell='%s'\n",
    pw->pw_gecos, pw->pw_dir, pw->pw_shell);
return 0;
}
