/*========================================================================
 * Written by D. Jason Penney, 1991.  Rights to this program are as follows:
 * you may not receive any compensation for distribution of this program
 * except for an optional fee for the distribution medium.  This program
 * must be accompanied by this source code.  This notice may not be removed.
 * Modifications to this program must be clearly noted and marked as such.
 * Since this program is provided free of charge, there is ABSOLUTELY NO
 * WARRANTY.
 *
 * Name - getservbyport.c
 *
 * Description - Program to verify presence of a given service, i.e.
 *               by the getservbyport(2) call.
 *
 *========================================================================
 */

#include <stdio.h>
#include <netdb.h>
#include <ctype.h>
#include <errno.h>
#include <stdlib.h>

#include <sys/types.h>
#include <netinet/in.h>

#define SUCCESS 0
#define NO_SERVICE 1
#define BAD_ARG 2

int main(int argc, char *argv[])
{
struct servent *thisOne;
char **thisAlias;
int port;

if (argc != 2) {
  printf("Usage: %s <port-number>\n", argv[0]);
  exit(BAD_ARG);
  }

if (sscanf(argv[1], "%d", &port) != 1) {
  printf("Usage: %s <port-number>\n", argv[0]);
  exit(BAD_ARG);
  }

#if defined(AIX) || defined(_AIX)
thisOne = getservbyport(htons(port), "tcp");
#else
thisOne = getservbyport(htons(port), NULL);
#endif
if (thisOne == NULL) {
  printf("%s:  (no entry, errno = %d)\n", argv[1], errno);
  exit(NO_SERVICE);
  }
printf("s_name=%s s_port = %d s_proto = %s\n", thisOne->s_name,
    ntohs(thisOne->s_port), thisOne->s_proto);
if (*thisOne->s_aliases != NULL) {
  printf("aliases: ");
  for (thisAlias = thisOne->s_aliases; *thisAlias != NULL; thisAlias ++)
    printf("%s ", *thisAlias);
  printf("\n");
  }
exit(SUCCESS);
return SUCCESS; /* for lint */
}
