"
No class-specific documentation for RsrIntegerReference, hierarchy is:
Object
  RsrObject
    RsrReference
      RsrImmediateReference
        RsrIntegerReference( value)

"
Class {
	#name : 'RsrIntegerReference',
	#superclass : 'RsrValueReference',
	#category : 'RemoteServiceReplication-Base',
	#package : 'RemoteServiceReplication-Base'
}

{ #category : 'converting' }
RsrIntegerReference class >> convertToBytes: anInteger [

	| stream int |
	anInteger <= 0
		ifTrue: [^#[0]].
	stream := WriteStream on: (ByteArray new: 8).
	int := anInteger.
	[int > 0]
		whileTrue:
			[stream nextPut: (int bitAnd: 16rFF).
			int := int bitShift: -8].
	^stream contents reverse
]

{ #category : 'instance creation' }
RsrIntegerReference class >> from: anInteger [

	| intermediate |
	intermediate := self convertToBytes: anInteger abs.
	^anInteger positive
		ifTrue: [RsrPositiveIntegerReference intermediate: intermediate]
		ifFalse: [RsrNegativeIntegerReference intermediate: intermediate]
]

{ #category : 'converting' }
RsrIntegerReference >> convertBytes: aByteArray [

	^aByteArray
		inject: 0
		into: [:integer :byte | (integer bitShift: 8) bitOr: byte]
]

{ #category : 'encoding/decoding' }
RsrIntegerReference >> decode: aStream
using: aDecoder [

	aDecoder
		decodeIntegerReference: self
		from: aStream
]

{ #category : 'resolving' }
RsrIntegerReference >> resolve: aConnection [

	^self convertBytes: intermediate
]
