"
RBBlockNode is an AST node that represents a block ""[...]"".

Instance Variables:
	arguments	<SequenceableCollection of: RBVariableNode>	the arguments for the block
	bar	<Integer | nil>	position of the | after the arguments
	body	<RBSequenceNode>	the code inside the block
	colons	<SequenceableCollection of: Integer>	positions of each : before each argument
	left	<Integer>	position of [
	right	<Integer>	position of ]


"
Class {
	#name : 'RBBlockNode',
	#superclass : 'RBValueNode',
	#instVars : [
		'left',
		'right',
		'colons',
		'arguments',
		'bar',
		'body'
	],
	#category : 'AST-Core'
}

{ #category : 'instance creation' }
RBBlockNode class >> arguments: argNodes body: sequenceNode [ 
	^(self new)
		arguments: argNodes;
		body: sequenceNode;
		yourself
]

{ #category : 'instance creation' }
RBBlockNode class >> body: sequenceNode [ 
	^self arguments: #() body: sequenceNode
]

{ #category : 'comparing' }
RBBlockNode >> = anObject [ 
	self == anObject ifTrue: [^true].
	self class = anObject class ifFalse: [^false].
	self body = anObject body ifFalse: [^false].
	self arguments size = anObject arguments size ifFalse: [^false].
	1 to: self arguments size
		do: [:i | (self arguments at: i) = (anObject arguments at: i) ifFalse: [^false]].
	^true
]

{ #category : 'visitor' }
RBBlockNode >> acceptVisitor: aProgramNodeVisitor [ 
	^aProgramNodeVisitor acceptBlockNode: self
]

{ #category : 'accessing' }
RBBlockNode >> allArgumentVariables [
	^(self argumentNames asOrderedCollection)
		addAll: super allArgumentVariables;
		yourself
]

{ #category : 'accessing' }
RBBlockNode >> allDefinedVariables [
	^(self argumentNames asOrderedCollection)
		addAll: super allDefinedVariables;
		yourself
]

{ #category : 'accessing' }
RBBlockNode >> argumentNames [
	^self arguments collect: [:each | each name]
]

{ #category : 'accessing' }
RBBlockNode >> arguments [
	^arguments
]

{ #category : 'accessing' }
RBBlockNode >> arguments: argCollection [ 
	arguments := argCollection.
	arguments do: [:each | each parent: self]
]

{ #category : 'accessing-token' }
RBBlockNode >> bar [
	^ bar
]

{ #category : 'accessing-token' }
RBBlockNode >> bar: anInteger [
	bar := anInteger
]

{ #category : 'accessing' }
RBBlockNode >> blockVariables [
	| vars |
	vars := super blockVariables asOrderedCollection.
	vars addAll: self argumentNames.
	^vars
]

{ #category : 'accessing' }
RBBlockNode >> body [
	^body
]

{ #category : 'accessing' }
RBBlockNode >> body: stmtsNode [ 
	body := stmtsNode.
	body parent: self
]

{ #category : 'accessing' }
RBBlockNode >> children [
	^self arguments copyWith: self body
]

{ #category : 'accessing-token' }
RBBlockNode >> colons [
	^ colons
]

{ #category : 'accessing-token' }
RBBlockNode >> colons: anArray [ 
	colons := anArray
]

{ #category : 'matching' }
RBBlockNode >> copyInContext: aDictionary [ 
	^ self class new
		arguments: (self copyList: self arguments inContext: aDictionary);
		body: (self body copyInContext: aDictionary);
		yourself
]

{ #category : 'testing' }
RBBlockNode >> defines: aName [ 
	^arguments anySatisfy: [:each | each name = aName]
]

{ #category : 'testing' }
RBBlockNode >> directlyUses: aNode [ 
	^false
]

{ #category : 'comparing' }
RBBlockNode >> equalTo: anObject withMapping: aDictionary [ 
	self class = anObject class ifFalse: [^false].
	self arguments size = anObject arguments size ifFalse: [^false].
	1 to: self arguments size
		do: 
			[:i | 
			((self arguments at: i) equalTo: (anObject arguments at: i)
				withMapping: aDictionary) ifFalse: [^false]].
	(self body equalTo: anObject body withMapping: aDictionary)
		ifFalse: [^false].
	self arguments do: [:each | aDictionary removeKey: each name].
	^true
]

{ #category : 'comparing' }
RBBlockNode >> hash [
	^ (self hashForCollection: self arguments) bitXor: self body hash
]

{ #category : 'testing' }
RBBlockNode >> isBlock [
	^true
]

{ #category : 'testing' }
RBBlockNode >> isImmediateNode [
	^true
]

{ #category : 'testing' }
RBBlockNode >> isLast: aNode [ 
	^body isLast: aNode
]

{ #category : 'accessing-token' }
RBBlockNode >> left [
	^ left
]

{ #category : 'accessing-token' }
RBBlockNode >> left: anInteger [
	left := anInteger
]

{ #category : 'matching' }
RBBlockNode >> match: aNode inContext: aDictionary [ 
	aNode class = self class ifFalse: [^false].
	^(self 
		matchList: arguments
		against: aNode arguments
		inContext: aDictionary) 
			and: [body match: aNode body inContext: aDictionary]
]

{ #category : 'testing' }
RBBlockNode >> needsParenthesis [
	^false
]

{ #category : 'copying' }
RBBlockNode >> postCopy [
	super postCopy.
	self arguments: (self arguments collect: [ :each | each copy ]).
	self body: self body copy
]

{ #category : 'accessing' }
RBBlockNode >> precedence [
	^0
]

{ #category : 'testing' }
RBBlockNode >> references: aVariableName [ 
	^body references: aVariableName
]

{ #category : 'replacing' }
RBBlockNode >> replaceNode: aNode withNode: anotherNode [ 
	body == aNode ifTrue: [self body: anotherNode].
	self arguments: (arguments 
				collect: [:each | each == aNode ifTrue: [anotherNode] ifFalse: [each]])
]

{ #category : 'accessing-token' }
RBBlockNode >> right [
	^ right
]

{ #category : 'accessing-token' }
RBBlockNode >> right: anInteger [
	right := anInteger
]

{ #category : 'accessing' }
RBBlockNode >> startWithoutParentheses [
	^left
]

{ #category : 'accessing' }
RBBlockNode >> statementComments [
	^self comments
]

{ #category : 'accessing' }
RBBlockNode >> stopWithoutParentheses [
	^right
]

{ #category : 'testing' }
RBBlockNode >> uses: aNode [ 
	aNode = body ifFalse: [^false].
	^parent isMessage 
		ifTrue: 
			[(#(#ifTrue:ifFalse: #ifTrue: #ifFalse: #ifFalse:ifTrue:) 
				includes: parent selector) not 
				or: [parent isUsed]]
		ifFalse: [self isUsed]
]
