"
No class-specific documentation for RowanProcessService, hierarchy is:
Object
  RowanService( definition updates command commandArgs updateType organizer)
    RowanProcessService( frames oop status)

"
Class {
	#name : 'RowanProcessService',
	#superclass : 'RowanService',
	#instVars : [
		'frames',
		'oop',
		'status',
		'name',
		'errorMessage'
	],
	#category : 'Rowan-Services-Core'
}

{ #category : 'instance creation' }
RowanProcessService class >> new [

	"in general use one of the other constructor methods.
	Needed for STON replication"
	^super new
]

{ #category : 'instance creation' }
RowanProcessService class >> onActiveProcess: aGsProcess [

	^self basicNew
		initialize;
		initialize: aGsProcess status: 'active';
		yourself
]

{ #category : 'instance creation' }
RowanProcessService class >> onReadyProcess: aGsProcess [

	^self basicNew
		initialize: aGsProcess status: 'ready';
		yourself

]

{ #category : 'instance creation' }
RowanProcessService class >> onSuspendedProcess: aGsProcess [

	^self basicNew
		initialize: aGsProcess status: 'suspended';
		yourself

]

{ #category : 'instance creation' }
RowanProcessService class >> onWaitingProcess: aGsProcess [

	^self basicNew
		initialize: aGsProcess status: 'waiting';
		yourself

]

{ #category : 'rsr' }
RowanProcessService class >> templateClassName [

	^#RowanProcessService
]

{ #category : 'initialize' }
RowanProcessService >> clearOrganizers [
	self organizer: nil. 
	updates := nil.
	frames
		ifNotNil: [ 
			frames
				do: [ :frameService | 
					frameService organizer: nil.  
					frameService method organizer: nil.
					frameService vars
						ifNotNil: [ :vars | vars do: [ :variableService | variableService organizer: nil ] ] ] ]
]

{ #category : 'accessing' }
RowanProcessService >> errorMessage [
	^errorMessage
]

{ #category : 'accessing' }
RowanProcessService >> errorMessage: object [
	errorMessage := object
]

{ #category : 'initialize' }
RowanProcessService >> frames [

	^frames
]

{ #category : 'initialize' }
RowanProcessService >> initialize [

	frames := Array new
]

{ #category : 'initialize' }
RowanProcessService >> initialize: aGsProcess status: aString [
	| theOrganizer |
	theOrganizer := ClassOrganizer new.
	frames := Array new: aGsProcess stackDepth.
	1 to: aGsProcess stackDepth do: [ :i | 
		frames
			at: i
			put:
				([ RowanFrameServiceServer process: aGsProcess level: i organizer: theOrganizer ]
					on: Error , Halt
					do: [ :ex | 
						GsFile gciLogServer: 'error building Jadeite debugger - ' , ex printString.
						RowanFrameServiceServer basicNew
							label: 'unprintable frame - error: ' , ex printString;
							method:
									(RowanMethodServiceServer new
											stepPoints: Array new;
											breakPoints: Array new) ]) ].
	oop := aGsProcess asOop.
	status := aString
]

{ #category : 'accessing' }
RowanProcessService >> oop [
	^oop
]

{ #category : 'accessing' }
RowanProcessService >> oop: object [
	oop := object
]

{ #category : 'accessing' }
RowanProcessService >> status [
	^status
]

{ #category : 'accessing' }
RowanProcessService >> status: object [
	status := object
]

{ #category : 'updating' }
RowanProcessService >> update [
	super update. 
	self initialize: (Object _objectForOop: oop) status: 'suspended'.
	RowanCommandResult addResult: self.
]
