Extension { #name : 'AbstractUserProfileSet' }

{ #category : 'Adding' }
AbstractUserProfileSet >> _add: aUserProfile [

AbstractUserProfileSet subclassResponsibility: #_add:

]

{ #category : 'Removing' }
AbstractUserProfileSet >> _removeAll: aCollection errIfAbsent: aBool [

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aBool ifTrue:[ self removeAll: aCollection]
     ifFalse:[ self removeAllPresent: aCollection ]

]

{ #category : 'Adding' }
AbstractUserProfileSet >> add: aUserProfile [

"(Subclass responsibility.)  Adds aUserProfile to the receiver."

AbstractUserProfileSet subclassResponsibility: #add:

]

{ #category : 'Adding' }
AbstractUserProfileSet >> addAll: aCollection [

"Reimplemented to maintain KeyValueDictionary on AllUsers."

AbstractUserProfileSet subclassResponsibility: #addAll:

]

{ #category : 'Removing' }
AbstractUserProfileSet >> removeAll: aCollection [

"Reimplemented to maintain KeyValueDictionary on AllUsers."

| aColl tmpArr|
aColl := aCollection.
aColl == self ifTrue:[
  aColl == AllUsers ifTrue:[
    self _halt: 'Attempt to remove all elements of AllUsers'  .
    self _uncontinuableError
    ].
  tmpArr := Array withAll: aColl .
  aColl := tmpArr .
  ].
aColl accompaniedBy: self do:[ :me :element | me remove: element ].
^ aCollection

]

{ #category : 'Removing' }
AbstractUserProfileSet >> removeAllPresent: aCollection [

"Reimplemented to maintain KeyValueDictionary on AllUsers."

aCollection == self ifTrue:[ ^ self removeAll: aCollection ].

aCollection accompaniedBy: self do:[ :me :element | me removeIfPresent: element ].
^ aCollection

]

{ #category : 'Removing' }
AbstractUserProfileSet >> removeIfPresent: anObject [

"Reimplemented to maintain KeyValueDictionary on AllUsers."

^ self remove: anObject ifAbsent: [ nil ]

]

{ #category : 'Accessing' }
AbstractUserProfileSet >> userWithId: aString [

"Searches the receiver for a UserProfile whose userId is equal to aString, and
 returns that UserProfile.  Generates an error if no userId is equal to
 aString."

^ self userWithId: aString
         ifAbsent:[ self _error: #objErrNotInColl args: { aString }]

]
