Extension { #name : 'ClusterBucket' }

{ #category : 'Listing Instances' }
ClusterBucket class >> allInstances [

"Returns the collection of all instances of the receiver."

^ AllClusterBuckets

]

{ #category : 'Accessing' }
ClusterBucket class >> bucketWithId: aPositiveSmallInt [

"Returns the instance with the specified ID if one exists.  Generates an error
 if anInt is less than 1 or outside of the range of existing cluster buckets."

^ AllClusterBuckets at: aPositiveSmallInt

]

{ #category : 'Instance Creation' }
ClusterBucket class >> new [

"Creates an instance of the receiver and adds the new instance to
 AllClusterBuckets."

| newId result max |
max := System _maxClusterId .
(AllClusterBuckets size >= max) ifTrue: [
  self _error: #rtErrMaxClusterId args: { max }.
  ^ AllClusterBuckets at: 1 "returns default bucket"
  ] .
newId := AllClusterBuckets size + 1 .
result := super new .
result _clusterId: newId ;
       keepClusteredOnModify: false ;
  "create an empty string for the description, so description can be
   modified later without putting the ClusterBucket in a write set."
       description: String new .

AllClusterBuckets addLast: result .
^ result

]

{ #category : 'Instance Creation' }
ClusterBucket class >> newForExtent: extentId [

"DEPRECATED.
 In Gemstone64 v2.0, the relationship between a ClusterBucket and
 an extent is weak.  Clustering an object into a ClusterBucket will
 attempt to use the specified extentId , if the session already has a
 free page within that extent.
 Otherwise  DBF_ALLOCATION_MODE in Stone's config file will
 take precedence when the session asks stone for more free pages.

 Creates an instance of the receiver for clustering objects in the extent
 extentId.  The extentId argument is a positive SmallInteger in the range of
 1 to (SystemRepository numberOfExtents)."

self deprecated: 'ClusterBucket>>newForExtent: deprecated in v3.2, use new instead'.
^ self new extentId: extentId

]

{ #category : 'Updating' }
ClusterBucket >> _clearClusterCache [

"Private.  Any method that modifies an instance variable of a
 ClusterBucket that affects clustering behavior must send this method.  The
 instance variable description is not included in such instance variables."

<primitive: 235>
self _primitiveFailed: #_clearClusterCache .
self _uncontinuableError

]

{ #category : 'Updating' }
ClusterBucket >> _clusterId: aSmallInteger [

"Private.  For use only during instance creation."

_clusterId := aSmallInteger .
self _clearClusterCache .

]

{ #category : 'Accessing' }
ClusterBucket >> clusterId [

"Returns the value of the private instance variable.  This instance variable
 should only be assigned by ClusterBucket | new."

^ _clusterId

]

{ #category : 'Accessing' }
ClusterBucket >> description [

"Returns the value of the description instance variable."

^ description

]

{ #category : 'Updating' }
ClusterBucket >> description: anObject [

"Assigns anObject (typically some kind of String object) as the description of
 the receiver."

description := anObject

]

{ #category : 'Accessing' }
ClusterBucket >> extentId [

"Returns the value of the extentId instance variable.

 In Gemstone64 v2.0, the relationship between a ClusterBucket and
 an extent is weak.  Clustering an object into a ClusterBucket will
 attempt to use the specified extentId , if the session already has a
 free page within that extent.
 Otherwise  DBF_ALLOCATION_MODE in Stone's config file will
 take precedence when the session asks stone for more free pages."


^ extentId

]

{ #category : 'Updating' }
ClusterBucket >> extentId: anExtentId [

"DEPRECATED.  In Gemstone64 v2.0, the relationship between a ClusterBucket and
 an extent is weak.  Clustering an object into a ClusterBucket will
 attempt to use the specified extentId , if the session already has a
 free page within that extent.
 Otherwise  DBF_ALLOCATION_MODE in Stone's config file will
 take precedence when the session asks stone for more free pages.

 An argument of nil specifies don't care behavior.  Positive arguments are
 an offset into the result of Repository | fileNames, thus specifying an extent.
 Reference to an extent which does not exist will generate an error at the
 time of executing this method.

 At the time of object modification, a non-nil extentId specifies which extent
 to attempt to put the object in (per DEPRECATED notice above).
 If the extent no longer exists, or is full,
 at the time of clustering or object modification, don't care behavior occurs."


self deprecated: 'ClusterBucket>>extentId: deprecated in v3.2, use new instead'.
SystemRepository validateExtentId: anExtentId .
extentId := anExtentId .
self _clearClusterCache .

]

{ #category : 'Accessing' }
ClusterBucket >> keepClusteredOnModify [

"This feature is not implemented in this release."

^ keepClusteredOnModify

]

{ #category : 'Updating' }
ClusterBucket >> keepClusteredOnModify: aBoolean [

"This feature is deferred until a future release.  Argument value of true
 is not supported in this release."

keepClusteredOnModify := false .
self _clearClusterCache .

]
