Extension { #name : 'CollisionBucket' }

{ #category : 'Searching' }
CollisionBucket >> _firstPair [

"Returns an Array containing the receiver's first key/value pair.
 If the receiver is empty, returns an Array containing nils."

   numElements == 0 ifFalse: [  | idx |
      idx := 1 .
      "Search for the first non-nil key"
      1 to: self tableSize do: [ :n | | aKey |
         (aKey := self _at: idx ) ifNotNil: [    "inline keyAt:"
            ^ { aKey . (self _at: idx + 1) }
         ].
         idx := idx + 2
      ]
   ].
   ^ { nil . nil } "No first pair was found"

]

{ #category : 'Private' }
CollisionBucket >> _removeAll [

"Dereferences the receiver from its parent and shrinks the receiver.
 Used while rebuilding a KeyValueDictionary."

keyValueDictionary := nil.
numElements := 0.
"gs64 v3.0 don't send  size: 0"

]

{ #category : 'Private' }
CollisionBucket >> _removePairAt: anOffset [

(self _at: anOffset)  ifNil:[
  ^ Error signal:'key has already been removed'.
].
self _at: anOffset put: nil ;
     _at: anOffset + 1 put: nil .
numElements := numElements - 1 .

]

{ #category : 'Accessing' }
CollisionBucket >> keyValueDictionary [

"Returns the value of the instance variable."

^keyValueDictionary

]

{ #category : 'Updating' }
CollisionBucket >> keyValueDictionary: aDict [

"Updates the value of the keyValueDictionary instance variable."

keyValueDictionary := aDict

]
