Extension { #name : 'GsExceptionHandler' }

{ #category : 'Disallowed' }
GsExceptionHandler class >> basicNew [
  "Instances are created only by methods in Exception. See also #new ."

  self shouldNotImplement: #basicNew .
  ^ nil

]

{ #category : 'Disallowed' }
GsExceptionHandler class >> new [
  "instances may be created only by using
     Exception(C)>>category:number:do:
     Exception(C)>>installStaticException:category:number:
     Exception(C)>>installStaticException:category:number:subtype:
     Exception(C)>>addDefaultHandler:
  "
  self shouldNotImplement: #new .
  ^ nil

]

{ #category : 'Management' }
GsExceptionHandler class >> removeActivationException: aGsExceptionHandler [

"Search the current GemStone Smalltalk call stack for a method or block context
 that has anException installed, and remove it.  The stack is searched by
 starting with the top method or block context and moving down.

 If aGsExceptionHandler was found on the stack, returns aGsExceptionHandler,
 otherwise signals a RuntimeError.  "

aGsExceptionHandler class == GsExceptionHandler ifTrue:[
  aGsExceptionHandler _remove ifNil:[
    LookupError signal: 'aGsExceptionHandler was not found on the stack'
  ].
  ^ aGsExceptionHandler .
].
aGsExceptionHandler _validateClass: GsExceptionHandler

]

{ #category : 'Accessing' }
GsExceptionHandler >> _ansiBlock [
  "If receiver is an ANSI static handler, return the receivers block,
   else return nil."
  exClass ifNotNil:[ ^ theBlock ].
  ^ nil

]

{ #category : 'Management' }
GsExceptionHandler >> _remove [

"Search the current GemStone Smalltalk call stack for a method or block context
 that has the receiver installed, and remove it.  The stack is searched by
 starting with the top method or block context and moving down.

 Returns receiver if found, nil if not found ."

<primitive: 375>
self _primitiveFailed: #remove

]

{ #category : 'Accessing' }
GsExceptionHandler >> block [

"Returns the value of the instance variable 'theBlock'."

^ theBlock

]

{ #category : 'Accessing' }
GsExceptionHandler >> category [

^ GemStoneError

]

{ #category : 'Accessing' }
GsExceptionHandler >> exceptionClass [
  ^ exClass

]

{ #category : 'Accessing' }
GsExceptionHandler >> isLegacy [
  ^ exClass == nil

]

{ #category : 'Accessing' }
GsExceptionHandler >> next [

"Returns the next exception to be invoked (the value of the next instance
 variable)."

^next

]

{ #category : 'Accessing' }
GsExceptionHandler >> number [

"Returns the value of the instance variable 'number'."

^number

]

{ #category : 'Management' }
GsExceptionHandler >> remove [
"Search the current GemStone Smalltalk call stack for a frame
 that has the receiver installed, and remove it if found.
 If not found on the stack, search the list of static handlers and
 remove it if found.

 Returns receiver if found, nil if not found ."

  ^ self _remove ifNil:[ AbstractException removeStaticException: self ]

]

{ #category : 'Accessing' }
GsExceptionHandler >> subtype [

"Returns the value of the receiver's subtype instance variable."

^subtype

]
