Extension { #name : 'IdentityBag' }

{ #category : 'Private' }
IdentityBag class >> _clearEnumCache [

"Remove all entries from the enumeration cache"

<primitive: 547>
self _primitiveFailed: #_clearEnumCache .
self _uncontinuableError

]

{ #category : 'Modifying Classes' }
IdentityBag class >> isModifiable [

"Returns true if the receiver and its Array of named instance variables are
 modifiable."

^ (self isInvariant or:[ instVarNames isInvariant] ) not

]

{ #category : 'Instance Creation' }
IdentityBag class >> new: anInteger [

"Returns an instance of the receiver with sufficient space to hold
 approximately anInteger number of elements. "

 <primitive: 41>
 self _primitiveFailed: #new: args: { anInteger } .
 self _uncontinuableError
]

{ #category : 'Adding' }
IdentityBag >> _add: anObject withOccurrences: aSmallInteger forReplay: aBoolean [

"Adds anObject as an element of the receiver aSmallInteger number of times.

 Has no effect if anObject is nil."

<primitive: 549>
aSmallInteger _validateClass: SmallInteger .
aBoolean _validateClass: Boolean .
self _primitiveFailed: #add:withOccurrences:forReplay:
     args: { anObject . aSmallInteger } .
self _uncontinuableError

]

{ #category : 'Adding' }
IdentityBag >> _addAll: aCollection forReplay: aBoolean [

"Adds all of the elements of aCollection to the receiver.  Occurrences
 of nil in aCollection are not added to the receiver.

 The primitive code handles aCollection if it is a kind of
 Array, OrderedCollection or IdentityBag, without faulting in elements of aCollection.
 Otherwise the accompaniedBy:do: implementation in this method is executed."

<primitive: 225>
(self == aCollection) ifTrue: [ ^ self addAll: (aCollection copy) ].
aBoolean _validateClass: Boolean .
aCollection _validateClass: Collection.
aCollection accompaniedBy: self do: [:me :each | me add: each].
^ aCollection

]

{ #category : 'Adding' }
IdentityBag >> _addForReplay: newObject [

"Adds newObject to the receiver.  Has no effect if newObject is nil.
 Returns newObject. "

<primitive: 1044>
self _primitiveFailed: #'_addForReplay:' args: { newObject } .
self _uncontinuableError

]

{ #category : 'Adding' }
IdentityBag >> _addIfAbsent: anObject [

"Adds anObject to the receiver.
 Returns true if anObject added, false if it was already present in receiver.
 If newObject is nil has no effect, and returns false."

<primitive: 804>
self _primitiveFailed: #_addIfAbsent: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Private' }
IdentityBag >> _asIdentityBag [
	"Returns the receiver."

	^ self
]

{ #category : 'Accessing' }
IdentityBag >> _at: anInteger [

"Private.  Functionally equivalent to 'at:'."

"Used to implement the 'do:' method, which cannot be implemented as a
 primitive itself, since blocks cannot be sent as arguments to primitives."

<primitive: 64>
(anInteger _isInteger)
ifTrue: [ ^ self _error: #objErrBadOffsetIncomplete args: { anInteger } ]
ifFalse: [ ^ self _errorNonIntegerIndex: anInteger ].
self _primitiveFailed: #_at: args: { anInteger } .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
IdentityBag >> _checkForRcIndexesBeforeRcSelectiveAbort [
"_selectiveAbort may not be performed if there are indexes on the receiver and those indexes
 themselves are not RC."

  _indexedPaths ifNotNil:[ 
    _indexedPaths _allIndexesAreRc
    ifFalse:[ self _error: #rtErrSelectiveAbort with: 'collection has indexes' ].
  ]
]

{ #category : 'Searching' }
IdentityBag >> _indexOf: anElement [

"Returns the numerical index into the receiver of the given element (or nil if
 the element cannot be found)."

"Uses _at: to do the search and matches on equality."

1 to: self size do: [ :each |
  (self _at: each) = anElement ifTrue: [ ^each ]
  ].
^nil

]

{ #category : 'Testing' }
IdentityBag >> _isIdentityBag [

"Return whether the receiver is an identity-based collection."

^ true

]

{ #category : 'Searching' }
IdentityBag >> _offsetOf: anObject [

"Returns the first SmallInteger offset such that
 (self _at: (self _offSetOf: anObject)) == anObject.

 If the argument is not in the receiver, returns 0.  The result of this method
 is only valid while no insertions or deletions are made to the IdentityBag."

"Implemented with sequential scan of the receiver."

<primitive: 62>
self _primitiveFailed: #_offsetOf: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Set Arithmetic' }
IdentityBag >> _primDifference: aBagOrSet [

""

<primitive: 223>
aBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #_primDifference: args: { aBagOrSet } .
self _uncontinuableError

]

{ #category : 'Set Arithmetic' }
IdentityBag >> _primIntersect: aBagOrSet [

<primitive: 222>
aBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #_primIntersect: args: { aBagOrSet } .
self _uncontinuableError

]

{ #category : 'Updating' }
IdentityBag >> _primitiveAt: anIndex put: anObject [

"Disallowed.  Generates an error, since the elements of an IdentityBag are not
 externally accessible through numeric indices."

^ self _errorNotIndexable

]

{ #category : 'Set Arithmetic' }
IdentityBag >> _primUnion: aBagOrSet [

""

<primitive: 221 >
aBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #_primUnion: args: { aBagOrSet } .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
IdentityBag >> _rcDifference: aBag [

"Returns the set arithmetic difference between the receiver and aBag.  Also
 places the root object and interior nodes that are accessed in the
 reduced-conflict read set (RcReadSet) for both the receiver and aBag."

<primitive: 224>
aBag _validateClass: IdentityBag.
self _primitiveFailed: #_rcDifference: args: { aBag } .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
IdentityBag >> _rcOccurrencesOf: anObject [

"Returns the number of occurrences of anObject in the receiver.  Places the
 root of the receiver and any interior nodes that are accessed in the
 reduced-conflict read set(RcReadSet) ."

<primitive: 68>
self _primitiveFailed: #_rcOccurrencesOf: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Removing' }
IdentityBag >> _remove: anObject [

"Removes anObject from the receiver and returns anObject.  If anObject is
 present several times in the receiver, only one occurrence is removed.
 Generates an error if anObject is not in the receiver."

"Needed by certain subclasses where the super remove: message picks up an
 undesired reimplementation."

<primitive: 207>  "primitive fails if anObject not found"
^ self _errorNotFound: anObject

]

{ #category : 'Private' }
IdentityBag >> _removeAll: aCollection errIfAbsent: aBool forReplay: replayBool [
  ^ self _removeAll: aCollection errIfAbsent: aBool forReplay: replayBool rc: false 
]

{ #category : 'Private' }
IdentityBag >> _removeAll: aCollection errIfAbsent: aBool forReplay: replayBool rc: rcBool [

"For each element in aCollection, removes the one element that is identical
 from the receiver.  Returns aCollection if successful.

 The primitive includes an optimization
 for the case    where aCollection == self ."

<primitive: 226>

aBool _validateClass: Boolean .
replayBool _validateClass: Boolean .
rcBool _validateClass: Boolean .

(aCollection _isArray)
  ifFalse: [
    self _removeAll: (aCollection asArray) errIfAbsent: aBool forReplay: replayBool rc: rcBool.
    ^ aCollection
    ].

(aCollection isKindOf: CharacterCollection) ifTrue:[
  replayBool ifTrue:[ Error signal:'replay not supported' ].
  rcBool ifTrue:[
    aBool ifTrue:[ Error signal:'errIfAbsent not supported for rc remove'].
    1 to: aCollection size do:[:j| self _rcRemove: (aCollection _at: j) ].
  ] ifFalse:[
   aBool
    ifTrue:[
      1 to: aCollection size do:[:j| self remove: (aCollection _at: j) ].
    ] ifFalse:[
      1 to: aCollection size do:[:j| self remove: (aCollection _at: j) otherwise: nil ].
    ].
  ^ aCollection
  ].
 ].

aCollection _validateClass: Collection .
self _primitiveFailed: #_removeAll:errIfAbsent:forReplay:
       args: { aCollection . aBool . replayBool} .
self _uncontinuableError

]

{ #category : 'Removing' }
IdentityBag >> _removeForReplay: anObject [

<primitive: 1037>  "returns true if successful, false if object not found"

]

{ #category : 'Private' }
IdentityBag >> _removeFromEnumCache [

"Explicitly remove the receiver from the enumeration cache ,
 to facilitate garbage collection of temporary IdentityBags.

 Enumeration of the last element of an IdentityBag will
 automatically remove the receiver from the enumeration cache, so this
 method would be of use only if enumeration was terminated before
 reaching the end of an IdentityBag."

<primitive: 548>
self _primitiveFailed: #_removeFromEnumCache .
self _uncontinuableError

]

{ #category : 'Reduced Conflict Support' }
IdentityBag >> _selectiveAbort [

"Performs an abort operation on the receiver. That is, if the object is
 committed, it removes any changes made by the current transaction and allows
 access to the committed state of the object.  This is not allowed if the object
 participates in an index."

  _indexedPaths ~~ nil ifTrue:[
    self _checkForRcIndexesBeforeRcSelectiveAbort.
  ].
^ super _selectiveAbort

]

{ #category : 'Set Arithmetic' }
IdentityBag >> _union: aBag [

"Union with minimal result.
 An object must be present in either the receiver or the argument in order
 to appear in the result.
 For each object in the result the number of occurrances in the result
 is the maximum of the number of occurrances in the receiver or argument.

 aBag must be a kind of IdentityBag."

<primitive: 1043>

aBag _validateClass: IdentityBag.
self _primitiveFailed: #_union: args: { aBag } .
self _uncontinuableError

]

{ #category : 'Set Arithmetic' }
IdentityBag >> - aBagOrSet [

"Difference.  Returns a kind of IdentityBag containing exactly those elements of
 the receiver that have a greater number of occurrences in the receiver than in
 the argument aBagOrSet.  If an element occurs m times in the receiver and n
 times in aBagOrSet (where m >= n), then the result will contain m - n
 occurrences of that element.

 The class of the result is the class of the receiver."

^ (aBagOrSet _isRcIdentityBag or: [ aBagOrSet _isIdentityBag not ])
  ifTrue: [ self _primDifference: aBagOrSet _asIdentityBag ]
  ifFalse: [ self _primDifference: aBagOrSet ]

]

{ #category : 'Set Arithmetic' }
IdentityBag >> * aBagOrSet [

"Intersection.  Returns a kind of IdentityBag containing only the elements that
 are present in both the receiver and the argument aBagOrSet.

 The class of the result is the lowest class in the hierarchy of which both the
 receiver and argument are some kind.

 If the result is a kind of Set, then each element that occurs in both the
 receiver and aBagOrSet occurs exactly once in the result.  If the result is a
 IdentityBag that is not an IdentitySet, and if an element occurs m times in the
 receiver and n times in the argument aBagOrSet, then the result contains the
 lesser of m or n occurrences of that element."

^ (aBagOrSet _isRcIdentityBag or: [ aBagOrSet _isIdentityBag not ])
  ifTrue: [ self _primIntersect: aBagOrSet _asIdentityBag ]
  ifFalse: [ self _primIntersect: aBagOrSet ]

]

{ #category : 'Set Arithmetic' }
IdentityBag >> + aBagOrSet [

"Union.  Returns a kind of IdentityBag containing exactly the elements that are
 present in either the receiver or the argument aBagOrSet.

 The class of the result is the lowest class in the hierarchy of which both the
 receiver and argument are some kind.

 If the result is a kind of IdentitySet, then each element that occurs in either
 the receiver or aBagOrSet occurs exactly once in the result.  If the result is
 an IdentityBag that is not an IdentitySet, and if an element occurs m times in
 the receiver and n times in the argument aBagOrSet, then the result contains
 m + n occurrences of that element."

^ (aBagOrSet _isRcIdentityBag or: [ aBagOrSet _isIdentityBag not ])
  ifTrue: [ self _primUnion: aBagOrSet _asIdentityBag ]
  ifFalse: [ self _primUnion: aBagOrSet ]

]

{ #category : 'Comparing' }
IdentityBag >> = aBag [

"Returns true if all of the following conditions are true:

 1.  The receiver and aBag are of the same class.
 2.  The two collections are of the same size.

 3.  Their public named instance variables are identical.
 4.  The elements of the receiver and aBag are identical.
 5.  Each element occurs the same number of times in the receiver and in aBag.

 Returns false otherwise."

<primitive: 600>
self _primitiveFailed: #= args: { aBag } .
^false

]

{ #category : 'Adding' }
IdentityBag >> add: newObject [

"Adds newObject to the receiver.  Has no effect if newObject is nil.
 Returns newObject. "

<primitive: 208>  "ObsoleteDictionary >> _basicAdd: is also prim 208"
self _primitiveFailed: #add: args: { newObject } .
self _uncontinuableError

]

{ #category : 'Adding' }
IdentityBag >> add: anObject withOccurrences: aSmallInteger [

"Adds anObject as an element of the receiver aSmallInteger number of times.

 Has no effect if anObject is nil."

  ^ self _add: anObject withOccurrences: aSmallInteger forReplay: false
]

{ #category : 'Private' }
IdentityBag >> _rcAdd: anObject withOccurrences: aSmallInteger [

"Adds anObject as an element of the receiver aSmallInteger number of times,
 adding root node and modified nodes of the receiver to the RcReadSet.

 Has no effect if anObject is nil."

<primitive: 44>
self _primitiveFailed: #_rcAdd: args: { anObject . aSmallInteger }.
self _uncontinuableError
]

{ #category : 'Adding' }
IdentityBag >> addAll: aCollection [

"Adds all of the elements of aCollection to the receiver."

^ aCollection _isRcIdentityBag
  ifTrue: [ super addAll: aCollection ]
  ifFalse: [ self _addAll: aCollection forReplay: false ]

]

{ #category : 'Converting' }
IdentityBag >> asArray [

"Returns a new Array containing all elements of the receiver."
| a |
a := Array new .
a _addAllFromNsc: self .
^ a

]

{ #category : 'Accessing' }
IdentityBag >> at: anIndex [

"Returns the element of the receiver that is currently located at position
 anIndex.

 The elements of an IdentityBag are inherently unordered, and can change
 position (index) when the IdentityBag is altered.  Thus, after an IdentityBag
 is altered, a given element may reside at a different index than before, and a
 given index may house a different element.  You should not infer an ordering
 for an IdentityBag's elements when you access them by index.

 This method is useful primarily as a code optimizer for iterating over all the
 elements of an IdentityBag (using a loop that runs the index from 1 to
 the size of the IdentityBag).

 The IdentityBag must not change during the iteration.  But the iteration may
 run faster than it would if you use other alternatives such as the do:
 method."

<primitive: 64>
(anIndex _isInteger)
   ifTrue: [ ^ self _error: #objErrBadOffsetIncomplete args: { anIndex } ]
ifFalse: [ ^ self _errorNonIntegerIndex: anIndex ].
self _primitiveFailed: #at: args: { anIndex } .
self _uncontinuableError

]

{ #category : 'Updating' }
IdentityBag >> at: anIndex put: anObject [

"Disallowed.  Generates an error, since the elements of an IdentityBag are not
 externally accessible through numeric indices."

^ self _errorNotIndexable

]

{ #category : 'Searching' }
IdentityBag >> collect: aBlock [

"Evaluates aBlock with each of the receiver's elements as the argument.
 Collects the resulting values into a collection of class specified by
 sending #speciesForCollect message to the receiver and returns the new
 collection.  The argument aBlock must be a one-argument block."

| result mySize |

result:= self speciesForCollect new.
mySize := self size.
1 to: mySize do: [ :i | result add: (aBlock value:(self _at:i)) ].
^ result

]

{ #category : 'Deprecated' }
IdentityBag >> copyFrom: index1 count: aCount into: aColl startingAt: destIndex [

"Deprecated, non-ANSI.
 Copies elements of the receiver from (receiver at: index1)
  to (receiver at: (index1 + aCount - 1)), inclusive
 into aColl starting at destIndex, overwriting the previous contents.

 If (index1 + aCount - 1) is beyond the end of the receiver, then
 the copy will stop with the element  (receiver at: (receiver size)) .

 aColl must be a kind of Array or OrderedCollection .
 Returns the number of elements copied."

 | count |
  self deprecated: 'IdentityBag >> copyFrom:count:into:startingAt: deprecated v3.0' .
  count :=  aCount min: ( self size - index1 + 1) .
  aColl replaceFrom: destIndex to: destIndex + count - 1
	  with: self startingAt: index1 .
  ^ count


]

{ #category : 'Deprecated' }
IdentityBag >> copyFrom: index1 to: index2 into: aColl startingAt: destIndex [

"Deprecated, non-ANSI.
 Copies the elements of the receiver from (receiver at: index1)
  to (receiver at: index2), inclusive,
 into aColl starting at destIndex, overwriting the previous contents.
 aColl must be a kind of Array or OrderedCollection .
 Returns the receiver. "

 self deprecated: 'IdentityBag >> copyFrom:to:into:startingAt: deprecated v3.0' .
 aColl replaceFrom: destIndex to: destIndex + (index2 - index1)
	with: self startingAt: index1 .
 ^ self

]

{ #category : 'Enumerating' }
IdentityBag >> do: aBlock [

"Evaluates aBlock with each of the receiver's elements as the argument.
 The argument aBlock must be a one-argument block."

| theSize |
theSize := self size.
1 to: theSize do: [:i | aBlock value: (self _at: i) ].
^ self

]

{ #category : 'Repository Conversion' }
IdentityBag >> fixReferencesInFirstPass [

"Return whether this object should have references to Float, SmallFloat,
 LargeInteger  fixed in the first pass.
 false means fix them in the 2nd pass.  IdentityBag objects can be part
 of an RcIdentityBag, so we do those later"

^self class ~~ IdentityBag

]

{ #category : 'Comparing' }
IdentityBag >> hash [

"Returns an Integer hash code for the receiver."

| mySize |
(mySize := self size) = 0
  ifTrue: [ ^12794 ]
  ifFalse: [
    ^(((self _at: 1) identityHash bitShift: -1)
      bitXor: (self _at: mySize) identityHash)
        bitXor: mySize
  ]

]

{ #category : 'Searching' }
IdentityBag >> includes: anObject [

"Returns true if the argument anObject is an element of the receiver.
 Returns false otherwise.  (Compare with includesValue:, which is based
 on equality.)"

<primitive: 65>
self _primitiveFailed: #includes: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Searching' }
IdentityBag >> includesIdentical: anObject [

"Returns true if the argument anObject is an element of the receiver.
 Returns false otherwise.  (Compare with includesValue:, which is based
 on equality.)"

<primitive: 65>
self _primitiveFailed: #includes: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Searching' }
IdentityBag >> includesValue: anObject [

"Returns true if the receiver contains an object of the same value as the
 argument, anObject.  Returns false otherwise.  (Compare with includes:,
 which is based on identity.)"

1 to: self size do: [ :each |
  (anObject = (self _at: each)) ifTrue: [ ^true ]
].
^ false

]

{ #category : 'Set Arithmetic' }
IdentityBag >> intersect: aBagOrSet into: anotherBagOrSet [

"April 5, 2000 Norm Green - Created for OOCL
Same as the * method, except the result of the intersection
is put into anotherBagOrSet"

<primitive: 533>
aBagOrSet _validateClass: IdentityBag.
anotherBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #intersect:into: args: { aBagOrSet . anotherBagOrSet } .
self _uncontinuableError

]

{ #category : 'Set Arithmetic' }
IdentityBag >> intersectAll: anArrayOfSetsOrBags into: aBagOrSet [

"April 5, 2000 Norm Green - Created for OOCL

Starts by sorting by ascending size anArrayOfSetsOrBags.  The intersect the first
element with the receiver.  Take that result and intersect it with the second element.
Continue to all intersections are completed and place the result set into aBagOrSet.
Returns aBagOrSet.  If the array is empty, aBagOrSet will be a copy of the receiver.

This method will fail if any of the following is true:
 -the array size is greater than 2031.
 -any element of the array is not an IdentitySet or IdentityBag.
 -any element of the array is empty.
 -aBagOrSet is not an IdentityBag or IdentitySet"

<primitive: 532>
anArrayOfSetsOrBags _validateClass: Array.
aBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #intersectAll:into:
     args: { anArrayOfSetsOrBags . aBagOrSet } .
self _uncontinuableError

]

{ #category : 'Searching' }
IdentityBag >> occurrencesOf: anObject [

"Returns the number of the receiver's elements that are identical (==) to
 anObject."

<primitive: 67>
self _primitiveFailed: #occurrencesOf: args: { anObject } .
self _uncontinuableError

]

{ #category : 'Removing' }
IdentityBag >> remove: anObject [

"Removes anObject from the receiver and returns anObject.  If anObject is
 present several times in the receiver, only one occurrence is removed.
 Generates an error if anObject is not in the receiver."

<primitive: 207>  "primitive fails if anObject not found"
^ self _errorNotFound: anObject
]

{ #category : 'Removing' }
IdentityBag >> _rcRemove: anObject [

"Removes anObject from the receiver and returns anObject.  If anObject is
 present several times in the receiver, only one occurrence is removed.
 Generates an error if anObject is not in the receiver.
 Adds root node and any modified nodes to the RcReadSet. "

<primitive: 60>  "primitive fails if anObject not found"
^ self _errorNotFound: anObject
]


{ #category : 'Removing' }
IdentityBag >> remove: anObject ifAbsent: exceptionBlock [

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject is not present in
 the receiver, evaluates anExceptionBlock and returns the result of the
 evaluation."

<primitive: 209>  "primitive fails if anObject not found"
^ exceptionBlock value

]

{ #category : 'Removing' }
IdentityBag >> remove: anObject otherwise: notFoundValue [

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject is not present in
 the receiver, returns notFoundValue."

<primitive: 209>  "primitive fails if anObject not found"
^ notFoundValue

]

{ #category : 'Removing' }
IdentityBag >> removeAll: aCollection [

"Removes one occurrence of each element of aCollection from the
 receiver and returns the receiver.  Generates an error if any
 element of aCollection is not present in the receiver.

 The primitive _removeAll:errIfAbsent: includes an optimization
 for the case    where aCollection == self ."

^ aCollection _isRcIdentityBag
  ifTrue: [ self _removeAll: aCollection _asIdentityBag errIfAbsent: true forReplay: false ]
  ifFalse: [ self _removeAll: aCollection errIfAbsent: true forReplay: false ]

]

{ #category : 'Removing' }
IdentityBag >> removeAllPresent: aCollection [

"Removes from the receiver one occurrence of each element of aCollection that is
 also an element of the receiver.  Differs from removeAll: in that, if some
 elements of aCollection are not present in the receiver, no error is generated.
 Returns aCollection."

aCollection _isRcIdentityBag
  ifTrue: [ self _removeAll: aCollection _asIdentityBag errIfAbsent: false forReplay: false ]
  ifFalse: [ self _removeAll: aCollection errIfAbsent: false forReplay: false ].
^aCollection

]

{ #category : 'Removing' }
IdentityBag >> removeIdentical: anObject [

"Removes anObject from the receiver and returns anObject.  If anObject is
 present several times in the receiver, only one occurrence is removed.
 Generates an error if anObject is not in the receiver."

^ self remove: anObject

]

{ #category : 'Removing' }
IdentityBag >> removeIdentical: anObject ifAbsent: exceptionBlock [

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject is not present in
 the receiver, evaluates anExceptionBlock and returns the result of the
 evaluation."

<primitive: 209>  "primitive fails if anObject not found"
^ exceptionBlock value

]

{ #category : 'Removing' }
IdentityBag >> removeIdentical: anObject otherwise: notFoundValue [

"Removes from the receiver an object that is identical to anObject and
 returns anObject.  If several elements of the receiver are identical to
 anObject, only one instance is removed.  If anObject is not present in
 the receiver, returns notFoundValue."

<primitive: 209>  "primitive fails if anObject not found"
^ notFoundValue

]

{ #category : 'Removing' }
IdentityBag >> removeIfPresent: anObject [

"Removes anObject from the receiver and returns anObject.  If anObject is
 present several times in the receiver, only one occurrence is removed.
 Returns nil if anObject is missing from the receiver."

<primitive: 207>  "primitive fails if anObject not found"
^nil

]

{ #category : 'Set Arithmetic' }
IdentityBag >> sizeOfIntersectionWith: aBagOrSet [

"April 5, 2000 Norm Green - Created for OOCL
Perform the intersection and return only the size of the result set"
<primitive: 531>
aBagOrSet _validateClass: IdentityBag.
self _primitiveFailed: #sizeOfIntersectionWith: args: { aBagOrSet } .
self _uncontinuableError

]

{ #category : 'Set Arithmetic' }
IdentityBag >> sizeOfIntersectionWithAll: anArrayOfBagsOrSets [

"April 7, 2000 Norm Green - Created for OOCL
Starts by sorting by ascending size anArrayOfSetsOrBags.  The intersect the first
element with the receiver.  Take that result and intersect it with the second element.
Continue to all intersections are completed. Return the size of the resultant set.
If the array is empty, return the size of the receiver.

This method will fail if any of the following is true:
 -the array size is greater than 2031.
 -any element of the array is not an IdentitySet or IdentityBag.
 -any element of the array is empty.

All intermediate objects are disposed (no garbage is created)"

<primitive: 534>
anArrayOfBagsOrSets _validateClass: Array.
self _primitiveFailed: #sizeOfIntersectionWithAll:
     args: { anArrayOfBagsOrSets } .
self _uncontinuableError

]
